/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.dmm;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.Vsh;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.TFTP;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.model.EnclosureBase;
import com.cisco.dcbu.sm.common.model.EndPortBase;
import com.cisco.dcbu.sm.common.model.FabricBase;
import com.cisco.dcbu.sm.common.model.VsanBase;
import com.cisco.dcbu.sm.common.model.ZoneBase;
import com.cisco.dcbu.sm.common.model.ZoneMemberBase;
import com.cisco.dcbu.sm.common.model.ddm.DDMDppVi;
import com.cisco.dcbu.sm.common.model.ddm.DDMJob;
import com.cisco.dcbu.sm.common.model.ddm.DDMLun;
import com.cisco.dcbu.sm.common.model.ddm.DDMLunITL;
import com.cisco.dcbu.sm.common.model.ddm.DDMSession;
import com.cisco.dcbu.sm.common.model.ddm.DDMSwitch;
import com.cisco.dcbu.sm.common.rif.DMMException;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.VsanPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.dmm.CommandHelper;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmFcPortInfo;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobAdditionalPeerAttr;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobEstTimeCompAttr;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobEventLogAttr;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobIdAttr;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobInfo;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobNameAttr;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobRateAttr;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobSchedAttr;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobSessionInfo;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobSessionLunAttr;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobSessionLunInfo;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobSessionProgressAttr;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobSessionStorageAttr;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobSsmAttr;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobStatusAttr;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobStorageServerAttr;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobTypeAttr;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmViAttr;
import com.cisco.dcbu.sm.server.model.EnclosureImpl;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.model.VsanImpl;
import com.cisco.dcbu.sm.server.zone.ZoneService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class DMMHelper {
    private static DMMHelper _Helper = null;
    private Logger _logger = LogManager.getLogger((String)"dmm");

    public static DMMHelper getInstance() {
        if (_Helper == null) {
            _Helper = new DMMHelper();
        }
        return _Helper;
    }

    public EndPortBase getEndPortByWwn(Wwn wwn, FabricPK pk) {
        SanManager sanMan = SanManager.getInstance();
        EndPortImpl ePort = sanMan.findEndPort(wwn, pk);
        if (ePort == null) {
            EndPortBase ep = new EndPortBase(new WwnKey(wwn), wwn, null, null);
            return ep;
        }
        return (EndPortBase)ePort.getBaseObject();
    }

    public List<EndPortBase> getEndPort(EndPortBase[] epBase, FabricPK fabricPK) {
        ArrayList<EndPortBase> ret = new ArrayList<EndPortBase>();
        for (int i = 0; i < epBase.length; ++i) {
            if (epBase[i] == null || !epBase[i].getFabricPK().equals(fabricPK)) continue;
            ret.add(epBase[i]);
        }
        return ret;
    }

    public EndPortBase getEndPort(EndPortBase[] epBase, FabricPK fabricPK, List<Integer> vsanId) {
        for (int i = 0; i < epBase.length; ++i) {
            if (epBase[i] == null || !epBase[i].getFabricPK().equals(fabricPK) || !vsanId.contains(new Integer(epBase[i].getVsan()))) continue;
            return epBase[i];
        }
        return null;
    }

    public EndPortBase[] getEndPorts(EnclosureBase encl, FabricPK fabricPK) {
        SanManager sanMan = SanManager.getInstance();
        ArrayList<EndPortBase> ports = new ArrayList<EndPortBase>();
        List<WwnKey> pkList = encl.getEndPortPKs();
        for (int i = 0; i < pkList.size(); ++i) {
            EndPortBase base;
            WwnKey key = pkList.get(i);
            EndPortImpl port = sanMan.findEndPort(key, fabricPK);
            if (port == null || !(base = (EndPortBase)port.getBaseObject()).getFabricPK().equals(fabricPK)) continue;
            ports.add(base);
        }
        return ports.size() != 0 ? ports.toArray(new EndPortBase[ports.size()]) : new EndPortBase[]{};
    }

    public EndPortBase[] getEndPort(EnclosureBase encl, FabricPK fpk) {
        SanManager sanMan = SanManager.getInstance();
        ArrayList<EndPortBase> ports = new ArrayList<EndPortBase>();
        List<WwnKey> pkList = encl.getEndPortPKs();
        for (int i = 0; i < encl.getEndPortPKs().size(); ++i) {
            WwnKey key = pkList.get(i);
            EndPortImpl eImpl = sanMan.findEndPort(key, fpk);
            if (eImpl == null || eImpl.getFabric() == null) continue;
            ports.add((EndPortBase)sanMan.findEndPort(key, fpk).getBaseObject());
        }
        return ports.size() != 0 ? ports.toArray(new EndPortBase[ports.size()]) : new EndPortBase[]{};
    }

    public EndPortBase[] getEndPort(EnclosureBase encl, FabricPK[] pks) {
        ArrayList<FabricPK> allList = new ArrayList<FabricPK>();
        for (int i = 0; i < pks.length; ++i) {
            allList.add(pks[i]);
        }
        SanManager sanMan = SanManager.getInstance();
        ArrayList<EndPortBase> ports = new ArrayList<EndPortBase>();
        if (encl != null) {
            List<WwnKey> pkList = encl.getEndPortPKs();
            for (int i = 0; i < encl.getEndPortPKs().size(); ++i) {
                WwnKey key = pkList.get(i);
                for (int f = 0; f < pks.length; ++f) {
                    EndPortImpl eImpl = sanMan.findEndPort(key, pks[f]);
                    if (eImpl == null || eImpl.getFabric() == null) continue;
                    ports.add((EndPortBase)eImpl.getBaseObject());
                }
            }
        }
        return ports.size() != 0 ? ports.toArray(new EndPortBase[ports.size()]) : new EndPortBase[]{};
    }

    public boolean isStorageZoned(FabricImpl fabric, EnclosureImpl storage) {
        EnclosureBase storageBase = (EnclosureBase)storage.getBaseObject();
        VsanImpl[] allVsans = fabric.getVsans();
        for (int i = 0; i < allVsans.length; ++i) {
            ZoneBase[] zoneBases = allVsans[i].getEnforcedZones();
            if (zoneBases == null) continue;
            for (int j = 0; j < zoneBases.length; ++j) {
                if (!this.isEnclosureInZone(storageBase, zoneBases[j])) continue;
                return true;
            }
        }
        return false;
    }

    public ArrayList<EndPortBase> getEndPortsInZone(ArrayList<EndPortBase> ports, ZoneBase zoneBase) {
        Array members = zoneBase.getMembers();
        ArrayList<EndPortBase> retPorts = new ArrayList<EndPortBase>();
        if (members != null && members.getData() != null && members.size() > 0) {
            E[] allMembers = members.getData();
            for (int k = 0; k < members.size(); ++k) {
                ZoneMemberBase obj = (ZoneMemberBase)allMembers[k];
                if (obj.getType() != 1) {
                    this._logger.info((Object)("getEndPortsInZone: Skipping Zone member: " + obj + " type = " + obj.getTypeName()));
                    continue;
                }
                Wwn memWwn = new Wwn(obj.getId());
                for (EndPortBase port : ports) {
                    if (!memWwn.equals(port.getPortWwn())) continue;
                    retPorts.add(port);
                }
            }
        }
        return retPorts;
    }

    public boolean isEnclosureInZone(EnclosureBase encl, ZoneBase zoneBase) {
        Array members = zoneBase.getMembers();
        if (members != null && members.getData() != null && members.size() > 0) {
            E[] allMembers = members.getData();
            for (int k = 0; k < members.size(); ++k) {
                ZoneMemberBase obj = (ZoneMemberBase)allMembers[k];
                if (obj.getType() != 1) {
                    this._logger.info((Object)("Zone member: " + obj + " type = " + obj.getTypeName()));
                    this._logger.info((Object)("Enclosure " + encl + ": skipping isEnclosureInZone check for Zone member: " + obj));
                    continue;
                }
                if (!this.isEnclosureInZoneMember(encl, obj)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEnclosureInZone(EnclosureBase encl, ZoneBase zoneBase, VsanBase vsan, FabricBase fa) {
        Array members = zoneBase.getMembers();
        if (members != null && members.getData() != null && members.size() > 0) {
            E[] allMembers = members.getData();
            for (int k = 0; k < members.size(); ++k) {
                ZoneMemberBase obj = (ZoneMemberBase)allMembers[k];
                if (obj.getType() != 1) {
                    this._logger.info((Object)("Zone member: " + obj + " type = " + obj.getTypeName()));
                    this._logger.info((Object)("Enclosure " + encl + ": skipping isEnclosureInZone check for Zone member: " + obj));
                    continue;
                }
                if (!this.isEnclosureInZoneMember(encl, obj, vsan, fa)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEnclosureInZoneMember(EnclosureBase encl, ZoneMemberBase mem) {
        List<WwnKey> list = encl.getEndPortPKs();
        Iterator<WwnKey> iter = list.iterator();
        Wwn memWwn = new Wwn(mem.getId());
        while (iter.hasNext()) {
            WwnKey epKey = iter.next();
            if (!memWwn.equals(epKey._wwn)) continue;
            return true;
        }
        return false;
    }

    public boolean isEnclosureInZoneMember(EnclosureBase encl, ZoneMemberBase mem, VsanBase vsan, FabricBase fa) {
        List<WwnKey> list = encl.getEndPortPKs();
        switch (mem.getType()) {
            case 1: 
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                EndPortBase epb = ZoneService.getEndPort(mem.getType(), mem.getId(), vsan, fa);
                if (epb == null) break;
                Wwn epbWwn = epb.getPortWwn();
                for (WwnKey epKey : list) {
                    if (!epbWwn.equals(epKey._wwn)) continue;
                    return true;
                }
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                ArrayList endportList = ZoneService.getAttachedEndPorts(fa, mem.getType(), mem.getId(), vsan);
                if (endportList == null) break;
                for (int i = 0; i < endportList.size(); ++i) {
                    EndPortBase epb = (EndPortBase)endportList.get(i);
                    if (epb == null) continue;
                    Wwn epbWwn = epb.getPortWwn();
                    for (WwnKey epKey : list) {
                        if (!epbWwn.equals(epKey._wwn)) continue;
                        return true;
                    }
                }
                break;
            }
        }
        return false;
    }

    public boolean isEndPortInZone(EndPortBase ep, ZoneBase zoneBase) {
        Array members = zoneBase.getMembers();
        if (members != null && members.getData() != null && members.size() > 0) {
            E[] allMembers = members.getData();
            for (int k = 0; k < members.size(); ++k) {
                ZoneMemberBase obj = (ZoneMemberBase)allMembers[k];
                if (obj.getType() != 1) {
                    this._logger.info((Object)("isEndPortInZone: Skipping Zone member: " + obj + " type = " + obj.getTypeName()));
                    continue;
                }
                Wwn memWwn = new Wwn(obj.getId());
                WwnKey epKey = ep.getEndPortPK();
                if (!memWwn.equals(epKey._wwn)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEndPortInZone(WwnKey epKey, ZoneBase zoneBase) {
        Array members = zoneBase.getMembers();
        if (members != null && members.getData() != null && members.size() > 0) {
            E[] allMembers = members.getData();
            for (int k = 0; k < members.size(); ++k) {
                ZoneMemberBase obj = (ZoneMemberBase)allMembers[k];
                if (obj.getType() != 1) {
                    this._logger.info((Object)("isEndPortInZone: Skipping Zone member: " + obj + " type = " + obj.getTypeName()));
                    continue;
                }
                Wwn memWwn = new Wwn(obj.getId());
                if (!memWwn.equals(epKey._wwn)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean vsanIdsContainsVsan(VsanImpl nextVsan, List<Integer> vsanIds) {
        Short vsan = nextVsan.getId();
        for (Integer nextId : vsanIds) {
            if (nextId.shortValue() != vsan.shortValue()) continue;
            return true;
        }
        return false;
    }

    public ArrayList<EndPortBase> getHostTargetInSameZoneMember(FabricImpl fabric, ArrayList<EndPortBase> encPorts, EndPortBase[] storagePorts, List<Integer> vsanIds) {
        VsanImpl[] allVsans = fabric.getVsans();
        ArrayList<EndPortBase> ret = new ArrayList<EndPortBase>();
        for (int i = 0; i < allVsans.length; ++i) {
            ZoneBase[] zoneBases;
            VsanImpl nextVsan = allVsans[i];
            if (!this.vsanIdsContainsVsan(nextVsan, vsanIds) || (zoneBases = nextVsan.getEnforcedZones()) == null) continue;
            for (int j = 0; j < zoneBases.length; ++j) {
                for (int sp = 0; sp < storagePorts.length; ++sp) {
                    if (!this.isEndPortInZone(storagePorts[sp].getEndPortPK(), zoneBases[j])) continue;
                    ret.addAll(this.getEndPortsInZone(encPorts, zoneBases[j]));
                }
            }
        }
        return ret;
    }

    public static ArrayList<EndPortBase> createArray(EndPortBase[] ports) {
        ArrayList<EndPortBase> ret = new ArrayList<EndPortBase>();
        if (ports != null) {
            for (EndPortBase port : ports) {
                ret.add(port);
            }
        }
        return ret;
    }

    public static EndPortBase[] createArray(ArrayList<EndPortBase> ports) {
        if (ports != null) {
            EndPortBase[] ret = new EndPortBase[ports.size()];
            int index = 0;
            for (EndPortBase port : ports) {
                ret[index++] = port;
            }
            return ret;
        }
        return new EndPortBase[0];
    }

    public boolean isHostTargetInSameZoneMember(FabricImpl fabric, EnclosureBase port, EndPortBase[] storagePorts, List<Integer> vsanIds) {
        VsanImpl[] allVsans = fabric.getVsans();
        for (int i = 0; i < allVsans.length; ++i) {
            ZoneBase[] zoneBases;
            VsanImpl nextVsan = allVsans[i];
            if (!this.vsanIdsContainsVsan(nextVsan, vsanIds) || (zoneBases = nextVsan.getEnforcedZones()) == null) continue;
            for (int j = 0; j < zoneBases.length; ++j) {
                for (int sp = 0; sp < storagePorts.length; ++sp) {
                    if (!this.isEnclosureInZone(port, zoneBases[j]) || !this.isEndPortInZone(storagePorts[sp].getEndPortPK(), zoneBases[j])) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public int getVsanIfHostTargetInSameZoneMember(FabricImpl fabric, EndPortBase[] hostPorts, EndPortBase[] storagePorts, List<Integer> vsanIds) {
        for (int i = 0; i < hostPorts.length; ++i) {
            EndPortBase nextHost = hostPorts[i];
            for (int v = 0; v < vsanIds.size(); ++v) {
                VsanImpl nextVsan;
                ZoneBase[] zoneBases;
                VsanPK vsanPk = nextHost.getVsanPK(vsanIds.get(v));
                if (vsanPk == null || (zoneBases = (nextVsan = fabric.findVsan(vsanPk)).getEnforcedZones()) == null) continue;
                for (int j = 0; j < zoneBases.length; ++j) {
                    for (int sp = 0; sp < storagePorts.length; ++sp) {
                        if (!this.isEndPortInZone(nextHost, zoneBases[j]) || !this.isEndPortInZone(storagePorts[sp].getEndPortPK(), zoneBases[j])) continue;
                        return nextVsan.getId();
                    }
                }
            }
        }
        return -1;
    }

    public boolean isHostTargetInSameZoneMember(FabricImpl fabric, EnclosureBase port, EnclosureBase storageBase) {
        VsanImpl[] allVsans = fabric.getVsans();
        for (int i = 0; i < allVsans.length; ++i) {
            ZoneBase[] zoneBases = allVsans[i].getEnforcedZones();
            if (zoneBases == null) continue;
            for (int j = 0; j < zoneBases.length; ++j) {
                if (!this.isEnclosureInZone(port, zoneBases[j]) || !this.isEnclosureInZone(storageBase, zoneBases[j])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isHostTargetInSameZoneMember(FabricImpl fabric, EnclosureBase port, EnclosureBase storageBase, VsanBase vsan, FabricBase fa, ZoneBase[] zoneBases) {
        if (zoneBases != null) {
            for (int j = 0; j < zoneBases.length; ++j) {
                if (!this.isEnclosureInZone(port, zoneBases[j], vsan, fa) || !this.isEnclosureInZone(storageBase, zoneBases[j], vsan, fa)) continue;
                return true;
            }
        }
        return false;
    }

    public EndPortBase[] findTargetPortsInSameZone(EndPortBase hostPort, EnclosureBase encl) {
        SanManager sanMan = SanManager.getInstance();
        FabricImpl[] allFabrics = sanMan.getFabrics();
        ArrayList<EndPortBase> ret = new ArrayList<EndPortBase>();
        for (int k = 0; k < allFabrics.length; ++k) {
            VsanImpl[] allVsans = allFabrics[k].getVsans();
            for (int i = 0; i < allVsans.length; ++i) {
                ZoneBase[] zoneBases = allVsans[i].getEnforcedZones();
                if (zoneBases == null) continue;
                for (int j = 0; j < zoneBases.length; ++j) {
                    if (!this.isEndPortInZone(hostPort, zoneBases[j])) continue;
                    List<WwnKey> list = encl.getEndPortPKs();
                    for (WwnKey epKey : list) {
                        if (!this.isEndPortInZone(epKey, zoneBases[j])) continue;
                        EndPortImpl ep = sanMan.findEndPort(epKey, allFabrics[k].getPK());
                        ret.add((EndPortBase)ep.getBaseObject());
                    }
                }
            }
        }
        if (ret.size() > 0) {
            return ret.toArray(new EndPortBase[ret.size()]);
        }
        return new EndPortBase[0];
    }

    public DDMJob toDDMJob(DmmJobInfo jobInfo, DDMSwitch ssm) throws DMMException {
        FabricPK fpk = ssm.getFabric().getPK();
        DDMJob job = new DDMJob();
        Map map = (Map)jobInfo.getDetails().get(0);
        Object attrObj = map.get(new Integer(1));
        if (attrObj != null) {
            job.setId(((DmmJobIdAttr)attrObj).getJobId());
        }
        if ((attrObj = map.get(new Integer(2))) != null) {
            job.setName(((DmmJobNameAttr)attrObj).getJobName().trim());
        }
        if ((attrObj = map.get(new Integer(3))) != null) {
            job.setJobMode(((DmmJobTypeAttr)attrObj).getJobMode());
            job.setType(((DmmJobTypeAttr)attrObj).getJobType());
            byte method = ((DmmJobTypeAttr)attrObj).getJobMethod();
            if (method == -1) {
                job.setMethod((byte)-1);
            } else if (method == -35) {
                job.setMethod((byte)-35);
            } else {
                job.setMethod((byte)-18);
            }
        }
        if ((attrObj = map.get(new Integer(4))) != null) {
            job.setServerHosts(this.getEnclosure((DmmJobStorageServerAttr)attrObj, fpk));
        }
        if ((attrObj = map.get(new Integer(5))) != null) {
            job.setExsitingStorages(this.getEnclosure((DmmJobStorageServerAttr)attrObj, fpk));
        }
        if ((attrObj = map.get(new Integer(6))) != null) {
            job.setNewStorages(this.getEnclosure((DmmJobStorageServerAttr)attrObj, fpk));
        }
        if ((attrObj = map.get(new Integer(8))) != null) {
            job.setRate(((DmmJobRateAttr)attrObj).getRate());
        }
        if ((attrObj = map.get(new Integer(7))) != null) {
            DmmJobSsmAttr jobSsmAttr = (DmmJobSsmAttr)attrObj;
            Object attrObj2 = map.get(new Integer(13));
            int lengthAddPeers = 0;
            DmmJobAdditionalPeerAttr addPeerAttr = null;
            if (attrObj2 != null) {
                addPeerAttr = (DmmJobAdditionalPeerAttr)attrObj2;
                lengthAddPeers = 1;
            }
            int[] peerList = null;
            int ipAddrs = jobSsmAttr.getIpAddr();
            int peerIndex = 0;
            if (ipAddrs != 0) {
                peerList = new int[1 + lengthAddPeers];
                peerList[peerIndex++] = ipAddrs;
            } else {
                peerList = new int[lengthAddPeers];
            }
            if (addPeerAttr != null) {
                peerList[peerIndex] = addPeerAttr.getPeerSsmIp();
            }
            job.setPeerIps(peerList);
        }
        if ((attrObj = map.get(new Integer(11))) != null) {
            job.setLog(((DmmJobEventLogAttr)attrObj).getEventLog());
        }
        if ((attrObj = map.get(new Integer(9))) != null) {
            job.setStatus(((DmmJobStatusAttr)attrObj).getStatus());
            if (((DmmJobStatusAttr)attrObj).getDataMoverSsm() == 1) {
                job.setSSM1DataMoverSSM(true);
            } else {
                job.setSSM1DataMoverSSM(false);
            }
        }
        if ((attrObj = map.get(new Integer(12))) != null) {
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            DmmJobSchedAttr scheAttr = (DmmJobSchedAttr)attrObj;
            cal.set(scheAttr.getYear(), scheAttr.getMonth() - 1, scheAttr.getDay(), scheAttr.getHour(), scheAttr.getMinute(), 0);
            Calendar localCal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            localCal.setTimeInMillis(cal.getTimeInMillis());
            job.setScheduledStartingTime(localCal.getTime());
        }
        if (job.getStatus() == 1) {
            job.setScheduleAction((byte)1);
        }
        if ((attrObj = map.get(new Integer(14))) != null) {
            DmmJobEstTimeCompAttr estAttr = (DmmJobEstTimeCompAttr)attrObj;
            long seconds = estAttr.getEstTime();
            job.setEstimatedCompletionTimeInSeconds(seconds);
        }
        return job;
    }

    public DDMDppVi toDDMDppVi(DmmViAttr viAttr) throws DMMException {
        DDMDppVi vi = new DDMDppVi();
        int jobsOutstanding = viAttr.getNumOutstandingJobs();
        Wwn viNodeWWN = viAttr.getStgJobViNwwn();
        Wwn viPortWWN = viAttr.getStgJobViPwwn();
        EndPortBase ep = new EndPortBase(new WwnKey(viPortWWN), viNodeWWN, null, null);
        ep.setFc4Features(512);
        vi.setViPort(ep);
        vi.setNumberOfOutstandingJobs(jobsOutstanding);
        return vi;
    }

    public DDMSession toDDMSession(DmmJobSessionInfo jobInfo, DDMSwitch ssm) throws DMMException {
        Object attrObj4;
        Object attrObj3;
        Object attrObj1;
        FabricPK fpk = ssm.getFabric().getPK();
        DDMSession session = new DDMSession();
        session.setId(jobInfo.getJobSessionId());
        Map map = (Map)jobInfo.getDetails().get(0);
        Object attrObj = map.get(new Integer(1));
        if (attrObj != null) {
            DmmJobSessionStorageAttr storeAttr = (DmmJobSessionStorageAttr)attrObj;
            session.setExistingPort(this.getEndPortBase(storeAttr, fpk));
        }
        if ((attrObj1 = map.get(new Integer(2))) != null) {
            DmmJobSessionStorageAttr storeAttr = (DmmJobSessionStorageAttr)attrObj1;
            session.setNewPort(this.getEndPortBase(storeAttr, fpk));
        }
        EndPortBase server = null;
        Object attrObj2 = map.get(new Integer(3));
        if (attrObj2 != null) {
            DmmJobSessionStorageAttr storeAttr = (DmmJobSessionStorageAttr)attrObj2;
            server = this.getEndPortBase(storeAttr, fpk);
            session.setHost(server);
        }
        if ((attrObj3 = map.get(new Integer(5))) != null) {
            DmmJobSessionProgressAttr progressAttr = (DmmJobSessionProgressAttr)attrObj3;
            session.setProgress((byte)progressAttr.getLastLbaMoved());
            session.setStatus(progressAttr.getStatus());
            session.setVerifyStatus(progressAttr.getVerifySts());
            session.setLastLbaMoved(progressAttr.getLastLbaMoved());
            session.setLastLbaVerified(progressAttr.getLastLbaVerified());
            session.setAvgMbPerSec(progressAttr.getAvgMbPerSec());
        }
        if ((attrObj4 = map.get(new Integer(4))) != null) {
            DmmJobSessionLunAttr lunAttr = (DmmJobSessionLunAttr)attrObj4;
            session.setExistingLuns(this.getLunInfo(session, server, lunAttr, lunAttr.getEsLun()));
            session.setNewLuns(this.getLunInfo(session, server, lunAttr, lunAttr.getNsLun()));
            session.setMaxLba(lunAttr.getEsLun().getMaxLba());
            session.setBlkLen(lunAttr.getEsLun().getBlkLen());
        }
        return session;
    }

    private DDMLunITL getLunInfo(DDMSession session, EndPortBase server, DmmJobSessionLunAttr lunAttr, DmmJobSessionLunInfo esLun) {
        DDMLunITL eItl = new DDMLunITL();
        eItl.setInitator(server);
        eItl.setTaget(session.getExistingPort());
        DDMLun[] eLuns = new DDMLun[]{new DDMLun()};
        eLuns[0].setLunNumber(esLun.getLun());
        eLuns[0].setCapacity(lunAttr.getEsLun().getMaxLba() / 1024L * (long)lunAttr.getEsLun().getBlkLen());
        eItl.setLuns(eLuns);
        return eItl;
    }

    public EndPortBase getEndPortBase(DmmJobSessionStorageAttr attrObj, FabricPK fpk) {
        DmmFcPortInfo portInfo = attrObj.getFcPortInfo();
        EndPortImpl endport = SanManager.getInstance().findEndPort(portInfo.getPortWwn(), fpk);
        if (endport == null) {
            return new EndPortBase(new WwnKey(portInfo.getPortWwn()), portInfo.getNodeWwn(), null, null);
        }
        return (EndPortBase)endport.getBaseObject();
    }

    public EnclosureBase getEnclosure(DmmJobStorageServerAttr attrObj, FabricPK fpk) {
        EnclosureBase enclBase = null;
        List list = attrObj.getFcPortInfo();
        for (DmmFcPortInfo portInfo : list) {
            EndPortImpl endport = SanManager.getInstance().findEndPort(portInfo.getPortWwn(), fpk);
            if (endport == null || endport.getEnclosure() == null) {
                return null;
            }
            enclBase = (EnclosureBase)endport.getEnclosure().getBaseObject();
        }
        return enclBase;
    }

    public Map intersect(Map map1, Map map2) {
        HashMap ret = new HashMap();
        if (map1 != null && map2 != null) {
            for (Object obj : map1.keySet()) {
                if (map2.get(obj) == null) continue;
                ret.put(obj, obj);
            }
        }
        return ret;
    }

    public Map getVsans(EndPortBase[] ports, FabricPK fabricPK) {
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        for (int i = 0; i < ports.length; ++i) {
            short[] vsans;
            if (ports[i] == null || !ports[i].getFabricPK().equals(fabricPK) || (vsans = ports[i].getVsanMembership()) == null) continue;
            for (int j = 0; j < vsans.length; ++j) {
                Integer vsanId = new Integer(vsans[j]);
                ret.put(vsanId, vsanId);
            }
        }
        return ret;
    }

    public Map<Integer, Integer> getVsans(EnclosureBase encl, FabricPK fabricPK) {
        EndPortBase[] ports = DMMHelper.getInstance().getEndPort(encl, fabricPK);
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        for (int i = 0; i < ports.length; ++i) {
            short[] vsans;
            if (ports[i] == null || !ports[i].getFabricPK().equals(fabricPK) || (vsans = ports[i].getVsanMembership()) == null) continue;
            for (int j = 0; j < vsans.length; ++j) {
                Integer vsanId = new Integer(vsans[j]);
                ret.put(vsanId, vsanId);
            }
        }
        return ret;
    }

    public int findFirstCommonVsanId(EndPortBase[] es, EndPortBase[] server, FabricPK fabricPK) {
        Map serverHasItMap;
        Map esHasItMap;
        DMMHelper helper = DMMHelper.getInstance();
        Map ret = helper.intersect(esHasItMap = helper.getVsans(es, fabricPK), serverHasItMap = helper.getVsans(server, fabricPK));
        Iterator iter = ret.keySet().iterator();
        if (iter.hasNext()) {
            Integer value = (Integer)iter.next();
            return value;
        }
        return -1;
    }

    public int findCommonVsanId(EnclosureBase es, EnclosureBase server, FabricPK fabricPK) {
        Map<Integer, Integer> serverHasItMap;
        Map<Integer, Integer> esHasItMap;
        DMMHelper helper = DMMHelper.getInstance();
        Map ret = helper.intersect(esHasItMap = helper.getVsans(es, fabricPK), serverHasItMap = helper.getVsans(server, fabricPK));
        Iterator iter = ret.keySet().iterator();
        if (iter.hasNext()) {
            Integer value = (Integer)iter.next();
            return value;
        }
        return -1;
    }

    public Integer[] findCommonVsanMembership(EndPortBase[] encl1, EndPortBase[] encl2, FabricPK fpk) {
        Map map1 = null;
        if (encl1 != null) {
            map1 = this.getVsans(encl1, fpk);
        }
        Map map2 = null;
        if (encl2 != null) {
            map2 = this.getVsans(encl2, fpk);
        }
        Map map = null;
        map = encl1 == null ? map2 : (encl2 == null ? map1 : DMMHelper.getInstance().intersect(map1, map2));
        if (map == null) {
            return new Integer[0];
        }
        Set ret = map.keySet();
        return ret.size() != 0 ? ret.toArray(new Integer[ret.size()]) : new Integer[]{};
    }

    public Integer[] findCommonVsanMembership(EnclosureBase encl1, EnclosureBase encl2, FabricPK fpk) {
        Map<Integer, Integer> map1 = null;
        if (encl1 != null) {
            map1 = this.getVsans(encl1, fpk);
        }
        Map<Integer, Integer> map2 = null;
        if (encl2 != null) {
            map2 = this.getVsans(encl2, fpk);
        }
        Map<Integer, Integer> map = null;
        map = encl1 == null ? map2 : (encl2 == null ? map1 : DMMHelper.getInstance().intersect(map1, map2));
        if (map == null) {
            return null;
        }
        Set<Integer> ret = map.keySet();
        return ret.size() != 0 ? ret.toArray(new Integer[ret.size()]) : null;
    }

    public List<Integer> findCommonVsanId(EndPortBase[] es, EndPortBase[] ns, EndPortBase[] server, FabricPK fabricPK) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        DMMHelper helper = DMMHelper.getInstance();
        Map esHasItMap = helper.getVsans(es, fabricPK);
        Map nsHasItMap = helper.getVsans(ns, fabricPK);
        Map serverHasItMap = null;
        if (server != null && server.length > 0) {
            serverHasItMap = helper.getVsans(server, fabricPK);
        }
        Map inteMap = helper.intersect(esHasItMap, nsHasItMap);
        if (server != null && server.length > 0) {
            inteMap = helper.intersect(inteMap, serverHasItMap);
        }
        for (Integer value : inteMap.keySet()) {
            ret.add(value);
        }
        return ret;
    }

    public List<Integer> findCommonVsanIds(EndPortBase[] es, EndPortBase[] server, FabricPK fabricPK) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        DMMHelper helper = DMMHelper.getInstance();
        Map esHasItMap = helper.getVsans(es, fabricPK);
        Map serverHasItMap = null;
        Map inteMap = esHasItMap;
        if (server != null && server.length > 0) {
            serverHasItMap = helper.getVsans(server, fabricPK);
            inteMap = helper.intersect(esHasItMap, serverHasItMap);
        }
        for (Integer value : inteMap.keySet()) {
            ret.add(value);
        }
        return ret;
    }

    public void fillEndPort(DDMJob job, FabricPK[] pks) {
        if (job.getServerEndPorts() == null && job.getType() == -86) {
            job.setServerEndPorts(this.getEndPort(job.getServerHosts(), pks));
        }
        if (job.getExisitingStoragesEndPorts() == null) {
            job.setExisitingStoragesEndPorts(this.getEndPort(job.getExsitingStorages(), pks));
        }
        if (job.getNewStoragesEndPorts() == null) {
            job.setNewStoragesEndPorts(this.getEndPort(job.getNewStorages(), pks));
        }
    }

    public void getRemoteFile(SnmpPeer peer, String remoteAddr, String remotePath, String localAddr, String localPath, TFTP tftp) throws Exception {
        Vsh vsh = Vsh.get(null, peer, true);
        String cmd = "copy " + remotePath + " " + localPath + "\n";
        CommandHelper helper = new CommandHelper(vsh, cmd, tftp);
        new Thread(helper).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRemoteFileViaSftp(SnmpPeer peer, String remoteAddr, String remotePath, String localAddr, String localPath, String passwd) throws Exception {
        block10: {
            Vsh vsh = Vsh.get(null, peer, true);
            String currentPrompt = vsh.getPrompt();
            String cmd = "copy " + remotePath + " " + localPath + "\n";
            StringBuffer output = new StringBuffer();
            try {
                if (vsh == null) break block10;
                vsh.send("\n");
                vsh.readPrompt();
                vsh.send(cmd);
                vsh.expect(new String[]{"password:", "Password:", "(yes/no)?", currentPrompt}, output);
                if (output.indexOf("(yes/no)?") != -1) {
                    output.setLength(0);
                    vsh.send("yes\n");
                    vsh.expect(new String[]{"password:", "Password:", currentPrompt}, output);
                }
                if (output.toString().toLowerCase().indexOf("password:") != -1) {
                    output.setLength(0);
                    vsh.send(passwd + "\n");
                    vsh.expect(new String[]{"password:", "Password:", currentPrompt}, output);
                    if (output.toString().toLowerCase().indexOf("password:") != -1) {
                        throw new Exception("Incorrect Password");
                    }
                    if (output.indexOf("100%") != -1) {
                        output.setLength(0);
                        break block10;
                    }
                    throw new Exception("Remote copy failed. " + output);
                }
                throw new Exception("Remote copy failed. " + output);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
            finally {
                if (vsh != null) {
                    Vsh.put(vsh);
                }
            }
        }
    }

    public static String getSsmIpAddress(SnmpPeer peer, Card card, Map map) throws DMMException {
        String result = "";
        result = DMMHelper.getSsmIpAddressSlotId(peer, card.getSlotId(), map);
        if (result.equals("")) {
            SwitchImpl sw = SanManager.getInstance().findSwitchByIP(peer.getAddress());
            int supSlot = sw.getActiveSupSlot();
            if (card.getSlotId() == supSlot) {
                result = DMMHelper.getSsmIpAddressSlotId(peer, 32, map);
            }
        }
        return result;
    }

    public static String getSsmIpAddressPhysicalIndex(SnmpPeer peer, int cardPhyIndex, Map map) throws DMMException {
        String ret = "";
        VarBindList vbl = new VarBindList();
        SnmpOID root = new SnmpOID(MibNode.get("ciiIPIfAddressPrefixLength").getOid());
        int rootLength = root.getValue().length;
        try {
            vbl.add(new SnmpVarBind(root));
            SnmpPDU resp = SnmpFetch.next(peer, vbl);
            while (true) {
                VarBindList invbl = new VarBindList();
                invbl.add(new SnmpVarBind(resp.getOid(0)));
                resp = SnmpFetch.next(peer, invbl);
                if (resp.getOid(0).startsWith(root)) {
                    int[] lookupValue = resp.getOid(0).getValue();
                    int ifIndex = lookupValue[rootLength];
                    int vsan = ifIndex & 0xFFF;
                    if (vsan != 1 || 8 != IfIndexUtil.getType(ifIndex)) continue;
                    int card = (ifIndex >> 19 & 0x1F) + 1;
                    StringBuffer buf = new StringBuffer(new Integer(lookupValue[rootLength + 3]).toString());
                    for (int j = rootLength + 4; j < lookupValue.length; ++j) {
                        buf.append('.');
                        buf.append(lookupValue[j]);
                    }
                    if (ifIndex == cardPhyIndex) {
                        ret = buf.toString();
                    }
                    if (map == null || buf.length() <= 3 || map.get(new Integer(card)) == null) continue;
                    map.put(new Integer(card), buf.toString());
                    continue;
                }
                break;
            }
        }
        catch (SnmpException ex) {
            DMMHelper.wrapAndRethrow(ex);
        }
        return ret;
    }

    public static String getSsmIpAddressSlotId(SnmpPeer peer, int slotId, Map map) throws DMMException {
        String ret = "";
        VarBindList vbl = new VarBindList();
        SnmpOID root = new SnmpOID(MibNode.get("ciiIPIfAddressPrefixLength").getOid());
        int rootLength = root.getValue().length;
        try {
            vbl.add(new SnmpVarBind(root));
            SnmpPDU resp = SnmpFetch.next(peer, vbl);
            while (true) {
                VarBindList invbl = new VarBindList();
                invbl.add(new SnmpVarBind(resp.getOid(0)));
                resp = SnmpFetch.next(peer, invbl);
                if (resp.getOid(0).startsWith(root)) {
                    int[] lookupValue = resp.getOid(0).getValue();
                    int ifIndex = lookupValue[rootLength];
                    int vsan = ifIndex & 0xFFF;
                    if (vsan != 1 || 8 != IfIndexUtil.getType(ifIndex)) continue;
                    int card = (ifIndex >> 19 & 0x1F) + 1;
                    StringBuffer buf = new StringBuffer(new Integer(lookupValue[rootLength + 3]).toString());
                    for (int j = rootLength + 4; j < lookupValue.length; ++j) {
                        buf.append('.');
                        buf.append(lookupValue[j]);
                    }
                    if (card == slotId) {
                        ret = buf.toString();
                    }
                    if (map == null || buf.length() <= 3 || map.get(new Integer(card)) == null) continue;
                    map.put(new Integer(card), buf.toString());
                    continue;
                }
                break;
            }
        }
        catch (SnmpException ex) {
            DMMHelper.wrapAndRethrow(ex);
        }
        return ret;
    }

    private static void wrapAndRethrow(Exception ex) throws DMMException {
        DMMException e = new DMMException();
        e.setProtocolException(ex);
        throw e;
    }
}

