/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.dmm;

import com.cisco.dcbu.lib.jnm.SshUserInfo;
import com.cisco.dcbu.lib.jnm.Vsh;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.sm.server.dmm.CommandReader;
import com.cisco.dcbu.sm.server.dmm.Mediator;
import com.cisco.dcbu.sm.server.dmm.SshMediatorPdu;
import com.cisco.dcbu.sm.server.dmm.SshMediatorReqPdu;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobActionResp;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobConfigValidateResp;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobInfraCreateResp;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobLunmapResp;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobQueryResp;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobSessionQueryResp;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmPduHdr;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmSessionAddResp;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmShowViListResp;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmStorageJobViResp;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.ByteBuffer;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SshMediator
implements Mediator {
    private static final int NUM_UNIT = Integer.getInteger("dmm.read.numunit", 10);
    private static final int SSH_READ_TIMEOUT = Integer.getInteger("dmm.read.timeout", 60000);
    private static final int SSH_INIT_READ_TIMEOUT = Integer.getInteger("dmm.read.ini.timeout", 5000);
    private static final int SSH_CONNECT_TIMEOUT = Integer.getInteger("dmm.connect.timeout", 10000);
    private static final boolean CONNECTION_RETRY = Boolean.getBoolean("dmm.connection.retry");
    private static short SSM_PORT = (short)2048;
    static final byte CARRIAGE_RETURN = 13;
    static final boolean _AsciiMode = true;
    static final String DMM_PORT = "2048";
    static boolean _UseSocket = true;
    public static Logger _Logger = null;
    public static short SSH = 1;
    protected Vsh _vsh;
    private Session _session = null;
    private Channel _channel = null;
    private InputStream _in;
    private OutputStream _out;
    public static byte DMM_PDU_VERSION = 1;
    static int _ReqId = 3;
    private String _user;
    private String _pass;
    private String _mgmtIp = null;
    private String _ssmCardIp = null;
    static char[] s_hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static DmmPduHdr getHeader(byte type, SshMediatorReqPdu pdu) throws IOException {
        DmmPduHdr hdr = new DmmPduHdr();
        hdr.setOpcode(type);
        hdr.setVersion(DMM_PDU_VERSION);
        hdr.setReqIdentified(SshMediator.getReqId());
        pdu.setPduHdr(hdr);
        hdr.setLength((short)(pdu.toByteArray().length * 2));
        return hdr;
    }

    public static int getReqId() {
        return _ReqId++;
    }

    @Override
    public String getMgmtIp() {
        return this._mgmtIp;
    }

    @Override
    public String getSSMCardIp() {
        return this._ssmCardIp;
    }

    @Override
    public void reconnect() throws IOException {
        this.setUpInternal(this._mgmtIp, this._ssmCardIp);
    }

    SshMediator(String host, String user, String passCode) throws IOException {
        this._user = user;
        this._pass = passCode;
        SshMediator.initLogger();
    }

    public static String toHexString(long value) {
        StringBuffer buf = new StringBuffer();
        byte[] setValues = new byte[8];
        setValues[7] = (byte)(value >> 56 & 0xFFL);
        setValues[6] = (byte)(value >> 48 & 0xFFL);
        setValues[5] = (byte)(value >> 40 & 0xFFL);
        setValues[4] = (byte)(value >> 32 & 0xFFL);
        setValues[3] = (byte)(value >> 24 & 0xFFL);
        setValues[2] = (byte)(value >> 16 & 0xFFL);
        setValues[1] = (byte)(value >> 8 & 0xFFL);
        setValues[0] = (byte)(value & 0xFFL);
        try {
            boolean hasValue = false;
            for (int i = 7; i >= 0; --i) {
                if (setValues[i] == 0) {
                    if (!hasValue) {
                        continue;
                    }
                } else {
                    hasValue = true;
                }
                buf.append(SshMediator.toHexString(setValues[i]));
            }
        }
        catch (Exception ex) {
            _Logger.error((Object)("can not convert to String:" + ex.getMessage()), (Throwable)ex);
        }
        return buf.toString();
    }

    private static String toHexString(byte in) {
        StringBuffer buf = new StringBuffer();
        try {
            byte lowPos = (byte)(in & 0xF);
            byte highPos = (byte)(in >> 4 & 0xF);
            buf.append(s_hexChar[highPos]);
            buf.append(s_hexChar[lowPos]);
        }
        catch (Exception ex) {
            _Logger.error((Object)("can not convert to String:" + ex.getMessage()), (Throwable)ex);
        }
        return buf.toString();
    }

    @Override
    public Object sendRecv(short messageType, Object in) throws IOException {
        return this.sendRecv(messageType, in, false);
    }

    @Override
    public Object sendRecv(short messageType, Object in, boolean retry) throws IOException {
        SshMediatorReqPdu pduIn = (SshMediatorReqPdu)in;
        pduIn.getPduHdr().setNumUnits((short)NUM_UNIT);
        pduIn.getPduHdr().setOffset((short)0);
        try {
            return this.sendRecv(messageType, pduIn);
        }
        catch (IOException ioe) {
            if (retry) {
                this.reconnect();
                return this.sendRecv(messageType, pduIn);
            }
            throw ioe;
        }
    }

    private Object sendRecv(short messageType, SshMediatorReqPdu pduIn) throws IOException {
        SshMediatorPdu resp = this.sendRecvInternal(messageType, pduIn);
        if (15 == messageType) {
            return this.processLunMap(pduIn, (DmmJobLunmapResp)resp);
        }
        if (32 == messageType) {
            return this.processSessionQuery(pduIn, (DmmJobSessionQueryResp)resp);
        }
        return resp;
    }

    private DmmJobSessionQueryResp processSessionQuery(SshMediatorReqPdu pduIn, DmmJobSessionQueryResp resp) throws IOException {
        DmmJobSessionQueryResp origlunResp = resp;
        while (resp.getPduHdr().getMore() > 0) {
            DmmJobSessionQueryResp nextresp;
            _Logger.debug((Object)("more:  " + this._mgmtIp + ": " + this._ssmCardIp + ": " + resp.getPduHdr()));
            pduIn.getPduHdr().setOffset((short)(pduIn.getPduHdr().getOffset() + resp.getNumSessions()));
            resp = nextresp = (DmmJobSessionQueryResp)this.sendRecvInternal((short)32, pduIn);
            origlunResp.getSessions().addAll(nextresp.getSessions());
            _Logger.debug((Object)("read: " + nextresp.getSessions().size() + "unit"));
            origlunResp.setNumSessions(origlunResp.getSessions().size());
        }
        return origlunResp;
    }

    private DmmJobLunmapResp processLunMap(SshMediatorReqPdu pduIn, DmmJobLunmapResp resp) throws IOException {
        DmmJobLunmapResp origlunResp = resp;
        while (resp.getPduHdr().getMore() > 0) {
            DmmJobLunmapResp nextresp;
            _Logger.debug((Object)("more:  " + this._mgmtIp + ": " + this._ssmCardIp + ": " + resp.getPduHdr()));
            pduIn.getPduHdr().setOffset((short)(pduIn.getPduHdr().getOffset() + resp.getNumLuns()));
            resp = nextresp = (DmmJobLunmapResp)this.sendRecvInternal((short)15, pduIn);
            origlunResp.getLuns().addAll(nextresp.getLuns());
            _Logger.debug((Object)("read: " + nextresp.getLuns().size() + "unit"));
            origlunResp.setNumLuns(origlunResp.getLuns().size());
        }
        return origlunResp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SshMediatorPdu sendRecvInternal(short messageType, Object in) throws IOException {
        byte[] toWrite = ((SshMediatorPdu)in).toByteArray();
        SshMediatorPdu ret = null;
        SshMediatorReqPdu pduIn = (SshMediatorReqPdu)in;
        _Logger.debug((Object)("send:  " + this._mgmtIp + ": " + this._ssmCardIp + ": " + pduIn.toString()));
        OutputStream outputStream = this._out;
        synchronized (outputStream) {
            this.write(toWrite);
            switch (messageType) {
                case 32: {
                    DmmJobSessionQueryResp pdu = new DmmJobSessionQueryResp();
                    pdu.fromByteArray(this.read(toWrite.length));
                    ret = pdu;
                    break;
                }
                case 1: {
                    DmmJobQueryResp pdu = new DmmJobQueryResp();
                    pdu.fromByteArray(this.read(toWrite.length));
                    ret = pdu;
                    break;
                }
                case 15: {
                    DmmJobLunmapResp pdu = new DmmJobLunmapResp();
                    pdu.fromByteArray(this.read(toWrite.length));
                    ret = pdu;
                    break;
                }
                case 11: {
                    DmmStorageJobViResp pdu = new DmmStorageJobViResp();
                    pdu.fromByteArray(this.read(toWrite.length));
                    ret = pdu;
                    break;
                }
                case 21: {
                    DmmJobActionResp pdu = new DmmJobActionResp();
                    pdu.fromByteArray(this.read(toWrite.length));
                    ret = pdu;
                    break;
                }
                case 19: {
                    DmmSessionAddResp pdu = new DmmSessionAddResp();
                    pdu.fromByteArray(this.read(toWrite.length));
                    ret = pdu;
                    break;
                }
                case 3: {
                    DmmJobConfigValidateResp pdu = new DmmJobConfigValidateResp();
                    pdu.fromByteArray(this.read(toWrite.length));
                    ret = pdu;
                    break;
                }
                case 5: 
                case 7: 
                case 9: 
                case 13: 
                case 17: 
                case 50: 
                case 57: 
                case 59: {
                    DmmJobInfraCreateResp pdu = new DmmJobInfraCreateResp();
                    pdu.fromByteArray(this.read(toWrite.length));
                    ret = pdu;
                    break;
                }
                case 55: {
                    DmmShowViListResp pdu = new DmmShowViListResp();
                    pdu.fromByteArray(this.read(toWrite.length));
                    ret = pdu;
                    break;
                }
            }
            _Logger.debug((Object)("recv:  " + this._mgmtIp + ": " + this._ssmCardIp + ": " + ret));
        }
        return ret;
    }

    private String getString(byte[] toSend) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < toSend.length; ++i) {
            buf.append(SshMediator.toHexString(toSend[i]));
        }
        buf.append("\n");
        return buf.toString();
    }

    private void write(byte[] toWrite) throws IOException {
        byte[] toSend = toWrite;
        String asciiStr = this.getString(toSend);
        _Logger.debug((Object)("send:  " + this._mgmtIp + ": " + this._ssmCardIp + ": " + asciiStr));
        toSend = asciiStr.getBytes();
        try {
            this._out.write(toSend);
        }
        catch (IOException ex) {
            this.setUpInternal(this._mgmtIp, this._ssmCardIp);
            this._out.write(toSend);
        }
    }

    private ByteBuffer read(int skipLength) throws IOException {
        byte[] skip = new byte[skipLength * 2 + 2];
        this._in.read(skip);
        byte[] all = new byte[1024];
        int read_len = this._in.read(all);
        if (read_len == -1) {
            throw new IOException("SSH socket closed or Read Timeout after:" + SSH_READ_TIMEOUT + " milli seconds - to " + this._mgmtIp + ": " + this._ssmCardIp + ": ");
        }
        ByteBuffer ret = null;
        _Logger.debug((Object)("recv:  " + this._mgmtIp + ": " + this._ssmCardIp + ": " + new String(all, 0, read_len)));
        ret = ByteBuffer.allocate(81920);
        int total_length = this.getBnaryFromHex(all, read_len, ret, true);
        int count = 0;
        while (read_len < total_length) {
            all = new byte[1024];
            int temp = this._in.read(all);
            if (temp == -1) {
                throw new IOException("SSH socket closed or Read Timeout after:" + SSH_READ_TIMEOUT + " milli seconds ");
            }
            if (temp % 2 == 1) {
                _Logger.debug((Object)("read an odd number of bytes - " + temp + " will read one more "));
                byte[] oneMore = new byte[1];
                int oneMoreLength = this._in.read(oneMore);
                if (oneMoreLength == -1) {
                    throw new IOException("SSH socket closed or Read Timeout after:" + SSH_READ_TIMEOUT + " milli seconds ");
                }
                all[temp] = oneMore[0];
                ++temp;
                _Logger.debug((Object)("read one more - " + oneMoreLength + " will append to last read"));
            }
            _Logger.debug((Object)("read " + temp + " bytes" + " readlen: " + (read_len += temp) + " total_length: " + total_length));
            this.getBnaryFromHex(all, temp, ret, false);
            ++count;
        }
        ret.rewind();
        return ret;
    }

    private int getBnaryFromHex(byte[] all, int read_len, ByteBuffer ret, boolean getCount) {
        String preHex = "";
        int total_length = 8;
        for (int count = 0; count < read_len; count += 2) {
            String hex;
            block7: {
                hex = new String(all, count, 2);
                try {
                    byte[] value = SnmpString.fromHexString(hex, false);
                    ret.put(value[0]);
                    if (getCount && count == 6) {
                        value = SnmpString.fromHexString(preHex + hex, false);
                        total_length = value[1];
                        if (total_length < 0) {
                            total_length = 256 + total_length;
                        }
                        if (value[0] < 0) {
                            int temp = value[0];
                            total_length += (temp += 256) * 256;
                        } else {
                            total_length += value[0] * 256;
                        }
                    }
                }
                catch (NumberFormatException ex) {
                    if (count == total_length - 2) break block7;
                    _Logger.debug((Object)("stop at hex:" + hex + ":" + count));
                }
            }
            preHex = hex;
        }
        return total_length;
    }

    private static int getBinaryFromHex(char[] all, int read_len, ByteBuffer ret, boolean getCount) {
        String preHex = "";
        int total_length = 8;
        for (int count = 0; count < read_len; count += 2) {
            String hex;
            block5: {
                hex = new String(all, count, 2);
                try {
                    byte[] value = SnmpString.fromHexString(hex, false);
                    ret.put(value[0]);
                    if (getCount && count == 6) {
                        value = SnmpString.fromHexString(preHex + hex, false);
                        total_length = value[1];
                        if (total_length < 0) {
                            total_length = 256 + total_length;
                        }
                        total_length += value[0] * 256;
                    }
                }
                catch (NumberFormatException ex) {
                    if (count == total_length - 2) break block5;
                    _Logger.debug((Object)("stop at hex:" + hex + ":" + count));
                }
            }
            preHex = hex;
        }
        return total_length;
    }

    @Override
    public void setUp(String mgmtIp, String ssmCardIp) throws IOException {
        this.setUp(mgmtIp, ssmCardIp, CONNECTION_RETRY);
    }

    @Override
    public void setUp(String mgmtIp, String ssmCardIp, boolean retry) throws IOException {
        if (ssmCardIp == null || ssmCardIp.trim().equals("")) {
            throw new IOException("ssmCardIp is null");
        }
        try {
            this.setUpInternal(mgmtIp, ssmCardIp);
        }
        catch (IOException ex) {
            if (retry) {
                _Logger.debug((Object)"caught an exception: one more try");
                this.setUpInternal(mgmtIp, ssmCardIp);
            }
            throw ex;
        }
    }

    private void setUpInternal(String mgmtIp, String ssmCardIp) throws IOException {
        JSch jsch = new JSch();
        this._mgmtIp = mgmtIp;
        this._ssmCardIp = ssmCardIp;
        try {
            this._session = jsch.getSession(this._user, mgmtIp);
            this._session.setPassword(this._pass);
            this._session.setUserInfo(new SshUserInfo(this._pass));
            this._session.setTimeout(SSH_INIT_READ_TIMEOUT);
            this._session.connect(SSH_CONNECT_TIMEOUT);
            if (!this._session.isConnected()) {
                throw new IOException("can not open session to:" + ssmCardIp + " on switcher: " + mgmtIp);
            }
            this._channel = this._session.openChannel("shell");
            this._in = this._channel.getInputStream();
            this._out = this._channel.getOutputStream();
            this._channel.connect();
            String connectTo = "telnet " + ssmCardIp + "  " + SSM_PORT + "\n";
            _Logger.debug((Object)("telnet to:" + mgmtIp + ":" + ssmCardIp));
            if (!this.doHandShack(connectTo, mgmtIp)) {
                throw new IOException("Can not connect to ssmCard:" + ssmCardIp + " on MDS: " + mgmtIp);
            }
            this._session.setTimeout(SSH_READ_TIMEOUT);
        }
        catch (JSchException ex) {
            throw new IOException("Failed to connect to" + mgmtIp + " " + ex.getMessage());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void disconnect() {
        _Logger.debug((Object)("disconnect:" + this._mgmtIp + ":" + this._ssmCardIp));
        if (this._channel != null) {
            this._channel.disconnect();
        }
        if (this._session != null) {
            this._session.disconnect();
        }
    }

    public boolean doHandShack(String connectTo, String switchIp) throws IOException {
        byte[] outArr = new byte[2048];
        int length = this._in.read(outArr);
        String peek = new String(outArr, 0, length);
        CommandReader.readPrompt(this._in, this._out, outArr);
        String no_monitor = "terminal no monitor_force\n";
        this._out.write(no_monitor.getBytes());
        this._out.flush();
        this._out.write(connectTo.getBytes());
        this._out.flush();
        while (peek.indexOf("Escape") < 0) {
            try {
                length = CommandReader.readData(this._in, outArr);
            }
            catch (IOException io) {
                _Logger.error((Object)("error during read:" + io.getMessage()));
                throw new IOException("can not connect to line card " + connectTo + " on MDS " + switchIp + ", recieved read error: " + io.getMessage());
            }
            peek = new String(outArr, 0, length);
            if (peek.indexOf("Connection refused") < 0) continue;
            _Logger.error((Object)("can not connect to line card " + connectTo + " on MDS " + switchIp + ", refused to connect to SSM"));
            throw new IOException("can not connect to line card " + connectTo + " on MDS " + switchIp + ", refused to connect to SSM");
        }
        if (peek.indexOf("Connection closed") >= 0) {
            _Logger.error((Object)("can not connect to line card, Telnet session is closed:" + connectTo + " on MDS " + switchIp));
            throw new IOException("can not connect to line card, Telnet session is closed:" + connectTo + " on MDS " + switchIp);
        }
        return true;
    }

    public static void initLogger() {
        if (_Logger != null) {
            return;
        }
        _Logger = LogManager.getLogger((String)"dmm");
    }

    public static void main(String[] args) throws Exception {
        String str = "021082BA0000000D00000000000000B18C0000FFFFFF0188EB95164C53492020202020494E462D30312D303020202020202020013FFFFF000002000200000000200000E08B80930B210000E08B80930B00000000200600A0B8169681200600A0B8169682000000000000000000000000200100E08BA0930B210100E08BA0930B00000000200600A0B8169681200600A0B816968300000000000000008C0000FFFFFF014D7A99614C53492020202020494E462D30312D303020202020202020013FFFFF000002000200000000200000E08B80930B210000E08B80930B00000000200600A0B8169681200600A0B8169682000000000000000100000000200100E08BA0930B210100E08BA0930B00000000200600A0B8169681200600A0B816968300000000000000018C0000FFFFFF01706F3F714C53492020202020494E462D30312D303020202020202020013FFFFF000002000200000000200000E08B80930B210000E08B80930B00000000200600A0B8169681200600A0B8169682000000000000000200000000200100E08BA0930B210100E08BA0930B00000000200600A0B8169681200600A0B816968300000000000000028C0000FFFFFF01D76AA0744C53492020202020494E462D30312D303020202020202020013FFFFF000002000200000000200000E08B80930B210000E08B80930B00000000200600A0B8169681";
        ByteBuffer ret = ByteBuffer.allocate(40960);
        StringReader _in = new StringReader(str);
        char[] all = new char[1024];
        int read_len = _in.read(all, 0, str.length());
        if (read_len == -1) {
            throw new IOException("SSH socket closed or Read Timeout after:" + SSH_READ_TIMEOUT + " milli seconds ");
        }
        SshMediator.getBinaryFromHex(all, read_len, ret, true);
        ret.rewind();
        DmmJobLunmapResp pdu = new DmmJobLunmapResp();
        pdu.fromByteArray(ret);
        System.out.println(pdu);
    }
}

