/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.dmm.pdu;

import com.cisco.dcbu.sm.server.dmm.SshMediatorHelper;
import com.cisco.dcbu.sm.server.dmm.SshMediatorPdu;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmItlInfo;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class DmmJobLunmapInfo
implements SshMediatorPdu {
    private int m_len;
    private short m_rsvd_o;
    private long m_phy_lun_token;
    private long m_vendor_id;
    private String m_product_id;
    private long m_max_lba;
    private int m_blk_len;
    private byte m_num_itl_info;
    private List m_luns;

    public void setLen(int len) {
        this.m_len = len;
    }

    public int getLen() {
        return this.m_len;
    }

    public void setRsvdO(short rsvd_o) {
        this.m_rsvd_o = rsvd_o;
    }

    public short getRsvdO() {
        return this.m_rsvd_o;
    }

    public void setPhyLunToken(long phy_lun_token) {
        this.m_phy_lun_token = phy_lun_token;
    }

    public long getPhyLunToken() {
        return this.m_phy_lun_token;
    }

    public void setVendorId(long vendor_id) {
        this.m_vendor_id = vendor_id;
    }

    public long getVendorId() {
        return this.m_vendor_id;
    }

    public void setProductId(String product_id) {
        this.m_product_id = product_id;
    }

    public String getProductId() {
        return this.m_product_id;
    }

    public void setMaxLba(long max_lba) {
        this.m_max_lba = max_lba;
    }

    public long getMaxLba() {
        return this.m_max_lba;
    }

    public void setBlkLen(int blk_len) {
        this.m_blk_len = blk_len;
    }

    public int getBlkLen() {
        return this.m_blk_len;
    }

    public void setNumItlInfo(byte num_itl_info) {
        this.m_num_itl_info = num_itl_info;
    }

    public byte getNumItlInfo() {
        return this.m_num_itl_info;
    }

    public void setLuns(List luns) {
        this.m_luns = luns;
    }

    public List getLuns() {
        return this.m_luns;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        ByteBuffer stream = ByteBuffer.allocate(10000);
        SshMediatorHelper.writeInt(stream, this.m_len, 1);
        SshMediatorHelper.writeShort(stream, this.m_rsvd_o, 2);
        SshMediatorHelper.writeLong(stream, this.m_phy_lun_token, 8);
        SshMediatorHelper.writeLong(stream, this.m_vendor_id, 8);
        SshMediatorHelper.writeString(stream, this.m_product_id, 16);
        SshMediatorHelper.writeLong(stream, this.m_max_lba, 8);
        SshMediatorHelper.writeInt(stream, this.m_blk_len, 4);
        SshMediatorHelper.writeByte(stream, (byte)this.m_luns.size(), 1);
        for (int i = 0; i < this.m_luns.size(); ++i) {
            DmmItlInfo obj = (DmmItlInfo)this.m_luns.get(i);
            SshMediatorHelper.writeByteArray(stream, obj.toByteArray());
        }
        int pos = stream.position();
        stream.rewind();
        byte[] ret = new byte[pos];
        stream.get(ret, 0, pos);
        return ret;
    }

    @Override
    public void fromByteArray(ByteBuffer stream) throws IOException {
        this.m_len = SshMediatorHelper.readInt(stream, 1);
        this.m_rsvd_o = SshMediatorHelper.readShort(stream, 2);
        this.m_phy_lun_token = SshMediatorHelper.readLong(stream, 8);
        this.m_vendor_id = SshMediatorHelper.readLong(stream, 8);
        this.m_product_id = SshMediatorHelper.readString(stream, 16);
        this.m_max_lba = SshMediatorHelper.readLong(stream, 8);
        this.m_blk_len = SshMediatorHelper.readInt(stream, 4);
        this.m_num_itl_info = SshMediatorHelper.readByte(stream, 1);
        this.m_luns = new ArrayList();
        for (int i = 0; i < this.m_num_itl_info; ++i) {
            DmmItlInfo obj = new DmmItlInfo();
            obj.fromByteArray(stream);
            this.m_luns.add(obj);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("(DmmJobLunmapInfo:");
        buf.append("m_len:" + this.m_len + ":");
        buf.append("m_rsvd_o:" + this.m_rsvd_o + ":");
        buf.append("m_phy_lun_token:" + this.m_phy_lun_token + ":");
        buf.append("m_vendor_id:" + this.m_vendor_id + ":");
        buf.append("m_product_id:" + this.m_product_id + ":");
        buf.append("m_max_lba:" + this.m_max_lba + ":");
        buf.append("m_blk_len:" + this.m_blk_len + ":");
        buf.append("m_num_itl_info:" + this.m_num_itl_info + ":");
        buf.append("m_luns:");
        for (int i = 0; i < this.m_luns.size(); ++i) {
            buf.append(":" + this.m_luns.get(i));
        }
        buf.append(")");
        return buf.toString();
    }
}

