/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.dmm.pdu;

import com.cisco.dcbu.sm.server.dmm.SshMediatorHelper;
import com.cisco.dcbu.sm.server.dmm.SshMediatorReqPdu;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmPduHdr;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmSessionInfo;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class DmmSessionAddReq
implements SshMediatorReqPdu {
    private DmmPduHdr m_pdu_hdr;
    private long m_job_id;
    private int m_num_sessions;
    private List m_sessions;

    @Override
    public void setPduHdr(DmmPduHdr pdu_hdr) {
        this.m_pdu_hdr = pdu_hdr;
    }

    @Override
    public DmmPduHdr getPduHdr() {
        return this.m_pdu_hdr;
    }

    public void setJobId(long job_id) {
        this.m_job_id = job_id;
    }

    public long getJobId() {
        return this.m_job_id;
    }

    public void setNumSessions(int num_sessions) {
        this.m_num_sessions = num_sessions;
    }

    public int getNumSessions() {
        return this.m_num_sessions;
    }

    public void setSessions(List sessions) {
        this.m_sessions = sessions;
    }

    public List getSessions() {
        return this.m_sessions;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        ByteBuffer stream = ByteBuffer.allocate(10000);
        SshMediatorHelper.writeByteArray(stream, this.m_pdu_hdr.toByteArray());
        SshMediatorHelper.writeLong(stream, this.m_job_id, 8);
        SshMediatorHelper.writeInt(stream, this.m_sessions.size(), 4);
        for (int i = 0; i < this.m_sessions.size(); ++i) {
            DmmSessionInfo obj = (DmmSessionInfo)this.m_sessions.get(i);
            SshMediatorHelper.writeByteArray(stream, obj.toByteArray());
        }
        int pos = stream.position();
        stream.rewind();
        byte[] ret = new byte[pos];
        stream.get(ret, 0, pos);
        return ret;
    }

    @Override
    public void fromByteArray(ByteBuffer stream) throws IOException {
        this.m_pdu_hdr = new DmmPduHdr();
        this.m_pdu_hdr.fromByteArray(stream);
        this.m_job_id = SshMediatorHelper.readLong(stream, 8);
        this.m_num_sessions = SshMediatorHelper.readInt(stream, 4);
        this.m_sessions = new ArrayList();
        for (int i = 0; i < this.m_num_sessions; ++i) {
            DmmSessionInfo obj = new DmmSessionInfo();
            obj.fromByteArray(stream);
            this.m_sessions.add(obj);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("(DmmSessionAddReq:");
        buf.append("m_job_id:" + this.m_job_id + ":");
        buf.append("m_num_sessions:" + this.m_num_sessions + ":");
        buf.append("m_sessions:");
        for (int i = 0; i < this.m_sessions.size(); ++i) {
            buf.append(":" + this.m_sessions.get(i));
        }
        buf.append(")");
        return buf.toString();
    }
}

