/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.em;

import com.cisco.dcbu.lib.jnm.SnmpInetAddress;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpOutputStream;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.sm.common.event.LogEvent;
import com.cisco.dcbu.sm.common.event.LogEventType;
import com.cisco.dcbu.sm.common.event.PortLogEventType;
import com.cisco.dcbu.sm.common.event.Severity;
import com.cisco.dcbu.sm.common.model.SwitchIf;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.LanPK;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.em.EventForwardObject;
import com.cisco.dcbu.sm.server.em.EventForwardRec;
import com.cisco.dcbu.sm.server.facade.FMServerImpl;
import com.cisco.dcbu.sm.server.licmgr.LicenseManager;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.LanImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.web.util.NavigationUtil;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public enum AlertNotifier {
    INSTANCE;

    private static final String _AddSql = "INSERT INTO EVENT_FORWARD(ID,TYPE,SEVERITY,ADDRESS,EVENTTYPE,SUBTYPE,LAST_UPDATE_TIME, FID, VSAN_SCOPE, GID, ISLAN, FACILITY, SYSTYPE, desRegx, PGID) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String _CheckSql = "SELECT ID FROM EVENT_FORWARD WHERE TYPE = ? AND SEVERITY >= ? AND ADDRESS = ? AND EVENTTYPE = ? AND SUBTYPE = ? AND FID = ? AND VSAN_SCOPE = ? AND GID = ? AND ISLAN = ? AND FACILITY = ? AND SYSTYPE = ? AND desRegx = ? AND PGID = ?";
    private static final String _SelSql = "Select ID,TYPE,SEVERITY, ADDRESS,EVENTTYPE,FID,VSAN_SCOPE,SUBTYPE, GID, ISLAN, FACILITY, SYSTYPE, desRegx, PGID from EVENT_FORWARD";
    private static final String _RemoveSql = "DELETE FROM EVENT_FORWARD WHERE ( ID = ? )";
    private static final String FULL_VSAN_SCOPE_STR = "All";
    public static final short _FullVsanScope = -1;
    public static final String PROP_EVENT_FORWARD_ENABLE = "server.forward.event.enable";
    public static final String PROP_FROM_EMAIL = "server.forward.email.fromAddress";
    public static final String PROP_BCC_EMAIL = "server.forward.email.mailCC";
    public static final String PROP_CC_EMAIL = "server.forward.email.mailBCC";
    public static final String PROP_SMTP_HOST = "server.forward.email.smtphost";
    public static final String PROP_FORWARD_COMMUNITY = "server.forward.event.community";
    public static final String PROP_TRAP_SNMPV2C_ENABLE = "server.forward.event.SNMPV2Cenabled";
    public static final String PROP_STANDARDMIF_ENABLE = "server.forward.event.useStandardMIB";
    public static final String PROP_EVENT_FORWARD_SNOOZE = "server.forward.event.snooze";
    public static final String PROP_EVENT_FORWARD_SNOOZE_START = "server.forward.event.start";
    public static final String PROP_EVENT_FORWARD_SNOOZE_END = "server.forward.event.end";
    static final int[] _SnmpTrapOID;
    static final int[] _SysUpTime;
    static final int[] _CiscoFMEvent;
    static final int[] _CiscoFMEType;
    static final int[] _CiscoFMEDescription;
    static final int[] _CiscoFMEFacility;
    static final int[] _CiscoFMESourceAddr;
    static final int[] _EnterpriseOid;
    static final int _SpecificTrapType = 40990;
    static final long _StartTime;
    private static HashMap<Severity, int[]> _TrapOids;
    private static int _ReqId;
    private Logger _Logger = LogManager.getLogger((String)"fms.forward");
    private Logger _optionalLogger = null;
    private int _queueMax;
    private int[] _emailCount = new int[Severity.values().length];
    private int[] _trapCount = new int[Severity.values().length];
    private AtomicLong cenIdx = new AtomicLong(1L);
    private final SnmpOutputStream _outBuf = new SnmpOutputStream(2000);
    private DatagramSocket _sock;
    private volatile String _smtpHostName = null;
    private volatile String _fromAddress = null;
    private volatile String _mailCc = null;
    private volatile String _mailBcc = null;
    private volatile boolean _forwardEnabled = true;
    private ArrayList<Map<Long, EventForwardRec>> _emailList = new ArrayList(Severity.values().length);
    private ArrayList<Map<Long, EventForwardRec>> _trapList = new ArrayList(Severity.values().length);
    private String _mailSubject = null;
    private String _mailMessage = null;
    private LinkedBlockingQueue<EventForwardObject> _eventQueue = new LinkedBlockingQueue();
    private Sender _sender;
    private AtomicBoolean _inited = new AtomicBoolean();
    private Semaphore _sema = new Semaphore(1);

    private AlertNotifier() {
        this.init();
    }

    public static AlertNotifier getInstance() {
        return INSTANCE;
    }

    void init() {
        if (this._inited.get()) {
            return;
        }
        String value = System.getProperty(PROP_EVENT_FORWARD_ENABLE);
        boolean bl = this._forwardEnabled = value != null && value.length() > 0 ? Boolean.valueOf(value) : true;
        if (!this._forwardEnabled) {
            this._Logger.info((Object)"Email/Trap forwarding not enabled, init skipped");
            return;
        }
        try {
            this._smtpHostName = System.getProperty(PROP_SMTP_HOST);
            if (this._smtpHostName == null || this._smtpHostName.length() == 0) {
                this._Logger.warn((Object)"server.forward.email.smtphost is not set.");
            }
            if (!NetUtil.isReachable(this._smtpHostName, 25, 1000)) {
                this._Logger.warn((Object)("could not reach SMTP server " + this._smtpHostName + " in TCP"));
            }
        }
        catch (Exception ex) {
            this._Logger.warn((Object)("reading server.forward.email.smtphost error: " + ex));
        }
        this._fromAddress = System.getProperty(PROP_FROM_EMAIL);
        this._mailCc = System.getProperty(PROP_CC_EMAIL);
        this._mailBcc = System.getProperty(PROP_BCC_EMAIL);
        for (int i = 0; i < Severity.values().length; ++i) {
            this._emailList.add(i, Collections.synchronizedMap(new HashMap()));
            this._trapList.add(i, Collections.synchronizedMap(new HashMap()));
        }
        this.loadFromDB();
        try {
            this._sock = new DatagramSocket();
            this._Logger.info((Object)("Trap forwarding port inited: " + this._sock.getLocalPort()));
        }
        catch (Exception e) {
            this._sock = null;
            this._Logger.warn((Object)("Trap forwarding port init failed: " + e));
        }
        this._sender = new Sender();
        this._sender.start();
        this._Logger.info((Object)"Email/Trap forwarding started");
        this._inited.set(true);
    }

    public void reinit() {
        if (this._inited.get() && this._sema.tryAcquire()) {
            if (this._sender != null) {
                this._sender._stopped = true;
                if (this._sender.isAlive()) {
                    this._sender.interrupt();
                }
                this._sender = null;
            }
            if (this._sock != null) {
                if (!this._sock.isClosed()) {
                    this._sock.close();
                }
                this._sock = null;
            }
            this._emailList.clear();
            this._trapList.clear();
            for (int i = 0; i < Severity.values().length; ++i) {
                this._emailCount[i] = 0;
                this._trapCount[i] = 0;
            }
            this._inited.set(false);
            this._sema.release();
        }
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromDB() {
        int i;
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block5: {
            con = null;
            stmt = null;
            rs = null;
            i = 0;
            try {
                con = ConnectionManager.getConnection();
                stmt = con.prepareStatement(_SelSql);
                rs = stmt.executeQuery();
                if (rs == null) break block5;
                while (rs.next()) {
                    ++i;
                    this.addEntry(rs.getLong(1), rs.getInt(2), rs.getString(4), LogEventType.valueOf(rs.getInt(5)), rs.getInt(8), rs.getInt(3), FabricImpl.findDbIdByFPK(rs.getLong(6)), AlertNotifier.parseVsanScope(rs.getString(7)), rs.getLong(9), rs.getInt(10), rs.getString(11), rs.getString(12), rs.getString(13), rs.getInt(14));
                    this._Logger.debug((Object)("Read from database: " + rs.getLong(1) + " " + rs.getString(4)));
                }
            }
            catch (SQLException ex) {
                try {
                    this._Logger.warn((Object)("Reading from DB error: " + ex));
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stmt);
                    DbUtil.close(con);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        DbUtil.close(con);
        this._Logger.info((Object)("read " + i + " DB entries for event forwarding"));
    }

    public boolean addEventForward(int type, String address, LogEventType eventType, long dcid, String vsanScope, int severity) throws Exception {
        return this.addEventForward(type, address, eventType, -1, dcid, vsanScope, severity, -1L, 0, "", "", "", -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEventForward(int type, String address, LogEventType eventType, int subEventType, long fid, String vsanScope, int severity, long gid, int dctype, String facility, String sysType, String desRegx, int portGroupId) throws Exception {
        boolean added = false;
        Connection conn = null;
        PreparedStatement stmt = null;
        PreparedStatement stmt2 = null;
        ResultSet rs = null;
        int defLevel = 2;
        long eid = -1L;
        int subType = -1;
        vsanScope = vsanScope == null || vsanScope.trim().length() == 0 ? " " : vsanScope;
        facility = facility == null || facility.trim().length() == 0 ? "*" : facility.trim();
        sysType = sysType == null || sysType.trim().length() == 0 ? "*" : sysType.trim();
        desRegx = desRegx == null || desRegx.trim().length() == 0 ? "*" : desRegx.trim();
        try {
            conn = ConnectionManager.getConnection();
            defLevel = conn.getTransactionIsolation();
            DatabaseMetaData dbMd = conn.getMetaData();
            if (dbMd.supportsTransactionIsolationLevel(2)) {
                conn.setTransactionIsolation(2);
            }
            conn.setAutoCommit(false);
            stmt = conn.prepareStatement(_CheckSql);
            stmt.setInt(1, type);
            stmt.setInt(2, severity);
            stmt.setString(3, address);
            stmt.setInt(4, eventType == null ? LogEventType.ALL.value() : eventType.value());
            if (eventType.equals(LogEventType.PORT_ALARM) || eventType.equals(LogEventType.PORT_UP) || eventType.equals(LogEventType.PORT_DOWN)) {
                if (subEventType >= PortLogEventType.ALL.value() && subEventType <= PortLogEventType.NPLINK.value()) {
                    subType = subEventType;
                } else {
                    throw new Exception("The port sub type not in the proper range");
                }
            }
            stmt.setInt(5, subType);
            stmt.setLong(6, fid);
            stmt.setString(7, vsanScope);
            stmt.setLong(8, gid);
            stmt.setInt(9, dctype);
            stmt.setString(10, facility);
            stmt.setString(11, sysType);
            stmt.setString(12, desRegx);
            stmt.setInt(13, portGroupId);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                stmt2 = conn.prepareStatement(_AddSql);
                eid = Sequence.getSequence().getPK();
                stmt2.setLong(1, eid);
                stmt2.setInt(2, type);
                stmt2.setInt(3, severity);
                stmt2.setString(4, address);
                stmt2.setInt(5, eventType == null ? LogEventType.ALL.value() : eventType.value());
                if (eventType.equals(LogEventType.PORT_ALARM) || eventType.equals(LogEventType.PORT_UP) || eventType.equals(LogEventType.PORT_DOWN)) {
                    if (subEventType >= PortLogEventType.ALL.value() && subEventType <= PortLogEventType.NPLINK.value()) {
                        subType = subEventType;
                    } else {
                        throw new Exception("The port sub type not in the proper range");
                    }
                }
                stmt2.setInt(6, subType);
                stmt2.setTimestamp(7, new Timestamp(new Date().getTime()));
                stmt2.setLong(8, fid);
                stmt2.setString(9, vsanScope);
                stmt2.setLong(10, gid);
                stmt2.setInt(11, dctype);
                stmt2.setString(12, facility);
                stmt2.setString(13, sysType);
                stmt2.setString(14, desRegx);
                stmt2.setInt(15, portGroupId);
                int rows = stmt2.executeUpdate();
                added = rows > 0;
                this._Logger.info((Object)("Added  " + eid + " " + address));
            } else {
                added = true;
                eid = rs.getLong(1);
            }
            conn.commit();
        }
        catch (SQLException ex) {
            try {
                if (conn != null) {
                    conn.rollback();
                }
                this._Logger.log((Priority)Level.WARN, (Object)"Unable to add row", (Throwable)ex);
                added = false;
            }
            catch (Throwable throwable) {
                conn.setTransactionIsolation(defLevel);
                conn.setAutoCommit(true);
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(stmt2);
                DbUtil.close(conn);
                throw throwable;
            }
            conn.setTransactionIsolation(defLevel);
            conn.setAutoCommit(true);
            DbUtil.close(rs);
            DbUtil.close(stmt);
            DbUtil.close(stmt2);
            DbUtil.close(conn);
        }
        conn.setTransactionIsolation(defLevel);
        conn.setAutoCommit(true);
        DbUtil.close(rs);
        DbUtil.close(stmt);
        DbUtil.close(stmt2);
        DbUtil.close(conn);
        if (added && this._inited.get()) {
            this.addEntry(eid, type, address, eventType, subType, severity, FabricImpl.findDbIdByFPK(fid), AlertNotifier.parseVsanScope(vsanScope), gid, dctype, facility, sysType, desRegx, portGroupId);
        }
        return added;
    }

    private void addEntry(long eid, int type, String address, LogEventType eventType, int subEveType, int severity, long fid, short[] vsanScope, long gid, int dctype, String facility, String sysType, String desRegx, int pgid) {
        if (facility == null) {
            facility = "*";
        }
        facility = facility.replace("*", ".*").toUpperCase();
        facility = this.convert(facility);
        if (sysType == null) {
            sysType = "*";
        }
        sysType = sysType.replace("*", ".*").toUpperCase();
        sysType = this.convert(sysType);
        if (desRegx == null) {
            desRegx = "*";
        }
        desRegx = desRegx.replace("*", ".*").toUpperCase();
        desRegx = this.convert(desRegx);
        for (int i = 0; i <= severity; ++i) {
            if (type == 2) {
                if (this._emailList.size() <= i) continue;
                this._emailList.get(i).put(eid, new EventForwardRec(eid, type, address, eventType, subEveType, i, fid, vsanScope, gid, dctype, facility, sysType, desRegx, pgid));
                continue;
            }
            if (this._trapList.size() <= i) continue;
            this._trapList.get(i).put(eid, new EventForwardRec(eid, type, address, eventType, subEveType, i, fid, vsanScope, gid, dctype, facility, sysType, desRegx, pgid));
        }
    }

    private String convert(String facility) {
        if (!facility.startsWith(".*")) {
            facility = ".*" + facility;
        }
        if (!facility.endsWith(".*")) {
            facility = facility + ".*";
        }
        return facility;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeEventForward(long eid) throws Exception {
        boolean removed = false;
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = ConnectionManager.getConnection();
            stmt = conn.prepareStatement(_RemoveSql);
            stmt.setLong(1, eid);
            int rows = stmt.executeUpdate();
            removed = rows > 0;
            this._Logger.info((Object)("Removed from database " + eid));
        }
        catch (SQLException ex) {
            try {
                this._Logger.log((Priority)Level.WARN, (Object)"Unable to remove row ", (Throwable)ex);
                removed = false;
            }
            catch (Throwable throwable) {
                DbUtil.close(stmt);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(stmt);
            DbUtil.close(conn);
        }
        DbUtil.close(stmt);
        DbUtil.close(conn);
        if (this._inited.get()) {
            this.removeEntry(eid);
        }
        return removed;
    }

    private void removeEntry(long eid) {
        for (int i = 0; i < Severity.values().length; ++i) {
            if (this._emailList.get(i) != null && this._emailList.size() > i) {
                this._emailList.get(i).remove(eid);
            }
            if (this._trapList.get(i) == null || this._trapList.size() <= i) continue;
            this._trapList.get(i).remove(eid);
        }
    }

    public boolean forwardEvent(LogEvent e) {
        boolean isLicensed = true;
        boolean snoozeEnabled = Boolean.getBoolean(PROP_EVENT_FORWARD_SNOOZE);
        Date start = null;
        Date end = null;
        if (snoozeEnabled) {
            String startStr = System.getProperty(PROP_EVENT_FORWARD_SNOOZE_START);
            String endStr = System.getProperty(PROP_EVENT_FORWARD_SNOOZE_END);
            SimpleDateFormat df = new SimpleDateFormat("EEE MMM dd kk:mm:ss 'GMT'Z yyyy");
            try {
                start = df.parse(startStr);
                end = df.parse(endStr);
            }
            catch (ParseException e1) {
                this._Logger.warn((Object)"The snooze time parsing: ", (Throwable)e1);
            }
            Date now = new Date();
            if (start != null && start.after(now) || end != null && end.before(now)) {
                snoozeEnabled = false;
            }
        }
        if (e.getDCType() == 0) {
            isLicensed = LicenseManager.getInstance().isFmLicensed((FabricPK)e.getSource());
        }
        if (this._forwardEnabled && !snoozeEnabled && isLicensed) {
            try {
                if (this.needForward(e.getSeverity(), 2)) {
                    this._eventQueue.put(new EventForwardObject(e, 2));
                    if (this._queueMax < this._eventQueue.size()) {
                        this._queueMax = this._eventQueue.size();
                    }
                }
                if (this.needForward(e.getSeverity(), 1)) {
                    this._eventQueue.put(new EventForwardObject(e, 1));
                    if (this._queueMax < this._eventQueue.size()) {
                        this._queueMax = this._eventQueue.size();
                    }
                }
                return true;
            }
            catch (InterruptedException ie) {
                this._Logger.warn((Object)"Event forwarder stopped, event cannot be forwarded");
            }
        }
        return false;
    }

    private void sendTrap(LogEvent e, String s) {
        try {
            this.logOptionalLogger("FMS Fowarding: sendTrap.");
            this._outBuf.reset();
            SnmpPDU pdu = Boolean.valueOf(System.getProperty(PROP_TRAP_SNMPV2C_ENABLE, "false")) != false ? new SnmpPDU(-89) : new SnmpPDU(-92);
            pdu.setReqid(++_ReqId);
            InetAddress address = InetAddress.getByName(s.substring(0, s.lastIndexOf(58)));
            int port = Integer.parseInt(s.substring(s.lastIndexOf(58) + 1));
            SwitchIf sw = this.getSwitch(e);
            InetAddress agentAddr = null;
            if (sw != null) {
                agentAddr = sw.getInetAddress();
            } else {
                try {
                    agentAddr = InetAddress.getByName(e.getOrigin());
                }
                catch (UnknownHostException he) {
                    // empty catch block
                }
            }
            if (agentAddr == null) {
                return;
            }
            if (!Boolean.valueOf(System.getProperty(PROP_STANDARDMIF_ENABLE, "false")).booleanValue() || !Boolean.valueOf(System.getProperty(PROP_TRAP_SNMPV2C_ENABLE, "false")).booleanValue()) {
                this.buildPduOrig(e, pdu, agentAddr);
            } else {
                this.buildPduNew(e, pdu, agentAddr);
            }
            pdu.encode(this._outBuf);
            this._Logger.trace((Object)("\nForwarding Trap :" + (sw != null ? " switch " + sw.getName() : (e.getOrigin() != null && e.getOrigin().length() != 0 ? "Cisco DCNM " + e.getOrigin() : "no IP")) + " type : " + e.getType().toString() + " Severity : " + e.getSeverity().getValue() + " Description : " + e.getDescription()));
            this.logOptionalLogger("\nForwarding Trap :" + (sw != null ? " switch " + sw.getName() : (e.getOrigin() != null && e.getOrigin().length() != 0 ? "Cisco DCNM " + e.getOrigin() : "no IP")) + " type : " + e.getType().toString() + " Severity : " + e.getSeverity().getValue() + " Description : " + e.getDescription());
            this._sock.send(new DatagramPacket(this._outBuf._buf, this._outBuf._pos, address, port));
            int n = e.getSeverity().getValue();
            this._trapCount[n] = this._trapCount[n] + 1;
        }
        catch (Exception e11) {
            this._Logger.trace((Object)("Event Trap forwarding: exception " + e11.getMessage()));
            this.logOptionalLogger("Event Trap forwarding: exception " + e11.getMessage());
        }
    }

    private SwitchIf getSwitch(LogEvent e) {
        AbstractModelObjectImpl sw = null;
        if (e.getDCType() == 0) {
            FabricImpl fbi = null;
            if (e.getSource() != null) {
                fbi = SanManager.getInstance().findFabric((FabricPK)e.getSource());
                if (fbi != null) {
                    sw = fbi.findSwitchByDbId(e.getSwitchId());
                } else if (e.getDCId() > 0L && (fbi = SanManager.getInstance().findFabric(new FabricPK((int)e.getDCId()))) != null) {
                    sw = fbi.findSwitchByDbId(e.getSwitchId());
                }
            }
            if (sw == null && fbi != null) {
                sw = fbi.getSeed();
            }
        } else {
            LanImpl lan = null;
            if (e.getSource() != null) {
                lan = DCManager.getInstance().findLan((LanPK)e.getSource());
                if (lan != null) {
                    sw = lan.findEthSwitchByDBID(e.getSwitchId());
                } else if (e.getDCId() > 0L && (lan = DCManager.getInstance().findLan(new LanPK((int)e.getDCId()))) != null) {
                    sw = lan.findEthSwitchByDBID(e.getSwitchId());
                }
            }
            if (sw == null && lan != null && !lan.getCdpSeeds().isEmpty()) {
                List<InetAddress> swips;
                List<InetAddress> list = swips = lan.getCdpSeeds().get(0).getSeedIPs().isEmpty() ? null : lan.getCdpSeeds().get(0).getSeedIPs();
                if (!swips.isEmpty()) {
                    sw = lan.findEthSwitchByIp(swips.get(0));
                }
            }
        }
        return sw;
    }

    private void buildPduNew(LogEvent e, SnmpPDU pdu, InetAddress agentAddr) {
        long idx = this.cenIdx.getAndIncrement();
        VarBindList vbl = new VarBindList(5);
        pdu.setVariables(vbl);
        pdu.setVersion(1);
        pdu.addSysUpTime(System.currentTimeMillis() - _StartTime);
        pdu.addTrapOid(MibNode.get("ciscoEpmNotificationAlarm").getOid());
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cenAlarmIndex").getOid(), (int)idx), new SnmpUnsignedInt(idx)));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cenAlarmVersion").getOid(), (int)idx), new SnmpString("200207281420Z.0")));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cenAlarmTimestamp").getOid(), (int)idx), new SnmpTimeticks(System.currentTimeMillis() - _StartTime)));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cenAlarmUpdatedTimestamp").getOid(), (int)idx), new SnmpTimeticks(System.currentTimeMillis() - _StartTime)));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cenAlarmInstanceID").getOid(), (int)idx), new SnmpString(Long.toOctalString(idx))));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cenAlarmStatus").getOid(), (int)idx), new SnmpInt(1)));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cenAlarmStatusDefinition").getOid(), (int)idx), new SnmpString("NA")));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cenAlarmType").getOid(), (int)idx), new SnmpInt(2)));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cenAlarmCategory").getOid(), (int)idx), new SnmpInt(e.getType().value() + 100)));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cenAlarmCategoryDefinition").getOid(), (int)idx), new SnmpString(e.getType().toString())));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cenAlarmServerAddressType").getOid(), (int)idx), new SnmpInt(1)));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cenAlarmServerAddress").getOid(), (int)idx), new SnmpInetAddress(FMServerImpl.getInstance().getCurrentServerInetAddr().getAddress())));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cenAlarmManagedObjectClass").getOid(), (int)idx), new SnmpString("Switch")));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cenAlarmManagedObjectAddressType").getOid(), (int)idx), new SnmpInt(1)));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cenAlarmManagedObjectAddress").getOid(), (int)idx), agentAddr != null ? new SnmpInetAddress(agentAddr.getAddress()) : null));
        String event = e.getDescription();
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cenAlarmDescription").getOid(), (int)idx), new SnmpString(event.length() > 255 ? event.substring(0, 255) : event)));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cenAlarmSeverity").getOid(), (int)idx), new SnmpInt(e.getSeverity().getValue())));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cenAlarmSeverityDefinition").getOid(), (int)idx), new SnmpString(e.getSeverity().toString())));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cenAlarmTriageValue").getOid(), (int)idx), new SnmpInt(1)));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cenEventIDList").getOid(), (int)idx), new SnmpString(Long.toString(e.getCount()))));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cenUserMessage1").getOid(), (int)idx), new SnmpString("NA")));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cenUserMessage2").getOid(), (int)idx), new SnmpString("NA")));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cenUserMessage3").getOid(), (int)idx), new SnmpString("NA")));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cenAlarmMode").getOid(), (int)idx), new SnmpInt(3)));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cenPartitionNumber").getOid(), (int)idx), new SnmpUnsignedInt(1L)));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cenPartitionName").getOid(), (int)idx), new SnmpString("DCNM")));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cenCustomerIdentification").getOid(), (int)idx), new SnmpString("NA")));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cenCustomerRevision").getOid(), (int)idx), new SnmpString("NA")));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cenAlertID").getOid(), (int)idx), new SnmpString(Long.toOctalString(idx))));
        pdu.setCommunity(System.getProperty(PROP_FORWARD_COMMUNITY, "public"));
    }

    private void buildPduOrig(LogEvent e, SnmpPDU pdu, InetAddress agentAddr) {
        VarBindList vbl = new VarBindList(4);
        pdu.setVariables(vbl);
        if (Boolean.valueOf(System.getProperty(PROP_TRAP_SNMPV2C_ENABLE, "false")).booleanValue()) {
            pdu.setVersion(1);
            pdu.addSysUpTime(System.currentTimeMillis() - _StartTime);
            pdu.addTrapOid(_TrapOids.get((Object)e.getSeverity()));
            vbl.add(new SnmpVarBind(new SnmpOID(_CiscoFMESourceAddr), new SnmpIpAddress(agentAddr != null ? agentAddr.getAddress() : null)));
        } else {
            pdu.setVersion(0);
            pdu.setEnterpriseOid(_EnterpriseOid);
            pdu.setSpecificTrapType(40990 + e.getSeverity().getValue());
            pdu.setAgentAddress(agentAddr);
        }
        vbl.add(new SnmpVarBind(new SnmpOID(_CiscoFMEType), new SnmpString(e.getType().toString())));
        vbl.add(new SnmpVarBind(new SnmpOID(_CiscoFMEFacility), new SnmpString(e.getFacility().toString())));
        String event = e.getDescription();
        vbl.add(new SnmpVarBind(new SnmpOID(_CiscoFMEDescription), new SnmpString(event.length() > 255 ? event.substring(0, 255) : event)));
        pdu.setCommunity(System.getProperty(PROP_FORWARD_COMMUNITY, "public"));
    }

    private void sendMail(LogEvent e, String to) throws Exception {
        this._smtpHostName = System.getProperty(PROP_SMTP_HOST);
        this._fromAddress = System.getProperty(PROP_FROM_EMAIL);
        this._mailCc = System.getProperty(PROP_CC_EMAIL);
        this._mailBcc = System.getProperty(PROP_BCC_EMAIL);
        try {
            this.logOptionalLogger("FMS Fowarding: sendMail.");
            Properties properties = new Properties();
            properties.put("mail.smtp.host", this._smtpHostName);
            Session session = Session.getInstance((Properties)properties, null);
            if (SnmpSession.isTrace()) {
                session.setDebug(true);
            }
            MimeMessage mimemessage = new MimeMessage(session);
            if (this._fromAddress != null && this._fromAddress.length() > 0) {
                mimemessage.setFrom((Address)new InternetAddress(this._fromAddress));
            }
            if (this._mailCc != null && this._mailCc.length() > 0) {
                mimemessage.addRecipients(Message.RecipientType.CC, (Address[])AlertNotifier.parseInternetAddresses(this._mailCc));
            }
            if (this._mailBcc != null && this._mailBcc.length() > 0) {
                mimemessage.addRecipients(Message.RecipientType.BCC, (Address[])AlertNotifier.parseInternetAddresses(this._mailBcc));
            }
            InternetAddress[] internetAddress = AlertNotifier.parseInternetAddresses(to);
            mimemessage.addRecipients(Message.RecipientType.TO, (Address[])internetAddress);
            String srcName = (e.getSource() == null ? (e.getOrigin() == null ? "Cisco DCNM" : e.getOrigin()) : e.getSource()).toString();
            SwitchIf sw = this.getSwitch(e);
            if (e.getDCType() == 1 && sw != null) {
                long gid = e.getGroupId();
                if (gid <= 0L) {
                    gid = DbUtil.getNavGroupId(e.getSwitchId(), 4);
                }
                if (gid > 0L) {
                    srcName = NavigationUtil.getInstance().getGroupName(gid);
                }
            }
            String sname = sw != null ? sw.getName() : "";
            srcName = sname == null || sname.length() == 0 ? srcName : srcName + "\\" + sname;
            boolean _isHttps = Boolean.getBoolean("mds.web.https");
            String method = _isHttps ? "https://" : "http://";
            String port = System.getProperty("web.port");
            if (port == null) {
                port = _isHttps ? "443" : "80";
            }
            this._mailMessage = "       Time: " + new Date(e.getTimeStamp()).toString() + "\n" + "     Source: " + srcName + "\n" + "   Facility: " + e.getFacility() + "\n" + "   Severity: " + (Object)((Object)e.getSeverity()) + "\n" + "Description: " + e.getDescription() + "\n" + "DM download: " + method + FMServerImpl.getInstance().getCurrentServerIP() + ":" + port + "/element-manager.jnlp";
            mimemessage.setText(this._mailMessage);
            this._mailSubject = "" + (e.getType() == LogEventType.SYSLOG ? "Syslog" : e.getType()) + " on " + (e.getType() == LogEventType.SYSLOG && sname != null && sname.length() > 0 ? sname : e.getOrigin());
            mimemessage.setSubject(this._mailSubject);
            mimemessage.setHeader("Content-type", "text/plain; charset=\"utf-8\"");
            mimemessage.setHeader("Content-Transfer-Encoding", "base64");
            this._Logger.trace((Object)("sending out email " + to + "\n" + this._mailSubject + "\n" + this._mailMessage));
            this.logOptionalLogger("AlertNotifier sendMail: host=" + this._smtpHostName);
            this.logOptionalLogger("sending out email " + to + "\n" + this._mailSubject + "\n" + this._mailMessage);
            Transport.send((Message)mimemessage);
            int n = e.getSeverity().getValue();
            this._emailCount[n] = this._emailCount[n] + 1;
        }
        catch (Exception e1) {
            this._Logger.trace((Object)("ERROR forwarding Email to SMTP host " + this._smtpHostName));
            this.logOptionalLogger("ERROR forwarding Email to SMTP host " + this._smtpHostName);
        }
    }

    boolean needForward(Severity sev, int type) {
        return (type == 2 ? this._emailList : this._trapList).get(sev.getValue()).size() > 0;
    }

    private EventForwardRec[] getMatching(EventForwardObject efo) {
        ArrayList<EventForwardRec> list = new ArrayList<EventForwardRec>();
        Map<Long, EventForwardRec> h = (efo.getEvtFwdType() == 2 ? this._emailList : this._trapList).get(efo.getSeverity().getValue());
        Iterator<EventForwardRec> it = h.values().iterator();
        LogEvent le = efo.getLogEvent();
        while (it.hasNext()) {
            EventForwardRec efc = it.next();
            if (efc._pgid >= 0 ? !efo.getLogEvent().get_pgGroupIds().contains(efc._pgid) : efc._islan && efo.getLogEvent().getDCType() != 1 || !efc._islan && efo.getLogEvent().getDCType() != 0) continue;
            if (efc._eventType != null && efc._eventType != LogEventType.ALL && efc._eventType != efo.getLogEvent().getType() || efc._eventType == LogEventType.ALL && efo.getLogEvent().getType() == LogEventType.SYSLOG) continue;
            if (efc._eventType == LogEventType.PORT_ALARM || efc._eventType == LogEventType.PORT_UP || efc._eventType == LogEventType.PORT_DOWN) {
                boolean subTypeMatch = false;
                switch (efc._subEveType) {
                    case -1: {
                        subTypeMatch = true;
                        break;
                    }
                    case 0: {
                        if (le == null || le.getDescription() == null || le.getDescription().startsWith(PortLogEventType.STORAGE.toString()) || le.getDescription().startsWith(PortLogEventType.HOST.toString()) || le.getDescription().startsWith(PortLogEventType.ISL.toString()) || le.getDescription().startsWith(PortLogEventType.NPLINK.toString())) break;
                        subTypeMatch = true;
                        break;
                    }
                    case 1: {
                        if (le == null || le.getDescription() == null || !le.getDescription().startsWith(PortLogEventType.STORAGE.toString())) break;
                        subTypeMatch = true;
                        break;
                    }
                    case 2: {
                        if (le == null || le.getDescription() == null || !le.getDescription().startsWith(PortLogEventType.HOST.toString())) break;
                        subTypeMatch = true;
                        break;
                    }
                    case 3: {
                        if (le == null || le.getDescription() == null || !le.getDescription().startsWith(PortLogEventType.ISL.toString())) break;
                        subTypeMatch = true;
                        break;
                    }
                    case 4: {
                        if (le == null || le.getDescription() == null || !le.getDescription().startsWith(PortLogEventType.NPLINK.toString())) break;
                        subTypeMatch = true;
                    }
                }
                if (!subTypeMatch) continue;
            }
            if (efc._eventType == LogEventType.SYSLOG && (!le.getFacility().toUpperCase().matches(efc._facility) || !le.getSysType().toUpperCase().matches(efc._sysType)) || !le.getDescription().toUpperCase().matches(efc._desRegx)) continue;
            SwitchImpl sw = null;
            FabricImpl fbi = null;
            if (!efc._islan && efc._vsanScope[0] != -1) {
                if (le.getSource() != null) {
                    fbi = SanManager.getInstance().findFabric((FabricPK)le.getSource());
                    if (fbi != null) {
                        sw = fbi.findSwitchByDbId(le.getSwitchId());
                    }
                } else if (le.getDCId() > 0L) {
                    FabricPK fpk = null;
                    try {
                        fpk = FabricImpl.findFPKByDbId(le.getDCId());
                    }
                    catch (SQLException e) {
                        this._Logger.debug((Object)e);
                    }
                    if (fpk != null && (fbi = SanManager.getInstance().findFabric(fpk)) != null) {
                        sw = fbi.findSwitchByDbId(le.getSwitchId());
                    }
                } else {
                    sw = SanManager.getInstance().findSwitchByIP(SwitchImpl.findSwitchAddrinDB(le.getSwitchId()));
                }
                this._Logger.trace((Object)("Switch " + (sw != null ? sw.getName() : "No")));
                this._Logger.trace((Object)("Found Fabric " + fbi));
                if (sw == null || !FabricImpl.inScope(efc._vsanScope, sw)) continue;
                if (efc._dcid <= 0L) {
                    list.add(efc);
                    continue;
                }
                if (efc._dcid <= 0L || efc._dcid != efo.getLogEvent().getDCId()) continue;
                list.add(efc);
                continue;
            }
            if (!efc._islan && efc._dcid > 0L) {
                if (efc._dcid != efo.getLogEvent().getDCId()) continue;
                list.add(efc);
                continue;
            }
            if (!efc._islan) {
                list.add(efc);
                continue;
            }
            if (efc._gid <= 0L) {
                list.add(efc);
                continue;
            }
            long groupId = le.getGroupId();
            long swId = le.getSwitchId();
            if (groupId <= 0L && swId > 0L) {
                groupId = DbUtil.getNavGroupId(swId, 4);
            }
            if (efc._gid != groupId && !efc._gidls.contains(groupId)) continue;
            list.add(efc);
        }
        return list.size() > 0 ? list.toArray(new EventForwardRec[list.size()]) : null;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder("Alert Notifier: ");
        sb.append(this._forwardEnabled ? "enabled" : "disabled").append(", ").append(this._inited.get() ? "inited" : "un-inited");
        if (this._forwardEnabled) {
            sb.append("\n\tMail settings: ").append("SMTP server=").append(System.getProperty(PROP_SMTP_HOST)).append(", from address=").append(System.getProperty(PROP_FROM_EMAIL)).append(", subject=").append(this._mailSubject).append(", message=").append(this._mailMessage).append(", cc=").append(System.getProperty(PROP_CC_EMAIL)).append(", bcc=").append(System.getProperty(PROP_BCC_EMAIL)).append("\n\tTrap settings: ").append("sendingPort=").append(this._sock.getLocalPort());
        }
        if (this._inited.get()) {
            sb.append("\nPending events: ").append(this._eventQueue.size()).append(",\tnotifier thread: ").append(this._sender != null && this._sender.isAlive() ? "alive" : "inactive");
        }
        sb = sb.append("\n\tMax Queue Size = ").append(this._queueMax).append("\n\tEmails statistics: ");
        for (i = 0; i < Severity.values().length; ++i) {
            sb.append("\n\t").append(Severity.valueOf(i).toString()).append(" : ").append(this._emailCount[i]);
        }
        sb.append("\n\tTraps statistics: ");
        for (i = 0; i < Severity.values().length; ++i) {
            sb.append("\n\t").append(Severity.valueOf(i).toString()).append(" : ").append(this._trapCount[i]);
        }
        return sb.toString();
    }

    static InternetAddress[] parseInternetAddresses(String r) {
        String[] addr = r.split(",");
        if (addr.length < 1) {
            return null;
        }
        InternetAddress[] iaddr = new InternetAddress[addr.length];
        for (int i = 0; i < addr.length; ++i) {
            try {
                iaddr[i] = new InternetAddress(addr[i]);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return iaddr;
    }

    static short[] parseVsanScope(String vsan) {
        short[] rval = new short[]{-1};
        if (vsan == null || vsan.trim().length() == 0 || vsan.trim().equals(FULL_VSAN_SCOPE_STR)) {
            return rval;
        }
        short[] a = new short[1024];
        String[] st = vsan.trim().split(",");
        int count = 0;
        for (int i = 0; i < st.length; ++i) {
            if (st[i].indexOf(45) != -1) {
                int ul;
                int ll;
                String[] ss = st[i].split("-");
                if (ss == null || ss.length == 0 || ss.length > 2 || (ll = Integer.parseInt(ss[0])) > (ul = Integer.parseInt(ss[1]))) continue;
                for (int j = ll; j <= ul; ++j) {
                    a[count++] = (short)j;
                }
                continue;
            }
            a[count++] = (short)Integer.parseInt(st[i]);
        }
        if (count > 0) {
            short[] ret = new short[count];
            System.arraycopy(a, 0, ret, 0, count);
            return ret;
        }
        return rval;
    }

    public void setOptionalLogger(Logger log) {
        this._optionalLogger = log;
    }

    private void logOptionalLogger(String msg) {
        if (this._optionalLogger != null) {
            try {
                this._optionalLogger.debug((Object)msg);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] strArgs) {
        SimpleDateFormat df = new SimpleDateFormat("EEE MMM dd kk:mm:ss 'GMT'Z yyyy");
        try {
            Date start = df.parse("Tue Apr 30 16:51:25 GMT-0700 2013");
            Date end = df.parse("Tue Apr 30 22:51:25 GMT-0700 2013");
            Date now = new Date();
            if (start.after(now) || end.before(now)) {
                System.out.println("false");
            } else {
                System.out.println("true");
            }
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
    }

    static {
        _SnmpTrapOID = new int[]{1, 3, 6, 1, 6, 3, 1, 1, 4, 1, 0};
        _SysUpTime = new int[]{1, 3, 6, 1, 2, 1, 1, 3, 0};
        _CiscoFMEvent = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 40999, 0, 1};
        _CiscoFMEType = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 40999, 1, 1, 1, 0};
        _CiscoFMEDescription = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 40999, 1, 1, 3, 0};
        _CiscoFMEFacility = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 40999, 1, 1, 4, 0};
        _CiscoFMESourceAddr = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 40999, 1, 1, 5, 0};
        _EnterpriseOid = new int[]{1, 3, 6, 1, 4, 1, 9};
        _StartTime = System.currentTimeMillis();
        _TrapOids = new HashMap();
        int len = _EnterpriseOid.length;
        for (Severity s : Severity.values()) {
            int[] trapoid = new int[len + 2];
            System.arraycopy(_EnterpriseOid, 0, trapoid, 0, len);
            trapoid[len] = 9;
            trapoid[len + 1] = 40990 + s.getValue();
            _TrapOids.put(s, trapoid);
        }
    }

    class Sender
    extends Thread {
        boolean _stopped;

        Sender() {
            super("event-forwarder");
            this._stopped = false;
        }

        @Override
        public void run() {
            this._stopped = false;
            AlertNotifier.this._Logger.trace((Object)"Event forwarder started");
            while (!this._stopped) {
                try {
                    EventForwardObject efo = (EventForwardObject)AlertNotifier.this._eventQueue.take();
                    try {
                        EventForwardRec[] efc = AlertNotifier.this.getMatching(efo);
                        if (efc == null) continue;
                        for (int i = 0; i < efc.length; ++i) {
                            if (efo.getEvtFwdType() == 2) {
                                AlertNotifier.this.sendMail(efo.getLogEvent(), efc[i]._address);
                                continue;
                            }
                            AlertNotifier.this.sendTrap(efo.getLogEvent(), efc[i]._address);
                        }
                    }
                    catch (Throwable ex) {
                        AlertNotifier.this._Logger.warn((Object)("Forwarding event error: " + ex));
                        if (!Boolean.getBoolean("debug.stacktrace")) continue;
                        ex.printStackTrace();
                    }
                }
                catch (InterruptedException ie) {
                    if (this._stopped) continue;
                    this._stopped = true;
                    AlertNotifier.this._Logger.warn((Object)"Event forwarder stopped unexpectedly");
                }
            }
        }
    }
}

