/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.em;

import com.cisco.dcbu.lib.serviceconf.ServiceConfig;
import com.cisco.dcbu.sm.server.em.AbstractReceiver;
import com.cisco.dcbu.sm.server.em.EventManagerService;
import com.cisco.dcbu.sm.server.em.NmsEventStore;

class NmsEventReceiver
extends AbstractReceiver {
    NmsEventStore _store;
    static int _MAX_INCOMING = 3000;

    NmsEventReceiver() throws Exception {
        super("Event Receiver", 4);
        String value = System.getProperty("events.maxIncoming", "3000");
        _MAX_INCOMING = Integer.parseInt(value);
        this.setThrottlePoint(_MAX_INCOMING);
        this.enableThrottle(true);
    }

    @Override
    void stop() {
        super.stop();
        if (this._store != null) {
            this._store.shut();
            ((EventManagerService)ServiceConfig.findService("Event Manager Service")).delConsumer(this._store, 4);
            this._store = null;
        }
    }

    @Override
    void loadConfig(EventManagerService emService) {
        if (emService.store(4)) {
            if (this._store == null) {
                this._store = NmsEventStore.getNmsEventStore();
                emService.addConsumer(this._store, null, 4, null);
            }
        } else if (this._store != null) {
            emService.delConsumer(this._store, 4);
            this._store = null;
        }
        super.loadConfig(emService);
    }

    @Override
    void loadConfig() {
        EventManagerService emService = (EventManagerService)ServiceConfig.findService("Event Manager Service");
        this.loadConfig(emService);
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer();
        if (this._store != null) {
            buff.append("Events are being stored in DB.\n");
            if (this._store.getError() != null) {
                buff.append("Last error: ");
                buff.append(this._store.getError());
                buff.append("\n");
            }
        }
        buff.append("Statistics: ");
        buff.append(this._processed);
        buff.append(" processed, ");
        if (this._processed != 0L) {
            buff.append(this._totalProcTime / this._processed);
        } else {
            buff.append(0);
        }
        buff.append(" ms avg time\n");
        return buff.toString();
    }

    @Override
    public String toHtml() {
        StringBuffer buff = new StringBuffer();
        if (this._store != null) {
            buff.append("Events are being stored in database.<br>");
            if (this._store.getError() != null) {
                buff.append("Last error: ");
                buff.append(this._store.getError());
                buff.append("<br>");
            }
        }
        buff.append("Statistics: ");
        buff.append(this._processed);
        buff.append(" processed");
        return buff.toString();
    }
}

