/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.em;

import com.cisco.dcbu.lib.channel.ChannelIf;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.rmi.ChannelConsumerRif;
import com.cisco.dcbu.sm.common.event.LogEvent;
import com.cisco.dcbu.sm.common.event.LogEventType;
import com.cisco.dcbu.sm.common.event.Severity;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.em.EventThread;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public class NmsEventStore
extends EventThread
implements ChannelConsumerRif {
    public static final String TABLE_NAME = "events";
    public static final String[] TABLE_TYPES = new String[]{"TABLE"};
    static final int EVENTID = 1;
    static final int FIRST_SEEN = 2;
    static final int LAST_SEEN = 3;
    static final int COUNT = 4;
    static final int TYPE = 5;
    static final int SEVERITY = 6;
    static final int SOURCE = 7;
    static final int DESCR = 8;
    static final int VSANID = 9;
    static final int DCID = 10;
    static final int SWITCHID = 11;
    static final int SRCID = 12;
    static final int DESTID = 13;
    static final int SWITCHWWN = 14;
    static final int ENCLOSURE = 14;
    static final int DCTYPE = 15;
    static final int GROUPID = 16;
    static final int FACILITY = 17;
    static final int SYSLOGEVENT = 18;
    static final String GETALL_BY_FID_STMT = "SELECT e.EVENTID, e.FIRST_SEEN, e.LAST_SEEN, e.COUNT, e.TYPE, e.SEVERITY, e.SOURCE, e.DESCR, e.VSANID, e.DCID, e.SWITCHID, e.SRCID, e.DESTID, s.WWN, e.DCTYPE, e.GROUP_ID, e.FACILITY FROM EVENTS e LEFT OUTER JOIN Switch s ON s.ID = e.SWITCHID WHERE e.DCID =? ORDER BY e.LAST_SEEN DESC";
    static final String COUNT_STMT = "SELECT COUNT(*) FROM EVENTS";
    static final String COUNT_SAME = "SELECT EVENTS.COUNT FROM EVENTS WHERE DCID=? AND SWITCHID=? AND GROUP_ID=? AND DESCR = ?";
    static final String INSERT_STMT = "INSERT INTO EVENTS(EVENTID, FIRST_SEEN, LAST_SEEN, COUNT,TYPE, SEVERITY, SOURCE, DESCR, VSANID, DCID, SWITCHID, SRCID, DESTID, ENCLOSURE_ID, DCTYPE, GROUP_ID, FACILITY, SYSLOGEVENT) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    static final String UPDATE_STMT = "UPDATE EVENTS SET COUNT = ?, LAST_SEEN = ?, ACK = 0 WHERE DCID =? AND SWITCHID = ? AND DESCR = ?";
    static final String ENCLOSURE_STMT = "SELECT ID FROM ENCLOSURE WHERE NAME = ?";
    static final String HEADER = "Time,Type,Severity,Source,Description\n";
    static int _MaxEvents = 5000;
    static NmsEventStore _Instance = null;
    private LinkedBlockingQueue<LogEvent> _queue;
    private static final int _Capacity = 20000;
    private static final long DISPATCH_TIMEOUT = 60000L;
    String _error;
    int _count = -1;
    long _sanId = 0L;

    protected NmsEventStore() {
        super("EVENT_STORE");
        String value = System.getProperty("events.maxRowsDB", "5000");
        _MaxEvents = Integer.parseInt(value);
        this._queue = new LinkedBlockingQueue(20000);
        this.initDB();
    }

    static NmsEventStore getNmsEventStore() {
        _Instance = new NmsEventStore();
        _Instance.start();
        return _Instance;
    }

    public static NmsEventStore getInstance() {
        return _Instance;
    }

    String getError() {
        return this._error;
    }

    @Override
    public void consume(ChannelIf ch, Object event) throws RemoteException {
        if (this._keepRunning && this.isAlive()) {
            try {
                if (!this._queue.offer((LogEvent)event, 60000L, TimeUnit.MILLISECONDS)) {
                    _Logger.warn((Object)("NmsEventStore queue is full, event cannot be stored: " + event));
                }
            }
            catch (InterruptedException ie) {
                _Logger.warn((Object)"NmsEventStore event queuing interrupted.");
            }
        } else {
            _Logger.warn((Object)("NmsEventStore stopped, event cannot be stored: " + event));
        }
    }

    @Override
    public void run() {
        _Logger.debug((Object)"NmsEventStore started");
        while (this.isRunning()) {
            try {
                LogEvent e = this._queue.take();
                try {
                    this.drain(e);
                }
                catch (Throwable ex) {
                    _Logger.warn((Object)("storing nms event error: " + ex));
                }
            }
            catch (InterruptedException ie) {
                if (this._keepRunning) continue;
                break;
            }
        }
        this._queue.clear();
        _Logger.debug((Object)"NmsEventSTore stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogEvent> getEventsByFid(long fid) {
        ArrayList<LogEvent> ret;
        block7: {
            ret = new ArrayList<LogEvent>();
            Connection con = null;
            PreparedStatement stat = null;
            ResultSet rs = null;
            try {
                con = ConnectionManager.getConnection();
                stat = con.prepareStatement(GETALL_BY_FID_STMT);
                stat.setObject(1, fid);
                rs = stat.executeQuery();
                for (int rows = 0; rs.next() && rows < _MaxEvents; ++rows) {
                    Timestamp ts1 = rs.getTimestamp(2);
                    Timestamp ts = rs.getTimestamp(3);
                    long count = rs.getLong(4);
                    int type = rs.getInt(5);
                    int severity = rs.getInt(6);
                    String source = rs.getString(7);
                    String descr = rs.getString(8);
                    long dcId = rs.getLong(10);
                    long switchId = rs.getLong(11);
                    byte[] switchWWN = rs.getBytes(14);
                    int islan = rs.getInt(15);
                    long gid = rs.getLong(16);
                    String facility = rs.getString(17);
                    WwnKey key = null;
                    if (switchWWN != null) {
                        key = new WwnKey(new Wwn(switchWWN));
                    }
                    FabricPK fkey = new FabricPK(new Long(fid).intValue());
                    ret.add(new LogEvent(fkey, LogEventType.valueOf(type), Severity.valueOf(severity), source, descr, dcId, switchId, ts1.getTime(), ts.getTime(), count, key, islan, gid, facility));
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                this._error = ex.getMessage();
                _Logger.error((Object)"DB error", (Throwable)ex);
                break block7;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
            }
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        return ret;
    }

    void drain(LogEvent e) {
        Object con = null;
        Object stat = null;
        if (this._count == -1) {
            return;
        }
        ++this._count;
        try {
            if (e.getOrigin() != null && e.getDescription() != null) {
                this.insertEvent(e);
            } else {
                _Logger.log((Priority)Level.INFO, (Object)("Origin/Descr is null or Fabric Id == 0 ignoring event " + e));
            }
        }
        catch (SQLException ex) {
            _Logger.log((Priority)Level.ERROR, (Object)"DB error trying again", (Throwable)ex);
            try {
                if (e.getOrigin() != null && e.getDescription() != null) {
                    this.insertEvent(e);
                } else {
                    _Logger.info((Object)("Origin/Descr is null or Fabric Id == 0 ignoring event " + e));
                }
            }
            catch (SQLException ex2) {
                this._error = ex2.getMessage();
                _Logger.error((Object)"DB error", (Throwable)ex2);
            }
        }
    }

    static long getSameCount(long dcId, long switchId, long groupId, String desc, Connection con) throws SQLException {
        long l;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            long count = 0L;
            stat = con.prepareStatement(COUNT_SAME);
            stat.setLong(1, dcId);
            stat.setLong(2, switchId);
            stat.setLong(3, groupId);
            stat.setString(4, desc);
            rs = stat.executeQuery();
            if (rs.next()) {
                count = rs.getLong(1);
            }
            l = count;
        }
        catch (SQLException e1) {
            try {
                _Logger.warn((Object)e1.getMessage());
                throw e1;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        return l;
    }

    void insertEvent(LogEvent e) throws SQLException {
        Connection con = null;
        PreparedStatement stat = null;
        PreparedStatement stat1 = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            String encl = e.getEnclosure();
            long enclosure_id = -1L;
            if (encl != null) {
                stat1 = con.prepareStatement(ENCLOSURE_STMT);
                stat1.setString(1, encl);
                rs = stat1.executeQuery();
                if (rs.next()) {
                    enclosure_id = rs.getLong(1);
                }
                DbUtil.close(rs);
            }
            long group_id = -1L;
            group_id = e.getDCType() == 0 ? DbUtil.getNavGroupId(e.getDCId(), 0) : DbUtil.getNavGroupId(e.getSwitchId(), 4);
            long csame = NmsEventStore.getSameCount(e.getDCId(), e.getSwitchId(), group_id, e.getDescription(), con);
            if (csame == 0L) {
                stat = con.prepareStatement(INSERT_STMT);
                long eventId = Sequence.getSequence().getEventPK(con);
                stat.setLong(1, eventId);
                stat.setTimestamp(2, new Timestamp(e.getTimeStamp()));
                stat.setTimestamp(3, new Timestamp(e.getTimeStamp()));
                stat.setLong(4, 1L);
                stat.setInt(5, e.getType().value());
                stat.setInt(6, e.getSeverity().getValue());
                stat.setString(7, e.getOrigin());
                stat.setString(8, e.getDescription());
                stat.setLong(9, this._sanId);
                stat.setLong(10, e.getDCId());
                stat.setLong(11, e.getSwitchId());
                stat.setLong(12, e.getSrcId());
                stat.setLong(13, e.getDestId());
                stat.setLong(14, enclosure_id);
                stat.setInt(15, e.getDCType());
                stat.setLong(16, group_id);
                stat.setString(17, e.getFacility());
                stat.setString(18, e.getType().toString());
                stat.executeUpdate();
            } else {
                stat = con.prepareStatement(UPDATE_STMT);
                stat.setLong(1, csame + 1L);
                stat.setTimestamp(2, new Timestamp(e.getTimeStamp()));
                stat.setLong(3, e.getDCId());
                stat.setLong(4, e.getSwitchId());
                stat.setString(5, e.getDescription());
                stat.executeUpdate();
            }
            con.commit();
        }
        catch (SQLException e1) {
            try {
                _Logger.warn((Object)e1.getMessage());
                try {
                    con.rollback();
                }
                catch (Throwable th) {
                    // empty catch block
                }
                throw e1;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat1);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat1);
        DbUtil.close(stat);
        DbUtil.close(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initDB() {
        Connection con = null;
        ResultSet rs = null;
        Statement stat = null;
        try {
            con = ConnectionManager.getConnection();
            if (con == null) {
                throw new SQLException("Connection can't be established");
            }
            stat = con.createStatement();
            rs = stat.executeQuery(COUNT_STMT);
            this._count = rs.next() ? rs.getInt(1) : 0;
            rs.close();
            rs = null;
        }
        catch (SQLException ex) {
            try {
                this._error = ex.getMessage();
                _Logger.log((Priority)Level.ERROR, (Object)"DB error", (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
    }

    public static void main(String[] strArgs) {
        System.setProperty("db.url", "jdbc:oracle:thin:@171.71.49.51:1521:XE");
        System.setProperty("db.user", "mayli");
        System.setProperty("db.password", "mayli");
        try {
            LogEventType eEventType = LogEventType.valueOf("PORT_ALARM");
            Severity eSeverity = Severity.valueOf(7);
            LogEvent evt = new LogEvent(eEventType, eSeverity, "test222", "test222", System.currentTimeMillis(), InetAddress.getLocalHost(), 1);
            new NmsEventStore().insertEvent(evt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

