/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.esp;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.common.dto.ESPDto;
import com.cisco.dcbu.sm.common.dto.QueueResponseBaseModelObject;
import com.cisco.dcbu.sm.common.event.CommunicationObjectSender;
import com.cisco.dcbu.sm.common.model.IslBase;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.esp.BaseRunnable;
import com.cisco.dcbu.sm.server.model.ChannelMemberIsl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.IslImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.security.FMUser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ISLSetESPRunnable
extends BaseRunnable {
    static Logger _logger = LogManager.getLogger((String)"fms.esp");
    public static final String BOGOTA_VERSION = "5.0(0)";
    static final int[] _ifAdminStatusOid = MibNode.get("ifAdminStatus").getOid();
    public static final int PORT_ADMIN_STATUS_ENABLE = 1;
    public static final int PORT_ADMIN_STATUS_DISABLE = 2;
    public static final int MANUAL = 2;
    public static final int CLEAR = 0;
    private SwitchBase _currentOperationOnSw = null;
    private SwitchBase _sw1Base;
    private SwitchBase _sw2Base;
    private IslBase _isl;
    private ESPDto _dto;
    boolean sw1PreBogotaVersion = false;
    boolean sw2PreBogotaVersion = false;

    public ISLSetESPRunnable(long requestId, FMUser user, IslBase isl, ESPDto dto, CommunicationObjectSender sender) {
        super(requestId, user, sender);
        this._isl = isl;
        this._dto = dto;
    }

    @Override
    public void run() {
        try {
            QueueResponseBaseModelObject result = new QueueResponseBaseModelObject(this._requestId, this._isl, null, 3, "In Progress", null);
            this._sender.send(result);
            SanManager sanMan = SanManager.getInstance();
            FabricPK fabPk = this._isl.getFabricPK();
            if (fabPk == null) {
                throw new Exception("Unable to find a fabric for the ISL in the FM server cache.");
            }
            SwitchImpl swImpl1 = sanMan.findSwitch(this._isl.getSwitch1PK()._wwn, fabPk);
            SwitchImpl swImpl2 = sanMan.findSwitch(this._isl.getSwitch2PK()._wwn, fabPk);
            this.sw1PreBogotaVersion = !swImpl1.isVersionGreaterThanEqual(BOGOTA_VERSION);
            this.sw2PreBogotaVersion = !swImpl2.isVersionGreaterThanEqual(BOGOTA_VERSION);
            this._sw1Base = (SwitchBase)swImpl1.getBaseObject();
            this._sw2Base = (SwitchBase)swImpl2.getBaseObject();
            this._currentOperationOnSw = this._sw1Base;
            SnmpPeer peerSw1 = this.getPeer(swImpl1);
            this._currentOperationOnSw = this._sw2Base;
            SnmpPeer peerSw2 = this.getPeer(swImpl2);
            int[] sw1PortsToSet = this.getPortsToOperateOn(this._isl, this._sw1Base);
            int[] sw2PortsToSet = this.getPortsToOperateOn(this._isl, this._sw2Base);
            if (this.isIslSecure(this._isl)) {
                if (this._isl.isPortChannel() && (this.sw1PreBogotaVersion || this.sw2PreBogotaVersion)) {
                    this.modifyExistingPCAnkBogIsl(peerSw1, sw1PortsToSet, peerSw2, sw2PortsToSet);
                } else {
                    this.modifyExistingIsl(peerSw1, peerSw2);
                }
            } else {
                this._currentOperationOnSw = this._sw1Base;
                this.setMultiPortAdminStatus(peerSw1, sw1PortsToSet, 2);
                this._currentOperationOnSw = this._sw2Base;
                this.setMultiPortAdminStatus(peerSw2, sw2PortsToSet, 2);
                try {
                    this.setESPForMultiISLPorts(peerSw1, sw1PortsToSet, peerSw2, sw2PortsToSet);
                }
                catch (Exception e) {
                    this._currentOperationOnSw = this._sw1Base;
                    this.setMultiPortAdminStatus(peerSw1, sw1PortsToSet, 1);
                    this._currentOperationOnSw = this._sw2Base;
                    this.setMultiPortAdminStatus(peerSw2, sw2PortsToSet, 1);
                    throw e;
                }
                this._currentOperationOnSw = this._sw1Base;
                this.setMultiPortAdminStatus(peerSw1, sw1PortsToSet, 1);
                this._currentOperationOnSw = this._sw2Base;
                this.setMultiPortAdminStatus(peerSw2, sw2PortsToSet, 1);
            }
            result = new QueueResponseBaseModelObject(this._requestId, this._isl, this._currentOperationOnSw, 1, "Successful", null);
            this._sender.send(result);
        }
        catch (Exception re) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Unable to set ESP config for isl:" + this._isl.toString() + " received error: " + re.getMessage()));
            }
            QueueResponseBaseModelObject result = new QueueResponseBaseModelObject(this._requestId, this._isl, this._currentOperationOnSw, 4, null, re);
            this._sender.send(result);
        }
    }

    protected boolean isIslSecure(IslBase isl) {
        boolean result = true;
        result = isl.getEspSecure();
        return result;
    }

    protected void setPortAdminStatus(SnmpPeer peerSw, int portIfIndex, int portStatus) throws SnmpException {
        VarBindList varList = new VarBindList();
        varList.add(_ifAdminStatusOid, portIfIndex, (SnmpVar)new SnmpInt(portStatus));
        SnmpPDU pdu = new SnmpPDU(-93, varList);
        pdu.setIgnoreSetCount(true);
        peerSw.set(pdu);
    }

    protected void setMultiPortAdminStatus(SnmpPeer peerSw, int[] portIfIndexes, int portStatus) throws SnmpException {
        for (int nextIfIndex : portIfIndexes) {
            this.setPortAdminStatus(peerSw, nextIfIndex, portStatus);
        }
    }

    private int[] getPortsToOperateOn(IslBase islBase, SwitchBase swbase) throws Exception {
        int[] swPortsToSet;
        boolean isPreBogotaVersions;
        boolean bl = isPreBogotaVersions = swbase.equals(this._sw1Base) ? this.sw1PreBogotaVersion : this.sw2PreBogotaVersion;
        if (islBase.isPortChannel() && isPreBogotaVersions) {
            FabricImpl fab = SanManager.getInstance().findFabric(this._isl.getFabricPK());
            if (fab == null) {
                throw new Exception("Unable to find a fabric for the ISL in the FM server cache.");
            }
            IslImpl islImpl = fab.findIsl(this._isl.getIslPK().getSwitchIntKey1());
            if (islImpl == null) {
                throw new Exception("Unable to find the ISL in FM server cache, isl might have been purged.");
            }
            List<ChannelMemberIsl> pcIsls = islImpl.getPCMemberLinks();
            if (pcIsls == null || pcIsls.size() == 0) {
                throw new Exception("No members found in the port channel.");
            }
            swPortsToSet = new int[pcIsls.size()];
            int index = 0;
            for (ChannelMemberIsl nextMember : pcIsls) {
                int memberIfIndex = swbase.equals(nextMember.getSwitch1().getBaseObject()) ? nextMember.getIfIndex1() : nextMember.getIfIndex2();
                swPortsToSet[index++] = memberIfIndex;
            }
        } else {
            swPortsToSet = new int[1];
            int ifIndex = ((WwnKey)swbase.getSwitchPK()).equals(islBase.getSwitch1PK()) ? islBase.getIfIndex1() : islBase.getIfIndex2();
            swPortsToSet[0] = ifIndex;
        }
        return swPortsToSet;
    }

    private void setESPForMultiISLPorts(SnmpPeer peerSw1, int[] sw1PortsToSet, SnmpPeer peerSw2, int[] sw2PortsToSet) throws Exception {
        int mode = this._dto.getEspMode();
        Integer egress = this._dto.getEgress();
        Integer ingress = this._dto.getIngress1();
        this._currentOperationOnSw = this._sw1Base;
        for (int nextIfIndex : sw1PortsToSet) {
            this.setESP(peerSw1, nextIfIndex, mode, egress, ingress, null);
        }
        try {
            this._currentOperationOnSw = this._sw2Base;
            for (int nextIfIndex : sw2PortsToSet) {
                this.setESP(peerSw2, nextIfIndex, mode, ingress, egress, null);
            }
        }
        catch (SnmpException e) {
            try {
                for (int nextIfIndex : sw1PortsToSet) {
                    this.deleteESP(peerSw1, nextIfIndex);
                }
            }
            catch (SnmpException se) {
                _logger.error((Object)("Unable to delete ESP from switch,port " + peerSw1 + "," + this._isl.getIfIndex1() + " recieved error:" + se));
            }
            throw e;
        }
    }

    private void modifyExistingPCAnkBogIsl(SnmpPeer peerSw1, int[] sw1PortsToSet, SnmpPeer peerSw2, int[] sw2PortsToSet) throws Exception {
        Map<Integer, ESPDto> sw1Dtos = this.getFcspEsp(peerSw1, this._sw1Base, sw1PortsToSet);
        Map<Integer, ESPDto> sw2Dtos = this.getFcspEsp(peerSw2, this._sw2Base, sw2PortsToSet);
        if (sw1Dtos == null || sw1Dtos.size() != sw1PortsToSet.length) {
            this._currentOperationOnSw = this._sw1Base;
            throw new Exception("Unable to modify existing ESP configuraton: Unable to retrieve existing configuration for all Port Channel ISL ports.");
        }
        if (sw2Dtos == null || sw2Dtos.size() != sw2PortsToSet.length) {
            this._currentOperationOnSw = this._sw2Base;
            throw new Exception("Unable to modify existing ESP configuraton: Unable to retrieve existing configuration for all Port Channel ISL ports.");
        }
        HashMap<Integer, Boolean> sw1EmptyInI1Map = new HashMap<Integer, Boolean>();
        HashMap<Integer, Boolean> sw2EmptyInI1Map = new HashMap<Integer, Boolean>();
        boolean sw1IngressChanged = true;
        boolean sw2IngressChanged = true;
        boolean sw1EgressChanged = true;
        boolean sw2EgressChanged = true;
        ESPDto existingDtoSw1 = sw1Dtos.get(sw1PortsToSet[0]);
        if (this._dto.getIngress1().equals(existingDtoSw1.getIngress1()) || this._dto.getIngress1().equals(existingDtoSw1.getIngress2())) {
            sw1IngressChanged = false;
        }
        ESPDto existingDtoSw2 = sw2Dtos.get(sw2PortsToSet[0]);
        if (this._dto.getEgress().equals(existingDtoSw2.getIngress1()) || this._dto.getEgress().equals(existingDtoSw2.getIngress2())) {
            sw2IngressChanged = false;
        }
        if (this._dto.getEgress().equals(existingDtoSw1.getEgress())) {
            sw1EgressChanged = false;
        }
        if (this._dto.getIngress1().equals(existingDtoSw2.getEgress())) {
            sw2EgressChanged = false;
        }
        if (sw1IngressChanged) {
            for (int nextIfIndex : sw1PortsToSet) {
                ESPDto nextDto1 = sw1Dtos.get(nextIfIndex);
                if (nextDto1.getIngress1().equals(existingDtoSw2.getEgress())) {
                    sw1EmptyInI1Map.put(nextIfIndex, false);
                    continue;
                }
                if (nextDto1.getIngress2().equals(existingDtoSw2.getEgress())) {
                    sw1EmptyInI1Map.put(nextIfIndex, true);
                    continue;
                }
                throw new Exception("Unable to modify existing ESP configuraton: At least one of the Port Channel members Ingress SA1/Ingress SA2 doesn't match the connected ports Egress.");
            }
        }
        if (sw2IngressChanged) {
            for (int nextIfIndex : sw2PortsToSet) {
                ESPDto nextDto2 = sw2Dtos.get(nextIfIndex);
                if (nextDto2.getIngress1().equals(existingDtoSw1.getEgress())) {
                    sw2EmptyInI1Map.put(nextIfIndex, false);
                    continue;
                }
                if (nextDto2.getIngress2().equals(existingDtoSw1.getEgress())) {
                    sw2EmptyInI1Map.put(nextIfIndex, true);
                    continue;
                }
                throw new Exception("Unable to modify existing ESP configuraton: At least one of the Port Channel members Ingress SA1/Ingress SA2 doesn't match the connected ports Egress.");
            }
        }
        if (sw1IngressChanged) {
            for (int nextIfIndex : sw1PortsToSet) {
                this._currentOperationOnSw = this._sw1Base;
                if (((Boolean)sw1EmptyInI1Map.get(nextIfIndex)).booleanValue()) {
                    this.setIngress1Only(peerSw1, nextIfIndex, this._dto.getIngress1());
                    continue;
                }
                this.setIngress2Only(peerSw1, nextIfIndex, this._dto.getIngress1());
            }
        }
        if (sw2EgressChanged) {
            for (int nextIfIndex : sw2PortsToSet) {
                this._currentOperationOnSw = this._sw2Base;
                this.setEgressOnly(peerSw2, nextIfIndex, this._dto.getIngress1());
            }
        }
        if (sw1IngressChanged) {
            for (int nextIfIndex : sw1PortsToSet) {
                this._currentOperationOnSw = this._sw1Base;
                if (!((Boolean)sw1EmptyInI1Map.get(nextIfIndex)).booleanValue()) {
                    this.setIngress1Only(peerSw1, nextIfIndex, 0);
                    continue;
                }
                this.setIngress2Only(peerSw1, nextIfIndex, 0);
            }
        }
        if (sw2IngressChanged) {
            for (int nextIfIndex : sw2PortsToSet) {
                this._currentOperationOnSw = this._sw2Base;
                if (((Boolean)sw2EmptyInI1Map.get(nextIfIndex)).booleanValue()) {
                    this.setIngress1Only(peerSw2, nextIfIndex, this._dto.getEgress());
                    continue;
                }
                this.setIngress2Only(peerSw2, nextIfIndex, this._dto.getEgress());
            }
        }
        if (sw1EgressChanged) {
            for (int nextIfIndex : sw1PortsToSet) {
                this._currentOperationOnSw = this._sw1Base;
                this.setEgressOnly(peerSw1, nextIfIndex, this._dto.getEgress());
            }
        }
        if (sw2IngressChanged) {
            for (int nextIfIndex : sw2PortsToSet) {
                this._currentOperationOnSw = this._sw2Base;
                if (!((Boolean)sw2EmptyInI1Map.get(nextIfIndex)).booleanValue()) {
                    this.setIngress1Only(peerSw2, nextIfIndex, 0);
                    continue;
                }
                this.setIngress2Only(peerSw2, nextIfIndex, 0);
            }
        }
    }

    private void modifyExistingIsl(SnmpPeer peerSw1, SnmpPeer peerSw2) throws Exception {
        boolean sw1EmptyInI1 = false;
        boolean sw2EmptyInI1 = false;
        ESPDto dto1 = this.getFcspEsp(peerSw1, this._sw1Base, this._isl.getIfIndex1());
        ESPDto dto2 = this.getFcspEsp(peerSw2, this._sw2Base, this._isl.getIfIndex2());
        if (dto1 == null) {
            this._currentOperationOnSw = this._sw1Base;
            throw new Exception("Unable to modify existing ESP configuraton: Unable to retrieve existing configuration for both ISL ports.");
        }
        if (dto2 == null) {
            this._currentOperationOnSw = this._sw2Base;
            throw new Exception("Unable to modify existing ESP configuraton: Unable to retrieve existing configuration for both ISL ports.");
        }
        boolean sw1IngressChanged = true;
        boolean sw2IngressChanged = true;
        boolean sw1EgressChanged = true;
        boolean sw2EgressChanged = true;
        if (this._dto.getIngress1().equals(dto1.getIngress1()) || this._dto.getIngress1().equals(dto1.getIngress2())) {
            sw1IngressChanged = false;
        }
        if (this._dto.getEgress().equals(dto2.getIngress1()) || this._dto.getEgress().equals(dto2.getIngress2())) {
            sw2IngressChanged = false;
        }
        if (this._dto.getEgress().equals(dto1.getEgress())) {
            sw1EgressChanged = false;
        }
        if (this._dto.getIngress1().equals(dto2.getEgress())) {
            sw2EgressChanged = false;
        }
        if (sw1IngressChanged) {
            if (dto1.getIngress1().equals(dto2.getEgress())) {
                sw1EmptyInI1 = false;
            } else if (dto1.getIngress2().equals(dto2.getEgress())) {
                sw1EmptyInI1 = true;
            } else {
                throw new Exception("Unable to modify existing ESP configuraton: One of the ISLs ports Ingress SA1/Ingress SA2 doesn't match the connected ports Egress.");
            }
        }
        if (sw2IngressChanged) {
            if (dto2.getIngress1().equals(dto1.getEgress())) {
                sw2EmptyInI1 = false;
            } else if (dto2.getIngress2().equals(dto1.getEgress())) {
                sw2EmptyInI1 = true;
            } else {
                throw new Exception("Unable to modify existing ESP configuraton: One of the ISLs ports Ingress SA1/Ingress SA2 doesn't match the connected ports Egress.");
            }
        }
        if (sw1IngressChanged) {
            this._currentOperationOnSw = this._sw1Base;
            if (sw1EmptyInI1) {
                this.setIngress1Only(peerSw1, this._isl.getIfIndex1(), this._dto.getIngress1());
            } else {
                this.setIngress2Only(peerSw1, this._isl.getIfIndex1(), this._dto.getIngress1());
            }
        }
        if (sw2EgressChanged) {
            this._currentOperationOnSw = this._sw2Base;
            this.setEgressOnly(peerSw2, this._isl.getIfIndex2(), this._dto.getIngress1());
        }
        if (sw1IngressChanged) {
            this._currentOperationOnSw = this._sw1Base;
            if (!sw1EmptyInI1) {
                this.setIngress1Only(peerSw1, this._isl.getIfIndex1(), 0);
            } else {
                this.setIngress2Only(peerSw1, this._isl.getIfIndex1(), 0);
            }
        }
        if (sw2IngressChanged) {
            this._currentOperationOnSw = this._sw2Base;
            if (sw2EmptyInI1) {
                this.setIngress1Only(peerSw2, this._isl.getIfIndex2(), this._dto.getEgress());
            } else {
                this.setIngress2Only(peerSw2, this._isl.getIfIndex2(), this._dto.getEgress());
            }
        }
        if (sw1EgressChanged) {
            this._currentOperationOnSw = this._sw1Base;
            this.setEgressOnly(peerSw1, this._isl.getIfIndex1(), this._dto.getEgress());
        }
        if (sw2IngressChanged) {
            this._currentOperationOnSw = this._sw2Base;
            if (!sw2EmptyInI1) {
                this.setIngress1Only(peerSw2, this._isl.getIfIndex2(), 0);
            } else {
                this.setIngress2Only(peerSw2, this._isl.getIfIndex2(), 0);
            }
        }
    }

    private void setIngress1Only(SnmpPeer peerSw, int portIfIndex, Integer spi) throws SnmpException {
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.setIgnoreSetCount(true);
        pdu.setRetries(0);
        pdu.addVar(new SnmpOID(_CfcspIngressSA1Oid, portIfIndex), new SnmpInt(spi));
        peerSw.set(pdu);
    }

    private void setIngress2Only(SnmpPeer peerSw, int portIfIndex, Integer spi) throws SnmpException {
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.setIgnoreSetCount(true);
        pdu.setRetries(0);
        pdu.addVar(new SnmpOID(_CfcspIngressSA2Oid, portIfIndex), new SnmpInt(spi));
        peerSw.set(pdu);
    }

    private void setEgressOnly(SnmpPeer peerSw, int portIfIndex, Integer spi) throws SnmpException {
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.setIgnoreSetCount(true);
        pdu.setRetries(0);
        pdu.addVar(new SnmpOID(_CfcspEgressSAOid, portIfIndex), new SnmpInt(spi));
        peerSw.set(pdu);
    }

    private void setESP(SnmpPeer peerSw, int portIfIndex, Integer mode, Integer egress, Integer ingress1, Integer ingress2) throws SnmpException {
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.setIgnoreSetCount(true);
        pdu.setRetries(0);
        pdu.addVar(new SnmpOID(_CfcspEspRowStatus, portIfIndex), CREATE_AND_GO);
        if (ingress1 != null) {
            pdu.addVar(new SnmpOID(_CfcspIngressSA1Oid, portIfIndex), new SnmpInt(ingress1));
        }
        if (ingress2 != null) {
            pdu.addVar(new SnmpOID(_CfcspIngressSA2Oid, portIfIndex), new SnmpInt(ingress2));
        }
        pdu.addVar(new SnmpOID(_CfcspEgressSAOid, portIfIndex), new SnmpInt(egress));
        pdu.addVar(new SnmpOID(_CfcspESPModeOid, portIfIndex), new SnmpInt(mode));
        pdu.addVar(new SnmpOID(_CfcspEspSAMethod, portIfIndex), new SnmpInt(2));
        peerSw.set(pdu);
    }

    private void deleteESP(SnmpPeer peerSw, int portIfIndex) throws SnmpException {
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.setIgnoreSetCount(true);
        pdu.setRetries(0);
        pdu.addVar(new SnmpOID(_CfcspEspRowStatus, portIfIndex), DESTROY);
        peerSw.set(pdu);
    }

    private Map<Integer, ESPDto> getFcspEsp(SnmpPeer peer, SwitchBase sw, int[] ifIndexes) throws SnmpException {
        HashMap<Integer, ESPDto> results = new HashMap<Integer, ESPDto>();
        for (int nextIfIndex : ifIndexes) {
            results.put(nextIfIndex, this.getFcspEsp(peer, sw, nextIfIndex));
        }
        return results;
    }

    private ESPDto getFcspEsp(SnmpPeer peer, SwitchBase sw, int ifIndex) throws SnmpException {
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList(5));
        pdu.addNull(new SnmpOID(_CfcspESPModeOid, ifIndex));
        pdu.addNull(new SnmpOID(_CfcspIngressSA1Oid, ifIndex));
        pdu.addNull(new SnmpOID(_CfcspIngressSA2Oid, ifIndex));
        pdu.addNull(new SnmpOID(_CfcspEgressSAOid, ifIndex));
        pdu.addNull(new SnmpOID(_CfcspEspSAMethod, ifIndex));
        VarBindList resp = peer.send(pdu).getVariables();
        int espMode = resp.intValue(0);
        int ingressSa1 = resp.intValue(1);
        int ingressSa2 = resp.intValue(2);
        int egressSa = resp.intValue(3);
        int keyGenMethod = resp.intValue(4);
        ESPDto dto = new ESPDto(sw, espMode, ingressSa1, ingressSa2, egressSa, ifIndex, keyGenMethod);
        return dto;
    }
}

