/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.event;

import com.cisco.dcbu.lib.channel.ChannelIf;
import com.cisco.dcbu.lib.mds.TrapRegister;
import com.cisco.dcbu.lib.mds.TrapRegisterListener;
import com.cisco.dcbu.lib.mds.TrapRegistrationEvent;
import com.cisco.dcbu.lib.rmi.ChannelConsumerRif;
import com.cisco.dcbu.lib.serviceconf.AbstractService;
import com.cisco.dcbu.lib.serviceconf.ServiceConfig;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.sm.FMStandalone;
import com.cisco.dcbu.sm.common.event.LogEvent;
import com.cisco.dcbu.sm.common.event.SnmpTrapEntry;
import com.cisco.dcbu.sm.common.event.SyslogEntry;
import com.cisco.dcbu.sm.common.model.SwitchIf;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.server.em.EventManagerService;
import com.cisco.dcbu.sm.server.event.EmcCallHomeHandler;
import com.cisco.dcbu.sm.server.event.SMISNotifications;
import com.cisco.dcbu.sm.server.event.TrapHandler;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.LanImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class EventControllerService
extends AbstractService
implements ChannelConsumerRif,
Runnable,
TrapRegisterListener {
    public static final String PROP_CALL_HOME_ENABLE = "server.callhome.enable";
    private static final int MAX_SYSLOG_ENTRIES = 3;
    private static final int MAX_TRAP_ENTRIES = 10;
    private static final int SMIS_TIMER_DELAY = 10000;
    private static final int SMIS_TIMER_PERIOD = 300000;
    protected ThreadGroup _threadGroup = new ThreadGroup(this.getClass().getName());
    protected Thread _serviceThread;
    private EventManagerService _eventMgr;
    private LinkedList _eventQueue;
    private TrapHandler _trapHandler;
    private InetAddress _trapRefAddress;
    private InetAddress _trapPropRegAddr;
    static final int[] _SnmpTargetOid = MibNode.get("snmpTargetAddrTAddress").getOid();
    static final int[] _SysLogOid = MibNode.get("cseSyslogServerAddressType").getOid();
    static final int[] _SysLogSeverityOid = MibNode.get("cseSyslogMessageSeverity").getOid();
    static final int SYSLOG_SEVERITY_INFO = 7;
    static Logger _Logger = LogManager.getLogger((String)"fms.em");

    public EventControllerService() {
        super("Event Controller Service");
    }

    @Override
    protected void initImpl(Object[] params) throws Exception {
        int rmiPort;
        Registry registry;
        this._eventQueue = new LinkedList();
        this._trapHandler = new TrapHandler();
        if (!FMStandalone.isStandAlone()) {
            if (SMISNotifications.initSmisStatus()) {
                _Logger.debug((Object)"SMIS service is detected in EventController Service startup");
                SMISNotifications.getInstance();
            } else {
                _Logger.debug((Object)"No SMIS service is detected in EventController Service startup for the first try ...");
                new Timer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        if (SMISNotifications.initSmisStatus()) {
                            _Logger.debug((Object)"SMIS service is detected in EventController Service startup for another try");
                            SMISNotifications.getInstance();
                            this.cancel();
                        } else {
                            _Logger.debug((Object)"No SMIS service is detected in EventController Service startup for another try...");
                        }
                    }
                }, 10000L, 300000L);
            }
        }
        if ((registry = LocateRegistry.getRegistry(rmiPort = Integer.getInteger("java.rmi.registry.port", 4447).intValue())) == null) {
            return;
        }
        this._eventMgr = (EventManagerService)ServiceConfig.findService("Event Manager Service");
        this._eventMgr.addConsumer((ChannelConsumerRif)this, null, TrapHandler._FilteredOids);
        String value = System.getProperty("trap.registaddress");
        if (value != null && value.trim().length() > 0) {
            try {
                this._trapPropRegAddr = NetUtil.getLocalAddressByName(value.trim());
            }
            catch (Exception ex) {
                _Logger.warn((Object)"Invalid trap.registaddress value in server configuration file");
            }
        }
        TrapRegister.getInstance().addTrapRegisterListener(this);
        this._serviceThread = new Thread(this._threadGroup, this, this.getName());
    }

    @Override
    protected void startImpl() throws Exception {
        this._serviceThread.start();
    }

    @Override
    protected void stopImpl() {
        if (!FMStandalone.isStandAlone() && SMISNotifications.isSmisEnable()) {
            SMISNotifications.getInstance().stop();
        }
        this._serviceThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            if (this.getSize() == 0) {
                try {
                    LinkedList linkedList = this._eventQueue;
                    synchronized (linkedList) {
                        this._eventQueue.wait();
                    }
                }
                catch (InterruptedException ie) {}
                continue;
            }
            Object curEvt = null;
            LinkedList linkedList = this._eventQueue;
            synchronized (linkedList) {
                try {
                    curEvt = this._eventQueue.getFirst();
                }
                catch (NoSuchElementException ex) {
                    _Logger.warn((Object)"event queue getFirst error");
                    continue;
                }
                this._eventQueue.removeFirst();
            }
            if (curEvt instanceof TrapRegistrationEvent) {
                FabricPK[] pks;
                _Logger.log((Priority)Level.DEBUG, (Object)curEvt.toString());
                TrapRegistrationEvent trapEvent = (TrapRegistrationEvent)curEvt;
                for (FabricPK fKey : pks = SanManager.getInstance().getFabricPKs()) {
                    SwitchImpl sw = SanManager.getInstance().findSwitch(trapEvent._ip, fKey);
                    if (sw == null || !trapEvent._success) continue;
                    sw.setTrapRegistered(trapEvent._type == 1);
                }
                EthSwitchImpl ethSw = DCManager.getInstance().findEthSwitchBySwIp(trapEvent._ip);
                if (ethSw == null) continue;
                ethSw.setTrapRegistered(trapEvent._type == 1);
                continue;
            }
            _Logger.log((Priority)Level.INFO, (Object)"a trap dispatch to trap handler");
            this._trapHandler.trapReceived((SnmpTrapEntry)curEvt);
            if (SMISNotifications.isSmisEnable()) {
                _Logger.log((Priority)Level.INFO, (Object)("a trap dispatch to trap handle, isSmisEnable" + SMISNotifications.isSmisEnable()));
                SMISNotifications.getInstance().trapReceived((SnmpTrapEntry)curEvt);
            }
            if (!Boolean.getBoolean(PROP_CALL_HOME_ENABLE)) continue;
            EmcCallHomeHandler.getInstance().trapReceived((SnmpTrapEntry)curEvt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSize() {
        LinkedList linkedList = this._eventQueue;
        synchronized (linkedList) {
            return this._eventQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consume(ChannelIf channel, Object evtObj) throws RemoteException {
        LinkedList linkedList = this._eventQueue;
        synchronized (linkedList) {
            this._eventQueue.add(evtObj);
            this._eventQueue.notifyAll();
        }
    }

    public void publishEvent(LogEvent evt) {
        try {
            this._eventMgr.sendEvent(evt);
        }
        catch (Exception ex) {
            _Logger.log((Priority)Level.WARN, (Object)"Event Manager SendEvent", (Throwable)ex);
        }
    }

    public void publishAccounting(SyslogEntry se) {
        try {
            this._eventMgr.sentAccounting(se);
        }
        catch (Exception ex) {
            _Logger.log((Priority)Level.WARN, (Object)"Event Manager SendAccounting", (Throwable)ex);
        }
    }

    public boolean isTrapListening() {
        try {
            return this._eventMgr.isTrapListening();
        }
        catch (Exception ex) {
            _Logger.log((Priority)Level.ERROR, (Object)"Event Manager isTrapListening", (Throwable)ex);
            return false;
        }
    }

    public InetAddress getTrapRefAddress() {
        return this._trapRefAddress;
    }

    public int getTrapPort() {
        try {
            return this._eventMgr.getTrapPort();
        }
        catch (Exception ex) {
            _Logger.log((Priority)Level.WARN, (Object)"Event Manager getTrapPort", (Throwable)ex);
            return 0;
        }
    }

    public String getStatus() {
        try {
            return this._eventMgr.getStatus();
        }
        catch (Exception ex) {
            _Logger.log((Priority)Level.ERROR, (Object)"Event Manager getStatus", (Throwable)ex);
            return null;
        }
    }

    public void addSource(SwitchIf<PKIf> sw) {
        try {
            if (sw.getInetAddress() != null) {
                this._eventMgr.addSource(sw.getInetAddress());
            }
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Register with event manager for " + sw + " error: " + ex.getMessage()));
        }
    }

    public void registerTrap(SnmpPeer peer) {
        InetAddress regaddr = null;
        String value = System.getProperty("trap.registaddress");
        if (value != null && value.trim().length() != 0) {
            _Logger.info((Object)"parse user supplied regsitering address");
            try {
                regaddr = NetUtil.getLocalAddressByName(value);
            }
            catch (Exception ex) {
                _Logger.warn((Object)"Invalid trap.registaddress value in server configuration file");
            }
        }
        try {
            InetSocketAddress socketAddr = TrapRegister.getInstance().asyncRegister(peer, regaddr, this.getTrapPort(), false);
            this._trapRefAddress = socketAddr.getAddress();
            if (_Logger.isDebugEnabled()) {
                _Logger.debug((Object)("trap destination registered on " + peer.getAddress().getHostAddress() + " with " + socketAddr));
            }
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Register trap at " + peer.getAddress().getHostAddress() + " error: " + ex.getMessage()));
        }
    }

    public void delSource(SwitchIf<PKIf> sw) {
        try {
            if (sw.getInetAddress() != null) {
                this._eventMgr.deleteSource(sw.getInetAddress());
            }
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Deregister with event manager for " + sw + " error: " + ex.getMessage()));
        }
    }

    public void deregisterTrap(SnmpPeer peer, CountDownLatch doneSignal) {
        try {
            TrapRegister.getInstance().asyncDeregister(peer, doneSignal);
            if (_Logger.isDebugEnabled()) {
                _Logger.debug((Object)("trap deregistered on " + peer.getAddress().getHostAddress()));
            }
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Deregistering trap on " + peer.getAddress().getHostAddress() + " error: " + ex.getMessage()));
        }
    }

    public void deregisterTrap(SnmpPeer peer) {
        try {
            TrapRegister.getInstance().asyncDeregister(peer);
            if (_Logger.isDebugEnabled()) {
                _Logger.debug((Object)("trap deregistered on " + peer.getAddress().getHostAddress()));
            }
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Deregistering trap on " + peer.getAddress().getHostAddress() + " error: " + ex.getMessage()));
        }
    }

    public HashMap getEventSrcs() {
        List<EthSwitchImpl> ethSws;
        ArrayList<SnmpPeer> sourceSws = new ArrayList<SnmpPeer>();
        SanManager sm = SanManager.getInstance();
        FabricPK[] fPks = sm.getFabricPKs();
        for (int j = 0; j < fPks.length; ++j) {
            FabricPK fPk = fPks[j];
            FabricImpl fabric = sm.findFabric(fPk);
            if (fabric == null) continue;
            SwitchImpl[] sws = fabric.getSwitches();
            for (int k = 0; k < sws.length; ++k) {
                if (!sws[k].isManageableMDS() || !sws[k].isPeerCreated()) continue;
                try {
                    sourceSws.add(sws[k].createPeer());
                    continue;
                }
                catch (SnmpException se) {
                    // empty catch block
                }
            }
        }
        LanImpl lan = DCManager.getInstance().getLan();
        if (lan != null && (ethSws = lan.getEthSwitches()) != null) {
            for (EthSwitchImpl s : ethSws) {
                if (!s.isManageable() || !s.isPeerCreated()) continue;
                sourceSws.add(s.getPeer());
            }
        }
        return this.getEventSrcs(sourceSws);
    }

    public HashMap getEventSrcs(String switchIpAddr) {
        LanImpl lan;
        ArrayList<SnmpPeer> sourceSws = new ArrayList<SnmpPeer>();
        SanManager sm = SanManager.getInstance();
        FabricImpl fabric = null;
        try {
            fabric = sm.findFabric(switchIpAddr);
        }
        catch (Exception ex) {
            _Logger.info((Object)("Error looking up fabric by " + switchIpAddr + ": " + ex.getMessage()));
        }
        if (fabric != null) {
            SwitchImpl[] sws = fabric.getSwitches();
            for (int k = 0; k < sws.length; ++k) {
                if (!sws[k].isManageableMDS() || !sws[k].isPeerCreated()) continue;
                try {
                    sourceSws.add(sws[k].createPeer());
                    continue;
                }
                catch (SnmpException se) {
                    // empty catch block
                }
            }
        }
        if ((lan = DCManager.getInstance().getLan()) != null) {
            try {
                EthSwitchImpl s = lan.findEthSwitchByIp(InetAddress.getByName(switchIpAddr));
                if (s != null && s.isManageable() && s.isPeerCreated()) {
                    sourceSws.add(s.getPeer());
                }
            }
            catch (UnknownHostException e) {
                _Logger.info((Object)("Error looking up ethswitch by " + switchIpAddr + ": " + e.getMessage()));
            }
        }
        return this.getEventSrcs(sourceSws);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap getEventSrcs(ArrayList<SnmpPeer> sourceSws) {
        String[] localAddrs;
        if (sourceSws == null || sourceSws.size() == 0) {
            return new HashMap();
        }
        int pending = sourceSws.size() * 2;
        Object lock = new Object();
        if (this._trapPropRegAddr == null && (localAddrs = NetUtil.getLocalIPAddresses()) == null) {
            return null;
        }
        CheckSrcCb cbs = new CheckSrcCb(lock, pending);
        for (int i = 0; i < sourceSws.size(); ++i) {
            int numTries = 48;
            SnmpPeer peer = sourceSws.get(i);
            VarBindList vbl = new VarBindList(1);
            vbl.add(new SnmpVarBind(new SnmpOID(_SnmpTargetOid)));
            try {
                new SnmpFetch().getBulk(peer, vbl, 10, cbs);
            }
            catch (SnmpException e) {
                // empty catch block
            }
            SnmpPDU pdu = new SnmpPDU(-91, new VarBindList());
            pdu.setMaxRptr(3);
            pdu.setNonRptr(1);
            pdu.addNull(new SnmpOID(MibNode.get("cseSyslogMessageSeverity").getOid(), 1239));
            pdu.addNull(new SnmpOID(_SysLogOid));
            pdu.addNull(new SnmpOID(MibNode.get("cseSyslogServerAddress").getOid()));
            try {
                peer.send(pdu, cbs);
                continue;
            }
            catch (SnmpException ex) {
                // empty catch block
            }
        }
        while (!cbs.done()) {
            Object i = lock;
            synchronized (i) {
                if (!cbs.done()) {
                    try {
                        lock.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
            }
        }
        HashMap results = cbs.getResults();
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void trapRegisterStatusChanged(TrapRegistrationEvent event) {
        LinkedList linkedList = this._eventQueue;
        synchronized (linkedList) {
            this._eventQueue.add(event);
            this._eventQueue.notifyAll();
        }
    }

    class CheckSrcCb
    implements SnmpCallbackIf {
        Object _lock;
        HashMap<InetAddress, List<Object>> _results;
        int _requests;

        CheckSrcCb(Object lock, int requests) {
            this._lock = lock;
            this._results = new HashMap();
            this._requests = requests;
        }

        boolean done() {
            return this._requests <= 0;
        }

        HashMap getResults() {
            return this._results;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
            Object[] objs;
            InetAddress addr;
            boolean sendSyslogAccting;
            boolean b;
            int state;
            block22: {
                state = -1;
                b = false;
                sendSyslogAccting = false;
                addr = pdu.getAddress();
                if (timedOut) {
                    state = 0;
                    _Logger.info((Object)("Error checking syslog srcs SNMP Timeout " + pdu.getAddress()));
                } else if (pdu.getError() != 0) {
                    state = 0;
                    _Logger.info((Object)("Error checking syslog srcs " + SnmpException.toError(pdu.getError()) + " from " + pdu.getAddress()));
                } else {
                    VarBindList vbl = pdu.getVariables();
                    if (vbl.size() > 0) {
                        int[] firstOid = vbl.getVb(0).getOid().getValue();
                        if (SnmpOID.startsWith(firstOid, _SysLogSeverityOid)) {
                            state = 2;
                            String dnsName = "";
                            InetAddress[] addrs = NetUtil.getLocalAddresses();
                            int lens = addrs == null ? 0 : addrs.length;
                            sendSyslogAccting = firstOid[firstOid.length - 1] == 1240 && vbl.intValue(0) == 7;
                            for (int j = 0; j < lens; ++j) {
                                for (int i = 1; i < vbl.size() && !b; i += 2) {
                                    b = vbl.intValue(i) == 16 ? dnsName.equals(vbl.stringValue(i + 1)) || NetUtil.getHostAddress(addrs[j]).equals(vbl.stringValue(i + 1)) : SnmpString.equals(addrs[j].getAddress(), vbl.byteValue(i + 1));
                                    if (!b) {
                                        continue;
                                    }
                                    break block22;
                                }
                            }
                        } else if (SnmpOID.startsWith(firstOid, _SnmpTargetOid)) {
                            SnmpVarBind vb;
                            byte[] value;
                            state = 1;
                            for (int i = 0; i < vbl.size() && (value = ((SnmpString)(vb = vbl.getVb(i)).getVar()).getValue()) != null && value.length == 6; ++i) {
                                byte[] ipbytes = new byte[4];
                                System.arraycopy(value, 0, ipbytes, 0, 4);
                                try {
                                    if (!NetUtil.isLocalHost(InetAddress.getByAddress(ipbytes))) continue;
                                    b = true;
                                    break;
                                }
                                catch (UnknownHostException e) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
            }
            List<Object> peer2Srcs = this._results.get(addr);
            if (peer2Srcs == null) {
                peer2Srcs = new ArrayList<Object>(0);
                this._results.put(addr, peer2Srcs);
            }
            if (state == 1) {
                objs = new Object[]{addr, new Integer(1), b ? Boolean.TRUE : Boolean.FALSE};
                peer2Srcs.add(objs);
            } else if (state == 2) {
                objs = new Object[]{addr, new Integer(2), b ? Boolean.TRUE : Boolean.FALSE};
                peer2Srcs.add(objs);
                objs = new Object[]{addr, new Integer(5), sendSyslogAccting};
                peer2Srcs.add(objs);
            }
            --this._requests;
            if (this._requests == 0) {
                Object object = this._lock;
                synchronized (object) {
                    this._lock.notifyAll();
                }
            }
        }
    }
}

