/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.event;

import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.event.EventEntity;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

public class EventUtil {
    private static EventUtil _Instance = null;
    static String _EvtQueryById = "select source, switch.sys_name, severity, host_time, descr, fabric.name from events left join fabric on fabricid=fabric.id left join switch on switchid = switch.id where eventid = ?";
    static final String[] SEVERITY_LABELS = new String[]{"Emergency", "Alert", "Critical", "Error", "Warning", "Notice", "Info", "Debug"};

    public static EventUtil getInstance() {
        if (_Instance == null) {
            _Instance = new EventUtil();
        }
        return _Instance;
    }

    private EventUtil() {
    }

    public EventEntity getEvtEntity(long evtId) throws Exception {
        EventEntity base = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = ConnectionManager.getConnection();
            pstmt = conn.prepareStatement(_EvtQueryById);
            pstmt.setLong(1, evtId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                String source = rs.getString(1);
                String swName = rs.getString(2);
                int severity = rs.getInt(3);
                Timestamp hostTime = rs.getTimestamp(4);
                String dscr = rs.getString(5);
                String fname = rs.getString(6);
                base = new EventEntity(source, dscr, SEVERITY_LABELS[severity], this.getTimeDisplay(hostTime), swName == null ? "" : swName, fname == null ? "" : fname);
            }
        }
        catch (Exception ex) {
            try {
                throw new Exception(ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(pstmt);
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(pstmt);
        DbUtil.close(conn);
        return base;
    }

    public String getTimeDisplay(Date hostTime) {
        if (hostTime == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd-HH:mm");
        return sdf.format(hostTime);
    }

    public static void main(String[] args) {
        try {
            EventEntity test = EventUtil.getInstance().getEvtEntity(9099460L);
            boolean bl = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

