/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.facade;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.snmp.security.CommunityUser;
import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.lib.snmp.security.UsmUser;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.lib.util.TFTP;
import com.cisco.dcbu.lib.util.jboss_4_2.JBoss_4_2Encrypter;
import com.cisco.dcbu.sm.common.dto.DMMPeerCfg;
import com.cisco.dcbu.sm.common.dto.SSHConfigInfo;
import com.cisco.dcbu.sm.common.dto.SSHConfigKey;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.model.EnclosureBase;
import com.cisco.dcbu.sm.common.model.EndPortBase;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.model.ddm.DDMDppVi;
import com.cisco.dcbu.sm.common.model.ddm.DDMJob;
import com.cisco.dcbu.sm.common.model.ddm.DDMSession;
import com.cisco.dcbu.sm.common.model.ddm.DDMSwitch;
import com.cisco.dcbu.sm.common.rif.DDMCreationRif;
import com.cisco.dcbu.sm.common.rif.DDMServerRif;
import com.cisco.dcbu.sm.common.rif.DMMException;
import com.cisco.dcbu.sm.common.rif.SessionRif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.ServerRefFactory;
import com.cisco.dcbu.sm.server.bean.SessionHelper;
import com.cisco.dcbu.sm.server.dmm.DMMHelper;
import com.cisco.dcbu.sm.server.dmm.Mediator;
import com.cisco.dcbu.sm.server.dmm.MediatorFactory;
import com.cisco.dcbu.sm.server.dmm.SshMediator;
import com.cisco.dcbu.sm.server.dmm.SshMediatorRespPdu;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobActionReq;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobActionResp;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobInfo;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobInfraCreateReq;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobInfraCreateResp;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobModifyReq;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobQueryReq;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobQueryResp;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobSchedReq;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobSessionInfo;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobSessionQueryReq;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmJobSessionQueryResp;
import com.cisco.dcbu.sm.server.facade.DDMCreationImpl;
import com.cisco.dcbu.sm.server.facade.QueryThread;
import com.cisco.dcbu.sm.server.facade.RunPDUSetThread;
import com.cisco.dcbu.sm.server.facade.SetCppIPAddressThread;
import com.cisco.dcbu.sm.server.facade.SetVSANIPAddressThread;
import com.cisco.dcbu.sm.server.facade.StopWatch;
import com.cisco.dcbu.sm.server.facade.ViQueryThread;
import com.cisco.dcbu.sm.server.facade.createPeerRoutesThread;
import com.cisco.dcbu.sm.server.facade.setCppRouteToVsan1Thread;
import com.cisco.dcbu.sm.server.inventory.InventoryManager;
import com.cisco.dcbu.sm.server.model.EnclosureImpl;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.security.FMUser;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class DDMServerImpl
implements DDMServerRif,
Serializable {
    public static boolean _FmStandalone = Boolean.getBoolean("fm.standalone");
    static final int[] _CssServiceActivationOid = MibNode.get("cssServiceActivation").getOid();
    static final int[] _CssKeyNBitsOid = MibNode.get("cssKeyNBits").getOid();
    static final int[] _CssKeyRowStatusOid = MibNode.get("cssKeyRowStatus").getOid();
    static final int[] _CiiIPIfAddressPrefixLengthOid = MibNode.get("ciiIPIfAddressPrefixLength").getOid();
    static final int[] _CiiIPIfAddressStatusOid = MibNode.get("ciiIPIfAddressStatus").getOid();
    static final int[] _VirtualNwIfRowStatusOid = MibNode.get("virtualNwIfRowStatus").getOid();
    static final int[] _IpForwardingOid = MibNode.get("ipForwarding").getOid();
    static final int[] _CInetCidrRouteNextHopTypeOid = MibNode.get("cInetCidrRouteNextHopType").getOid();
    static final int[] _CInetCidrRouteNextHopOid = MibNode.get("cInetCidrRouteNextHop").getOid();
    static final int[] _CInetCidrRouteIfIndexOid = MibNode.get("cInetCidrRouteIfIndex").getOid();
    static final int[] _CInetCidrRouteTypeOid = MibNode.get("cInetCidrRouteType").getOid();
    static final int[] _CInetCidrRouteMetric1Oid = MibNode.get("cInetCidrRouteMetric1").getOid();
    static final int[] _CInetCidrRouteStatusOid = MibNode.get("cInetCidrRouteStatus").getOid();
    static final int[] _IfPhysAddressOid = MibNode.get("ifPhysAddress").getOid();
    static final int[] _EntPhysicalIndex = MibNode.get("entPhysicalIndex").getOid();
    static final int[] _SsmSsnProvFeatureStartNode = MibNode.get("ssmSsnProvFeatureStartNode").getOid();
    static final int[] _SsmSsnProvFeatureEndNode = MibNode.get("ssmSsnProvFeatureEndNode").getOid();
    static final int[] _SsmSsnProvFeatureName = MibNode.get("ssmSsnProvFeatureName").getOid();
    static final int[] _SsmSsnProvFeatureRowStatus = MibNode.get("ssmSsnProvFeatureRowStatus").getOid();
    static final int[] _SsmProvFeatureIfRowStatus = MibNode.get("ssmProvFeatureIfRowStatus").getOid();
    static final int[] _ifAdminStatusOid = MibNode.get("ifAdminStatus").getOid();
    public static final int ADMIN_STATUS_ENABLE = 1;
    public static final int ADMIN_STATUS_DISABLE = 2;
    static final int SSH_RSA_PROTOCOL = 1;
    static final int SSH_DSA_PROTOCOL = 3;
    static final SnmpInt CREATE_AND_GO = new SnmpInt(4);
    public static final String DMM_MIN_VERSION = "6.2(1)";
    static byte DMM_PDU_VERSION = 1;
    static boolean _Simulation = true;
    transient Logger _logger = null;
    private SessionRif _session;
    private FMUser _user;
    private HashMap _jobs;
    private transient DMMHelper _helper;
    private int _reqId = 1;
    Map s_ssmIpMap = new HashMap();

    public DDMServerImpl(boolean sessionB) throws RemoteException {
        this._user = null;
    }

    @Override
    public void init(SessionRif session) throws RemoteException {
        this._logger = LogManager.getLogger((String)"dmm");
        if (this._session == null) {
            this._session = session;
        }
        if (this._user == null) {
            this._user = this._session.getUser();
        }
        this._jobs = new HashMap();
        this._helper = DMMHelper.getInstance();
    }

    private EnclosureBase[] getServerHostsForStorage(DDMJob job) throws RemoteException {
        Map host1 = this.getServerHosts(job, job.getSsm1().getSwitch().getFabricPK());
        if (job.getSsm2() != null) {
            Map host2 = this.getServerHosts(job, job.getSsm2().getSwitch().getFabricPK());
            host1.putAll(host2);
        }
        Collection values = host1.values();
        EnclosureBase[] ret = new EnclosureBase[values.size()];
        int i = 0;
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            ret[i] = (EnclosureBase)iter.next();
            ++i;
        }
        return ret;
    }

    public DDMServerImpl(SessionRif session) throws RemoteException {
        this._logger = LogManager.getLogger((String)"FM");
        this._session = session;
        this._user = this._session.getUser();
        this._jobs = new HashMap();
        this._helper = DMMHelper.getInstance();
    }

    @Override
    public EndPortBase[] getEndPorts(EnclosureBase encl) throws RemoteException {
        return this._helper.getEndPort(encl, this._session.getManageableFabrics());
    }

    @Override
    public EndPortBase[] getEndPorts(EnclosureBase encl, FabricPK[] fabrics) throws RemoteException {
        return this._helper.getEndPort(encl, fabrics);
    }

    @Override
    public int getVsanIfHostTargetInSameZoneMember(FabricPK fPk, EndPortBase[] hostPorts, EndPortBase[] storagePorts, List<Integer> vsanIds) throws RemoteException {
        SanManager sanManager = SanManager.getInstance();
        FabricImpl fabric = sanManager.findFabric(fPk);
        return this._helper.getVsanIfHostTargetInSameZoneMember(fabric, hostPorts, storagePorts, vsanIds);
    }

    private Map getServerHosts(DDMJob job, FabricPK fPk) throws RemoteException {
        return this.getServerHosts(job.getMethod(), job.getExisitingStoragesEndPorts(), job.getNewStoragesEndPorts(), fPk);
    }

    @Override
    public Map getServerHosts(byte methodType, EndPortBase[] existingStorage, EndPortBase[] newStorage, FabricPK fPk) throws RemoteException {
        SanManager sanManager = SanManager.getInstance();
        EnclosureImpl[] hosts = sanManager.getEnclosures();
        HashMap<EnclosureBase, EnclosureBase> ret = new HashMap<EnclosureBase, EnclosureBase>();
        for (int i = 0; i < hosts.length; ++i) {
            List<FabricPK> list;
            EnclosureBase base = (EnclosureBase)hosts[i].getBaseObject();
            if (base.isStorage() || this.isInternal(base) || (list = hosts[i].getConnectedFabrics()) == null) continue;
            for (int k = 0; k < list.size(); ++k) {
                FabricPK fabricPK = list.get(k);
                if (fabricPK == null || !fabricPK.equals(fPk)) continue;
                FabricImpl fabric = sanManager.findFabric(fabricPK);
                EndPortBase[] endPort = this._helper.getEndPort((EnclosureBase)hosts[i].getBaseObject(), fabricPK);
                if (!this.isEndPortUp(endPort, fabricPK)) continue;
                List<Integer> vsanId = null;
                vsanId = methodType != -35 ? this._helper.findCommonVsanId(endPort, existingStorage, newStorage, fPk) : this._helper.findCommonVsanIds(endPort, existingStorage, fPk);
                if (fabric == null || vsanId.size() <= 0 || !this._helper.isHostTargetInSameZoneMember(fabric, (EnclosureBase)hosts[i].getBaseObject(), existingStorage, vsanId)) continue;
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug((Object)("getServerHosts: " + vsanId + " " + (EnclosureBase)hosts[i].getBaseObject() + " Fabric PK:" + fPk));
                }
                ret.put((EnclosureBase)hosts[i].getBaseObject(), (EnclosureBase)hosts[i].getBaseObject());
            }
        }
        return ret;
    }

    boolean isEndPortUp(EndPortBase[] endports, FabricPK fpk) {
        boolean ret = false;
        for (int i = 0; i < endports.length; ++i) {
            if (!endports[i].getFabricPK().equals(fpk)) continue;
            return endports[i].isPresent();
        }
        return ret;
    }

    @Override
    public DDMCreationRif createJob(DDMJob job) throws RemoteException {
        DDMCreationRif rif = null;
        DMMHelper.getInstance().fillEndPort(job, this._session.getManageableFabrics());
        if (job.getType() == -69) {
            job.setServerHostsForStorage(this.getServerHostsForStorage(job));
        }
        rif = ServerRefFactory.getInstance().getDDMCreation(this._session, job, this._user, this, true);
        DDMCreationImpl impl = new DDMCreationImpl();
        impl.setContext(this._session, job, this._user, true);
        if (!_FmStandalone) {
            SessionHelper.getInstance().register(impl);
        }
        return rif;
    }

    @Override
    public void modifyJob(DDMJob job) throws RemoteException {
        this.modifyJob(job, job.getSsm1());
        if (job.getSsm2() != null) {
            this.modifyJob(job, job.getSsm2());
        }
        if (job.getMethod3DataMoverSSM() != null) {
            this.modifyJob(job, job.getMethod3DataMoverSSM());
        }
    }

    @Override
    public void verifyJob(DDMJob job) throws DMMException {
        DDMSession[] sessions = job.getSessions();
        if (sessions == null) {
            sessions = this.findAllSessionByJobId(job);
            job.setSessions(sessions);
        }
        if (job.getMethod() != -35) {
            boolean anyFirst = false;
            boolean anySecond = false;
            for (DDMSession nextSession : sessions) {
                if (nextSession.getOnSSM() == 1) {
                    anyFirst = true;
                } else {
                    anySecond = true;
                }
                if (anyFirst && anySecond) break;
            }
            if (anyFirst) {
                this.verifyJob(job, job.getSsm1());
            }
            if (job.getSsm2() != null && anySecond) {
                this.verifyJob(job, job.getSsm2());
            }
        } else {
            this.verifyJob(job, job.getMethod3DataMoverSSM());
        }
    }

    public void modifyJob(DDMJob job, DDMSwitch ssm) throws DMMException {
        Mediator mediator = null;
        try {
            mediator = this.getMediatorFromJob(job, ssm);
            DmmJobModifyReq reqPdu = new DmmJobModifyReq();
            reqPdu.setJobId(job.getId());
            reqPdu.setJobName(job.getName());
            reqPdu.setAttrBitMap((short)256);
            reqPdu.setJobRate(job.getRate());
            reqPdu.setPduHdr(SshMediator.getHeader((byte)50, reqPdu));
            reqPdu.getPduHdr().setLength((short)(reqPdu.toByteArray().length * 2));
            DmmJobInfraCreateResp resp1 = (DmmJobInfraCreateResp)mediator.sendRecv((short)50, reqPdu);
            if (resp1.getStatus() == 0) {
                return;
            }
            this.checkRespPdu(ssm + ":" + "Failed to modify job : ", resp1);
        }
        catch (Exception t) {
            throw new DMMException(t.toString());
        }
        finally {
            if (mediator != null) {
                mediator.disconnect();
            }
        }
    }

    public void verifyJob(DDMJob job, DDMSwitch ssm) throws DMMException {
        Mediator mediator = null;
        try {
            mediator = this.getMediatorFromJob(job, ssm);
            DmmJobActionReq reqPdu = new DmmJobActionReq();
            reqPdu.setJobId(job.getId());
            reqPdu.setAction((byte)-86);
            reqPdu.setPduHdr(SshMediator.getHeader((byte)21, reqPdu));
            reqPdu.getPduHdr().setLength((short)(reqPdu.toByteArray().length * 2));
            DmmJobActionResp resp1 = (DmmJobActionResp)mediator.sendRecv((short)21, reqPdu);
            if (resp1.getStatus() == 0) {
                return;
            }
            this.checkRespPdu(ssm + ":" + "Failed to verify job : ", resp1);
        }
        catch (Exception t) {
            throw new DMMException(t.toString());
        }
        finally {
            if (mediator != null) {
                mediator.disconnect();
            }
        }
    }

    @Override
    public String getJobLog(DDMJob job) throws DMMException {
        return this.getJobLog(job, true);
    }

    public String getJobLog(DDMJob job, boolean retrieveError) throws DMMException {
        String ret = "";
        try {
            if (job.getSsm1() != null) {
                ret = "SSM1:\n" + this.getJobLogFromSsm(job, job.getSsm1(), "_1.log", retrieveError, ret);
            }
            if (job.getSsm2() != null) {
                ret = ret + "\nSSM2: \n" + this.getJobLogFromSsm(job, job.getSsm2(), "_2.log", retrieveError, ret);
            }
            if (job.getMethod3DataMoverSSM() != null) {
                ret = ret + "\nData Mover SSM: \n" + this.getJobLogFromSsm(job, job.getMethod3DataMoverSSM(), "_DataMover.log", retrieveError, ret);
            }
            return ret;
        }
        catch (Exception t) {
            this._logger.error((Object)"unable to get job log", (Throwable)t);
            return t.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getJobLogFromSsm(DDMJob job, DDMSwitch ssm, String fileNameAppender, boolean retrieveError, String ret) throws RemoteException, DMMException, IOException {
        Mediator mediator = null;
        try {
            this.getExecutionLog(ssm, job.getId(), fileNameAppender);
            mediator = this.getMediatorFromJob(job, ssm);
            DmmJobQueryReq req = new DmmJobQueryReq();
            req.setAttrBitMap((short)8192);
            ArrayList<Long> jobList = new ArrayList<Long>();
            if (retrieveError) {
                jobList.add(new Long(job.getId()));
                req.setJobId(jobList);
                req.setNumJob((byte)1);
                req.setPduHdr(SshMediator.getHeader((byte)1, req));
                DmmJobQueryResp resp = (DmmJobQueryResp)mediator.sendRecv((short)1, req);
                DDMJob dJob = this._helper.toDDMJob((DmmJobInfo)resp.getJobs().get(0), ssm);
                ret = dJob.getLog();
            }
        }
        finally {
            if (mediator != null) {
                mediator.disconnect();
            }
        }
        return ret;
    }

    public void getExecutionLog(DDMSwitch ssm, long jobId, String fileNameAppender) throws RemoteException {
        TFTP tftpSrvr = null;
        SnmpPeer peer = null;
        try {
            String ftpStr;
            File dir;
            boolean useSFTP = Boolean.valueOf(System.getProperty("server.sftp.enabled", "false"));
            String sftpRoot = null;
            String sftpUserName = null;
            String sftpPassword = null;
            if (useSFTP) {
                sftpRoot = System.getProperty("server.sftp.rootdir", null);
                sftpUserName = System.getProperty("server.sftp.username", null);
                String pass = System.getProperty("server.sftp.password", null);
                if (pass != null) {
                    if (pass.startsWith("#")) {
                        try {
                            sftpPassword = JBoss_4_2Encrypter.decrypt(pass.substring(1));
                        }
                        catch (Exception ex) {
                            throw new Exception("can not decrypt SFTP password:" + pass.substring(1));
                        }
                    } else {
                        sftpPassword = pass;
                    }
                }
                if (sftpRoot == null || sftpUserName == null || sftpPassword == null) {
                    useSFTP = false;
                }
            }
            String mgmtIp = ssm.getSwitch().getInetAddress().getHostAddress();
            String ipAddr = NetUtil.getLocalServerHostAddress();
            if (ipAddr == null) {
                throw new Exception("DMM cannot get local server ip address");
            }
            FabricImpl fabricImpl = SanManager.getInstance().findFabric(ssm.getSwitch().getFabricPK());
            SnmpUser snmpUser = this._user.getSnmpUser(fabricImpl == null ? null : fabricImpl.getPK());
            if (snmpUser == null) {
                throw new Exception("No SNMP credential");
            }
            peer = DDMServerImpl.getSnmpPeer(InetAddress.getByName(mgmtIp), snmpUser, SnmpSession.getInstance());
            String swAddr = ssm.getSwitch().getInetAddress().getHostAddress();
            if (!useSFTP) {
                tftpSrvr = TFTP.getInstance();
                tftpSrvr.addIpAccess(swAddr, "true", "true", "true");
                tftpSrvr.startServer(SnmpSession.isTrace());
                String tftpDmmRoot = tftpSrvr.getRoot() + File.separator + "dmm";
                dir = new File(tftpDmmRoot);
                if (!dir.exists()) {
                    dir.mkdir();
                }
                ftpStr = "tftp://";
            } else {
                String sftpDmmRoot = sftpRoot + File.separator + "dmm";
                dir = new File(sftpDmmRoot);
                if (!dir.exists()) {
                    dir.mkdir();
                }
                ftpStr = "sftp://" + sftpUserName + "@";
            }
            String remotePath = "modflash://" + ssm.getSsmCard().getSlotId() + "-1/DMM_Job_" + jobId + ".log";
            String localPath = ftpStr + ipAddr + "/dmm/" + jobId + fileNameAppender;
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)(ftpStr + " " + localPath + "  " + remotePath));
            }
            if (!useSFTP) {
                DMMHelper.getInstance().getRemoteFile(peer, swAddr, remotePath, ipAddr, localPath, tftpSrvr);
            } else {
                DMMHelper.getInstance().getRemoteFileViaSftp(peer, swAddr, remotePath, ipAddr, localPath, sftpPassword);
            }
        }
        catch (Exception ex) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)"can not get execution log ", (Throwable)ex);
            }
            RemoteException exc = new RemoteException("can not get execution log (" + ex.getMessage() + ") ");
            exc.setStackTrace(ex.getStackTrace());
            throw exc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rescheduleJob(DDMJob job, byte actioncode, Calendar cal) throws RemoteException {
        Mediator mediator1 = null;
        Mediator mediator2 = null;
        Mediator mediator3 = null;
        DDMCreationImpl impl = null;
        if (job.getStatus() == 8) {
            impl = new DDMCreationImpl(this._session, job, this._user, this, false);
            impl.setupMediator();
            impl.createInfra(job);
            impl.validate();
        }
        try {
            mediator1 = impl != null ? impl.getMediator1() : this.getMediatorFromJob(job, job.getSsm1());
            this.rescheduleJob(job, actioncode, cal, mediator1);
            if (job.getSsm2() != null) {
                mediator2 = impl != null ? impl.getMediator2() : this.getMediatorFromJob(job, job.getSsm2());
                this.rescheduleJob(job, actioncode, cal, mediator2);
            }
            if (job.getMethod3DataMoverSSM() != null) {
                mediator3 = impl != null ? impl.getMethod3Mediator() : this.getMediatorFromJob(job, job.getMethod3DataMoverSSM());
                this.rescheduleJob(job, actioncode, cal, mediator3);
            }
        }
        finally {
            if (mediator1 != null) {
                mediator1.disconnect();
            }
            if (mediator2 != null) {
                mediator2.disconnect();
            }
            if (mediator3 != null) {
                mediator3.disconnect();
            }
            if (impl != null) {
                impl.destroy();
            }
        }
    }

    private void rescheduleJob(DDMJob job, byte actioncode, Calendar cal, Mediator mediator) throws DMMException {
        DmmJobActionResp resp;
        DmmJobInfraCreateResp scheResp;
        try {
            DmmJobSchedReq pdu = new DmmJobSchedReq();
            if (cal != null) {
                pdu = DDMCreationImpl.getSchedulePdu(job.getId(), cal);
            } else {
                pdu = DDMCreationImpl.getSchedulePdu(job.getId(), Calendar.getInstance());
                pdu.setYear((short)0);
            }
            pdu.setAction(actioncode);
            scheResp = (DmmJobInfraCreateResp)mediator.sendRecv((short)7, pdu);
            DmmJobActionReq reqPdu = new DmmJobActionReq();
            reqPdu.setJobId(job.getId());
            reqPdu.setAction((byte)-69);
            reqPdu.setPduHdr(SshMediator.getHeader((byte)21, reqPdu));
            reqPdu.getPduHdr().setLength((short)(reqPdu.toByteArray().length * 2));
            resp = (DmmJobActionResp)mediator.sendRecv((short)21, reqPdu);
        }
        catch (Exception t) {
            throw new DMMException(t.toString());
        }
        if (scheResp.getStatus() != 0) {
            throw new DMMException("Can not reschedule job", resp.getReason());
        }
        if (resp.getStatus() != 0) {
            throw new DMMException("Can not restart job", resp.getReason());
        }
    }

    @Override
    public void restartJob(DDMJob job) throws RemoteException {
        this.rescheduleJob(job, (byte)-69, null);
    }

    @Override
    public DDMSession[] findAllSessionByJobId(DDMJob job) throws DMMException {
        List list = new ArrayList();
        list = this.findAllSessionByJobId(job, job.getSsm1());
        if (job.getSsm2() != null) {
            list.addAll(this.findAllSessionByJobId(job, job.getSsm2()));
        }
        if (job.getMethod3DataMoverSSM() != null) {
            list.addAll(this.findAllSessionByJobId(job, job.getMethod3DataMoverSSM()));
        }
        DDMSession[] result = list.size() != 0 ? list.toArray(new DDMSession[list.size()]) : new DDMSession[]{};
        return result;
    }

    public List findAllSessionByJobId(DDMJob job, DDMSwitch ssm) throws DMMException {
        ArrayList<DDMSession> list = new ArrayList<DDMSession>();
        try {
            Mediator mediator = this.getMediatorFromJob(job, ssm);
            DmmJobSessionQueryReq reqPdu = new DmmJobSessionQueryReq();
            reqPdu.setJobId(job.getId());
            reqPdu.setAttrBitMap((short)-1);
            reqPdu.setNumSessions(0);
            reqPdu.setPduHdr(SshMediator.getHeader((byte)32, reqPdu));
            reqPdu.getPduHdr().setLength((short)(reqPdu.toByteArray().length * 2));
            DmmJobSessionQueryResp sessionresp = (DmmJobSessionQueryResp)mediator.sendRecv((short)32, reqPdu);
            int onSSM = 0;
            DDMSwitch switch1 = job.getSsm1();
            DDMSwitch switch2 = job.getSsm2();
            onSSM = job.isSSM1DataMoverSSM() ? 3 : (switch1 != null && switch1.equals(ssm) ? 1 : 2);
            for (int i = 0; i < sessionresp.getNumSessions(); ++i) {
                Object session = sessionresp.getSessions().get(i);
                DDMSession sessionObj = DMMHelper.getInstance().toDDMSession((DmmJobSessionInfo)session, ssm);
                sessionObj.getExistingLuns().setSwitch(ssm);
                sessionObj.getNewLuns().setSwitch(ssm);
                sessionObj.setOnSSM(onSSM);
                list.add(sessionObj);
            }
            mediator.disconnect();
        }
        catch (Exception t) {
            t.printStackTrace();
            throw new DMMException(t.toString());
        }
        return list;
    }

    private Mediator getMediatorFromJob(DDMJob job, DDMSwitch ssm) throws DMMException {
        SwitchBase switch1 = ssm.getSwitch();
        String ipAddress = switch1.getIpAddress();
        FabricImpl fabricImpl = null;
        try {
            fabricImpl = SanManager.getInstance().findFabric(switch1.getFabricPK());
        }
        catch (Exception e) {
            throw new DMMException(e.getMessage());
        }
        SnmpUser snmpUser = this._user.getSnmpUser(fabricImpl == null ? null : fabricImpl.getPK());
        if (snmpUser == null) {
            throw new DMMException("No SNMP credential");
        }
        int slotId = ssm.getSsmCard().getSlotId();
        Mediator mediator = null;
        try {
            mediator = MediatorFactory.getMediator((short)1, ipAddress, snmpUser.getSecurityModel() == 3 ? ((UsmUser)snmpUser).getUserName() : ((CommunityUser)snmpUser).getCommunity(), snmpUser.getSecurityModel() == 3 ? ((UsmUser)snmpUser).getAuthPassword() : null);
            mediator.setUp(ipAddress, this.getSsmIpAddress(ipAddress, ssm.getSsmCard(), snmpUser), false);
        }
        catch (Exception ex) {
            throw new DMMException(ex.getMessage());
        }
        return mediator;
    }

    @Override
    public void stopJob(DDMJob job) throws DMMException {
        this.stopJob(job, job.getSsm1(), true);
        if (job.getSsm2() != null) {
            this.stopJob(job, job.getSsm2(), true);
        }
        if (job.getMethod3DataMoverSSM() != null) {
            this.stopJob(job, job.getMethod3DataMoverSSM(), true);
        }
    }

    private Mediator stopJob(DDMJob job, DDMSwitch ssm, boolean disconnect) throws DMMException {
        DmmJobActionResp resp;
        Mediator mediator = null;
        try {
            mediator = this.getMediatorFromJob(job, ssm);
            DmmJobActionReq reqPdu = new DmmJobActionReq();
            reqPdu.setJobId(job.getId());
            reqPdu.setAction((byte)-52);
            reqPdu.setPduHdr(SshMediator.getHeader((byte)21, reqPdu));
            reqPdu.getPduHdr().setLength((short)(reqPdu.toByteArray().length * 2));
            resp = (DmmJobActionResp)mediator.sendRecv((short)21, reqPdu);
        }
        catch (Exception t) {
            throw new DMMException(t.toString());
        }
        finally {
            if (disconnect && mediator != null) {
                mediator.disconnect();
            }
        }
        if (resp.getStatus() != 0) {
            throw new DMMException(ssm + ":" + "Can not stop job", resp.getReason());
        }
        return mediator;
    }

    @Override
    public void cutOffJob(DDMJob job) throws DMMException {
        DMMException firstExcep = null;
        DMMException secondExcep = null;
        DMMException thirdExcep = null;
        DMMException fourthExcep = null;
        try {
            this.cutOffJob(job, job.getSsm1());
        }
        catch (DMMException ddme) {
            firstExcep = ddme;
        }
        try {
            if (job.getSsm2() != null) {
                this.cutOffJob(job, job.getSsm2());
            }
        }
        catch (DMMException ddme) {
            secondExcep = ddme;
        }
        try {
            if (job.getMethod3DataMoverSSM() != null) {
                this.cutOffJob(job, job.getMethod3DataMoverSSM());
            }
        }
        catch (DMMException ddme) {
            thirdExcep = ddme;
        }
        try {
            this.getJobLog(job, false);
        }
        catch (DMMException ddme) {
            fourthExcep = ddme;
        }
        if (firstExcep != null || secondExcep != null || thirdExcep != null || fourthExcep != null) {
            StringBuilder errorMsg = new StringBuilder("Error: ");
            errorMsg.append(job.getId());
            boolean moreThenOne = false;
            if (firstExcep != null) {
                errorMsg.append(" on Switch ").append(job.getSsm1().getSwitch()).append(" : ").append(firstExcep.getMessage());
                moreThenOne = true;
            }
            if (secondExcep != null) {
                if (moreThenOne) {
                    errorMsg.append(",");
                }
                errorMsg.append(" on Switch ").append(job.getSsm2().getSwitch()).append(" : ").append(secondExcep.getMessage());
                moreThenOne = true;
            }
            if (thirdExcep != null) {
                if (moreThenOne) {
                    errorMsg.append(",");
                }
                errorMsg.append(" on Switch ").append(job.getMethod3DataMoverSSM().getSwitch()).append(" : ").append(thirdExcep.getMessage());
                moreThenOne = true;
            }
            if (fourthExcep != null) {
                if (moreThenOne) {
                    errorMsg.append(",");
                }
                errorMsg.append(" getting job log ").append(" : ").append(fourthExcep.getMessage());
            }
            throw new DMMException(errorMsg.toString());
        }
    }

    private void cutOffJob(DDMJob job, DDMSwitch ssm) throws DMMException {
        DmmJobInfraCreateResp resp;
        Mediator mediator = null;
        try {
            mediator = this.stopJob(job, ssm, false);
            DmmJobInfraCreateReq reqPdu = new DmmJobInfraCreateReq();
            reqPdu.setJobId(job.getId());
            reqPdu.setPduHdr(SshMediator.getHeader((byte)9, reqPdu));
            reqPdu.getPduHdr().setLength((short)(reqPdu.toByteArray().length * 2));
            resp = (DmmJobInfraCreateResp)mediator.sendRecv((short)9, reqPdu);
        }
        catch (Exception t) {
            t.printStackTrace();
            throw new DMMException(ssm + ":" + t.toString());
        }
        finally {
            if (mediator != null) {
                mediator.disconnect();
            }
        }
        if (resp.getStatus() != 0) {
            throw new DMMException(ssm + ":" + "Can not delete job", resp.getReason());
        }
    }

    @Override
    public void cutOverJob(DDMJob job) throws DMMException {
        if (!job.isJobAsychJob()) {
            throw new DMMException("Action not allowed on Sync jobs");
        }
        DMMException firstExcep = null;
        DMMException secondExcep = null;
        DMMException thirdExcep = null;
        DMMException fourthExcep = null;
        if (job.getMethod() != -35) {
            DDMSession[] sessions = job.getSessions();
            if (sessions == null) {
                sessions = this.findAllSessionByJobId(job);
                job.setSessions(sessions);
            }
            boolean anyFirst = false;
            boolean anySecond = false;
            for (DDMSession nextSession : sessions) {
                if (nextSession.getOnSSM() == 1) {
                    anyFirst = true;
                } else {
                    anySecond = true;
                }
                if (anyFirst && anySecond) break;
            }
            try {
                if (anyFirst) {
                    this.cutOverJob(job, job.getSsm1());
                    this.getJobLog(job, false);
                }
            }
            catch (DMMException ddme) {
                firstExcep = ddme;
            }
            try {
                if (job.getSsm2() != null && anySecond) {
                    this.cutOverJob(job, job.getSsm2());
                }
            }
            catch (DMMException ddme) {
                secondExcep = ddme;
            }
        } else {
            try {
                if (job.getMethod3DataMoverSSM() != null) {
                    this.cutOverJob(job, job.getMethod3DataMoverSSM());
                }
            }
            catch (DMMException ddme) {
                thirdExcep = ddme;
            }
            try {
                this.getJobLog(job, false);
            }
            catch (DMMException ddme) {
                fourthExcep = ddme;
            }
        }
        if (firstExcep != null || secondExcep != null || thirdExcep != null || fourthExcep != null) {
            StringBuilder errorMsg = new StringBuilder("Error: ");
            errorMsg.append(job.getId());
            boolean moreThenOne = false;
            if (firstExcep != null) {
                errorMsg.append(" on Switch ").append(job.getSsm1().getSwitch()).append(" : ").append(firstExcep.getMessage());
                moreThenOne = true;
            }
            if (secondExcep != null) {
                if (moreThenOne) {
                    errorMsg.append(",");
                }
                errorMsg.append(" on Switch ").append(job.getSsm2().getSwitch()).append(" : ").append(secondExcep.getMessage());
                moreThenOne = true;
            }
            if (thirdExcep != null) {
                if (moreThenOne) {
                    errorMsg.append(",");
                }
                errorMsg.append(" on Switch ").append(job.getMethod3DataMoverSSM().getSwitch()).append(" : ").append(thirdExcep.getMessage());
                moreThenOne = true;
            }
            if (fourthExcep != null) {
                if (moreThenOne) {
                    errorMsg.append(",");
                }
                errorMsg.append(" getting job log ").append(" : ").append(fourthExcep.getMessage());
            }
            throw new DMMException(errorMsg.toString());
        }
    }

    private void cutOverJob(DDMJob job, DDMSwitch ssm) throws DMMException {
        DmmJobActionResp resp;
        Mediator mediator = null;
        try {
            mediator = this.getMediatorFromJob(job, ssm);
            DmmJobActionReq reqPdu = new DmmJobActionReq();
            reqPdu.setJobId(job.getId());
            reqPdu.setAction((byte)-35);
            reqPdu.setPduHdr(SshMediator.getHeader((byte)21, reqPdu));
            reqPdu.getPduHdr().setLength((short)(reqPdu.toByteArray().length * 2));
            resp = (DmmJobActionResp)mediator.sendRecv((short)21, reqPdu);
        }
        catch (Exception t) {
            t.printStackTrace();
            throw new DMMException(t.toString());
        }
        finally {
            if (mediator != null) {
                mediator.disconnect();
            }
        }
        if (resp.getStatus() != 0) {
            throw new DMMException(ssm + ":" + "Can not cutover job", resp.getReason());
        }
    }

    String getSsmIpAddress(String mgmtIp, Card ssmCard, SnmpUser user) throws DMMException, IOException, SnmpException {
        HashMap slotIpMap;
        String ret = null;
        int slotId = ssmCard.getSlotId();
        if (this.s_ssmIpMap.get(mgmtIp) == null) {
            slotIpMap = new HashMap();
            this.s_ssmIpMap.put(mgmtIp, slotIpMap);
        }
        if ((ret = (String)(slotIpMap = (HashMap)this.s_ssmIpMap.get(mgmtIp)).get(new Integer(slotId))) == null || ret.length() == 0) {
            SnmpSession snmpSession = SnmpSession.getInstance();
            snmpSession.open();
            SnmpPeer peer = DDMServerImpl.getSnmpPeer(InetAddress.getByName(mgmtIp), user, snmpSession);
            ret = DMMHelper.getSsmIpAddress(peer, ssmCard, slotIpMap);
            slotIpMap.put(new Integer(slotId), ret);
        }
        ret = (String)slotIpMap.get(new Integer(slotId));
        return ret;
    }

    protected SnmpPeer getPeer(SwitchImpl swImpl) throws Exception {
        FabricPK fabricPK = swImpl.getFabricPK();
        SnmpUser snmpUser = this._user.getSnmpUser(fabricPK);
        if (snmpUser == null) {
            throw new Exception("No SNMP credential");
        }
        return DDMServerImpl.getSnmpPeer(swImpl.getInetAddress(), snmpUser, SnmpSession.getInstance());
    }

    static SnmpPeer getSnmpPeer(InetAddress mgmtIp, SnmpUser user, SnmpSession snmpSession) throws SnmpException, UnknownHostException {
        return SnmpPeer.getSnmpPeer(mgmtIp, snmpSession, user);
    }

    @Override
    public DDMJob[] findAllJobs() throws RemoteException {
        StopWatch overAllTimer = new StopWatch();
        StopWatch timer = new StopWatch();
        if (this._logger.isDebugEnabled()) {
            overAllTimer.start();
            timer.start();
        }
        DDMSwitch[] allMDS = this.findAllDDMEnabledSwitch(null, false, (byte)-18, false);
        if (this._logger.isDebugEnabled()) {
            long timeTo = timer.stop();
            this._logger.debug((Object)("findAllJobs - Time to find all dmm enable switches - " + timeTo));
        }
        if (allMDS == null) {
            return null;
        }
        HashMap<Long, DDMJob> allJobs = new HashMap<Long, DDMJob>();
        ArrayList<DDMJob> ret = new ArrayList<DDMJob>();
        allJobs.clear();
        ArrayList<QueryThread> threadlist = new ArrayList<QueryThread>();
        for (int i = 0; i < allMDS.length; ++i) {
            QueryThread th = new QueryThread(allMDS[i], this);
            th.start();
            threadlist.add(th);
        }
        for (QueryThread th : threadlist) {
            try {
                th.join();
            }
            catch (Exception ex) {
                // empty catch block
            }
            ret.addAll(th.getList());
        }
        if (this._logger.isDebugEnabled()) {
            long timeTo = timer.stop();
            this._logger.debug((Object)("findAllJobs - Time to find get all jobs from switch - " + timeTo));
        }
        for (DDMJob job : ret) {
            DDMJob matchingJob = (DDMJob)allJobs.get(new Long(job.getId()));
            if (matchingJob != null) {
                if (job.getMethod() != -35) {
                    matchingJob.setSsm2(job.getSsm1());
                    if (job.getStatus() > matchingJob.getStatus()) {
                        this.updateJobStatus(matchingJob, job);
                        matchingJob.setScheduledStartingTime(job.getScheduledStartingTime(true));
                        continue;
                    }
                    this.updateJobStatus(matchingJob, job);
                    continue;
                }
                if (matchingJob.isSSM1DataMoverSSM() && matchingJob.getMethod3DataMoverSSM() != null) {
                    matchingJob.setSsm2(job.getSsm1());
                    if (job.getStatus() <= matchingJob.getStatus()) continue;
                    this.updateJobStatus(matchingJob, job);
                    matchingJob.setScheduledStartingTime(job.getScheduledStartingTime(true));
                    continue;
                }
                if (matchingJob.isSSM1DataMoverSSM()) {
                    matchingJob.setMethod3DataMoverSSM(matchingJob.getSsm1());
                    matchingJob.setSsm1(job.getSsm1());
                    if (job.getStatus() <= matchingJob.getStatus()) continue;
                    this.updateJobStatus(matchingJob, job);
                    matchingJob.setScheduledStartingTime(job.getScheduledStartingTime(true));
                    continue;
                }
                if (job.isSSM1DataMoverSSM()) {
                    job.setMethod3DataMoverSSM(job.getSsm1());
                    job.setSsm1(matchingJob.getSsm1());
                    job.setSsm2(matchingJob.getSsm2());
                    if (matchingJob.getStatus() > job.getStatus()) {
                        this.updateJobStatus(job, matchingJob);
                        job.setScheduledStartingTime(matchingJob.getScheduledStartingTime(true));
                    }
                    allJobs.put(new Long(job.getId()), job);
                    continue;
                }
                if (matchingJob.getSsm2() == null) {
                    matchingJob.setSsm2(job.getSsm1());
                } else {
                    matchingJob.setMethod3DataMoverSSM(matchingJob.getSsm1());
                    matchingJob.setSsm1(job.getSsm1());
                }
                if (job.getStatus() <= matchingJob.getStatus()) continue;
                this.updateJobStatus(matchingJob, job);
                matchingJob.setScheduledStartingTime(job.getScheduledStartingTime(true));
                continue;
            }
            allJobs.put(new Long(job.getId()), job);
        }
        for (DDMJob nextJob : allJobs.values()) {
            if (nextJob.getStatus() != 3 && nextJob.getStatus() != 10 && nextJob.getStatus() != 11 && nextJob.getStatus() != 12) continue;
            nextJob.setSessions(this.findAllSessionByJobId(nextJob));
        }
        if (this._logger.isDebugEnabled()) {
            long timeTo = timer.stop();
            this._logger.debug((Object)("findAllJobs - Time to correlate all the jobs to send back - " + timeTo));
        }
        Collection result = allJobs.values();
        if (this._logger.isDebugEnabled()) {
            long timeTo = overAllTimer.stop();
            this._logger.debug((Object)("findAllJobs - Time to - Find all jobs (all tasks) - " + timeTo));
        }
        return result.size() != 0 ? result.toArray(new DDMJob[result.size()]) : new DDMJob[]{};
    }

    private void updateJobStatus(DDMJob matchingJob, DDMJob job) {
        if (job.getStatus() == 4 && matchingJob.getStatus() == 11 || matchingJob.getStatus() == 4 && job.getStatus() == 11) {
            job.setStatus(4);
            matchingJob.setStatus(4);
        } else if (job.getStatus() > matchingJob.getStatus()) {
            matchingJob.setStatus(job.getStatus());
        }
    }

    @Override
    public DDMSwitch[] findAllDDMEnabledSwitch(FabricPK fpk) throws RemoteException {
        return this.findAllDDMEnabledSwitch(fpk, true, (byte)-18, true);
    }

    @Override
    public DDMSwitch[] findAllDDMEnabledSwitch(FabricPK fpk, boolean retrieveJobCount, byte method) throws RemoteException {
        return this.findAllDDMEnabledSwitch(fpk, retrieveJobCount, method, true);
    }

    public DDMSwitch[] findAllDDMEnabledSwitch(FabricPK fpk, boolean retrieveJobCount, byte method, boolean okToThrowFabricV2Error) throws RemoteException {
        SanManager sanManager = SanManager.getInstance();
        FabricImpl[] allFabrics = null;
        if (fpk == null) {
            FabricPK[] pks = this._session.getManageableFabrics();
            allFabrics = new FabricImpl[pks.length];
            int index = 0;
            for (FabricPK nextPk : pks) {
                FabricImpl next = sanManager.findFabric(nextPk);
                if (next == null) continue;
                allFabrics[index++] = next;
            }
        } else {
            FabricImpl fab = sanManager.findFabric(fpk);
            if (this._session.isManageable(fpk) && fab != null) {
                allFabrics = new FabricImpl[]{fab};
            } else {
                return new DDMSwitch[0];
            }
        }
        ArrayList<DDMSwitch> list = new ArrayList<DDMSwitch>();
        for (FabricImpl nextFab : allFabrics) {
            SwitchImpl[] allSwitches;
            if (nextFab == null) continue;
            SnmpUser snmpUserForFabric = this._user.getSnmpUser(nextFab.getPK());
            if (snmpUserForFabric.getSecurityModel() == 2) {
                if (okToThrowFabricV2Error) {
                    String msg = "Error searching fabric \"" + fpk + "\" for DMM enabled switches,\nuser login credentials for this fabric are SNMPv2, however SNMPv3 is required for DMM requests.";
                    this._logger.info((Object)msg);
                    throw new DMMException(msg);
                }
                this._logger.info((Object)("Skip searching fabric " + fpk + " for DMM Enabled switches as user login credentials for this fabric are SNMPv2, must be SNMPv3 for DMM Queries"));
                continue;
            }
            for (SwitchImpl nextSwitch : allSwitches = nextFab.getSwitches()) {
                if (fpk != null && nextSwitch.getFabricPK() != null && !nextSwitch.getFabricPK().equals(fpk) || !nextSwitch.isMDS() || !nextSwitch.isManageable() && (nextSwitch.isManageable() || !nextSwitch.isManageTimeOut()) || !nextSwitch.isVersionGreaterThanEqual(DMM_MIN_VERSION)) continue;
                this.findSSMCardBySwitch(nextSwitch, list, retrieveJobCount);
            }
        }
        Collections.sort(list);
        return list.size() != 0 ? list.toArray(new DDMSwitch[list.size()]) : new DDMSwitch[]{};
    }

    private void findSSMCardBySwitch(SwitchImpl sw, List<DDMSwitch> list, boolean retrieveJobCount) throws DMMException {
        InventoryManager invManager = InventoryManager.getInstance();
        List<Card> cards = invManager.findCards(sw.getSwitchPK());
        for (Card card : cards) {
            int dmmState;
            if (card.getType() != 5 && card.getType() != 20 && card.getType() != 39 && card.getType() != 41 && card.getType() != 68 || (dmmState = card.getDmmState()) != 1 && dmmState != 2 || card.getPowerOperStatus() != 2) continue;
            DDMSwitch ddmSwitch = new DDMSwitch((SwitchBase)sw.getBaseObject());
            ddmSwitch.setSsmCard(card);
            ddmSwitch.setFabric(sw.getFabric().getFabricBase(null));
            if (retrieveJobCount) {
                if (dmmState != 1) continue;
                this.getActiveNumJobForSwitch(ddmSwitch, retrieveJobCount);
            }
            list.add(ddmSwitch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getActiveNumJobForSwitch(DDMSwitch ddmSwitch, boolean retrieveJobCount) throws DMMException {
        SnmpUser snmpUser = this._user.getSnmpUser(ddmSwitch.getFabric() == null ? null : ddmSwitch.getFabric().getPK());
        if (snmpUser == null) {
            throw new DMMException("No SNMP credential");
        }
        Mediator mediator = null;
        try {
            mediator = MediatorFactory.getMediator((short)1, ddmSwitch.getSwitch().getIpAddress(), snmpUser.getSecurityModel() == 3 ? ((UsmUser)snmpUser).getUserName() : ((CommunityUser)snmpUser).getCommunity(), snmpUser.getSecurityModel() == 3 ? ((UsmUser)snmpUser).getAuthPassword() : null);
            String ssmIp = this.getSsmIpAddress(ddmSwitch.getSwitch().getIpAddress(), ddmSwitch.getSsmCard(), snmpUser);
            if (ssmIp == null || ssmIp.trim().equals("")) {
                ddmSwitch.setNumJob(0);
            } else {
                mediator.setUp(ddmSwitch.getSwitch().getIpAddress(), ssmIp, false);
                DmmJobQueryReq req = new DmmJobQueryReq();
                req.setAttrBitMap((short)24575);
                req.setJobId(new ArrayList());
                req.setNumJob((byte)0);
                req.setPduHdr(SshMediator.getHeader((byte)1, req));
                DmmJobQueryResp resp = (DmmJobQueryResp)mediator.sendRecv((short)1, req);
                ddmSwitch.setNumJob(resp.getNumJob());
            }
        }
        catch (Throwable ex) {
            ddmSwitch.setNumJob(0);
        }
        finally {
            if (mediator != null) {
                mediator.disconnect();
            }
        }
    }

    @Override
    public FabricPK[] findAllFabricForEnclosure(EnclosureBase encl) throws RemoteException {
        Map map = this.findFabricByEnclosure(encl);
        Set ret = map.keySet();
        return ret.size() != 0 ? ret.toArray(new FabricPK[ret.size()]) : new FabricPK[]{};
    }

    @Override
    public Integer[] findCommonVsanMembership(EndPortBase[] encl1, EndPortBase[] encl2, FabricPK fpk) throws DMMException {
        return DMMHelper.getInstance().findCommonVsanMembership(encl1, encl2, fpk);
    }

    @Override
    public Integer[] findCommonVsanMembership(EnclosureBase encl1, EnclosureBase encl2, FabricPK fpk) throws DMMException {
        return DMMHelper.getInstance().findCommonVsanMembership(encl1, encl2, fpk);
    }

    private Map findFabricByEnclosure(EnclosureBase encl) throws RemoteException {
        HashMap<FabricPK, FabricPK> map = new HashMap<FabricPK, FabricPK>();
        SanManager sanManager = SanManager.getInstance();
        EnclosureImpl ecnImpl = sanManager.findEnclosureByPK(encl.getEnclosurePK());
        List<EndPortImpl> list = ecnImpl.getEndPorts();
        if (list == null || list.size() == 0) {
            throw new DMMException("enclosure does not have endPoints");
        }
        for (int i = 0; i < list.size(); ++i) {
            EndPortImpl port = list.get(i);
            if (port == null || port.getFabricPK() == null || !this.isFabricInSession(port.getFabricPK())) continue;
            map.put(port.getFabricPK(), port.getFabricPK());
        }
        return map;
    }

    @Override
    public FabricPK[] findAllFabricForEnclosures(EnclosureBase encl1, EnclosureBase encl2) throws RemoteException {
        Map map1 = this.findFabricByEnclosure(encl1);
        Map map2 = this.findFabricByEnclosure(encl1);
        Map map = DMMHelper.getInstance().intersect(map1, map2);
        Set ret = map.keySet();
        return ret.size() != 0 ? ret.toArray(new FabricPK[ret.size()]) : new FabricPK[]{};
    }

    private boolean isFabricInSession(FabricPK in) throws RemoteException {
        FabricPK[] pks = this._session.getManageableFabrics();
        if (pks == null || pks.length == 0) {
            return false;
        }
        boolean found = false;
        for (int k = 0; k < pks.length; ++k) {
            if (!pks[k].equals(in)) continue;
            return true;
        }
        return false;
    }

    public EnclosureBase[] getAllStorage(boolean zoned, boolean all) throws RemoteException {
        SanManager sanManager = SanManager.getInstance();
        EnclosureImpl[] storage = sanManager.getEnclosures();
        ArrayList<EnclosureBase> ret = new ArrayList<EnclosureBase>();
        block0: for (int i = 0; i < storage.length; ++i) {
            FabricPK[] pks;
            EnclosureImpl impl = storage[i];
            EnclosureBase base = (EnclosureBase)impl.getBaseObject();
            String devTypeName = base.getTypeName();
            if (!base.isStorage() || devTypeName != null && devTypeName.equals("Tape") || (pks = this._session.getManageableFabrics()) == null || pks.length == 0) continue;
            boolean found = false;
            List<FabricPK> fpk = impl.getConnectedFabrics();
            if (fpk == null) continue;
            for (int k = 0; k < pks.length; ++k) {
                if (!fpk.contains(pks[k])) continue;
                found = true;
            }
            if (!found) continue;
            if (all && base.getEndPortPKs() != null && base.getEndPortPKs().size() != 0) {
                if (this.isInternal(base)) continue;
                ret.add(base);
                continue;
            }
            List<FabricPK> list = storage[i].getConnectedFabrics();
            if (list == null) continue;
            for (int k = 0; k < list.size(); ++k) {
                FabricImpl fabric;
                FabricPK fabricPK = list.get(k);
                if (fabricPK == null || (fabric = sanManager.findFabric(fabricPK)) == null || !this._helper.isStorageZoned(fabric, storage[i])) continue;
                if (this.isInternal(base)) continue block0;
                ret.add(base);
                continue block0;
            }
        }
        Collections.sort(ret);
        return ret.size() != 0 ? ret.toArray(new EnclosureBase[ret.size()]) : new EnclosureBase[]{};
    }

    private boolean isInternal(EnclosureBase base) {
        boolean ret = true;
        SanManager sanManager = SanManager.getInstance();
        EnclosureImpl encImpl = sanManager.findEnclosureByPK(base.getEnclosurePK());
        if (encImpl == null) {
            return true;
        }
        List<EndPortImpl> ports = encImpl.getEndPorts();
        if (ports == null) {
            return ret;
        }
        for (EndPortImpl port : ports) {
            if (port != null) {
                WwnKey key = port.getEndPortPK();
                if (port != null && port.getBaseObject() != null && (key._wwn != null && !WwnDictionary.isCiscoWwn(key._wwn.getValue()) || !((EndPortBase)port.getBaseObject()).isInternal())) {
                    ret = false;
                    continue;
                }
                if (!this._logger.isDebugEnabled()) continue;
                this._logger.debug((Object)("isInternal check: port in the enclosure (" + base + ") was skipped for internal check because a necessary value was null - port: " + port + " portbase : " + (port == null ? null : port.getBaseObject()) + " key._wwn : " + key._wwn));
                continue;
            }
            if (!this._logger.isDebugEnabled()) continue;
            this._logger.debug((Object)("one of the keys from the enclosure is null : " + base));
        }
        return ret;
    }

    @Override
    public EnclosureBase[] findAllStoragePortsByHost(EnclosureBase hostPort, boolean sameVsan, boolean all) throws RemoteException {
        SanManager sanManager = SanManager.getInstance();
        if (hostPort == null) {
            return this.getAllStorage(sameVsan, all);
        }
        List<WwnKey> list = hostPort.getEndPortPKs();
        if (list == null || list.size() == 0) {
            throw new DMMException("host enclosure does not have endPoints");
        }
        WwnKey epWwn = list.get(0);
        EndPortImpl port = sanManager.findEndPort(epWwn);
        if (port == null) {
            return new EnclosureBase[0];
        }
        SwitchImpl switcher = sanManager.findSwitch(port.getSwitchPK(), port.getFabricPK());
        if (switcher == null && this.isInDiscovery()) {
            throw new DMMException("fabric is being discovered");
        }
        if (switcher == null) {
            return new EnclosureBase[0];
        }
        FabricImpl fabric = sanManager.findFabric(port.getFabricPK());
        ArrayList<EnclosureBase> ret = new ArrayList<EnclosureBase>();
        EnclosureImpl[] storage = fabric.getEnclosures(2);
        for (int i = 0; i < storage.length; ++i) {
            EnclosureBase base;
            if (!this.isEnclosurePresent(storage[i]) || !(base = (EnclosureBase)storage[i].getBaseObject()).isPresent() || !base.isStorage() || this.isInternal(base)) continue;
            if (all) {
                ret.add(base);
                continue;
            }
            if (sameVsan) {
                if (this._helper.findCommonVsanId(base, hostPort, fabric.getPK()) <= 0) continue;
                ret.add(base);
                continue;
            }
            if (this._helper.isStorageZoned(fabric, storage[i])) continue;
            ret.add(base);
        }
        Collections.sort(ret);
        if (ret.size() > 0) {
            return ret.toArray(new EnclosureBase[ret.size()]);
        }
        return new EnclosureBase[0];
    }

    @Override
    public EnclosureBase[] findAllStoragePortsByHostZone(EnclosureBase hostPort, boolean zoned, boolean all) throws RemoteException {
        SanManager sanManager = SanManager.getInstance();
        if (hostPort == null) {
            return this.getAllStorage(zoned, all);
        }
        List<WwnKey> list = hostPort.getEndPortPKs();
        if (list == null || list.size() == 0) {
            throw new DMMException("host enclosure does not have endPoints");
        }
        WwnKey epWwn = list.get(0);
        EndPortImpl port = sanManager.findEndPort(epWwn);
        if (port == null) {
            return new EnclosureBase[0];
        }
        SwitchImpl switcher = sanManager.findSwitch(port.getSwitchPK(), port.getFabricPK());
        if (switcher == null && this.isInDiscovery()) {
            throw new DMMException("fabric is being discovered");
        }
        if (switcher == null) {
            return new EnclosureBase[0];
        }
        FabricImpl fabric = sanManager.findFabric(port.getFabricPK());
        ArrayList<EnclosureBase> ret = new ArrayList<EnclosureBase>();
        EnclosureImpl[] storage = fabric.getEnclosures(2);
        for (int i = 0; i < storage.length; ++i) {
            EnclosureBase base = (EnclosureBase)storage[i].getBaseObject();
            if (this.isInternal(base) || !base.isPresent() || !base.isStorage()) continue;
            if (all) {
                ret.add(base);
                continue;
            }
            if (zoned) {
                if (!this._helper.isHostTargetInSameZoneMember(fabric, hostPort, (EnclosureBase)storage[i].getBaseObject())) continue;
                ret.add(base);
                continue;
            }
            if (this._helper.isStorageZoned(fabric, storage[i])) continue;
            ret.add(base);
        }
        Collections.sort(ret);
        if (ret.size() > 0) {
            return ret.toArray(new EnclosureBase[ret.size()]);
        }
        return new EnclosureBase[0];
    }

    private boolean isInDiscovery() {
        SanManager san = SanManager.getInstance();
        FabricImpl[] fabs = san.getFabrics();
        boolean ret = false;
        for (int i = 0; i < fabs.length; ++i) {
            if (!fabs[i].isDiscovering()) continue;
            return true;
        }
        return ret;
    }

    @Override
    public EnclosureBase[] findAllHosts() throws RemoteException {
        ArrayList<EnclosureBase> ret = new ArrayList<EnclosureBase>();
        SanManager sanManager = SanManager.getInstance();
        EnclosureImpl[] enclosures = sanManager.getEnclosures();
        if (enclosures == null) {
            return null;
        }
        for (int i = 0; i < enclosures.length; ++i) {
            FabricPK[] pks;
            List<FabricPK> fpk = enclosures[i].getConnectedFabrics();
            if (fpk == null || fpk.size() == 0 || (pks = this._session.getManageableFabrics()) == null || pks.length == 0) continue;
            boolean found = false;
            for (int k = 0; k < pks.length; ++k) {
                if (!fpk.contains(pks[k])) continue;
                found = true;
            }
            if (!found || !enclosures[i].isHost()) continue;
            EnclosureBase base = (EnclosureBase)enclosures[i].getBaseObject();
            if (!this.isEnclosurePresent(enclosures[i]) || this.isInternal(base)) continue;
            ret.add(base);
        }
        Collections.sort(ret);
        return ret.size() != 0 ? ret.toArray(new EnclosureBase[ret.size()]) : new EnclosureBase[]{};
    }

    private boolean isEnclosurePresent(EnclosureImpl encl) {
        boolean ret = false;
        EnclosureBase base = (EnclosureBase)encl.getBaseObject();
        List<WwnKey> pks = base.getEndPortPKs();
        if (pks == null || pks.size() == 0) {
            return false;
        }
        List<EndPortImpl> ports = encl.getEndPorts();
        for (int i = 0; i < ports.size(); ++i) {
            EndPortImpl endPort = ports.get(i);
            if (!endPort.isPresent()) continue;
            ret = true;
        }
        return ret;
    }

    public FMUser getUser() {
        return this._user;
    }

    private void checkRespPdu(String prefix, SshMediatorRespPdu resp) throws DMMException {
        if (resp != null && resp.getStatus() != 0) {
            throw new DMMException(prefix + resp.getReasonStr().trim(), resp.getReason());
        }
    }

    @Override
    public Map<DDMSwitch, List<DDMDppVi>> getAllVIsPerSSM(List<DDMSwitch> sws) throws DMMException {
        HashMap<DDMSwitch, List<DDMDppVi>> allVis = new HashMap<DDMSwitch, List<DDMDppVi>>();
        try {
            ArrayList<ViQueryThread> threadlist = new ArrayList<ViQueryThread>();
            for (DDMSwitch nextSw : sws) {
                ViQueryThread th = new ViQueryThread(nextSw, this, null);
                th.start();
                threadlist.add(th);
            }
            for (ViQueryThread th : threadlist) {
                try {
                    th.join();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                Exception e = th.getException();
                if (e != null) {
                    throw e;
                }
                allVis.put(th.getSwitch(), th.getVIs());
            }
        }
        catch (Exception ex) {
            this._logger.error((Object)"Actual exception from getAllVisPerSSM", (Throwable)ex);
            DDMServerImpl.wrapAndRethrow(ex);
        }
        return allVis;
    }

    private static void wrapAndRethrow(Exception ex) throws DMMException {
        DMMException e = new DMMException();
        e.setProtocolException(ex);
        throw e;
    }

    @Override
    public Map<SwitchBase, SSHConfigInfo> getSSHConfig(List<SwitchBase> swBases) throws RemoteException {
        HashMap<SwitchBase, SSHConfigInfo> results = new HashMap<SwitchBase, SSHConfigInfo>();
        for (SwitchBase next : swBases) {
            results.put(next, this.getSSHConfig(next));
        }
        return results;
    }

    public SSHConfigInfo getSSHConfig(SwitchBase swBase) throws RemoteException {
        SanManager sanMan = SanManager.getInstance();
        SwitchImpl swImpl = sanMan.findSwitch(swBase.getWwn(), swBase.getFabricPK());
        try {
            SnmpPeer peer = this.getPeer(swImpl);
            VarBindList vbl = new VarBindList(1);
            vbl.add(new SnmpVarBind(new SnmpOID(_CssKeyNBitsOid), null));
            SnmpPDU rspPdu = SnmpFetch.getBulk(peer, vbl);
            VarBindList resp = rspPdu.getVariables();
            ArrayList<SSHConfigKey> results = new ArrayList<SSHConfigKey>();
            for (int i = 0; i < resp.size(); ++i) {
                int[] oid = resp.getVb(i).getOid().getValue();
                int protocolType = oid[oid.length - 1];
                long numbits = resp.longValue(i);
                SSHConfigKey dto = new SSHConfigKey(protocolType, numbits);
                results.add(dto);
            }
            SnmpPDU pdu = new SnmpPDU(-96, new VarBindList(1));
            pdu.addNull(new SnmpOID(_CssServiceActivationOid, 0));
            resp = peer.send(pdu).getVariables();
            boolean sshEnabled = resp.intValue(0) == 1;
            SSHConfigInfo config = new SSHConfigInfo(swBase, sshEnabled, results);
            return config;
        }
        catch (Exception ex) {
            RemoteException exc = new RemoteException(swImpl.getName() + ": " + ex.getMessage());
            exc.setStackTrace(ex.getStackTrace());
            throw exc;
        }
    }

    @Override
    public HashMap<SwitchBase, Exception> createSSHKeys(List<SwitchBase> switches) throws RemoteException {
        HashMap<SwitchBase, Exception> failures = new HashMap<SwitchBase, Exception>();
        ArrayList<RunPDUSetThread> threadlist = new ArrayList<RunPDUSetThread>();
        for (SwitchBase nextSw : switches) {
            SnmpPDU pdu = this.constructSSHKeyPDU();
            RunPDUSetThread th = new RunPDUSetThread(nextSw, pdu, this);
            th.start();
            threadlist.add(th);
        }
        for (RunPDUSetThread th : threadlist) {
            Exception e;
            try {
                th.join();
            }
            catch (Exception ex) {
                // empty catch block
            }
            if ((e = th.getException()) == null) continue;
            failures.put(th.getSwitch(), e);
        }
        return failures;
    }

    private SnmpPDU constructSSHKeyPDU() {
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.setIgnoreSetCount(true);
        pdu.setRetries(0);
        pdu.addVar(new SnmpOID(_CssKeyRowStatusOid, 1), CREATE_AND_GO);
        pdu.addVar(new SnmpOID(_CssKeyNBitsOid, 1), new SnmpInt(1024));
        return pdu;
    }

    @Override
    public HashMap<SwitchBase, Exception> enableSSH(List<SwitchBase> switches) throws RemoteException {
        HashMap<SwitchBase, Exception> failures = new HashMap<SwitchBase, Exception>();
        ArrayList<RunPDUSetThread> threadlist = new ArrayList<RunPDUSetThread>();
        for (SwitchBase nextSw : switches) {
            SnmpPDU pdu = this.constructEnableSSHPdu();
            RunPDUSetThread th = new RunPDUSetThread(nextSw, pdu, this);
            th.start();
            threadlist.add(th);
        }
        for (RunPDUSetThread th : threadlist) {
            Exception e;
            try {
                th.join();
            }
            catch (Exception ex) {
                // empty catch block
            }
            if ((e = th.getException()) == null) continue;
            failures.put(th.getSwitch(), e);
        }
        return failures;
    }

    @Override
    public Map<SwitchBase, Exception> setIpv4RoutingEnabled(List<SwitchBase> switches) throws RemoteException {
        HashMap<SwitchBase, Exception> failures = new HashMap<SwitchBase, Exception>();
        ArrayList<RunPDUSetThread> threadlist = new ArrayList<RunPDUSetThread>();
        for (SwitchBase nextSw : switches) {
            SnmpPDU pdu = this.constructEnableIpv4RoutingPdu();
            RunPDUSetThread th = new RunPDUSetThread(nextSw, pdu, this);
            th.start();
            threadlist.add(th);
        }
        for (RunPDUSetThread th : threadlist) {
            Exception e;
            try {
                th.join();
            }
            catch (Exception ex) {
                // empty catch block
            }
            if ((e = th.getException()) == null) continue;
            failures.put(th.getSwitch(), e);
        }
        return failures;
    }

    @Override
    public Map<SwitchBase, List<String>> getVSanIpAddress(List<SwitchBase> swBases) throws RemoteException {
        HashMap<SwitchBase, List<String>> results = new HashMap<SwitchBase, List<String>>();
        for (SwitchBase next : swBases) {
            results.put(next, this.getVSanIpAddress(next));
        }
        return results;
    }

    public List<String> getVSanIpAddress(SwitchBase swBase) throws RemoteException {
        SanManager sanMan = SanManager.getInstance();
        SwitchImpl swImpl = sanMan.findSwitch(swBase.getWwn(), swBase.getFabricPK());
        try {
            SnmpPeer peer = this.getPeer(swImpl);
            int vsanId = 1;
            int ifIndex = IfIndexUtil.getVsanIfIndex(vsanId);
            return this.getIpAddressForIfIndex(peer, ifIndex);
        }
        catch (Exception ex) {
            RemoteException exc = new RemoteException(swImpl.getName() + ": " + ex.getMessage());
            exc.setStackTrace(ex.getStackTrace());
            throw exc;
        }
    }

    @Override
    public Map<Card, List<String>> getCppIpAddress(List<Card> cards) throws RemoteException {
        HashMap<Card, List<String>> results = new HashMap<Card, List<String>>();
        for (Card nextCard : cards) {
            results.put(nextCard, this.getCppIpAddress(nextCard));
        }
        return results;
    }

    public List<String> getCppIpAddress(Card card) throws RemoteException {
        SanManager sanMan = SanManager.getInstance();
        if (!(card.getSwitchPK() instanceof WwnKey)) {
            throw new RemoteException("Invalid card for DDM:" + this.cardToString(card));
        }
        SwitchImpl swImpl = sanMan.findSwitchByPK((WwnKey)card.getSwitchPK());
        try {
            SnmpPeer peer = this.getPeer(swImpl);
            int vsanId = 1;
            int ifIndex = IfIndexUtil.getCppIfIndex(card.getSlotId(), 1, vsanId);
            return this.getIpAddressForIfIndex(peer, ifIndex);
        }
        catch (Exception ex) {
            RemoteException exc = new RemoteException(swImpl.getName() + ", " + this.cardToString(card) + ": " + ex.getMessage());
            exc.setStackTrace(ex.getStackTrace());
            throw exc;
        }
    }

    @Override
    public Map<SwitchBase, String> getVsan1Wwn(List<SwitchBase> switches) throws RemoteException {
        HashMap<SwitchBase, String> results = new HashMap<SwitchBase, String>();
        for (SwitchBase nextSw : switches) {
            results.put(nextSw, this.getVsan1Wwn(nextSw));
        }
        return results;
    }

    public String getVsan1Wwn(SwitchBase sw) throws RemoteException {
        SanManager sanMan = SanManager.getInstance();
        SwitchImpl swImpl = sanMan.findSwitch((WwnKey)sw.getSwitchPK(), sw.getFabricPK());
        try {
            SnmpPeer peer = this.getPeer(swImpl);
            int vsanId = 1;
            int ifIndex = IfIndexUtil.getVsanIfIndex(vsanId);
            return this.getWwnForIfIndex(peer, ifIndex);
        }
        catch (Exception ex) {
            RemoteException exc = new RemoteException(swImpl.getName() + ": " + ex.getMessage());
            exc.setStackTrace(ex.getStackTrace());
            throw exc;
        }
    }

    @Override
    public Map<Card, String> getCppWwn(List<Card> cards) throws RemoteException {
        HashMap<Card, String> results = new HashMap<Card, String>();
        for (Card nextCard : cards) {
            results.put(nextCard, this.getCppWwn(nextCard));
        }
        return results;
    }

    public String getCppWwn(Card card) throws RemoteException {
        SanManager sanMan = SanManager.getInstance();
        if (!(card.getSwitchPK() instanceof WwnKey)) {
            throw new RemoteException("Invalid card for DDM:" + this.cardToString(card));
        }
        SwitchImpl swImpl = sanMan.findSwitchByPK((WwnKey)card.getSwitchPK());
        try {
            SnmpPeer peer = this.getPeer(swImpl);
            int vsanId = 1;
            int ifIndex = IfIndexUtil.getCppIfIndex(card.getSlotId(), 1, vsanId);
            return this.getWwnForIfIndex(peer, ifIndex);
        }
        catch (Exception ex) {
            RemoteException exc = new RemoteException(swImpl.getName() + ", " + this.cardToString(card) + ": " + ex.getMessage());
            exc.setStackTrace(ex.getStackTrace());
            throw exc;
        }
    }

    private String getWwnForIfIndex(SnmpPeer peer, int ifIndex) throws Exception {
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
        pdu.addVar(new SnmpOID(_IfPhysAddressOid, ifIndex), null);
        VarBindList resp = peer.send(pdu).getVariables();
        byte[] b = resp.byteValue(0);
        String wwn = SnmpString.toHexString(b);
        return wwn;
    }

    private List<String> getIpAddressForIfIndex(SnmpPeer peer, int ifIndex) throws Exception {
        int[] ipIndex = new int[]{ifIndex, 1};
        VarBindList vbl = new VarBindList(1);
        vbl.add(new SnmpVarBind(new SnmpOID(_CiiIPIfAddressPrefixLengthOid, ipIndex), null));
        SnmpPDU rspPdu = SnmpFetch.getBulk(peer, vbl);
        VarBindList resp = rspPdu.getVariables();
        ArrayList<String> results = new ArrayList<String>();
        for (int i = 0; i < resp.size(); ++i) {
            SnmpVarBind vb = resp.getVb(i);
            int[] index = this.getIndexForVb(vb, _CiiIPIfAddressPrefixLengthOid);
            int prefix = resp.intValue(i);
            int indexPos = 1;
            if (index[indexPos] != 1) continue;
            int n = ++indexPos;
            ++indexPos;
            int length = index[n];
            byte[] ipAddr = new byte[length];
            for (int k = 0; k < length; ++k) {
                ipAddr[k] = new Integer(index[indexPos++]).byteValue();
            }
            StringBuilder nextAddrPrefix = new StringBuilder();
            nextAddrPrefix.append(SnmpIpAddress.toString(ipAddr));
            nextAddrPrefix.append("/");
            nextAddrPrefix.append(prefix);
            results.add(nextAddrPrefix.toString());
        }
        return results;
    }

    public int[] getIndexForVb(SnmpVarBind vb, int[] mibnode) {
        int[] oid = vb.getOid().getValue();
        int[] index = new int[oid.length - mibnode.length];
        System.arraycopy(oid, oid.length - index.length, index, 0, index.length);
        return index;
    }

    @Override
    public Map<Card, Boolean> doesCppRouteToVsan1Exist(List<Card> cards, byte[][] vsanIpAddresses) throws RemoteException {
        HashMap<Card, Boolean> results = new HashMap<Card, Boolean>();
        int index = 0;
        for (Card nextCard : cards) {
            byte[] nextAddress = vsanIpAddresses[index++];
            results.put(nextCard, this.doesCppRouteToVsan1Exist(nextCard, nextAddress));
        }
        return results;
    }

    @Override
    public HashMap<SwitchBase, Exception> setVSANIpAddr(List<SwitchBase> switches, byte[][] ipAddrs, List<Integer> prefixes) throws RemoteException {
        HashMap<SwitchBase, Exception> failures = new HashMap<SwitchBase, Exception>();
        ArrayList<SetVSANIPAddressThread> threadlist = new ArrayList<SetVSANIPAddressThread>();
        int index = 0;
        for (SwitchBase nextSw : switches) {
            byte[] nextIpAddr = ipAddrs[index];
            int nextPrefix = prefixes.get(index);
            ++index;
            SetVSANIPAddressThread th = new SetVSANIPAddressThread(nextSw, nextIpAddr, nextPrefix, this);
            th.start();
            threadlist.add(th);
        }
        for (SetVSANIPAddressThread th : threadlist) {
            Exception e;
            try {
                th.join();
            }
            catch (Exception ex) {
                // empty catch block
            }
            if ((e = th.getException()) == null) continue;
            failures.put(th.getSwitch(), e);
        }
        return failures;
    }

    public void setVSANIpAddr(SwitchBase sw, byte[] ipAddr, int prefix) throws RemoteException {
        block12: {
            try {
                int vsanId = 1;
                SanManager sanMan = SanManager.getInstance();
                SwitchImpl swImpl = sanMan.findSwitch(sw.getWwn(), sw.getFabricPK());
                SnmpPeer peer = this.getPeer(swImpl);
                int ifIndex = IfIndexUtil.getVsanIfIndex(vsanId);
                int card = sw.getActiveSupSlot();
                int moduleId = sw.getModuleProcessorId(card - 1);
                try {
                    this.doVsanIf(peer, moduleId, vsanId, 4);
                }
                catch (Exception ex) {
                    if (ex.getMessage().contains("already exists")) {
                        if (this._logger.isDebugEnabled()) {
                            this._logger.debug((Object)("recieved already exists for creating virtualNwIfRowStatus entry for switch - " + sw));
                        }
                    }
                    throw ex;
                }
                try {
                    this.assignIpAddress(peer, ipAddr, prefix, ifIndex);
                }
                catch (Exception ex) {
                    if (ex.getMessage().contains("already exists")) {
                        if (this._logger.isDebugEnabled()) {
                            this._logger.debug((Object)("recieved already exists for creating vsan IP entry for switch - " + sw));
                        }
                        break block12;
                    }
                    try {
                        this.doVsanIf(peer, moduleId, vsanId, 6);
                    }
                    catch (SnmpException ex1) {
                        // empty catch block
                    }
                    throw ex;
                }
            }
            catch (Exception ex) {
                RemoteException exc = new RemoteException(ex.getMessage());
                exc.setStackTrace(ex.getStackTrace());
                throw exc;
            }
        }
    }

    @Override
    public HashMap<Card, Exception> setCppIpAddr(List<Card> cards, byte[][] ipAddrs, List<Integer> prefixes) throws RemoteException {
        HashMap<Card, Exception> failures = new HashMap<Card, Exception>();
        ArrayList<SetCppIPAddressThread> threadlist = new ArrayList<SetCppIPAddressThread>();
        int index = 0;
        for (Card nextCard : cards) {
            byte[] nextIpAddr = ipAddrs[index];
            int nextPrefix = prefixes.get(index);
            ++index;
            SetCppIPAddressThread th = new SetCppIPAddressThread(nextCard, nextIpAddr, nextPrefix, this);
            th.start();
            threadlist.add(th);
        }
        for (SetCppIPAddressThread th : threadlist) {
            Exception e;
            try {
                th.join();
            }
            catch (Exception ex) {
                // empty catch block
            }
            if ((e = th.getException()) == null) continue;
            failures.put(th.getCard(), e);
        }
        return failures;
    }

    @Override
    public HashMap<Card, Exception> setCppRouteToVsan1(List<Card> cards, byte[][] vsan1IpAddrs) throws RemoteException {
        HashMap<Card, Exception> failures = new HashMap<Card, Exception>();
        ArrayList<setCppRouteToVsan1Thread> threadlist = new ArrayList<setCppRouteToVsan1Thread>();
        int index = 0;
        for (Card nextCard : cards) {
            byte[] nextIpAddr = vsan1IpAddrs[index];
            ++index;
            setCppRouteToVsan1Thread th = new setCppRouteToVsan1Thread(nextCard, nextIpAddr, this);
            th.start();
            threadlist.add(th);
        }
        for (setCppRouteToVsan1Thread th : threadlist) {
            Exception e;
            try {
                th.join();
            }
            catch (Exception ex) {
                // empty catch block
            }
            if ((e = th.getException()) == null) continue;
            failures.put(th.getCard(), e);
        }
        return failures;
    }

    @Override
    public HashMap<DMMPeerCfg, Exception> createPeerRoutes(List<DMMPeerCfg> peerCfgs) throws RemoteException {
        HashMap<DMMPeerCfg, Exception> failures = new HashMap<DMMPeerCfg, Exception>();
        ArrayList<createPeerRoutesThread> threadlist = new ArrayList<createPeerRoutesThread>();
        for (DMMPeerCfg next : peerCfgs) {
            createPeerRoutesThread th = new createPeerRoutesThread(next, this);
            th.start();
            threadlist.add(th);
        }
        for (createPeerRoutesThread th : threadlist) {
            Exception e;
            try {
                th.join();
            }
            catch (Exception ex) {
                // empty catch block
            }
            if ((e = th.getException()) == null) continue;
            failures.put(th.getPeerCfg(), e);
        }
        return failures;
    }

    public void setCppIpAddr(Card card, byte[] ipAddr, int prefix) throws RemoteException {
        try {
            int vsanId = 1;
            SanManager sanMan = SanManager.getInstance();
            if (!(card.getSwitchPK() instanceof WwnKey)) {
                throw new RemoteException("Invalid card for DDM:" + this.cardToString(card));
            }
            SwitchImpl swImpl = sanMan.findSwitchByPK((WwnKey)card.getSwitchPK());
            SnmpPeer peer = this.getPeer(swImpl);
            int ifIndex = IfIndexUtil.getCppIfIndex(card.getSlotId(), 1, vsanId);
            SwitchBase sw = (SwitchBase)swImpl.getBaseObject();
            int module = card.getSlotId();
            int moduleId = sw.getModuleProcessorId(module - 1);
            this.doVsanIf(peer, moduleId, vsanId, 4);
            try {
                this.assignIpAddress(peer, ipAddr, prefix, ifIndex);
            }
            catch (Exception ex) {
                try {
                    this.doVsanIf(peer, moduleId, vsanId, 6);
                }
                catch (SnmpException ex1) {
                    // empty catch block
                }
                throw ex;
            }
        }
        catch (Exception ex) {
            if (ex.getMessage().contains("already exists")) {
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug((Object)("recieved already exists for creating cpp IP address entry for card - " + card));
                }
            }
            RemoteException exc = new RemoteException(ex.getMessage());
            exc.setStackTrace(ex.getStackTrace());
            throw exc;
        }
    }

    public void assignIpAddress(SnmpPeer peer, byte[] ipAddr, int prefix, int ifIndex) throws SnmpException {
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        int[] ipIndex = new int[ipAddr.length + 3];
        ipIndex[0] = ifIndex;
        ipIndex[1] = ipAddr.length == 16 ? 2 : 1;
        ipIndex[2] = ipAddr.length;
        int i = 0;
        int j = 3;
        while (i < ipAddr.length) {
            ipIndex[j] = ipAddr[i] & 0xFF;
            ++i;
            ++j;
        }
        int defaultMask = ipAddr.length == 16 ? 64 : 24;
        pdu.addVar(new SnmpOID(_CiiIPIfAddressStatusOid, ipIndex), new SnmpInt(4));
        pdu.addVar(new SnmpOID(_CiiIPIfAddressPrefixLengthOid, ipIndex), new SnmpUnsignedInt(prefix == 0 ? (long)defaultMask : (long)prefix));
        peer.set(pdu);
        this.setAdminStatusForInterface(peer, 1, ifIndex);
    }

    public void setAdminStatusForInterface(SnmpPeer peer, int status, int ifIndex) throws SnmpException {
        VarBindList varList = new VarBindList();
        varList.add(_ifAdminStatusOid, ifIndex, (SnmpVar)new SnmpInt(status));
        SnmpPDU pdu = new SnmpPDU(-93, varList);
        pdu.setIgnoreSetCount(true);
        peer.set(pdu);
    }

    public boolean doesCppRouteToVsan1Exist(Card card, byte[] vsanIpAddress) throws RemoteException {
        boolean exists = false;
        SanManager sanMan = SanManager.getInstance();
        if (!(card.getSwitchPK() instanceof WwnKey)) {
            throw new RemoteException("Invalid card for DDM:" + this.cardToString(card));
        }
        SwitchImpl swImpl = sanMan.findSwitchByPK((WwnKey)card.getSwitchPK());
        try {
            int i;
            byte[] dest = new byte[]{0, 0, 0, 0};
            int vsanId = 1;
            boolean metric = false;
            SnmpPeer peer = this.getPeer(swImpl);
            int ifIndex = IfIndexUtil.getCppIfIndex(card.getSlotId(), 1, vsanId);
            SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
            int[] index = new int[vsanIpAddress.length + dest.length + 4];
            int j = 0;
            index[j++] = card.getSlotId();
            index[j++] = 1;
            for (i = 0; i < dest.length; ++i) {
                index[j++] = dest[i] & 0xFF;
            }
            index[j++] = 0;
            index[j++] = vsanIpAddress.length == 16 ? 2 : 1;
            for (i = 0; i < vsanIpAddress.length; ++i) {
                index[j++] = vsanIpAddress[i] & 0xFF;
            }
            pdu.addVar(new SnmpOID(_CInetCidrRouteIfIndexOid, index), null);
            VarBindList resp = peer.send(pdu).getVariables();
            int response = resp.get(0).intValue();
            if (response == ifIndex) {
                exists = true;
            }
        }
        catch (Exception ex) {
            RemoteException exc = new RemoteException("Unable to find default gateway to VSAN 1 IP " + swImpl.getName() + "," + this.cardToString(card) + ": received error (" + ex.getMessage() + ") ");
            exc.setStackTrace(ex.getStackTrace());
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)exc);
            }
            exists = false;
        }
        return exists;
    }

    public void setCppRouteToVsan1(Card card, byte[] vsanIpAddress) throws RemoteException {
        try {
            int i;
            byte[] dest = new byte[]{0, 0, 0, 0};
            int vsanId = 1;
            int metric = 0;
            SanManager sanMan = SanManager.getInstance();
            if (!(card.getSwitchPK() instanceof WwnKey)) {
                throw new RemoteException("Invalid card for DDM:" + this.cardToString(card));
            }
            SwitchImpl swImpl = sanMan.findSwitchByPK((WwnKey)card.getSwitchPK());
            SnmpPeer peer = this.getPeer(swImpl);
            int ifIndex = IfIndexUtil.getCppIfIndex(card.getSlotId(), 1, vsanId);
            SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
            int[] index = new int[vsanIpAddress.length + dest.length + 4];
            int j = 0;
            index[j++] = card.getSlotId();
            index[j++] = 1;
            for (i = 0; i < dest.length; ++i) {
                index[j++] = dest[i] & 0xFF;
            }
            index[j++] = 0;
            index[j++] = vsanIpAddress.length == 16 ? 2 : 1;
            for (i = 0; i < vsanIpAddress.length; ++i) {
                index[j++] = vsanIpAddress[i] & 0xFF;
            }
            pdu.addVar(new SnmpOID(_CInetCidrRouteStatusOid, index), new SnmpInt(4));
            pdu.addVar(new SnmpOID(_CInetCidrRouteIfIndexOid, index), new SnmpInt(ifIndex));
            pdu.addVar(new SnmpOID(_CInetCidrRouteMetric1Oid, index), new SnmpInt(metric));
            peer.set(pdu);
        }
        catch (Exception ex) {
            if (ex.getMessage().contains("already exists")) {
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug((Object)("recieved already exists for creating default-gateway entry for card - " + card));
                }
            }
            RemoteException exc = new RemoteException(ex.getMessage());
            exc.setStackTrace(ex.getStackTrace());
            throw exc;
        }
    }

    public void createPeerRoutes(Card sourceCard, byte[] sourceIp, int sourceMask, Card peerCard, byte[] peerIp, int peermask) throws RemoteException {
        int i;
        int j;
        int[] index;
        SnmpPDU pdu;
        int ifIndex;
        int metric;
        SanManager sanMan = SanManager.getInstance();
        if (!(sourceCard.getSwitchPK() instanceof WwnKey)) {
            throw new RemoteException("Invalid card for DDM:" + this.cardToString(sourceCard));
        }
        if (!(peerCard.getSwitchPK() instanceof WwnKey)) {
            throw new RemoteException("Invalid card for DDM:" + this.cardToString(peerCard));
        }
        SwitchImpl swImpl = sanMan.findSwitchByPK((WwnKey)sourceCard.getSwitchPK());
        SwitchImpl peerswImpl = sanMan.findSwitchByPK((WwnKey)peerCard.getSwitchPK());
        try {
            metric = 0;
            SnmpPeer cardSnmpPeer = this.getPeer(swImpl);
            ifIndex = IfIndexUtil.name2IfIndex("mgmt0");
            byte[] peerSwIp = SnmpIpAddress.parse(peerswImpl.getIpAddress());
            pdu = new SnmpPDU(-93, new VarBindList());
            index = new int[peerSwIp.length + peerIp.length + 4];
            j = 0;
            index[j++] = 0;
            index[j++] = 1;
            for (i = 0; i < peerIp.length; ++i) {
                index[j++] = peerIp[i] & 0xFF;
            }
            index[j++] = peermask;
            index[j++] = peerSwIp.length == 16 ? 2 : 1;
            for (i = 0; i < peerSwIp.length; ++i) {
                index[j++] = peerSwIp[i] & 0xFF;
            }
            pdu.addVar(new SnmpOID(_CInetCidrRouteStatusOid, index), new SnmpInt(4));
            pdu.addVar(new SnmpOID(_CInetCidrRouteIfIndexOid, index), new SnmpInt(ifIndex));
            pdu.addVar(new SnmpOID(_CInetCidrRouteMetric1Oid, index), new SnmpInt(metric));
            cardSnmpPeer.set(pdu);
        }
        catch (Exception ex) {
            if (ex.getMessage().contains("already exists")) {
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug((Object)("received already exists for creating peer entry for card - " + sourceCard));
                }
            }
            RemoteException exc = new RemoteException("Unable to create route on module to peer ip:" + ex.getMessage());
            exc.setStackTrace(ex.getStackTrace());
            throw exc;
        }
        try {
            metric = 0;
            SnmpPeer peerSnmpPeer = this.getPeer(peerswImpl);
            ifIndex = IfIndexUtil.name2IfIndex("mgmt0");
            byte[] sourceMgmtIp = SnmpIpAddress.parse(swImpl.getIpAddress());
            pdu = new SnmpPDU(-93, new VarBindList());
            index = new int[sourceMgmtIp.length + sourceIp.length + 4];
            j = 0;
            index[j++] = 0;
            index[j++] = 1;
            for (i = 0; i < sourceIp.length; ++i) {
                index[j++] = sourceIp[i] & 0xFF;
            }
            index[j++] = sourceMask;
            index[j++] = sourceMgmtIp.length == 16 ? 2 : 1;
            for (i = 0; i < sourceMgmtIp.length; ++i) {
                index[j++] = sourceMgmtIp[i] & 0xFF;
            }
            pdu.addVar(new SnmpOID(_CInetCidrRouteStatusOid, index), new SnmpInt(4));
            pdu.addVar(new SnmpOID(_CInetCidrRouteIfIndexOid, index), new SnmpInt(ifIndex));
            pdu.addVar(new SnmpOID(_CInetCidrRouteMetric1Oid, index), new SnmpInt(metric));
            peerSnmpPeer.set(pdu);
        }
        catch (Exception ex) {
            if (ex.getMessage().contains("already exists")) {
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug((Object)("received already exists for creating peer entry for card - " + peerCard));
                }
            }
            RemoteException exc = new RemoteException("Unable to create route on peer to module IP:" + ex.getMessage());
            exc.setStackTrace(ex.getStackTrace());
            throw exc;
        }
    }

    @Override
    public Map<Card, Exception> setFeatureEnabledDmmSe(List<Card> cards, String featureName) throws RemoteException {
        try {
            HashMap<Card, Exception> failures = new HashMap<Card, Exception>();
            for (Card nextCard : cards) {
                try {
                    int cardtype = nextCard.getType();
                    if (featureName.trim().equals("se") || featureName.trim().equals("dmm")) {
                        if (cardtype == 5 || cardtype == 20) {
                            int startPort = IfIndexUtil.name2IfIndex("fc" + nextCard.getSlotId() + '/' + 1);
                            int endPort = IfIndexUtil.name2IfIndex("fc" + nextCard.getSlotId() + '/' + nextCard.getNumPorts());
                            this.setFeatureEnabledDmmSSMCard(nextCard, featureName, startPort, endPort);
                            continue;
                        }
                        if (cardtype == 44) {
                            this.setFeatureEnabledDmmSeMSMCard(nextCard, featureName, 1, 4);
                            continue;
                        }
                        this.setFeatureEnabledDmmSeMSMCard(nextCard, featureName, 1, 1);
                        continue;
                    }
                    throw new Exception("Feature name provided is not supported by this method, feature name - " + featureName);
                }
                catch (Exception e) {
                    failures.put(nextCard, e);
                }
            }
            return failures;
        }
        catch (Exception ex) {
            RemoteException exc = new RemoteException(ex.getMessage());
            exc.setStackTrace(ex.getStackTrace());
            throw exc;
        }
    }

    public void setFeatureEnabledDmmSSMCard(Card card, String featureName, int startPort, int endPort) throws Exception {
        SanManager sanMan = SanManager.getInstance();
        if (!(card.getSwitchPK() instanceof WwnKey)) {
            throw new RemoteException("Invalid card for DDM:" + this.cardToString(card));
        }
        SwitchImpl swImpl = sanMan.findSwitchByPK((WwnKey)card.getSwitchPK());
        SnmpPeer peer = this.getPeer(swImpl);
        byte[] featureNameByte = new SnmpString(featureName).getValue();
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        int[] index = new int[3 + featureNameByte.length];
        int j = 0;
        index[j++] = startPort;
        index[j++] = endPort;
        index[j++] = featureNameByte.length;
        for (int n : featureNameByte) {
            index[j++] = n;
        }
        pdu.addVar(new SnmpOID(_SsmProvFeatureIfRowStatus, index), new SnmpInt(4));
        try {
            peer.set(pdu);
        }
        catch (SnmpException se) {
            if (se.getMessage().contains("already exists")) {
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug((Object)("received already exists for creating dmm feature entry for card - " + card));
                }
            }
            RemoteException exc = new RemoteException(se.getMessage());
            exc.setStackTrace(se.getStackTrace());
            throw exc;
        }
    }

    public void setFeatureEnabledDmmSeMSMCard(Card card, String featureName, int startNodeOrPort, int endNodeOrPort) throws Exception {
        SanManager sanMan = SanManager.getInstance();
        if (!(card.getSwitchPK() instanceof WwnKey)) {
            throw new RemoteException("Invalid card for DDM:" + this.cardToString(card));
        }
        SwitchImpl swImpl = sanMan.findSwitchByPK((WwnKey)card.getSwitchPK());
        SnmpPeer peer = this.getPeer(swImpl);
        boolean vsanId = true;
        byte[] featureNameByte = new SnmpString(featureName).getValue();
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        int[] index = new int[4 + featureNameByte.length];
        int j = 0;
        SwitchBase sw = (SwitchBase)swImpl.getBaseObject();
        int module = card.getSlotId();
        int moduleId = module + sw.getModuleIndexOffset();
        index[j++] = moduleId;
        index[j++] = startNodeOrPort;
        index[j++] = endNodeOrPort;
        index[j++] = featureNameByte.length;
        for (int n : featureNameByte) {
            index[j++] = n;
        }
        pdu.addVar(new SnmpOID(_SsmSsnProvFeatureRowStatus, index), new SnmpInt(4));
        try {
            peer.set(pdu);
        }
        catch (SnmpException se) {
            if (se.getMessage().contains("already exists")) {
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug((Object)("received already exists for creating dmm feature entry for card - " + card));
                }
            }
            throw se;
        }
    }

    protected int[] getInsertIndex(int vsanId, int moduleId) {
        int[] index = new int[]{moduleId, 1, vsanId};
        return index;
    }

    public void doVsanIf(SnmpPeer peer, int moduleId, int vsanId, int operation) throws SnmpException {
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        SnmpInt oper = new SnmpInt(operation);
        int[] index = this.getInsertIndex(vsanId, moduleId);
        pdu.addVar(new SnmpOID(_VirtualNwIfRowStatusOid, index), oper);
        peer.set(pdu);
    }

    private SnmpPDU constructEnableSSHPdu() {
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.setIgnoreSetCount(true);
        pdu.setRetries(0);
        pdu.addVar(new SnmpOID(_CssServiceActivationOid, 0), new SnmpInt(1));
        return pdu;
    }

    private SnmpPDU constructEnableIpv4RoutingPdu() {
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.setIgnoreSetCount(true);
        pdu.setRetries(0);
        pdu.addVar(new SnmpOID(_IpForwardingOid, 0), new SnmpInt(1));
        return pdu;
    }

    protected static VarBindList buildVbl(int[][] oid, int index) {
        VarBindList vbl = new VarBindList(oid.length);
        for (int i = 0; i < oid.length; ++i) {
            if (index == 0) {
                vbl.add(new SnmpVarBind(new SnmpOID(oid[i]), null));
                continue;
            }
            vbl.add(new SnmpVarBind(new SnmpOID(oid[i], index)));
        }
        return vbl;
    }

    private String cardToString(Card card) {
        return new StringBuffer("Module ").append(card.getSlotId()).append("(").append(card.getModelName()).append(")").toString();
    }
}

