/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.facade;

import com.cisco.dcbu.lib.channel.ChannelFilterIf;
import com.cisco.dcbu.lib.rmi.ChannelConsumerRif;
import com.cisco.dcbu.lib.serviceconf.ServiceConfig;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.sm.common.event.LogEvent;
import com.cisco.dcbu.sm.common.event.LogEventType;
import com.cisco.dcbu.sm.common.event.PortLogEventType;
import com.cisco.dcbu.sm.common.rif.EMRif;
import com.cisco.dcbu.sm.server.em.AlertNotifier;
import com.cisco.dcbu.sm.server.em.EventManagerService;
import java.net.InetAddress;
import java.rmi.RemoteException;

public enum EMImpl implements EMRif
{
    INSTANCE;

    private EventManagerService _em = (EventManagerService)ServiceConfig.findService("Event Manager Service");
    private AlertNotifier _ef = AlertNotifier.getInstance();
    private static EMImpl _instance;

    public static EMImpl getInstance() {
        return INSTANCE;
    }

    @Override
    public void start(int type) throws RemoteException {
        this.checkLocal();
        try {
            this._em.start(type);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void stop(int type) throws RemoteException {
        this.checkLocal();
        try {
            this._em.stop(type);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public boolean isRunning(int type) throws RemoteException {
        this.checkLocal();
        try {
            return this._em.isRunning(type);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public String getSubStatus(int type) throws RemoteException {
        this.checkLocal();
        try {
            return this._em.getSubStatus(type);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public String getStatus() throws RemoteException {
        this.checkLocal();
        try {
            return this._em.getStatus();
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public String getHtmlStatus() throws RemoteException {
        this.checkLocal();
        try {
            return this._em.getHtmlStatus();
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public String getTrapStatistics() throws RemoteException {
        this.checkLocal();
        try {
            return this._em.getTrapStatistics();
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public String getSyslogStatistics() throws RemoteException {
        this.checkLocal();
        try {
            return this._em.getSyslogStatistics();
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public boolean addSource(InetAddress ipAddr) throws RemoteException {
        this.checkLocal();
        try {
            return this._em.addSource(ipAddr);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void deleteSource(InetAddress ipAddr) throws RemoteException {
        this.checkLocal();
        try {
            this._em.deleteSource(ipAddr);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void addConsumer(ChannelConsumerRif consumer, ChannelFilterIf filter, int type) throws RemoteException {
        this.checkLocal();
        try {
            this._em.addConsumer(consumer, filter, type);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void addConsumer(ChannelConsumerRif consumer, ChannelFilterIf filter, byte[][] lowLevelTrapOids) throws RemoteException {
        this.checkLocal();
        try {
            this._em.addConsumer(consumer, filter, lowLevelTrapOids);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void deleteConsumer(ChannelConsumerRif consumer, int type) throws RemoteException {
        this.checkLocal();
        try {
            this._em.deleteConsumer(consumer, type);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public boolean isTrapListening() throws RemoteException {
        this.checkLocal();
        try {
            return this._em.isTrapListening();
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public InetAddress getTrapRegAddress() throws RemoteException {
        this.checkLocal();
        try {
            return this._em.getTrapRegAddress();
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public int getTrapPort() throws RemoteException {
        this.checkLocal();
        try {
            return this._em.getTrapPort();
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public InetAddress getSyslogAddress() throws RemoteException {
        this.checkLocal();
        try {
            return this._em.getSyslogAddress();
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public int getSyslogPort() throws RemoteException {
        this.checkLocal();
        try {
            return this._em.getSyslogPort();
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public boolean isSnmpTrapTraceEnabled() throws RemoteException {
        this.checkLocal();
        try {
            return this._em.isSnmpTrapTraceEnabled();
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void enableSnmpTrapTrace(boolean b) throws RemoteException {
        this.checkLocal();
        try {
            this._em.enableSnmpTrapTrace(b);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void sendEvent(LogEvent ev) throws RemoteException {
        this.checkLocal();
        try {
            this._em.sendEvent(ev);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public Object[][] getSourceState() throws RemoteException {
        this.checkLocal();
        try {
            return this._em.getSourceState();
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public Object[][] getSourceState(String switchIp) throws RemoteException {
        this.checkLocal();
        try {
            return this._em.getSourceState(switchIp);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    void checkLocal() throws RemoteException {
        boolean isLocal = false;
        try {
            isLocal = NetUtil.isLocalHost(this.getClientHost());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!isLocal) {
            throw new RemoteException("Only local access allowed");
        }
    }

    @Override
    public boolean addEventForward(int type, String address, LogEventType eventType, int subEventType, long fid, String vsanScope, int severity, long gid, int dctype, String facility, String sysType, String desRegx, int portGroupId) throws RemoteException {
        boolean added = false;
        try {
            added = this._ef.addEventForward(type, address, eventType, subEventType, fid, vsanScope, severity, gid, dctype, facility, sysType, desRegx, portGroupId);
        }
        catch (Exception ex) {
            added = false;
            throw new RemoteException("Unable to add event forward.");
        }
        return added;
    }

    @Override
    public boolean addEventForward(int type, String address, LogEventType eventType, long fid, String vsanScope, int severity) throws RemoteException {
        return this.addEventForward(type, address, eventType, PortLogEventType.ALL, fid, vsanScope, severity);
    }

    @Override
    public boolean addEventForward(int type, String address, LogEventType eventType, PortLogEventType eventSubType, long fid, String vsanScope, int severity) throws RemoteException {
        boolean added = false;
        try {
            added = this._ef.addEventForward(type, address, eventType, eventSubType.value(), fid, vsanScope, severity, -1L, 0, "", "", "", -1);
        }
        catch (Exception ex) {
            added = false;
            throw new RemoteException("Unable to add event forward.");
        }
        return added;
    }

    @Override
    public boolean addEventForward(int type, String address, long fid, String vsanScope, int severity) throws RemoteException {
        return this.addEventForward(type, address, LogEventType.ALL, fid, vsanScope, severity);
    }

    @Override
    public boolean removeEventForward(long eid) throws RemoteException {
        boolean removed = false;
        try {
            removed = this._ef.removeEventForward(eid);
        }
        catch (Exception ex) {
            removed = false;
            throw new RemoteException("Unable to remove event forward.");
        }
        return removed;
    }

    public String getClientHost() {
        return "localhost";
    }

    static {
        _instance = null;
    }
}

