/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.facade;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.sm.common.dto.ESPDto;
import com.cisco.dcbu.sm.common.dto.SecurityAssociationDto;
import com.cisco.dcbu.sm.common.model.IslBase;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.rif.ESPRif;
import com.cisco.dcbu.sm.common.rif.SessionRif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.esp.ESPManager;
import com.cisco.dcbu.sm.server.model.ChannelMemberIsl;
import com.cisco.dcbu.sm.server.model.IslImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.security.FMUser;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ESPImpl
implements ESPRif {
    public static final String BOGOTA_VERSION = "5.0(0)";
    static final int[] _CfcspSPIOid = MibNode.get("cfcspSPI").getOid();
    static final int[] _CfcspSaltOid = MibNode.get("cfcspSalt").getOid();
    static final int[] _CfcspKeyOid = MibNode.get("cfcspKey").getOid();
    static final int[] _CfcspESPModeOid = MibNode.get("cfcspESPMode").getOid();
    static final int[] _CfcspIngressSA1Oid = MibNode.get("cfcspIngressSA1").getOid();
    static final int[] _CfcspIngressSA2Oid = MibNode.get("cfcspIngressSA2").getOid();
    static final int[] _CfcspEgressSAOid = MibNode.get("cfcspEgressSA").getOid();
    static final int[] _CfcspEspSAMethod = MibNode.get("cfcspEspSAMethod").getOid();
    static int[][] _FcspSaVbl = new int[2][];
    transient Logger _logger = null;
    private SessionRif _session;
    private FMUser _user = null;

    @Override
    public void init(SessionRif session) throws RemoteException {
        this._logger = LogManager.getLogger((String)"fms.esp");
        if (this._session == null) {
            this._session = session;
        }
        if (this._user == null) {
            this._user = this._session.getUser();
        }
    }

    @Override
    public List<SecurityAssociationDto> getFcspSA(SwitchBase sw) throws RemoteException {
        SanManager sanMan = SanManager.getInstance();
        SwitchImpl swImpl = sanMan.findSwitch(sw.getWwn(), sw.getFabricPK());
        try {
            SnmpPeer peer = this.getPeer(swImpl);
            SnmpPDU rspPdu = SnmpFetch.getBulk(peer, ESPImpl.buildVbl(_FcspSaVbl, 0));
            VarBindList resp = rspPdu.getVariables();
            ArrayList<SecurityAssociationDto> results = new ArrayList<SecurityAssociationDto>();
            for (int i = 0; i < resp.size(); i += _FcspSaVbl.length) {
                int[] oid = resp.getVb(i).getOid().getValue();
                int spi = oid[oid.length - 1];
                long salt = resp.longValue(i);
                byte[] key = resp.byteValue(i + 1);
                String keyStr = SnmpString.toHexString(key, 0, key.length, false);
                SecurityAssociationDto dto = new SecurityAssociationDto(spi, salt, keyStr);
                results.add(dto);
            }
            return results;
        }
        catch (Exception ex) {
            RemoteException exc = new RemoteException("Unable to retrieve Security Associations for switch " + sw + ": received error (" + ex.getMessage() + ") ");
            exc.setStackTrace(ex.getStackTrace());
            throw exc;
        }
    }

    @Override
    public Map<SwitchBase, List<SecurityAssociationDto>> getFcspSA(List<SwitchBase> switches) throws RemoteException {
        HashMap<SwitchBase, List<SecurityAssociationDto>> results = new HashMap<SwitchBase, List<SecurityAssociationDto>>();
        ArrayList<QuerySAThread> threadlist = new ArrayList<QuerySAThread>();
        for (SwitchBase nextSwitch : switches) {
            QuerySAThread th = new QuerySAThread(nextSwitch);
            th.start();
            threadlist.add(th);
        }
        for (QuerySAThread th : threadlist) {
            try {
                th.join();
            }
            catch (Exception ex) {
                // empty catch block
            }
            RemoteException e = th.getException();
            if (e != null) {
                throw e;
            }
            results.put(th._switch, th.getList());
        }
        return results;
    }

    @Override
    public long setFcspSa(Map<SwitchBase, List<SecurityAssociationDto>> swSa, Object channelOrQueue) throws RemoteException {
        try {
            return ESPManager.getInstance().setFcspSa(swSa, this._user, channelOrQueue);
        }
        catch (Exception e) {
            throw new RemoteException("Error while setting SA on Switches ", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<ESPDto> getFcspEsp(IslBase isl) throws RemoteException {
        ArrayList<ESPDto> results = new ArrayList<ESPDto>();
        if (isl.isPortChannel()) {
            SanManager sanMan = SanManager.getInstance();
            FabricPK fpk = isl.getFabricPK();
            SwitchImpl sw1 = sanMan.findSwitch(isl.getSwitch1PK(), fpk);
            if (sw1.isVersionGreaterThanEqual(BOGOTA_VERSION)) {
                results.add(this.getFcspEsp(isl.getSwitch1PK(), isl.getIfIndex1()));
            } else {
                IslImpl islImpl = sw1.getFabric().findIsl(isl.getIslPK().getSwitchIntKey1());
                List<ChannelMemberIsl> pcIsls = islImpl.getPCMemberLinks();
                if (pcIsls.size() <= 0) throw new RemoteException("Unable to retrieve ESP for port channel ISL " + isl + " as the port channel member list was empty.");
                ChannelMemberIsl firstPcIsl = pcIsls.get(0);
                IslBase fpcIslBase = (IslBase)firstPcIsl.getBaseObject();
                ESPDto dto = fpcIslBase.getSwitch1PK().equals(isl.getSwitch1PK()) ? this.getFcspEsp(isl.getSwitch1PK(), fpcIslBase.getIfIndex1()) : this.getFcspEsp(isl.getSwitch1PK(), fpcIslBase.getIfIndex2());
                if (dto != null) {
                    dto.setIfIndex(isl.getIfIndex1());
                }
                results.add(dto);
            }
            SwitchImpl sw2 = sanMan.findSwitch(isl.getSwitch2PK(), fpk);
            if (sw2.isVersionGreaterThanEqual(BOGOTA_VERSION)) {
                results.add(this.getFcspEsp(isl.getSwitch2PK(), isl.getIfIndex2()));
                return results;
            } else {
                IslImpl islImpl = sw2.getFabric().findIsl(isl.getIslPK().getSwitchIntKey2());
                List<ChannelMemberIsl> pcIsls = islImpl.getPCMemberLinks();
                if (pcIsls.size() <= 0) throw new RemoteException("Unable to retrieve ESP for port channel ISL " + isl + " as the port channel member list was empty.");
                ChannelMemberIsl firstPcIsl = pcIsls.get(0);
                IslBase fpcIslBase = (IslBase)firstPcIsl.getBaseObject();
                ESPDto dto = fpcIslBase.getSwitch1PK().equals(isl.getSwitch2PK()) ? this.getFcspEsp(isl.getSwitch2PK(), fpcIslBase.getIfIndex1()) : this.getFcspEsp(isl.getSwitch2PK(), fpcIslBase.getIfIndex2());
                if (dto != null) {
                    dto.setIfIndex(isl.getIfIndex2());
                }
                results.add(dto);
            }
            return results;
        } else {
            results.add(this.getFcspEsp(isl.getSwitch1PK(), isl.getIfIndex1()));
            results.add(this.getFcspEsp(isl.getSwitch2PK(), isl.getIfIndex2()));
        }
        return results;
    }

    @Override
    public Map<IslBase, List<ESPDto>> getFcspEsp(List<IslBase> isls) throws RemoteException {
        HashMap<IslBase, List<ESPDto>> results = new HashMap<IslBase, List<ESPDto>>();
        ArrayList<QueryISLESPThread> threadlist = new ArrayList<QueryISLESPThread>();
        for (IslBase nextIsl : isls) {
            QueryISLESPThread th = new QueryISLESPThread(nextIsl);
            th.start();
            threadlist.add(th);
        }
        for (QueryISLESPThread th : threadlist) {
            try {
                th.join();
            }
            catch (Exception ex) {
                // empty catch block
            }
            RemoteException e = th.getException();
            if (e != null) {
                throw e;
            }
            results.put(th._isl, th.getList());
        }
        return results;
    }

    @Override
    public long setFcspESP(Map<IslBase, ESPDto> isls, Object channelOrQueue) throws RemoteException {
        try {
            return ESPManager.getInstance().setFcspESP(isls, this._user, channelOrQueue);
        }
        catch (Exception e) {
            throw new RemoteException("Error while setting ESP on ISLs ", e);
        }
    }

    @Override
    public long saveRunningConfigOnSwitch(List<SwitchBase> switches, Object channelOrQueue) throws RemoteException {
        try {
            return ESPManager.getInstance().saveRunningConfigOnSwitch(switches, this._user, channelOrQueue);
        }
        catch (Exception e) {
            throw new RemoteException("Error while saving running config", e);
        }
    }

    private ESPDto getFcspEsp(WwnKey sw, int ifIndex) throws RemoteException {
        SanManager sanMan = SanManager.getInstance();
        SwitchImpl swImpl = sanMan.findSwitchByPK(sw);
        try {
            SnmpPeer peer = this.getPeer(swImpl);
            SnmpPDU pdu = new SnmpPDU(-96, new VarBindList(5));
            pdu.addNull(new SnmpOID(_CfcspESPModeOid, ifIndex));
            pdu.addNull(new SnmpOID(_CfcspIngressSA1Oid, ifIndex));
            pdu.addNull(new SnmpOID(_CfcspIngressSA2Oid, ifIndex));
            pdu.addNull(new SnmpOID(_CfcspEgressSAOid, ifIndex));
            pdu.addNull(new SnmpOID(_CfcspEspSAMethod, ifIndex));
            VarBindList resp = peer.send(pdu).getVariables();
            int espMode = resp.intValue(0);
            int ingressSa1 = resp.intValue(1);
            int ingressSa2 = resp.intValue(2);
            int egressSa = resp.intValue(3);
            int keyGenMethod = resp.intValue(4);
            ESPDto dto = new ESPDto((SwitchBase)swImpl.getBaseObject(), espMode, ingressSa1, ingressSa2, egressSa, ifIndex, keyGenMethod);
            return dto;
        }
        catch (Exception ex) {
            RemoteException exc = new RemoteException("Unable to retrieve ESP for switch " + swImpl + ": received error (" + ex.getMessage() + ") ");
            exc.setStackTrace(ex.getStackTrace());
            throw exc;
        }
    }

    @Override
    public void destroyPtoPQueue(Object channelOrQueue) throws RemoteException {
        try {
            ESPManager.getInstance().destroyPtoPQueue(channelOrQueue);
        }
        catch (Exception e) {
            throw new RemoteException("Error while destroying point to point queue ", e);
        }
    }

    protected static VarBindList buildVbl(int[][] oid, int index) {
        VarBindList vbl = new VarBindList(oid.length);
        for (int i = 0; i < oid.length; ++i) {
            if (index == 0) {
                vbl.add(new SnmpVarBind(new SnmpOID(oid[i]), null));
                continue;
            }
            vbl.add(new SnmpVarBind(new SnmpOID(oid[i], index)));
        }
        return vbl;
    }

    private SnmpPeer getPeer(SwitchImpl swImpl) throws Exception {
        FabricPK fabricPK = swImpl.getFabricPK();
        SnmpUser snmpUser = this._user.getSnmpUser(fabricPK);
        if (snmpUser == null) {
            throw new Exception("No SNMP credential");
        }
        return SnmpPeer.getSnmpPeer(swImpl.getInetAddress(), SnmpSession.getInstance(), snmpUser);
    }

    static {
        ESPImpl._FcspSaVbl[0] = _CfcspSaltOid;
        ESPImpl._FcspSaVbl[1] = _CfcspKeyOid;
    }

    class QueryISLESPThread
    extends Thread {
        private IslBase _isl;
        private RemoteException _ex = null;
        List<ESPDto> _islEsp = null;

        public QueryISLESPThread(IslBase isl) {
            this._isl = isl;
        }

        @Override
        public void run() {
            try {
                this._islEsp = ESPImpl.this.getFcspEsp(this._isl);
            }
            catch (RemoteException e) {
                this._ex = e;
            }
        }

        public RemoteException getException() {
            return this._ex;
        }

        public List<ESPDto> getList() {
            return this._islEsp;
        }
    }

    class QuerySAThread
    extends Thread {
        private SwitchBase _switch;
        private RemoteException _ex = null;
        List<SecurityAssociationDto> _swSa = null;

        public QuerySAThread(SwitchBase sw) {
            this._switch = sw;
        }

        @Override
        public void run() {
            try {
                this._swSa = ESPImpl.this.getFcspSA(this._switch);
            }
            catch (RemoteException e) {
                this._ex = e;
            }
        }

        public RemoteException getException() {
            return this._ex;
        }

        public List<SecurityAssociationDto> getList() {
            return this._swSa;
        }
    }
}

