/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.facade;

import com.cisco.dcbu.jaxws.ep.IdentityManager;
import com.cisco.dcbu.jaxws.ep.InvalidCredentialException;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.serviceconf.ServiceConfig;
import com.cisco.dcbu.lib.snmp.security.CommunityUser;
import com.cisco.dcbu.lib.snmp.security.CommunityUserEntry;
import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.lib.snmp.security.UsmUser;
import com.cisco.dcbu.lib.snmp.security.UsmUserEntry;
import com.cisco.dcbu.lib.util.PropertyWrapper;
import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.sm.common.event.ChangedModelObject;
import com.cisco.dcbu.sm.common.event.LogEvent;
import com.cisco.dcbu.sm.common.event.LogEventType;
import com.cisco.dcbu.sm.common.event.Severity;
import com.cisco.dcbu.sm.common.model.FMUserBase;
import com.cisco.dcbu.sm.common.model.SnmpCommunityBase;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.rif.IscRif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.ComponentManager;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.InventoryPersistentManager;
import com.cisco.dcbu.sm.server.event.EventLoggerService;
import com.cisco.dcbu.sm.server.facade.FMServerImpl;
import com.cisco.dcbu.sm.server.facade.PMImpl;
import com.cisco.dcbu.sm.server.facade.SessionImpl;
import com.cisco.dcbu.sm.server.licmgr.LicenseManager;
import com.cisco.dcbu.sm.server.model.ClusterImpl;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.GlobalFabricManager;
import com.cisco.dcbu.sm.server.model.PmPolicyImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SnmpCommunityImpl;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.pm.PmCollect;
import com.cisco.dcbu.sm.server.scheduler.SchedulerManagerImpl;
import com.cisco.dcbu.sm.server.scheduler.jobs.IndexJob;
import com.cisco.dcbu.sm.server.security.DCNMUserImpl;
import com.cisco.dcbu.sm.server.security.FMUser;
import com.cisco.dcbu.sm.server.security.FMUserFailedAttempts;
import com.cisco.dcbu.sm.server.security.RoleFabricImpl;
import com.cisco.dcbu.sm.server.security.SecurityManager;
import com.cisco.dcbu.sm.server.security.ServerPropertyUtil;
import com.cisco.dcbu.sm.server.security.UserManager;
import java.io.Serializable;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class IscImpl
implements IscRif,
Serializable {
    private static final long serialVersionUID = 1L;
    private static IscImpl _Instance = null;

    public static IscImpl getInstance() {
        if (_Instance == null) {
            try {
                _Instance = new IscImpl();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return _Instance;
    }

    protected IscImpl(boolean bean) {
    }

    public IscImpl() throws RemoteException {
    }

    @Override
    public FabricPK[] getFabrics() throws RemoteException {
        try {
            List<FabricPK> pkList = GlobalFabricManager.getInstance().getAllFabricPKs();
            FabricPK[] pkArray = pkList.toArray(new FabricPK[0]);
            return pkArray;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public FabricPK openFabric(String seedAddr, String userName, String authPassword, int authProtocol, int privProtocol, String privPassword, String fmUsername, String fmSessionID, String inVsans, String exVsans) throws RemoteException {
        try {
            InetAddress ipAddr = InetAddress.getByName(seedAddr);
            if (SanManager.getInstance().findFabricPK(ipAddr) != null) {
                throw new RemoteException("The fabric has been discovered or is currently in discovery!");
            }
            UsmUser snmpUser = null;
            authPassword = StringEncrypter.decryptString("DESede", authPassword);
            if (privPassword != null && privPassword.length() != 0) {
                privPassword = StringEncrypter.decryptString("DESede", privPassword);
            }
            try {
                snmpUser = UsmUserEntry.authenticate(userName, authProtocol, authPassword, privProtocol, privPassword, ipAddr);
            }
            catch (Exception se) {
                throw new RemoteException(se.getMessage());
            }
            SanManager.getInstance().validateSeedSwitch(ipAddr, snmpUser);
            String ssoToken = SecurityManager.getSSOToken(userName);
            FabricPK fabricPK = FMServerImpl.getInstance().discoverFabric(snmpUser, seedAddr, ssoToken, inVsans, exVsans);
            FabricImpl fabric = SanManager.getInstance().findFabric(fabricPK);
            for (int i = 0; i < 50; ++i) {
                if (!fabric.isDiscovering()) {
                    return fabric.getPK();
                }
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException ie) {
                    break;
                }
            }
            return null;
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public String getAlias(Wwn pwwn) throws RemoteException {
        try {
            return SanManager.getInstance().findEndPort(pwwn).getAlias();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getWsToken(String username, String password, long expiration) throws RemoteException {
        try {
            if (username == null || password == null) {
                throw new InvalidCredentialException("Username and/or password cannot be null.");
            }
            username = username.trim();
            password = password.trim();
            try {
                password = StringEncrypter.DESedeEncrypt(password);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            FMUser fmuser = SecurityManager.getInstance().authenticateUser(username, password);
            if (fmuser == null) {
                throw new InvalidCredentialException("Invalid username:" + fmuser);
            }
            String token = IdentityManager.getInstance().createToken(username, password, expiration);
            return token;
        }
        catch (InvalidCredentialException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public FabricPK openFabric(String seedAddr, String rCommunity, String wCommunity, String fmUserName, String fmSessionID, String inVsans, String exVsans) throws RemoteException {
        try {
            CommunityUser user;
            InetAddress ipAddr;
            block16: {
                ipAddr = InetAddress.getByName(seedAddr);
                user = null;
                if (wCommunity != null && wCommunity.length() != 0) {
                    wCommunity = StringEncrypter.decryptString("DESede", wCommunity);
                    try {
                        if (wCommunity != null) {
                            user = CommunityUserEntry.authenticate(wCommunity, ipAddr);
                        }
                    }
                    catch (Exception ex) {
                        if (rCommunity != null) break block16;
                        throw ex;
                    }
                }
            }
            if (user == null) {
                try {
                    if (rCommunity != null) {
                        rCommunity = StringEncrypter.decryptString("DESede", rCommunity);
                        user = CommunityUserEntry.authenticate(rCommunity, ipAddr);
                    }
                }
                catch (Exception ex) {
                    throw new RemoteException("invalid community");
                }
            }
            SanManager.getInstance().validateSeedSwitch(ipAddr, user);
            String ssoToken = SecurityManager.getSSOToken(fmUserName);
            FabricPK fabricPK = FMServerImpl.getInstance().discoverFabric(user, seedAddr, ssoToken, inVsans, exVsans);
            FabricImpl fabric = SanManager.getInstance().findFabric(fabricPK);
            if (fabric != null) {
                FMUser fmuser = UserManager.getInstance().findUser(fmUserName);
                fmuser.addSnmpUser(fabric.getPK(), user);
            }
            for (int i = 0; i < 10; ++i) {
                if (!fabric.isDiscovering()) {
                    return fabric.getPK();
                }
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException ie) {
                    break;
                }
            }
            return null;
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void closeFabric(FabricPK pkey) throws RemoteException {
        try {
            SanManager sm = SanManager.getInstance();
            FabricImpl fabric = sm.findFabric(pkey);
            if (fabric == null) {
                throw new RemoteException(pkey + " not found");
            }
            ClusterImpl[] clusters = sm.findClusters(pkey);
            if (clusters != null && clusters.length > 0) {
                throw new RemoteException("Can't remove " + pkey.getName() + " it is associated with cluster(s).");
            }
            sm.closeFabric(fabric);
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void setFabricName(FabricPK pkey, String newName) throws RemoteException {
        try {
            SanManager sm = SanManager.getInstance();
            FabricImpl fabric = sm.findFabric(pkey);
            if (fabric == null) {
                throw new RemoteException(pkey + " not found");
            }
            fabric.setFabricName(newName);
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public boolean isFabricOpened(FabricPK pk) throws RemoteException {
        if (pk == null) {
            return false;
        }
        FabricImpl fabric = SanManager.getInstance().findFabric(pk);
        if (fabric == null) {
            return GlobalFabricManager.getInstance().isFabricManageable(pk);
        }
        return fabric != null && (fabric.getFarbicStatus() == 2 || fabric.getFarbicStatus() == 4);
    }

    @Override
    public void setPersistent(FabricPK pkey, boolean isPersistent) throws RemoteException {
        try {
            SanManager sm = SanManager.getInstance();
            FabricImpl fabric = sm.findFabric(pkey);
            if (fabric == null) {
                throw new RemoteException(pkey + " not found");
            }
            sm.persistFabric(fabric, isPersistent);
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public boolean isLicensed(FabricPK fpk) throws RemoteException {
        try {
            return LicenseManager.getInstance().isFmLicensed(fpk);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    @Override
    public int getLicensedState(FabricPK pkey) throws RemoteException {
        try {
            return LicenseManager.getInstance().getFmLicensedState(pkey);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    @Override
    public SnmpCommunityBase createSnmpCommunity(SnmpCommunityBase base) throws RemoteException {
        if (base == null) {
            return null;
        }
        if (base.getDBID() != 0L) {
            throw new RemoteException("Invalid id " + base.getDBID());
        }
        if (base.getIpAddress() == null) {
            throw new RemoteException("Invalid ip " + base.getIpAddress());
        }
        try {
            InventoryPersistentManager.getInstance().persistDBObject(new SnmpCommunityImpl(base));
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
        return base;
    }

    @Override
    public SnmpCommunityBase updateSnmpCommunity(SnmpCommunityBase base) throws RemoteException {
        if (base == null) {
            return null;
        }
        if (base.getIpAddress() == null) {
            throw new RemoteException("Invalid ip " + base.getIpAddress());
        }
        try {
            InventoryPersistentManager.getInstance().persistDBObject(new SnmpCommunityImpl(base));
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
        return base;
    }

    @Override
    public void propertyChanged(FabricPK fabricPK, ChangedModelObject chgObj) throws RemoteException {
        block7: {
            try {
                if (chgObj._propId == 522) {
                    FabricImpl fabric = SanManager.getInstance().findFabric(fabricPK);
                    if (fabric != null) {
                        fabric.useFcAlias((Boolean)chgObj.getNewValue());
                    }
                    break block7;
                }
                if (chgObj._propId == 1546) {
                    EndPortImpl ep = SanManager.getInstance().findEndPort((WwnKey)chgObj._objKey, fabricPK);
                    if (ep != null) {
                        ep.setAutoAlias((String)((Object)chgObj.getNewValue()));
                    }
                    break block7;
                }
                if (chgObj._propId != 1046) break block7;
                SwitchImpl sw = SanManager.getInstance().findSwitch((WwnKey)chgObj.getPK(), fabricPK);
                if (sw != null) {
                    sw.setFeatureFlags((boolean[])chgObj.getNewValue());
                    break block7;
                }
                throw new RemoteException("switch not found");
            }
            catch (Exception ex) {
                throw new RemoteException(ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void deleteSnmpCommunity(SnmpCommunityBase base) throws RemoteException {
        if (base == null) {
            return;
        }
        try {
            InventoryPersistentManager.getInstance().deleteDBObject(new SnmpCommunityImpl(base));
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void purgeFabric(FabricPK pkey, long fabricId) throws RemoteException {
        if (this.isFabricInPmCollection(pkey)) {
            throw new RemoteException("Can not remove Fabric: " + pkey + ", it is in PM collection, please remove the fabric from PM Collection first.");
        }
        if ("Starting".equals(PMImpl.getInstance().getStatus())) {
            throw new RemoteException("Performance Manager is starting, cannot purge fabrics at this stage. Please try again later");
        }
        try {
            SanManager.getInstance().purgeFabric(pkey, fabricId);
            ((EventLoggerService)ServiceConfig.findService("Event Logger Service")).logEvent(new LogEvent(pkey, LogEventType.FABRIC, Severity.WARNING, pkey.toString(), "fabric " + pkey.toString() + " are purged by web client"));
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public String getServerStartTime() throws RemoteException {
        long startTime = ComponentManager.getStartTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss z");
        return dateFormat.format(new Date(startTime));
    }

    private boolean isFabricInPmCollection(FabricPK pkey) throws RemoteException {
        if (PmCollect.getMetaData() == null) {
            return false;
        }
        List<PmPolicyImpl> implList = PmCollect.getMetaData().getFabricPolicyList();
        for (PmPolicyImpl impl : implList) {
            try {
                FabricPK pPk = FabricImpl.findFPKByDbId(impl.getBase().getFabricId());
                if (pkey == null || !pkey.equals(pPk)) continue;
                return true;
            }
            catch (SQLException ex) {
                throw new RemoteException(ex.getMessage());
            }
        }
        return false;
    }

    @Override
    public void purgeDownElements(FabricPK pkey) throws RemoteException {
        try {
            FabricImpl fabric = SanManager.getInstance().findFabric(pkey);
            if (fabric != null) {
                fabric.purgeAll();
                ((EventLoggerService)ServiceConfig.findService("Event Logger Service")).logEvent(new LogEvent((Object)pkey, LogEventType.FABRIC, Severity.WARNING, pkey.toString(), "Down elements in fabric " + pkey.toString() + " are purged by web client", pkey.get_fid()));
            }
        }
        catch (Exception ex) {
            throw new RemoteException("purging " + pkey + " error: " + ex.getMessage());
        }
    }

    @Override
    public void createUser(String userName, String authPassword, String roleName) throws RemoteException {
        String mode = SecurityManager.getInstance().getAuthMode();
        if (mode != null && !mode.equalsIgnoreCase("local")) {
            throw new RemoteException("The security mode is not local");
        }
        int status = UserManager.createUserInDB(userName, authPassword, roleName);
        if (status == 0) {
            throw new RemoteException("User Already Exist");
        }
        if (status == -1) {
            throw new RemoteException("Error in creating process");
        }
    }

    @Override
    public void createUser(String userName, String authPassword, String roleName, String userInCharge) throws RemoteException {
        String mode = SecurityManager.getInstance().getAuthMode();
        if (mode != null && !mode.equalsIgnoreCase("local")) {
            throw new RemoteException("The security mode is not local");
        }
        int status = UserManager.createUserInDB(userName, authPassword, roleName, userInCharge);
        if (status == 0) {
            throw new RemoteException("User Already Exist");
        }
        if (status == -1) {
            throw new RemoteException("Error in creating process");
        }
    }

    @Override
    public boolean deleteUser(String userName, String userInCharge) {
        return UserManager.getInstance().deleteUser(userName, userInCharge);
    }

    @Override
    public boolean deleteRemoteUser(String userName, String userInCharge) {
        return DCNMUserImpl.deleteUser(userName, userInCharge);
    }

    @Override
    public boolean updateUser(String userName, String authPassword) {
        return UserManager.getInstance().updateUser(userName, authPassword);
    }

    @Override
    public ArrayList getAllUsers() {
        return UserManager.getAllDBUsers();
    }

    @Override
    public void resetFailedAttempts(String username) throws RemoteException {
        try {
            FMUserFailedAttempts.getInstance().purgeFailedAttempt(username);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    @Override
    public boolean isUserLockoutEnabled() {
        return FMUserFailedAttempts.getInstance().isUserLockoutEnabled();
    }

    @Override
    public boolean isUserLockedOut(String username) {
        boolean isLocketOut = false;
        try {
            isLocketOut = FMUserFailedAttempts.getInstance().isUserLockout(username);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isLocketOut;
    }

    @Override
    public FMUserBase verifySSoToken(String ssoToken) {
        return SecurityManager.verifySSoToken(ssoToken);
    }

    @Override
    public String getSSoToken(String userName) throws RemoteException {
        try {
            return SecurityManager.getSSOToken(userName);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    @Override
    public String getSSoToken(String userName, int sessionId) throws RemoteException {
        try {
            return SecurityManager.getSSOToken(userName, sessionId);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    @Override
    public FMUserBase authenticate(String userName, String authPassword) throws RemoteException {
        FMUser fmUser = null;
        try {
            fmUser = SecurityManager.getInstance().authenticate(userName, authPassword);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
        if (fmUser == null) {
            return null;
        }
        UserManager.getInstance().addUser(fmUser);
        return new FMUserBase(fmUser.getUserName(), fmUser.getHashedPwd(), fmUser.getRoleName());
    }

    @Override
    public String getWsAddress() {
        String isolateWebClient = System.getProperty("isolateWebClient", "false");
        if (Boolean.parseBoolean(isolateWebClient)) {
            return System.getProperty("wsHostScheme", "http") + "://" + System.getProperty("wsHostAddress", "localhost") + ":" + System.getProperty("wsHostPort", "80");
        }
        return null;
    }

    @Override
    public boolean checkDB() throws RemoteException {
        try {
            int rst = ConnectionManager.checkDB();
            if (rst != 0) {
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    @Override
    public void logoff(String userName) throws RemoteException {
        UserManager.getInstance().removeUser(userName);
    }

    @Override
    public void buildIndex() {
        new IndexJob().buildIndex();
    }

    @Override
    public FMUserBase findUserFromDB(String userName) throws RemoteException {
        try {
            return UserManager.findUserFromDB(userName);
        }
        catch (SQLException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    @Override
    public FMUserBase findUserFromDB(String userName, String auth_password) throws RemoteException {
        try {
            return UserManager.findUserFromDB(userName, auth_password);
        }
        catch (SQLException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    @Override
    public ArrayList<FabricPK> getFabricsFromRole(String roleName) throws RemoteException {
        return UserManager.getFabricsFromRole(roleName);
    }

    @Override
    public boolean deleteRole(String roleName) throws RemoteException {
        return UserManager.deleteRole(roleName);
    }

    @Override
    public boolean addFabricToRole(String roleName, long fid) throws RemoteException {
        return UserManager.addFabricToRole(roleName, fid);
    }

    @Override
    public boolean addFabricsToRole(String roleName, ArrayList<Long> fids) throws RemoteException {
        return RoleFabricImpl.addMultiFabricsToRole(roleName, fids);
    }

    @Override
    public boolean addRole(String roleName) throws RemoteException {
        try {
            return UserManager.addRole(roleName);
        }
        catch (SQLException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    @Override
    public boolean updateRoleForUser(String role, String name) throws RemoteException {
        return UserManager.updateRoleForUser(role, name);
    }

    @Override
    public ArrayList<String> getAllRoles() throws RemoteException {
        try {
            return UserManager.getAllRoles();
        }
        catch (SQLException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    @Override
    public ArrayList<PropertyWrapper> readServerProperties() throws RemoteException {
        return ServerPropertyUtil.readServerProperties();
    }

    @Override
    public void storeServerProperties(ArrayList props) throws RemoteException {
        ServerPropertyUtil.storeServerProperties(props);
    }

    @Override
    public void validateEmailSettings() throws Exception {
        SchedulerManagerImpl.validateEmailSettings();
    }

    @Override
    public String getAuthMode() throws Exception {
        return SecurityManager.getInstance().getAuthMode();
    }

    @Override
    public void manageFabric(FabricPK fPK) throws RemoteException {
        try {
            SanManager.getInstance().manageFabric(fPK);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    @Override
    public void unmanageFabric(FabricPK fabricPK) throws RemoteException {
        SanManager sm = SanManager.getInstance();
        FabricImpl fabric = sm.findFabric(fabricPK);
        if (fabric == null) {
            throw new RemoteException(fabricPK + " not found");
        }
        sm.closeFabric(fabric);
    }

    @Override
    public boolean isManaged(FabricPK fabricPK) throws RemoteException {
        if (fabricPK == null) {
            return false;
        }
        SanManager sm = SanManager.getInstance();
        FabricImpl fabric = sm.findFabric(fabricPK);
        if (fabric == null) {
            throw new RemoteException(fabricPK + " not found");
        }
        int status = fabric.getFarbicStatus();
        return status == 2 || status == 4;
    }

    @Override
    public boolean isPersistent(FabricPK fabricPK) throws RemoteException {
        if (fabricPK == null) {
            return false;
        }
        SanManager sm = SanManager.getInstance();
        FabricImpl fabric = sm.findFabric(fabricPK);
        if (fabric == null) {
            throw new RemoteException(fabricPK + " not found");
        }
        return fabric.isPersistent();
    }

    @Override
    public void setFabricCredentials(String seedAddr, String userName, String authPassword, int authProtocol, int privProtocol, String privPassword, FabricPK fpk) throws RemoteException {
        try {
            UsmUser snmpUser = null;
            InetAddress ipAddr = InetAddress.getByName(seedAddr);
            authPassword = StringEncrypter.decryptString("DESede", authPassword);
            if (privPassword != null && privPassword.length() != 0) {
                privPassword = StringEncrypter.decryptString("DESede", privPassword);
            }
            try {
                snmpUser = UsmUserEntry.authenticate(userName, authProtocol, authPassword, privProtocol, privPassword, ipAddr);
            }
            catch (Exception se) {
                throw new RemoteException(se.getMessage());
            }
            FabricImpl fabric = SanManager.getInstance().findFabric(fpk);
            if (fabric == null) {
                throw new RemoteException("Can not find fabric:" + fpk);
            }
            fabric.setDBCredentials(snmpUser);
            fabric.setCredentials(snmpUser, true);
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void updateFabricCredetials(FabricPK pkey, SnmpUserOpt snmpUserOpt) throws RemoteException {
        if (pkey == null) {
            throw new RemoteException("findFabric: pkey is null");
        }
        if (snmpUserOpt == null) {
            throw new RemoteException("snmpUserOpt is null");
        }
        FabricImpl fabric = SanManager.getInstance().findFabric(pkey);
        if (fabric == null) {
            throw new RemoteException("Can not find fabric:" + pkey);
        }
        SnmpUser user = SessionImpl.convertSnmpUser(snmpUserOpt);
        try {
            if (fabric.getSwitches().length == 0) {
                fabric.setDBCredentials(user);
            } else {
                SecurityManager.authenticate(user, fabric);
            }
            fabric.setCredentials(user, true);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public void setFabricCredentials(String seedAddr, String rCommunity, String wCommunity, FabricPK fpk) throws RemoteException {
        try {
            FabricImpl fabric;
            CommunityUser user;
            InetAddress ipAddr;
            block12: {
                ipAddr = InetAddress.getByName(seedAddr);
                user = null;
                if (wCommunity != null && wCommunity.length() != 0) {
                    wCommunity = StringEncrypter.decryptString("DESede", wCommunity);
                    try {
                        if (wCommunity != null) {
                            user = CommunityUserEntry.authenticate(wCommunity, ipAddr);
                        }
                    }
                    catch (Exception ex) {
                        if (rCommunity != null) break block12;
                        throw ex;
                    }
                }
            }
            if (user == null) {
                try {
                    if (rCommunity != null) {
                        rCommunity = StringEncrypter.decryptString("DESede", rCommunity);
                        user = CommunityUserEntry.authenticate(rCommunity, ipAddr);
                    }
                }
                catch (Exception ex) {
                    throw new RemoteException("invalid community");
                }
            }
            if ((fabric = SanManager.getInstance().findFabric(fpk)) == null) {
                throw new RemoteException("Can not find fabric:" + fpk);
            }
            fabric.setDBCredentials(user);
            fabric.setCredentials(user, true);
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public String getSeedIpFromPK(FabricPK fabricPK) throws RemoteException {
        FabricImpl fs = SanManager.getInstance().findFabric(fabricPK);
        long seedid = fs.getSeedDBID();
        if (seedid == 0L) {
            try {
                seedid = FabricImpl.findSeedSwitchIdByPk(fabricPK);
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new RemoteException("Error locating seed id by fabric pk.");
            }
        }
        InetAddress ipAddr = SwitchImpl.findSwitchMgmtAddrByPK(seedid);
        return ipAddr.getHostAddress();
    }
}

