/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.facade;

import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.facade.DDMServerImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;

class RunPDUSetThread
extends Thread {
    private SwitchBase _switch;
    private DDMServerImpl _parent;
    private Exception _exception = null;
    private SnmpPDU _pdu;

    public RunPDUSetThread(SwitchBase switch1, SnmpPDU pdu, DDMServerImpl parent) {
        this._switch = switch1;
        this._parent = parent;
        this._pdu = pdu;
    }

    @Override
    public void run() {
        try {
            SanManager sanMan = SanManager.getInstance();
            SwitchImpl swImpl = sanMan.findSwitch((WwnKey)this._switch.getSwitchPK(), this._switch.getFabricPK());
            SnmpPeer peer = this._parent.getPeer(swImpl);
            peer.set(this._pdu);
        }
        catch (Exception ex) {
            this._exception = ex;
        }
    }

    public Exception getException() {
        return this._exception;
    }

    public SwitchBase getSwitch() {
        return this._switch;
    }
}

