/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.facade;

import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.sm.common.rif.EjbRegistryIf;
import com.cisco.dcbu.sm.common.rif.WebAnalysisRif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.server.analysis.ReportAnalysis;
import com.cisco.dcbu.sm.server.analysis.ServerObjectCache;
import com.cisco.dcbu.sm.server.config.BackUpConfiguration;
import com.cisco.dcbu.sm.server.fc.FabricCheckAnalysis;
import com.cisco.dcbu.sm.server.web.ClusterProcessor;
import com.cisco.dcbu.sm.server.web.WebReferenceManager;
import com.cisco.dcbu.sm.server.web.inventory.SwitchHandler;
import com.cisco.dcbu.sm.server.zone.ZoneService;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class WebAnalysisImpl
extends ServerObjectCache
implements WebAnalysisRif {
    public static Logger _Logger = LogManager.getLogger((String)"FM.WebReport");

    @Override
    public ArrayList getReportsynchronously(int fId, String vsanPKString, Object[] params, int reportType, long fabricDbID, long vsanDbID) throws RemoteException {
        try {
            return this.getReportObject(reportType, false).generateReportSynchronously(fId, vsanPKString, params, reportType, fabricDbID, vsanDbID);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage() != null ? ex.getMessage() : "Error processing request");
        }
    }

    @Override
    public int startASyncReportWithNewInstance(int fId, String vsanPKString, Object[] params, int reportType, String jobName, long fabricDbID, long vsanDbID) throws RemoteException {
        int reptId = -1;
        try {
            ReportAnalysis rep = this.getReportObject(reportType, true);
            reptId = WebAnalysisImpl.modifyCachedObjectMap(true, reportType, -1, new Object[]{rep, new Long(System.currentTimeMillis()), jobName});
            rep.generateReportAsynchronously(fId, vsanPKString, params, reportType, reptId, fabricDbID, vsanDbID);
            _Logger.info((Object)("Starting report " + (reportType - 1 < OBJECT_ID_2_NAME.length ? OBJECT_ID_2_NAME[reportType - 1] : Integer.valueOf(reportType)) + " ,report ID:" + reptId));
            return reptId;
        }
        catch (Exception ex) {
            if (reptId != -1) {
                WebAnalysisImpl.modifyCachedObjectMap(false, -1, reptId, null);
            }
            throw new RemoteException(ex.getMessage() != null ? ex.getMessage() : "Error processing request");
        }
    }

    @Override
    public ArrayList getReport(int reportType, int reptId) throws RemoteException {
        try {
            Object[] repInfo = WebAnalysisImpl.getNewInstanceCachedObject(reptId);
            if (repInfo != null) {
                return ((ReportAnalysis)repInfo[0]).getReportData(reportType);
            }
            return new ArrayList();
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage() != null ? ex.getMessage() : "Error processing request");
        }
    }

    @Override
    public void cleanUpExistingReport(int reportType, int reptId) throws RemoteException {
        try {
            Object[] repInfo = WebAnalysisImpl.getNewInstanceCachedObject(reptId);
            if (repInfo != null) {
                ((ReportAnalysis)repInfo[0]).cleanUpExistingReport();
            }
            WebAnalysisImpl.modifyCachedObjectMap(false, -1, reptId, null);
            _Logger.info((Object)("Removing report cache " + OBJECT_ID_2_NAME[reportType - 1] + " ,report ID:" + reptId));
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage() != null ? ex.getMessage() : "Error processing request");
        }
    }

    @Override
    public String getReportStatus(int reportType, int reptId) throws RemoteException {
        try {
            Object[] repInfo = WebAnalysisImpl.getNewInstanceCachedObject(reptId);
            if (repInfo != null) {
                return ((ReportAnalysis)repInfo[0]).getStatus();
            }
            return "";
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage() != null ? ex.getMessage() : "Error processing request");
        }
    }

    @Override
    public int getPercentCompleted(int reportType, int reptId) throws RemoteException {
        try {
            Object[] repInfo = WebAnalysisImpl.getNewInstanceCachedObject(reptId);
            if (repInfo != null) {
                return ((ReportAnalysis)repInfo[0]).getPercentCompleted();
            }
            return 100;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage() != null ? ex.getMessage() : "Error processing request");
        }
    }

    @Override
    public boolean isReportRunning(int reportType, int reptId) throws RemoteException {
        try {
            Object[] repInfo = WebAnalysisImpl.getNewInstanceCachedObject(reptId);
            if (repInfo != null) {
                return ((ReportAnalysis)repInfo[0]).isReportRunning();
            }
            return false;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage() != null ? ex.getMessage() : "Error processing request");
        }
    }

    @Override
    public boolean isErrorInProcessing(int reportType, int reptId) throws RemoteException {
        try {
            Object[] repInfo = WebAnalysisImpl.getNewInstanceCachedObject(reptId);
            if (repInfo != null) {
                return ((ReportAnalysis)repInfo[0]).isErrorInProcessing();
            }
            return false;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage() != null ? ex.getMessage() : "Error processing request");
        }
    }

    @Override
    public Exception getErrorException(int reportType, int reptId) throws RemoteException {
        try {
            Object[] repInfo = WebAnalysisImpl.getNewInstanceCachedObject(reptId);
            if (repInfo != null) {
                return ((ReportAnalysis)repInfo[0]).getErrorException();
            }
            return null;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage() != null ? ex.getMessage() : "Error processing request");
        }
    }

    @Override
    public ArrayList getAnalysisWarnings(int reportType, int reptId) throws RemoteException {
        try {
            Object[] repInfo = WebAnalysisImpl.getNewInstanceCachedObject(reptId);
            if (repInfo != null) {
                return ((ReportAnalysis)repInfo[0]).getWarnings();
            }
            return new ArrayList();
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage() != null ? ex.getMessage() : "Error processing request");
        }
    }

    @Override
    public void stopAsyncReport(int reptId, boolean cleanupReport) throws RemoteException {
        try {
            Object[] repInfo = WebAnalysisImpl.getNewInstanceCachedObject(reptId);
            if (repInfo != null) {
                if (cleanupReport) {
                    ((ReportAnalysis)repInfo[0]).setCleanUpOnFinish(cleanupReport);
                    if (!((ReportAnalysis)repInfo[0]).isReportRunning()) {
                        ServerObjectCache.modifyCachedObjectMap(false, -1, reptId, null);
                    }
                }
                ((ReportAnalysis)repInfo[0]).stopReport();
            }
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage() != null ? ex.getMessage() : "Error processing request");
        }
    }

    @Override
    public String[] getConfigFiles(int reptId) throws RemoteException {
        return FabricCheckAnalysis.getConfigFiles();
    }

    @Override
    public String getConfigFilesLocation(int reptId) throws RemoteException {
        return FabricCheckAnalysis.getConfigFilesLocation();
    }

    private ReportAnalysis getReportObject(int reportType, boolean newInstance) throws Exception {
        String reportClass = "";
        switch (reportType) {
            case 1: {
                reportClass = "com.cisco.dcbu.sm.server.zone.EnclosureAnalysis";
                break;
            }
            case 2: 
            case 3: {
                reportClass = "com.cisco.dcbu.sm.server.zone.ZoneAnalysis";
                break;
            }
            case 4: {
                reportClass = "com.cisco.dcbu.sm.server.zone.ZoneDiscrepancyAnalysis";
                break;
            }
            case 5: {
                reportClass = "com.cisco.dcbu.sm.server.fc.FabricCheckAnalysis";
                break;
            }
            case 6: {
                reportClass = "com.cisco.dcbu.sm.server.cat.HealthReportAnalysis";
                break;
            }
            case 7: {
                reportClass = "com.cisco.dcbu.sm.server.cat.FcPingAnalysis";
                break;
            }
            case 9: {
                reportClass = "com.cisco.dcbu.sm.server.zone.ZoneRoute";
                break;
            }
            case 8: {
                reportClass = "com.cisco.dcbu.sm.server.analysis.WebAnalysisReportStats";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                reportClass = "com.cisco.dcbu.sm.server.config.BackUpConfiguration";
            }
        }
        Class<?> cc = Class.forName(reportClass);
        Method m = cc.getMethod(newInstance ? "newInstance" : "getInstance", null);
        return (ReportAnalysis)m.invoke(null, null);
    }

    @Override
    public ArrayList getZoneInformation(int fId, String vsanPKString, Boolean[] unmoitoredFabric) throws RemoteException {
        try {
            StringBuffer unmonitored = new StringBuffer();
            ArrayList data = ZoneService.getZonesFromServer(fId, vsanPKString, unmonitored);
            if (unmoitoredFabric != null && unmoitoredFabric.length > 0) {
                unmoitoredFabric[0] = unmonitored.toString().trim().length() > 0;
            }
            return data;
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage() != null ? ex.getMessage() : "Error processing request");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            WebAnalysisImpl.clearExpiredObjects();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public ArrayList restoreConfigToSwitch(int fId, String swI, int protocol, String usrName, String passWord, String fileName, String rootDir, String configType, boolean isLan) throws RemoteException {
        try {
            return BackUpConfiguration.newInstance().restoreConfigToSwitch(swI, protocol, usrName, passWord, fileName, rootDir, configType, isLan);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public String[] backUpFabric(int fId, int configType, int protocol, String usrName, String pssWrd, String rootDir, boolean isLan) throws RemoteException {
        try {
            return BackUpConfiguration.newInstance().backUpFabric(fId, configType, protocol, usrName, pssWrd, rootDir, isLan);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public String backUpLanSwitch(String swIP, int configType, int protocol, String usrName, String passWord, String rootDir, boolean moveToDB) throws RemoteException {
        try {
            return BackUpConfiguration.newInstance().backUpLanSwitch(swIP, configType, protocol, usrName, passWord, rootDir, moveToDB);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public String backUpSanSwitch(String swIP, int configType, int protocol, String usrName, String passWord, String rootDir, boolean moveToDB) throws RemoteException {
        try {
            return BackUpConfiguration.newInstance().backUpSanSwitch(swIP, configType, protocol, usrName, passWord, rootDir, moveToDB);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public boolean clearSSHHosts(String swIp) throws RemoteException {
        try {
            return BackUpConfiguration.newInstance().clearSSHHosts(swIp);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public String[] backUpEtherSwitchGroup(long groupId, int configType, int protocol, String usrName, String pssWrd, String rootDir) throws Exception {
        try {
            return BackUpConfiguration.newInstance().backUpEtherSwitchGroup(groupId, configType, protocol, usrName, pssWrd, rootDir);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
    }

    public static WebAnalysisRif getRemoteWebAnalysisRif(long fIdOrSwitchDBID, boolean isLan) throws Exception {
        if (!isLan) {
            return WebAnalysisImpl.getRemoteWebAnalysisRif((int)fIdOrSwitchDBID);
        }
        return WebAnalysisImpl.getRemoteWebAnalysisRifForLanSwitch(fIdOrSwitchDBID);
    }

    public static WebAnalysisRif getRemoteWebAnalysisRif(int fId) throws Exception {
        WebAnalysisRif encRif = null;
        EjbRegistryIf rif = WebReferenceManager.getInstance().getLocalRef();
        String fedServer = ClusterProcessor.getInstance().getServerIpByPK(new FabricPK(fId));
        boolean isLocal = NetUtil.isLocalHost(fedServer);
        if (isLocal) {
            return rif.getWebAnalysis();
        }
        if (fedServer != null) {
            encRif = (WebAnalysisRif)rif.getRemoteService(fedServer, System.getProperty("server.port", "4447"), "WebAnalysisBean", WebAnalysisRif.class.getName());
        }
        if (encRif == null) {
            _Logger.error((Object)("Unable to find the server for selected Fabric:" + fId));
            throw new Exception("Unable to find the server for selected Fabric:" + fId);
        }
        return encRif;
    }

    public static WebAnalysisRif getRemoteWebAnalysisRifForLanSwitch(long swDbId) throws Exception {
        WebAnalysisRif encRif = null;
        EjbRegistryIf rif = WebReferenceManager.getInstance().getLocalRef();
        Object[] swData = SwitchHandler.getInstance().getFMSManagingLanSwitch(swDbId);
        if (swData == null || swData.length == 0) {
            _Logger.info((Object)("Skipping switch with DBID " + swDbId + " as the DCNM SAN managing the switch could not be found."));
            throw new Exception("Skipping switch with DBID " + swDbId + " as the FMS managing the switch could not be found.");
        }
        String fedServer = swData[0].toString();
        String swIpAddress = swData[2].toString();
        String swName = swData[1].toString();
        String localServer = rif.getFMServer().whereami();
        _Logger.info((Object)("Local Server " + localServer + ". Server for Switch ID:" + swDbId + " IPAddress:" + swIpAddress + " is" + (fedServer != null ? fedServer : "Unknown")));
        if (fedServer == null || localServer.equals(fedServer)) {
            return rif.getWebAnalysis();
        }
        if (fedServer != null) {
            encRif = (WebAnalysisRif)rif.getRemoteService(fedServer, "WebAnalysisBean");
        }
        if (encRif == null) {
            _Logger.error((Object)("Unable to find the server for selected Switch:" + swDbId + " IPAddress:" + swIpAddress));
            throw new Exception("Unable to find the server for selected Switch:" + swDbId + " IPAddress:" + swIpAddress);
        }
        return encRif;
    }
}

