/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.flexattach;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.common.dto.FlexAtahCfg;
import com.cisco.dcbu.sm.common.dto.QueueResponseObject;
import com.cisco.dcbu.sm.common.event.CommunicationObjectSender;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.server.flexattach.BasicRunnable;
import java.util.ArrayList;
import java.util.List;

public class FlexAtahPortCfgRunnable
extends BasicRunnable {
    static final int[] _fcIfAdminModeOid = MibNode.get("fcIfAdminMode").getOid();
    static final int[] _ifAliasOid = MibNode.get("ifAlias").getOid();
    static final int[] _ifAdminStatusOid = MibNode.get("ifAdminStatus").getOid();
    static final int[] _vsanIfVsanOid = MibNode.get("vsanIfVsan").getOid();
    static final int[] _cfaIfVirtualWwnAutoOid = MibNode.get("cfaIfVirtualWwnAuto").getOid();
    static final int[] _cfaIfVirtualWwnPwwnOid = MibNode.get("cfaIfVirtualWwnPwwn").getOid();
    static final int[] _cfaGlobalVirtualWwnAutoOid = MibNode.get("cfaGlobalVirtualWwnAuto").getOid();
    static final int[] _vsanMtuOid = MibNode.get("vsanMtu").getOid();
    private int _jobType;
    private long _requestId;
    private SwitchBase _sw;
    private List<FlexAtahCfg> _ports;
    private SnmpUserOpt _snmpUserOpt;
    private CommunicationObjectSender _sender;

    public FlexAtahPortCfgRunnable(int jobType, long requestId, SwitchBase sw, SnmpUserOpt snmpUserOpt, CommunicationObjectSender sender, List<FlexAtahCfg> ports) {
        this._jobType = jobType;
        this._requestId = requestId;
        this._sw = sw;
        this._ports = ports;
        this._snmpUserOpt = snmpUserOpt;
        this._sender = sender;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("FlexAtahPortCfgRunnable called for sw -" + sw + " for ports - " + ports + " for jobType - " + jobType));
        }
    }

    @Override
    public void run() {
        try {
            switch (this._jobType) {
                case 1: {
                    try {
                        QueueResponseObject portResults = this.setFlexAtahCfg();
                        this._sender.send(portResults);
                        break;
                    }
                    catch (SnmpException se) {
                        if (se.getMessage().indexOf("requested config change not allowed") != -1) {
                            throw new Exception(se.getMessage().trim() + ", please check that your switch rebooted after last NPV mode change.");
                        }
                        throw se;
                    }
                }
            }
        }
        catch (Exception se) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Unable to set FlexAttach port Config for switch/RequestId/_isExceptionClear/_isOk:" + this._sw.toString() + "/" + this._requestId + "/" + this._isExceptionClear + "/" + this._isOK + ";  received error: " + se.getMessage()));
            }
            if (!this._isExceptionClear) {
                this._isOK = false;
            }
            QueueResponseObject result = new QueueResponseObject(this._requestId, this._sw, 4, null, se);
            this._sender.send(result);
        }
    }

    private QueueResponseObject setFlexAtahCfg() throws Exception {
        SnmpPeer peer = this.generatePeer(this._sw, this._snmpUserOpt);
        if (FlexAtahPortCfgRunnable.isCFSPending(peer, null)) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)"FlexAtahPortCfgRunnabled::setFlexAtathCfg cfs lock");
            }
            throw new Exception("cfs locked,  please clear lock first.");
        }
        String errMsg = this.checkVSANs(peer);
        if (errMsg.length() > 5) {
            throw new Exception(errMsg.toString());
        }
        boolean isFlexAtahApplied = false;
        VarBindList varList = new VarBindList();
        VarBindList adminDownList = new VarBindList();
        VarBindList adminUpList = new VarBindList();
        for (int i = 0; i < this._ports.size(); ++i) {
            boolean isThisPortFAApplied = false;
            FlexAtahCfg nextPort = this._ports.get(i);
            int fcIndex = nextPort.getIfIndex();
            if (nextPort.getPortVsan() != -1) {
                varList.add(_vsanIfVsanOid, fcIndex, (SnmpVar)new SnmpInt(nextPort.getPortVsan()));
            }
            if (nextPort.getOrignalIsAuto() != nextPort.getIsAuto()) {
                varList.add(_cfaIfVirtualWwnAutoOid, new int[]{0, fcIndex}, (SnmpVar)new SnmpInt(nextPort.getIsAuto() ? 1 : 2));
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("FlexAtahPortCfgRunnabled::setFlexAtathCfg for sw/port isAuto changed  old/new -" + this._sw + "/" + this._sw.ifIndexToName(fcIndex) + "     " + nextPort.getOrignalIsAuto() + " / " + nextPort.getIsAuto()));
                }
                isFlexAtahApplied = true;
                isThisPortFAApplied = true;
            }
            if (nextPort.getIfVPWWN() == null && nextPort.getOriginalIfVPWWN() != null || nextPort.getIfVPWWN() != null && nextPort.getOriginalIfVPWWN() == null || nextPort.getIfVPWWN() != null && nextPort.getOriginalIfVPWWN() != null && !nextPort.getIfVPWWN().equals(nextPort.getOriginalIfVPWWN())) {
                SnmpString newValue = nextPort.getIfVPWWN() == null ? new SnmpString(new byte[0]) : new SnmpString(nextPort.getIfVPWWN().getValue());
                varList.add(_cfaIfVirtualWwnPwwnOid, new int[]{0, fcIndex}, (SnmpVar)newValue);
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("FlexAtahPortCfgRunnabled::setFlexAtathCfg for sw/port ifVPWWN changed  old/new -" + this._sw + "/" + this._sw.ifIndexToName(fcIndex) + "     " + nextPort.getOriginalIfVPWWN() + " / " + nextPort.getIfVPWWN()));
                }
                isFlexAtahApplied = true;
                isThisPortFAApplied = true;
            }
            if (nextPort.getAdminStatus() == -1) continue;
            if (isThisPortFAApplied) {
                adminDownList.add(_ifAdminStatusOid, fcIndex, (SnmpVar)new SnmpInt(2));
                if (nextPort.getAdminStatus() != 1) continue;
                varList.add(_ifAdminStatusOid, fcIndex, (SnmpVar)new SnmpInt(nextPort.getAdminStatus()));
                continue;
            }
            varList.add(_ifAdminStatusOid, fcIndex, (SnmpVar)new SnmpInt(nextPort.getAdminStatus()));
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("FlexAtahPortCfgRunnabled::setFlexAtathCfg for sw -" + this._sw + " for ports - " + this._ports + " for jobType - " + this._jobType + " varList - " + varList.toString()));
        }
        try {
            if (adminDownList.size() > 0) {
                SnmpFetch.set(peer, adminDownList);
            }
            if (varList.size() > 0) {
                SnmpFetch.set(peer, varList);
            }
        }
        catch (SnmpException ex) {
            StringBuffer errString = this.handleSetConfigException(this._sw, peer, varList, ex);
            this._isExceptionClear = true;
            throw new Exception(errString.toString());
        }
        if (isFlexAtahApplied) {
            try {
                VarBindList varList1 = new VarBindList();
                varList1.add(_cfsFeatureOpActionOid, _FlexAttachCFSIndex, (SnmpVar)new SnmpInt(4));
                varList1.add(_cfsFeatureOpScopeTypeOid, _FlexAttachCFSIndex, (SnmpVar)new SnmpInt(1));
                varList1.add(_cfsFeatureOpScopeValOid, _FlexAttachCFSIndex, (SnmpVar)new SnmpString(new byte[0]));
                SnmpFetch.set(peer, varList1);
            }
            catch (SnmpException ex) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("FlexAtahPortCfgRunnable::setFlexAtathCfg cfs commit SET failed, ex=" + ex));
                }
                throw new Exception("cfs commit SET failed, ex=" + ex);
            }
            this.doPoll(peer, 4, "");
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("FlexAtahPortCfgRunnable::setFlexAtathCfg success  sw/requestId=" + this._sw + "/" + this._requestId));
        }
        QueueResponseObject result = new QueueResponseObject(this._requestId, this._sw, 1, "Successful", null);
        return result;
    }

    private ArrayList getVsanList() {
        ArrayList<Integer> vsanList = new ArrayList<Integer>();
        for (int i = 0; i < this._ports.size(); ++i) {
            FlexAtahCfg nextPort = this._ports.get(i);
            boolean found = false;
            for (int j = 0; j < vsanList.size(); ++j) {
                if (nextPort.getPortVsan() != -1 && nextPort.getPortVsan() != ((Integer)vsanList.get(j)).intValue()) continue;
                found = true;
                break;
            }
            if (found || nextPort.getPortVsan() == -1) continue;
            vsanList.add(new Integer(nextPort.getPortVsan()));
        }
        return vsanList;
    }

    private String checkVSANs(SnmpPeer peer) throws SnmpException {
        ArrayList vsanList = this.getVsanList();
        StringBuilder errMsg = new StringBuilder("VSAN ");
        if (vsanList == null || vsanList.size() == 0) {
            return errMsg.toString();
        }
        VarBindList varList = new VarBindList();
        for (int i = 0; i < vsanList.size(); ++i) {
            varList.add(_vsanMtuOid, (Integer)vsanList.get(i));
        }
        SnmpPDU resp = SnmpFetch.get(peer, varList);
        for (int i = 0; i < resp.getVariables().size(); ++i) {
            if (resp.getVariables().get(i).getVar().getType() != 5) continue;
            int[] oid = resp.getVariables().get(i).getOid().getValue();
            if (errMsg.length() > 5) {
                errMsg.append(", ");
            }
            errMsg.append(oid[oid.length - 1]);
        }
        if (errMsg.length() > 5) {
            errMsg.append(errMsg.toString().indexOf(44) != -1 ? " do " : " does ");
            errMsg.append("not exist.");
        }
        return errMsg.toString();
    }
}

