/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.flexattach;

import com.cisco.dcbu.sm.common.dto.FlexAtahCfg;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.server.flexattach.PortJob;
import java.util.List;

public class PortAndGlobalJob
extends PortJob {
    private List<List<FlexAtahCfg>> _jobPortObjects;
    private List<Boolean> _isGlobalAutoList;

    public PortAndGlobalJob(int jobType, long requestId, List<SwitchBase> jobSwitches, List<SnmpUserOpt> snmpCreds, List<Boolean> isGlobalAutoList, List<List<FlexAtahCfg>> jobPortObjects) throws IllegalArgumentException {
        super(jobType, requestId, jobSwitches, snmpCreds, jobPortObjects);
        if (jobPortObjects != null && jobPortObjects.size() > snmpCreds.size()) {
            throw new IllegalArgumentException("Snmp Credentials must be provided for all switches.");
        }
        if (jobSwitches == null || jobPortObjects == null) {
            throw new IllegalArgumentException("Must provide at least one switch and port to perform the action upon.");
        }
        this._jobPortObjects = jobPortObjects;
        this._isGlobalAutoList = isGlobalAutoList;
    }

    @Override
    public List<List<FlexAtahCfg>> getJobPortObjects() {
        return this._jobPortObjects;
    }

    public List<Boolean> getGlobalIsAutoList() {
        return this._isGlobalAutoList;
    }

    @Override
    public String toString() {
        String strSuper = super.toString();
        StringBuilder str = new StringBuilder(strSuper);
        str.append(" globalIsAuto - ").append(this._isGlobalAutoList);
        str.append(" jobPortObjects - ").append(this._jobPortObjects);
        return str.toString();
    }
}

