/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.inventory;

import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.mds.NexusEntityMibHelper;
import com.cisco.dcbu.sm.common.dto.HwInventoryType;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.model.HwInventoryComponent;
import com.cisco.dcbu.sm.common.model.PowerSupply;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.server.inventory.InventoryTreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class HardwareNode<E extends PKIf>
extends InventoryTreeNode<E> {
    HwInventoryComponent<E> _chassis;
    HashMap<Integer, Card<E>> _modules = new HashMap(16);
    HashMap<Integer, HwInventoryComponent<E>> _fans = new HashMap(4);
    HashMap<Integer, PowerSupply<E>> _powers = new HashMap(4);
    HashMap<Integer, HwInventoryComponent<E>> _fexChassises = new HashMap(10);

    HardwareNode(E swPK) {
        super(swPK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Card<E>> getCards() {
        HashMap<Integer, Card<E>> hashMap = this._modules;
        synchronized (hashMap) {
            return new ArrayList<Card<E>>(this._modules.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Card<E>> findSSMCards() {
        HashMap<Integer, Card<E>> hashMap = this._modules;
        synchronized (hashMap) {
            ArrayList<Card<Card<E>>> cards = new ArrayList<Card<Card<E>>>();
            for (Card<E> card : this._modules.values()) {
                if (card.getType() != 5 && card.getType() != 20) continue;
                cards.add(card);
            }
            return cards;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Card<E>> findSMECapableCards() {
        HashMap<Integer, Card<E>> hashMap = this._modules;
        synchronized (hashMap) {
            ArrayList<Card<Card<E>>> cards = new ArrayList<Card<Card<E>>>();
            for (Card<E> card : this._modules.values()) {
                if (card.getType() != 39 && card.getType() != 41 && card.getType() != 5 && card.getType() != 20 && card.getType() != 68) continue;
                cards.add(card);
            }
            return cards;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Card<E>> findIOACapableCards() {
        HashMap<Integer, Card<E>> hashMap = this._modules;
        synchronized (hashMap) {
            ArrayList<Card<Card<E>>> cards = new ArrayList<Card<Card<E>>>();
            for (Card<E> card : this._modules.values()) {
                if (card.getType() != 39 && card.getType() != 41 && card.getType() != 44 && card.getType() != 68) continue;
                cards.add(card);
            }
            return cards;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumCards() {
        HashMap<Integer, Card<E>> hashMap = this._modules;
        synchronized (hashMap) {
            return this._modules.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<Integer> getCardSlotIds() {
        HashMap<Integer, Card<E>> hashMap = this._modules;
        synchronized (hashMap) {
            return new HashSet<Integer>(this._modules.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Card<E> createCard(int slot, int phyIndex, int[] vendorType, String name, String hwRev, String fwRev, String swRev, String serialNum, String model, String mfg, String assetId, int adminStatus, int operStatus, String statusDescr, String resetReason, long chgTime, int powerAdminStatus, int powerOperStatus, int current, int dmmState, int ioaState, int seState, int santapState) {
        Card<Object> card;
        HashMap<Integer, Card<E>> hashMap = this._modules;
        synchronized (hashMap) {
            card = this._modules.get(slot);
            if (card == null) {
                card = new Card<PKIf>(this._swPK, phyIndex, vendorType, slot, name, hwRev, fwRev, swRev, serialNum, model, mfg, assetId, adminStatus, operStatus, statusDescr, resetReason, chgTime, powerAdminStatus, powerOperStatus, current, dmmState, ioaState, seState, santapState);
                this._modules.put(slot, card);
            }
        }
        return card;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Card<E> deleteCard(int slotId) {
        HashMap<Integer, Card<E>> hashMap = this._modules;
        synchronized (hashMap) {
            return this._modules.remove(slotId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteCards() {
        HashMap<Integer, Card<E>> hashMap = this._modules;
        synchronized (hashMap) {
            this._modules.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Card<E> findCard(int slotId) {
        HashMap<Integer, Card<E>> hashMap = this._modules;
        synchronized (hashMap) {
            return this._modules.get(slotId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Card<E> findCardByPhysicalIndex(int phyIndex) {
        HashMap<Integer, Card<E>> hashMap = this._modules;
        synchronized (hashMap) {
            for (Card<E> card : this._modules.values()) {
                if (card.getPhysicalIndex() != phyIndex) continue;
                return card;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasIPSCard() {
        HashMap<Integer, Card<E>> hashMap = this._modules;
        synchronized (hashMap) {
            for (Card<E> card : this._modules.values()) {
                if (!FRUConstants.isIpsCard(card.getType())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasILC() {
        HashMap<Integer, Card<E>> hashMap = this._modules;
        synchronized (hashMap) {
            for (Card<E> card : this._modules.values()) {
                if (card.getType() != 5 && card.getType() != 20 && card.getType() != 39 && card.getType() != 41 && card.getType() != 68) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSMECard() {
        HashMap<Integer, Card<E>> hashMap = this._modules;
        synchronized (hashMap) {
            for (Card<E> card : this._modules.values()) {
                if (card.getType() != 39 && card.getType() != 41) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDualSup() {
        int numSups = 0;
        HashMap<Integer, Card<E>> hashMap = this._modules;
        synchronized (hashMap) {
            for (Card<E> card : this._modules.values()) {
                if (card.getType() != 1 && card.getType() != 2 && card.getType() != 28 && card.getType() != 56) continue;
                ++numSups;
            }
        }
        return numSups == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HwInventoryComponent<E> createChassis(int phyIndex, String name, int[] vendorType, int relPos, String hwRev, String fwRev, String swRev, String serialNum, String mfg, String modelName, String assetId, String status, String secSerialNum) {
        HardwareNode hardwareNode = this;
        synchronized (hardwareNode) {
            if (this._chassis == null) {
                this._chassis = new HwInventoryComponent<PKIf>(this._swPK, phyIndex, name, vendorType, HwInventoryType.CHASSIS.value(), relPos, hwRev, fwRev, swRev, serialNum, mfg, modelName, assetId, status, secSerialNum);
            }
        }
        return this._chassis;
    }

    HwInventoryComponent<E> getChassis() {
        return this._chassis;
    }

    HwInventoryComponent<E> deleteChassis() {
        HwInventoryComponent<E> tch = this._chassis;
        this._chassis = null;
        return tch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HwInventoryComponent<E> createFan(int phyIndex, String name, int[] vendorType, int relPos, String hwRev, String fwRev, String swRev, String serialNum, String mfg, String modelName, String assetId, String status) {
        HwInventoryComponent<Object> fan;
        HashMap<Integer, HwInventoryComponent<E>> hashMap = this._fans;
        synchronized (hashMap) {
            fan = this._fans.get(relPos);
            if (fan == null) {
                fan = new HwInventoryComponent<PKIf>(this._swPK, phyIndex, name, vendorType, HwInventoryType.FAN.value(), relPos, hwRev, fwRev, swRev, serialNum, mfg, modelName, assetId, status, "n/a");
                this._fans.put(relPos, fan);
            }
        }
        return fan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HwInventoryComponent<E> deleteFan(int slotId) {
        HashMap<Integer, HwInventoryComponent<E>> hashMap = this._fans;
        synchronized (hashMap) {
            return this._fans.remove(slotId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HwInventoryComponent<E> findFan(int slotId) {
        HashMap<Integer, HwInventoryComponent<E>> hashMap = this._fans;
        synchronized (hashMap) {
            return this._fans.get(slotId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HwInventoryComponent<E> findFanByPhysicalIndex(int phyIndex) {
        HashMap<Integer, HwInventoryComponent<E>> hashMap = this._fans;
        synchronized (hashMap) {
            for (HwInventoryComponent<E> fan : this._fans.values()) {
                if (fan.getPhysicalIndex() != phyIndex) continue;
                return fan;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<HwInventoryComponent<E>> getFans() {
        HashMap<Integer, HwInventoryComponent<E>> hashMap = this._fans;
        synchronized (hashMap) {
            return new ArrayList<HwInventoryComponent<E>>(this._fans.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<Integer> getFanSlotIds() {
        HashMap<Integer, HwInventoryComponent<E>> hashMap = this._fans;
        synchronized (hashMap) {
            return new HashSet<Integer>(this._fans.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PowerSupply<E> createPowerSupply(int phyIndex, String name, int[] vendorType, int relPos, String hwRev, String fwRev, String swRev, String serialNum, String mfg, String modelName, String assetId, String status, int redundancyMode, int drawnCur, int availCur, String units) {
        PowerSupply<Object> power;
        HashMap<Integer, PowerSupply<E>> hashMap = this._powers;
        synchronized (hashMap) {
            power = this._powers.get(relPos);
            if (power == null) {
                power = new PowerSupply<PKIf>(this._swPK, phyIndex, name, vendorType, relPos, hwRev, fwRev, swRev, serialNum, mfg, modelName, assetId, status, redundancyMode, drawnCur, availCur, units);
                this._powers.put(relPos, power);
            }
        }
        return power;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PowerSupply<E> deletePowerSupply(int slotId) {
        HashMap<Integer, PowerSupply<E>> hashMap = this._powers;
        synchronized (hashMap) {
            return this._powers.remove(slotId);
        }
    }

    List<PowerSupply<E>> getPowerSupplies() {
        return new ArrayList<PowerSupply<E>>(this._powers.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<Integer> getPowerSupplySlotIds() {
        HashMap<Integer, PowerSupply<E>> hashMap = this._powers;
        synchronized (hashMap) {
            return new HashSet<Integer>(this._powers.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PowerSupply<E> findPowerSupply(int slotId) {
        HashMap<Integer, PowerSupply<E>> hashMap = this._powers;
        synchronized (hashMap) {
            return this._powers.get(slotId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PowerSupply<E> findPowerSupplyByPhysicalIndex(int phyIndex) {
        HashMap<Integer, PowerSupply<E>> hashMap = this._powers;
        synchronized (hashMap) {
            for (PowerSupply<E> ps : this._powers.values()) {
                if (ps.getPhysicalIndex() != phyIndex) continue;
                return ps;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HwInventoryComponent<E> createFexChassis(int phyIndex, String name, int[] vendorType, int relPos, String hwRev, String fwRev, String swRev, String serialNum, String mfg, String modelName, String assetId, String status, String secSerialNum) {
        HwInventoryComponent<Object> fexChassis = null;
        HashMap<Integer, HwInventoryComponent<E>> hashMap = this._fexChassises;
        synchronized (hashMap) {
            fexChassis = this._fexChassises.get(phyIndex);
            if (fexChassis == null) {
                fexChassis = new HwInventoryComponent<PKIf>(this._swPK, phyIndex, name, vendorType, HwInventoryType.CHASSIS.value(), relPos, hwRev, fwRev, swRev, serialNum, mfg, modelName, assetId, status, secSerialNum);
                this._fexChassises.put(phyIndex, fexChassis);
            }
        }
        return fexChassis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HwInventoryComponent<E> deleteFexChassis(int phyIndex) {
        HashMap<Integer, HwInventoryComponent<E>> hashMap = this._fexChassises;
        synchronized (hashMap) {
            return this._fexChassises.remove(phyIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteFexChassises() {
        HashMap<Integer, HwInventoryComponent<E>> hashMap = this._fexChassises;
        synchronized (hashMap) {
            this._fexChassises.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Integer, HwInventoryComponent<E>> getFexChassises() {
        HashMap<Integer, HwInventoryComponent<E>> hashMap = this._fexChassises;
        synchronized (hashMap) {
            if (this._fexChassises.size() == 0) {
                return Collections.EMPTY_MAP;
            }
            return new HashMap<Integer, HwInventoryComponent<E>>(this._fexChassises);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HwInventoryComponent<E> findFexChassis(int phyIndex) {
        HashMap<Integer, HwInventoryComponent<E>> hashMap = this._fexChassises;
        synchronized (hashMap) {
            return this._fexChassises.get(phyIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Card<E> createFexCard(int phyIndex, int[] vendorType, String name, String hwRev, String fwRev, String swRev, String serialNum, String model, String mfg, String assetId, int adminStatus, int operStatus, String statusDescr, String resetReason, long chgTime, int powerAdminStatus, int powerOperStatus, int current) {
        Card<Object> card;
        HashMap<Integer, Card<E>> hashMap = this._modules;
        synchronized (hashMap) {
            card = this._modules.get(phyIndex);
            if (card == null) {
                card = new Card<PKIf>(this._swPK, phyIndex, vendorType, NexusEntityMibHelper.getFexIdByPhyIndex(phyIndex), name, hwRev, fwRev, swRev, serialNum, model, mfg, assetId, adminStatus, operStatus, statusDescr, resetReason, chgTime, powerAdminStatus, powerOperStatus, current, 0, 0, 0, 0);
                this._modules.put(phyIndex, card);
            }
        }
        return card;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Integer, Card<E>> getFexCards() {
        HashMap<Integer, Card<E>> cards = new HashMap<Integer, Card<E>>();
        HashMap<Integer, Card<E>> hashMap = this._modules;
        synchronized (hashMap) {
            for (Card<E> card : this._modules.values()) {
                if (!card.isFex()) continue;
                cards.put(card.getPhysicalIndex(), card);
            }
        }
        return cards;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Card<E> findFexCard(int phyIndex) {
        HashMap<Integer, Card<E>> hashMap = this._modules;
        synchronized (hashMap) {
            return this._modules.get(phyIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Card<E> deleteFexCard(int phyIndex) {
        HashMap<Integer, Card<E>> hashMap = this._modules;
        synchronized (hashMap) {
            return this._modules.remove(phyIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HwInventoryComponent<E> createFexFan(int phyIndex, String name, int[] vendorType, int relPos, String hwRev, String fwRev, String swRev, String serialNum, String mfg, String modelName, String assetId, String status) {
        HwInventoryComponent<Object> fan;
        HashMap<Integer, HwInventoryComponent<E>> hashMap = this._fans;
        synchronized (hashMap) {
            fan = this._fans.get(phyIndex);
            if (fan == null) {
                fan = new HwInventoryComponent<PKIf>(this._swPK, phyIndex, name, vendorType, HwInventoryType.FAN.value(), relPos, hwRev, fwRev, swRev, serialNum, mfg, modelName, assetId, status, "n/a");
                this._fans.put(phyIndex, fan);
            }
        }
        return fan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Integer, HwInventoryComponent<E>> getFexFans() {
        HashMap<Integer, HwInventoryComponent<E>> hashMap = this._fans;
        synchronized (hashMap) {
            if (this._fans.size() == 0) {
                return Collections.EMPTY_MAP;
            }
            HashMap<Integer, HwInventoryComponent<E>> ret = new HashMap<Integer, HwInventoryComponent<E>>();
            for (HwInventoryComponent<E> fan : this._fans.values()) {
                if (!fan.isFex()) continue;
                ret.put(fan.getPhysicalIndex(), fan);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<HwInventoryComponent<E>> getFexFans(int fexId) {
        int phyIndex = NexusEntityMibHelper.getFexEntityIndex(HwInventoryType.FAN.value(), fexId);
        int maxPhyIndex = NexusEntityMibHelper.getFexEntityIndex(HwInventoryType.FAN.value(), fexId);
        HashMap<Integer, HwInventoryComponent<E>> hashMap = this._fans;
        synchronized (hashMap) {
            HwInventoryComponent<E> fan;
            if (this._fans.size() == 0) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<HwInventoryComponent<HwInventoryComponent<E>>> ret = new ArrayList<HwInventoryComponent<HwInventoryComponent<E>>>();
            for (int i = phyIndex; i <= maxPhyIndex && (fan = this._fans.get(i)) != null; ++i) {
                ret.add(fan);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HwInventoryComponent<E> findFexFan(int phyIndex) {
        HashMap<Integer, HwInventoryComponent<E>> hashMap = this._fans;
        synchronized (hashMap) {
            return this._fans.get(phyIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HwInventoryComponent<E> deleteFexFan(int phyIndex) {
        HashMap<Integer, HwInventoryComponent<E>> hashMap = this._fans;
        synchronized (hashMap) {
            return this._fans.remove(phyIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PowerSupply<E> createFexPower(int phyIndex, String name, int[] vendorType, int relPos, String hwRev, String fwRev, String swRev, String serialNum, String mfg, String modelName, String assetId, String status, int redundancyMode, int drawnCur, int availCur, String units) {
        PowerSupply<Object> power;
        HashMap<Integer, PowerSupply<E>> hashMap = this._powers;
        synchronized (hashMap) {
            power = this._powers.get(phyIndex);
            if (power == null) {
                power = new PowerSupply<PKIf>(this._swPK, phyIndex, name, vendorType, relPos, hwRev, fwRev, swRev, serialNum, mfg, modelName, assetId, status, redundancyMode, drawnCur, availCur, units);
                this._powers.put(phyIndex, power);
            }
        }
        return power;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Integer, PowerSupply<E>> getFexPowers() {
        HashMap<Integer, PowerSupply<E>> hashMap = this._powers;
        synchronized (hashMap) {
            if (this._powers.size() == 0) {
                return Collections.EMPTY_MAP;
            }
            HashMap<Integer, PowerSupply<E>> ret = new HashMap<Integer, PowerSupply<E>>();
            for (PowerSupply<E> pw : this._powers.values()) {
                if (!pw.isFex()) continue;
                ret.put(pw.getPhysicalIndex(), pw);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<PowerSupply<E>> getFexPowers(int fexId) {
        int phyIndex = NexusEntityMibHelper.getFexEntityIndex(HwInventoryType.POWERSUPPLY.value(), fexId);
        int maxPhyIndex = NexusEntityMibHelper.getFexEntityIndex(HwInventoryType.POWERSUPPLY.value(), fexId);
        HashMap<Integer, PowerSupply<E>> hashMap = this._powers;
        synchronized (hashMap) {
            PowerSupply<E> ps;
            if (this._powers.size() == 0) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<PowerSupply<PowerSupply<E>>> ret = new ArrayList<PowerSupply<PowerSupply<E>>>();
            for (int i = phyIndex; i <= maxPhyIndex && (ps = this._powers.get(i)) != null; ++i) {
                ret.add(ps);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PowerSupply<E> findFexPower(int phyIndex) {
        HashMap<Integer, PowerSupply<E>> hashMap = this._powers;
        synchronized (hashMap) {
            return this._powers.get(phyIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PowerSupply<E> deleteFexPower(int phyIndex) {
        HashMap<Integer, PowerSupply<E>> hashMap = this._powers;
        synchronized (hashMap) {
            return this._powers.remove(phyIndex);
        }
    }
}

