/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.inventory;

import com.cisco.dcbu.lib.mds.NexusEntityMibHelper;
import com.cisco.dcbu.sm.common.dto.HwInventoryType;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.model.HwInventoryComponent;
import com.cisco.dcbu.sm.common.model.LicenseInfo;
import com.cisco.dcbu.sm.common.model.PowerSupply;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.inventory.HardwareNode;
import com.cisco.dcbu.sm.server.inventory.InventoryTreeNode;
import com.cisco.dcbu.sm.server.inventory.LicenseNode;
import com.cisco.dcbu.sm.server.inventory.SoftwareNode;
import com.cisco.dcbu.sm.server.inventory.SwitchInventoryWorkerIf;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

class NEInventoryNode<E extends PKIf>
extends InventoryTreeNode<E> {
    private HardwareNode<E> _hwNode;
    private SoftwareNode _swNode;
    private LicenseNode<E> _licNode;
    private SwitchInventoryWorkerIf _worker;

    NEInventoryNode(E swPK) {
        super(swPK);
    }

    private synchronized HardwareNode<E> createHardwareNode() {
        if (this._hwNode == null) {
            this._hwNode = new HardwareNode<PKIf>(this._swPK);
        }
        return this._hwNode;
    }

    private synchronized SoftwareNode createSoftwareNode() {
        if (this._swNode == null) {
            this._swNode = new SoftwareNode((WwnKey)this._swPK);
        }
        return this._swNode;
    }

    private synchronized LicenseNode<E> createLicenseNode() {
        if (this._licNode == null) {
            this._licNode = new LicenseNode<PKIf>(this._swPK);
        }
        return this._licNode;
    }

    SwitchInventoryWorkerIf getWorker() {
        return this._worker;
    }

    void setWorker(SwitchInventoryWorkerIf worker) {
        this._worker = worker;
    }

    Card<E> createCard(int slot, int phyIndex, int[] vendorType, String name, String hwRev, String fwRev, String swRev, String serialNum, String model, String mfg, String assetId, int adminStatus, int operStatus, String statusDescr, String resetReason, long changeTime, int powerAdminStatus, int powerOperStatus, int current, int dmmState, int ioaState, int seState, int santapState) {
        return this.createHardwareNode().createCard(slot, phyIndex, vendorType, name, hwRev, fwRev, swRev, serialNum, model, mfg, assetId, adminStatus, operStatus, statusDescr, resetReason, changeTime, powerAdminStatus, powerOperStatus, current, dmmState, ioaState, seState, santapState);
    }

    Card<E> deleteCard(int slotId) {
        return this._hwNode != null ? this._hwNode.deleteCard(slotId) : null;
    }

    void deleteCards() {
        if (this._hwNode != null) {
            this._hwNode.deleteCards();
        }
    }

    int getNumCards() {
        return this._hwNode != null ? this._hwNode.getNumCards() : 0;
    }

    List<Card<E>> getCards() {
        return this._hwNode != null ? this._hwNode.getCards() : Collections.emptyList();
    }

    Set<Integer> getCardSlotIds() {
        return this._hwNode != null ? this._hwNode.getCardSlotIds() : Collections.emptySet();
    }

    Card<E> findCard(int slot) {
        return this._hwNode != null ? this._hwNode.findCard(slot) : null;
    }

    Card<E> findCardByPhysicalIndex(int phyIndex) {
        if (NexusEntityMibHelper.isFexPhyIndex(phyIndex)) {
            return this._hwNode != null ? this._hwNode.findFexCard(phyIndex) : null;
        }
        return this._hwNode != null ? this._hwNode.findCardByPhysicalIndex(phyIndex) : null;
    }

    List<Card<E>> findSSMCards() {
        return this._hwNode != null ? this._hwNode.findSSMCards() : Collections.emptyList();
    }

    List<Card<E>> findSMECapableCards() {
        return this._hwNode != null ? this._hwNode.findSMECapableCards() : Collections.emptyList();
    }

    List<Card<E>> findIOACapableCards() {
        return this._hwNode != null ? this._hwNode.findIOACapableCards() : Collections.emptyList();
    }

    boolean hasIPSCard() {
        return this._hwNode != null ? this._hwNode.hasIPSCard() : false;
    }

    boolean hasSMECard() {
        return this._hwNode != null ? this._hwNode.hasSMECard() : false;
    }

    public boolean hasILC() {
        return this._hwNode != null ? this._hwNode.hasILC() : false;
    }

    public boolean hasDualSup() {
        return this._hwNode != null ? this._hwNode.hasDualSup() : false;
    }

    HwInventoryComponent<E> createHwComponent(int phyIndex, String name, int[] vendorType, int hwType, int relPos, String hwRev, String fwRev, String swRev, String serialNum, String mfg, String modelName, String assetId, String status, String secSerialNum) {
        HwInventoryType type = HwInventoryType.getType(hwType);
        HardwareNode<E> hw = this.createHardwareNode();
        HwInventoryComponent<E> comp = null;
        if (type == HwInventoryType.CHASSIS) {
            comp = hw.createChassis(phyIndex, name, vendorType, relPos, hwRev, fwRev, swRev, serialNum, mfg, modelName, assetId, status, secSerialNum);
        } else if (type == HwInventoryType.FAN) {
            comp = hw.createFan(phyIndex, name, vendorType, relPos, hwRev, fwRev, swRev, serialNum, mfg, modelName, assetId, status);
        } else if (type == HwInventoryType.POWERSUPPLY) {
            comp = hw.createPowerSupply(phyIndex, name, vendorType, relPos, hwRev, fwRev, swRev, serialNum, mfg, modelName, assetId, status, 0, 0, 0, null);
        } else if (type == HwInventoryType.MODULE) {
            comp = hw.createCard(relPos, phyIndex, vendorType, name, hwRev, fwRev, swRev, serialNum, modelName, mfg, assetId, 0, 0, status, null, 0L, 0, 0, 0, 0, 0, 0, 0);
        }
        return comp;
    }

    HwInventoryComponent<E> findHardwareComponent(int phyIndex) {
        if (this._hwNode == null) {
            return null;
        }
        HwInventoryComponent comp = null;
        comp = this._hwNode.findCardByPhysicalIndex(phyIndex);
        if (comp != null) {
            return comp;
        }
        comp = this._hwNode.findPowerSupplyByPhysicalIndex(phyIndex);
        if (comp != null) {
            return comp;
        }
        comp = this._hwNode.findFanByPhysicalIndex(phyIndex);
        if (comp != null) {
            return comp;
        }
        if (NexusEntityMibHelper.isFexChassisPhyIndex(phyIndex) && (comp = this._hwNode.findFexChassis(phyIndex)) != null) {
            return comp;
        }
        comp = this._hwNode.getChassis();
        if (comp == null || comp.getPhysicalIndex() != phyIndex) {
            comp = null;
        }
        return comp;
    }

    HwInventoryComponent<E> getChassis() {
        return this._hwNode != null ? this._hwNode.getChassis() : null;
    }

    HwInventoryComponent<E> deleteChassis() {
        return this._hwNode != null ? this._hwNode.deleteChassis() : null;
    }

    HwInventoryComponent<E> createFan(int phyIndex, String name, int[] vendorType, int relPos, String hwRev, String fwRev, String swRev, String serialNum, String mfg, String modelName, String assetId, String status) {
        return this.createHardwareNode().createFan(phyIndex, name, vendorType, relPos, hwRev, fwRev, swRev, serialNum, mfg, modelName, assetId, status);
    }

    HwInventoryComponent<E> findFan(int slot) {
        return this._hwNode != null ? this._hwNode.findFan(slot) : null;
    }

    List<HwInventoryComponent<E>> getFans() {
        return this._hwNode != null ? this._hwNode.getFans() : Collections.emptyList();
    }

    Set<Integer> getFanSlotIds() {
        return this._hwNode != null ? this._hwNode.getFanSlotIds() : Collections.emptySet();
    }

    HwInventoryComponent<E> deleteFan(int slotId) {
        return this._hwNode != null ? this._hwNode.deleteFan(slotId) : null;
    }

    HwInventoryComponent<E> findFanByPhysicalIndex(int phyIndex) {
        if (NexusEntityMibHelper.isFexPhyIndex(phyIndex)) {
            return this._hwNode != null ? this._hwNode.findFexFan(phyIndex) : null;
        }
        return this._hwNode != null ? this._hwNode.findFanByPhysicalIndex(phyIndex) : null;
    }

    PowerSupply<E> createPowerSupply(int phyIndex, String name, int[] vendorType, int relPos, String hwRev, String fwRev, String swRev, String serialNum, String mfg, String modelName, String assetId, String status, int redundancyMode, int drawnCur, int availCur, String units) {
        return this.createHardwareNode().createPowerSupply(phyIndex, name, vendorType, relPos, hwRev, fwRev, swRev, serialNum, mfg, modelName, assetId, status, redundancyMode, drawnCur, availCur, units);
    }

    List<PowerSupply<E>> getPowerSupplies() {
        return this._hwNode != null ? this._hwNode.getPowerSupplies() : Collections.emptyList();
    }

    Set<Integer> getPowerSupplySlotIds() {
        return this._hwNode != null ? this._hwNode.getPowerSupplySlotIds() : Collections.emptySet();
    }

    PowerSupply<E> deletePowerSupply(int slotId) {
        return this._hwNode != null ? this._hwNode.deletePowerSupply(slotId) : null;
    }

    PowerSupply<E> findPowerSupply(int slotNum) {
        return this._hwNode != null ? this._hwNode.findPowerSupply(slotNum) : null;
    }

    PowerSupply<E> findPowerSupplyByPhysicalIndex(int phyIndex) {
        if (NexusEntityMibHelper.isFexPhyIndex(phyIndex)) {
            return this._hwNode != null ? this._hwNode.findFexPower(phyIndex) : null;
        }
        return this._hwNode != null ? this._hwNode.findPowerSupplyByPhysicalIndex(phyIndex) : null;
    }

    HwInventoryComponent<E> createFexChassis(int phyIndex, String name, int[] vendorType, int relPos, String hwRev, String fwRev, String swRev, String serialNum, String mfg, String modelName, String assetId, String status, String secSerialNum) {
        return this.createHardwareNode().createFexChassis(phyIndex, name, vendorType, relPos, hwRev, fwRev, swRev, serialNum, mfg, modelName, assetId, status, secSerialNum);
    }

    Map<Integer, HwInventoryComponent<E>> getFexChassises() {
        return this._hwNode != null ? this._hwNode.getFexChassises() : Collections.EMPTY_MAP;
    }

    HwInventoryComponent<E> deleteFexChassis(int phyIndex) {
        return this._hwNode != null ? this._hwNode.deleteFexChassis(phyIndex) : null;
    }

    HwInventoryComponent<E> findFexChassis(int phyIndex) {
        return this._hwNode != null ? this._hwNode.findFexChassis(phyIndex) : null;
    }

    Card<E> createFexCard(int phyIndex, int[] vendorType, String name, String hwRev, String fwRev, String swRev, String serialNum, String model, String mfg, String assetId, int adminStatus, int operStatus, String statusDescr, String resetReason, long chgTime, int powerAdminStatus, int powerOperStatus, int current) {
        return this.createHardwareNode().createFexCard(phyIndex, vendorType, name, hwRev, fwRev, swRev, serialNum, model, mfg, assetId, adminStatus, operStatus, statusDescr, resetReason, chgTime, powerAdminStatus, powerOperStatus, current);
    }

    Map<Integer, Card<E>> getFexCards() {
        return this._hwNode != null ? this._hwNode.getFexCards() : Collections.EMPTY_MAP;
    }

    Card<E> deleteFexCard(int phyIndex) {
        return this._hwNode != null ? this._hwNode.deleteFexCard(phyIndex) : null;
    }

    Card<E> findFexCard(int phyIndex) {
        return this._hwNode != null ? this._hwNode.findFexCard(phyIndex) : null;
    }

    HwInventoryComponent<E> createFexFan(int phyIndex, String name, int[] vendorType, int relPos, String hwRev, String fwRev, String swRev, String serialNum, String mfg, String modelName, String assetId, String status) {
        return this.createHardwareNode().createFexFan(phyIndex, name, vendorType, relPos, hwRev, fwRev, swRev, serialNum, mfg, modelName, assetId, status);
    }

    Map<Integer, HwInventoryComponent<E>> getFexFans() {
        return this._hwNode != null ? this._hwNode.getFexFans() : Collections.EMPTY_MAP;
    }

    HwInventoryComponent<E> deleteFexFan(int phyIndex) {
        return this._hwNode != null ? this._hwNode.deleteFexFan(phyIndex) : null;
    }

    HwInventoryComponent<E> findFexFan(int phyIndex) {
        return this._hwNode != null ? this._hwNode.deleteFexFan(phyIndex) : null;
    }

    PowerSupply<E> createFexPower(int phyIndex, String name, int[] vendorType, int relPos, String hwRev, String fwRev, String swRev, String serialNum, String mfg, String modelName, String assetId, String status, int redundancyMode, int drawnCur, int availCur, String units) {
        return this.createHardwareNode().createFexPower(phyIndex, name, vendorType, relPos, hwRev, fwRev, swRev, serialNum, mfg, modelName, assetId, status, redundancyMode, drawnCur, availCur, units);
    }

    Map<Integer, PowerSupply<E>> getFexPowers() {
        return this._hwNode != null ? this._hwNode.getFexPowers() : Collections.EMPTY_MAP;
    }

    PowerSupply<E> deleteFexPower(int phyIndex) {
        return this._hwNode != null ? this._hwNode.deleteFexPower(phyIndex) : null;
    }

    PowerSupply<E> findFexPower(int phyIndex) {
        return this._hwNode != null ? this._hwNode.deleteFexPower(phyIndex) : null;
    }

    LicenseInfo createLicense(String name, byte flags, int curUsage, int maxUsage, int misUsage, byte[] dateAndTime, int gracePeriod) {
        return this.createLicenseNode().createLicense(name, flags, curUsage, maxUsage, misUsage, dateAndTime, gracePeriod);
    }

    int getNumLicenses() {
        return this._licNode != null ? this._licNode.getNumLicenses() : 0;
    }

    LicenseInfo deleteLicense(String name) {
        return this._licNode != null ? this._licNode.deleteLicense(name) : null;
    }

    void deleteLicenses() {
        if (this._licNode != null) {
            this._licNode.deleteLicenses();
        }
    }

    List<LicenseInfo> getLicenses() {
        return this._licNode != null ? this._licNode.getLicenses() : Collections.emptyList();
    }

    Set<String> getLicenseNames() {
        return this._licNode != null ? this._licNode.getLicenseNames() : Collections.emptySet();
    }

    LicenseInfo findLicense(String name) {
        return this._licNode != null ? this._licNode.findLicense(name) : null;
    }
}

