/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.ioa.message;

import com.cisco.dcbu.sm.common.model.ioa.Switch;
import com.cisco.dcbu.sm.server.ioa.message.IOAMessageBase;
import com.cisco.dcbu.sm.server.ioa.xml.ClusterData;
import com.cisco.dcbu.sm.server.ioa.xml.ClusterGetReq;
import com.cisco.dcbu.sm.server.ioa.xml.ClusterIndex;
import com.cisco.dcbu.sm.server.ioa.xml.ClusterInterfaceData;
import com.cisco.dcbu.sm.server.ioa.xml.ClusterInterfaceIndex;
import com.cisco.dcbu.sm.server.ioa.xml.ClusterInterfaceObject;
import com.cisco.dcbu.sm.server.ioa.xml.ClusterNodeData;
import com.cisco.dcbu.sm.server.ioa.xml.ClusterNodeIndex;
import com.cisco.dcbu.sm.server.ioa.xml.ClusterNodeObject;
import com.cisco.dcbu.sm.server.ioa.xml.ClusterObject;
import com.cisco.dcbu.sm.server.ioa.xml.ClusterSetReq;
import com.cisco.dcbu.sm.server.ioa.xml.GlobalGetReq;
import com.cisco.dcbu.sm.server.ioa.xml.IOAMessage;
import com.cisco.dcbu.sm.server.ioa.xml.IOAOpcodeEnum;
import com.cisco.dcbu.sm.server.ioa.xml.IOATableData;
import com.cisco.dcbu.sm.server.ioa.xml.IOATableEnum;
import com.cisco.dcbu.sm.server.ioa.xml.InterfaceIndex;
import com.cisco.dcbu.sm.server.ioa.xml.OperationEnum;
import com.cisco.dcbu.sm.server.ioa.xml.SiteGetReq;
import com.cisco.dcbu.sm.server.ioa.xml.SiteIndex;
import com.cisco.dcbu.sm.server.ioa.xml.SiteObject;
import com.cisco.dcbu.sm.server.ioa.xml.SiteSetReq;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class ClusterMessage
extends IOAMessageBase {
    static Logger _Logger = Logger.getLogger((String)"IOA_SRV");

    public String prepareCreateClusterSetReq(String clusterName) {
        IOAMessage IOAMessage2 = new IOAMessage();
        IOAMessage2.setMsg_Header(this.ioaMessageHeader("1.0", OperationEnum.BASE___SVC___OP___SET));
        IOAMessage2.setTable_Req_Header(this.ioaTableHeader(IOATableEnum.CLUSTER___TABLE, IOAOpcodeEnum.CREATE___CLUSTER));
        IOATableData tableData = new IOATableData();
        ClusterSetReq clusterSetReq = new ClusterSetReq();
        ClusterObject object = new ClusterObject();
        ClusterIndex index = new ClusterIndex();
        index.setCluster_Name(clusterName);
        object.setIndex(index);
        ClusterData data = new ClusterData();
        object.setData(data);
        clusterSetReq.setCluster(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        IOAMessage2.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + IOAMessage2.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name()));
        return this.buildIOAMessage(IOAMessage2);
    }

    public String prepareUpdateClusterNodeSetReq(String clusterName, String siteName, Switch node) {
        IOAMessage IOAMessage2 = new IOAMessage();
        IOAMessage2.setMsg_Header(this.ioaMessageHeader("1.0", OperationEnum.BASE___SVC___OP___SET));
        IOAMessage2.setTable_Req_Header(this.ioaTableHeader(IOATableEnum.CLUSTER___TABLE, IOAOpcodeEnum.UPDATE___CLUSTER___NODE));
        IOATableData tableData = new IOATableData();
        ClusterSetReq clusterSetReq = new ClusterSetReq();
        ClusterNodeObject object = new ClusterNodeObject();
        ClusterNodeIndex index = new ClusterNodeIndex();
        index.setCluster_Name(clusterName);
        index.setNode_Name(node.getIpAddress());
        object.setIndex(index);
        ClusterNodeData data = new ClusterNodeData();
        data.setSite(siteName);
        object.setData(data);
        clusterSetReq.setNode(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        IOAMessage2.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + IOAMessage2.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " node: " + index.getNode_Name()));
        return this.buildIOAMessage(IOAMessage2);
    }

    public String prepareUpdateClusterInterfaceSetReq(String clusterName, Switch node, String ifIndex, boolean isMaster, boolean isMemberLocal) {
        IOAMessage IOAMessage2 = new IOAMessage();
        IOAMessage2.setMsg_Header(this.ioaMessageHeader("1.0", OperationEnum.BASE___SVC___OP___SET));
        IOAMessage2.setTable_Req_Header(this.ioaTableHeader(IOATableEnum.CLUSTER___TABLE, IOAOpcodeEnum.UPDATE___CLUSTER___INTERFACE));
        IOATableData tableData = new IOATableData();
        ClusterSetReq clusterSetReq = new ClusterSetReq();
        ClusterInterfaceObject object = new ClusterInterfaceObject();
        ClusterInterfaceIndex index = new ClusterInterfaceIndex();
        index.setCluster_Name(clusterName);
        if (node.isSwitchCommUseIp()) {
            index.setNode_Name(node.getIpAddress());
        } else {
            index.setNode_Name(node.getName());
        }
        index.setIf_Index(ifIndex);
        object.setIndex(index);
        ClusterInterfaceData data = new ClusterInterfaceData();
        data.setIs_Master(isMaster);
        data.setIs_Member_Local(isMemberLocal);
        data.setForce(true);
        object.setData(data);
        clusterSetReq.setInterface(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        IOAMessage2.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + IOAMessage2.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " node: " + index.getNode_Name() + " interface: " + index.getIf_Index()));
        return this.buildIOAMessage(IOAMessage2);
    }

    public String prepareDeleteClusterSetReq(String clusterName) {
        IOAMessage IOAMessage2 = new IOAMessage();
        IOAMessage2.setMsg_Header(this.ioaMessageHeader("1.0", OperationEnum.BASE___SVC___OP___SET));
        IOAMessage2.setTable_Req_Header(this.ioaTableHeader(IOATableEnum.CLUSTER___TABLE, IOAOpcodeEnum.DELETE___CLUSTER));
        IOATableData tableData = new IOATableData();
        ClusterSetReq clusterSetReq = new ClusterSetReq();
        ClusterObject object = new ClusterObject();
        ClusterIndex index = new ClusterIndex();
        index.setCluster_Name(clusterName);
        object.setIndex(index);
        clusterSetReq.setCluster(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        IOAMessage2.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + IOAMessage2.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name()));
        return this.buildIOAMessage(IOAMessage2);
    }

    public String prepareDeleteClusterNodeSetReq(String clusterName, Switch node) {
        IOAMessage IOAMessage2 = new IOAMessage();
        IOAMessage2.setMsg_Header(this.ioaMessageHeader("1.0", OperationEnum.BASE___SVC___OP___SET));
        IOAMessage2.setTable_Req_Header(this.ioaTableHeader(IOATableEnum.CLUSTER___TABLE, IOAOpcodeEnum.DELETE___CLUSTER___NODE));
        IOATableData tableData = new IOATableData();
        ClusterSetReq clusterSetReq = new ClusterSetReq();
        ClusterNodeObject object = new ClusterNodeObject();
        ClusterNodeIndex index = new ClusterNodeIndex();
        index.setCluster_Name(clusterName);
        if (node.isSwitchCommUseIp()) {
            index.setNode_Name(node.getIpAddress());
        } else {
            index.setNode_Name(node.getName());
        }
        object.setIndex(index);
        clusterSetReq.setNode(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        IOAMessage2.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + IOAMessage2.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " node: " + index.getNode_Name()));
        return this.buildIOAMessage(IOAMessage2);
    }

    public String prepareDeleteClusterInterfaceSetReq(String clusterName, Switch node, String interfaceId) {
        IOAMessage IOAMessage2 = new IOAMessage();
        IOAMessage2.setMsg_Header(this.ioaMessageHeader("1.0", OperationEnum.BASE___SVC___OP___SET));
        IOAMessage2.setTable_Req_Header(this.ioaTableHeader(IOATableEnum.CLUSTER___TABLE, IOAOpcodeEnum.DELETE___CLUSTER___INTERFACE));
        IOATableData tableData = new IOATableData();
        ClusterSetReq clusterSetReq = new ClusterSetReq();
        ClusterInterfaceObject object = new ClusterInterfaceObject();
        ClusterInterfaceIndex index = new ClusterInterfaceIndex();
        index.setCluster_Name(clusterName);
        if (node.isSwitchCommUseIp()) {
            index.setNode_Name(node.getIpAddress());
        } else {
            index.setNode_Name(node.getName());
        }
        index.setIf_Index(interfaceId);
        object.setIndex(index);
        ClusterInterfaceData data = new ClusterInterfaceData();
        object.setData(data);
        clusterSetReq.setInterface(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        IOAMessage2.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + IOAMessage2.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " node: " + index.getNode_Name() + " interface: " + index.getIf_Index()));
        return this.buildIOAMessage(IOAMessage2);
    }

    public String prepareClusterGetReq(String clusterName, OperationEnum operation) {
        return this.prepareClusterGetReq(clusterName, operation, 1);
    }

    public String prepareClusterGetReq(String clusterName, OperationEnum operation, int count) {
        IOAMessage IOAMessage2 = new IOAMessage();
        IOAMessage2.setMsg_Header(this.ioaMessageHeader("1.0", operation));
        if (operation.equals((Object)OperationEnum.BASE___SVC___OP___GET)) {
            IOAMessage2.setTable_Req_Header(this.ioaTableHeader(IOATableEnum.CLUSTER___TABLE, IOAOpcodeEnum.GET___CLUSTER));
        } else if (operation.equals((Object)OperationEnum.BASE___SVC___OP___GET___NEXT)) {
            IOAMessage2.setTable_Req_Header(this.ioaTableHeader(IOATableEnum.CLUSTER___TABLE, IOAOpcodeEnum.GET___CLUSTER, count));
        }
        IOATableData tableData = new IOATableData();
        ClusterGetReq clusterGetReq = new ClusterGetReq();
        ClusterIndex index = new ClusterIndex();
        index.setCluster_Name(clusterName);
        clusterGetReq.setIndex(index);
        tableData.setCluster_Get_Req(clusterGetReq);
        IOAMessage2.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + IOAMessage2.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name()));
        return this.buildIOAMessage(IOAMessage2);
    }

    public String prepareClusterNodeGetReq(String clusterName, Switch node, OperationEnum operation) {
        return this.prepareClusterNodeGetReq(clusterName, node, operation, 1);
    }

    public String prepareClusterNodeGetReq(String clusterName, Switch node, OperationEnum operation, int count) {
        IOAMessage IOAMessage2 = new IOAMessage();
        IOAMessage2.setMsg_Header(this.ioaMessageHeader("1.0", operation));
        if (operation.equals((Object)OperationEnum.BASE___SVC___OP___GET)) {
            IOAMessage2.setTable_Req_Header(this.ioaTableHeader(IOATableEnum.CLUSTER___TABLE, IOAOpcodeEnum.GET___CLUSTER___NODE));
        } else if (operation.equals((Object)OperationEnum.BASE___SVC___OP___GET___NEXT)) {
            IOAMessage2.setTable_Req_Header(this.ioaTableHeader(IOATableEnum.CLUSTER___TABLE, IOAOpcodeEnum.GET___CLUSTER___NODE, count));
        }
        IOATableData tableData = new IOATableData();
        ClusterGetReq clusterGetReq = new ClusterGetReq();
        ClusterNodeIndex index = new ClusterNodeIndex();
        index.setCluster_Name(clusterName);
        if (node != null) {
            index.setNode_Name(node.getName());
        }
        clusterGetReq.setNode_Index(index);
        tableData.setCluster_Get_Req(clusterGetReq);
        IOAMessage2.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + IOAMessage2.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " node: " + index.getNode_Name()));
        return this.buildIOAMessage(IOAMessage2);
    }

    public String prepareClusterInterfaceGetReq(String clusterName, String node, String interfaceId, OperationEnum operation) {
        return this.prepareClusterInterfaceGetReq(clusterName, node, interfaceId, operation, 1);
    }

    public String prepareClusterInterfaceGetReq(String clusterName, String node, String interfaceId, OperationEnum operation, int count) {
        IOAMessage IOAMessage2 = new IOAMessage();
        IOAMessage2.setMsg_Header(this.ioaMessageHeader("1.0", operation));
        if (operation.equals((Object)OperationEnum.BASE___SVC___OP___GET)) {
            IOAMessage2.setTable_Req_Header(this.ioaTableHeader(IOATableEnum.CLUSTER___TABLE, IOAOpcodeEnum.GET___CLUSTER___INTERFACE));
        } else if (operation.equals((Object)OperationEnum.BASE___SVC___OP___GET___NEXT)) {
            IOAMessage2.setTable_Req_Header(this.ioaTableHeader(IOATableEnum.CLUSTER___TABLE, IOAOpcodeEnum.GET___CLUSTER___INTERFACE, count));
        }
        IOATableData tableData = new IOATableData();
        ClusterGetReq clusterGetReq = new ClusterGetReq();
        ClusterInterfaceIndex index = new ClusterInterfaceIndex();
        index.setCluster_Name(clusterName);
        if (node != null) {
            index.setNode_Name(node);
        }
        if (interfaceId != null) {
            index.setIf_Index(interfaceId);
        }
        clusterGetReq.setInterface_Index(index);
        tableData.setCluster_Get_Req(clusterGetReq);
        IOAMessage2.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + IOAMessage2.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name() + " node: " + index.getNode_Name() + " interface: " + index.getIf_Index()));
        return this.buildIOAMessage(IOAMessage2);
    }

    public String prepareSiteSetReq(String siteName) {
        IOAMessage ioaMessage = new IOAMessage();
        ioaMessage.setMsg_Header(this.ioaMessageHeader("1.0", OperationEnum.BASE___SVC___OP___SET));
        ioaMessage.setTable_Req_Header(this.ioaTableHeader(IOATableEnum.SITE___TABLE, IOAOpcodeEnum.CREATE___SITE));
        IOATableData tableData = new IOATableData();
        SiteSetReq setReq = new SiteSetReq();
        SiteIndex index = new SiteIndex();
        index.setSite_Name(siteName);
        SiteObject object = new SiteObject();
        object.setIndex(index);
        setReq.setSite(object);
        tableData.setSite_Set_Req(setReq);
        ioaMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + ioaMessage.getTable_Req_Header().getOpcode() + " site: " + index.getSite_Name()));
        return this.buildIOAMessage(ioaMessage);
    }

    public String prepareSiteGetReq(String siteName) {
        IOAMessage ioaMessage = new IOAMessage();
        ioaMessage.setMsg_Header(this.ioaMessageHeader("1.0", OperationEnum.BASE___SVC___OP___GET));
        ioaMessage.setTable_Req_Header(this.ioaTableHeader(IOATableEnum.SITE___TABLE, IOAOpcodeEnum.GET___SITE));
        IOATableData tableData = new IOATableData();
        SiteGetReq getReq = new SiteGetReq();
        SiteIndex index = new SiteIndex();
        index.setSite_Name(siteName);
        tableData.setSite_Get_Req(getReq);
        ioaMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + ioaMessage.getTable_Req_Header().getOpcode() + " site: " + index.getSite_Name()));
        return this.buildIOAMessage(ioaMessage);
    }

    public String prepareSiteDeleteReq(String siteName) {
        IOAMessage ioaMessage = new IOAMessage();
        ioaMessage.setMsg_Header(this.ioaMessageHeader("1.0", OperationEnum.BASE___SVC___OP___SET));
        ioaMessage.setTable_Req_Header(this.ioaTableHeader(IOATableEnum.SITE___TABLE, IOAOpcodeEnum.DELETE___SITE));
        IOATableData tableData = new IOATableData();
        SiteSetReq setReq = new SiteSetReq();
        SiteIndex index = new SiteIndex();
        index.setSite_Name(siteName);
        SiteObject object = new SiteObject();
        object.setIndex(index);
        setReq.setSite(object);
        tableData.setSite_Set_Req(setReq);
        ioaMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + ioaMessage.getTable_Req_Header().getOpcode() + " site: " + index.getSite_Name()));
        return this.buildIOAMessage(ioaMessage);
    }

    public IOAMessage parseClusterResponse(InputStream msg) {
        return this.parseIOAMessage(msg);
    }

    public String prepareGetInterfaceStatsGetReq(String ifIndex, OperationEnum operation, int count) {
        IOAMessage IOAMessage2 = new IOAMessage();
        IOAMessage2.setMsg_Header(this.ioaMessageHeader("1.0", operation));
        IOAMessage2.setTable_Req_Header(this.ioaTableHeader(IOATableEnum.GLOBAL___TABLE, IOAOpcodeEnum.GET___INTERFACE, count));
        IOATableData tableData = new IOATableData();
        GlobalGetReq globalGetReq = new GlobalGetReq();
        InterfaceIndex index = new InterfaceIndex();
        if (ifIndex != null) {
            index.setIf_Index(ifIndex);
        }
        globalGetReq.setInterface_Index(index);
        tableData.setGlobal_Get_Req(globalGetReq);
        IOAMessage2.setTable_Data(tableData);
        return this.buildIOAMessage(IOAMessage2);
    }

    public String prepareEnableSSLSetReq(String clusterName, IOAOpcodeEnum opcode, boolean value) {
        IOAMessage IOAMessage2 = new IOAMessage();
        IOAMessage2.setMsg_Header(this.ioaMessageHeader("1.0", OperationEnum.BASE___SVC___OP___SET));
        IOAMessage2.setTable_Req_Header(this.ioaTableHeader(IOATableEnum.CLUSTER___TABLE, opcode));
        IOATableData tableData = new IOATableData();
        ClusterSetReq clusterSetReq = new ClusterSetReq();
        ClusterObject object = new ClusterObject();
        ClusterIndex index = new ClusterIndex();
        ClusterData data = new ClusterData();
        index.setCluster_Name(clusterName);
        if (opcode == IOAOpcodeEnum.ENABLE___TRANSPORT___SECURITY) {
            data.setIntra_Cluster_Transport(value);
        }
        object.setIndex(index);
        object.setData(data);
        clusterSetReq.setCluster(object);
        tableData.setCluster_Set_Req(clusterSetReq);
        IOAMessage2.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + IOAMessage2.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name()));
        return this.buildIOAMessage(IOAMessage2);
    }
}

