/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.ioa.message;

import com.cisco.dcbu.sm.common.model.ioa.EndDevice;
import com.cisco.dcbu.sm.common.model.ioa.Flow;
import com.cisco.dcbu.sm.server.ioa.common.Limits;
import com.cisco.dcbu.sm.server.ioa.message.IOAMessageBase;
import com.cisco.dcbu.sm.server.ioa.xml.IOAFlowData;
import com.cisco.dcbu.sm.server.ioa.xml.IOAFlowGetReq;
import com.cisco.dcbu.sm.server.ioa.xml.IOAFlowObject;
import com.cisco.dcbu.sm.server.ioa.xml.IOAFlowSetReq;
import com.cisco.dcbu.sm.server.ioa.xml.IOAMessage;
import com.cisco.dcbu.sm.server.ioa.xml.IOAOpcodeEnum;
import com.cisco.dcbu.sm.server.ioa.xml.IOATableData;
import com.cisco.dcbu.sm.server.ioa.xml.IOATableEnum;
import com.cisco.dcbu.sm.server.ioa.xml.ITNexusIndex;
import com.cisco.dcbu.sm.server.ioa.xml.NportData;
import com.cisco.dcbu.sm.server.ioa.xml.NportIndex;
import com.cisco.dcbu.sm.server.ioa.xml.NportObject;
import com.cisco.dcbu.sm.server.ioa.xml.OperationEnum;
import com.cisco.dcbu.sm.server.ioa.xml.Path;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class FlowMessage
extends IOAMessageBase {
    public String prepareClusterFlowGetReq(String clusterName, Path path, String flowGroupName, OperationEnum operation, int count) {
        IOAMessage ioaMessage = new IOAMessage();
        ioaMessage.setMsg_Header(this.ioaMessageHeader("1.0", operation));
        if (operation.equals((Object)OperationEnum.BASE___SVC___OP___GET)) {
            ioaMessage.setTable_Req_Header(this.ioaTableHeader(IOATableEnum.FLOW___TABLE, IOAOpcodeEnum.GET___FLOWS));
        } else if (operation.equals((Object)OperationEnum.BASE___SVC___OP___GET___NEXT)) {
            ioaMessage.setTable_Req_Header(this.ioaTableHeader(IOATableEnum.FLOW___TABLE, IOAOpcodeEnum.GET___FLOWS, count));
        }
        IOATableData tableData = new IOATableData();
        IOAFlowGetReq flowGetReq = new IOAFlowGetReq();
        IOAFlowObject f = new IOAFlowObject();
        ITNexusIndex index = new ITNexusIndex();
        index.setCluster_Name(clusterName);
        if (path == null) {
            path = new Path();
            path.setFabric("");
            path.setInitiator("");
            path.setTarget("");
        }
        index.setI_T_Nexus_Path(path);
        f.setIndex(index);
        IOAFlowData data = new IOAFlowData();
        if (flowGroupName == null) {
            flowGroupName = "";
        }
        data.setFlowGroup(flowGroupName);
        f.setData(data);
        flowGetReq.setFlow(f);
        tableData.setFlow_Get_Req(flowGetReq);
        ioaMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + ioaMessage.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name()));
        return this.buildIOAMessage(ioaMessage);
    }

    public String prepareClusterFlowSetReq(String clusterName, Flow flow, IOAOpcodeEnum opcode) {
        ArrayList<Flow> flowList = new ArrayList<Flow>();
        flowList.add(flow);
        return this.prepareClusterFlowSetReq(clusterName, flowList, opcode);
    }

    public String prepareClusterFlowSetReq(String clusterName, List<Flow> flowList, IOAOpcodeEnum opcode) {
        IOAMessage ioaMessage = new IOAMessage();
        ioaMessage.setMsg_Header(this.ioaMessageHeader("1.0", OperationEnum.BASE___SVC___OP___SET));
        ioaMessage.setTable_Req_Header(this.ioaTableHeader(IOATableEnum.FLOW___TABLE, opcode));
        IOATableData tableData = new IOATableData();
        IOAFlowSetReq flowSetReq = new IOAFlowSetReq();
        tableData.setFlow_Set_Req(flowSetReq);
        List flows = flowSetReq.getFlows();
        int count = Limits.MAX_CLUSTER_FLOWS_IN_REQUEST;
        if (count > flowList.size()) {
            count = flowList.size();
        }
        for (int i = 0; i < count; ++i) {
            Flow flow = flowList.get(i);
            IOAFlowObject object = new IOAFlowObject();
            ITNexusIndex index = new ITNexusIndex();
            index.setCluster_Name(clusterName);
            Path path = new Path();
            path.setFabric(null);
            path.setInitiator(flow.getInitiator().getWwnBrief());
            path.setTarget(flow.getTarget().getWwnBrief());
            index.setI_T_Nexus_Path(path);
            object.setIndex(index);
            IOAFlowData data = new IOAFlowData();
            data.setCompression(flow.isUseCompression());
            data.setTA(flow.isUseTA());
            data.setWA(flow.isUseWA());
            data.setFlowGroup(flow.getFlowGroupName());
            object.setData(data);
            flows.add(object);
        }
        ioaMessage.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + ioaMessage.getTable_Req_Header().getOpcode() + " cluster: " + clusterName + " flows: " + count));
        return this.buildIOAMessage(ioaMessage);
    }

    public String prepareDeleteFlowSetReq(String clusterName, Flow flow) {
        IOAMessage IOAMessage2 = new IOAMessage();
        IOAMessage2.setMsg_Header(this.ioaMessageHeader("1.0", OperationEnum.BASE___SVC___OP___SET));
        IOAMessage2.setTable_Req_Header(this.ioaTableHeader(IOATableEnum.FLOW___TABLE, IOAOpcodeEnum.DELETE___FLOW));
        IOATableData tableData = new IOATableData();
        IOAFlowSetReq flowSetReq = new IOAFlowSetReq();
        IOAFlowObject object = new IOAFlowObject();
        ITNexusIndex index = new ITNexusIndex();
        index.setCluster_Name(clusterName);
        Path path = new Path();
        path.setFabric(null);
        path.setInitiator(flow.getInitiator().getWwnBrief());
        path.setTarget(flow.getTarget().getWwnBrief());
        index.setI_T_Nexus_Path(path);
        IOAFlowData data = new IOAFlowData();
        data.setFlowGroup(flow.getFlowGroupName());
        object.setIndex(index);
        object.setData(data);
        flowSetReq.getFlows().add(object);
        tableData.setFlow_Set_Req(flowSetReq);
        IOAMessage2.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + IOAMessage2.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name()));
        return this.buildIOAMessage(IOAMessage2);
    }

    public String prepareNportSetReq(String clusterName, EndDevice nport) {
        IOAMessage IOAMessage2 = new IOAMessage();
        IOAMessage2.setMsg_Header(this.ioaMessageHeader("1.0", OperationEnum.BASE___SVC___OP___SET));
        IOAMessage2.setTable_Req_Header(this.ioaTableHeader(IOATableEnum.FLOW___TABLE, IOAOpcodeEnum.UPDATE___NPORT___SITE));
        IOATableData tableData = new IOATableData();
        IOAFlowSetReq setReq = new IOAFlowSetReq();
        NportObject object = new NportObject();
        NportIndex index = new NportIndex();
        index.setCluster_Name(clusterName);
        String wwn = nport.getWwnBrief();
        index.setPwwn(wwn);
        object.setIndex(index);
        NportData data = new NportData();
        data.setSite(nport.getSiteName());
        data.setVSAN(new Integer(nport.getVsan()._id));
        object.setData(data);
        setReq.setNport(object);
        tableData.setFlow_Set_Req(setReq);
        IOAMessage2.setTable_Data(tableData);
        _Logger.info((Object)("Sending " + IOAMessage2.getTable_Req_Header().getOpcode() + " cluster: " + index.getCluster_Name()));
        return this.buildIOAMessage(IOAMessage2);
    }

    public IOAMessage parseFlowResponse(InputStream msg) {
        return this.parseIOAMessage(msg);
    }
}

