/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.licmgr;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HostIdGenerator {
    static Logger _Logger = LogManager.getLogger((String)"fms.HostIdGenerator");
    private static final Map<String, OsHandler> OS_HDLRS_MAP = new HashMap<String, OsHandler>();
    private static List<String> knownInvMacs;
    private static HostIdGenerator _instance;
    private List<String> hostMacs;
    private static boolean isDbHostLocal;
    private static String databaseHostId;
    private static Pattern WIN_MAC_ADDR;
    private static Pattern WIN_IP_ADDR;
    private static Pattern VALID_HOSTID;
    private static Pattern WIN_PING;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HostIdGenerator getInstance() {
        if (_instance != null) {
            return _instance;
        }
        Class<HostIdGenerator> clazz = HostIdGenerator.class;
        synchronized (HostIdGenerator.class) {
            if (_instance == null) {
                try {
                    databaseHostId = HostIdGenerator.getDatabaseHostName();
                    isDbHostLocal = databaseHostId != null ? HostIdGenerator.isHostLocal(databaseHostId) : true;
                    HostIdGenerator.logMsg("Database Host " + databaseHostId + (isDbHostLocal ? " is Local " : " is Remote ") + " Host");
                }
                catch (Exception e) {
                    _Logger.error((Object)"Unable to get DataBase HostID - won't be able to verify instance ID for legacy LAN Licenses");
                }
                _instance = new HostIdGenerator();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    private static String getDatabaseHostName() {
        String dburl = System.getProperties().getProperty("db.url");
        boolean isPostgres = dburl.toLowerCase().contains("postgres");
        String hostName = null;
        String cmpChar = "//";
        if (!isPostgres) {
            cmpChar = "@";
        }
        StringTokenizer st = new StringTokenizer(dburl, ":");
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken();
            if (!nextToken.startsWith(cmpChar)) continue;
            hostName = nextToken.substring(cmpChar.length());
            if (!hostName.contains("host=")) break;
            hostName = null;
            break;
        }
        try {
            if (hostName != null) {
                String temp;
                hostName = temp = InetAddress.getByName(hostName).getHostAddress();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return hostName;
    }

    private static Boolean isHostLocal(String hostName) {
        Enumeration<NetworkInterface> en;
        try {
            en = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            return false;
        }
        if (en == null) {
            return false;
        }
        try {
            String ht;
            hostName = ht = InetAddress.getByName(hostName).getHostAddress();
        }
        catch (Exception e) {
            // empty catch block
        }
        while (en.hasMoreElements()) {
            NetworkInterface ni = en.nextElement();
            Enumeration<InetAddress> addrs = ni.getInetAddresses();
            while (addrs.hasMoreElements()) {
                InetAddress addr = addrs.nextElement();
                if (addr.isMulticastAddress() || addr.isLinkLocalAddress() || addr instanceof Inet6Address || !addr.getHostAddress().trim().equals(hostName.trim())) continue;
                return true;
            }
        }
        return false;
    }

    private HostIdGenerator() {
        WindowsOsHandler winHdlr = new WindowsOsHandler();
        OS_HDLRS_MAP.put("Windows", winHdlr);
        LinuxOsHandler linHdlr = new LinuxOsHandler();
        OS_HDLRS_MAP.put("Linux", linHdlr);
        SolarisOsHandler solHdlr = new SolarisOsHandler();
        OS_HDLRS_MAP.put("Solaris", solHdlr);
        MACOsHandler macHdlr = new MACOsHandler();
        OS_HDLRS_MAP.put("Mac", macHdlr);
        knownInvMacs = new ArrayList<String>();
        knownInvMacs.add("02004C4F4F50");
        knownInvMacs.add("000000000000");
        try {
            this.hostMacs = this.getMacs();
        }
        catch (IOException e) {
            _Logger.error((Object)"HostIdGenerator: Error getting MAC address for license validation : ", (Throwable)e);
            this.hostMacs = null;
        }
    }

    private boolean validHostId(String host) {
        if (!VALID_HOSTID.matcher(host).matches()) {
            return false;
        }
        return !knownInvMacs.contains(host);
    }

    private List<String> getMacs() throws IOException {
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            os = "Windows";
        } else if (os.startsWith("Solaris") || os.startsWith("SunOS")) {
            os = "Solaris";
        } else if (os.toLowerCase().contains("mac")) {
            os = "Mac";
        }
        OsHandler hdlr = OS_HDLRS_MAP.get(os);
        ArrayList<String> allMacs = new ArrayList<String>();
        allMacs.addAll(hdlr.getLocalMacs());
        if (!isDbHostLocal) {
            try {
                allMacs.add(hdlr.getDbAddresses(databaseHostId));
            }
            catch (Exception e) {
                _Logger.error((Object)"Unable to get host Id from remote DB for license verification.  If DB MAC Address is being used for the license Host ID, license validation will fail.", (Throwable)e);
            }
        }
        return allMacs;
    }

    private String removeDuplicateWhitespace(String inputStr) {
        String patternStr = "\\s+";
        String replaceStr = " ";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(inputStr);
        return matcher.replaceAll(replaceStr);
    }

    private static void logMsg(String msg) {
        if (_Logger.isDebugEnabled()) {
            _Logger.debug((Object)msg);
        }
    }

    public void retryMacQuery() throws Exception {
        try {
            this.hostMacs = this.getMacs();
            if (this.hostMacs == null || this.hostMacs.size() == 0) {
                throw new Exception("Unable to retrieve machine MAC address, please make sure your security agent isn't blocking the system call.");
            }
        }
        catch (IOException e) {
            _Logger.error((Object)"HostIdGenerator: Error getting MAC address on for license validation : ", (Throwable)e);
            this.hostMacs = null;
        }
    }

    public List<String> getHostMacs() {
        return this.hostMacs;
    }

    public static void main(String[] args) throws Exception {
        HostIdGenerator getInstance = HostIdGenerator.getInstance();
        System.out.println(getInstance.getHostMacs());
    }

    static {
        isDbHostLocal = true;
        WIN_MAC_ADDR = Pattern.compile("(([a-fA-F0-9]{2}\\-){2})([a-fA-F0-9]{2})");
        WIN_IP_ADDR = Pattern.compile("((([1-9]?[0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([1-9]?[0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]))");
        VALID_HOSTID = Pattern.compile("[A-F0-9]{12}");
        WIN_PING = Pattern.compile("\\([0-9]*\\%");
    }

    public class SolarisOsHandler
    extends OsHandler {
        @Override
        List<String> getLocalMacs() throws IOException {
            String cmd = "/sbin/ifconfig -a";
            String response = this.getCmdResponse(cmd);
            HostIdGenerator.logMsg("getLocalMacs: Response: " + response);
            ArrayList<String> macList = new ArrayList<String>();
            String[] lines = response.split("\\n");
            ArrayList<String> resp = new ArrayList<String>();
            for (String line : lines) {
                if ((line = line.trim()).length() <= 0) continue;
                resp.add(new String(line));
            }
            String macAddress = null;
            for (String line : resp) {
                line = line.trim();
                HostIdGenerator.logMsg("getLocalMacs:" + line);
                if (!line.contains("ether")) continue;
                macAddress = line.substring(line.indexOf("ether") + "ether".length() + 1).trim().toUpperCase();
                HostIdGenerator.logMsg(macAddress);
                macAddress = macAddress.replaceAll(":", "");
                while (macAddress.length() < 12) {
                    macAddress = "0" + macAddress;
                }
                if (HostIdGenerator.this.validHostId(macAddress)) {
                    if (macList.contains(macAddress)) continue;
                    HostIdGenerator.logMsg("getLocalMacs: Added MAC : " + macAddress);
                    macList.add(macAddress);
                    continue;
                }
                HostIdGenerator.logMsg("getLocalMacs: Found Mac is not Valid  (Ignored) " + macAddress);
            }
            return macList;
        }

        @Override
        String getDbAddresses(String dbHostIpAddr) throws IOException {
            return null;
        }
    }

    public class MACOsHandler
    extends OsHandler {
        @Override
        List<String> getLocalMacs() throws IOException {
            String cmd = "ifconfig";
            String response = this.getCmdResponse(cmd);
            HostIdGenerator.logMsg("getLocalMacs: Response: " + response);
            ArrayList<String> macList = new ArrayList<String>();
            String[] lines = response.split("\\n");
            ArrayList<String> resp = new ArrayList<String>();
            for (String line : lines) {
                if ((line = line.trim()).length() <= 0) continue;
                resp.add(new String(line));
            }
            String macAddress = null;
            for (String line : resp) {
                line = line.trim();
                HostIdGenerator.logMsg("getLocalMacs:" + line);
                if (!line.contains("ether")) continue;
                macAddress = line.substring(line.indexOf("ether") + "ether".length() + 1).trim().toUpperCase();
                HostIdGenerator.logMsg(macAddress);
                macAddress = macAddress.replaceAll(":", "");
                if (HostIdGenerator.this.validHostId(macAddress)) {
                    if (macList.contains(macAddress)) continue;
                    HostIdGenerator.logMsg("getLocalMacs: Added MAC : " + macAddress);
                    macList.add(macAddress);
                    continue;
                }
                HostIdGenerator.logMsg("getLocalMacs: Found Mac is not Valid  (Ignored) " + macAddress);
            }
            return macList;
        }

        @Override
        String getDbAddresses(String dbHostIpAddr) throws IOException {
            return null;
        }
    }

    public class LinuxOsHandler
    extends OsHandler {
        @Override
        List<String> getLocalMacs() throws IOException {
            String cmd = "/sbin/ifconfig -a";
            String response = this.getCmdResponse(cmd);
            HostIdGenerator.logMsg("getLocalMacs: Response: " + response);
            ArrayList<String> macList = new ArrayList<String>();
            String[] lines = response.split("\\n");
            ArrayList<String> resp = new ArrayList<String>();
            for (String line : lines) {
                if ((line = line.trim()).length() <= 0) continue;
                resp.add(new String(line));
            }
            String macAddress = null;
            for (String line : resp) {
                line = line.trim();
                HostIdGenerator.logMsg("getLocalMacs:" + line);
                if (!line.contains("Link encap:Ethernet")) continue;
                macAddress = line.substring(line.indexOf("HWaddr") + "HWaddr".length() + 1).trim().toUpperCase();
                HostIdGenerator.logMsg(macAddress);
                macAddress = macAddress.replaceAll(":", "");
                if (HostIdGenerator.this.validHostId(macAddress)) {
                    if (macList.contains(macAddress)) continue;
                    HostIdGenerator.logMsg("getLocalMacs: Added MAC : " + macAddress);
                    macList.add(macAddress);
                    continue;
                }
                HostIdGenerator.logMsg("getLocalMacs: Found Mac is not Valid  (Ignored) " + macAddress);
            }
            return macList;
        }

        @Override
        String getDbAddresses(String dbHostIpAddr) throws IOException {
            String[] lines;
            HostIdGenerator.logMsg("Checking for DCNM Instance using IP Address " + dbHostIpAddr);
            for (String li : lines = this.getCmdResponse("/bin/ping -c 3 " + dbHostIpAddr).split("\\n")) {
                if (!li.contains("packets")) continue;
                String sbli = li.split(",")[2].trim();
                if (Integer.valueOf(sbli.substring(0, sbli.indexOf("%"))) != 100) break;
                throw new IOException("Could not Ping the Host " + dbHostIpAddr);
            }
            lines = this.getCmdResponse("/sbin/arp -n").split("\\n");
            String macAddress = null;
            boolean found = false;
            for (String line : lines) {
                if ((line = line.trim()).contains("Address")) {
                    found = true;
                    continue;
                }
                if (!found || !HostIdGenerator.this.removeDuplicateWhitespace(line).split(" ")[0].trim().equals(dbHostIpAddr)) continue;
                macAddress = HostIdGenerator.this.removeDuplicateWhitespace(line).split(" ")[2].trim();
                break;
            }
            if (macAddress == null) {
                throw new IOException("\nCould not find MAC address for this Remote Linux Host " + dbHostIpAddr + "\nPlease make sure All Clustered hosts are in same subnet");
            }
            if (HostIdGenerator.this.validHostId(macAddress = macAddress.replaceAll(":", "").toUpperCase())) {
                return macAddress;
            }
            HostIdGenerator.logMsg("getLocalMacs:Found Mac is not Valid (Ignored) " + macAddress);
            return null;
        }
    }

    public class WindowsOsHandler
    extends OsHandler {
        @Override
        List<String> getLocalMacs() throws IOException {
            String cmd = "ipconfig /all";
            String response = this.getCmdResponse(cmd);
            HostIdGenerator.logMsg("getLocalMacs:Response: " + response);
            String[] lines = response.split("\\n");
            ArrayList<String> resp = new ArrayList<String>();
            for (String line : lines) {
                if ((line = line.trim()).length() <= 0) continue;
                resp.add(new String(line));
            }
            ArrayList<String> macList = new ArrayList<String>();
            String macAddress = null;
            for (String line : resp) {
                if (!(line = line.trim()).startsWith("Physical Address")) continue;
                macAddress = new String(line.substring(line.indexOf(58) + 1).trim()).toUpperCase();
                if (HostIdGenerator.this.validHostId(macAddress = macAddress.replaceAll("-", ""))) {
                    if (macList.contains(macAddress)) continue;
                    HostIdGenerator.logMsg("getLocalMacs:Added MAC : " + macAddress);
                    macList.add(macAddress);
                    continue;
                }
                HostIdGenerator.logMsg("getLocalMacs:Found Mac is not Valid (Ignored) " + macAddress);
            }
            return macList;
        }

        @Override
        String getDbAddresses(String dbHostIpAddr) throws IOException {
            String[] lines;
            HostIdGenerator.logMsg("Checking for DCNM Instance using IP Address " + dbHostIpAddr);
            for (String li : lines = this.getCmdResponse("ping " + dbHostIpAddr).split("\\n")) {
                if (!WIN_PING.matcher(li).find()) continue;
                if (Integer.valueOf(li.substring(li.indexOf("(") + 1, li.indexOf("%"))) != 100) break;
                throw new IOException("Could not Ping the Host " + dbHostIpAddr);
            }
            lines = this.getCmdResponse("arp -A").split("\\n");
            String macAddress = null;
            for (String line : lines) {
                if (!WIN_IP_ADDR.matcher(line).find() || !WIN_MAC_ADDR.matcher(line).find() || !HostIdGenerator.this.removeDuplicateWhitespace(line.trim()).split(" ")[0].trim().equals(dbHostIpAddr)) continue;
                macAddress = HostIdGenerator.this.removeDuplicateWhitespace(line.trim()).split(" ")[1].trim();
                break;
            }
            if (macAddress == null) {
                throw new IOException("\nCould not find MAC address for this Remote Windows Host " + dbHostIpAddr + "\nPlease make sure All Clustered hosts are in same subnet");
            }
            if (HostIdGenerator.this.validHostId(macAddress = macAddress.replaceAll("-", "").toUpperCase())) {
                return macAddress;
            }
            HostIdGenerator.logMsg("getLocalMacs:Found Mac is not Valid (Ignored) " + macAddress);
            return null;
        }
    }

    abstract class OsHandler {
        OsHandler() {
        }

        abstract List<String> getLocalMacs() throws IOException;

        abstract String getDbAddresses(String var1) throws IOException;

        protected String getCmdResponse(String cmd) throws IOException {
            final Process cmdProcess = Runtime.getRuntime().exec(cmd);
            final StringBuffer response = new StringBuffer();
            Thread readThread = new Thread(){

                @Override
                public void run() {
                    BufferedReader rdr = new BufferedReader(new InputStreamReader(cmdProcess.getInputStream()));
                    String line = null;
                    try {
                        while ((line = rdr.readLine()) != null) {
                            response.append(line);
                            response.append("\n");
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            readThread.start();
            try {
                readThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return response.toString();
        }
    }
}

