/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.licmgr;

import com.cisco.dcbu.sm.common.model.EthSwitchBase;
import com.cisco.dcbu.sm.common.model.LicenseInfo;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.model.SwitchLicenseDetails;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.inventory.InventoryManager;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.LanImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class LicenseManager {
    public static final String[] DMM_LICENSE = new String[]{"DMM_FOR_SSM_PKG", "DMM_184_PKG", "DMM_9222i_PKG", "DMM_SSN16_PKG"};
    private static LicenseManager _Instance;
    static Logger _Logger;

    private LicenseManager() {
    }

    public static LicenseManager getInstance() {
        if (_Instance == null) {
            _Instance = new LicenseManager();
        }
        return _Instance;
    }

    public boolean isFmLicensed(FabricPK key) {
        return this.isFmLicensed(SanManager.getInstance().findFabric(key));
    }

    public boolean isFmLicensed(FabricImpl fabric) {
        if (fabric == null) {
            return false;
        }
        SwitchImpl[] sws = fabric.getSwitches();
        for (int i = 0; i < sws.length; ++i) {
            SwitchLicenseDetails swLicDetails = sws[i].getLicenseDetails();
            if (swLicDetails == null || !swLicDetails.isLicensed()) continue;
            return true;
        }
        return false;
    }

    public int getFmLicensedState(FabricPK key) {
        return this.getFmLicensedState(SanManager.getInstance().findFabric(key));
    }

    public int getFmLicensedState(FabricImpl fabric) {
        if (fabric == null) {
            return 0;
        }
        boolean evalLicenseFound = false;
        int evalLicenseType = -1;
        SwitchImpl[] sws = fabric.getSwitches();
        for (int i = 0; i < sws.length; ++i) {
            SwitchLicenseDetails swLicDetails = sws[i].getLicenseDetails();
            if (swLicDetails == null || !swLicDetails.isLicensed()) continue;
            if (swLicDetails.isEval()) {
                evalLicenseFound = true;
                evalLicenseType = swLicDetails.getLicenseId();
                continue;
            }
            return swLicDetails.getLicenseId();
        }
        if (evalLicenseFound) {
            return evalLicenseType;
        }
        return 0;
    }

    public Map<FabricPK, List<SwitchBase>> getAllUnLicensedSwitches(List<FabricPK> keys) throws IllegalArgumentException {
        HashMap<FabricPK, List<SwitchBase>> results = new HashMap<FabricPK, List<SwitchBase>>();
        for (FabricPK nextPK : keys) {
            List<SwitchBase> switches = this.getAllUnlicensedSwitches(SanManager.getInstance().findFabric(nextPK));
            results.put(nextPK, switches);
        }
        return results;
    }

    public List<SwitchBase> getAllUnLicensedSwitches(FabricPK key) throws IllegalArgumentException {
        return this.getAllUnlicensedSwitches(SanManager.getInstance().findFabric(key));
    }

    public List<EthSwitchBase> getAllUnLicensedLANSwitches() throws Exception {
        ArrayList<EthSwitchBase> unlicensedSwitches = new ArrayList<EthSwitchBase>();
        LanImpl lan = DCManager.getInstance().getLan();
        if (lan == null) {
            throw new Exception("Unable to find any lan discovered");
        }
        List<EthSwitchImpl> sws = lan.getEthSwitches();
        for (int i = 0; i < sws.size(); ++i) {
            SwitchLicenseDetails swLicDetails = sws.get(i).getLicenseDetails();
            if (swLicDetails != null && swLicDetails.isLicensed()) continue;
            unlicensedSwitches.add((EthSwitchBase)sws.get(i).getBaseObject());
        }
        return unlicensedSwitches;
    }

    private List<SwitchBase> getAllUnlicensedSwitches(FabricImpl fabric) throws IllegalArgumentException {
        ArrayList<SwitchBase> unlicensedSwitches = new ArrayList<SwitchBase>();
        if (fabric == null) {
            throw new IllegalArgumentException("Fabric value can't be null");
        }
        SwitchImpl[] sws = fabric.getSwitches();
        for (int i = 0; i < sws.length; ++i) {
            SwitchLicenseDetails swLicDetails = sws[i].getLicenseDetails();
            if (swLicDetails != null && swLicDetails.isLicensed()) continue;
            unlicensedSwitches.add((SwitchBase)sws[i].getBaseObject());
        }
        return unlicensedSwitches;
    }

    public int isDmmLicensed(FabricPK key) {
        return this.isDmmLicensed(SanManager.getInstance().findFabric(key));
    }

    public int isDmmLicensed(FabricImpl fabric) {
        return this.getLicenseState(fabric, DMM_LICENSE);
    }

    private int getLicenseState(FabricImpl fabric, String license) {
        return this.getLicenseState(fabric, new String[]{license});
    }

    private int getLicenseState(FabricImpl fabric, String[] licenses) {
        if (fabric == null) {
            return 0;
        }
        boolean evalLicenseFound = false;
        int evalLicenseType = -1;
        SwitchImpl[] sws = fabric.getSwitches();
        InventoryManager im = InventoryManager.getInstance();
        for (int i = 0; i < sws.length; ++i) {
            List<LicenseInfo> licInfo;
            WwnKey key = sws[i].getSwitchPK();
            if (key == null || (licInfo = this.findLicense(im, key, licenses)) == null || licInfo.size() == 0) continue;
            for (LicenseInfo nextLic : licInfo) {
                if (nextLic.isPermanent()) {
                    return 3;
                }
                if (!nextLic.isCheckedout() || nextLic.timeLeft() <= 0L) continue;
                evalLicenseFound = true;
            }
        }
        if (evalLicenseFound) {
            return evalLicenseType;
        }
        return 0;
    }

    private List<LicenseInfo> findLicense(InventoryManager imInst, WwnKey key, String[] licenses) {
        ArrayList<LicenseInfo> licInfo = new ArrayList<LicenseInfo>();
        if (imInst == null) {
            imInst = InventoryManager.getInstance();
        }
        for (String licStr : licenses) {
            LicenseInfo nextlicInfo = imInst.findLicense(key, licStr);
            if (nextlicInfo == null) continue;
            licInfo.add(nextlicInfo);
        }
        return licInfo;
    }

    static {
        _Logger = LogManager.getLogger((String)"fms.license");
    }
}

