/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.server.model.AbstractDBObjectImpl;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.LanImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import org.apache.log4j.Level;

public abstract class AbstractModelObjectImpl
extends AbstractDBObjectImpl
implements Comparator,
Comparable {
    protected AbstractModelObjectImpl() {
    }

    public abstract FabricImpl getFabric();

    public LanImpl getLan() {
        return DCManager.getInstance().findLan(null);
    }

    public abstract BaseModelObject getBaseObject();

    public PKIf getPK() {
        return this.getBaseObject().getPK();
    }

    public long getLastScanTime() {
        return this.getBaseObject().getLastScanTime();
    }

    public void syncLastScanTime() {
        LanImpl lan;
        if (this.getBaseObject().isFcObject()) {
            if (this.getFabric() == null) {
                return;
            }
            this.getBaseObject().setLastScanTime(this.getFabric().getLastScanTime());
        } else if (this.getBaseObject().isEthObject() && (lan = this.getLan()) != null) {
            this.getBaseObject().setLastScanTime(lan.getLastScanTime());
        }
    }

    public boolean isPresent() {
        return this.getBaseObject().isPresent();
    }

    public abstract boolean setPresent(boolean var1);

    public boolean hasDisappeared(long lastScanTime) {
        return this.getBaseObject().hasDisappeared(lastScanTime);
    }

    public boolean hasReappeared(long lastScanTime) {
        return this.getBaseObject().hasReappeared(lastScanTime);
    }

    public String getStatus() {
        if (!this.getBaseObject().isPresent()) {
            return "Last seen " + SnmpTimeticks.getDateFormat().format(new Date(this.getBaseObject().getLastScanTime()));
        }
        return "ok";
    }

    public String getDetails() {
        return this.toString();
    }

    public boolean isMinorAlarm() {
        return false;
    }

    @Override
    public boolean equals(Object x) {
        if (x == this) {
            return true;
        }
        if (x == null || !(x instanceof AbstractModelObjectImpl)) {
            return false;
        }
        return ((AbstractModelObjectImpl)x).getBaseObject().equals(this.getBaseObject());
    }

    public int hashCode() {
        return this.getBaseObject().hashCode();
    }

    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        PKIf key1 = ((AbstractModelObjectImpl)o1).getPK();
        PKIf key2 = ((AbstractModelObjectImpl)o2).getPK();
        return key1.compare(key1, key2);
    }

    public int compareTo(Object o) {
        return this.compare(this, o);
    }

    public String toString() {
        return this.getBaseObject().toString();
    }

    protected void propertyChanged(short propId, Serializable oldValue, Serializable newValue) {
        if (this.getBaseObject().isFcObject()) {
            FabricImpl f = this.getFabric();
            if (f != null) {
                f.modelObjectChanged(this.getPK(), propId, oldValue, newValue);
            } else if (SanManager._Logger.isDebugEnabled()) {
                SanManager._Logger.debug((Object)(this + " cannot find a fabric to notify property change:" + propId));
            }
        } else if (this.getBaseObject().isEthObject()) {
            LanImpl lan = this.getLan();
            if (lan != null) {
                lan.modelObjectChanged(this.getPK(), propId, oldValue, newValue);
            } else if (SanManager._Logger.isDebugEnabled()) {
                DCManager._Tracer.log(Level.DEBUG, this + " cannot find a lan to notify property change:" + propId);
            }
        }
    }
}

