/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.lib.serviceconf.AbstractService;
import com.cisco.dcbu.sm.common.event.ChangedModelObject;
import com.cisco.dcbu.sm.common.event.MovedModelObject;
import com.cisco.dcbu.sm.common.model.GroupBase;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.GroupPK;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.server.db.GroupPersistent;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.CdpSeedImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.LanImpl;
import com.cisco.dcbu.sm.server.model.ModelEventListenerIf;
import com.cisco.dcbu.sm.server.model.SanManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class GroupManagerService
extends AbstractService
implements ModelEventListenerIf {
    static Logger _Logger = LogManager.getLogger((String)"fms.model");
    private ConcurrentHashMap _groupsByPK = new ConcurrentHashMap();
    private ConcurrentHashMap _groupPKsByFabricPK = new ConcurrentHashMap();

    public GroupManagerService() {
        super("Group Manager Service");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addGroup(GroupBase group) {
        if (group == null) {
            return;
        }
        GroupPK groupPK = group.getGroupPK();
        ConcurrentHashMap concurrentHashMap = this._groupsByPK;
        synchronized (concurrentHashMap) {
            if (!this._groupsByPK.containsKey(groupPK)) {
                this._groupsByPK.put(groupPK, group);
                FabricPK fabricPK = groupPK.getFabricPK();
                ConcurrentHashMap concurrentHashMap2 = this._groupPKsByFabricPK;
                synchronized (concurrentHashMap2) {
                    ArrayList<GroupPK> al = (ArrayList<GroupPK>)this._groupPKsByFabricPK.get(fabricPK);
                    if (al == null) {
                        al = new ArrayList<GroupPK>();
                        this._groupPKsByFabricPK.put(fabricPK, al);
                    }
                    if (!al.contains(groupPK)) {
                        al.add(groupPK);
                    }
                }
            }
        }
    }

    public GroupBase addGroup(GroupPK groupPK, short type, PKIf[] members) throws Exception {
        if (groupPK == null) {
            return null;
        }
        if (this._groupsByPK.containsKey(groupPK)) {
            throw new Exception("Group with the same name already exists");
        }
        FabricPK fabricPK = groupPK.getFabricPK();
        GroupPK[] oldGroupPKs = this.getGroupPKs(fabricPK);
        GroupBase group = new GroupBase(groupPK, type);
        group.setMembers(members);
        this.addGroup(group);
        GroupPK[] newGroupPKs = this.getGroupPKs(fabricPK);
        GroupPersistent.getInstance().persist(group);
        FabricImpl fabric = SanManager.getInstance().findFabric(fabricPK);
        if (fabric != null) {
            ChangedModelObject[] mos = new ChangedModelObject[]{new ChangedModelObject(fabricPK, 523, (Serializable)oldGroupPKs, (Serializable)newGroupPKs)};
            SanManager.notifyMembersChanged(fabric, mos);
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupBase updateGroup(GroupPK groupPK, short type, PKIf[] members) throws Exception {
        if (groupPK == null) {
            return null;
        }
        if (this._groupsByPK.contains(groupPK)) {
            throw new Exception("Group does not exist");
        }
        boolean changed = false;
        GroupBase group = null;
        ConcurrentHashMap concurrentHashMap = this._groupsByPK;
        synchronized (concurrentHashMap) {
            group = (GroupBase)this._groupsByPK.get(groupPK);
            if (group != null && !group.getMembers().equals(members)) {
                group.setMembers(members);
                changed = true;
            }
        }
        if (changed) {
            GroupPersistent.getInstance().persist(group);
            FabricPK fabricPK = groupPK.getFabricPK();
            FabricImpl fabric = SanManager.getInstance().findFabric(fabricPK);
            if (fabric != null) {
                GroupPK[] groupPKs = new GroupPK[]{groupPK};
                ChangedModelObject[] mos = new ChangedModelObject[]{new ChangedModelObject(fabricPK, 523, (Serializable)groupPKs, (Serializable)groupPKs)};
                SanManager.notifyMembersChanged(fabric, mos);
            }
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupBase removeGroup(GroupPK groupPK) throws Exception {
        if (groupPK == null) {
            return null;
        }
        GroupBase group = null;
        ConcurrentHashMap concurrentHashMap = this._groupsByPK;
        synchronized (concurrentHashMap) {
            group = (GroupBase)this._groupsByPK.remove(groupPK);
            FabricPK fabricPK = groupPK.getFabricPK();
            ConcurrentHashMap concurrentHashMap2 = this._groupPKsByFabricPK;
            synchronized (concurrentHashMap2) {
                ArrayList al = (ArrayList)this._groupPKsByFabricPK.get(fabricPK);
                if (al != null) {
                    al.remove(groupPK);
                    if (al.size() == 0) {
                        this._groupPKsByFabricPK.remove(fabricPK);
                    }
                }
            }
        }
        if (group != null) {
            GroupPersistent.getInstance().purge(group);
            FabricPK fabricPK = groupPK.getFabricPK();
            FabricImpl fabric = SanManager.getInstance().findFabric(fabricPK);
            if (fabric != null) {
                GroupPK[] groupPKs = new GroupPK[]{groupPK};
                ChangedModelObject[] mos = new ChangedModelObject[]{new ChangedModelObject(fabricPK, 523, (Serializable)groupPKs, (Serializable)groupPKs)};
                SanManager.notifyMembersChanged(fabric, mos);
            }
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupBase getGroup(GroupPK groupPK) {
        if (groupPK == null) {
            return null;
        }
        ConcurrentHashMap concurrentHashMap = this._groupsByPK;
        synchronized (concurrentHashMap) {
            return (GroupBase)this._groupsByPK.get(groupPK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupPK[] getGroupPKs() {
        ConcurrentHashMap concurrentHashMap = this._groupsByPK;
        synchronized (concurrentHashMap) {
            return this._groupsByPK.keySet().toArray(new GroupPK[this._groupsByPK.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupBase[] getGroups() {
        ConcurrentHashMap concurrentHashMap = this._groupsByPK;
        synchronized (concurrentHashMap) {
            return this._groupsByPK.values().toArray(new GroupBase[this._groupsByPK.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupPK[] getGroupPKs(FabricPK fabricPK) {
        if (fabricPK == null) {
            return null;
        }
        ConcurrentHashMap concurrentHashMap = this._groupPKsByFabricPK;
        synchronized (concurrentHashMap) {
            ArrayList al = (ArrayList)this._groupPKsByFabricPK.get(fabricPK);
            if (al == null || al.size() == 0) {
                return null;
            }
            GroupPK[] pks = new GroupPK[al.size()];
            pks = al.toArray(pks);
            return pks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupBase[] getGroups(FabricPK fabricPK) {
        GroupPK[] groupPKs = this.getGroupPKs(fabricPK);
        if (groupPKs == null || groupPKs.length == 0) {
            return null;
        }
        GroupBase[] groups = new GroupBase[groupPKs.length];
        ConcurrentHashMap concurrentHashMap = this._groupsByPK;
        synchronized (concurrentHashMap) {
            for (int i = 0; i < groupPKs.length; ++i) {
                groups[i] = (GroupBase)this._groupsByPK.get(groupPKs[i]);
            }
        }
        return groups;
    }

    @Override
    public void fabricOpened(FabricImpl fabric) {
        try {
            this.loadGroupsFromDB(fabric);
            _Logger.info((Object)("loaded groups for fabric: " + fabric));
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Error loading groups for fabric: " + fabric + ": " + ex.getMessage()));
        }
    }

    @Override
    public void fabricDiscovered(FabricImpl fabric) {
    }

    @Override
    public void fabricRemoved(FabricImpl fabric) {
    }

    @Override
    public void fabricClosed(FabricImpl fabric) {
    }

    @Override
    public void fabricMerged(FabricImpl mergerFabric, FabricPK mergeePK) {
    }

    @Override
    public void fabricSplit(FabricImpl origFabric, FabricImpl newFabric) {
    }

    @Override
    public void fabricRediscovered(FabricImpl fabric) {
    }

    @Override
    public void fabricEmptied(FabricImpl fabric) {
    }

    @Override
    public void membersAdded(FabricImpl fabric, AbstractModelObjectImpl[] mos) {
    }

    @Override
    public void membersRemoved(FabricImpl fabric, PKIf[] pks) {
    }

    @Override
    public void membersChanged(FabricImpl fabric, ChangedModelObject[] mos) {
    }

    @Override
    public void membersMoved(FabricImpl fImpl, MovedModelObject[] mos) {
    }

    @Override
    public void memberPurged(FabricImpl fImpl, PKIf[] pks) {
    }

    @Override
    public void modelObjectCreated(AbstractModelObjectImpl mo) {
    }

    @Override
    public void modelObjectRemoved(AbstractModelObjectImpl mo) {
    }

    @Override
    public void cdpSeedAdded(CdpSeedImpl cdpSeed) {
    }

    @Override
    public void cdpSeedRemoved(CdpSeedImpl cdpSeed) {
    }

    @Override
    public void lanOpened(LanImpl lan) {
    }

    @Override
    public void lanClosed(LanImpl lan) {
    }

    @Override
    public void lanRemoved(CdpSeedImpl cdpSeed, LanImpl lan) {
    }

    @Override
    public void lanDiscovered(LanImpl lan) {
    }

    @Override
    public void lanRediscovered(LanImpl lan) {
    }

    @Override
    public void membersAdded(LanImpl lan, AbstractModelObjectImpl[] mos) {
    }

    @Override
    public void membersRemoved(LanImpl lan, PKIf[] pks) {
    }

    @Override
    public void membersChanged(LanImpl lan, ChangedModelObject[] mos) {
    }

    @Override
    public void membersMoved(LanImpl lan, MovedModelObject[] mos) {
    }

    @Override
    public void memberPurged(LanImpl lan, PKIf[] pks) {
    }

    @Override
    public void dbObjectPurged(long dbid) {
    }

    public void loadGroupsFromDB(FabricImpl fabric) throws Exception {
        ArrayList groups = GroupPersistent.getInstance().reload(fabric);
        if (groups != null && groups.size() > 0) {
            for (int i = 0; i < groups.size(); ++i) {
                this.addGroup((GroupBase)groups.get(i));
            }
        }
    }

    @Override
    public void fabricClosed(FabricPK fpk) {
    }
}

