/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.HostBase;
import com.cisco.dcbu.sm.common.util.TraceLogger;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EnclosureImpl;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.HostManager;
import com.cisco.dcbu.sm.server.model.HostMapImpl;
import com.cisco.dcbu.sm.server.model.LanHostImpl;
import com.cisco.dcbu.sm.server.model.LanImpl;
import com.cisco.dcbu.sm.server.model.PhyNicImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.VHostImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class HostImpl
extends AbstractModelObjectImpl {
    static final TraceLogger _logger = new TraceLogger(Logger.getLogger((String)"fms.model"), false, false, false, false);
    public static final String QuerySQL = "select id, name, full_name, enclosure_id, vhost_id, user_modified, mac, ip, pwwn, multipath, os_info, hbas, vcluster, created_time, last_updated_time from host";
    public static final String QueryIdsSQL = "select id from host";
    public static final String QuerySQLByName = "select id, name, full_name, enclosure_id, vhost_id, user_modified, mac, ip, pwwn, multipath, os_info, hbas, vcluster, created_time, last_updated_time from host where name=?";
    public static final String QuerySQLEsitingRecord = "select id from host where name=?";
    public static final String QuerySQLByFabricId = "select h.id, h.name, h.full_name, m.enclosure_id, m.vhost_id, h.user_modified, h.mac, h.ip, h.pwwn, h.multipath, h.os_info, h.hbas, h.vcluster, h.created_time, h.last_updated_time from host h, host_map m, enclosure e, end_port ep where h.id=m.host_id and m.enclosure_id=e.id and e.enc_type=47 and e.id=ep.enclosure_id and ep.fabric_id=?";
    public static final String QuerySQLById = "select id, name, full_name, enclosure_id, vhost_id, user_modified, mac, ip, pwwn, multipath, os_info, hbas, vcluster, created_time, last_updated_time from host where id=?";
    public static final String QuerySQLByVhostId = "select h.id, h.name, h.full_name, m.enclosure_id, m.vhost_id, h.user_modified, h.mac, h.ip, h.pwwn, h.multipath, h.os_info, h.hbas, h.vcluster, h.created_time, h.last_updated_time from host h, host_map m where m.vhost_id=? AND m.host_id=h.id";
    static final String QuerySQLSanHostIds = "select enc.id from enclosure enc, end_port ep where ep.enclosure_id=enc.id and enc.enc_type=47";
    public static final String QueryLanHostSQL = "select h.id, h.name, h.full_name, m.enclosure_id, m.vhost_id, h.user_modified, h.mac, h.ip, h.pwwn, h.multipath, h.os_info, h.hbas, h.vcluster, h.created_time, h.last_updated_time from host h, host_map m where h.id=m.host_id and m.lanhost_id>0";
    public static final String QuerySanHostSQL = "select h.id, h.name, h.full_name, m.enclosure_id, m.vhost_id, h.user_modified, h.mac, h.ip, h.pwwn, h.multipath, h.os_info, h.hbas, h.vcluster, h.created_time, h.last_updated_time from host h, host_map m where m.enclosure_id>0 AND h.id=m.host_id";
    public static final String QueryVHostHostSQL = "select h.id, h.name, h.full_name, h.enclosure_id, h.vhost_id, h.user_modified, h.mac, h.ip, h.pwwn, h.multipath, h.os_info, h.hbas, h.vcluster, h.created_time, h.last_updated_time from host h where h.vhost_id>0";
    public static final String QueryHostByMacSQL = "select h.id, h.name, h.full_name, m.enclosure_id, m.vhost_id, h.user_modified, h.mac, h.ip, h.pwwn, h.multipath, h.os_info, h.hbas, h.vcluster, h.created_time, h.last_updated_time from host h, host_map m where h.id=m.host_id and ((m.vhost_id in (select id from vhost where upper(mac_address) like ?)) or (m.vhost_id in (select vhost_id from phynic where upper(mac) like ?)) or (m.vhost_id in (select vh.id from vhost vh, vm vm left join vnic vn on upper(mac) like ? where vh.id=vm.vhost_id and vm.id=vn.vm_id)))";
    public static final String QueryHostByLanHostIdSQL = "select h.id, h.name, h.full_name, m.enclosure_id, m.vhost_id, h.user_modified, h.mac, h.ip, h.pwwn, h.multipath, h.os_info, h.hbas, h.vcluster, h.created_time, h.last_updated_time from host h left join host_map m on m.lanhost_id=? where h.id=m.host_id";
    public static final String QueryHostBySanHostIdSQL = "select h.id, h.name, h.full_name, m.enclosure_id, m.vhost_id, h.user_modified, h.mac, h.ip, h.pwwn, h.multipath, h.os_info, h.hbas, h.vcluster, h.created_time, h.last_updated_time from host h left join host_map m on m.enclosure_id=? where h.id=m.host_id";
    public static final String QueryVHostSQL = "select h.id, h.name, h.full_name, m.enclosure_id, m.vhost_id, h.user_modified, h.mac, h.ip, h.pwwn, h.multipath, h.os_info, h.hbas, h.vcluster, h.created_time, h.last_updated_time from host h, host_map m where m.vhost_id>0 AND h.id=m.host_id";
    public static final String QueryEnclosureSQL = "select distinct e.id, e.name, e.vhost_id from enclosure e where e.enc_type=47";
    public static final String QueryEnclosureByFabricIdSQL = "select distinct e.id, e.name, e.vhost_id from enclosure e, end_port ep where e.id=ep.enclosure_id and e.enc_type=47 and ep.fabric_id=?";
    public static final String QueryVhostSQL = "select v.id, v.name, v.full_name from vhost v";
    public static final String QueryHostByVhostIdSQL = "select id, name, full_name, enclosure_id from host where vhost_id=?";
    public static final String QueryAcsNameSQL = "select a.instanceclassid, a.name, n.physicalport_id, n.macaddress from networkinterface n left join abstractcomputersystem a on a.instanceclassid=n.abstractcomputersystem_id where n.abstractcomputersystem_id is not null and n.physicalport_id is not null";
    public static final String QuerySwitchNameAndIfNameSQL = "select distinct es.id, es.sys_name, n.name from ethswitch es, physicalport b left join networkinterface n on b.networkinterface_id=n.instanceclassid where es.serial_number in (select b.serialnumber from physicalport a where a.port_link_id = b.port_link_id and a.hardware_id = ? and b.hardware_id != ?)";
    public static final String QueryPhynicSQL = "select count(*) from phynic p where upper(p.mac)=?";
    public static final String QueryVnicSQL = "select count(*) from vnic v where upper(v.mac)=?";
    public static final String QueryVhostMacSQL = "select count(*) from vhost v where upper(v.mac_address) like ?";
    public static final String QueryFexNameSQL = "select fs.id, fs.sys_name from ethswitch s, ethswitch fs, ethswitch_fex f where s.id=? and f.switch_id=s.id and fs.id=f.fex_id and fs.fex_id=?";
    public static final String DeleteAllSQL = "delete from host";
    public static final String DeleteSQL = "delete from host where id=?";
    public static final String DeleteAllLanHostSQL = "delete from host where enclosure_id=0 and vhost_id=0";
    public static final String DeleteByLanHostIdSQL = "delete from host where id in (select host_id from host_map m where m.lanhost_id=?)";
    public static final String DeleteByIdSQL = "delete from host where id=?";
    public static final String DeleteInvalidHostSQL = "delete from host where id not in (select host_id from host_map)";
    public static final String DeleteInvalidHostMapSQL = "delete from host_map m where m.host_id > 0 and m.host_id not in (select id from host)";
    public static final String DeleteInvalidSANHostMapSQL = "delete from host_map m where m.enclosure_id > 0 and m.enclosure_id not in (select id from enclosure where enc_type=47)";
    public static final String InsertSQL = "insert into host(id, name, full_name, enclosure_id, vhost_id, user_modified, mac, ip, pwwn, multipath, os_info, hbas, vcluster, created_time, last_updated_time) values(?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?)";
    public static final String UpdateSQL = "update host set name=?, full_name=?, enclosure_id=?, vhost_id=?, user_modified=?, mac=?, ip=?, pwwn=?, multipath=?, os_info=?, hbas=?, vcluster=?, last_updated_time=? where id=?";
    static final String TableName = "host";
    private final HostBase _base;
    private List<HostMapImpl> hostMaps;

    public HostImpl(String name) {
        this._base = new HostBase(name);
    }

    public HostImpl(long id, String name, String fullName, long enclosureId, long vhostId, boolean userModified, String mac, String ip, String pwwn, String multipath, String osinfo, String hbas, String vcluster) {
        super.setDBID(id);
        this._base = new HostBase(name, fullName);
        this._base.setId(id);
        this._base.setEnclosureId(enclosureId);
        this._base.setVhostId(vhostId);
        this._base.setUserModified(userModified);
        this._base.setMac(mac);
        this._base.setIp(ip);
        this._base.setPwwn(pwwn);
        this._base.setMultipath(multipath);
        this._base.setOsInfo(osinfo);
        this._base.setVcluster(vcluster);
    }

    @Override
    public String getDBTableName() {
        return TableName;
    }

    @Override
    public FabricImpl getFabric() {
        return null;
    }

    @Override
    public BaseModelObject getBaseObject() {
        return this._base;
    }

    public HostBase getBase() {
        return this._base;
    }

    @Override
    public boolean setPresent(boolean isPresent) {
        boolean wasPresent = this._base.isPresent();
        if (wasPresent ^ isPresent) {
            this._base.setPresent(isPresent);
            this.propertyChanged((short)1793, Boolean.valueOf(wasPresent), Boolean.valueOf(isPresent));
        }
        return wasPresent;
    }

    @Override
    public void setDBID(long id) {
        super.setDBID(id);
        this._base.setId(id);
    }

    public String getName() {
        return this._base.getName();
    }

    public void setName(String name) {
        this._base.setName(name);
    }

    public String getFullName() {
        return this._base.getFullName();
    }

    public void setFullName(String value) {
        this._base.setFullName(value);
    }

    public String getMac() {
        return this._base.getMac();
    }

    public void setMac(String value) {
        this._base.setMac(value);
    }

    public String getIp() {
        return this._base.getIp();
    }

    public void setIp(String ip) {
        this._base.setIp(ip);
    }

    public String getPwwn() {
        return this._base.getPwwn();
    }

    public void setPwwn(String pwwn) {
        this._base.setPwwn(pwwn);
    }

    public String getMutipath() {
        return this._base.getMultipath();
    }

    public void setMultipath(String multipath) {
        this._base.setMultipath(multipath);
    }

    public String getOsInfo() {
        return this._base.getOsInfo();
    }

    public void setOsInfo(String osinfo) {
        this._base.setOsInfo(osinfo);
    }

    public String getHbas() {
        return this._base.getHbas();
    }

    public void setHbas(String hbas) {
        this._base.setHbas(hbas);
    }

    public String getVcluster() {
        return this._base.getVcluster();
    }

    public void setVcluster(String vcluster) {
        this._base.setVcluster(vcluster);
    }

    public Timestamp getCreatedTime() {
        return this._base.getCreatedTime();
    }

    public void setCreatedTime(Timestamp t) {
        this._base.setCreatedTime(t);
    }

    public Timestamp getLastUpdatedTime() {
        return this._base.getLastUpdatedTime();
    }

    public void setLastUpdatedTime(Timestamp t) {
        this._base.setLastUpdatedTime(t);
    }

    public long getEnclosureId() {
        return this._base.getEnclosureId();
    }

    public void setEnclosureId(long id) {
        this._base.setEnclosureId(id);
    }

    public long getVhostId() {
        return this._base.getVhostId();
    }

    public void setVhostId(long id) {
        this._base.setVhostId(id);
    }

    public List<HostMapImpl> getHostMaps() {
        if (this.hostMaps == null) {
            this.hostMaps = new ArrayList<HostMapImpl>();
        }
        return this.hostMaps;
    }

    public void setHostMaps(List<HostMapImpl> hostMaps) {
        this.hostMaps = hostMaps;
    }

    public void addHostMap(HostMapImpl hostmap) {
        if (this.hostMaps == null) {
            this.hostMaps = new ArrayList<HostMapImpl>();
        }
        this.hostMaps.add(hostmap);
    }

    public void deleteHostMap(HostMapImpl hostmap) {
        this.hostMaps.remove(hostmap);
    }

    public boolean isEnclosure() {
        return this._base.getEnclosureId() > 0L;
    }

    public boolean isVhost() {
        return this._base.getVhostId() > 0L;
    }

    public boolean isLanHost() {
        if (this.hostMaps != null) {
            for (HostMapImpl m : this.hostMaps) {
                if (m.getLanHostId() <= 0L) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isUserModified() {
        return this._base.isUserModified();
    }

    public void setUserModified(boolean value) {
        this._base.setUserModified(value);
    }

    public void setData(Connection con) {
        this._base.clear();
        if (this.hostMaps != null) {
            for (HostMapImpl m : this.hostMaps) {
                LanHostImpl lanHost;
                if (m.getEnclosureId() > 0L) {
                    List<Wwn> pwwns;
                    EnclosureImpl enc = SanManager.getInstance().findEnclosureByName(this.getName());
                    if (enc == null) continue;
                    if (enc.getIpAddress() != null && !enc.getIpAddress().equalsIgnoreCase("null")) {
                        if (this.getIp() == null || this.getIp().length() == 0) {
                            this.setIp(enc.getIpAddress());
                        } else if (enc.getIpAddress() != null && this.getIp().indexOf(enc.getIpAddress()) < 0) {
                            this.setIp(this.getIp() + "," + enc.getIpAddress());
                        }
                    }
                    if ((pwwns = HostManager.getPortWwnByEnclosureId(con, enc.getDBID())) == null || pwwns.isEmpty()) continue;
                    String wwns = "";
                    for (int i = 0; i < pwwns.size() - 1; ++i) {
                        String pwwn;
                        if (pwwns.get(i) == null || wwns.indexOf(pwwn = pwwns.get(i).toHexString(true).toUpperCase()) >= 0 || this.getPwwn() != null && this.getPwwn().indexOf(pwwn) >= 0) continue;
                        wwns = wwns + pwwn + ",";
                    }
                    String pwwn = pwwns.get(pwwns.size() - 1).toHexString(true).toUpperCase();
                    if (wwns.indexOf(pwwn) < 0 && (this.getPwwn() == null || this.getPwwn().indexOf(pwwn) < 0)) {
                        wwns = wwns + pwwn;
                    }
                    if (this.getPwwn() == null || this.getPwwn().length() == 0) {
                        this.setPwwn(wwns);
                        continue;
                    }
                    this.setPwwn(this.getPwwn() + "," + wwns);
                    continue;
                }
                if (m.getVhostId() > 0L) {
                    ArrayList<Wwn> pwwns;
                    PhyNicImpl[] phynics;
                    VHostImpl vhost = VHostImpl.getVhostById(m.getVhostId());
                    if (vhost == null) continue;
                    this.setVcluster(vhost.getClusterName());
                    if (this.getHbas() == null || this.getHbas().length() == 0) {
                        this.setHbas(vhost.getHbasAsString());
                    } else if (vhost.getHbasAsString() != null && this.getHbas().indexOf(vhost.getHbasAsString()) < 0) {
                        this.setHbas(this.getHbas() + "," + vhost.getHbasAsString());
                    }
                    this.setFullName(vhost.getHostFullName());
                    if (this.getIp() == null || this.getIp().length() == 0) {
                        this.setIp(vhost.getIpAddressesAsString());
                    } else if (vhost.getIpAddressesAsString() != null && this.getIp().indexOf(vhost.getIpAddressesAsString()) < 0) {
                        this.setIp(this.getIp() + "," + vhost.getIpAddressesAsString());
                    }
                    this.setOsInfo(vhost.getOsType());
                    this.setMultipath(vhost.getMultiPath());
                    String mac = "";
                    if (vhost.getMacAddressesAsString() != null && vhost.getMacAddressesAsString().length() > 0) {
                        mac = vhost.getMacAddressesAsString().toUpperCase();
                    }
                    if ((phynics = vhost.getPhyNics()) != null && phynics.length > 0) {
                        if (mac.length() > 0) {
                            mac = mac + ",";
                        }
                        for (int i = 0; i < phynics.length - 1; ++i) {
                            if (mac.indexOf(phynics[i].getMac().toUpperCase()) >= 0 || this.getMac() != null && this.getMac().indexOf(phynics[i].getMac().toUpperCase()) >= 0) continue;
                            mac = mac + phynics[i].getMac().toUpperCase() + ",";
                        }
                        String temp = phynics[phynics.length - 1].getMac().toUpperCase();
                        if (mac.indexOf(temp) < 0 && (this.getMac() == null || this.getMac().indexOf(temp) < 0)) {
                            mac = mac + temp;
                        }
                    }
                    if (this.getMac() == null || this.getMac().length() == 0) {
                        this.setMac(mac);
                    } else {
                        this.setMac(this.getMac() + "," + mac);
                    }
                    if ((pwwns = vhost.getHbas()) == null || pwwns.isEmpty()) continue;
                    String wwns = "";
                    for (int i = 0; i < pwwns.size() - 1; ++i) {
                        String pwwn;
                        if (pwwns.get(i) == null || wwns.indexOf(pwwn = ((Wwn)pwwns.get(i)).toHexString(true).toUpperCase()) >= 0 || this.getPwwn() != null && this.getPwwn().indexOf(pwwn) >= 0) continue;
                        wwns = wwns + pwwn + ",";
                    }
                    String pwwn = ((Wwn)pwwns.get(pwwns.size() - 1)).toHexString(true).toUpperCase();
                    if (wwns.indexOf(pwwn) < 0 && (this.getPwwn() == null || this.getPwwn().indexOf(pwwn) < 0)) {
                        wwns = wwns + pwwn;
                    }
                    if (this.getPwwn() == null || this.getPwwn().length() == 0) {
                        this.setPwwn(wwns);
                        continue;
                    }
                    this.setPwwn(this.getPwwn() + "," + wwns);
                    continue;
                }
                if (m.getLanHostId() <= 0L || (lanHost = LanHostImpl.getLanHostsById(con, m.getLanHostId())) == null) continue;
                if (this.getMac() == null || this.getMac().length() == 0) {
                    this.setMac(lanHost.getMac());
                } else if (lanHost.getMac() != null && this.getMac() != null && this.getMac().indexOf(lanHost.getMac()) < 0) {
                    this.setMac(this.getMac() + "," + lanHost.getMac());
                }
                if (this.getIp() == null || this.getIp().length() == 0) {
                    this.setIp(lanHost.getIpAddress());
                    continue;
                }
                if (lanHost.getIpAddress() == null || lanHost.getIpAddress() == null || this.getIp().indexOf(lanHost.getIpAddress()) >= 0) continue;
                this.setIp(this.getIp() + "," + lanHost.getIpAddress());
            }
        }
    }

    public void setData(Connection con, LanHostImpl lanHost) {
        if (lanHost != null) {
            if (this.getMac() == null || this.getMac().length() == 0) {
                this.setMac(lanHost.getMac());
            } else if (lanHost.getMac() != null && this.getMac() != null && this.getMac().indexOf(lanHost.getMac()) < 0) {
                this.setMac(this.getMac() + "," + lanHost.getMac());
            }
            if (this.getIp() == null || this.getIp().length() == 0) {
                this.setIp(lanHost.getIpAddress());
            } else if (lanHost.getIpAddress() != null && lanHost.getIpAddress() != null && this.getIp().indexOf(lanHost.getIpAddress()) < 0) {
                this.setIp(this.getIp() + "," + lanHost.getIpAddress());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPreexistRecord(Connection con) throws SQLException {
        block6: {
            PreparedStatement stat = con.prepareStatement(QuerySQLEsitingRecord);
            ResultSet rs = null;
            try {
                int i = 1;
                stat.setString(i++, this.getName());
                rs = stat.executeQuery();
                if (rs.next()) {
                    this.setDBID(rs.getLong(1));
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                _logger.log(Level.ERROR, "checkPreexistRecord caught exception", ex);
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        if (this.getDBID() == 0L) {
            this.setDBID(Sequence.getSequence().getPK());
            PreparedStatement stat = con.prepareStatement(InsertSQL);
            this.setupInsertStatement(stat);
            return stat;
        }
        PreparedStatement stat = con.prepareStatement(UpdateSQL);
        this.setupUpdateStatement(stat);
        return stat;
    }

    public void setupInsertStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        int i = 1;
        stat.setLong(i++, this.getDBID());
        stat.setString(i++, this.getName());
        stat.setString(i++, this._base.getFullName());
        stat.setLong(i++, this._base.getEnclosureId());
        stat.setLong(i++, this._base.getVhostId());
        stat.setBoolean(i++, this._base.isUserModified());
        if (this._base.getMac() != null && this._base.getMac().length() > 4000) {
            stat.setString(i++, this._base.getMac().substring(0, 3999));
        } else {
            stat.setString(i++, this._base.getMac());
        }
        if (this._base.getIp() != null && this._base.getIp().length() > 4000) {
            stat.setString(i++, this._base.getIp().substring(0, 3999));
        } else {
            stat.setString(i++, this._base.getIp());
        }
        if (this._base.getPwwn() != null && this._base.getPwwn().length() > 4000) {
            stat.setString(i++, this._base.getPwwn().substring(0, 3999));
        } else {
            stat.setString(i++, this._base.getPwwn());
        }
        if (this._base.getMultipath() != null && this._base.getMultipath().length() > 1024) {
            stat.setString(i++, this._base.getMultipath().substring(0, 1023));
        } else {
            stat.setString(i++, this._base.getMultipath());
        }
        if (this._base.getOsInfo() != null && this._base.getOsInfo().length() > 1024) {
            stat.setString(i++, this._base.getOsInfo().substring(0, 1023));
        } else {
            stat.setString(i++, this._base.getOsInfo());
        }
        if (this._base.getHbas() != null && this._base.getHbas().length() > 4000) {
            stat.setString(i++, this._base.getHbas().substring(0, 3999));
        } else {
            stat.setString(i++, this._base.getHbas());
        }
        stat.setString(i++, this._base.getVcluster());
        stat.setTimestamp(i++, new Timestamp(System.currentTimeMillis()));
        stat.setTimestamp(i++, new Timestamp(System.currentTimeMillis()));
    }

    public void setupUpdateStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        int i = 1;
        stat.setString(i++, this.getName());
        stat.setString(i++, this._base.getFullName());
        stat.setLong(i++, this._base.getEnclosureId());
        stat.setLong(i++, this._base.getVhostId());
        stat.setBoolean(i++, this._base.isUserModified());
        if (this._base.getMac() != null && this._base.getMac().length() > 4000) {
            stat.setString(i++, this._base.getMac().substring(0, 3999));
        } else {
            stat.setString(i++, this._base.getMac());
        }
        if (this._base.getIp() != null && this._base.getIp().length() > 4000) {
            stat.setString(i++, this._base.getIp().substring(0, 3999));
        } else {
            stat.setString(i++, this._base.getIp());
        }
        if (this._base.getPwwn() != null && this._base.getPwwn().length() > 4000) {
            stat.setString(i++, this._base.getPwwn().substring(0, 3999));
        } else {
            stat.setString(i++, this._base.getPwwn());
        }
        if (this._base.getMultipath() != null && this._base.getMultipath().length() > 1024) {
            stat.setString(i++, this._base.getMultipath().substring(0, 1023));
        } else {
            stat.setString(i++, this._base.getMultipath());
        }
        if (this._base.getOsInfo() != null && this._base.getOsInfo().length() > 1024) {
            stat.setString(i++, this._base.getOsInfo().substring(0, 1023));
        } else {
            stat.setString(i++, this._base.getOsInfo());
        }
        if (this._base.getHbas() != null && this._base.getHbas().length() > 4000) {
            stat.setString(i++, this._base.getHbas().substring(0, 3999));
        } else {
            stat.setString(i++, this._base.getHbas());
        }
        stat.setString(i++, this._base.getVcluster());
        stat.setTimestamp(i++, new Timestamp(System.currentTimeMillis()));
        stat.setLong(i++, this.getDBID());
    }

    @Override
    public String toString() {
        return "HostImpl [_base=" + this._base + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HostImpl> getHostByFabricId(Connection con, long fid) {
        List<HostImpl> list;
        block5: {
            PreparedStatement queryStat = null;
            ResultSet rs = null;
            list = null;
            try {
                queryStat = con.prepareStatement(QuerySQLByFabricId);
                queryStat.setLong(1, fid);
                rs = queryStat.executeQuery();
                list = HostImpl.loadDBRecord(rs);
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                _logger.log(Level.WARN, "loadSanHostsFromDB failed", ex);
                break block5;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(queryStat);
            }
            DbUtil.close(queryStat);
        }
        return list;
    }

    public static List<HostImpl> loadDBRecord(ResultSet rs) throws SQLException {
        ArrayList<HostImpl> list = new ArrayList<HostImpl>();
        if (rs == null) {
            return list;
        }
        while (rs.next()) {
            int i = 1;
            long id = rs.getLong(i++);
            String name = rs.getString(i++);
            String fullName = rs.getString(i++);
            long enclosure_id = rs.getLong(i++);
            long vhost_id = rs.getLong(i++);
            boolean userModified = rs.getBoolean(i++);
            String mac = rs.getString(i++);
            String ip = rs.getString(i++);
            String pwwn = rs.getString(i++);
            String multipath = rs.getString(i++);
            String osinfo = rs.getString(i++);
            String hbas = rs.getString(i++);
            String vcluster = rs.getString(i++);
            Timestamp createdTime = rs.getTimestamp(i++);
            Timestamp lastUpdatedTime = rs.getTimestamp(i++);
            HostImpl host = new HostImpl(id, name, fullName, enclosure_id, vhost_id, userModified, mac, ip, pwwn, multipath, osinfo, hbas, vcluster);
            host.setCreatedTime(createdTime);
            host.setLastUpdatedTime(lastUpdatedTime);
            list.add(host);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteHost(Connection con, HostImpl host) {
        if (host == null) {
            return;
        }
        PreparedStatement deleteStat = null;
        try {
            deleteStat = con.prepareStatement("delete from host where id=?");
            deleteStat.setLong(1, host.getDBID());
            deleteStat.execute();
            List<HostMapImpl> hostMaps = HostMapImpl.loadHostMapsByHostId(con, host.getDBID());
            if (hostMaps != null && !hostMaps.isEmpty()) {
                HostMapImpl.deleteHostMaps(con, hostMaps);
            }
        }
        catch (Exception ex) {
            try {
                con.rollback();
            }
            catch (Exception sqlex) {
                // empty catch block
            }
            _logger.log(Level.ERROR, "deleteHost caught exception", ex);
        }
        finally {
            DbUtil.close(deleteStat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllHosts(Connection con) {
        PreparedStatement deleteStat = null;
        long startTime = System.currentTimeMillis();
        try {
            deleteStat = con.prepareStatement(DeleteAllSQL);
            deleteStat.execute();
        }
        catch (Exception ex) {
            try {
                con.rollback();
            }
            catch (Exception sqlex) {
                // empty catch block
            }
            _logger.log(Level.ERROR, "deleteAllHosts caught exception", ex);
        }
        finally {
            DbUtil.close(deleteStat);
        }
        _logger.info("deleteAllHosts finished in " + (System.currentTimeMillis() - startTime) + "ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteInvalidHosts(Connection con) {
        long startTime = System.currentTimeMillis();
        List<Long> ids = HostImpl.getHostIds(con);
        List<Long> hostIds = HostMapImpl.getHostIds(con);
        PreparedStatement deleteStat = null;
        int[] deleted = new int[]{};
        try {
            deleteStat = con.prepareStatement("delete from host where id=?");
            for (Long id : hostIds) {
                if (ids.contains(id)) continue;
                deleteStat.setLong(1, id);
                deleteStat.addBatch();
            }
            deleted = deleteStat.executeBatch();
        }
        catch (Exception ex) {
            try {
                con.rollback();
            }
            catch (Exception sqlex) {
                // empty catch block
            }
            _logger.log(Level.ERROR, "deleteHost caught exception", ex);
        }
        finally {
            DbUtil.close(deleteStat);
        }
        _logger.info("deleteInvalidHosts: finished in " + (System.currentTimeMillis() - startTime) + "ms, deleted: " + deleted.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteInvalidLanHosts(Connection con) {
        long startTime = System.currentTimeMillis();
        List<Long> ids = HostImpl.getHostIds(con);
        List<Long> hostIds = HostMapImpl.getHostIds(con);
        PreparedStatement deleteStat = null;
        int[] deleted = new int[]{};
        try {
            deleteStat = con.prepareStatement("delete from host where id=?");
            for (Long id : ids) {
                if (hostIds.contains(id)) continue;
                deleteStat.setLong(1, id);
                deleteStat.addBatch();
            }
            deleted = deleteStat.executeBatch();
        }
        catch (Exception ex) {
            try {
                con.rollback();
            }
            catch (Exception sqlex) {
                // empty catch block
            }
            _logger.log(Level.ERROR, "deleteHost caught exception", ex);
        }
        finally {
            DbUtil.close(deleteStat);
        }
        _logger.info("deleteInvalidHosts: finished in " + (System.currentTimeMillis() - startTime) + ", deleted: " + deleted.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteHosts(Connection con, List<HostImpl> hosts) {
        if (hosts == null || hosts.size() == 0) {
            return;
        }
        long startTime = System.currentTimeMillis();
        PreparedStatement deleteStat = null;
        for (HostImpl h : hosts) {
            try {
                deleteStat = con.prepareStatement("delete from host where id=?");
                deleteStat.setLong(1, h.getDBID());
                deleteStat.execute();
                List<HostMapImpl> hostMaps = HostMapImpl.loadHostMapsByHostId(con, h.getDBID());
                if (hostMaps != null && !hostMaps.isEmpty()) {
                    HostMapImpl.deleteHostMaps(con, hostMaps);
                }
                _logger.log(Level.DEBUG, "done deleteHost: " + h.getName());
            }
            catch (SQLException ex) {
                _logger.log(Level.ERROR, "deleteHost '" + h.getName() + "' failed", ex);
                try {
                    if (con != null) {
                        con.rollback();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (ex != null && ex.getNextException() != null) {
                    _logger.log(Level.WARN, "deleteHosts failed and got SQLException", ex.getNextException());
                    continue;
                }
                _logger.log(Level.WARN, "deleteHosts failed and got SQLException", ex);
            }
            finally {
                DbUtil.close(deleteStat);
            }
        }
        _logger.log(Level.INFO, "deleteHosts finished in " + (System.currentTimeMillis() - startTime) + "ms, deleted: " + hosts.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteHostsByLanHostIds(Connection con, List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        long startTime = System.currentTimeMillis();
        PreparedStatement deleteStat = null;
        int[] total = new int[]{};
        try {
            deleteStat = con.prepareStatement(DeleteByLanHostIdSQL);
            for (Long id : ids) {
                deleteStat.setLong(1, id);
                deleteStat.addBatch();
            }
            total = deleteStat.executeBatch();
        }
        catch (Exception ex) {
            _logger.log(Level.ERROR, "deleteHostsByLanHostIds failed", ex);
        }
        finally {
            DbUtil.close(deleteStat);
        }
        _logger.log(Level.INFO, "deleteHosts finished in " + (System.currentTimeMillis() - startTime) + "ms, IDs: " + ids.size() + ", deleted: " + total.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void persistHost(Connection con, HostImpl host) {
        PreparedStatement updateStat;
        PreparedStatement insertStat;
        block8: {
            if (host == null) {
                return;
            }
            insertStat = null;
            updateStat = null;
            try {
                insertStat = con.prepareStatement(InsertSQL);
                updateStat = con.prepareStatement(UpdateSQL);
                if (host.getDBID() > 0L) {
                    host.setupUpdateStatement(updateStat);
                    updateStat.executeUpdate();
                } else {
                    host.setDBID(Sequence.getSequence().getPK());
                    host.setupInsertStatement(insertStat);
                    insertStat.execute();
                }
                if (host.getHostMaps() == null || host.getHostMaps().isEmpty()) break block8;
                List<HostMapImpl> hostMaps = host.getHostMaps();
                for (HostMapImpl m : hostMaps) {
                    m.setHostId(host.getDBID());
                }
                HostMapImpl.persistHostMaps(con, hostMaps);
            }
            catch (Exception ex) {
                try {
                    _logger.log(Level.WARN, "persistsHosts caught exception", ex);
                }
                catch (Throwable throwable) {
                    DbUtil.close(insertStat);
                    DbUtil.close(updateStat);
                    throw throwable;
                }
                DbUtil.close(insertStat);
                DbUtil.close(updateStat);
            }
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void persistHosts(Connection con, List<HostImpl> hosts) {
        if (hosts == null || hosts.size() == 0) {
            return;
        }
        int MAX_COUNT = 500;
        long startTime = System.currentTimeMillis();
        Statement insertStat = null;
        Statement updateStat = null;
        int insertCount = 0;
        int updateCount = 0;
        int total = 0;
        ArrayList<HostMapImpl> hmaps = new ArrayList<HostMapImpl>();
        try {
            for (HostImpl h : hosts) {
                if (insertStat == null) {
                    insertStat = con.prepareStatement(InsertSQL);
                }
                if (updateStat == null) {
                    updateStat = con.prepareStatement(UpdateSQL);
                }
                try {
                    if (h.getDBID() == 0L) {
                        h.setDBID(Sequence.getSequence().getPK());
                        h.setupInsertStatement((PreparedStatement)insertStat);
                        insertStat.addBatch();
                        ++insertCount;
                    } else if (h.getBase().isModified()) {
                        h.setupUpdateStatement((PreparedStatement)updateStat);
                        updateStat.addBatch();
                        ++updateCount;
                    }
                    if (h.getHostMaps() != null && !h.getHostMaps().isEmpty()) {
                        List<HostMapImpl> hostMaps = h.getHostMaps();
                        for (HostMapImpl m : hostMaps) {
                            m.setHostId(h.getDBID());
                            hmaps.add(m);
                        }
                    }
                    ++total;
                    if (insertCount == MAX_COUNT) {
                        try {
                            insertStat.executeBatch();
                        }
                        catch (SQLException sqlex) {
                            if (sqlex != null && sqlex.getNextException() != null) {
                                _logger.log(Level.WARN, "insertHosts failed and got SQLException", sqlex.getNextException());
                            } else {
                                _logger.log(Level.WARN, "insertHosts failed and got SQLException", sqlex);
                            }
                        }
                        finally {
                            DbUtil.close(insertStat);
                            insertStat = null;
                            insertCount = 0;
                        }
                    }
                    if (updateCount != MAX_COUNT) continue;
                    try {
                        updateStat.executeBatch();
                    }
                    catch (SQLException sqlex) {
                        if (sqlex != null && sqlex.getNextException() != null) {
                            _logger.log(Level.WARN, "updateHosts failed and got SQLException", sqlex.getNextException());
                            continue;
                        }
                        _logger.log(Level.WARN, "updateHosts failed and got SQLException", sqlex);
                    }
                    finally {
                        DbUtil.close(updateStat);
                        updateStat = null;
                        updateCount = 0;
                    }
                }
                catch (SQLException ex) {
                    _logger.log(Level.ERROR, "persistHost '" + h.getName() + "' failed", ex);
                }
            }
            if (insertStat != null) {
                insertStat.executeBatch();
            }
            if (updateStat != null) {
                updateStat.executeBatch();
            }
            _logger.log(Level.INFO, "persistHosts finished in " + (System.currentTimeMillis() - startTime) + "ms, persisted: " + total);
        }
        catch (SQLException sqlex) {
            block36: {
                if (sqlex != null && sqlex.getNextException() != null) {
                    _logger.log(Level.WARN, "persistsHosts failed and got SQLException", sqlex.getNextException());
                    break block36;
                }
                _logger.log(Level.WARN, "persistsHosts failed and got SQLException", sqlex);
            }
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
        }
        catch (Exception ex) {
            _logger.log(Level.WARN, "persistsHosts failed and got exception", ex);
            {
                catch (Throwable throwable) {
                    DbUtil.close(insertStat);
                    DbUtil.close(updateStat);
                    throw throwable;
                }
            }
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
        if (!hmaps.isEmpty()) {
            HostMapImpl.persistHostMaps(con, hmaps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HostImpl getHostByName(Connection con, String name) {
        HostImpl host;
        block6: {
            PreparedStatement stat = null;
            ResultSet rs = null;
            host = null;
            try {
                List<HostImpl> hosts;
                stat = con.prepareStatement(QuerySQLByName);
                stat.setString(1, name);
                rs = stat.executeQuery();
                if (rs != null && (hosts = HostImpl.loadDBRecord(rs)) != null && !hosts.isEmpty()) {
                    host = hosts.get(0);
                    host.setHostMaps(HostMapImpl.loadHostMapsByHostId(con, host.getDBID()));
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                _logger.log(Level.ERROR, "getHostByName caught exception", ex);
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
        return host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized List<HostImpl> loadHostsFromDB() throws SQLException {
        ArrayList<HostImpl> result = new ArrayList();
        Connection con = null;
        try {
            con = ConnectionManager.getConnection();
            result = HostImpl.loadHostsFromDB(con);
        }
        catch (Exception ex) {
            _logger.log(Level.WARN, "Load hosts from DB failed", ex);
            List<HostImpl> list = null;
            return list;
        }
        finally {
            DbUtil.close(con);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized List<HostImpl> loadHostsFromDB(Connection con) throws SQLException {
        List<Object> result = new ArrayList();
        PreparedStatement queryStat = null;
        ResultSet rs = null;
        try {
            queryStat = con.prepareStatement(QuerySQL);
            rs = queryStat.executeQuery();
            result = HostImpl.loadDBRecord(rs);
            if (!result.isEmpty()) {
                for (HostImpl hostImpl : result) {
                    List<HostMapImpl> hostMaps = HostMapImpl.loadHostMapsByHostId(con, hostImpl.getDBID());
                    hostImpl.setHostMaps(hostMaps);
                }
            }
        }
        catch (Exception ex) {
            List<HostImpl> list;
            try {
                _logger.log(Level.WARN, "Load hosts from DB failed", ex);
                list = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(queryStat);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(queryStat);
            return list;
        }
        DbUtil.close(rs);
        DbUtil.close(queryStat);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupHosts(Connection con) {
        long startTime = System.currentTimeMillis();
        PreparedStatement hostmapStat = null;
        try {
            hostmapStat = con.prepareStatement(DeleteInvalidHostMapSQL);
            hostmapStat.execute();
        }
        catch (SQLException ex) {
            _logger.log(Level.ERROR, "deleteInvalidHostMaps failed. ", ex);
        }
        finally {
            DbUtil.close(hostmapStat);
        }
        PreparedStatement hostStat = null;
        try {
            hostStat = con.prepareStatement(DeleteInvalidHostSQL);
            hostStat.execute();
        }
        catch (SQLException ex) {
            _logger.log(Level.ERROR, "deleteInvalidHosts failed. ", ex);
        }
        finally {
            DbUtil.close(hostStat);
        }
        _logger.info("cleanupHosts: finished in " + (System.currentTimeMillis() - startTime) + "ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Long> getHostIds(Connection con) {
        ResultSet rs;
        PreparedStatement stat;
        ArrayList<Long> results;
        block5: {
            results = new ArrayList<Long>();
            stat = null;
            rs = null;
            try {
                stat = con.prepareStatement(QueryIdsSQL);
                rs = stat.executeQuery();
                if (rs == null) break block5;
                while (rs.next()) {
                    results.add(new Long(rs.getLong(1)));
                }
            }
            catch (Exception ex) {
                try {
                    _logger.log(Level.ERROR, "deleteHost caught exception", ex);
                }
                catch (Throwable throwable) {
                    DbUtil.close(stat);
                    DbUtil.close(rs);
                    throw throwable;
                }
                DbUtil.close(stat);
                DbUtil.close(rs);
            }
        }
        DbUtil.close(stat);
        DbUtil.close(rs);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HostImpl getHostByMac(Connection con, String mac) {
        HostImpl host;
        block6: {
            PreparedStatement stat = null;
            ResultSet rs = null;
            host = null;
            try {
                List<HostImpl> hosts;
                String macAddr = "%" + mac + "%";
                stat = con.prepareStatement(QueryHostByMacSQL);
                stat.setString(1, macAddr);
                stat.setString(2, macAddr);
                stat.setString(3, macAddr);
                rs = stat.executeQuery();
                if (rs != null && (hosts = HostImpl.loadDBRecord(rs)) != null && !hosts.isEmpty()) {
                    host = hosts.get(0);
                    host.setHostMaps(HostMapImpl.loadHostMapsByHostId(con, host.getDBID()));
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                _logger.log(Level.ERROR, "getHostByMac caught exception", ex);
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
        return host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<HostImpl> getHostsByVhostId(Connection con, long vhostId) {
        ResultSet rs;
        PreparedStatement stat;
        block7: {
            List<HostImpl> list;
            block6: {
                stat = null;
                rs = null;
                try {
                    stat = con.prepareStatement(QuerySQLByVhostId);
                    stat.setLong(1, vhostId);
                    rs = stat.executeQuery();
                    if (rs != null) {
                        list = HostImpl.loadDBRecord(rs);
                        DbUtil.close(rs);
                        break block6;
                    }
                    DbUtil.close(rs);
                    break block7;
                }
                catch (SQLException ex) {
                    _logger.log(Level.ERROR, "getHostByVhostId caught exception", ex);
                    return null;
                }
            }
            DbUtil.close(stat);
            return list;
        }
        DbUtil.close(stat);
        return null;
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HostImpl> loadSanHostsFromDB(Connection con) throws SQLException {
        PreparedStatement queryStat = null;
        ResultSet rs = null;
        List<HostImpl> list = null;
        try {
            queryStat = con.prepareStatement(QuerySanHostSQL);
            rs = queryStat.executeQuery();
            list = HostImpl.loadDBRecord(rs);
        }
        catch (Exception ex) {
            try {
                _logger.log(Level.WARN, "loadSanHostsFromDB failed", ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(queryStat);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(queryStat);
        }
        DbUtil.close(rs);
        DbUtil.close(queryStat);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HostImpl> loadEnclosuresDB() throws SQLException {
        Connection con = null;
        List<HostImpl> list = null;
        try {
            con = ConnectionManager.getConnection();
            list = HostImpl.loadEnclosuresDB(con);
        }
        catch (Exception ex) {
            _logger.log(Level.WARN, "load enclosures from DB failed", ex);
        }
        finally {
            DbUtil.close(con);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<HostImpl> loadEnclosuresDB(Connection con) throws SQLException {
        ArrayList<HostImpl> id222;
        PreparedStatement queryStat = null;
        ResultSet rs = null;
        ArrayList<HostImpl> list = new ArrayList<HostImpl>();
        try {
            queryStat = con.prepareStatement(QueryEnclosureSQL);
            rs = queryStat.executeQuery();
            while (rs.next()) {
                long id222 = rs.getLong(1);
                String name = rs.getString(2);
                long vhost_id = rs.getLong(3);
                HostImpl host = new HostImpl(name);
                host.getBase().setEnclosureId(id222);
                if (vhost_id > 0L) {
                    host.getBase().setVhostId(vhost_id);
                }
                list.add(host);
            }
            id222 = list;
        }
        catch (Exception ex) {
            try {
                _logger.log(Level.WARN, "load enclosures from DB failed", ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(queryStat);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(queryStat);
            return list;
        }
        DbUtil.close(rs);
        DbUtil.close(queryStat);
        return id222;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HostImpl> loadEnclosuresByFabricIdFromDB(Connection con, long fId) throws SQLException {
        ArrayList<HostImpl> id2;
        PreparedStatement queryStat = null;
        ResultSet rs = null;
        ArrayList<HostImpl> list = new ArrayList<HostImpl>();
        try {
            queryStat = con.prepareStatement(QueryEnclosureByFabricIdSQL);
            queryStat.setLong(1, fId);
            rs = queryStat.executeQuery();
            while (rs.next()) {
                long id2 = rs.getLong(1);
                String name = rs.getString(2);
                long vhost_id = rs.getLong(3);
                HostImpl host = new HostImpl(name);
                host.getBase().setEnclosureId(id2);
                if (vhost_id > 0L) {
                    host.getBase().setVhostId(vhost_id);
                }
                list.add(host);
            }
            id2 = list;
        }
        catch (Exception ex) {
            List<HostImpl> list2;
            try {
                _logger.log(Level.WARN, "load enclosures from DB failed", ex);
                list2 = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(queryStat);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(queryStat);
            return list2;
        }
        DbUtil.close(rs);
        DbUtil.close(queryStat);
        return id2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HostImpl> loadLanHostsFromHostTable(Connection con) {
        ResultSet rs;
        PreparedStatement stat;
        List<HostImpl> hosts;
        block5: {
            hosts = null;
            stat = null;
            rs = null;
            try {
                stat = con.prepareStatement(QueryLanHostSQL);
                rs = stat.executeQuery();
                hosts = HostImpl.loadDBRecord(rs);
                if (hosts == null) break block5;
                for (HostImpl h : hosts) {
                    h.setHostMaps(HostMapImpl.loadHostMapsByHostId(con, h.getDBID()));
                }
            }
            catch (SQLException ex) {
                try {
                    _logger.log(Level.ERROR, "loadLanHostsFromHostTable caught exception", ex);
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stat);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        return hosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HostImpl getHostByLanHostIdFromDB(Connection con, long lanHostId) throws SQLException {
        HostImpl host;
        block6: {
            PreparedStatement queryStat = null;
            ResultSet rs = null;
            host = null;
            try {
                queryStat = con.prepareStatement(QueryHostByLanHostIdSQL);
                queryStat.setLong(1, lanHostId);
                rs = queryStat.executeQuery();
                List<HostImpl> hosts = HostImpl.loadDBRecord(rs);
                if (hosts != null && !hosts.isEmpty()) {
                    host = hosts.get(0);
                    host.setHostMaps(HostMapImpl.loadHostMapsByHostId(con, host.getDBID()));
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                _logger.log(Level.WARN, "getHostByLanHostIdFromDB failed", ex);
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(queryStat);
            }
            DbUtil.close(queryStat);
        }
        return host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HostImpl getHostBySanHostIdFromDB(Connection con, long sanHostId) throws SQLException {
        HostImpl host;
        block6: {
            PreparedStatement queryStat = null;
            ResultSet rs = null;
            host = null;
            try {
                queryStat = con.prepareStatement(QueryHostBySanHostIdSQL);
                queryStat.setLong(1, sanHostId);
                rs = queryStat.executeQuery();
                List<HostImpl> hosts = HostImpl.loadDBRecord(rs);
                if (hosts != null && !hosts.isEmpty()) {
                    host = hosts.get(0);
                    host.setHostMaps(HostMapImpl.loadHostMapsByHostId(con, host.getDBID()));
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                _logger.log(Level.WARN, "getHostByLanHostIdFromDB failed", ex);
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(queryStat);
            }
            DbUtil.close(queryStat);
        }
        return host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HostImpl getHostByVhostIdFromDB(Connection con, long vhostId) throws SQLException {
        HostImpl res;
        block7: {
            PreparedStatement queryStat = null;
            ResultSet rs = null;
            ArrayList<HostImpl> list = new ArrayList<HostImpl>();
            res = null;
            try {
                queryStat = con.prepareStatement(QueryHostByVhostIdSQL);
                queryStat.setLong(1, vhostId);
                rs = queryStat.executeQuery();
                while (rs.next()) {
                    long id = rs.getLong(1);
                    String name = rs.getString(2);
                    String fullName = rs.getString(3);
                    long enc_id = rs.getLong(4);
                    HostImpl host = new HostImpl(name);
                    host.setDBID(id);
                    host.setFullName(fullName);
                    host.setEnclosureId(enc_id);
                    host.getBase().setVhostId(vhostId);
                    host.setHostMaps(HostMapImpl.loadHostMapsByHostId(con, host.getDBID()));
                    list.add(host);
                }
                if (!list.isEmpty()) {
                    res = (HostImpl)list.get(0);
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                _logger.log(Level.WARN, " load vhosts from DB failed", ex);
                break block7;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(queryStat);
            }
            DbUtil.close(queryStat);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HostImpl> loadVHostHostsFromDB(Connection con) throws SQLException {
        ArrayList<HostImpl> arrayList;
        PreparedStatement queryStat = null;
        ResultSet rs = null;
        ArrayList<HostImpl> list = new ArrayList();
        try {
            queryStat = con.prepareStatement(QueryVHostHostSQL);
            rs = queryStat.executeQuery();
            arrayList = list = HostImpl.loadDBRecord(rs);
        }
        catch (Exception ex) {
            List<HostImpl> list2;
            try {
                _logger.log(Level.WARN, "loadVHostHostsFromDB failed", ex);
                list2 = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(queryStat);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(queryStat);
            return list2;
        }
        DbUtil.close(rs);
        DbUtil.close(queryStat);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HostImpl> loadVHostsFromDB(Connection con) throws SQLException {
        ArrayList<HostImpl> id2;
        PreparedStatement queryStat = null;
        ResultSet rs = null;
        ArrayList<HostImpl> list = new ArrayList<HostImpl>();
        try {
            queryStat = con.prepareStatement(QueryVhostSQL);
            rs = queryStat.executeQuery();
            while (rs.next()) {
                long id2 = rs.getLong(1);
                String name = rs.getString(2);
                String fullName = rs.getString(3);
                HostImpl host = new HostImpl(name);
                host.getBase().setVhostId(id2);
                host.setFullName(fullName);
                list.add(host);
            }
            id2 = list;
        }
        catch (Exception ex) {
            List<HostImpl> list2;
            try {
                _logger.log(Level.WARN, "loadVHostsFromDB failed", ex);
                list2 = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(queryStat);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(queryStat);
            return list2;
        }
        DbUtil.close(rs);
        DbUtil.close(queryStat);
        return id2;
    }

    public static Map<Long, HostImpl> getSanHosts(Connection con) throws SQLException {
        HashMap<Long, HostImpl> hosts = new HashMap<Long, HostImpl>();
        List<HostImpl> sanHosts = HostImpl.loadSanHostsFromDB(con);
        if (sanHosts != null) {
            for (HostImpl h : sanHosts) {
                List<HostMapImpl> hostMaps = HostMapImpl.loadHostMapsByHostId(con, h.getDBID());
                if (hostMaps != null) {
                    h.setHostMaps(hostMaps);
                }
                hosts.put(h.getBase().getEnclosureId(), h);
            }
        }
        return hosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Long> getSanHostIds(Connection con) throws SQLException {
        HashSet<Long> ids = new HashSet<Long>();
        PreparedStatement queryStat = null;
        ResultSet rs = null;
        try {
            queryStat = con.prepareStatement(QuerySQLSanHostIds);
            rs = queryStat.executeQuery();
            while (rs.next()) {
                long id = rs.getLong(1);
                ids.add(id);
            }
        }
        catch (Exception ex) {
            Set<Long> set;
            try {
                _logger.log(Level.WARN, "load SAN host Ids failed", ex);
                set = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(queryStat);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(queryStat);
            return set;
        }
        DbUtil.close(rs);
        DbUtil.close(queryStat);
        return ids;
    }

    public static void cleanupLanHosts() {
        HostManager.getInstance().stopLanHostWorker();
        Thread cleanup = new Thread((Runnable)new CleanupLanHosts(), "CleanupLanHosts");
        cleanup.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteOldSanHosts(Connection con) {
        try {
            long startTime = System.currentTimeMillis();
            PreparedStatement stat = null;
            try {
                stat = con.prepareStatement(DeleteInvalidSANHostMapSQL);
                stat.execute();
            }
            catch (SQLException ex) {
                _logger.log(Level.ERROR, "deleteOldSanHosts failed. ", ex);
            }
            finally {
                DbUtil.close(stat);
            }
            if (DCManager.getInstance().getNumEthSwitches() == 0) {
                HostImpl.cleanupHosts(con);
            }
            _logger.info("deleteOldSanHosts finished in " + (System.currentTimeMillis() - startTime) + "ms");
        }
        catch (Exception ex) {
            _logger.log(Level.ERROR, "deleteOldSanHosts caught exception", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllLanHosts(Connection con) {
        PreparedStatement stat = null;
        long startTime = System.currentTimeMillis();
        try {
            stat = con.prepareStatement(DeleteAllLanHostSQL);
            stat.execute();
        }
        catch (Exception ex) {
            _logger.log(Level.ERROR, "deleteAllLanHosts caught exception", ex);
        }
        finally {
            DbUtil.close(stat);
        }
        _logger.info("deleteAllLanHosts finished in " + (System.currentTimeMillis() - startTime) + "ms");
    }

    public static void deleteOldLanHosts(Connection con) {
        try {
            long startTime = System.currentTimeMillis();
            LanHostImpl.deleteInvalidLanHosts(con);
            HostImpl.cleanupHosts(con);
            _logger.info("deleteOldLanHosts finished in " + (System.currentTimeMillis() - startTime) + "ms");
        }
        catch (Exception ex) {
            _logger.log(Level.ERROR, "deleteOldLanHosts caught exception", ex);
        }
    }

    public static class CleanupLanHosts
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long startTime = System.currentTimeMillis();
            Connection con = null;
            try {
                con = ConnectionManager.getConnection();
                LanImpl lan = DCManager.getInstance().getLan();
                List<EthSwitchImpl> swList = null;
                if (lan != null) {
                    swList = lan.getEthSwitches();
                }
                if (swList == null || swList.isEmpty()) {
                    LanHostImpl.deleteAllLanHosts(con);
                    HostImpl.deleteOldLanHosts(con);
                } else {
                    ArrayList<Long> swIds = new ArrayList<Long>();
                    for (EthSwitchImpl s : swList) {
                        swIds.add(s.getDBID());
                    }
                    List<Long> swIdsInLanHosts = LanHostImpl.getEthSwitchIds(con);
                    ArrayList<Long> invalidSwIds = new ArrayList<Long>();
                    for (Long l : swIdsInLanHosts) {
                        if (swIds.contains(l)) continue;
                        invalidSwIds.add(l);
                    }
                    if (!invalidSwIds.isEmpty()) {
                        ArrayList<Long> lanHostIds = new ArrayList<Long>();
                        for (Long l : invalidSwIds) {
                            lanHostIds.addAll(LanHostImpl.getLanHostIdsBySwitchId(con, l));
                        }
                        if (!lanHostIds.isEmpty()) {
                            LanHostImpl.deleteLanHostsByIds(con, lanHostIds);
                            HostImpl.deleteOldLanHosts(con);
                        }
                    }
                }
            }
            catch (Exception e) {
                _logger.log(Level.ERROR, "cleanupLanHosts caught exception", e);
            }
            finally {
                DbUtil.close(con);
            }
            _logger.info("cleanupLanHosts finished in " + (System.currentTimeMillis() - startTime) + "ms");
        }
    }
}

