/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.sm.common.model.SpanInfo;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.model.AbstractDBObjectImpl;
import com.cisco.dcbu.sm.server.model.NtopImpl;
import com.cisco.dcbu.sm.server.model.SpanPortImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public class NtopSpanInfoImpl
extends AbstractDBObjectImpl {
    static final String QuerySQLByNtopSpanId = "select id, ntop_id, span_port_id,eth_name from ntop_span_info where ntop_id=? and span_port_id=?";
    static final String InsertSQL = "insert into ntop_span_info(id, ntop_id, span_port_id, eth_name,last_update_time) values(?,?,?,?,?)";
    static final String UpdateSQL = "update ntop_span_info set ntop_id=?, span_port_id=?, eth_name=?, last_update_time=? where id=?";
    static final String TableName = "ntop_span_info";
    private SpanPortImpl _sport;
    private NtopImpl _ntop;
    private SpanInfo _sInfo;

    public NtopSpanInfoImpl(SpanPortImpl sp, NtopImpl ntop, SpanInfo sInfo) {
        this._sport = sp;
        this._ntop = ntop;
        this._sInfo = sInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPreexistRecord(Connection con) throws SQLException {
        block8: {
            PreparedStatement stat = con.prepareStatement(QuerySQLByNtopSpanId);
            ResultSet rs = null;
            try {
                if (this._sport == null || this._ntop == null) {
                    return;
                }
                this.setupCheckExistenceStatement(stat);
                rs = stat.executeQuery();
                if (rs.next()) {
                    this.setDBID(1L);
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                break block8;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        if (this.getDBID() == 0L) {
            this.setDBID(Sequence.getSequence().getPK());
            PreparedStatement stat = con.prepareStatement(InsertSQL);
            this.setupInsertStatement(stat);
            return stat;
        }
        PreparedStatement stat = con.prepareStatement(UpdateSQL);
        this.setupUpdateStatement(stat);
        return stat;
    }

    @Override
    public String getDBTableName() {
        return TableName;
    }

    public static String getInsertSqlStr() {
        return InsertSQL;
    }

    public static String getUpdateSqlStr() {
        return UpdateSQL;
    }

    public static String getCheckExistenceSqlStr() {
        return QuerySQLByNtopSpanId;
    }

    public void setupInsertStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this.getDBID());
        stat.setLong(2, this._ntop.getDBID());
        stat.setLong(3, this._sport.getDBID());
        stat.setString(4, this._sInfo._ntopEth);
        stat.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
    }

    public void setupUpdateStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this._ntop.getDBID());
        stat.setLong(2, this._sport.getDBID());
        stat.setString(3, this._sInfo._ntopEth);
        stat.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
        stat.setLong(5, this.getDBID());
    }

    public void setupCheckExistenceStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this._ntop.getDBID());
        stat.setLong(2, this._sport.getDBID());
    }
}

