/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.jnm.WwnVendor;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.mds.zm.DefaultZoneAttributes;
import com.cisco.dcbu.lib.snmp.SnmpCommunity;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.snmp.security.CommunityUser;
import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.lib.util.IntArray;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.sm.common.dto.FeatureRegion;
import com.cisco.dcbu.sm.common.dto.VsanDomain;
import com.cisco.dcbu.sm.common.model.AbstractSwitchBase;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import com.cisco.dcbu.sm.common.model.HwInventoryComponent;
import com.cisco.dcbu.sm.common.model.LicenseInfo;
import com.cisco.dcbu.sm.common.model.PowerSupply;
import com.cisco.dcbu.sm.common.model.SMEPortBase;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.model.SwitchIf;
import com.cisco.dcbu.sm.common.model.SwitchLicenseDetails;
import com.cisco.dcbu.sm.common.type.CfsRegionPK;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.MacAddress;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.PlatformType;
import com.cisco.dcbu.sm.common.type.SerialNumKey;
import com.cisco.dcbu.sm.common.type.VsanFcIdKey;
import com.cisco.dcbu.sm.common.type.VsanPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.common.util.TraceLogger;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.discovery.SnmpAdapter;
import com.cisco.dcbu.sm.server.inventory.InventoryManager;
import com.cisco.dcbu.sm.server.licmgr.FileLicensingHelper;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.EnclosureImpl;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.IslImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.VsanImpl;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public final class SwitchImpl
extends AbstractModelObjectImpl
implements SwitchIf {
    static Logger _Logger = LogManager.getLogger((String)"fms.model");
    static TraceLogger _Tracer = new TraceLogger(_Logger, SanManager.Test, false, false, false);
    static final String QuerySQL = "select id, fabric_id, wwn, ip_address, is_mds, type, is_managable, non_mds_model, sys_name, sys_contact, sys_location, sys_uptime, active_sup_slot, conn_unit_status, standby_sup_state, features_string, is_license_violation, version, is_present, serial_number, unmanagable_cause, last_scan_time, num_ports, is_trap_registered, is_syslog_registered, standby_sup_slot, module_index_offset, oper_mode, cpu_usage, mem_usage, sign, lic_details, is_vdc, vdc_id, fcoe_capable, vdc_mac, primary_ip, secondary_ip from switch";
    static final String QuerySQLByFabricID = "select id, fabric_id, wwn, ip_address, is_mds, type, is_managable, non_mds_model, sys_name, sys_contact, sys_location, sys_uptime, active_sup_slot, conn_unit_status, standby_sup_state, features_string, is_license_violation, version, is_present, serial_number, unmanagable_cause, last_scan_time, num_ports, is_trap_registered, is_syslog_registered, standby_sup_slot, module_index_offset, oper_mode, cpu_usage, mem_usage, sign, lic_details, is_vdc, vdc_id, fcoe_capable, vdc_mac, primary_ip, secondary_ip from switch where fabric_id=?";
    static final String QuerySQLByWwn = "select id, fabric_id, wwn, ip_address, is_mds, type, is_managable, non_mds_model, sys_name, sys_contact, sys_location, sys_uptime, active_sup_slot, conn_unit_status, standby_sup_state, features_string, is_license_violation, version, is_present, serial_number, unmanagable_cause, last_scan_time, num_ports, is_trap_registered, is_syslog_registered, standby_sup_slot, module_index_offset, oper_mode, cpu_usage, mem_usage, sign, lic_details, is_vdc, vdc_id, fcoe_capable, vdc_mac, primary_ip, secondary_ip from switch where wwn=?";
    static final String QuerySQLByFabricIDWwn = "select id, fabric_id, wwn, ip_address, is_mds, type, is_managable, non_mds_model, sys_name, sys_contact, sys_location, sys_uptime, active_sup_slot, conn_unit_status, standby_sup_state, features_string, is_license_violation, version, is_present, serial_number, unmanagable_cause, last_scan_time, num_ports, is_trap_registered, is_syslog_registered, standby_sup_slot, module_index_offset, oper_mode, cpu_usage, mem_usage, sign, lic_details, is_vdc, vdc_id, fcoe_capable, vdc_mac, primary_ip, secondary_ip from switch where fabric_id=? and wwn=?";
    static final String InsertSQL = "insert into switch(id, fabric_id, wwn, ip_address, is_mds, type, is_managable, non_mds_model, sys_name, sys_contact, sys_location, sys_uptime, active_sup_slot, conn_unit_status, standby_sup_state, features_string, is_license_violation, version, is_present, serial_number, unmanagable_cause, last_scan_time, last_update_time, num_ports, is_trap_registered, is_syslog_registered, standby_sup_slot, module_index_offset, oper_mode, cpu_usage, mem_usage, sign, lic_details, is_vdc, vdc_id, fcoe_capable, vdc_mac, num_1g_port, num_2g_port, num_4g_port, num_8g_port, num_10g_port, num_16g_port, num_40g_port, num_100g_port, l_report, primary_ip, secondary_ip) values(?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?,?)";
    static final String UpdateSQL = "update switch set fabric_id=?, wwn=?, ip_address=?, is_mds=?, type=?, is_managable=?, non_mds_model=?, sys_name=?, sys_contact=?, sys_location=?, sys_uptime=?, active_sup_slot=?, conn_unit_status=?, standby_sup_state=?, features_string=?, is_license_violation=?, version=?, is_present=?, serial_number=?,  unmanagable_cause=?, last_scan_time=?, last_update_time=?, num_ports=?, is_trap_registered =?,is_syslog_registered=?,standby_sup_slot=?, module_index_offset=?, oper_mode=?, cpu_usage=?, mem_usage=?, sign=?, lic_details=?, is_vdc=?, vdc_id=?, fcoe_capable=?, vdc_mac=?, num_1g_port=?, num_2g_port=?, num_4g_port=?, num_8g_port=?, num_10g_port=?, num_16g_port=?, num_40g_port=?, num_100g_port=?, l_report=?, primary_ip=?, secondary_ip=? where id=?";
    static final String QueryMgmtAddrSQLBySwitchID = "select mgmt_address, mgmt_type from switch_mgmt_address where switch_id=?";
    static final String QuerySQLByIPAddress = "select id from switch where ip_address=?";
    static final String QuerySQLByFabricIDIPAddress = "select id from switch where fabric_id=? and ip_address=?";
    static final String QueryIPAddrSQLBySwitchID = "select ip_address from switch where id=?";
    static final String QuerySwitchIDsSQLByFabricID = "select id, wwn  from switch where fabric_id=?";
    static final String ResetISECHSUPPORT = "update switch set is_ech_support = ?";
    static final String UpdateISECHSUPPORTBySwitchID = "update switch set is_ech_support =? where id=?";
    static final String isECHSUPPORTBySwitchID = "select is_ech_support from switch where id=?";
    static final String GetNoECHSwitchList = "select distinct id from switch where is_ech_support = ?";
    static final String TableName = "switch";
    public static final int DISC_SYSINFO = 1;
    public static final int DISC_FCSWINFO = 2;
    public static final int DISC_CONNUNITINFO = 4;
    public static final int DISC_FEATURES = 8;
    public static final int DISC_VSANS = 16;
    public static final int DISC_FICONVSANS = 32;
    public static final int DISC_FCPORTS = 64;
    public static final int DISC_FICONPORTS = 128;
    public static final int DISC_EVENTREG = 256;
    public static final int DISC_VIRTENCL = 512;
    public static final int DISC_PCMBRS = 1024;
    public static final int DISC_SME = 2048;
    public static final int DISC_IOA = 4096;
    public static final int DISC_CFSREGION = 8192;
    public static final int DISC_FLOGIPORT = 16384;
    public static final int DISC_VFCBIND = 32768;
    public static final int DISC_VPNINFO = 65536;
    public static final int DISC_FCSW = 97279;
    public static final int DISC_NPVSW = 16719;
    public static final int DISC_NPVSW_ALLOWED = 50511;
    public static final String[] DISC_FLAGS = new String[]{"SysInfo", "FcSwInfo", "ConnUnitInfo", "Features", "Vsans", "FiconVsans", "FcPorts", "FiconPorts", "EventReg", "VirtEncl", "PcMbrs", "SME", "IOA", "CfsRegion", "FlogiPort", "VfcBind", "VpnInfo"};
    public static final String DISC_NPV_DISABLED = "unmanaged no NPV discovery";
    private final SwitchBase _base;
    private FabricImpl _fabric;
    private SnmpPeer _peer;
    private Map<Integer, FcPortBase> _portByIfIndex = Collections.synchronizedMap(new HashMap());
    private Map<WwnKey, FcPortBase> _portByWwnKey = Collections.synchronizedMap(new HashMap());
    private boolean _hasFCoECard = false;
    private final transient Map<VsanFcIdKey, Wwn[]> _flogiQueryByVsanFcid = new ConcurrentHashMap<VsanFcIdKey, Wwn[]>();
    private final transient Map<Wwn, Set<EndPortImpl>> _pendingEps = new ConcurrentHashMap<Wwn, Set<EndPortImpl>>();
    public long _entLastChangeTime = -1L;
    public long _smeLastChangeTime;
    public long _basesvcLastChangeTime;
    private long _vsanLastChange;
    private long _fcnsTableLastChange;
    private long _statusChgTime;
    private long _cfgChgTime;
    private long _connUnitTableChgTime;
    private int _numConnUnits;
    private int _numVsanConfigured;
    private int _numLicFeatures;
    private int _numConnLinks;
    private int _numSnsEntries;
    private int _numFeModules;
    private int _daShowCfg;
    private int _ivrShowCfg;
    private String[] _mgmtAddrs;
    private int _discFlags = 97279;
    private HashMap<Long, IslImpl> _islById = new HashMap();
    private HashMap<String, NetworkInterface> hostNICCache = null;
    private boolean _assignLicenseTried = false;
    private LicenseInfo _fmServerPkgLicenseInfo = null;
    private boolean _trapRegisterTried = false;

    public static String toDiscFlagString(int flags) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < DISC_FLAGS.length; ++i) {
            if ((flags >> i & 1) == 0) continue;
            sb.append(DISC_FLAGS[i]).append(" ");
        }
        return sb.toString();
    }

    SwitchImpl(WwnKey swPK, InetAddress swIp) {
        this._base = new SwitchBase(swPK, swIp);
        if (swPK != null && WwnDictionary.isQuailWwn(swPK._wwn.getValue())) {
            this._base.setModelType(514);
            this._base.setMDS(false);
        }
    }

    @Override
    public BaseModelObject getBaseObject() {
        return this._base;
    }

    public SwitchBase getBase() {
        return this._base;
    }

    public WwnKey getSwitchPK() {
        return (WwnKey)this._base.getSwitchPK();
    }

    @Override
    public SerialNumKey getChassisKey() {
        return this._base.getChassisKey();
    }

    public FabricPK getFabricPK() {
        return this._base.getFabricPK();
    }

    @Override
    public boolean isCdpEnabled() {
        return this._base.isCdpEnabled();
    }

    public void setVdc(boolean isVdc) {
        this._base.setVdc(isVdc);
    }

    public void setVdcId(int vdcId) {
        int oldValue = this._base.getVdcId();
        if (oldValue != vdcId) {
            this._base.setVdcId(vdcId);
            this.propertyChanged((short)1071, Integer.valueOf(oldValue), Integer.valueOf(this._base.getVdcId()));
        }
    }

    public void setVdcMacAddress(MacAddress macAddr) {
        MacAddress oldValue = this._base.getVdcMacAddress();
        if (!GenUtil.equals(oldValue, macAddr)) {
            this._base.setVdcMacAddress(macAddr);
            this.propertyChanged((short)1073, oldValue, this._base.getVdcMacAddress());
        }
    }

    public void setVdcFCoECapability(short fcoeCapability) {
        short oldValue = this._base.getFCoECapability();
        if (oldValue != fcoeCapability) {
            this._base.setFCoECapability(fcoeCapability);
            this.propertyChanged((short)1072, Short.valueOf(oldValue), Short.valueOf(this._base.getFCoECapability()));
            this.updateFCoECapable();
        }
    }

    public void setFCoEFeatureSetStatus(int status) {
        AbstractSwitchBase.FeatureStatus oldValue = this._base.getFCoFeatureSetStatus();
        if (oldValue == null || oldValue.value() != status) {
            this._base.setFCoEFeatureSetStatus(status);
            this.updateFCoECapable();
        }
    }

    public void setFiconPortRange(byte[] ficonPortRange) {
        byte[] oldValue = this._base.getFiconPortRange();
        if (!Arrays.equals(oldValue, ficonPortRange)) {
            this._base.setFiconPortRange(ficonPortRange);
            this.propertyChanged((short)1076, (Serializable)oldValue, (Serializable)this._base.getFiconPortRange());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCardEthPorts() {
        List<Card> cards = InventoryManager.getInstance().findCards(this.getPK());
        if (cards != null && cards.size() > 0) {
            HashMap<Integer, HashMap<Integer, TreeSet<Integer>>> cardPorts = new HashMap<Integer, HashMap<Integer, TreeSet<Integer>>>();
            Map<Integer, FcPortBase> map = this._portByIfIndex;
            synchronized (map) {
                for (FcPortBase port : this._portByIfIndex.values()) {
                    TreeSet<Integer> ports;
                    int portSlot = IfIndexUtil.ifIndex2Card(port.getIfIndex()) + 1;
                    int ifType = IfIndexUtil.getType(port.getIfIndex());
                    if (ifType != 26 && ifType != 1) continue;
                    HashMap<Integer, TreeSet<Integer>> portByIfType = cardPorts.get(portSlot);
                    if (portByIfType == null) {
                        portByIfType = new HashMap();
                        cardPorts.put(portSlot, portByIfType);
                    }
                    if ((ports = portByIfType.get(ifType)) == null) {
                        ports = new TreeSet();
                        portByIfType.put(ifType, ports);
                    }
                    ports.add(IfIndexUtil.ifIndex2Port(port.getIfIndex()) + 1);
                }
                this._base.setCardPorts(cardPorts);
                int totalSwitchNumEthPorts = 0;
                for (int i = 0; i < cards.size(); ++i) {
                    Card card = cards.get(i);
                    int cardSlot = card.getPhysicalIndex() - 21;
                    HashMap<Integer, TreeSet<Integer>> portByIfType = cardPorts.get(cardSlot);
                    if (portByIfType == null || portByIfType.isEmpty()) continue;
                    TreeSet<Integer> ethNoNIPSPorts = portByIfType.get(26);
                    int totalEthPorts = 0;
                    if (ethNoNIPSPorts != null && ethNoNIPSPorts.size() > 0) {
                        totalEthPorts += ethNoNIPSPorts.size();
                    }
                    totalSwitchNumEthPorts += totalEthPorts;
                    InventoryManager.getInstance().updateCardEthPortNumAndPortType(card, totalEthPorts, portByIfType);
                }
                this.setNumEthPorts(totalSwitchNumEthPorts);
            }
        }
    }

    public void updateFCoECapable() {
        boolean oldValue = this._base.isFCoECapable();
        boolean fcoeCapable = this._base.isFCoECapableVersion();
        if (fcoeCapable) {
            if (this._base.isN7K()) {
                fcoeCapable = this._base.hasFCoEInstalled() && this._base.isFCoEAllowed() && this.hasFCoECard();
            } else if (!this._base.isN5K()) {
                if (this._base.isCAT()) {
                    fcoeCapable = false;
                } else if (this._base.isMDS()) {
                    boolean bl = fcoeCapable = this._base.hasFCoEInstalled() && this.hasFCoECard();
                }
            }
        }
        if (oldValue != fcoeCapable) {
            this._base.setFCoECapable(fcoeCapable);
            this.propertyChanged((short)1066, Boolean.valueOf(oldValue), Boolean.valueOf(this._base.isFCoECapable()));
        }
    }

    public void checkCards() {
        boolean oldValue = this._hasFCoECard;
        List<Card> cards = InventoryManager.getInstance().findCards(this.getPK());
        if (cards == null) {
            this._hasFCoECard = false;
        } else {
            this._hasFCoECard = false;
            int[] cardTypes = new int[FRUConstants.getNumFrontSlots(this.getBase().getModelType())];
            for (int i = 0; i < cardTypes.length; ++i) {
                cardTypes[i] = 0;
            }
            for (Card card : cards) {
                int slot = card.getSlotId();
                if (slot > 0) {
                    --slot;
                }
                if (slot >= cardTypes.length) continue;
                cardTypes[slot] = card.getType();
                if (!FRUConstants.isFCoECapableCardType(card.getType())) continue;
                this._hasFCoECard = true;
            }
            this.setCardTypes(cardTypes);
            this.updateCardEthPorts();
        }
        if (oldValue != this._hasFCoECard) {
            this.updateFCoECapable();
        }
    }

    public void setCardTypes(int[] cardTypes) {
        boolean changed;
        if (cardTypes == null) {
            return;
        }
        int[] oldValue = this._base.getCardTypeInSlots();
        boolean bl = changed = oldValue == null || cardTypes.length != oldValue.length;
        if (!changed) {
            for (int i = 0; i < cardTypes.length; ++i) {
                if (oldValue[i] == cardTypes[i]) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            this._base.setCardTypeInSlots(cardTypes);
            this.propertyChanged((short)1037, (Serializable)oldValue, (Serializable)this._base.getCardTypeInSlots());
        }
    }

    private boolean hasFCoECard() {
        return this._hasFCoECard;
    }

    @Override
    public FabricImpl getFabric() {
        return this._fabric;
    }

    public SnmpPeer getPeer() {
        if (this._peer == null) {
            try {
                this._peer = this.createPeer();
            }
            catch (SnmpException e) {
                _Logger.debug((Object)e.getMessage());
            }
        }
        return this._peer;
    }

    public SnmpPeer getPeerWithoutCreate() {
        return this._peer;
    }

    public PlatformType getPlatformType() {
        return this._base.getPlatformType();
    }

    public List<FcPortBase> getPorts() {
        ArrayList<FcPortBase> ports = new ArrayList<FcPortBase>();
        ports.addAll(this._portByIfIndex.values());
        return ports;
    }

    public void setFabric(FabricImpl fabric) {
        if (this._fabric == fabric) {
            if (this._fabric != null && this._fabric.findSwitchByDbId(this.getDBID()) == null) {
                this._fabric.addSwitch(this);
            }
        } else {
            FabricPK oldKey = this._base.getFabricPK();
            FabricPK newKey = fabric == null ? null : fabric.getPK();
            this._base.setFabricPK(newKey);
            if (this._fabric != null && fabric == null) {
                this._fabric.removeSwitch(this);
                this._fabric.modelObjectChanged(this._base.getPK(), (short)1026, oldKey, newKey);
            } else if (this._fabric == null && fabric != null) {
                fabric.addSwitch(this);
                fabric.modelObjectChanged(this._base.getPK(), (short)1026, oldKey, newKey);
            } else if (this._fabric != fabric) {
                throw new IllegalStateException("SwitchImpl object cannot directly migrate from one fabric to another by setFabric()");
            }
            this._fabric = fabric;
        }
    }

    @Override
    public boolean setPresent(boolean isPresent) {
        boolean wasPresent = this._base.isPresent();
        if (wasPresent ^ isPresent) {
            this._base.setPresent(isPresent);
            this.propertyChanged((short)1025, Boolean.valueOf(wasPresent), Boolean.valueOf(isPresent));
            if (_Logger.isTraceEnabled()) {
                _Logger.trace((Object)("SwitchImpl trace setPresent: old=" + wasPresent + "-->new=" + isPresent + " for " + this), (Throwable)new Exception("TraceLogger"));
            }
        }
        if (!isPresent) {
            if (this._fabric.getIvrSeed() == this) {
                this._fabric.setIvrSeed(null);
            }
            if (this._fabric.getAliasSeed() == this) {
                this._fabric.selectAliasSeed();
            }
            if (wasPresent) {
                this._fcnsTableLastChange = 0L;
            }
        }
        return wasPresent;
    }

    public Wwn getWwn() {
        return this._base.getWwn();
    }

    public void setWwn(Wwn wwn) {
        if (this._base.getWwn() == null) {
            this._base.setWwn(wwn);
            SanManager.getInstance().addSwitchByPK(this);
            if (WwnDictionary.isQuailWwn(wwn.getValue())) {
                this.setModelType(514);
            }
        }
    }

    public Wwn getVsanWwn(short vsanId) {
        return this._base.getVsanWwn(vsanId);
    }

    public void addNewOUI(WwnVendor v) {
        if (v == null) {
            return;
        }
        this.propertyChanged((short)1070, null, v);
    }

    public String getSysName() {
        return this._base.getSysName();
    }

    public void setSysName(String newSysName) {
        String oldSysName;
        if (SnmpAdapter.TrimDomain && newSysName != null) {
            newSysName = GenUtil.trimDomain(newSysName);
        }
        if (!GenUtil.equals(oldSysName = this._base.getSysName(), newSysName)) {
            this._base.setSysName(newSysName);
            this.propertyChanged((short)1027, (Serializable)((Object)oldSysName), (Serializable)((Object)newSysName));
        }
    }

    public void setSysDescr(String newSysDescr) {
        String oldSysDescr = this._base.getSysDescr();
        if (!GenUtil.equals(oldSysDescr, newSysDescr)) {
            int pos;
            this._base.setSysDescr(newSysDescr);
            this.propertyChanged((short)1052, (Serializable)((Object)oldSysDescr), (Serializable)((Object)newSysDescr));
            if (this._base.getVendor().equals("Cisco")) {
                int pos1 = newSysDescr.indexOf("Interim version");
                if (pos1 != -1) {
                    pos1 += 16;
                } else {
                    pos1 = newSysDescr.indexOf("Version");
                    if (pos1 == -1) {
                        return;
                    }
                    pos1 += 8;
                }
                int pos2 = newSysDescr.indexOf(44, pos1);
                String version = newSysDescr.substring(pos1, pos2 != -1 ? pos2 : newSysDescr.length()).trim();
                if (version != null && version.length() != 0) {
                    this.setVersion(version);
                }
            } else if (this._base.getVendor().equals("McData")) {
                int end;
                int pos2 = newSysDescr.indexOf("firmware");
                if (pos2 != -1) {
                    this.setVersion(newSysDescr.substring(pos2 + 9));
                }
                if ((pos2 = newSysDescr.indexOf(32)) != -1 && (end = newSysDescr.indexOf("Fibre", pos2 + 1)) != -1) {
                    this.setModelName(newSysDescr.substring(0, end - 1));
                }
            } else if (this._base.getVendor().equals("QLogic") && (pos = newSysDescr.indexOf("FC Switch")) != -1) {
                this.setModelName(newSysDescr.substring(0, pos - 1));
            }
        }
    }

    public void setSysObjectID(int[] objectId) {
        if (objectId == null || objectId.length == 0) {
            return;
        }
        byte[] objId = new byte[objectId.length];
        for (int i = 0; i < objectId.length; ++i) {
            objId[i] = (byte)objectId[i];
        }
        this._base.setSysObjectId(objId);
    }

    public void setContact(String newSysContact) {
        String oldSysContact = this._base.getSysContact();
        if (!GenUtil.equals(oldSysContact, newSysContact)) {
            this._base.setSysContact(newSysContact);
            this.propertyChanged((short)1028, (Serializable)((Object)oldSysContact), (Serializable)((Object)newSysContact));
        }
    }

    public void setLocation(String newSysLocation) {
        String oldSysLocation = this._base.getSysLocation();
        if (!GenUtil.equals(oldSysLocation, newSysLocation)) {
            this._base.setSysLocation(newSysLocation);
            this.propertyChanged((short)1029, (Serializable)((Object)oldSysLocation), (Serializable)((Object)newSysLocation));
        }
    }

    public boolean isManageTimeOut() {
        String str = this._base.getUnmanageableCause();
        return str != null && str.indexOf("timeout") != -1;
    }

    public String getUnmanageableCause() {
        return this._base.getUnmanageableCause();
    }

    @Override
    public long getSysUpTime() {
        return this._base.getSysUpTime();
    }

    public void setSysUpTime(long upTime) {
        if (this._base.isMDS() && this._base.isVersionGreaterThan("3.2(0)")) {
            return;
        }
        if (Math.abs(this._base.getSysUpTime() - upTime) > (long)(this._peer != null ? this._peer.getTimeout() / 10 : 1000)) {
            long oldTime = this._base.getSysLastBootTime();
            long newTime = upTime == 0L ? 0L : System.currentTimeMillis() - upTime * 10L;
            this._base.setSysLastBootTime(newTime);
            this.propertyChanged((short)1030, new Long(oldTime), new Long(newTime));
        }
    }

    public void setSysCpuUsage(int usage) {
        this._base.setSysCpuUsage(usage);
    }

    public void setSysMemoryUsage(int usage) {
        this._base.setSysMemoryUsage(usage);
    }

    public long getSysLastBootTime() {
        return this._base.getSysLastBootTime();
    }

    public void setSysLastBootTime(long time) {
        long oldTime = this._base.getSysLastBootTime();
        if (Math.abs(oldTime - time) > 5000L) {
            this._base.setSysLastBootTime(time);
            this.propertyChanged((short)1030, new Long(oldTime), new Long(time));
        }
    }

    public void setSwitchLastBootTime(long time) {
        long oldTime = this._base.getSwitchLastBootTime();
        if (Math.abs(oldTime - time) > 5000L) {
            this._base.setSwitchLastBootTime(time);
            this.propertyChanged((short)1069, new Long(oldTime), new Long(time));
        }
    }

    public boolean isTrapRegistered() {
        return this._base.isTrapRegistered();
    }

    @Override
    public void setTrapRegistered(boolean b) {
        if (b ^ this._base.isTrapRegistered()) {
            this._base.setTrapRegistered(b);
            this.propertyChanged((short)1048, Boolean.valueOf(!b), Boolean.valueOf(b));
        }
    }

    public void setSyslogRegistered(boolean b) {
        if (b ^ this._base.isSyslogRegistered()) {
            this._base.setSyslogRegistered(b);
            this.propertyChanged((short)1049, Boolean.valueOf(!b), Boolean.valueOf(b));
        }
    }

    public void setTelnetEnabled(boolean b) {
        if (b ^ this._base.isTelnetEnabled()) {
            this._base.setTelnetEnabled(b);
            this.propertyChanged((short)1055, Boolean.valueOf(!b), Boolean.valueOf(b));
        }
    }

    public void setDelayLinkEnabled(boolean b) {
        if (b ^ this._base.isDelayLinkEnabled()) {
            this._base.setDelayLinkEnabled(b);
            this.propertyChanged((short)1067, Boolean.valueOf(!b), Boolean.valueOf(b));
        }
    }

    public void setSSHEnabled(boolean b) {
        if (b ^ this._base.isSSHEnabled()) {
            this._base.setSSHEnabled(b);
            this.propertyChanged((short)1057, Boolean.valueOf(!b), Boolean.valueOf(b));
        }
    }

    public int getType(int ifIndex) {
        return this._base.getType(ifIndex);
    }

    @Override
    public String getVersion() {
        return this._base.getVersion();
    }

    public void setVersion(String newVersion) {
        String oldVersion = this._base.getVersion();
        if (!GenUtil.equals(oldVersion, newVersion)) {
            this._base.setVersion(newVersion);
            this.propertyChanged((short)1031, (Serializable)((Object)oldVersion), (Serializable)((Object)newVersion));
            InventoryManager.getInstance().poll(this.getSwitchPK(), 31);
            if (this._base.getVendor().equals("Brocade") && newVersion.length() > 1) {
                switch (newVersion.charAt(1)) {
                    case '2': {
                        this.setModelName("2xx0");
                        break;
                    }
                    case '3': {
                        this.setModelName("3200/3800");
                        break;
                    }
                    case '4': {
                        this.setModelName("3900/12000");
                        break;
                    }
                    case '5': {
                        this.setModelName("3900-48000");
                        break;
                    }
                    case '6': {
                        this.setModelName("3900-48000");
                        break;
                    }
                    default: {
                        this.setModelName(null);
                    }
                }
            }
            if (PlatformType.isTypeOf(this._base.getPlatformType(), PlatformType.FCOE)) {
                this.updateFCoECapable();
            }
        }
    }

    public void setFcFeModuleId(int id) {
        if (this._base.getFcFeModuleId() != id) {
            Integer old = new Integer(this._base.getFcFeModuleId());
            this._base.setFcFeModuleId(id);
            this.propertyChanged((short)1053, old, new Integer(id));
        }
    }

    public void setPlatform(PlatformType platform) {
        this._base.setPlatformType(platform);
    }

    @Override
    public int getModuleIndexOffset() {
        return this._base.getModuleIndexOffset();
    }

    public void setModuleIndexOffset(int offset) {
        if (this._base.getModuleIndexOffset() != offset) {
            Integer old = new Integer(this._base.getModuleIndexOffset());
            this._base.setModuleIndexOffset(offset);
            this.propertyChanged((short)1054, old, new Integer(offset));
        }
    }

    public String getSerialNumber() {
        return this._base.getSerialNumber();
    }

    public void setSerialNumber(String serialNum) {
        String oldNum = this._base.getSerialNumber();
        if (!GenUtil.equals(oldNum, serialNum)) {
            this._base.setSerialNumber(serialNum);
            this.propertyChanged((short)1032, (Serializable)((Object)oldNum), (Serializable)((Object)serialNum));
        }
    }

    public void setNumEthPorts(int numPorts) {
        if (this._base.getNumEthPorts() != numPorts) {
            Integer oldNum = new Integer(this._base.getNumEthPorts());
            this._base.setNumEthPorts(numPorts);
            this.propertyChanged((short)1064, oldNum, new Integer(numPorts));
        }
    }

    public void setNumFcPorts(int numPorts) {
        if (this._base.getNumFcPorts() != numPorts) {
            Integer oldNum = new Integer(this._base.getNumFcPorts());
            this._base.setNumFcPorts(numPorts);
            this.propertyChanged((short)1033, oldNum, new Integer(numPorts));
        }
    }

    public int getNum1gPort() {
        return this._base.getNum1gPorts();
    }

    public void setNum1gPorts(int num1gPorts) {
        if (this._base.getNum1gPorts() != num1gPorts) {
            Integer oldNum = new Integer(this._base.getNum1gPorts());
            this._base.setNum1gPorts(num1gPorts);
        }
    }

    public int getNum2gPort() {
        return this._base.getNum2gPorts();
    }

    public void setNum2gPorts(int num2gPorts) {
        if (this._base.getNum2gPorts() != num2gPorts) {
            Integer oldNum = new Integer(this._base.getNum2gPorts());
            this._base.setNum2gPorts(num2gPorts);
        }
    }

    public int getNum4gPort() {
        return this._base.getNum4gPorts();
    }

    public void setNum4gPorts(int num4gPorts) {
        if (this._base.getNum4gPorts() != num4gPorts) {
            Integer oldNum = new Integer(this._base.getNum4gPorts());
            this._base.setNum4gPorts(num4gPorts);
        }
    }

    public int getNum8gPort() {
        return this._base.getNum8gPorts();
    }

    public void setNum8gPorts(int num8gPorts) {
        if (this._base.getNum8gPorts() != num8gPorts) {
            Integer oldNum = new Integer(this._base.getNum8gPorts());
            this._base.setNum8gPorts(num8gPorts);
        }
    }

    public int getNum10gPort() {
        return this._base.getNum10gPorts();
    }

    public void setNum10gPorts(int num10gPorts) {
        if (this._base.getNum10gPorts() != num10gPorts) {
            Integer oldNum = new Integer(this._base.getNum10gPorts());
            this._base.setNum10gPorts(num10gPorts);
        }
    }

    public int getNum16gPort() {
        return this._base.getNum16gPorts();
    }

    public void setNum16gPorts(int num16gPorts) {
        if (this._base.getNum16gPorts() != num16gPorts) {
            Integer oldNum = new Integer(this._base.getNum16gPorts());
            this._base.setNum16gPorts(num16gPorts);
        }
    }

    public int getNum40gPort() {
        return this._base.getNum40gPorts();
    }

    public void setNum40gPorts(int num40gPorts) {
        if (this._base.getNum40gPorts() != num40gPorts) {
            Integer oldNum = new Integer(this._base.getNum40gPorts());
            this._base.setNum40gPorts(num40gPorts);
        }
    }

    public int getNum100gPort() {
        return this._base.getNum100gPorts();
    }

    public void setNum100gPorts(int num100gPorts) {
        if (this._base.getNum100gPorts() != num100gPorts) {
            Integer oldNum = new Integer(this._base.getNum100gPorts());
            this._base.setNum100gPorts(num100gPorts);
        }
    }

    @Override
    public String getName() {
        String name = this._base.getSysName();
        if (name != null && name.length() != 0) {
            return name;
        }
        if (this._peer != null) {
            return this._peer.toString();
        }
        if (this._base.getIpAddress() != null) {
            return this._base.getIpAddress();
        }
        return this._base.getWwn() == null ? "" : this._base.getWwn().toString();
    }

    public boolean isMDS() {
        return this._base.isMDS();
    }

    public boolean isBrocade() {
        return this._base.isBrocade();
    }

    public boolean isN5K() {
        return this._base.isN5K();
    }

    public boolean isN6K() {
        return this._base.isN6K();
    }

    public boolean isN7K() {
        return this._base.isN7K();
    }

    public boolean isFCoEEnabled() {
        return this._base.isFCoEEnabled();
    }

    public boolean isFCoECapable() {
        return this._base.isFCoECapable();
    }

    public boolean isUCS() {
        return this._base.isUCS();
    }

    public boolean isMDSOrQuail() {
        return this._base.isMDSOrQuail();
    }

    public void setMDS(boolean isMDS) {
        boolean wasMDS = this._base.isMDS();
        if (wasMDS != isMDS) {
            this._base.setMDS(isMDS);
            this.propertyChanged((short)1034, Boolean.valueOf(wasMDS), Boolean.valueOf(isMDS));
        }
    }

    public boolean isQuail() {
        return this._base.isQuail();
    }

    public boolean isManageableMDS() {
        return this._base.isManageableMDS();
    }

    public String getVendor() {
        return this._base.getVendor();
    }

    public void setVendor(String vendor) {
        String old = this._base.getVendor();
        if (vendor != old) {
            this._base.setVendor(vendor);
        }
    }

    public int getModelType() {
        return this._base.getModelType();
    }

    public void setModelType(int newType) {
        int oldType = this._base.getModelType();
        if (oldType != newType) {
            this._base.setModelType(newType);
            this.propertyChanged((short)1035, new Integer(oldType), new Integer(newType));
        }
    }

    public void setModelName(String newModel) {
        String oldModel = this._base.getModelName();
        if (!GenUtil.equals(oldModel, newModel)) {
            this._base.setModelName(newModel);
            this.propertyChanged((short)1036, (Serializable)((Object)oldModel), (Serializable)((Object)newModel));
        }
    }

    public int getNumSlots() {
        return this._base.getNumSlots();
    }

    public int getActiveSupSlot() {
        return this._base.getActiveSupSlot();
    }

    public int getActiveSupPhysicalIndex() {
        return this._base.getActiveSupPhysicalIndex();
    }

    public boolean setActiveSupPhysicalIndex(int newPhyIndex) {
        int oldPhyIndex = this._base.getActiveSupPhysicalIndex();
        if (oldPhyIndex != newPhyIndex) {
            Card preActiveCard;
            this._base.setActiveSupPhysicalIndex(newPhyIndex);
            Card activeCard = InventoryManager.getInstance().findCardByPhysicalIndex(this.getSwitchPK(), newPhyIndex);
            if (activeCard != null) {
                activeCard.setActive(true);
            }
            if ((preActiveCard = InventoryManager.getInstance().findCardByPhysicalIndex(this.getSwitchPK(), oldPhyIndex)) != null) {
                preActiveCard.setActive(false);
            }
            this.propertyChanged((short)1042, new Integer(oldPhyIndex), new Integer(newPhyIndex));
            return true;
        }
        return false;
    }

    public int getStandbySupSlot() {
        return this._base.getStandbySupSlot();
    }

    public void setStandbySupSlot(int newSlotNum) {
        int oldSlotNum = this._base.getStandbySupSlot();
        if (oldSlotNum != newSlotNum) {
            this._base.setStandbySupSlot(newSlotNum);
            this.propertyChanged((short)1043, new Integer(oldSlotNum), new Integer(newSlotNum));
        }
    }

    @Override
    public String getIpAddress() {
        return this._base.getIpAddress();
    }

    @Override
    public InetAddress getInetAddress() {
        return this._base.getInetAddress();
    }

    public void setManagementAddressInUse(InetAddress newAddr) {
        if (!GenUtil.equals(this._base.getInetAddress(), newAddr)) {
            InetAddress oldAddr = this._base.getInetAddress();
            this._base.setManagementAddressInUse(newAddr);
            if (_Logger.isTraceEnabled()) {
                _Logger.trace((Object)("setManagementAddressInUse: update management IP of switch '" + this.getName() + "' with '" + newAddr + "'"));
            }
            this.propertyChanged((short)1041, oldAddr, newAddr);
        }
    }

    @Override
    public InetAddress[] getManagementAddresses() {
        return this._base.getManagementAddresses();
    }

    public void setManagementAddresses(InetAddress[] newAddrs) {
        Object[] oldAddrs;
        if (newAddrs != null && newAddrs.length > 1) {
            Arrays.sort(newAddrs, NetUtil._InetAddrComparator);
        }
        if (!Arrays.equals(oldAddrs = this._base.getManagementAddresses(), newAddrs)) {
            InetAddress oldAddrInUse = this._base.getInetAddress();
            this._base.setManagementAddresses(newAddrs);
            if (_Logger.isTraceEnabled()) {
                _Logger.trace((Object)("setManagementAddresses: update management IP of switch '" + this.getName() + "' with '" + Arrays.asList(newAddrs) + "'"));
            }
            this.propertyChanged((short)1040, (Serializable)oldAddrs, (Serializable)newAddrs);
            SanManager.getInstance().switchIpChanged(this, (InetAddress[])oldAddrs, newAddrs);
            if (oldAddrInUse == null || GenUtil.linearSearch(newAddrs, oldAddrInUse) < 0 || !this.isManageable()) {
                this.selectManagementAddress();
            }
        }
    }

    public InetAddress[] getVsanIps() {
        int max;
        short[] vids = this._base.getVsanIds();
        ArrayList<InetAddress> l = new ArrayList<InetAddress>(5);
        int n = max = vids != null ? vids.length : 0;
        for (int i = 0; i < max; ++i) {
            InetAddress vip = this._base.getVsanIp(vids[i]);
            if (vip == null) continue;
            l.add(vip);
        }
        return l.size() != 0 ? l.toArray(new InetAddress[l.size()]) : null;
    }

    public void setVsanIp(short vid, InetAddress newAddr) {
        InetAddress oldAddr = this._base.getVsanIp(vid);
        if (oldAddr == null || newAddr instanceof Inet4Address && oldAddr instanceof Inet6Address) {
            this._base.setVsanIp(vid, newAddr);
            if (!this.isManageable()) {
                this.selectManagementAddress();
            }
        }
    }

    public InetAddress[] getAllAddresses() {
        InetAddress[] mgmtAddrs = this.getManagementAddresses();
        InetAddress[] vsanIps = this.getVsanIps();
        if (mgmtAddrs == null || mgmtAddrs.length == 0) {
            if (vsanIps == null || vsanIps.length == 0) {
                return null;
            }
            return vsanIps;
        }
        if (vsanIps == null || vsanIps.length == 0) {
            return mgmtAddrs;
        }
        InetAddress[] addrs = new InetAddress[mgmtAddrs.length + vsanIps.length];
        System.arraycopy(mgmtAddrs, 0, addrs, 0, mgmtAddrs.length);
        System.arraycopy(vsanIps, 0, addrs, mgmtAddrs.length, vsanIps.length);
        return addrs;
    }

    private void selectManagementAddress() {
        Object[] addrs = this.getAllAddresses();
        if (addrs == null || addrs.length == 0) {
            this.setManagementAddressInUse(null);
            if (this._peer != null) {
                SnmpPeer.removePeer(this._peer);
                this.setManageable(false, "noMgmtAddr");
            }
            this._peer = null;
            return;
        }
        if (this._peer == null) {
            Object addr = null;
            for (int i = 0; i < addrs.length; ++i) {
                if (addrs[i].isLinkLocalAddress() || ((InetAddress)addrs[i]).isMulticastAddress() || addr != null && (!(addrs[i] instanceof Inet4Address) || !(addr instanceof Inet6Address))) continue;
                addr = addrs[i];
            }
            if (addr != null) {
                this.setManagementAddressInUse((InetAddress)addr);
            }
        } else {
            try {
                SnmpPeer peer = this.createPeer((InetAddress[])addrs);
                SnmpPeer.addPeer(peer);
                SnmpPeer.removePeer(this._peer);
                this._peer = peer;
                this.setManagementAddressInUse(peer.getAddress());
                this.setManageable(true, null);
            }
            catch (SnmpException se) {
                if (!this.isManageable() || GenUtil.linearSearch(addrs, this._peer.getAddress()) < 0) {
                    SnmpPeer.removePeer(this._peer);
                    this._peer = null;
                }
                this.setManageable(false, se.getMessage());
            }
        }
    }

    public boolean isManageable() {
        return this._base.isManageable();
    }

    public void setManageable(boolean isManageable, String cause) {
        if (this._base.isManageable() ^ isManageable) {
            this._base.setManageable(isManageable);
            this.propertyChanged((short)1038, Boolean.valueOf(!isManageable), Boolean.valueOf(isManageable));
        }
        if (!GenUtil.equals(this._base.getUnmanageableCause(), cause)) {
            this._base.setUnmanageableCause(cause);
            if (cause != null) {
                this.propertyChanged((short)1039, null, (Serializable)((Object)cause));
            }
        }
        if (!isManageable) {
            VsanDomain[] vdKeys;
            if (this._fabric != null && this._fabric.getIvrSeed() == this) {
                this._fabric.setIvrSeed(null);
            }
            if (this._fabric != null && this._fabric.getAliasSeed() == this) {
                this._fabric.selectAliasSeed();
            }
            if ((vdKeys = this._base.getVsanDomains()) != null && this._fabric != null) {
                for (int i = 0; i < vdKeys.length; ++i) {
                    VsanImpl v = this._fabric.findVsan(vdKeys[i]._vsanPK);
                    if (v == null || v.getFcAliasSeed() != this) continue;
                    v.reselectFcAliasSeed();
                }
            }
        }
    }

    public int getStandbySupState() {
        return this._base.getStandbySupState();
    }

    public void setStandbySupState(int newState) {
        int oldState = this._base.setStandbySupState(newState);
        if (oldState != newState) {
            this.propertyChanged((short)1044, new Integer(oldState), new Integer(newState));
        }
    }

    public void setConnUnitStatus(int newStatus) {
        int oldStatus = this._base.setConnUnitStatus(newStatus);
        if (oldStatus != newStatus) {
            this.propertyChanged((short)1045, new Integer(oldStatus), new Integer(newStatus));
        }
    }

    public void setIsLicenseViolation(boolean violation) {
        if (this._base.isLicenseViolation() != violation) {
            this._base.setLicenseViolation(violation);
            this.propertyChanged((short)1050, Boolean.valueOf(!violation), Boolean.valueOf(violation));
        }
    }

    public boolean isVersionGreaterThanEqual(String version) {
        return this._base.isVersionGreaterThanEqual(version);
    }

    public boolean isVersionGreaterThan(String version) {
        return this._base.isVersionGreaterThan(version);
    }

    public boolean isVersionEqual(String version) {
        return this._base.isVersionEqual(version);
    }

    public boolean isFabricSeed() {
        return this._fabric.getSeed() == this;
    }

    public boolean isAliasSeed() {
        return this._fabric.getAliasSeed() == this;
    }

    public boolean isIvrSeed() {
        return this._fabric.getIvrSeed() == this;
    }

    public boolean isIvrEnabled() {
        return this._base.isIvrEnabled();
    }

    public boolean isNpvEnabled() {
        return this._base.isNpvEnabled();
    }

    public boolean isDelayLinkEnabled() {
        return this._base.isDelayLinkEnabled();
    }

    public boolean isCfsFeatureEnabled() {
        return this._base.isCfsFeatureEnabled();
    }

    public boolean isFeatureEnabled(int featureFlag) {
        return this._base.isFeatureEnabled(featureFlag);
    }

    public void setFeatureFlags(boolean[] flags) {
        boolean[] oldFlags = this._base.getFeatureFlags();
        if (!Arrays.equals(oldFlags, flags)) {
            this._base.setFeatureFlags(flags);
            this.propertyChanged((short)1046, (Serializable)oldFlags, (Serializable)flags);
            if (oldFlags[AbstractSwitchBase.Feature.FICON.flag()] && !flags[AbstractSwitchBase.Feature.FICON.flag()]) {
                VsanDomain[] vdks = this._base.getVsanDomains();
                if (vdks != null) {
                    for (int i = 0; i < vdks.length; ++i) {
                        VsanImpl vsan = this._fabric.findVsan(vdks[i]._vsanPK);
                        if (vsan == null) continue;
                        vsan.setFiconState((byte)0);
                    }
                }
            } else if (!oldFlags[AbstractSwitchBase.Feature.FICON.flag()] && flags[AbstractSwitchBase.Feature.FICON.flag()]) {
                this.setDiscFlag(128);
            } else if (!oldFlags[AbstractSwitchBase.Feature.NPV.flag()] && !oldFlags[AbstractSwitchBase.Feature.FCOENPV.flag()] && (flags[AbstractSwitchBase.Feature.NPV.flag()] || flags[AbstractSwitchBase.Feature.FCOENPV.flag()]) || this.isDiscFlagSet(16) && (flags[AbstractSwitchBase.Feature.NPV.flag()] || flags[AbstractSwitchBase.Feature.FCOENPV.flag()])) {
                this._discFlags = 16719;
            } else if ((oldFlags[AbstractSwitchBase.Feature.NPV.flag()] || oldFlags[AbstractSwitchBase.Feature.FCOENPV.flag()]) && !flags[AbstractSwitchBase.Feature.NPV.flag()] && !flags[AbstractSwitchBase.Feature.FCOENPV.flag()]) {
                this._discFlags = 97279;
            }
        }
        if (this._base.isIvrEnabled()) {
            if (this._base.isManageable() && (this._fabric.getIvrSeed() == null || this._base.isVersionGreaterThan(this._fabric.getIvrSeed().getVersion()))) {
                this._fabric.setIvrSeed(this);
            }
        } else if (this._fabric.getIvrSeed() == this) {
            this._fabric.setIvrSeed(this._fabric.selectIvrSeed());
        }
    }

    public void setFeatureEnabled(int feature, boolean enabled) {
        if (feature < 0 || feature > SwitchBase.NUM_FEATURES - 1) {
            _Logger.warn((Object)("invalid feature " + feature));
            return;
        }
        boolean[] oldFlags = this._base.getFeatureFlags();
        this._base.setFeatureFlag(feature, enabled);
        boolean[] flags = this._base.getFeatureFlags();
        if (!Arrays.equals(oldFlags, flags)) {
            this.propertyChanged((short)1046, (Serializable)oldFlags, (Serializable)flags);
        }
    }

    public boolean isMemberOfVsan(short vsanId) {
        return this._base.isMemberOfVsan(vsanId);
    }

    public int getNumVsans() {
        return this._base.getNumVsans();
    }

    public short[] getVsanIds() {
        Collection<Short> list = this._base.getVsanMembership();
        short[] vids = new short[list.size()];
        int i = 0;
        for (short vid : list) {
            vids[i++] = vid;
        }
        return vids;
    }

    public Collection<Short> getVsanMembership() {
        return this._base.getVsanMembership();
    }

    public Map<Short, VsanImpl> getVsans() {
        HashMap<Short, VsanImpl> hash = new HashMap<Short, VsanImpl>(this._base.getNumVsans());
        Collection<Short> list = this._base.getVsanMembership();
        for (short vid : list) {
            VsanImpl v = this.getVsan(vid);
            if (v == null) continue;
            hash.put(vid, v);
        }
        return hash;
    }

    public void addVsan(VsanImpl vsan, short domainId, Wwn vwwn) {
        VsanDomain oldVdid;
        VsanDomain newVdid = new VsanDomain(vsan.getVsanPK(), domainId, vwwn);
        if (newVdid != (oldVdid = this._base.addVsan(newVdid))) {
            VsanImpl v;
            this.propertyChanged((short)1047, oldVdid, newVdid);
            if (oldVdid != null && !oldVdid._vsanPK.equals(newVdid._vsanPK) && (v = this._fabric.findVsan(oldVdid._vsanPK)) != null) {
                if (this.isNpvEnabled() && vsan.getId() == v.getId() && vsan.isSegmented() && v.isSegmented()) {
                    _Logger.info((Object)(this + " is in the segmented vsans: " + vsan + "," + v));
                } else {
                    _Logger.debug((Object)(this + " is removed from vsan: " + v + ", new vsan is " + vsan));
                    v.removeSwitch(this);
                }
            }
        }
    }

    void removeVsan(VsanImpl vsan) {
        VsanDomain vd;
        if (this._base.getVsanDomain(vsan.getId()) != null && vsan.getVsanPK() == this._base.getVsanDomain((short)vsan.getId())._vsanPK && (vd = this._base.removeVsan(vsan.getId())) != null) {
            this.propertyChanged((short)1047, vd, null);
        }
    }

    public boolean hasFiconVsan() {
        VsanDomain[] vdkeys = this._base.getVsanDomains();
        if (vdkeys != null) {
            for (int i = 0; i < vdkeys.length; ++i) {
                VsanImpl vsan = this._fabric.findVsan(vdkeys[i]._vsanPK);
                if (vsan == null || !vsan.isFicon()) continue;
                return true;
            }
        }
        return false;
    }

    public VsanImpl getVsan(short vid) {
        VsanPK vpk = this._base.getVsanPK(vid);
        return vpk == null ? null : this._fabric.findVsan(vpk);
    }

    public int getDomainId(short vid) {
        return this._base.getDomainId(vid);
    }

    public VsanDomain[] getVsanDomains() {
        return this._base.getVsanDomains();
    }

    public VsanDomain getVsanDomain(short vsanId) {
        return this._base.getVsanDomain(vsanId);
    }

    public ArrayList<Integer> getCfsRegionIds() {
        return this._base.getCfsRegionIds();
    }

    public InetAddress getVsanIp(short vsanId) {
        return this._base.getVsanIp(vsanId);
    }

    public byte[] getFiconPortRange() {
        return this._base.getFiconPortRange();
    }

    public SwitchImpl findNeighborSwitch(short vid, int domainId) {
        VsanImpl vsan = this.getVsan(vid);
        return vsan != null ? vsan.findSwitchByDomainId(domainId) : null;
    }

    public Wwn getPrincipalSwitchWwn(short vsanId) {
        VsanImpl v = this.getVsan(vsanId);
        return v != null ? v.getPrincipalSwitchWwn() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FcPortBase addPort(FcPortBase port) {
        if (port == null) {
            return null;
        }
        FcPortBase oldPort = null;
        Map<Integer, FcPortBase> map = this._portByIfIndex;
        synchronized (map) {
            oldPort = this._portByIfIndex.get(port.getIfIndex());
            this._portByIfIndex.put(port.getIfIndex(), port);
        }
        return oldPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FcPortBase createPort(int ifindex) {
        FcPortBase port;
        Map<Integer, FcPortBase> map = this._portByIfIndex;
        synchronized (map) {
            port = this._portByIfIndex.get(ifindex);
            if (port == null) {
                port = new FcPortBase((WwnKey)this._base.getSwitchPK(), ifindex);
                port.setIfname(this.ifIndexToName(ifindex));
                port.setPhysical(this._base.isIfPhysical(ifindex));
                this._portByIfIndex.put(ifindex, port);
            }
        }
        return port;
    }

    public FcPortBase removePort(int ifindex) {
        FcPortBase port = this._portByIfIndex.remove(ifindex);
        if (port != null && port.getFWwn() != null) {
            this._portByWwnKey.remove(port.getFWwn());
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FcPortBase createPort(WwnKey fwwn, int ifindex) {
        FcPortBase port = null;
        Map<WwnKey, FcPortBase> map = this._portByWwnKey;
        synchronized (map) {
            if (fwwn != null) {
                port = this._portByWwnKey.get(fwwn);
            }
            if (port == null) {
                port = this.createPort(ifindex);
                if (fwwn != null) {
                    this._portByWwnKey.put(fwwn, port);
                }
            }
        }
        return port;
    }

    public void removePort(WwnKey fwwn) {
        this._portByWwnKey.remove(fwwn);
    }

    public List<FcPortBase> getAllPorts() {
        return new ArrayList<FcPortBase>(this._portByIfIndex.values());
    }

    @Override
    public String ifIndexToName(int ifIndex) {
        return this._base.ifIndexToName(ifIndex);
    }

    public int fspfPortIndexToIfIndex(int portIndex) {
        if (this._base.isMDS()) {
            return IfIndexUtil.fspfPortIndexToIfIndex(portIndex);
        }
        if (this._base.isQuail()) {
            return IfIndexUtil.nameToIfIndex(1, portIndex + 1, 1);
        }
        return portIndex;
    }

    public FcPortBase findPort(int ifindex) {
        return this._portByIfIndex.get(ifindex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FcPortBase> findPortChannelPorts() {
        ArrayList<FcPortBase> pcports = new ArrayList<FcPortBase>();
        Map<Integer, FcPortBase> map = this._portByIfIndex;
        synchronized (map) {
            for (FcPortBase port : this._portByIfIndex.values()) {
                if (IfIndexUtil.getType(port.getIfIndex()) != 4) continue;
                pcports.add(port);
            }
        }
        return pcports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FcPortBase> findGigaEthPorts() {
        ArrayList<FcPortBase> gEports = new ArrayList<FcPortBase>();
        Map<Integer, FcPortBase> map = this._portByIfIndex;
        synchronized (map) {
            for (FcPortBase port : this._portByIfIndex.values()) {
                if (port.getIfType() != 117 && port.getIfType() != 135 || !port.getIfname().startsWith("Gig") && !port.getIfname().startsWith("IPStorage")) continue;
                gEports.add(port);
            }
        }
        return gEports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FcPortBase> findMgmtPorts() {
        ArrayList<FcPortBase> mgmtPorts = new ArrayList<FcPortBase>();
        Map<Integer, FcPortBase> map = this._portByIfIndex;
        synchronized (map) {
            for (FcPortBase port : this._portByIfIndex.values()) {
                if (port.getIfType() != 6 && port.getIfType() != 62 || !port.getIfname().startsWith("mgmt")) continue;
                mgmtPorts.add(port);
            }
        }
        return mgmtPorts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FcPortBase> findFcPorts() {
        ArrayList<FcPortBase> gFcports = new ArrayList<FcPortBase>();
        Map<Integer, FcPortBase> map = this._portByIfIndex;
        synchronized (map) {
            for (FcPortBase port : this._portByIfIndex.values()) {
                if (port.getIfType() != 56 || IfIndexUtil.getType(port.getIfIndex()) != 1 && IfIndexUtil.getType(port.getIfIndex()) != 30) continue;
                gFcports.add(port);
            }
        }
        return gFcports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FcPortBase> findFcPortsIncFcip() {
        ArrayList<FcPortBase> gFcports = new ArrayList<FcPortBase>();
        Map<Integer, FcPortBase> map = this._portByIfIndex;
        synchronized (map) {
            for (FcPortBase port : this._portByIfIndex.values()) {
                if (port.getIfType() != 56 || IfIndexUtil.getType(port.getIfIndex()) != 1 && IfIndexUtil.getType(port.getIfIndex()) != 30 && IfIndexUtil.getType(port.getIfIndex()) != 10) continue;
                gFcports.add(port);
            }
        }
        return gFcports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FcPortBase> findFexEthPorts() {
        ArrayList<FcPortBase> eports = new ArrayList<FcPortBase>();
        Map<Integer, FcPortBase> map = this._portByIfIndex;
        synchronized (map) {
            for (FcPortBase port : this._portByIfIndex.values()) {
                if (port.getIfIndex() < 526581760 || port.getIfType() != 31) continue;
                eports.add(port);
            }
        }
        return eports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FcPortBase> findNonIPSEthPorts() {
        ArrayList<FcPortBase> eports = new ArrayList<FcPortBase>();
        Map<Integer, FcPortBase> map = this._portByIfIndex;
        synchronized (map) {
            for (FcPortBase port : this._portByIfIndex.values()) {
                if (port.getIfType() != 6 || !port.getIfname().startsWith("Ethernet")) continue;
                eports.add(port);
            }
        }
        return eports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FcPortBase> findGigEthPorts() {
        ArrayList<FcPortBase> eports = new ArrayList<FcPortBase>();
        Map<Integer, FcPortBase> map = this._portByIfIndex;
        synchronized (map) {
            for (FcPortBase port : this._portByIfIndex.values()) {
                if (port.getIfType() != 117 || !port.getIfname().startsWith("GigabitEthernet")) continue;
                eports.add(port);
            }
        }
        return eports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FcPortBase> findNonIPSEthPortChannels() {
        ArrayList<FcPortBase> eports = new ArrayList<FcPortBase>();
        Map<Integer, FcPortBase> map = this._portByIfIndex;
        synchronized (map) {
            for (FcPortBase port : this._portByIfIndex.values()) {
                if (this._base.getType(port.getIfIndex()) != 22) continue;
                eports.add(port);
            }
        }
        return eports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FcPortBase> findVEthPorts() {
        ArrayList<FcPortBase> eports = new ArrayList<FcPortBase>();
        Map<Integer, FcPortBase> map = this._portByIfIndex;
        synchronized (map) {
            for (FcPortBase port : this._portByIfIndex.values()) {
                if (this.getType(port.getIfIndex()) != 28) continue;
                eports.add(port);
            }
        }
        return eports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FcPortBase> findIscsiPorts() {
        ArrayList<FcPortBase> eports = new ArrayList<FcPortBase>();
        Map<Integer, FcPortBase> map = this._portByIfIndex;
        synchronized (map) {
            for (FcPortBase port : this._portByIfIndex.values()) {
                if (this.getType(port.getIfIndex()) != 11) continue;
                eports.add(port);
            }
        }
        return eports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SMEPortBase> findSMEPortsWithSysName() {
        ArrayList<SMEPortBase> smePorts = new ArrayList<SMEPortBase>();
        Map<Integer, FcPortBase> map = this._portByIfIndex;
        synchronized (map) {
            for (FcPortBase port : this._portByIfIndex.values()) {
                if (port.getSMEState() == -1) continue;
                SMEPortBase smePort = new SMEPortBase(port);
                smePort.setIpAddr(this.getIpAddress());
                smePort.setSwitchPK(this.getSwitchPK());
                smePort.setSysName(this.getSysName());
                smePorts.add(smePort);
            }
        }
        return smePorts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FcPortBase> findSMEPorts() {
        ArrayList<FcPortBase> smePorts = new ArrayList<FcPortBase>();
        Map<Integer, FcPortBase> map = this._portByIfIndex;
        synchronized (map) {
            for (FcPortBase port : this._portByIfIndex.values()) {
                if (port.getSMEState() == -1) continue;
                smePorts.add(port);
            }
        }
        return smePorts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FcPortBase> findIOAPorts() {
        ArrayList<FcPortBase> ioaPorts = new ArrayList<FcPortBase>();
        Map<Integer, FcPortBase> map = this._portByIfIndex;
        synchronized (map) {
            for (FcPortBase port : this._portByIfIndex.values()) {
                if (port.getIOAState() == -1) continue;
                ioaPorts.add(port);
            }
        }
        return ioaPorts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FcPortBase> findFcipPorts() {
        ArrayList<FcPortBase> fcipPorts = new ArrayList<FcPortBase>();
        Map<Integer, FcPortBase> map = this._portByIfIndex;
        synchronized (map) {
            for (FcPortBase port : this._portByIfIndex.values()) {
                if (port.getIfType() != 56 || IfIndexUtil.getType(port.getIfIndex()) != 10) continue;
                fcipPorts.add(port);
            }
        }
        return fcipPorts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findOtherFcPortsNonENonFxNonPCnl() {
        IntArray portsEandFx = new IntArray();
        int[] findIndexResults = this.findIfIndices();
        if (findIndexResults != null) {
            portsEandFx.add(this.findIfIndices());
        }
        IntArray otherPorts = new IntArray();
        Map<Integer, FcPortBase> map = this._portByIfIndex;
        synchronized (map) {
            for (FcPortBase port : this._portByIfIndex.values()) {
                int portType = IfIndexUtil.getType(port.getIfIndex());
                if (portType == 4 || portType != 1 || portsEandFx.contains(port.getIfIndex())) continue;
                otherPorts.add(port.getIfIndex());
            }
        }
        return otherPorts.size() > 0 ? otherPorts.toArray() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FcPortBase> findOtherNonENonFxNonPCnlFcPorts() {
        IntArray portsEandFx = new IntArray();
        int[] findIndexResults = this.findIfIndices();
        if (findIndexResults != null) {
            portsEandFx.add(this.findIfIndices());
        }
        ArrayList<FcPortBase> otherPorts = new ArrayList<FcPortBase>();
        Map<Integer, FcPortBase> map = this._portByIfIndex;
        synchronized (map) {
            for (FcPortBase port : this._portByIfIndex.values()) {
                int portType = IfIndexUtil.getType(port.getIfIndex());
                if (portType == 4 || portType != 1 || portsEandFx.contains(port.getIfIndex())) continue;
                otherPorts.add(port);
            }
        }
        return otherPorts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FcPortBase> findNonFcNonPChnlPorts() {
        ArrayList<FcPortBase> otherPorts = new ArrayList<FcPortBase>();
        Map<Integer, FcPortBase> map = this._portByIfIndex;
        synchronized (map) {
            for (FcPortBase port : this._portByIfIndex.values()) {
                if (IfIndexUtil.getType(port.getIfIndex()) == 4 || port.getIfType() == 1) continue;
                otherPorts.add(port);
            }
        }
        return otherPorts;
    }

    public int[] findIfIndices() {
        int[] ifindices1 = this._fabric.findEPortIfIndexesBySwitchPK(this.getSwitchPK());
        int[] ifindices2 = this.findFxPortIfIndices();
        if (ifindices1 == null) {
            return ifindices2;
        }
        if (ifindices2 == null) {
            return ifindices1;
        }
        int[] ifindices = new int[ifindices1.length + ifindices2.length];
        System.arraycopy(ifindices1, 0, ifindices, 0, ifindices1.length);
        System.arraycopy(ifindices2, 0, ifindices, ifindices1.length, ifindices2.length);
        return ifindices;
    }

    public List<Integer> findVFCIfIndices() {
        List<FcPortBase> ports = this.getPorts();
        ArrayList<Integer> portIndices = new ArrayList<Integer>();
        for (int k = 0; k < ports.size(); ++k) {
            FcPortBase nextPort = ports.get(k);
            int ifIndex = nextPort.getIfIndex();
            if (30 != this._base.getType(ifIndex)) continue;
            portIndices.add(ifIndex);
        }
        return portIndices;
    }

    public int[] findEPortIfIndices() {
        return this._fabric.findEPortIfIndexesBySwitchPK(this.getSwitchPK());
    }

    public int[] findFxPortIfIndices() {
        VsanDomain[] vdks = this._base.getVsanDomains();
        SanManager sm = SanManager.getInstance();
        HashSet<Integer> ifIndexes = new HashSet<Integer>();
        int[] ret = null;
        if (this.getSwitchPK() == null) {
            _Logger.warn((Object)(this + " switchPK is null"), (Throwable)new Exception());
        }
        if (vdks != null) {
            int i;
            for (i = 0; i < vdks.length; ++i) {
                VsanImpl v = this.getVsan(vdks[i]._vsanPK._id);
                if (v == null) continue;
                for (EndPortImpl ep : v.getEndPorts()) {
                    if (!this.getSwitchPK().equals(ep.getSwitchPK()) || ifIndexes.contains(ep.getIfIndex())) continue;
                    ifIndexes.add(ep.getIfIndex());
                }
            }
            if (ifIndexes.size() > 0) {
                ret = new int[ifIndexes.size()];
                i = 0;
                for (Integer ifindex : ifIndexes) {
                    ret[i++] = ifindex;
                }
            }
        }
        return ret;
    }

    public List findFvPorts() {
        if (!InventoryManager.getInstance().hasILC((PKIf)this._base.getSwitchPK())) {
            return null;
        }
        VsanDomain[] vdks = this._base.getVsanDomains();
        ArrayList<EndPortImpl> fvPorts = new ArrayList<EndPortImpl>();
        if (vdks != null) {
            for (int i = 0; i < vdks.length; ++i) {
                VsanImpl v = this.getVsan(vdks[i]._vsanPK._id);
                if (v == null) continue;
                for (EndPortImpl ep : v.getEndPorts()) {
                    if (!ep.isPresent() || !ep.isVirtualized() || !((WwnKey)this._base.getSwitchPK()).equals(ep.getSwitchPK())) continue;
                    fvPorts.add(ep);
                }
            }
        }
        return fvPorts.size() != 0 ? fvPorts : null;
    }

    public FcPortBase findPort(WwnKey fwwn) {
        return this._portByWwnKey.get(fwwn);
    }

    public void addFwwn2IfIndex(Wwn fwwn, int ifindex) {
        if (this._base.getIfIndexByFwwnInMap(fwwn) == -1) {
            Map<Wwn, Integer> oldValue = this._base.getFwwn2IfIndexMap();
            this._base.addFwwn2IfIndex(fwwn, ifindex);
            this.propertyChanged((short)1063, (Serializable)((Object)oldValue), (Serializable)((Object)this._base.getFwwn2IfIndexMap()));
        }
    }

    public void removeFwwn2IfIndex(Wwn fwwn) {
        if (this._base.getIfIndexByFwwnInMap(fwwn) != -1) {
            Map<Wwn, Integer> oldValue = this._base.getFwwn2IfIndexMap();
            this._base.removeFwwn2IfIndex(fwwn);
            this.propertyChanged((short)1063, (Serializable)((Object)oldValue), (Serializable)((Object)this._base.getFwwn2IfIndexMap()));
        }
    }

    public void clearFwwn2IfIndexMap() {
        Map<Wwn, Integer> oldValue = this._base.getFwwn2IfIndexMap();
        if (oldValue.size() > 0) {
            this._base.clearIfIndexByFwwnInMap();
            this.propertyChanged((short)1063, (Serializable)((Object)oldValue), (Serializable)((Object)this._base.getFwwn2IfIndexMap()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFlogiQuery(VsanFcIdKey vsanFcid, Wwn pwwn, Wwn fwwn) {
        if (vsanFcid == null || fwwn == null) {
            return;
        }
        Map<VsanFcIdKey, Wwn[]> map = this._flogiQueryByVsanFcid;
        synchronized (map) {
            this._flogiQueryByVsanFcid.put(vsanFcid, new Wwn[]{pwwn, fwwn});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Wwn[] removeFlogiQuery(VsanFcIdKey vsanFcid) {
        Map<VsanFcIdKey, Wwn[]> map = this._flogiQueryByVsanFcid;
        synchronized (map) {
            return this._flogiQueryByVsanFcid.remove(vsanFcid);
        }
    }

    public int getNumOfFlogiQueries() {
        return this._flogiQueryByVsanFcid.size();
    }

    public Wwn[] getFlogiQuery(VsanFcIdKey vsanFcid) {
        return this._flogiQueryByVsanFcid.get(vsanFcid);
    }

    public Map<VsanFcIdKey, Wwn[]> getFlogiQueries() {
        return new HashMap<VsanFcIdKey, Wwn[]>(this._flogiQueryByVsanFcid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearFlogiQueries() {
        Map<VsanFcIdKey, Wwn[]> map = this._flogiQueryByVsanFcid;
        synchronized (map) {
            this._flogiQueryByVsanFcid.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPendingEP(Wwn fwwn, EndPortImpl ep) {
        if (fwwn != null && ep != null) {
            Map<Wwn, Set<EndPortImpl>> map = this._pendingEps;
            synchronized (map) {
                Set<EndPortImpl> eps = this._pendingEps.get(fwwn);
                if (eps == null) {
                    eps = new HashSet<EndPortImpl>();
                    this._pendingEps.put(fwwn, eps);
                }
                eps.add(ep);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<EndPortImpl> removePendingEp(Wwn fwwn) {
        if (fwwn != null) {
            Map<Wwn, Set<EndPortImpl>> map = this._pendingEps;
            synchronized (map) {
                return this._pendingEps.remove(fwwn);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPendingEps() {
        Map<Wwn, Set<EndPortImpl>> map = this._pendingEps;
        synchronized (map) {
            this._pendingEps.clear();
        }
    }

    public Set<EndPortImpl> findPendingEp(Wwn fwwn) {
        if (fwwn != null) {
            return this._pendingEps.get(fwwn);
        }
        return null;
    }

    public void setVlanByVsanMap(Map<Short, Short> newMap) {
        boolean changed;
        if (newMap == null) {
            return;
        }
        Map<Short, Short> oldValue = this._base.getVlanByVsanMap();
        boolean bl = changed = oldValue.size() != newMap.size();
        if (!changed) {
            for (Map.Entry<Short, Short> ent : newMap.entrySet()) {
                if (oldValue.get(ent.getKey()) == ent.getValue()) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            this._base.setVlanByVsanMap(newMap);
            this.propertyChanged((short)1065, (Serializable)((Object)oldValue), (Serializable)((Object)this._base.getVlanByVsanMap()));
        }
    }

    public void clearVlanByVsanMap() {
        Map<Short, Short> oldValue = this._base.getVlanByVsanMap();
        if (oldValue.size() != 0) {
            this._base.clearIfIndexByFwwnInMap();
            this.propertyChanged((short)1065, (Serializable)((Object)oldValue), (Serializable)((Object)this._base.getVlanByVsanMap()));
        }
    }

    public void clean() {
        if (this.hostNICCache != null) {
            this.hostNICCache.clear();
            this.hostNICCache = null;
        }
    }

    public TraceLogger getLogger() {
        return _Tracer;
    }

    public boolean isPeerCreated() {
        return this._peer != null;
    }

    public synchronized SnmpPeer createPeer() throws SnmpException {
        if (this._peer != null) {
            return this._peer;
        }
        InetAddress[] addrs = null;
        addrs = !Boolean.parseBoolean(System.getProperty("fabric.managementIpOverwrite")) && this.getInetAddress() != null ? new InetAddress[]{this.getInetAddress()} : this.getAllAddresses();
        if (addrs == null || addrs.length == 0) {
            throw new SnmpException("noMgmtAddr");
        }
        try {
            SnmpPeer peer;
            this._peer = peer = this.createPeer(addrs);
            this.setManagementAddressInUse(peer.getAddress());
            this.setManageable(true, null);
            SnmpPeer.addPeer(peer);
        }
        catch (SnmpException se) {
            if (addrs.length == 1) {
                this.setManagementAddressInUse(addrs[0]);
            }
            this.setManageable(false, se.getMessage());
            this.resetPeer();
            throw se;
        }
        return this._peer;
    }

    public synchronized void resetPeer() {
        if (this._peer != null) {
            SnmpPeer.removePeer(this._peer);
            this._peer = null;
            this.setManageable(false, null);
        }
    }

    private SnmpPeer createPeer(InetAddress[] addrs) throws SnmpException {
        SnmpPeer peer = null;
        Throwable ex = null;
        if (addrs == null || addrs.length == 0) {
            throw new SnmpException("noMgmtAddr");
        }
        for (int i = 0; i < addrs.length; ++i) {
            if (addrs[i] == null || addrs[i].isLinkLocalAddress() || addrs[i].isMulticastAddress()) continue;
            try {
                peer = new SnmpPeer(addrs[i]);
                this.setCredentials(peer, this._fabric.getCredentials());
                peer.setTimeout(this._fabric.getTimeout());
                peer.setRetries(this._fabric.getRetries());
                String standAlone = System.getProperty("fm.standalone");
                if (standAlone != null && Boolean.parseBoolean(standAlone)) {
                    peer.setLogger(Logger.getLogger((String)"snmp.discovery"));
                }
                if (this._base.getWwn() == null || peer.getVersion() == 3 || !WwnDictionary.isBrocadeWwn(this._base.getWwn().getValue())) break;
                String community = System.getProperty("snmp.defaultCommunity");
                if (community == null || community.trim().equals("")) {
                    community = "public";
                }
                CommunityUser user = new CommunityUser(community);
                if (this.getVersion() == null || this.getVersion() != null && (this.getVersion().indexOf("3.") >= 0 || this.getVersion().indexOf("4.") >= 0)) {
                    peer.setVersion(0);
                    user.setVersion(0);
                } else {
                    peer.setVersion(1);
                }
                this.setCredentials(peer, user);
                break;
            }
            catch (SnmpException se) {
                peer = null;
                ex = se;
            }
        }
        if (peer == null) {
            if (ex == null) {
                ex = new SnmpException("noMgmtAddr");
            }
            this.setManageable(false, ex.getMessage());
            throw ex;
        }
        return peer;
    }

    public void setCredentials(SnmpUser user) throws SnmpException {
        if (this._peer != null) {
            if (this.isMDS() || this.isQuail() && user instanceof CommunityUser) {
                if (user.getSecurityModel() == 3) {
                    user.initPeer(this._peer, SanManager.getSnmpSession());
                } else {
                    user.initPeer(this._peer, SnmpSession.getInstance("udp"));
                }
            } else {
                String wc;
                String rc;
                boolean v3 = false;
                if (user.getSecurityModel() == 3) {
                    v3 = true;
                    rc = SnmpCommunity.getRead(this._base.getInetAddress());
                    wc = SnmpCommunity.getWrite(this._base.getInetAddress());
                } else {
                    SnmpCommunity sc = SnmpCommunity.getCommunity(this._base.getInetAddress());
                    if (sc != null) {
                        rc = sc.getRead();
                        wc = sc.getWrite();
                    } else {
                        rc = ((CommunityUser)user).getCommunity();
                        wc = ((CommunityUser)user).getCommunity();
                    }
                }
                if ("$IGNORE_COMMUNITY$".equals(rc)) {
                    throw new SnmpException("noCommunity");
                }
                if (v3) {
                    this._peer.setCredentials(SanManager.getSnmpSession(), rc, wc);
                } else {
                    this._peer.setCredentials(SnmpSession.getInstance("udp"), rc, wc);
                }
            }
        }
    }

    void setCredentials(SnmpPeer peer, SnmpUser user) throws SnmpException {
        if (user == null) {
            throw new SnmpException("No valid snmp user");
        }
        if (this.isMDS() || this.isQuail() && user instanceof CommunityUser) {
            if (user.getSecurityModel() == 3) {
                user.initPeer(peer, SanManager.getSnmpSession());
            } else {
                user.initPeer(peer, SnmpSession.getInstance("udp"));
            }
        } else {
            String wc;
            String rc;
            boolean v3 = false;
            if (user.getSecurityModel() == 3) {
                v3 = true;
                rc = SnmpCommunity.getRead(this._base.getInetAddress());
                wc = SnmpCommunity.getWrite(this._base.getInetAddress());
            } else {
                SnmpCommunity sc = SnmpCommunity.getCommunity(this._base.getInetAddress());
                if (sc != null) {
                    rc = sc.getRead();
                    wc = sc.getWrite();
                } else {
                    rc = ((CommunityUser)user).getCommunity();
                    wc = ((CommunityUser)user).getCommunity();
                }
            }
            if ("$IGNORE_COMMUNITY$".equals(rc)) {
                throw new SnmpException("noCommunity");
            }
            if (v3) {
                peer.setCredentials(SnmpSession.getInstance(), rc, wc);
            } else {
                peer.setCredentials(SnmpSession.getInstance("udp"), rc, wc);
            }
        }
    }

    public boolean isHostReachable(byte[] hostIP) {
        block7: {
            try {
                Enumeration<NetworkInterface> netEnum;
                String hostIPAddr = InetAddress.getByAddress(hostIP).getHostAddress();
                String svrIp = System.getProperty("server.translatedAddr");
                if (svrIp != null && (svrIp = svrIp.trim()).length() > 0) {
                    return GenUtil.equals(svrIp, hostIPAddr);
                }
                if (this.hostNICCache == null && (netEnum = NetworkInterface.getNetworkInterfaces()) != null) {
                    this.hostNICCache = new HashMap();
                    while (netEnum.hasMoreElements()) {
                        NetworkInterface ni = netEnum.nextElement();
                        Enumeration<InetAddress> ipEnum = ni.getInetAddresses();
                        long t1 = System.currentTimeMillis();
                        while (ipEnum.hasMoreElements()) {
                            String ipAddr = ipEnum.nextElement().getHostAddress();
                            this.hostNICCache.put(ipAddr, ni);
                        }
                    }
                }
                NetworkInterface ni = null;
                if (this.hostNICCache != null && (ni = this.hostNICCache.get(hostIPAddr)) != null) {
                    return true;
                }
            }
            catch (Exception e) {
                if (!_Logger.isDebugEnabled()) break block7;
                _Logger.debug((Object)"Caught exception in check host ip ", (Throwable)e);
            }
        }
        return false;
    }

    public void setDiscFlag(int type) {
        this._discFlags |= type;
        if (this._base.isNpvEnabled()) {
            this._discFlags &= 0xC54F;
        }
    }

    public void resetDiscFlag(int type) {
        this._discFlags &= ~type;
    }

    public boolean isDiscFlagSet(int type) {
        return (this._discFlags & type) != 0;
    }

    public void setDiscFlags(int types) {
        this._discFlags = types;
    }

    public String toDiscFlagString() {
        return SwitchImpl.toDiscFlagString(this._discFlags);
    }

    public int getDiscFlag() {
        return this._discFlags;
    }

    public boolean isHotStandby() {
        return this._base.isHotStandby();
    }

    public VsanFcIdKey[] getHostPortsToQuery() {
        EndPortImpl[] eps = this._fabric.getEndPorts();
        if (eps == null) {
            return null;
        }
        ArrayList<VsanFcIdKey> l = new ArrayList<VsanFcIdKey>();
        for (int i = 0; i < eps.length; ++i) {
            VsanFcIdKey[] fcids;
            if (!eps[i].isTarget() && eps[i].getSymNodeName() == null) {
                VsanFcIdKey[] fcids2;
                int vendorId = WwnDictionary.getVendorId(eps[i].getPortWwn().getValue());
                if (vendorId != 201 && vendorId != 57483 || (fcids2 = eps[i].getVsanFcIds()) == null) continue;
                l.add(fcids2[0]);
                continue;
            }
            if (!eps[i].isISCSI() || eps[i].getSwitch() != this || eps[i].getSymNodeName() != null || (fcids = eps[i].getVsanFcIds()) == null) continue;
            l.add(fcids[0]);
        }
        return l.size() == 0 ? null : l.toArray(new VsanFcIdKey[l.size()]);
    }

    public EndPortImpl[] getTargetPortsToQuery() {
        EndPortImpl[] eps = this._fabric.getEndPorts();
        if (eps == null) {
            return null;
        }
        ArrayList<EndPortImpl> l = new ArrayList<EndPortImpl>();
        for (int i = 0; i < eps.length; ++i) {
            EnclosureImpl enc;
            if (!eps[i].isTarget() || eps[i].getSwitch() != this || (enc = eps[i].getEnclosure()) == null || enc.getScsiTarget() != null) continue;
            l.add(eps[i]);
        }
        return l.size() == 0 ? null : l.toArray(new EndPortImpl[l.size()]);
    }

    public int getNumVsanConfigured() {
        return this._numVsanConfigured;
    }

    public void setNumVsanConfigured(int vsanNum) {
        if (this._numVsanConfigured != vsanNum) {
            this.setDiscFlag(16);
            this._numVsanConfigured = vsanNum;
        }
    }

    public void setVsanLastChange(long lastChange) {
        if (this._vsanLastChange != lastChange) {
            this.setDiscFlag(16);
            this._vsanLastChange = lastChange;
        }
    }

    public int getNumLicensedFeatures() {
        return this._numLicFeatures;
    }

    public void setNumLicensedFeatures(int num) {
        this._numLicFeatures = num;
    }

    public void setFcnsTableLastChange(long lastChange) {
        if (this._fcnsTableLastChange != lastChange) {
            this._fcnsTableLastChange = lastChange;
            Collection<Short> vids = this._base.getVsanMembership();
            for (short vid : vids) {
                VsanImpl vsan = this.getVsan(vid);
                if (vsan == null) continue;
                vsan.setDiscFlag(2);
            }
        }
    }

    public int getNumConnUnits() {
        return this._numConnUnits;
    }

    public void setNumConnUnits(int num) {
        this._numConnUnits = num;
    }

    public int getNumConnLinks() {
        return this._numConnLinks;
    }

    public void setNumConnLinks(int num) {
        this._numConnLinks = num;
    }

    public int getNumSnsEntries() {
        return this._numSnsEntries;
    }

    public void setNumSnsEntries(int num) {
        this._numSnsEntries = num;
    }

    public int getNumFeModules() {
        return this._numFeModules;
    }

    public void setNumFeModules(int num) {
        this._numFeModules = num;
    }

    public void setStatusChangeTime(long time) {
        this._statusChgTime = time;
    }

    public long getConfigChangeTime() {
        return this._cfgChgTime;
    }

    public void setConfigChangeTime(long time) {
        this._cfgChgTime = time;
    }

    public void setConnUnitTableChangeTime(long time) {
        if (this._connUnitTableChgTime != time) {
            this._connUnitTableChgTime = time;
            this._discFlags |= 4;
        }
    }

    public int getDeviceAliasMode() {
        return this._base.getDeviceAliasMode();
    }

    public void setDeviceAliasMode(int newMode) {
        if (this._base.getDeviceAliasMode() != newMode) {
            Integer oldMode = new Integer(this._base.getDeviceAliasMode());
            this._base.setDeviceAliasMode(newMode);
            this.propertyChanged((short)1056, oldMode, new Integer(newMode));
        }
    }

    public int getDeviceAliasShowCfg() {
        return this._daShowCfg;
    }

    public void setDeviceAliasShowCfg(int opt) {
        this._daShowCfg = opt;
    }

    public int getCfsFeatureOpStatus() {
        return this._base.getCfsFeatureOpStatus();
    }

    public void setCfsFeatureOpStatus(int opStat) {
        this._base.setCfsFeatureOpStatus(opStat);
    }

    public int getIvrShowCfg() {
        return this._ivrShowCfg;
    }

    public void setIvrShowCfg(int opt) {
        this._ivrShowCfg = opt;
    }

    public int getCfsRegionId(String feature) {
        return this._base.getCfsRegionId(feature);
    }

    public void addCfsRegionId(String feature, int regionId) {
        FeatureRegion newRid = new FeatureRegion(feature, (short)regionId);
        FeatureRegion oldRid = this._base.addCfsRegionId(feature, regionId);
        if (newRid != oldRid) {
            this.propertyChanged((short)1074, oldRid, newRid);
        }
    }

    public void removeFeatureRegion(String feature) {
        FeatureRegion fr;
        if (feature != null && (fr = this._base.removeFeatureRegion(feature)) != null) {
            this.propertyChanged((short)1074, fr, null);
        }
    }

    public void removeCfsRegion(CfsRegionPK reg) {
        FeatureRegion[] frs = this._base.getFeatureRegions();
        for (int i = 0; i < frs.length; ++i) {
            FeatureRegion fr;
            if (frs[i] == null || frs[i]._regionId != reg._id || (fr = this._base.removeFeatureRegion(frs[i]._feature)) == null) continue;
            this.propertyChanged((short)1074, fr, null);
        }
    }

    public void setVsanZoneAttrs(Map<Short, DefaultZoneAttributes> zoneAttrs) {
        if (zoneAttrs == null) {
            return;
        }
        Map<Short, DefaultZoneAttributes> oldValue = this._base.getVsanZoneAttrs();
        boolean changed = false;
        if (oldValue.size() != zoneAttrs.size()) {
            changed = true;
        } else {
            for (Map.Entry<Short, DefaultZoneAttributes> ent : zoneAttrs.entrySet()) {
                DefaultZoneAttributes v = oldValue.get(ent.getKey());
                if (ent.getValue().equals(oldValue.get(ent.getKey()))) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            this._base.setVsanZoneAttrs(zoneAttrs);
            this.propertyChanged((short)1068, (Serializable)((Object)oldValue), (Serializable)((Object)this._base.getVsanZoneAttrs()));
        }
    }

    public boolean isTrapRegisterTried() {
        return this._trapRegisterTried;
    }

    public void setTrapRegisterTried(boolean b) {
        this._trapRegisterTried = b;
    }

    public boolean isAssignedLicenseTried() {
        return this._assignLicenseTried;
    }

    public void setAssignedLicenseTried(boolean b) {
        this._assignLicenseTried = b;
    }

    public boolean isMdsDirector() {
        return this._base.isMdsDirector();
    }

    public int[] getCardPhysicalIndices() {
        List<Card> cards = InventoryManager.getInstance().findCards(this._base.getPK());
        if (cards != null && cards.size() > 0) {
            int[] indices = new int[cards.size()];
            for (int i = 0; i < cards.size(); ++i) {
                Card cr = cards.get(i);
                indices[i] = cr.getPhysicalIndex();
            }
            return indices;
        }
        return new int[0];
    }

    public int[] getPSPhysicalIndices() {
        List<PowerSupply> pws = InventoryManager.getInstance().findPowerSupplies(((SwitchBase)this.getBaseObject()).getPK());
        if (pws != null && pws.size() > 0) {
            int[] indices = new int[pws.size()];
            for (int i = 0; i < pws.size(); ++i) {
                PowerSupply pw = pws.get(i);
                indices[i] = pw.getPhysicalIndex();
            }
            return indices;
        }
        return new int[0];
    }

    public int[] getFanPhysicalIndices() {
        List<HwInventoryComponent> pws = InventoryManager.getInstance().findFans(((SwitchBase)this.getBaseObject()).getPK());
        if (pws != null && pws.size() > 0) {
            int[] indices = new int[pws.size()];
            for (int i = 0; i < pws.size(); ++i) {
                HwInventoryComponent pw = pws.get(i);
                indices[i] = pw.getPhysicalIndex();
            }
            return indices;
        }
        return new int[0];
    }

    public String dump(int level) {
        SwitchLicenseDetails licDetails;
        StringBuilder sb = new StringBuilder();
        sb.append(FabricImpl.LIL[level]).append("Switch: ").append(this._base.getWwn()).append(FabricImpl.LIL[level + 1]).append("Management Addresses: ");
        InetAddress[] addrs = this._base.getManagementAddresses();
        if (addrs != null) {
            for (int i = 0; i < addrs.length; ++i) {
                if (addrs[i] == null) continue;
                sb.append(addrs[i].getHostAddress()).append(addrs[i].equals(this._base.getInetAddress()) ? "(in use) " : " ");
            }
        } else {
            sb.append("n/a");
        }
        sb.append(FabricImpl.LIL[level + 1]).append("Manageable: ").append(this._base.isManageable());
        if (!this._base.isManageable()) {
            sb.append(FabricImpl.LIL[level + 1]).append("Unmanageable Cause: ").append(this._base.getUnmanageableCause());
        }
        sb.append(FabricImpl.LIL[level + 1]).append("Model: ").append(this._base.getModel() == null ? this._base.getVendor() : this._base.getModel()).append(FabricImpl.LIL[level + 1]).append("Version: ");
        if (this._base.getVersion() == null) {
            sb.append("n/a");
        } else {
            sb.append(this._base.getVersion());
        }
        sb.append(FabricImpl.LIL[level + 1]).append("SerialNo: ");
        if (this._base.getSerialNumber() == null) {
            sb.append("n/a");
        } else {
            sb.append(this._base.getSerialNumber());
        }
        if (this.getBase().isVdc()) {
            sb.append(FabricImpl.LIL[level + 1]).append("isVDC: ").append(this.getBase().isVdc()).append(", isDefaultVdc:").append(this.getBase().isDefaultVdc());
        }
        if ((licDetails = this._base.getLicenseDetails()) != null) {
            sb.append(FabricImpl.LIL[level + 1]).append(licDetails.toString());
        }
        long uptime = this._base.getSwitchUpTime() > 0L ? this._base.getSwitchUpTime() : this._base.getSysUpTime();
        long lastBootTime = this._base.getSwitchLastBootTime() > 0L ? this._base.getSwitchLastBootTime() : this._base.getSysLastBootTime();
        sb.append(FabricImpl.LIL[level + 1]).append("SysUpTime: ").append(SnmpTimeticks.formatTimeElapsed(uptime)).append(FabricImpl.LIL[level + 1]).append("LastBootTime: ").append(new Date(lastBootTime)).append(FabricImpl.LIL[level + 1]).append("SysName: ").append(this._base.getSysName() == null ? "n/a" : this._base.getSysName()).append(FabricImpl.LIL[level + 1]).append("SysDescription: ").append(this._base.getSysDescr() == null ? "n/a" : this._base.getSysDescr()).append(FabricImpl.LIL[level + 1]).append("SysContact: ").append(this._base.getSysContact() == null ? "n/a" : this._base.getSysContact()).append(FabricImpl.LIL[level + 1]).append("SysLocation: ").append(this._base.getSysLocation() == null ? "n/a" : this._base.getSysLocation()).append(FabricImpl.LIL[level + 1]).append("Cpu Usage %: ").append(this._base.getSysContact() == null ? "n/a" : Integer.valueOf(this._base.getSysCpuUsage())).append(FabricImpl.LIL[level + 1]).append("Memory Usage %: ").append(this._base.getSysContact() == null ? "n/a" : Integer.valueOf(this._base.getSysMemoryUsage())).append(FabricImpl.LIL[level + 1]).append("ConnUnitStatus: ").append(this._base.getConnUnitStatus() == 0 ? "n/a" : String.valueOf(this._base.getConnUnitStatus())).append(FabricImpl.LIL[level + 1]).append("Enabled Feature(s): ").append(!this._base.isAnyFeatureEnabled() ? "n/a" : this._base.getFeatureString()).append(FabricImpl.LIL[level + 1]).append("fcoeCapable: ").append(this._base.isFCoECapable()).append(", versionCapable=").append(this._base.isFCoECapableVersion()).append(", featureSet=").append((Object)this._base.getFCoFeatureSetStatus()).append(FabricImpl.LIL[level + 1]).append("IVR Buffer: ").append(this._ivrShowCfg == 0 ? "n/a" : (this._ivrShowCfg == 1 ? "running" : "pending")).append(FabricImpl.LIL[level + 1]).append("Device Alias Mode: ").append(this._base.getDeviceAliasMode() == 0 ? "n/a" : (this._base.getDeviceAliasMode() == 1 ? "basic" : "enhanced")).append(FabricImpl.LIL[level + 1]).append("Device Alias Buffer: ").append(this._daShowCfg == 0 ? "n/a" : (this._daShowCfg == 1 ? "running" : "pending")).append(FabricImpl.LIL[level + 1]).append("Num of Slots: ").append(this._base.getNumSlots()).append(FabricImpl.LIL[level + 1]).append("Card Offset: ").append(this._base.getModuleIndexOffset()).append(FabricImpl.LIL[level + 1]).append("Num of Cards: ");
        List<Card> cards = InventoryManager.getInstance().findCards(this._base.getPK());
        if (cards.size() == 0) {
            sb.append("n/a");
        } else {
            sb.append(cards.size());
            Collections.sort(cards);
            for (Card card : cards) {
                sb.append(FabricImpl.LIL[level + 2]).append("Slot: ").append(card.getSlotId()).append(", Type: ").append(card.getModelName()).append(", ").append(card.getType()).append(", Name: ").append(card.getName()).append(", Num of Ports: ").append(card.getNumPorts()).append(", HwRev: ").append(card.getHardwareRevision()).append(", SwRev: ").append(card.getSoftwareRevision()).append(", SerialNo: ").append(card.getSerialNumber()).append(", AssetID: ").append(card.getAssetId()).append(", DMM State: ").append(card.getDmmState()).append(", Power OperStatus: ").append(card.getPowerOperStatus()).append(", OperStatus: ").append(card.getOperStatus() == 2 ? "up" : String.valueOf(card.getOperStatus()));
            }
        }
        if (this._base.isMDS()) {
            sb.append(FabricImpl.LIL[level + 1]).append("ActiveSupSlot: ");
            if (this._base.getActiveSupSlot() == -1) {
                sb.append("n/a");
            } else {
                sb.append(this._base.getActiveSupSlot());
            }
            sb.append(FabricImpl.LIL[level + 1]).append("StandbySupSlot: ");
            int slot = this._base.getStandbySupSlot();
            if (slot == -1) {
                sb.append("n/a");
            } else {
                sb.append(slot);
            }
            sb.append(FabricImpl.LIL[level + 1]).append("StandbySupState: ");
            if (this._base.getStandbySupState() == 0) {
                sb.append("n/a");
            } else {
                sb.append(this._base.getStandbySupState());
            }
            sb.append(FabricImpl.LIL[level + 1]).append("Trap Registered: ").append(this._base.isTrapRegistered()).append(FabricImpl.LIL[level + 1]).append("Syslog Registered: ").append(this._base.isSyslogRegistered()).append(FabricImpl.LIL[level + 1]).append("Telnet Enabled: ").append(this._base.isTelnetEnabled());
        } else if (this._base.isQuail()) {
            sb.append(FabricImpl.LIL[level + 1]).append("FC-FE Module ID: ").append(this._base.getFcFeModuleId());
        }
        sb.append(FabricImpl.LIL[level + 1]).append("Num of FC Ports: ").append(this._base.getNumFcPorts());
        List<FcPortBase> fports = this.getPorts();
        Collections.sort(fports);
        for (FcPortBase fport : fports) {
            sb.append(FabricImpl.LIL[level + 2]).append(fport);
        }
        sb.append(FabricImpl.LIL[level + 1]).append("License Violation: ").append(this._base.isLicenseViolation());
        short[] vids = this.getVsanIds();
        sb.append(FabricImpl.LIL[level + 1]).append("FabricPK=").append(this.getFabricPK());
        sb.append(FabricImpl.LIL[level + 1]).append(vids.length).append(" VSAN configured");
        if (vids != null) {
            Arrays.sort(vids);
            for (int i = 0; i < vids.length; ++i) {
                DefaultZoneAttributes defZoneAttrs;
                sb.append(FabricImpl.LIL[level + 2]).append("VSAN: ").append(vids[i]);
                VsanDomain vdomain = this._base.getVsanDomain(vids[i]);
                if (vdomain == null) {
                    sb.append("down");
                } else {
                    VsanImpl v = this.getVsan(vids[i]);
                    if (v != null) {
                        sb.append(" (").append(v.isUp() ? "up" : "down").append("), ");
                        Wwn prinswwn = v.getPrincipalSwitchWwn();
                        sb.append("Domain ID: ").append(this._base.isNpvEnabled() ? vdomain._domainId & 0xFF : vdomain._domainId).append(", ").append(vdomain.getVsanWwn()).append(", Principal: ");
                        if (this.getWwn().equals(prinswwn)) {
                            sb.append("self");
                        } else if (prinswwn != null) {
                            SwitchImpl prin = SanManager.getInstance().findSwitch(prinswwn, this._base.getFabricPK());
                            if (prin != null && prin.getIpAddress() != null) {
                                sb.append(prin.getIpAddress());
                            } else {
                                sb.append(prinswwn);
                            }
                        } else {
                            sb.append(v.getVsanPK()._prinSwwn);
                        }
                    } else {
                        sb.append("VSAN " + vids[i] + " has broken reference");
                    }
                }
                InetAddress vip = this._base.getVsanIp(vids[i]);
                if (vip != null) {
                    sb.append(", IP: ").append(vip.getHostAddress());
                }
                if ((defZoneAttrs = this._base.getZoneAttrsByVsanId(vids[i])) == null) continue;
                sb.append(", DefaultZonePolicy=").append(defZoneAttrs.isPermitDefaultPolicy() ? "permit" : "deny");
            }
        }
        sb.append(FabricImpl.LIL[level + 1]).append("Discovery Flags: ").append(SwitchImpl.toDiscFlagString(this._discFlags));
        return sb.toString();
    }

    public void addChannelIsl(IslImpl islImpl) {
        this._islById.put(islImpl.getDBID(), islImpl);
    }

    public IslImpl findChannelIsl(long id) {
        return this._islById.get(new Long(id));
    }

    public void clearIslHash() {
        this._islById.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPreexistRecord(Connection con) throws SQLException {
        ResultSet rs;
        PreparedStatement stat;
        block8: {
            block6: {
                block7: {
                    stat = null;
                    rs = null;
                    if (this.getWwn() != null) {
                        stat = con.prepareStatement(QuerySQLByFabricIDWwn);
                        this.setupCheckExistenceByFabricIdWwnStatement(stat);
                        break block6;
                    }
                    if (this.getInetAddress() == null) break block7;
                    stat = con.prepareStatement(QuerySQLByFabricIDIPAddress);
                    this.setupCheckExistenceByFabricIdIpStatement(stat);
                    break block6;
                }
                DbUtil.close(rs);
                DbUtil.close(stat);
                return;
            }
            try {
                rs = stat.executeQuery();
                if (!rs.next()) break block8;
                this.setDBID(rs.getLong(1));
            }
            catch (SQLException ex) {
                try {
                    ex.printStackTrace();
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stat);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        if (this.getDBID() == 0L) {
            this.setDBID(Sequence.getSequence().getPK());
            PreparedStatement stat = con.prepareStatement(InsertSQL);
            this.setupInsertStatement(stat);
            return stat;
        }
        PreparedStatement stat = con.prepareStatement(UpdateSQL);
        this.setupUpdateStatement(stat);
        return stat;
    }

    @Override
    public String getDBTableName() {
        return TableName;
    }

    public static InetAddress findSwitchMgmtAddrByPK(long id) {
        InetAddress ip = SwitchImpl.findSwitchMgmtAddrByPK(id, QueryMgmtAddrSQLBySwitchID);
        if (ip == null) {
            ip = SwitchImpl.findSwitchMgmtAddrByPK(id, QueryIPAddrSQLBySwitchID);
        }
        return ip;
    }

    public static InetAddress findSwitchAddrinDB(long id) {
        return SwitchImpl.findSwitchMgmtAddrByPK(id, QueryIPAddrSQLBySwitchID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Map<Long, Wwn> findSwitchIdsByFabircId(long id) {
        HashMap<Long, Wwn> ret = new HashMap<Long, Wwn>();
        Connection con = null;
        PreparedStatement queryAddrStat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            queryAddrStat = con.prepareStatement(QuerySwitchIDsSQLByFabricID);
            queryAddrStat.setLong(1, id);
            rs = queryAddrStat.executeQuery();
            while (rs.next()) {
                byte[] bwwn = rs.getBytes(2);
                if (bwwn == null) continue;
                ret.put(rs.getLong(1), new Wwn(bwwn));
            }
            DbUtil.close(rs);
        }
        catch (SQLException ex) {
            _Logger.error((Object)"findSwitchIdsByFabircId error", (Throwable)ex);
            Map<Long, Wwn> map = null;
            return map;
        }
        catch (Exception ex2) {
            _Logger.error((Object)"findSwitchIdsByFabircId error", (Throwable)ex2);
            Map<Long, Wwn> map = null;
            return map;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(queryAddrStat);
            DbUtil.close(con);
        }
        DbUtil.close(queryAddrStat);
        DbUtil.close(con);
        return ret;
    }

    public static Set<Long> getNoECHSupportList() throws SQLException {
        Connection con = null;
        PreparedStatement querySw = null;
        ResultSet rs = null;
        HashSet<Long> swlist = new HashSet<Long>();
        try {
            con = ConnectionManager.getConnection();
            querySw = con.prepareStatement(GetNoECHSwitchList);
            querySw.setLong(1, 0L);
            rs = querySw.executeQuery();
            while (rs.next()) {
                swlist.add(rs.getLong(1));
            }
        }
        catch (SQLException ex) {
            try {
                _Logger.error((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(querySw);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(querySw);
        DbUtil.close(con);
        return swlist;
    }

    public static void setNoECHSupportList(List<Long> swlist) throws SQLException {
        Connection con = null;
        PreparedStatement updateAll = null;
        PreparedStatement updateStr = null;
        try {
            con = ConnectionManager.getConnection();
            updateAll = con.prepareStatement(ResetISECHSUPPORT);
            updateAll.setInt(1, 1);
            updateAll.executeUpdate();
            updateStr = con.prepareStatement(UpdateISECHSUPPORTBySwitchID);
            con.setAutoCommit(false);
            for (Long num : swlist) {
                updateStr.setInt(1, 0);
                updateStr.setLong(2, num);
                updateStr.addBatch();
            }
            updateStr.executeBatch();
            con.commit();
        }
        catch (SQLException ex) {
            try {
                _Logger.error((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(updateAll);
                DbUtil.close(updateStr);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(updateAll);
        DbUtil.close(updateStr);
        DbUtil.close(con);
    }

    public static boolean syncSwitch(SwitchImpl source, SwitchImpl dest) {
        if (source == null || dest == null) {
            return false;
        }
        dest.setModuleIndexOffset(source.getModuleIndexOffset());
        dest.setVersion(source.getVersion());
        dest.setSerialNumber(source.getSerialNumber());
        dest.setStandbySupSlot(source.getStandbySupSlot());
        dest.setActiveSupPhysicalIndex(source.getActiveSupPhysicalIndex());
        dest.setStandbySupState(source.getStandbySupState());
        dest.setNumLicensedFeatures(source.getNumLicensedFeatures());
        dest._entLastChangeTime = source._entLastChangeTime;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InetAddress findSwitchMgmtAddrByPK(long id, String queryStr) {
        InetAddress ip = null;
        Connection con = null;
        PreparedStatement queryAddrStat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            queryAddrStat = con.prepareStatement(queryStr);
            queryAddrStat.setLong(1, id);
            rs = queryAddrStat.executeQuery();
            while (rs.next()) {
                ip = InetAddress.getByAddress(rs.getBytes(1));
                if (!(ip instanceof Inet4Address)) continue;
                InetAddress inetAddress = ip;
                DbUtil.close(rs);
                DbUtil.close(queryAddrStat);
                DbUtil.close(con);
                return inetAddress;
            }
            DbUtil.close(rs);
        }
        catch (SQLException ex) {
            _Logger.error((Object)"findSwitchMgmtAddrByPk error", (Throwable)ex);
            InetAddress inetAddress = null;
            return inetAddress;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (Exception ex2) {
                _Logger.error((Object)"findSwitchMgmtAddrByPk error", (Throwable)ex2);
                InetAddress inetAddress2 = null;
                return inetAddress2;
            }
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(queryAddrStat);
            DbUtil.close(con);
        }
        DbUtil.close(queryAddrStat);
        DbUtil.close(con);
        return ip;
    }

    public static boolean isSwitchIsECHSupported(long id) throws SQLException {
        ResultSet rs;
        PreparedStatement selectStat;
        Connection con;
        block5: {
            con = null;
            selectStat = null;
            rs = null;
            con = ConnectionManager.getConnection();
            selectStat = con.prepareStatement(isECHSUPPORTBySwitchID);
            selectStat.setLong(1, id);
            rs = selectStat.executeQuery();
            if (!rs.next()) break block5;
            boolean bl = rs.getInt(1) == 1;
            DbUtil.close(rs);
            DbUtil.close(selectStat);
            DbUtil.close(con);
            return bl;
        }
        try {
            try {
                throw new SQLException("No data entry can be retrieve for switch id: " + id);
            }
            catch (SQLException ex) {
                _Logger.error((Object)"isSwitchIsECHSupported error", (Throwable)ex);
                throw new SQLException("Querying Switch is_ech_support error: " + ex.getMessage());
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(rs);
            DbUtil.close(selectStat);
            DbUtil.close(con);
            throw throwable;
        }
    }

    public static boolean updateSwitchIsECHSupported(long id, boolean is_ech_support) throws SQLException {
        boolean bl;
        PreparedStatement updateStat;
        Connection con;
        block5: {
            con = null;
            updateStat = null;
            int num = 0;
            con = ConnectionManager.getConnection();
            updateStat = con.prepareStatement(UpdateISECHSUPPORTBySwitchID);
            updateStat.setInt(1, is_ech_support ? 1 : 0);
            updateStat.setLong(2, id);
            num = updateStat.executeUpdate();
            if (num <= 0) break block5;
            boolean bl2 = true;
            DbUtil.close(updateStat);
            DbUtil.close(con);
            return bl2;
        }
        try {
            bl = false;
        }
        catch (SQLException ex) {
            try {
                _Logger.error((Object)"updateSwitchIsECHSupported error", (Throwable)ex);
                throw new SQLException("Updating Switch is_ech_support error: " + ex.getMessage());
            }
            catch (Throwable throwable) {
                DbUtil.close(updateStat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(updateStat);
        DbUtil.close(con);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList loadFromDB(FabricImpl fImpl) throws SQLException {
        ArrayList<SwitchImpl> arrayList;
        Connection con = ConnectionManager.getConnection();
        PreparedStatement queryStat = null;
        PreparedStatement queryAddrStat = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        try {
            queryStat = con.prepareStatement(QuerySQLByFabricID);
            queryAddrStat = con.prepareStatement(QueryMgmtAddrSQLBySwitchID);
            queryStat.setLong(1, fImpl.getDBID());
            rs1 = queryStat.executeQuery();
            ArrayList<SwitchImpl> al = SwitchImpl.loadDBRecord(rs1, fImpl);
            for (int i = 0; i < al.size(); ++i) {
                SwitchImpl swIpl = al.get(i);
                swIpl.setFabric(fImpl);
                if (swIpl.isNpvEnabled()) {
                    swIpl.setDiscFlags(16719);
                } else {
                    swIpl.setDiscFlags(97279);
                }
                queryAddrStat.setLong(1, swIpl.getDBID());
                rs2 = queryAddrStat.executeQuery();
                ArrayList<InetAddress> ips = new ArrayList<InetAddress>();
                while (rs2.next()) {
                    try {
                        InetAddress ip = InetAddress.getByAddress(rs2.getBytes(1));
                        byte type = rs2.getByte(2);
                        ips.add(ip);
                    }
                    catch (Exception ex) {}
                }
                if (ips.size() > 0) {
                    InetAddress[] addrs = new InetAddress[ips.size()];
                    for (int j = 0; j < ips.size(); ++j) {
                        addrs[j] = (InetAddress)ips.get(j);
                    }
                    swIpl.setManagementAddresses(addrs);
                }
                DbUtil.close(rs2);
            }
            arrayList = al;
            DbUtil.close(rs1);
        }
        catch (SQLException ex) {
            ArrayList arrayList2 = null;
            return arrayList2;
        }
        finally {
            DbUtil.close(rs1);
            DbUtil.close(rs2);
            DbUtil.close(queryStat);
            DbUtil.close(queryAddrStat);
            DbUtil.close(con);
        }
        DbUtil.close(rs2);
        DbUtil.close(queryStat);
        DbUtil.close(queryAddrStat);
        DbUtil.close(con);
        return arrayList;
    }

    public static ArrayList<SwitchImpl> loadDBRecord(ResultSet rs, FabricImpl fImpl) throws SQLException {
        ArrayList<SwitchImpl> al = new ArrayList<SwitchImpl>();
        while (rs.next()) {
            int vendorId;
            Wwn wwn = null;
            try {
                wwn = new Wwn(rs.getBytes(3));
            }
            catch (Exception ex) {
                // empty catch block
            }
            InetAddress ip = null;
            try {
                byte[] b = rs.getBytes(4);
                if (b != null) {
                    ip = InetAddress.getByAddress(b);
                }
            }
            catch (UnknownHostException ex) {
                ex.printStackTrace();
            }
            boolean isMDS = rs.getBoolean(5);
            WwnVendor v = null;
            if (isMDS && wwn != null && WwnDictionary.findWwnVendor(vendorId = WwnDictionary.getVendorId(wwn.getValue())) == null && (v = WwnDictionary.addDiscoveredOUI(vendorId, "Cisco", 32)) != null) {
                _Logger.info((Object)("***** Add new discovered OUI to WwnDictionary:" + WwnVendor.format(v) + "; please add the new OUI to server.properties->newOUIs as permanent one."));
            }
            SwitchImpl sw = SanManager.getInstance().createSwitch(wwn, ip, fImpl);
            sw.setMDS(isMDS);
            if (v != null) {
                sw.addNewOUI(v);
            }
            sw.setDBID(rs.getLong(1));
            sw._base.setModelType(rs.getInt(6));
            sw._base.setManageable(rs.getBoolean(7));
            sw._base.setModelName(rs.getString(8));
            sw._base.setSysName(rs.getString(9));
            sw._base.setSysContact(rs.getString(10));
            sw._base.setSysLocation(rs.getString(11));
            sw._base.setSysLastBootTime(rs.getLong(12));
            int activeSupSlot = rs.getInt(13);
            sw._base.setConnUnitStatus(rs.getInt(14));
            sw._base.setStandbySupState(rs.getInt(15));
            sw._base.setFeatureFlagsDB(rs.getString(16));
            sw._base.setLicenseViolation(rs.getBoolean(17));
            sw._base.setVersion(rs.getString(18));
            sw._base.setPresent(rs.getBoolean(19));
            sw._base.setSerialNumber(rs.getString(20));
            sw._base.setUnmanageableCause(rs.getString(21));
            sw._base.setLastScanTime(rs.getLong(22));
            sw._base.setNumFcPorts(rs.getInt(23));
            sw._base.setTrapRegistered(rs.getBoolean(24));
            sw._base.setSyslogRegistered(rs.getBoolean(25));
            sw._base.setStandbySupSlot(rs.getInt(26));
            int moduleOffset = rs.getInt(27);
            sw._base.setModuleIndexOffset(moduleOffset);
            sw._base.setActiveSupPhysicalIndex(activeSupSlot + moduleOffset);
            sw._base.setDeviceAliasMode(rs.getInt(27));
            sw._base.setSysCpuUsage(rs.getInt(29));
            sw._base.setSysMemoryUsage(rs.getInt(30));
            FileLicensingHelper.handleLicenseDecodingFromDBValue(sw._base, rs.getString(31), rs.getString(32));
            sw._base.setVdc(rs.getBoolean(33));
            sw._base.setVdcId(rs.getInt(34));
            sw._base.setFCoECapable(rs.getBoolean(35));
            byte[] macBytes = rs.getBytes(36);
            if (macBytes != null) {
                sw._base.setVdcMacAddress(new MacAddress(macBytes));
            }
            sw._base.setPrimaryIp(rs.getString(37));
            sw._base.setSecondaryIp(rs.getString(38));
            al.add(sw);
        }
        return al;
    }

    public static String getInsertSqlStr() {
        return InsertSQL;
    }

    public static String getUpdateSqlStr() {
        return UpdateSQL;
    }

    public static String getCheckExistenceByWwnSqlStr() {
        return QuerySQLByWwn;
    }

    public static String getCheckExistenceByFabricIdWwnSqlStr() {
        return QuerySQLByFabricIDWwn;
    }

    public static String getCheckExistenceByIpSqlStr() {
        return QuerySQLByIPAddress;
    }

    public static String getCheckExistenceByFabricIdIpSqlStr() {
        return QuerySQLByFabricIDIPAddress;
    }

    public void setupInsertStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this.getDBID());
        stat.setLong(2, this._fabric.getDBID());
        if (this._base.getWwn() != null) {
            stat.setBytes(3, this._base.getWwn().getValue());
        } else {
            stat.setNull(3, -2);
        }
        if (this._base.getInetAddress() != null) {
            stat.setBytes(4, this._base.getInetAddress().getAddress());
        } else {
            stat.setNull(4, -2);
        }
        stat.setBoolean(5, this._base.isMDS());
        stat.setInt(6, this._base.getModelType());
        stat.setBoolean(7, this._base.isManageable());
        stat.setString(8, this._base.getModelName());
        stat.setString(9, this.getName());
        stat.setString(10, this._base.getSysContact());
        stat.setString(11, this._base.getSysLocation());
        stat.setLong(12, this._base.getSysLastBootTime());
        stat.setInt(13, this._base.getActiveSupSlot());
        stat.setInt(14, this._base.getConnUnitStatus());
        stat.setInt(15, this._base.getStandbySupState());
        stat.setString(16, this._base.getFeatureFlagsDB());
        stat.setBoolean(17, this._base.isLicenseViolation());
        stat.setString(18, this._base.getVersion());
        stat.setBoolean(19, this.isPresent());
        stat.setString(20, this._base.getSerialNumber());
        stat.setString(21, this._base.getUnmanageableCause());
        stat.setLong(22, this._base.getLastScanTime());
        stat.setTimestamp(23, new Timestamp(System.currentTimeMillis()));
        stat.setInt(24, this._base.getNumFcPorts());
        stat.setBoolean(25, this._base.isTrapRegistered());
        stat.setBoolean(26, this._base.isSyslogRegistered());
        stat.setInt(27, this._base.getStandbySupSlot());
        stat.setInt(28, this._base.getModuleIndexOffset());
        stat.setInt(29, this._base.getDeviceAliasMode());
        stat.setInt(30, this._base.getSysCpuUsage());
        stat.setInt(31, this._base.getSysMemoryUsage());
        String sign = null;
        String licDetails = "";
        try {
            sign = this._base.getLicenseDetails() == null ? "" : this._base.getLicenseDetails().getSign();
            licDetails = FileLicensingHelper.processLicDetailStringForDB(this._base);
        }
        catch (Exception e) {
            _Logger.error((Object)("Unable to encrypt switch license details for DB, switch will show as unlicensed - " + this._base), (Throwable)e);
        }
        stat.setString(32, sign);
        stat.setString(33, licDetails);
        stat.setBoolean(34, this._base.isVdc());
        stat.setInt(35, this._base.getVdcId());
        stat.setBoolean(36, this._base.isFCoECapable());
        if (this._base.getVdcMacAddress() != null) {
            stat.setBytes(37, this._base.getVdcMacAddress().getBytes());
        } else {
            stat.setNull(37, -2);
        }
        stat.setInt(38, this._base.getNum1gPorts());
        stat.setInt(39, this._base.getNum2gPorts());
        stat.setInt(40, this._base.getNum4gPorts());
        stat.setInt(41, this._base.getNum8gPorts());
        stat.setInt(42, this._base.getNum10gPorts());
        stat.setInt(43, this._base.getNum16gPorts());
        stat.setInt(44, this._base.getNum40gPorts());
        stat.setInt(45, this._base.getNum100gPorts());
        stat.setBoolean(46, this._base.getLicenseDetails() == null ? false : this._base.getLicenseDetails().isLicensed());
        stat.setString(47, this._base.getPrimaryIp());
        stat.setString(48, this._base.getSecondaryIp());
    }

    public void setupUpdateStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this._fabric.getDBID());
        if (this._base.getWwn() != null) {
            stat.setBytes(2, this._base.getWwn().getValue());
        } else {
            stat.setNull(2, -2);
        }
        if (this._base.getInetAddress() != null) {
            stat.setBytes(3, this._base.getInetAddress().getAddress());
        } else {
            stat.setNull(3, -2);
        }
        stat.setBoolean(4, this._base.isMDS());
        stat.setInt(5, this._base.getModelType());
        stat.setBoolean(6, this._base.isManageable());
        stat.setString(7, this._base.getModelName());
        stat.setString(8, this.getName());
        stat.setString(9, this._base.getSysContact());
        stat.setString(10, this._base.getSysLocation());
        stat.setLong(11, this._base.getSysLastBootTime());
        stat.setInt(12, this._base.getActiveSupSlot());
        stat.setInt(13, this._base.getConnUnitStatus());
        stat.setInt(14, this._base.getStandbySupState());
        stat.setString(15, this._base.getFeatureFlagsDB());
        stat.setBoolean(16, this._base.isLicenseViolation());
        stat.setString(17, this._base.getVersion());
        stat.setBoolean(18, this.isPresent());
        stat.setString(19, this._base.getSerialNumber());
        stat.setString(20, this._base.getUnmanageableCause());
        stat.setLong(21, this._base.getLastScanTime());
        stat.setTimestamp(22, new Timestamp(System.currentTimeMillis()));
        stat.setInt(23, this._base.getNumFcPorts());
        stat.setBoolean(24, this._base.isTrapRegistered());
        stat.setBoolean(25, this._base.isSyslogRegistered());
        stat.setInt(26, this._base.getStandbySupSlot());
        stat.setInt(27, this._base.getModuleIndexOffset());
        stat.setInt(28, this._base.getDeviceAliasMode());
        stat.setInt(29, this._base.getSysCpuUsage());
        stat.setInt(30, this._base.getSysMemoryUsage());
        String sign = null;
        String licDetails = "";
        try {
            sign = this._base.getLicenseDetails() == null ? "" : this._base.getLicenseDetails().getSign();
            licDetails = FileLicensingHelper.processLicDetailStringForDB(this._base);
        }
        catch (Exception e) {
            _Logger.error((Object)("Unable to encrypt switch license details for DB, switch will show as unlicensed - " + this._base), (Throwable)e);
        }
        stat.setString(31, sign);
        stat.setString(32, licDetails);
        stat.setBoolean(33, this._base.isVdc());
        stat.setInt(34, this._base.getVdcId());
        stat.setBoolean(35, this._base.isFCoECapable());
        if (this._base.getVdcMacAddress() != null) {
            stat.setBytes(36, this._base.getVdcMacAddress().getBytes());
        } else {
            stat.setNull(36, -2);
        }
        stat.setInt(37, this._base.getNum1gPorts());
        stat.setInt(38, this._base.getNum2gPorts());
        stat.setInt(39, this._base.getNum4gPorts());
        stat.setInt(40, this._base.getNum8gPorts());
        stat.setInt(41, this._base.getNum10gPorts());
        stat.setInt(42, this._base.getNum16gPorts());
        stat.setInt(43, this._base.getNum40gPorts());
        stat.setInt(44, this._base.getNum100gPorts());
        stat.setBoolean(45, this._base.getLicenseDetails() == null ? false : this._base.getLicenseDetails().isLicensed());
        stat.setString(46, this._base.getPrimaryIp());
        stat.setString(47, this._base.getSecondaryIp());
        stat.setLong(48, this.getDBID());
    }

    public void setupCheckExistenceByWwnStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setBytes(1, this.getWwn().getValue());
    }

    public void setupCheckExistenceByFabricIdWwnStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setInt(1, this.getFabricPK().get_fid());
        stat.setBytes(2, this.getWwn().getValue());
    }

    public void setupCheckExistenceByIpStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        if (this.getInetAddress() != null) {
            stat.setBytes(1, this.getInetAddress().getAddress());
        } else {
            stat.setNull(1, -2);
        }
    }

    public void setupCheckExistenceByFabricIdIpStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setInt(1, this.getFabricPK().get_fid());
        if (this.getInetAddress() != null) {
            stat.setBytes(2, this.getInetAddress().getAddress());
        } else {
            stat.setNull(2, -2);
        }
    }

    public SwitchLicenseDetails getLicenseDetails() {
        return this._base.getLicenseDetails();
    }

    public void setLicenseDetails(SwitchLicenseDetails licDetails) {
        this._base.setLicenseDetails(licDetails);
    }

    public LicenseInfo getFmServerPkgLicenseInfo() {
        return this._fmServerPkgLicenseInfo;
    }

    public void setFmServerPkgLicenseInfo(LicenseInfo fmServerPkgLicenseInfo) {
        this._fmServerPkgLicenseInfo = fmServerPkgLicenseInfo;
    }
}

