/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.model.AbstractDBObjectImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public class VpcImpl
extends AbstractDBObjectImpl {
    static final String InsertSQL = "insert into vpc_info(id, vpc_id, domain_id, multichassis_vpc_sw_id, primary_vpc_switch_id, primary_vpc_po_id, primary_vpc_peerlink_id, secondary_vpc_switch_id, secondary_vpc_po_id, secondary_vpc_peerlink_id, is_vpc_consistent, is_peerlink_consistent, last_update_time) values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
    static final String UpdateSQL = "update vpc_info set vpc_id=?, domain_id=?, multichassis_vpc_sw_id=?, primary_vpc_po_id=?, primary_vpc_peerlink_id=?, secondary_vpc_po_id=?, secondary_vpc_peerlink_id=?, is_vpc_consistent=?, is_peerlink_consistent=?, last_update_time=? where vpc_id=? and primary_vpc_switch_id=? and secondary_vpc_switch_id=?";
    static final String QuerySQLByVpcPeerSwitchIds = "select id from vpc_info where vpc_id=? and primary_vpc_switch_id=? and secondary_vpc_switch_id=?";
    static final String TableName = "vpc_info";
    private int vpcID;
    private int domainID;
    private PKIf primaryVpcSwPK;
    private long primaryVpcSwDbID;
    private int primaryVpcPoID;
    private int primaryVpcPeerLinkPoID;
    private PKIf secondaryVpcSwPK;
    private long secondaryVpcSwDbID;
    private int secondaryVpcPoID;
    private int secondaryVpcPeerLinkPoID;
    private long multichassisVpcSwDbID;
    private boolean isVpcConsistent;
    private boolean isVpcPeerConsistent;

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        if (this.getDBID() == 0L) {
            this.setDBID(Sequence.getSequence().getPK());
            PreparedStatement stat = con.prepareStatement(InsertSQL);
            this.setupInsertStatement(stat);
            return stat;
        }
        PreparedStatement stat = con.prepareStatement(UpdateSQL);
        this.setupUpdateStatement(stat);
        return stat;
    }

    public PreparedStatement getCheckExistanceStatement(Connection con) throws SQLException {
        return con.prepareStatement(VpcImpl.getCheckExistenceSqlStr());
    }

    public PreparedStatement getInsertStatement(Connection con) throws SQLException {
        return con.prepareStatement(VpcImpl.getInsertSqlStr());
    }

    public PreparedStatement getUpdateStatement(Connection con) throws SQLException {
        return con.prepareStatement(VpcImpl.getUpdateSqlStr());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPreexistRecord(Connection con) throws SQLException {
        ResultSet rs;
        PreparedStatement stat;
        block4: {
            stat = con.prepareStatement(QuerySQLByVpcPeerSwitchIds);
            rs = null;
            try {
                this.setupCheckExistenceStatement(stat);
                rs = stat.executeQuery();
                if (!rs.next()) break block4;
                this.setDBID(rs.getLong(1));
            }
            catch (SQLException ex) {
                try {
                    ex.printStackTrace();
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stat);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
    }

    public void setupInsertStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        int i = 1;
        stat.setLong(i++, this.getDBID());
        stat.setInt(i++, this.vpcID);
        stat.setLong(i++, this.domainID);
        stat.setLong(i++, this.multichassisVpcSwDbID);
        stat.setLong(i++, this.primaryVpcSwDbID);
        stat.setInt(i++, this.primaryVpcPoID);
        stat.setInt(i++, this.primaryVpcPeerLinkPoID);
        stat.setLong(i++, this.secondaryVpcSwDbID);
        stat.setInt(i++, this.secondaryVpcPoID);
        stat.setInt(i++, this.secondaryVpcPeerLinkPoID);
        stat.setBoolean(i++, this.isVpcConsistent);
        stat.setBoolean(i++, this.isVpcPeerConsistent);
        stat.setTimestamp(i++, new Timestamp(System.currentTimeMillis()));
    }

    public void setupUpdateStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        int i = 1;
        stat.setInt(i++, this.vpcID);
        stat.setLong(i++, this.domainID);
        stat.setLong(i++, this.multichassisVpcSwDbID);
        stat.setInt(i++, this.primaryVpcPoID);
        stat.setInt(i++, this.primaryVpcPeerLinkPoID);
        stat.setInt(i++, this.secondaryVpcPoID);
        stat.setInt(i++, this.secondaryVpcPeerLinkPoID);
        stat.setBoolean(i++, this.isVpcConsistent);
        stat.setBoolean(i++, this.isVpcPeerConsistent);
        stat.setTimestamp(i++, new Timestamp(System.currentTimeMillis()));
        stat.setInt(i++, this.vpcID);
        stat.setLong(i++, this.primaryVpcSwDbID);
        stat.setLong(i++, this.secondaryVpcSwDbID);
    }

    public void setupCheckExistenceStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this.vpcID);
        stat.setLong(2, this.primaryVpcSwDbID);
        stat.setLong(3, this.secondaryVpcSwDbID);
    }

    @Override
    public String getDBTableName() {
        return TableName;
    }

    public static String getInsertSqlStr() {
        return InsertSQL;
    }

    public static String getUpdateSqlStr() {
        return UpdateSQL;
    }

    public static String getCheckExistenceSqlStr() {
        return QuerySQLByVpcPeerSwitchIds;
    }

    public int getVpcID() {
        return this.vpcID;
    }

    public void setVpcID(int vpcID) {
        this.vpcID = vpcID;
    }

    public int getDomainID() {
        return this.domainID;
    }

    public void setDomainID(int domainID) {
        this.domainID = domainID;
    }

    public PKIf getPrimaryVpcSwPK() {
        return this.primaryVpcSwPK;
    }

    public void setPrimaryVpcSwPK(PKIf primaryVpcSwPK) {
        this.primaryVpcSwPK = primaryVpcSwPK;
    }

    public long getPrimaryVpcSwDbID() {
        return this.primaryVpcSwDbID;
    }

    public void setPrimaryVpcSwDbID(long primaryVpcSwDbID) {
        this.primaryVpcSwDbID = primaryVpcSwDbID;
    }

    public int getPrimaryVpcPoID() {
        return this.primaryVpcPoID;
    }

    public void setPrimaryVpcPoID(int primaryVpcPoID) {
        this.primaryVpcPoID = primaryVpcPoID;
    }

    public int getPrimaryVpcPeerLinkID() {
        return this.primaryVpcPeerLinkPoID;
    }

    public void setPrimaryVpcPeerLinkID(int primaryVpcPeerLinkPoID) {
        this.primaryVpcPeerLinkPoID = primaryVpcPeerLinkPoID;
    }

    public PKIf getSecondaryVpcSwPK() {
        return this.secondaryVpcSwPK;
    }

    public void setSecondaryVpcSwPK(PKIf secondaryVpcSwPK) {
        this.secondaryVpcSwPK = secondaryVpcSwPK;
    }

    public long getSecondaryVpcSwDbID() {
        return this.secondaryVpcSwDbID;
    }

    public void setSecondaryVpcSwDbID(long secondaryVpcSwDbID) {
        this.secondaryVpcSwDbID = secondaryVpcSwDbID;
    }

    public int getSecondaryVpcPoID() {
        return this.secondaryVpcPoID;
    }

    public void setSecondaryVpcPoID(int secondaryVpcPoID) {
        this.secondaryVpcPoID = secondaryVpcPoID;
    }

    public int getSecondaryVpcPeerLinkID() {
        return this.primaryVpcPeerLinkPoID;
    }

    public void setSecondaryVpcPeerLinkID(int secondaryVpcPeerLinkPoID) {
        this.secondaryVpcPeerLinkPoID = secondaryVpcPeerLinkPoID;
    }

    public boolean isVpcConsistent() {
        return this.isVpcConsistent;
    }

    public void setVpcConsistent(boolean isVpcConsistent) {
        this.isVpcConsistent = isVpcConsistent;
    }

    public boolean isVpcPeerConsistent() {
        return this.isVpcPeerConsistent;
    }

    public void setVpcPeerConsistent(boolean isVpcPeerConsistent) {
        this.isVpcPeerConsistent = isVpcPeerConsistent;
    }

    public long getMultichassisVpcSwDbID() {
        return this.multichassisVpcSwDbID;
    }

    public void setMultichassisVpcSwDbID(long multichassisVpcSwDbID) {
        this.multichassisVpcSwDbID = multichassisVpcSwDbID;
    }
}

