/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.sm.common.dto.VsanDomain;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.model.AbstractDBObjectImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.model.VsanImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;

public final class VsanDomainImpl
extends AbstractDBObjectImpl {
    static final String QuerySQLByFabricId = "select vsan_domain_info.vsan_id, vsan_domain_info.switch_id, vsan_domain_info.domain_id,vsan_domain_info.wwn from vsan_domain_info, vsan where vsan.fabric_id=? and vsan_domain_info.vsan_id=vsan.id";
    static final String QuerySQLByVsanSwitchId = "select vsan_id, switch_id, domain_id, wwn from vsan_domain_info where vsan_id=? and switch_id=?";
    static final String InsertSQL = "insert into vsan_domain_info(vsan_id, switch_id, domain_id, wwn, last_update_time) values(?,?,?,?,?)";
    static final String UpdateSQL = "update vsan_domain_info set domain_id=?, wwn=?, last_update_time=? where vsan_id=? and switch_id=?";
    static final String TableName = "vsan_domain_info";
    final VsanDomain _base;
    final VsanImpl _vsan;
    final SwitchImpl _sw;

    public VsanDomainImpl(VsanImpl vsan, int did, Wwn wwn, SwitchImpl sw) {
        if (vsan == null || sw == null) {
            throw new IllegalArgumentException("Null Vsan or Switch is not allowed");
        }
        this._base = new VsanDomain(vsan.getVsanPK(), (short)did, wwn);
        this._sw = sw;
        this._vsan = vsan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPreexistRecord(Connection con) throws SQLException {
        ResultSet rs;
        PreparedStatement stat;
        block4: {
            stat = con.prepareStatement(QuerySQLByVsanSwitchId);
            rs = null;
            try {
                this.setupCheckExistenceStatement(stat);
                rs = stat.executeQuery();
                if (!rs.next()) break block4;
                this.setDBID(1L);
            }
            catch (SQLException ex) {
                try {
                    ex.printStackTrace();
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stat);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        if (this.getDBID() == 0L) {
            this.setDBID(Sequence.getSequence().getPK());
            PreparedStatement stat = con.prepareStatement(InsertSQL);
            this.setupInsertStatement(stat);
            return stat;
        }
        PreparedStatement stat = con.prepareStatement(UpdateSQL);
        this.setupUpdateStatement(stat);
        return stat;
    }

    @Override
    public String getDBTableName() {
        return TableName;
    }

    public static void loadFromDB(FabricImpl fImpl) throws SQLException {
        Connection con = null;
        ResultSet rs = null;
        PreparedStatement stat = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(QuerySQLByFabricId);
            stat.setLong(1, fImpl.getDBID());
            rs = stat.executeQuery();
            VsanDomainImpl.loadDBRecord(rs, fImpl);
        }
        catch (SQLException ex) {
            try {
                ex.printStackTrace();
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
    }

    public static ArrayList loadDBRecord(ResultSet rs, FabricImpl fImpl) throws SQLException {
        while (rs.next()) {
            VsanImpl vImpl = fImpl.findVsanByDbId(rs.getLong(1));
            SwitchImpl swImpl = fImpl.findSwitchByDbId(rs.getLong(2));
            if (vImpl == null || swImpl == null) continue;
            byte[] bytes = rs.getBytes(4);
            Wwn wwn = bytes == null ? null : new Wwn(bytes);
            vImpl.addSwitch(swImpl, (short)rs.getInt(3), wwn);
        }
        return null;
    }

    public static String getInsertSqlStr() {
        return InsertSQL;
    }

    public static String getUpdateSqlStr() {
        return UpdateSQL;
    }

    public static String getCheckExistenceSqlStr() {
        return QuerySQLByVsanSwitchId;
    }

    public void setupInsertStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this._vsan.getDBID());
        stat.setLong(2, this._sw.getDBID());
        stat.setShort(3, this._base._domainId);
        if (this._base.getVsanWwn() != null) {
            stat.setBytes(4, this._base.getVsanWwn().getValue());
        } else {
            stat.setBytes(4, null);
        }
        stat.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
    }

    public void setupUpdateStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setShort(1, this._base._domainId);
        if (this._base.getVsanWwn() != null) {
            stat.setBytes(2, this._base.getVsanWwn().getValue());
        } else {
            stat.setBytes(2, null);
        }
        stat.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
        stat.setLong(4, this._vsan.getDBID());
        stat.setLong(5, this._sw.getDBID());
    }

    public void setupCheckExistenceStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this._vsan.getDBID());
        stat.setLong(2, this._sw.getDBID());
    }
}

