/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.sm.common.type.VsanFcIdKey;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.model.AbstractDBObjectImpl;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.VsanImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;

public final class VsanNxPortImpl
extends AbstractDBObjectImpl {
    static final String QuerySQLByFabricId = "select vsan_endport_info.vsan_id, vsan_endport_info.endport_id, vsan_endport_info.fcid from vsan_endport_info, vsan where vsan.fabric_id=? and vsan_endport_info.vsan_id = vsan.id";
    static final String QuerySQLByVsanEndPort = "select fcid from vsan_endport_info where vsan_id=? and endport_id=?";
    static final String InsertSQL = "insert into vsan_endport_info(vsan_id, endport_id, fcid,last_update_time) values(?,?,?,?)";
    static final String UpdateSQL = "update vsan_endport_info set fcid=?, last_update_time=? where vsan_id=? and endport_id=?";
    static final String TableName = "vsan_endport_info";
    final VsanImpl _vsan;
    final int _fcId;
    final EndPortImpl _ep;

    public VsanNxPortImpl(VsanImpl vsan, VsanFcIdKey key, EndPortImpl ep) throws IllegalArgumentException {
        if (vsan == null || ep == null) {
            throw new IllegalArgumentException("Null Vsan or EndPort is not allowed");
        }
        this._vsan = vsan;
        this._fcId = key._fcId;
        this._ep = ep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPreexistRecord(Connection con) throws SQLException {
        block6: {
            PreparedStatement stat = null;
            ResultSet rs = null;
            try {
                stat = con.prepareStatement(QuerySQLByVsanEndPort);
                this.setupCheckExistenceStatement(stat);
                rs = stat.executeQuery();
                if (rs.next()) {
                    this.setDBID(1L);
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        if (this.getDBID() == 0L) {
            this.setDBID(Sequence.getSequence().getPK());
            PreparedStatement stat = con.prepareStatement(InsertSQL);
            this.setupInsertStatement(stat);
            return stat;
        }
        PreparedStatement stat = con.prepareStatement(UpdateSQL);
        this.setupUpdateStatement(stat);
        return stat;
    }

    @Override
    public String getDBTableName() {
        return TableName;
    }

    public static void loadFromDB(FabricImpl fImpl) throws SQLException {
        Connection con = ConnectionManager.getConnection();
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            stat = con.prepareStatement(QuerySQLByFabricId);
            stat.setLong(1, fImpl.getDBID());
            rs = stat.executeQuery();
            VsanNxPortImpl.loadDBRecord(rs, fImpl);
        }
        catch (SQLException ex) {
            try {
                ex.printStackTrace();
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
    }

    public static ArrayList loadDBRecord(ResultSet rs, FabricImpl fImpl) throws SQLException {
        while (rs.next()) {
            VsanImpl vImpl = fImpl.findVsanByDbId(rs.getLong(1));
            EndPortImpl epImpl = fImpl.findEndPortByDbId(rs.getLong(2));
            if (vImpl == null || epImpl == null) continue;
            vImpl.addEndPort(epImpl, rs.getInt(3));
        }
        return null;
    }

    public static String getInsertSqlStr() {
        return InsertSQL;
    }

    public static String getUpdateSqlStr() {
        return UpdateSQL;
    }

    public static String getCheckExistenceSqlStr() {
        return QuerySQLByVsanEndPort;
    }

    public void setupInsertStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this._vsan.getDBID());
        stat.setLong(2, this._ep.getDBID());
        stat.setInt(3, this._fcId);
        stat.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
    }

    public void setupUpdateStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setInt(1, this._fcId);
        stat.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
        stat.setLong(3, this._vsan.getDBID());
        stat.setLong(4, this._ep.getDBID());
    }

    public void setupCheckExistenceStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this._vsan.getDBID());
        stat.setLong(2, this._ep.getDBID());
    }
}

