/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.common.model.ZoneBase;
import com.cisco.dcbu.sm.common.model.ZoneMemberBase;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DBObjectIf;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.model.AbstractDBObjectImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.VsanImpl;
import com.cisco.dcbu.sm.server.model.ZoneMemberImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class ZoneImpl
extends AbstractDBObjectImpl {
    static final String QuerySQL = "select id, parent_id, zone_index, name, read_only, qos, qos_priority, broadcast, is_ivr from zone";
    static final String QuerySQLByParentID = "select id, parent_id, zone_index, name, read_only, qos, qos_priority, broadcast, cfs_region_id from zone where parent_id=? and is_ivr=?";
    static final String QuerySQLByParentIDZoneName = "select id from zone where parent_id=? and name=? and is_ivr=?";
    static final String InsertSQL = "insert into zone(id, parent_id, zone_index, name, read_only, is_ivr,  qos, qos_priority, broadcast, cfs_region_id, last_update_time) values(?,?,?,?,?, ?,?,?,?,?, ?)";
    static final String UpdateSQL = "update zone set parent_id=?, zone_index=?, name=?, read_only=?, is_ivr=?,  qos=?, qos_priority=?, broadcast=?, cfs_region_id=?, last_update_time=? where id=?";
    static final String TableName = "zone";
    final ZoneBase _zone;
    final VsanImpl _vsan;
    final FabricImpl _fabric;
    final boolean _isIvr;

    public ZoneImpl(VsanImpl vsan, ZoneBase zone) {
        this._fabric = null;
        this._vsan = vsan;
        this._zone = zone;
        this._isIvr = false;
    }

    public ZoneImpl(FabricImpl fabric, ZoneBase zone) {
        this._fabric = fabric;
        this._vsan = null;
        this._zone = zone;
        this._isIvr = true;
    }

    public ZoneBase getBaseObject() {
        return this._zone;
    }

    public FabricImpl getFabric() {
        return this._fabric;
    }

    public VsanImpl getVsan() {
        return this._vsan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPreexistRecord(Connection con) throws SQLException {
        block6: {
            PreparedStatement stat = null;
            ResultSet rs = null;
            try {
                stat = con.prepareStatement(QuerySQLByParentIDZoneName);
                this.setupCheckExistenceStatement(stat);
                rs = stat.executeQuery();
                if (rs.next()) {
                    this.setDBID(rs.getLong(1));
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        if (!this._isIvr && this._vsan == null || this._isIvr && this._fabric == null || this._zone == null) {
            System.err.println("Error : zone " + this._zone.getName() + " can not be persiste: ivr ?" + this._isIvr + " in fabric " + this._fabric.getPK() + " vsan " + this._vsan);
            return null;
        }
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        if (this.getDBID() == 0L) {
            this.setDBID(Sequence.getSequence().getPK());
            PreparedStatement stat = con.prepareStatement(InsertSQL);
            this.setupInsertStatement(stat);
            return stat;
        }
        PreparedStatement stat = con.prepareStatement(UpdateSQL);
        this.setupUpdateStatement(stat);
        return stat;
    }

    @Override
    public String getDBTableName() {
        return TableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList loadFromDB(DBObjectIf impl) throws SQLException {
        ArrayList arrayList;
        Connection con = ConnectionManager.getConnection();
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            stat = con.prepareStatement(QuerySQLByParentID);
            stat.setLong(1, impl.getDBID());
            if (impl instanceof VsanImpl) {
                stat.setBoolean(2, false);
            } else {
                stat.setBoolean(2, true);
            }
            rs = stat.executeQuery();
            arrayList = ZoneImpl.loadDBRecord(rs, impl);
            DbUtil.close(rs);
        }
        catch (SQLException ex) {
            ArrayList arrayList2 = null;
            return arrayList2;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return arrayList;
    }

    public static ArrayList loadDBRecord(ResultSet rs, DBObjectIf impl) throws SQLException {
        ArrayList<ZoneImpl> al = new ArrayList<ZoneImpl>();
        ArrayList<ZoneBase> zal = new ArrayList<ZoneBase>();
        ConcurrentHashMap<Integer, HashSet<ZoneBase>> zoneByRegion = new ConcurrentHashMap<Integer, HashSet<ZoneBase>>();
        while (rs.next()) {
            ZoneBase zone = new ZoneBase(rs.getInt(3), rs.getString(4), rs.getBoolean(5), rs.getBoolean(6), rs.getInt(7), rs.getBoolean(8), rs.getInt(9));
            ZoneImpl zoneImpl = null;
            if (impl instanceof VsanImpl) {
                zoneImpl = new ZoneImpl((VsanImpl)impl, zone);
                zal.add(zone);
            } else {
                zoneImpl = new ZoneImpl((FabricImpl)impl, zone);
                HashSet<ZoneBase> zones = (HashSet<ZoneBase>)zoneByRegion.get(zone.getCfsRegion());
                if (zones == null) {
                    zones = new HashSet<ZoneBase>();
                    zoneByRegion.put(zone.getCfsRegion(), zones);
                }
                zones.add(zone);
            }
            zoneImpl.setDBID(rs.getLong(1));
            al.add(zoneImpl);
        }
        ZoneBase[] zas = zal.toArray(new ZoneBase[zal.size()]);
        if (impl instanceof VsanImpl) {
            ((VsanImpl)impl).setEnforcedZones(zas);
        } else {
            for (Integer region : zoneByRegion.keySet()) {
                int regionId = region;
                Set zoneList = (Set)zoneByRegion.get(regionId);
                ZoneBase[] zones = zoneList.toArray(new ZoneBase[zoneList.size()]);
                ((FabricImpl)impl).setIvrEnforcedZones(regionId, zones);
            }
        }
        return al;
    }

    public static String dump(ZoneBase zone, int level) {
        StringBuffer sb = new StringBuffer(FabricImpl.LIL[level]).append(zone.getName());
        Array zmbrs = zone.getMembers();
        for (int i = 0; i < zmbrs.size(); ++i) {
            sb.append(FabricImpl.LIL[level + 1]).append(ZoneMemberImpl.dump((ZoneMemberBase)zmbrs.elementAt(i)));
        }
        return sb.toString();
    }

    public void clearMembers() {
        if (this._zone.getMembers() != null) {
            this._zone.getMembers().clear();
        }
    }

    public static String getInsertSqlStr() {
        return InsertSQL;
    }

    public static String getUpdateSqlStr() {
        return UpdateSQL;
    }

    public static String getCheckExistenceSqlStr() {
        return QuerySQLByParentIDZoneName;
    }

    public void setupInsertStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this.getDBID());
        if (this._isIvr) {
            stat.setLong(2, this._fabric.getDBID());
        } else {
            stat.setLong(2, this._vsan.getDBID());
        }
        stat.setInt(3, this._zone.getIndex());
        stat.setString(4, this._zone.getName());
        stat.setBoolean(5, this._zone.isReadOnly());
        stat.setBoolean(6, this._isIvr);
        stat.setBoolean(7, this._zone.isQosSupported());
        stat.setInt(8, this._zone.getQosPriority());
        stat.setBoolean(9, this._zone.isBrodcastSupported());
        stat.setInt(10, this._zone.getCfsRegion());
        stat.setTimestamp(11, new Timestamp(System.currentTimeMillis()));
    }

    public void setupUpdateStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        if (this._isIvr) {
            stat.setLong(1, this._fabric.getDBID());
        } else {
            stat.setLong(1, this._vsan.getDBID());
        }
        stat.setInt(2, this._zone.getIndex());
        stat.setString(3, this._zone.getName());
        stat.setBoolean(4, this._zone.isReadOnly());
        stat.setBoolean(5, this._isIvr);
        stat.setBoolean(6, this._zone.isQosSupported());
        stat.setInt(7, this._zone.getQosPriority());
        stat.setBoolean(8, this._zone.isBrodcastSupported());
        stat.setInt(9, this._zone.getCfsRegion());
        stat.setTimestamp(10, new Timestamp(System.currentTimeMillis()));
        stat.setLong(11, this.getDBID());
    }

    public void setupCheckExistenceStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        if (this._isIvr) {
            stat.setLong(1, this._fabric.getDBID());
        } else {
            stat.setLong(1, this._vsan.getDBID());
        }
        stat.setString(2, this._zone.getName());
        stat.setBoolean(3, this._isIvr);
    }
}

