/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpFcAddressId;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.mds.zm.ZoneMember;
import com.cisco.dcbu.lib.mds.zm.ZoneMemberFormat;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import com.cisco.dcbu.sm.common.model.ZoneBase;
import com.cisco.dcbu.sm.common.model.ZoneMemberBase;
import com.cisco.dcbu.sm.common.type.SwitchIntKey;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.model.AbstractDBObjectImpl;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.FcPortImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.model.VsanImpl;
import com.cisco.dcbu.sm.server.model.ZoneImpl;
import com.cisco.dcbu.sm.server.web.util.DisplayUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;

public final class ZoneMemberImpl
extends AbstractDBObjectImpl {
    static final String QuerySQL = "select id, zone_id, type, member_id,lun_id,ivr_vsan_id,afid from zone_member";
    static final String QuerySQLByZoneID = "select id, zone_id, type, member_id,lun_id,ivr_vsan_id,afid, cfs_region_id from zone_member where zone_id=?";
    static final String QueryByZoneIDMemberID = "select id, zone_id, type, member_id,lun_id,ivr_vsan_id,afid from zone_member where zone_id=? and member_id=?";
    static final String QueryByZoneIDMemberIDLunID = "select id, zone_id, type, member_id,lun_id,ivr_vsan_id,afid from zone_member where zone_id=? and member_id=? and lun_id=?";
    static final String InsertSQL = "insert into zone_member(id, zone_id, type, member_id, lun_id, ivr_vsan_id, cfs_region_id, last_update_time,afid, endport_id, switchport_id, name, switch_int) values(?,?,?,?,?, ?,?,?,?,?, ?,?,?)";
    static final String UpdateSQL = "update zone_member set zone_id=?, type=?, member_id=?, lun_id=?, ivr_vsan_id=?, cfs_region_id, last_update_time=? ,afid=?, endport_id=?, switchport_id=?, name=?, switch_int=? where id=?";
    static final String TableName = "zone_member";
    final ZoneMemberBase _zoneMember;
    final ZoneImpl _zoneImpl;
    private EndPortImpl _ep;
    private FcPortImpl _sp;

    public void addLun(long lunNumber) {
        this._zoneMember.addLun(lunNumber);
    }

    public ZoneMemberImpl(ZoneImpl zoneImpl, ZoneMemberBase zoneMember) {
        this._zoneImpl = zoneImpl;
        this._zoneMember = zoneMember;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPreexistRecord(Connection con) throws SQLException {
        block9: {
            if (this._zoneImpl == null || this._zoneMember == null) {
                return;
            }
            PreparedStatement stat = null;
            ResultSet rs = null;
            byte[][] lunIDs = this._zoneMember.getLunId();
            try {
                if (lunIDs == null) {
                    stat = con.prepareStatement(QueryByZoneIDMemberID);
                    this.setupCheckExistenceByMemberIdStatement(stat);
                } else {
                    stat = con.prepareStatement(QueryByZoneIDMemberIDLunID);
                    this.setupCheckExistenceByLunIdStatement(stat);
                }
                rs = stat.executeQuery();
                if (rs.next()) {
                    this.setDBID(rs.getLong(1));
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                break block9;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        if (this._zoneImpl == null || this._zoneMember == null) {
            return null;
        }
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        Object vsan = null;
        if (this.getDBID() == 0L) {
            this.setDBID(Sequence.getSequence().getPK());
            PreparedStatement stat = con.prepareStatement(InsertSQL);
            this.setupInsertStatement(stat);
            return stat;
        }
        PreparedStatement stat = con.prepareStatement(UpdateSQL);
        this.setupUpdateStatement(stat);
        return stat;
    }

    @Override
    public String getDBTableName() {
        return TableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList loadFromDB(ZoneImpl zImpl) throws SQLException {
        ArrayList arrayList;
        Connection con = ConnectionManager.getConnection();
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            stat = con.prepareStatement(QuerySQLByZoneID);
            stat.setLong(1, zImpl.getDBID());
            rs = stat.executeQuery();
            ArrayList al = ZoneMemberImpl.loadDBRecord(rs);
            ZoneBase zone = zImpl.getBaseObject();
            for (int i = al.size() - 1; i >= 0; --i) {
                ZoneMemberBase zm = (ZoneMemberBase)al.get(i);
                zm.setParentZone(zone);
                zone.addMember(zm);
            }
            arrayList = al;
            DbUtil.close(rs);
        }
        catch (SQLException ex) {
            ArrayList arrayList2 = null;
            return arrayList2;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return arrayList;
    }

    public static ArrayList loadDBRecord(ResultSet rs) throws SQLException {
        ArrayList<ZoneMemberBase> al = new ArrayList<ZoneMemberBase>();
        ArrayList zal = new ArrayList();
        while (rs.next()) {
            ZoneMemberBase zm = new ZoneMemberBase(null, rs.getInt(3), rs.getBytes(4), (short)rs.getLong(6), rs.getInt(8));
            long[] lids = PersistentHelper.getHelper().getLongArray(rs, 5);
            if (lids != null) {
                zm.setLunIds(lids);
            }
            try {
                zm.setAfid(rs.getInt(7));
            }
            catch (SQLException e) {
                // empty catch block
            }
            al.add(zm);
        }
        return al;
    }

    public static String dump(ZoneMemberBase zmbr) {
        int numLuns;
        StringBuffer sb = new StringBuffer();
        if (zmbr.getType() == 5) {
            sb.append(zmbr.getTypeName()).append(" ").append(new String(zmbr.getId()));
        } else {
            sb.append(zmbr.getTypeName()).append(" ").append(SnmpString.toHexString(zmbr.getId()));
        }
        if (zmbr.getAfid() != 0) {
            sb.append(" AFID: ").append(zmbr.getAfid());
        }
        if ((numLuns = zmbr.getNumLunIds()) != 0) {
            long[] lunIds = zmbr.getLunIds();
            sb.append(", ").append(numLuns).append(" LUN(s): ");
            for (int i = 0; i < numLuns; ++i) {
                if (ZoneMemberBase.isLunNumber(lunIds[i])) {
                    sb.append("0xx").append(Long.toHexString(ZoneMemberBase.getLunNumber(lunIds[i])));
                } else {
                    sb.append(SnmpString.toHexString(ZoneMemberBase.getByteLunArray(lunIds[i])));
                }
                if (i == numLuns - 1) continue;
                sb.append(", ");
            }
        }
        return sb.toString();
    }

    public static String getInsertSqlStr() {
        return InsertSQL;
    }

    public static String getUpdateSqlStr() {
        return UpdateSQL;
    }

    public static String getCheckExistenceByLunIdSqlStr() {
        return QueryByZoneIDMemberIDLunID;
    }

    public static String getCheckExistenceByMemberIdSqlStr() {
        return QueryByZoneIDMemberID;
    }

    public void setupInsertStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this.getDBID());
        stat.setLong(2, this._zoneImpl.getDBID());
        stat.setInt(3, this._zoneMember.getType());
        stat.setBytes(4, this._zoneMember.getId());
        PersistentHelper.getHelper().setLongArray(stat, this._zoneMember.getLunIds(), 5);
        stat.setLong(6, this._zoneMember.getIvrVsanId());
        stat.setLong(7, this._zoneMember.getCfsRegion());
        stat.setTimestamp(8, new Timestamp(System.currentTimeMillis()));
        stat.setInt(9, this._zoneMember.getAfid());
        stat.setLong(10, this._ep == null ? -1L : this._ep.getDBID());
        stat.setLong(11, this._sp == null ? -1L : this._sp.getDBID());
        stat.setString(12, this.getName());
        stat.setString(13, this.getZoneMemberSwitchInterface());
    }

    public void setupUpdateStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this._zoneImpl.getDBID());
        stat.setInt(2, this._zoneMember.getType());
        stat.setBytes(3, this._zoneMember.getId());
        PersistentHelper.getHelper().setLongArray(stat, this._zoneMember.getLunIds(), 4);
        stat.setLong(5, this._zoneMember.getIvrVsanId());
        stat.setLong(6, this._zoneMember.getCfsRegion());
        stat.setTimestamp(7, new Timestamp(System.currentTimeMillis()));
        stat.setInt(8, this._zoneMember.getAfid());
        stat.setLong(9, this._ep == null ? -1L : this._ep.getDBID());
        stat.setLong(10, this._sp == null ? -1L : this._sp.getDBID());
        stat.setString(11, this.getName());
        stat.setString(12, this.getZoneMemberSwitchInterface());
        stat.setLong(13, this.getDBID());
    }

    public void setupCheckExistenceByLunIdStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this._zoneImpl.getDBID());
        stat.setBytes(2, this._zoneMember.getId());
        PersistentHelper.getHelper().setLongArray(stat, this._zoneMember.getLunIds(), 3);
    }

    public void setupCheckExistenceByMemberIdStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this._zoneImpl.getDBID());
        stat.setBytes(2, this._zoneMember.getId());
    }

    public String getZoneMemberSwitchInterface() {
        VsanImpl vsan = this._zoneImpl.getVsan();
        FabricImpl fabric = this._zoneImpl.getFabric();
        if (fabric == null) {
            fabric = vsan.getFabric();
        }
        if (fabric == null) {
            return null;
        }
        int vsanId = vsan == null ? -1 : (int)vsan.getId();
        int memberType = this._zoneMember.getType();
        byte[] id = this._zoneMember.getId();
        String memberName = DisplayUtil.getZoneMemberId(memberType, id);
        String name = "";
        switch (memberType) {
            case 1: 
            case 3: 
            case 10: 
            case 11: 
            case 12: {
                String tmpName;
                int switchIf = -1;
                SwitchImpl sw = null;
                int switchType = 0;
                String displayName = null;
                if (this._ep != null) {
                    switchIf = this._ep.getIfIndex();
                    sw = this._ep.getSwitch();
                    if (sw == null) break;
                    switchType = sw.getModelType();
                    String ifname = this._ep.getIfName();
                    FcPortBase fPort = sw.findPort(switchIf);
                    displayName = this.getDisplayName(fPort, ifname);
                }
                if (switchIf == -1) break;
                String ip = "";
                String sysName = null;
                if (sw != null) {
                    if (sw.getBase() != null && sw.getBase().getInetAddress() != null) {
                        ip = sw.getBase().getInetAddress().getHostAddress();
                    }
                    sysName = sw.getName();
                }
                String string = tmpName = sysName != null ? sysName : ip;
                if (displayName != null) {
                    name = tmpName + " " + displayName;
                    break;
                }
                name = tmpName + " " + DisplayUtil.ifIndexToName(switchIf, switchType);
                break;
            }
            case 4: 
            case 6: {
                if (this._sp == null) break;
                String displayName = null;
                SwitchImpl sw = this._sp.getSwitch();
                String ip = "";
                String sysName = null;
                if (sw != null) {
                    if (sw.getBase() != null && sw.getBase().getInetAddress() != null) {
                        ip = sw.getBase().getInetAddress().getHostAddress();
                    }
                    sysName = sw.getName();
                }
                String tmpName = sysName != null ? sysName : ip;
                int index = this._sp.getIfIndex();
                displayName = this.getDisplayName((FcPortBase)this._sp.getBaseObject(), this._sp.getIfname());
                if (displayName != null) {
                    name = tmpName + " " + displayName;
                    break;
                }
                name = tmpName + " " + IfIndexUtil.ifIndexToName(index);
                break;
            }
            case 2: {
                name = memberName;
                break;
            }
            case 7: {
                if (this._sp == null) break;
                SwitchImpl sw = this._sp.getSwitch();
                String ip = null;
                if (sw != null && sw.getBase() != null && sw.getBase().getInetAddress() != null) {
                    ip = sw.getBase().getInetAddress().getHostAddress();
                }
                int tmp = id[1] << 24 & 0xFF000000 | id[2] << 16 & 0xFF0000 | id[3] << 8 & 0xFF00 | id[4] & 0xFF;
                String fcid = IfIndexUtil.ifIndexToName(tmp);
                if (ip != null) {
                    name = ip + " " + fcid;
                    break;
                }
                name = memberName;
                break;
            }
        }
        return name;
    }

    public String getName() {
        VsanImpl vsan = this._zoneImpl.getVsan();
        int vsanId = vsan == null ? -1 : (int)vsan.getId();
        int memberType = this._zoneMember.getType();
        byte[] memberId = this._zoneMember.getId();
        String name = ZoneMember.getZoneMemberName(vsanId, memberType, memberId, null).toString();
        FabricImpl fabric = this._zoneImpl.getFabric();
        if (fabric == null) {
            fabric = vsan.getFabric();
        }
        if (fabric == null) {
            return null;
        }
        switch (memberType) {
            case 10: {
                if (this._ep == null) break;
                name = this._ep.getAlias();
                break;
            }
            case 1: 
            case 11: {
                if (this._ep != null) {
                    name = this._ep.getPortWwn().toString();
                    if (this._ep.getAlias() == null || this._ep.getAlias().trim().length() <= 0) break;
                    name = this._ep.getAlias();
                    break;
                }
                if (name != null && name.trim().length() != 0) break;
                name = SnmpString.toHexString(memberId);
                break;
            }
            case 3: 
            case 12: {
                name = "";
                if (this._ep == null) break;
                name = this._ep.getAlias();
                break;
            }
            case 2: 
            case 7: {
                String ifName;
                SwitchImpl sw = this._sp == null ? null : this._sp.getSwitch();
                int ifIndex = memberType == 7 ? ZoneMemberFormat.getIfFormatIfIndex(memberId, 1) : 0xFF & memberId[1];
                String string = ifName = memberType == 7 ? IfIndexUtil.ifIndexToName(ifIndex) : Integer.toString(ifIndex);
                if (null != sw) {
                    name = sw + " port:" + (memberType == 7 ? sw.ifIndexToName(ifIndex) : Integer.toString(ifIndex));
                    break;
                }
                name = "0x" + Integer.toHexString(0xFF & memberId[0]) + " port:" + ifName;
                break;
            }
            case 4: {
                SwitchImpl sw;
                SwitchImpl switchImpl = sw = this._sp == null ? null : this._sp.getSwitch();
                if (sw != null) {
                    name = sw + " " + sw.getBase().ifWwn2IfIndex(memberId, IfIndexIf.FwwnInfo.Config);
                    break;
                }
                name = SnmpString.toHexString(memberId);
                break;
            }
            case 5: {
                name = new String(memberId);
                break;
            }
            case 6: {
                byte[] swWwn = ZoneMemberFormat.getIfFormatSwitchWwn(memberId);
                int ifIndex = ZoneMemberFormat.getIfFormatIfIndex(memberId, 0);
                if (this._sp != null) {
                    SwitchImpl sw = this._sp.getSwitch();
                    if (sw != null) {
                        name = sw + " " + sw.ifIndexToName(ifIndex);
                        break;
                    }
                    name = WwnDictionary.get(swWwn) + " " + IfIndexUtil.ifIndexToName(ifIndex);
                    break;
                }
                name = memberId + " " + IfIndexUtil.ifIndexToName(ifIndex);
                break;
            }
            case 8: {
                byte[] add = new byte[4];
                byte[] mask = new byte[4];
                System.arraycopy(memberId, 0, add, 0, 4);
                if (memberId.length > 4) {
                    System.arraycopy(memberId, 4, mask, 0, 4);
                    name = SnmpIpAddress.toString(add) + "/" + SnmpIpAddress.toString(mask);
                    break;
                }
                name = SnmpIpAddress.toString(add);
                break;
            }
        }
        if (name == null || name.equals("null")) {
            name = "";
        }
        return name;
    }

    public EndPortImpl getEndPort() {
        return this._ep;
    }

    public void setEndPort(EndPortImpl ep) {
        this._ep = ep;
    }

    public void setEndPort() {
        VsanImpl vsan = this._zoneImpl.getVsan();
        int vsanId = vsan == null ? -1 : (int)vsan.getId();
        int memberType = this._zoneMember.getType();
        byte[] memberId = this._zoneMember.getId();
        FabricImpl fabric = this._zoneImpl.getFabric();
        if (fabric == null) {
            fabric = vsan.getFabric();
        }
        if (fabric == null) {
            return;
        }
        block0 : switch (memberType) {
            case 10: {
                this._ep = SanManager.getInstance().findEndPort(new String(memberId), fabric.getPK());
                break;
            }
            case 1: 
            case 11: {
                this._ep = SanManager.getInstance().findEndPort(new Wwn(memberId), fabric.getPK());
                break;
            }
            case 3: 
            case 12: {
                EndPortImpl[] epList = SanManager.getInstance().findEndPorts(fabric.getPK());
                for (int i = 0; epList != null && i < epList.length; ++i) {
                    EndPortImpl endP = epList[i];
                    int fcId = endP.getFcId(vsanId);
                    if (!DisplayUtil.getFormattedFcId(fcId).equals(SnmpFcAddressId.toHexString(memberId))) continue;
                    this._ep = endP;
                    break block0;
                }
                break;
            }
        }
    }

    public FcPortImpl getFcPort() {
        return this._sp;
    }

    public void setFcPort(FcPortImpl sp) {
        this._sp = sp;
    }

    public void setFcPort() {
        FabricImpl fabric = this._zoneImpl.getFabric();
        VsanImpl vsan = this._zoneImpl.getVsan();
        if (fabric == null) {
            fabric = vsan.getFabric();
        }
        if (fabric == null) {
            return;
        }
        int vsanId = vsan == null ? -1 : (int)vsan.getId();
        int memberType = this._zoneMember.getType();
        byte[] id = this._zoneMember.getId();
        if (memberType == 10 || memberType == 1 || memberType == 11 || memberType == 3 || memberType == 12) {
            SwitchIntKey fcPortKey;
            if (this._ep != null && (fcPortKey = this._ep.getFPortPK()) != null) {
                this._sp = fabric.findSwitchPortByKey(fcPortKey);
            }
        } else if (memberType == 2 || memberType == 7) {
            SwitchImpl sw = vsan == null ? null : vsan.findSwitchByDomainId(0xFF & id[0]);
            int ifIndex = memberType == 7 ? ZoneMemberFormat.getIfFormatIfIndex(id, 1) : 0xFF & id[1];
            this._sp = sw == null ? null : fabric.findSwitchPortByKey(new SwitchIntKey(sw.getSwitchPK(), ifIndex));
        } else {
            Object[] swPort = ZoneMemberFormat.getSwitchPort(memberType, id);
            if (swPort == null || swPort[0] == null || swPort[1] == null) {
                return;
            }
            byte[] swWwn = (byte[])swPort[1];
            if (swWwn.length != 8) {
                return;
            }
            Wwn fwwn = new Wwn(swWwn);
            SwitchImpl sw = SanManager.getInstance().findSwitch(new WwnKey(fwwn), fabric.getPK());
            if (sw == null) {
                return;
            }
            int ifIndexS = memberType == 4 ? sw.getBase().ifWwn2IfIndex(id, IfIndexIf.FwwnInfo.Config) : ((int[])swPort[0])[0];
            this._sp = fabric.findSwitchPortByKey(new SwitchIntKey(sw.getSwitchPK(), ifIndexS));
        }
    }

    private String getDisplayName(FcPortBase fPort, String ifname) {
        if (fPort == null || ifname == null) {
            return null;
        }
        if (fPort.isVfcBound() && fPort.getVFCBindTo() != null) {
            return fPort.getIfname() + "(" + fPort.getVFCBindTo() + ")";
        }
        if (ifname.startsWith(IfIndexUtil.IfType.FMFI.getName())) {
            return "unknown";
        }
        return ifname;
    }
}

