/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.npv;

import com.cisco.dcbu.lib.mds.FeatureEnabler;
import com.cisco.dcbu.lib.mds.zm.StatusIf;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.common.dto.QueueResponseObject;
import com.cisco.dcbu.sm.common.event.CommunicationObjectSender;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.server.npv.CopyRSRunnable;
import java.util.ArrayList;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class NpvSetFeatureRunnable
extends CopyRSRunnable
implements StatusIf {
    static final int[] _cfcFeatureCtrlLastActionOid = MibNode.get("cfcFeatureCtrlLastAction").getOid();
    static final int[] _cfcFeatureCtrlLastActionResultOid = MibNode.get("cfcFeatureCtrlLastActionResult").getOid();
    static final int[] _cfcFeatureCtrlLastFailureReasonOid = MibNode.get("cfcFeatureCtrlLastFailureReason").getOid();
    static final int[] _cfcFeatureCtrlOpStatusOid = MibNode.get("cfcFeatureCtrlOpStatus").getOid();
    static final int[] _cfcFeatureCtrlNameOid = MibNode.get("cfcFeatureCtrlName").getOid();
    private int FEATURE_NPIV = 16;
    private int FEATURE_NPV = 37;
    private int _jobType;
    static Logger _logger = LogManager.getLogger((String)"fms.npv");

    private NpvSetFeatureRunnable(long requestId, SwitchBase sw, SnmpUserOpt snmpUserOpt, CommunicationObjectSender sender) {
        super(requestId, sw, snmpUserOpt, sender);
        throw new IllegalArgumentException("jobType must be defined");
    }

    public NpvSetFeatureRunnable(int jobType, long requestId, SwitchBase sw, SnmpUserOpt snmpUserOpt, CommunicationObjectSender sender) {
        super(requestId, sw, snmpUserOpt, sender);
        this._jobType = jobType;
    }

    @Override
    public void run() {
        try {
            switch (this._jobType) {
                case 2: {
                    SnmpPeer peer = this.generatePeer(this._sw, this._snmpUserOpt);
                    this.enableFeature(peer, this.FEATURE_NPIV);
                    break;
                }
                case 1: {
                    SnmpPeer peer = this.generatePeer(this._sw, this._snmpUserOpt);
                    QueueResponseObject result = this.copyRS();
                    if (result.getResultValue() != 1) {
                        this._sender.send(result);
                        break;
                    }
                    this.enableFeature(peer, this.FEATURE_NPV);
                }
            }
        }
        catch (Exception se) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("error " + se));
            }
            QueueResponseObject result = new QueueResponseObject(this._requestId, this._sw, 4, null, se);
            this._sender.send(result);
        }
    }

    private void enableFeature(SnmpPeer swPeer, int featureId) throws SnmpException {
        ArrayList<Object[]> enableFeatureList = new ArrayList<Object[]>();
        enableFeatureList.add(new Object[]{swPeer, new int[]{featureId}});
        FeatureEnabler featureEnabler = new FeatureEnabler(enableFeatureList, true, this);
        featureEnabler.startAction();
    }

    protected SnmpPDU getSnmpFeatureCtrlEntry(SnmpPeer peer, int featureIndex) throws SnmpException {
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList(5));
        pdu.addNull(new SnmpOID(_cfcFeatureCtrlNameOid, featureIndex));
        pdu.addNull(new SnmpOID(_cfcFeatureCtrlLastActionResultOid, featureIndex));
        pdu.addNull(new SnmpOID(_cfcFeatureCtrlLastFailureReasonOid, featureIndex));
        pdu.addNull(new SnmpOID(_cfcFeatureCtrlOpStatusOid, featureIndex));
        pdu.addNull(new SnmpOID(_cfcFeatureCtrlLastActionOid, featureIndex));
        SnmpPDU respPdu = peer.send(pdu);
        VarBindList vbl = respPdu.getVariables();
        byte[] firstVarLength = vbl.byteValue(0);
        if (firstVarLength.length == 0) {
            return null;
        }
        return respPdu;
    }

    @Override
    public void setStatus(String status) {
        try {
            if (this._sender != null) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("recieved status - " + status + " for request id  - " + this._requestId));
                }
                if (status.contains("enable features on")) {
                    QueueResponseObject result = new QueueResponseObject(this._requestId, this._sw, 3, "In Progress", null);
                    this._sender.send(result);
                } else if (status.contains("Finished") || status.contains("finished")) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("supressing finish status from going to client : " + status));
                    }
                } else if (status.contains("Success") || status.contains("success")) {
                    QueueResponseObject result = new QueueResponseObject(this._requestId, this._sw, 1, "Successful", null);
                    this._sender.send(result);
                } else if (!status.contains("Fail") && !status.contains("fail")) {
                    if (status.contains("Progress") || status.contains("progress")) {
                        QueueResponseObject result = new QueueResponseObject(this._requestId, this._sw, 3, "In Progress", null);
                        this._sender.send(result);
                    } else {
                        QueueResponseObject result = new QueueResponseObject(this._requestId, this._sw, 5, status, null);
                        this._sender.send(result);
                    }
                }
            }
        }
        catch (Exception jmse) {
            _logger.error((Object)"unable to send message to client, received error:", (Throwable)jmse);
        }
    }

    @Override
    public void handleError(Exception[] ex) {
        try {
            if (this._sender != null && ex != null && ex.length > 0) {
                if (ex.length > 1) {
                    _logger.info((Object)("received more then one error for set feature - " + ex));
                }
                _logger.error((Object)("recieved error - " + ex[0] + " for request id  - " + this._requestId + " switch - " + this._sw));
                QueueResponseObject result = new QueueResponseObject(this._requestId, this._sw, 4, null, ex[0]);
                this._sender.send(result);
            }
        }
        catch (Exception jmse) {
            _logger.error((Object)"unable to send message to client, received error:", (Throwable)jmse);
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public void actionFinished() {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("recieved actionfinished - for request id  - " + this._requestId + " switch - " + this._sw));
        }
    }
}

