/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.pm;

import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.pm.PM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PortGroupSummary {
    static final int STATS_TOTAL_SIZE = 28;
    static final int STATS_SIZE = 7;
    static final String[] GraLevels = new String[]{"Daily", "Weekly", "Monthly", "Yearly"};
    static final String QueryPGIslStatisticsDaily = "select sp.switch_id * 10000 + sp.port_group, sum(stat.avg_rx), sum(stat.avg_tx), sum(stat.total_rxtx), sum(stat.max_rx), sum(stat.max_tx), sum(stat.total_err), sum(stat.total_discard) from statistics stat, switch_port sp where stat.avg_rx != 'NaN' and stat.avg_tx != 'NaN' and stat.total_rxtx != 'NaN' and stat.max_rx != 'NaN' and stat.max_tx != 'NaN' and  stat.avg_rx >= 0 and stat.avg_tx >=0 and stat.total_rxtx >=0 and stat.max_rx >=0 and stat.max_tx >=0 and stat.total_err >=0 and stat.total_discard >=0 and  (stat.src_id = sp.id or stat.dest_id = sp.id ) group by sp.switch_id * 10000 + sp.port_group";
    static final String QueryPGIslStatisticsWeekly = "select sp.switch_id * 10000 + sp.port_group, sum(stat.last_week_avg_rx), sum(stat.last_week_avg_tx), sum(stat.last_week_total_rxtx), sum(stat.last_week_max_rx), sum(stat.last_week_max_tx), sum(stat.last_week_total_err), sum(stat.last_week_total_discard) from statistics stat, switch_port sp  where stat.last_week_avg_rx != 'NaN' and stat.last_week_avg_tx != 'NaN' and stat.last_week_total_rxtx != 'NaN' and stat.last_week_max_rx != 'NaN' and stat.last_week_max_tx != 'NaN' and  stat.last_week_avg_rx >= 0 and stat.last_week_avg_tx >= 0 and stat.last_week_total_rxtx >= 0 and stat.last_week_max_rx >= 0 and stat.last_week_max_tx >= 0 and stat.last_week_total_err >= 0 and stat.last_week_total_discard >= 0 and  (stat.src_id = sp.id or stat.dest_id = sp.id ) group by sp.switch_id * 10000 + sp.port_group";
    static final String QueryPGIslStatisticsMonthly = "select sp.switch_id * 10000 + sp.port_group, sum(stat.last_month_avg_rx), sum(stat.last_month_avg_tx), sum(stat.last_month_total_rxtx), sum(stat.last_month_max_rx), sum(stat.last_month_max_tx), sum(stat.last_month_total_err), sum(stat.last_month_total_discard) from statistics stat, switch_port sp where stat.last_month_avg_rx != 'NaN' and stat.last_month_avg_tx != 'NaN' and stat.last_month_total_rxtx != 'NaN' and stat.last_month_max_rx != 'NaN' and stat.last_month_max_tx != 'NaN' and stat.last_month_avg_rx >= 0 and stat.last_month_avg_tx >= 0 and stat.last_month_total_rxtx >= 0 and stat.last_month_max_rx >= 0 and stat.last_month_max_tx >= 0 and stat.last_month_total_err >= 0 and stat.last_month_total_discard >= 0 and  (stat.src_id = sp.id or stat.dest_id = sp.id ) group by sp.switch_id * 10000 + sp.port_group";
    static final String QueryPGIslStatisticsYearly = "select sp.switch_id * 10000 + sp.port_group, sum(stat.last_year_avg_rx), sum(stat.last_year_avg_tx), sum(stat.last_year_total_rxtx), sum(stat.last_year_max_rx), sum(stat.last_year_max_tx), sum(stat.last_year_total_err), sum(stat.last_year_total_discard) from statistics stat, switch_port sp where stat.last_year_avg_rx != 'NaN' and stat.last_year_avg_tx != 'NaN' and stat.last_year_total_rxtx != 'NaN' and stat.last_year_max_rx != 'NaN' and stat.last_year_max_tx != 'NaN' and stat.last_year_avg_rx >= 0 and stat.last_year_avg_tx >= 0 and stat.last_year_total_rxtx >= 0 and stat.last_year_max_rx >= 0 and stat.last_year_max_tx >= 0 and stat.last_year_total_err >= 0 and stat.last_year_total_discard >= 0 and  (stat.src_id = sp.id or stat.dest_id = sp.id ) group by sp.switch_id * 10000 + sp.port_group";
    static final String QueryPGEndPortStatisticsDaily = "select sp.switch_id * 10000 + sp.port_group, sum(stat.avg_rx), sum(stat.avg_tx), sum(stat.total_rxtx), sum(stat.max_rx), sum(stat.max_tx), sum(stat.total_err), sum(stat.total_discard) from statistics stat, switch_port sp, end_port ep where stat.avg_rx != 'NaN' and stat.avg_tx != 'NaN' and stat.total_rxtx != 'NaN' and stat.max_rx != 'NaN' and stat.max_tx != 'NaN' and stat.avg_rx >= 0 and stat.avg_tx >=0 and stat.total_rxtx >=0 and stat.max_rx >=0 and stat.max_tx >=0 and stat.total_err >=0 and stat.total_discard >=0 and stat.src_id = ep.id and ep.switch_port_id = sp.id group by sp.switch_id * 10000 + sp.port_group";
    static final String QueryPGEndPortStatisticsWeekly = "select sp.switch_id * 10000 + sp.port_group, sum(stat.last_week_avg_rx), sum(stat.last_week_avg_tx), sum(stat.last_week_total_rxtx), sum(stat.last_week_max_rx), sum(stat.last_week_max_tx), sum(stat.last_week_total_err), sum(stat.last_week_total_discard) from statistics stat, switch_port sp, end_port ep where stat.last_week_avg_rx != 'NaN' and stat.last_week_avg_tx != 'NaN' and stat.last_week_total_rxtx != 'NaN' and stat.last_week_max_rx != 'NaN' and stat.last_week_max_tx != 'NaN' and  stat.last_week_avg_rx >= 0 and stat.last_week_avg_tx >= 0 and stat.last_week_total_rxtx >= 0 and stat.last_week_max_rx >= 0 and stat.last_week_max_tx >= 0 and stat.last_week_total_err >= 0 and stat.last_week_total_discard >= 0 and stat.src_id = ep.id and ep.switch_port_id = sp.id group by sp.switch_id * 10000 + sp.port_group";
    static final String QueryPGEndPortStatisticsMonthly = "select sp.switch_id * 10000 + sp.port_group, sum(stat.last_month_avg_rx), sum(stat.last_month_avg_tx), sum(stat.last_month_total_rxtx), sum(stat.last_month_max_rx), sum(stat.last_month_max_tx), sum(stat.last_month_total_err), sum(stat.last_month_total_discard) from statistics stat, switch_port sp, end_port ep where stat.last_month_avg_rx != 'NaN' and stat.last_month_avg_tx != 'NaN' and stat.last_month_total_rxtx != 'NaN' and stat.last_month_max_rx != 'NaN' and stat.last_month_max_tx != 'NaN' and stat.last_month_avg_rx >= 0 and stat.last_month_avg_tx >= 0 and stat.last_month_total_rxtx >= 0 and stat.last_month_max_rx >= 0 and stat.last_month_max_tx >= 0 and stat.last_month_total_err >= 0 and stat.last_month_total_discard >= 0 and stat.src_id = ep.id and ep.switch_port_id = sp.id group by sp.switch_id * 10000 + sp.port_group";
    static final String QueryPGEndPortStatisticsYearly = "select sp.switch_id * 10000 + sp.port_group, sum(stat.last_year_avg_rx), sum(stat.last_year_avg_tx), sum(stat.last_year_total_rxtx), sum(stat.last_year_max_rx), sum(stat.last_year_max_tx), sum(stat.last_year_total_err), sum(stat.last_year_total_discard) from statistics stat, switch_port sp, end_port ep where stat.last_year_avg_rx != 'NaN' and stat.last_year_avg_tx != 'NaN' and stat.last_year_total_rxtx != 'NaN' and stat.last_year_max_rx != 'NaN' and stat.last_year_max_tx != 'NaN' and stat.last_year_avg_rx >= 0 and stat.last_year_avg_tx >= 0 and stat.last_year_total_rxtx >= 0 and stat.last_year_max_rx >= 0 and stat.last_year_max_tx >= 0 and stat.last_year_total_err >= 0 and stat.last_year_total_discard >= 0 and stat.src_id = ep.id and ep.switch_port_id = sp.id group by sp.switch_id * 10000 + sp.port_group";
    static final String QueryEndPortStatisticsDaily = "select enc.id, sum(stat.avg_rx), sum(stat.avg_tx), sum(stat.total_rxtx), sum(stat.max_rx), sum(stat.max_tx), sum(stat.total_err), sum(stat.total_discard) from statistics stat, enclosure enc, end_port ep where stat.avg_rx != 'NaN' and stat.avg_tx != 'NaN' and stat.total_rxtx != 'NaN' and stat.max_rx != 'NaN' and stat.max_tx != 'NaN' and stat.avg_rx >= 0 and stat.avg_tx >=0 and stat.total_rxtx >=0 and stat.max_rx >=0 and stat.max_tx >=0 and stat.total_err >=0 and stat.total_discard >=0 and stat.src_id = ep.id and ep.ENCLOSURE_ID = enc.ID  and stat.type= ? group by enc.id";
    static final String QueryEndPortStatisticsWeekly = "select enc.id, sum(stat.last_week_avg_rx), sum(stat.last_week_avg_tx), sum(stat.last_week_total_rxtx), sum(stat.last_week_max_rx), sum(stat.last_week_max_tx), sum(stat.last_week_total_err), sum(stat.last_week_total_discard) from statistics stat, enclosure enc, end_port ep where stat.last_week_avg_rx != 'NaN' and stat.last_week_avg_tx != 'NaN' and stat.last_week_total_rxtx != 'NaN' and stat.last_week_max_rx != 'NaN' and stat.last_week_max_tx != 'NaN' and  stat.last_week_avg_rx >= 0 and stat.last_week_avg_tx >= 0 and stat.last_week_total_rxtx >= 0 and stat.last_week_max_rx >= 0 and stat.last_week_max_tx >= 0 and stat.last_week_total_err >= 0 and stat.last_week_total_discard >= 0 and stat.src_id = ep.id and ep.ENCLOSURE_ID = enc.ID  and stat.type= ? group by enc.id";
    static final String QueryEndPortStatisticsMonthly = "select enc.id, sum(stat.last_month_avg_rx), sum(stat.last_month_avg_tx), sum(stat.last_month_total_rxtx), sum(stat.last_month_max_rx), sum(stat.last_month_max_tx), sum(stat.last_month_total_err), sum(stat.last_month_total_discard) from statistics stat, enclosure enc, end_port ep where stat.last_month_avg_rx != 'NaN' and stat.last_month_avg_tx != 'NaN' and stat.last_month_total_rxtx != 'NaN' and stat.last_month_max_rx != 'NaN' and stat.last_month_max_tx != 'NaN' and stat.last_month_avg_rx >= 0 and stat.last_month_avg_tx >= 0 and stat.last_month_total_rxtx >= 0 and stat.last_month_max_rx >= 0 and stat.last_month_max_tx >= 0 and stat.last_month_total_err >= 0 and stat.last_month_total_discard >= 0 and stat.src_id = ep.id and ep.ENCLOSURE_ID = enc.ID and stat.type= ?  group by enc.id";
    static final String QueryEndPortStatisticsYearly = "select enc.id, sum(stat.last_year_avg_rx), sum(stat.last_year_avg_tx), sum(stat.last_year_total_rxtx), sum(stat.last_year_max_rx), sum(stat.last_year_max_tx), sum(stat.last_year_total_err), sum(stat.last_year_total_discard) from statistics stat, enclosure enc, end_port ep where stat.last_year_avg_rx != 'NaN' and stat.last_year_avg_tx != 'NaN' and stat.last_year_total_rxtx != 'NaN' and stat.last_year_max_rx != 'NaN' and stat.last_year_max_tx != 'NaN' and stat.last_year_avg_rx >= 0 and stat.last_year_avg_tx >= 0 and stat.last_year_total_rxtx >= 0 and stat.last_year_max_rx >= 0 and stat.last_year_max_tx >= 0 and stat.last_year_total_err >= 0 and stat.last_year_total_discard >= 0 and stat.src_id = ep.id and ep.ENCLOSURE_ID = enc.ID and stat.type= ?  group by enc.id";
    static final String InsertPorGroupSummarySQL = "insert into statistics (src_id, dest_id, type, avg_rx, avg_tx, total_rxtx, max_rx, max_tx, total_err, total_discard, last_week_avg_rx, last_week_avg_tx, last_week_total_rxtx, last_week_max_rx, last_week_max_tx, last_week_total_err, last_week_total_discard, last_month_avg_rx, last_month_avg_tx, last_month_total_rxtx, last_month_max_rx, last_month_max_tx, last_month_total_err, last_month_total_discard, last_year_avg_rx, last_year_avg_tx, last_year_total_rxtx, last_year_max_rx, last_year_max_tx, last_year_total_err, last_year_total_discard, last_update_time)values (?,?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    static final String UpdatePorGroupSummarySQL = "update statistics set src_id =?, dest_id =?, type=?, avg_rx =?, avg_tx =?, total_rxtx =?, max_rx =?, max_tx =?, total_err =?, total_discard =?, last_week_avg_rx =?, last_week_avg_tx =?, last_week_total_rxtx =?, last_week_max_rx =?, last_week_max_tx =?, last_week_total_err =?, last_week_total_discard =?, last_month_avg_rx =?, last_month_avg_tx =?, last_month_total_rxtx =?, last_month_max_rx =?, last_month_max_tx =?, last_month_total_err =?, last_month_total_discard =?, last_year_avg_rx =?, last_year_avg_tx =?, last_year_total_rxtx =?, last_year_max_rx =?, last_year_max_tx =?, last_year_total_err =?, last_year_total_discard =?, last_update_time =? where src_id=? and dest_id=?";
    private static PortGroupSummary _Instance = null;

    public void aggregate2DB() throws Exception {
        PM._Logger.debug((Object)(new Date().toString() + ": Switch Total Bandwidth data aggregate to db"));
        this.processEnclosureData();
    }

    private PortGroupSummary() {
    }

    public static PortGroupSummary getInstance() {
        if (_Instance == null) {
            _Instance = new PortGroupSummary();
        }
        return _Instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEnclosureData() {
        HashMap<Long, double[]> map = new HashMap<Long, double[]>();
        Connection conn = null;
        try {
            conn = ConnectionManager.getConnection();
            this.processSQL(map, "QueryPGEndPortStatistics", conn, 14);
            this.processSQL(map, "QueryPGIslStatistics", conn, 14);
            this.updateStats(map, InsertPorGroupSummarySQL, UpdatePorGroupSummarySQL, conn, 14);
            map.clear();
            this.processSQL(map, "QueryEndPortStatistics", conn, 3);
            this.updateStats(map, InsertPorGroupSummarySQL, UpdatePorGroupSummarySQL, conn, 12);
            map.clear();
            this.processSQL(map, "QueryEndPortStatistics", conn, 4);
            this.updateStats(map, InsertPorGroupSummarySQL, UpdatePorGroupSummarySQL, conn, 13);
        }
        catch (Exception ex) {
            PM._Logger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            DbUtil.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStats(HashMap<Long, double[]> map, String insertSQL, String updateSQL, Connection conn, int type) {
        block10: {
            PreparedStatement pstmt_s = null;
            ResultSet rs = null;
            long encId = -1L;
            double[] values = null;
            try {
                Iterator<Map.Entry<Long, double[]>> itr = map.entrySet().iterator();
                Map.Entry<Long, double[]> entry = null;
                int count = 0;
                while (itr.hasNext()) {
                    entry = itr.next();
                    pstmt_s = conn.prepareStatement(updateSQL);
                    long srcId = encId = entry.getKey().longValue();
                    long destId = encId;
                    if (type == 14) {
                        srcId = encId / 10000L;
                        destId = encId % 10000L;
                    }
                    pstmt_s.setLong(1, srcId);
                    pstmt_s.setLong(2, destId);
                    pstmt_s.setInt(3, type);
                    for (int i = 4; i <= 31; ++i) {
                        values = entry.getValue();
                        pstmt_s.setDouble(i, values[i - 4]);
                    }
                    pstmt_s.setTimestamp(32, new Timestamp(System.currentTimeMillis()));
                    pstmt_s.setLong(33, srcId);
                    pstmt_s.setLong(34, destId);
                    int rc = pstmt_s.executeUpdate();
                    if (rc < 1) {
                        pstmt_s.close();
                        pstmt_s = conn.prepareStatement(insertSQL);
                        pstmt_s.setLong(1, srcId);
                        pstmt_s.setLong(2, destId);
                        pstmt_s.setInt(3, type);
                        for (int i = 4; i <= 31; ++i) {
                            values = entry.getValue();
                            pstmt_s.setDouble(i, values[i - 4]);
                        }
                        pstmt_s.setTimestamp(32, new Timestamp(System.currentTimeMillis()));
                        rc = pstmt_s.executeUpdate();
                    }
                    pstmt_s.close();
                    ++count;
                }
                PM._Logger.info((Object)("Processed Enclosure stats: " + type + " : " + count));
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                PM._Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                break block10;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(pstmt_s);
            }
            DbUtil.close(pstmt_s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSQL(HashMap<Long, double[]> map, String sql, Connection conn, int type) {
        PreparedStatement pstmt_s = null;
        ResultSet rs = null;
        long encId = -1L;
        double[] values = null;
        try {
            for (int j = 0; j < GraLevels.length; ++j) {
                String querysql = PortGroupSummary.class.getDeclaredField(sql + GraLevels[j]).get(PortGroupSummary.class).toString();
                pstmt_s = conn.prepareStatement(querysql);
                if (type != 14) {
                    pstmt_s.setInt(1, type);
                }
                rs = pstmt_s.executeQuery();
                while (rs.next()) {
                    encId = rs.getLong(1);
                    if (!map.containsKey(encId)) {
                        map.put(encId, new double[28]);
                    }
                    values = map.get(encId);
                    for (int i = 2; i <= 8; ++i) {
                        int n = i - 2 + j * 7;
                        values[n] = values[n] + (rs.getObject(i) == null || ((Double)rs.getObject(i)).isNaN() ? 0.0 : (Double)rs.getObject(i));
                    }
                }
                rs.close();
                rs = null;
                pstmt_s.close();
                pstmt_s = null;
            }
        }
        catch (Exception ex) {
            PM._Logger.warn((Object)("PortGroupSummary set port data error: " + ex.getMessage()), (Throwable)ex);
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(pstmt_s);
        }
    }

    public static void main(String[] args) {
        try {
            GenUtil.loadServerProperties(null);
            PortGroupSummary.getInstance().aggregate2DB();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

