/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.ps;

import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.mds.CfsActionCommitter;
import com.cisco.dcbu.lib.mds.zm.ActionEnabler;
import com.cisco.dcbu.lib.mds.zm.StatusIf;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpAggregrate;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.IntArray;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.rif.PortSecurityRif;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class PSBase
implements StatusIf {
    public static Logger _Logger = LogManager.getLogger((String)"FM.PSMWizard");
    private static int MERGE_SLEEP_TIME = 5000;
    private static int MERGE_CHECK_TRIES = 4;
    private static HashMap userIp2Peer = new HashMap();
    protected boolean stopAction;
    protected boolean lastActionSuccess;
    protected ActionEnabler acEnabler;
    protected String status;
    protected Exception[] errorException;

    public PSBase() {
        String exTime = System.getProperty("MERGE_SLEEP_TIME", "5000");
        try {
            MERGE_SLEEP_TIME = Integer.parseInt(exTime);
        }
        catch (Exception ex) {
            // empty catch block
        }
        String numTries = System.getProperty("MERGE_CHECK_TRIES", "4");
        try {
            MERGE_CHECK_TRIES = Integer.parseInt(numTries);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.status = "";
    }

    public static SnmpPeer generatePeer(SwitchBase sw, SnmpUserOpt snmpUserOpt) throws SnmpException {
        SnmpPeer peer = null;
        if (sw != null) {
            String key = (snmpUserOpt.isV3() ? snmpUserOpt.getUsername() : snmpUserOpt.getCommunity()) + sw.getIpAddress();
            peer = (SnmpPeer)userIp2Peer.get(key);
            if (peer != null) {
                return peer;
            }
            if (snmpUserOpt.isV3()) {
                peer = new SnmpPeer(sw.getInetAddress(), SnmpSession.getInstance(), snmpUserOpt.getUsername(), snmpUserOpt.getPassword(), snmpUserOpt.getAuthProtocol(), snmpUserOpt.getPrivPassword(), snmpUserOpt.getPrivProtocol());
                peer.setLogger(_Logger);
            } else {
                peer = new SnmpPeer(sw.getInetAddress(), snmpUserOpt.getCommunity(), snmpUserOpt.getCommunity(), SnmpSession.getInstance());
                peer.setLogger(_Logger);
            }
            userIp2Peer.put(key, peer);
        }
        return peer;
    }

    public static SnmpPeer generatePeer(String sw, SnmpUserOpt snmpUserOpt) throws SnmpException {
        try {
            InetAddress iAdd = InetAddress.getByName(sw);
            SwitchImpl swImpl = SanManager.getInstance().findSwitchByIP(iAdd);
            if (swImpl == null) {
                throw new SnmpException("Unreachable Switch:" + sw);
            }
            SwitchBase swB = (SwitchBase)SanManager.getInstance().findSwitchByIP(iAdd).getBaseObject();
            if (swB == null) {
                throw new SnmpException("Unreachable Switch:" + sw);
            }
            return PSBase.generatePeer(swB, snmpUserOpt);
        }
        catch (UnknownHostException exx) {
            throw new SnmpException("Unreachable Switch:" + sw);
        }
    }

    public int[] getCfsIndex(String sw) {
        if (PSBase.isN5KOrN7K(sw)) {
            return (int[])PortSecurityRif.FEATURE_TABLE[0][2];
        }
        return (int[])PortSecurityRif.FEATURE_TABLE[0][1];
    }

    public static ArrayList<String> getN5KAndN7KSwitchList(ArrayList<String> swList) {
        ArrayList<String> n5kAndN7KSwitches = new ArrayList<String>();
        for (String sw : swList) {
            if (!PSBase.isN5KOrN7K(sw)) continue;
            n5kAndN7KSwitches.add(sw);
        }
        return n5kAndN7KSwitches;
    }

    public static boolean isN5KOrN7K(String sw) {
        try {
            InetAddress iAdd = InetAddress.getByName(sw);
            SwitchImpl swImpl = SanManager.getInstance().findSwitchByIP(iAdd);
            if (swImpl == null) {
                return false;
            }
            if (swImpl.isN5K() || swImpl.isN7K()) {
                return true;
            }
        }
        catch (UnknownHostException exx) {
            return false;
        }
        return false;
    }

    public boolean isError() {
        return this.errorException != null && this.errorException.length > 0;
    }

    @Override
    public void setStatus(String stat) {
        _Logger.info((Object)stat);
        this.status = stat;
    }

    @Override
    public void handleError(Exception[] ex) {
        this.errorException = ex;
        this.lastActionSuccess = false;
        StringBuffer errMsg = new StringBuffer();
        if (ex != null && ex.length > 0) {
            for (int i = 0; i < ex.length; ++i) {
                errMsg.append(ex[i]);
            }
        }
        _Logger.error((Object)("last Action Failed:" + errMsg));
    }

    @Override
    public void dispose() {
        if (this.errorException != null) {
            this.errorException = null;
        }
    }

    @Override
    public void actionFinished() {
        _Logger.info((Object)"Successfully finished last action");
        this.lastActionSuccess = true;
    }

    public Exception[] getErrorException() {
        return this.errorException;
    }

    public String getStatus() {
        return this.status;
    }

    public void stopAction() {
        this.stopAction = true;
        if (this.acEnabler != null) {
            this.acEnabler.stopPolling();
        }
    }

    public void resetStopAction() {
        this.stopAction = false;
        this.lastActionSuccess = true;
        this.errorException = null;
    }

    public boolean isLastActionSuccess() {
        return this.lastActionSuccess;
    }

    public boolean startCommit(String sw, SnmpUserOpt userOpt, int[] cfsIndex, int[] scope, String name, int commitVal) throws SnmpException {
        ArrayList<SnmpPeer> swList = new ArrayList<SnmpPeer>();
        swList.add(PSBase.generatePeer(sw, userOpt));
        return this.startCommit(swList, this.getCfsIndex(sw), scope, name, commitVal);
    }

    public boolean startCommit(ArrayList swList, int[] cfsIndex, int[] scope, String name, int commitVal) throws SnmpException {
        this.status = "";
        this.errorException = null;
        CfsActionCommitter cfsCommitter = new CfsActionCommitter(swList, this, cfsIndex, scope, commitVal, name);
        if (this.stopAction) {
            this.lastActionSuccess = true;
            _Logger.info((Object)"Operation Stopped");
            return false;
        }
        this.acEnabler = cfsCommitter;
        this.lastActionSuccess = false;
        _Logger.info((Object)("Committing on Switch " + swList.get(0) + ", Info:" + name));
        cfsCommitter.startAction();
        return true;
    }

    public void setReadFrom(String sw, boolean running, int[] cfsIndex, SnmpUserOpt userOpt) throws SnmpException {
        VarBindList vbl = new VarBindList();
        this.readFromVbl(vbl, running, this.getCfsIndex(sw));
        _Logger.info((Object)("Port Security Wizard:Set Read DB from on " + sw + " to " + (running ? "running DB" : "Pending DB")));
        SnmpFetch.set(PSBase.generatePeer(sw, userOpt), vbl);
    }

    public void readFromVbl(VarBindList vbl, boolean readRunning, int[] cfsIndex) {
        vbl.add(MibNode.get("cfsFeatureOpShowCfgOption").getOid(), cfsIndex, (SnmpVar)new SnmpInt(readRunning ? 1 : 2));
    }

    protected SnmpPDU buildPSMPDU(byte action, VarBindList vbl) {
        SnmpPDU pdu = new SnmpPDU(action, vbl);
        pdu.setLogger(_Logger);
        return pdu;
    }

    public ArrayList getSwitchMergeState(String[] swList, int[] cfsIndex, int[] scope, SnmpUserOpt userOpt) throws SnmpException {
        SnmpPeer[] peers = new SnmpPeer[swList.length];
        for (int i = 0; i < swList.length; ++i) {
            peers[i] = PSBase.generatePeer(swList[i], userOpt);
        }
        ArrayList<Object[]> featureList = new ArrayList<Object[]>();
        VarBindList vbl = new VarBindList();
        vbl.add(MibNode.get("cfsMergeStatusValue").getOid(), this.buildCFSIndex(cfsIndex, scope));
        SnmpPDU[] pdus = new SnmpAggregrate().get(peers, vbl);
        for (int i = 0; i < pdus.length; ++i) {
            if (pdus[i].getError() != 0) {
                throw new SnmpException(pdus[i].getAddress().getHostName() + ": " + SnmpException.toError(pdus[i].getError()));
            }
            VarBindList response = pdus[i].getVariables();
            if (response == null) continue;
            SnmpPeer prr = this.findPeer(pdus[i].getAddress(), peers);
            Object[] obb = new Object[]{prr != null ? prr.getAddress().getHostAddress() : null, new int[]{response.getVb(0).getVar().getType() == 5 ? 1 : response.intValue(0)}};
            featureList.add(obb);
        }
        return featureList;
    }

    protected SnmpPeer findPeer(InetAddress add, SnmpPeer[] peers) {
        if (peers != null && add != null) {
            for (int i = 0; i < peers.length; ++i) {
                if (!add.equals(peers[i].getAddress())) continue;
                return peers[i];
            }
        }
        return null;
    }

    protected int[] buildCFSIndex(int[] featureIndex, int[] scope) {
        IntArray intAr = new IntArray(featureIndex);
        if (scope != null && scope.length == 2) {
            intAr.add(scope);
            if (scope[0] == 1) {
                return intAr.toArray();
            }
            if (scope[0] == 2) {
                byte[] bt = SnmpIntList.valueOf(new int[]{scope[1]});
                int[] btVal = new int[bt.length];
                for (int k = 0; k < bt.length; ++k) {
                    btVal[k] = bt[k];
                }
                intAr.add(btVal);
                return intAr.toArray();
            }
        }
        return featureIndex;
    }

    public class MergeStatusThread
    implements Runnable {
        String[] cfsSwitchList;
        int[] cfsIndex;
        int[] scope;
        SnmpUserOpt userOpt;

        public MergeStatusThread(String[] swList, int[] cfsIndex, int[] scope, SnmpUserOpt userOpt) {
            this.cfsSwitchList = swList;
            this.cfsIndex = cfsIndex;
            this.scope = scope;
            this.userOpt = userOpt;
        }

        @Override
        public void run() {
            boolean mergeInProgress = true;
            ArrayList mergeStateList = null;
            String mergeWaitSwitch = null;
            String mergeSwitch = null;
            PSBase.this.setStatus("Validating CFS merge...");
            try {
                block4: for (int counter = 0; counter < MERGE_CHECK_TRIES && mergeInProgress && !PSBase.this.stopAction; ++counter) {
                    try {
                        Thread.sleep(MERGE_SLEEP_TIME);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    mergeStateList = PSBase.this.getSwitchMergeState(this.cfsSwitchList, this.cfsIndex, this.scope, this.userOpt);
                    mergeInProgress = false;
                    for (int m = 0; m < mergeStateList.size(); ++m) {
                        Object[] ob = (Object[])mergeStateList.get(m);
                        int mergeState = ((int[])ob[1])[0];
                        if (mergeInProgress) {
                            if (mergeState != 4) continue;
                            mergeWaitSwitch = (String)ob[0];
                            continue block4;
                        }
                        if (mergeState == 2 || mergeState == 4) {
                            mergeInProgress = true;
                            mergeSwitch = (String)ob[0];
                            PSBase.this.setStatus("CFS Merge waiting on " + mergeSwitch + "...");
                            continue;
                        }
                        if (mergeState != 3 || ob[0] == null) continue;
                        mergeSwitch = (String)ob[0];
                    }
                }
                if (PSBase.this.stopAction) {
                    PSBase.this.lastActionSuccess = true;
                    _Logger.info((Object)"Operation Stopped");
                } else if (!mergeInProgress) {
                    PSBase.this.actionFinished();
                } else {
                    String msg = "CFS Merge is in Progress." + (mergeWaitSwitch != null ? " (" + mergeWaitSwitch + "...)" : "") + ". \nThis can happen if CFS Merge is locked for other features.\n" + "Please check Merge Status and merge locks for all features by \nissuing CLI command 'show cfs merge status...' \n" + "and restart wizard after clearing the merge locks for other features.";
                    PSBase.this.handleError(new Exception[]{new Exception(msg)});
                }
            }
            catch (SnmpException ex) {
                PSBase.this.handleError(new Exception[]{ex});
            }
        }
    }
}

