/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.scheduler;

import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.common.rif.SchedulerRif;
import com.cisco.dcbu.sm.server.scheduler.jobs.AnalysisReportJob;
import com.cisco.dcbu.sm.server.scheduler.jobs.BackUpConfigJob;
import com.cisco.dcbu.sm.server.scheduler.jobs.CapacityJob;
import com.cisco.dcbu.sm.server.scheduler.jobs.CustomReportJob;
import com.cisco.dcbu.sm.server.scheduler.jobs.DCNMReportJob;
import com.cisco.dcbu.sm.server.scheduler.jobs.IndexJob;
import com.cisco.dcbu.sm.server.scheduler.jobs.JobDirector;
import com.cisco.dcbu.sm.server.scheduler.jobs.PmServiceJob;
import com.cisco.dcbu.sm.server.smisjob.JobManagementJob;
import com.cisco.dcbu.sm.server.web.WebConst;
import com.cisco.dcbu.sme.accounting.SMEKMCAccountingJob;
import com.cisco.dcbu.sme.ckmc.replication.SMEKMCReplicationJob;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.naming.InitialContext;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.StatefulJob;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;
import org.quartz.impl.StdScheduler;

public class SchedulerManagerImpl
implements SchedulerRif {
    private Logger _log = null;
    private InitialContext _IniCtx = null;
    private StdScheduler _Scheduler = null;
    private String _JobID;
    private Date _TimeStamp;
    private long _TimeSuffix;
    public final String QUARTZ_JNDI = "QuartzScheduler";
    public final String GROUP_NAME = "DCM_Group";
    private final String COMMON_JOB_KEY = "jobClassName";
    public static final int RUN_ONCE = 1;
    public static final int RUN_DAILY = 2;
    public static final int RUN_WEEKLY = 3;
    public static final int RUN_TEST = 4;
    public static final int RUN_MONTHLY = 5;
    public static final int RUN_HOURLY = 6;
    public static final int SCHEDULE_SUCCESS = 0;
    public static final int SCHEDULE_DUPLICATE_NAME = -1;
    public static final int SCHEDULE_UNDEFINED_JOB_TYPE = -2;
    private static final String SMTP_HOST = "server.forward.email.smtphost";
    private static final String SENDER_ADDRESS = "server.forward.email.fromAddress";
    private static SchedulerManagerImpl _Instance = null;

    private SchedulerManagerImpl() throws Exception {
        GenUtil.loadServerLog4j();
        this._log = LogManager.getLogger((String)"FmQuartzScheduler");
        this._IniCtx = new InitialContext();
        this._Scheduler = (StdScheduler)this._IniCtx.lookup("QuartzScheduler");
        if (this._Scheduler == null) {
            this._log.error((Object)"Failed to acquire schedulers!");
            throw new Exception("Look up schedulers fails");
        }
        this.jBossMigration();
        if (this._Scheduler.isShutdown()) {
            this._Scheduler.start();
            this._log.info((Object)"Quartz Scheduler Started.");
        }
        this._TimeStamp = new Date();
        this._TimeSuffix = 0L;
    }

    private void jBossMigration() {
        try {
            String[] groupNameArr;
            for (String groupName : groupNameArr = this._Scheduler.getJobGroupNames()) {
                String[] jobNameArr;
                for (String jobName : jobNameArr = this._Scheduler.getJobNames(groupName)) {
                    JobDetail jobDetail = this._Scheduler.getJobDetail(jobName, groupName);
                    Class jClass = jobDetail.getJobClass();
                    String curJobName = jClass.getName();
                    if (!curJobName.startsWith("com.cisco.dcbu") || curJobName.equalsIgnoreCase(JobDirector.class.getName())) continue;
                    jobDetail.setJobClass(JobDirector.class);
                    JobDataMap jDataMap = jobDetail.getJobDataMap();
                    jDataMap.put("jobClassName", curJobName);
                    this._Scheduler.addJob(jobDetail, true);
                }
            }
        }
        catch (Exception ex) {
            this._log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public static SchedulerManagerImpl getInstance() throws Exception {
        if (_Instance == null) {
            _Instance = new SchedulerManagerImpl();
        }
        return _Instance;
    }

    @Override
    public int scheduleJob(int interval, int jobType, String jobName, JobDataMap jobStatesMap, Date startTime, boolean persist) throws Exception {
        return this.scheduleJob(interval, jobType, jobName, jobStatesMap, startTime, null, persist);
    }

    @Override
    public int scheduleJob(int interval, int jobType, String jobName, JobDataMap jobStatesMap, Date startTime, Date endTime, boolean persist) throws Exception {
        int scheduledJobCode = 0;
        String cronExpression = null;
        SimpleDateFormat timeFormat = new SimpleDateFormat("ss mm HH");
        SimpleDateFormat weekDayFormat = new SimpleDateFormat("EEE");
        SimpleDateFormat monthDayFormat = new SimpleDateFormat("d");
        String time = timeFormat.format(startTime);
        String weekDay = weekDayFormat.format(startTime).toUpperCase();
        String monthDay = monthDayFormat.format(startTime).toUpperCase();
        String hourlyCronExpression = System.getProperty("dailyToHourly");
        String fiveMinCronExpression = System.getProperty("monthlyTo5Min");
        interval = hourlyCronExpression != null ? 6 : interval;
        interval = fiveMinCronExpression != null && interval == 5 ? 4 : interval;
        String jobInstanceStr = this.getJobObj(jobType);
        jobStatesMap.put("jobClassName", jobInstanceStr);
        switch (interval) {
            case 1: {
                scheduledJobCode = this.scheduleSimpleJob(jobType, jobName, jobStatesMap, startTime, persist);
                break;
            }
            case 2: {
                cronExpression = hourlyCronExpression != null ? hourlyCronExpression : time + " * * ?";
                scheduledJobCode = this.scheduleCronJob(jobType, jobName, jobStatesMap, startTime, endTime, cronExpression, persist);
                break;
            }
            case 6: {
                cronExpression = "0 0 0/1 * * ?";
                scheduledJobCode = this.scheduleCronJob(jobType, jobName, jobStatesMap, startTime, endTime, cronExpression, persist);
                break;
            }
            case 3: {
                cronExpression = time + " ? * " + weekDay;
                scheduledJobCode = this.scheduleCronJob(jobType, jobName, jobStatesMap, startTime, endTime, cronExpression, persist);
                break;
            }
            case 4: {
                cronExpression = "0 0/5 * * * ?";
                scheduledJobCode = this.scheduleCronJob(jobType, jobName, jobStatesMap, startTime, endTime, cronExpression, persist);
                break;
            }
            case 5: {
                cronExpression = time + " " + monthDay + " * ? ";
                scheduledJobCode = this.scheduleCronJob(jobType, jobName, jobStatesMap, startTime, endTime, cronExpression, persist);
                break;
            }
        }
        return scheduledJobCode;
    }

    @Override
    public int scheduleJob(String cronExpression, int jobType, String jobName, JobDataMap jobStatesMap, Date startTime, Date endTime, boolean persist) throws Exception {
        int scheduledJobCode = 0;
        SimpleDateFormat timeFormat = new SimpleDateFormat("ss mm HH");
        SimpleDateFormat weekDayFormat = new SimpleDateFormat("EEE");
        String time = timeFormat.format(startTime);
        String weekDay = weekDayFormat.format(startTime).toUpperCase();
        scheduledJobCode = this.scheduleCronJob(jobType, jobName, jobStatesMap, startTime, endTime, cronExpression, persist);
        return scheduledJobCode;
    }

    private int scheduleCronJob(int jobType, String jobName, JobDataMap jobDataMap, Date startTime, Date endTime, String cronExpression, boolean persist) throws Exception {
        String jobInstanceStr = this.getJobObj(jobType);
        jobDataMap.put("jobClassName", jobInstanceStr);
        JobDirector job = new JobDirector();
        this._log.info((Object)"------- Scheduling cron Job -------------------");
        startTime = startTime == null ? TriggerUtils.getEvenMinuteDate((Date)new Date()) : startTime;
        String newJobID = jobName == null ? this.getJobID() : jobName;
        String userName = null;
        userName = jobDataMap.getString("UserName");
        if (!this.validateJobName(jobName, userName == null ? "DCM_Group" : userName)) {
            this._log.error((Object)("Job name:" + jobName + " already exist, please pick another one!"));
            return -1;
        }
        String groupName = userName == null ? "DCM_Group" : userName;
        CronTrigger trigger = new CronTrigger("trigger_" + newJobID, groupName, newJobID, groupName, startTime, endTime, cronExpression);
        JobDetail jobDetail = new JobDetail(newJobID, groupName, job.getClass());
        jobDetail.setJobDataMap(jobDataMap);
        if (!persist) {
            jobDetail.setVolatility(true);
            trigger.setVolatility(true);
        }
        this._Scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        this._log.info((Object)(jobDetail.getFullName() + " will start at: " + startTime));
        return 0;
    }

    private int scheduleSimpleJob(int jobType, String jobName, JobDataMap jobDataMap, Date startTime, boolean persist) throws SchedulerException {
        this._log.info((Object)"------- Scheduling Jobs -------------------");
        startTime = startTime == null ? TriggerUtils.getEvenMinuteDate((Date)new Date()) : startTime;
        String newJobID = jobName == null ? this.getJobID() : jobName;
        String userName = null;
        userName = jobDataMap.getString("UserName");
        if (!this.validateJobName(jobName, userName == null ? "DCM_Group" : userName)) {
            this._log.error((Object)("Job name:" + jobName + " already exist, please pick another one!"));
            return -1;
        }
        String groupName = userName == null ? "DCM_Group" : userName;
        SimpleTrigger trigger = new SimpleTrigger("trigger_" + newJobID, groupName, startTime);
        JobDetail jobDetail = new JobDetail(newJobID, groupName, JobDirector.class);
        jobDetail.setJobDataMap(jobDataMap);
        if (!persist) {
            jobDetail.setVolatility(true);
            trigger.setVolatility(true);
        }
        this._Scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        this._log.info((Object)(jobDetail.getFullName() + " will run at: " + startTime));
        return 0;
    }

    public String scheduleSimpleJob(int jobType, HashMap<Object, Object> jobStatesMap, Date startTime, long repeatInterval, boolean persist) throws SchedulerException, RemoteException {
        this._log.info((Object)"------- Scheduling Jobs -------------------");
        if (startTime == null) {
            startTime = TriggerUtils.getEvenMinuteDate((Date)new Date());
        }
        String newJobID = this.getJobID();
        String userName = null;
        JobDataMap jobDataMap = new JobDataMap();
        Iterator<Object> itr = jobStatesMap.keySet().iterator();
        Object key = null;
        Object value = null;
        while (itr.hasNext()) {
            key = itr.next();
            value = jobStatesMap.get(key);
            if (key.equals("UserName")) {
                userName = (String)value;
            }
            jobDataMap.put(key, value);
        }
        String groupName = userName == null ? "DCM_Group" : userName;
        SimpleTrigger trigger = new SimpleTrigger("trigger_" + newJobID, groupName, startTime, null, SimpleTrigger.REPEAT_INDEFINITELY, repeatInterval);
        JobDetail jobDetail = new JobDetail(newJobID, groupName, JobDirector.class);
        jobDetail.setJobDataMap(jobDataMap);
        if (!persist) {
            jobDetail.setVolatility(true);
            trigger.setVolatility(true);
        }
        this._Scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        this._log.info((Object)(jobDetail.getFullName() + " will start at: " + startTime));
        return newJobID;
    }

    public boolean unscheduleJob(String jobID) throws Exception {
        return this._Scheduler.unscheduleJob("trigger_" + jobID, "DCM_Group");
    }

    public boolean isTheSameJob(String jobID, Job newJob) throws SchedulerException {
        JobDetail jDetail = this._Scheduler.getJobDetail(jobID, "DCM_Group");
        return newJob.equals(jDetail.getJobClass());
    }

    public boolean isTheJobRunning(String jobID) throws SchedulerException {
        List jobList = this._Scheduler.getCurrentlyExecutingJobs();
        for (int i = 0; i < jobList.size(); ++i) {
            JobExecutionContext jExecutionContext = (JobExecutionContext)jobList.get(i);
            JobDetail jDetail = jExecutionContext.getJobDetail();
            if (!jobID.equalsIgnoreCase(jDetail.getName())) continue;
            return true;
        }
        return false;
    }

    private String getJobID() throws SchedulerException {
        if (this._JobID == null) {
            this._JobID = String.valueOf(this._TimeStamp.getTime()) + "A";
        } else {
            ++this._TimeSuffix;
            this._JobID = this._JobID + String.valueOf(this._TimeSuffix);
        }
        return this._JobID;
    }

    @Override
    public List<JobDetail> getJobListByUser(String userName) throws SchedulerException, RemoteException {
        String[] jobName = this._Scheduler.getJobNames(userName);
        ArrayList<JobDetail> list = new ArrayList<JobDetail>();
        for (int i = 0; i < jobName.length; ++i) {
            JobDetail jobDetail = this._Scheduler.getJobDetail(jobName[i], userName);
            list.add(jobDetail);
        }
        return list;
    }

    public List<JobDetail> getFullJobList() throws SchedulerException, RemoteException {
        JobDetail jobDetail;
        int k;
        String[] jobNames;
        int i;
        String[] trgGrpName = this._Scheduler.getTriggerGroupNames();
        String[] jobGrpName = this._Scheduler.getJobGroupNames();
        ArrayList<JobDetail> list = new ArrayList<JobDetail>();
        if (trgGrpName != null) {
            for (i = 0; i < trgGrpName.length; ++i) {
                jobNames = this._Scheduler.getTriggerNames(trgGrpName[i]);
                if (jobNames == null) continue;
                for (k = 0; k < jobNames.length; ++k) {
                    jobDetail = this._Scheduler.getJobDetail(jobNames[k], trgGrpName[i]);
                    if (jobDetail == null) continue;
                    list.add(jobDetail);
                }
            }
        }
        if (jobGrpName != null) {
            for (i = 0; i < jobGrpName.length; ++i) {
                jobNames = this._Scheduler.getJobNames(jobGrpName[i]);
                if (jobNames == null) continue;
                for (k = 0; k < jobNames.length; ++k) {
                    jobDetail = this._Scheduler.getJobDetail(jobNames[k], jobGrpName[i]);
                    if (jobDetail == null) continue;
                    list.add(jobDetail);
                }
            }
        }
        return list;
    }

    @Override
    public List<String> checkJobList(String userName) throws SchedulerException, RemoteException {
        String[] jobName = this._Scheduler.getJobNames(userName);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < jobName.length; ++i) {
            try {
                JobDetail jobDetail = this._Scheduler.getJobDetail(jobName[i], userName);
                continue;
            }
            catch (Exception e) {
                this._Scheduler.unscheduleJob(jobName[i], userName);
                this._Scheduler.deleteJob(jobName[i], userName);
                list.add(jobName[i]);
            }
        }
        return list;
    }

    @Override
    public JobDetail getJobDetail(String jobName, String groupName) throws SchedulerException, RemoteException {
        return this._Scheduler.getJobDetail(jobName, groupName);
    }

    private String getJobObj(int jobType) {
        switch (jobType) {
            case 1: {
                return CustomReportJob.class.getName();
            }
            case 2: {
                return AnalysisReportJob.class.getName();
            }
            case 4: {
                return SMEKMCAccountingJob.class.getName();
            }
            case 5: {
                return SMEKMCReplicationJob.class.getName();
            }
            case 6: {
                return IndexJob.class.getName();
            }
            case 7: {
                return BackUpConfigJob.class.getName();
            }
            case 8: {
                return CapacityJob.class.getName();
            }
            case 9: {
                return DCNMReportJob.class.getName();
            }
            case 10: {
                return JobManagementJob.class.getName();
            }
            case 11: {
                return PmServiceJob.class.getName();
            }
        }
        return null;
    }

    public boolean deleteJob(String jobName) throws SchedulerException, Exception {
        return this.deleteJob(jobName, null);
    }

    @Override
    public boolean deleteJob(String jobName, String groupName) throws SchedulerException, Exception {
        return this._Scheduler.deleteJob(jobName, groupName == null ? "DCM_Group" : groupName);
    }

    public void cleanUp() throws Exception {
        int j;
        String[] names;
        int i;
        this._log.warn((Object)"***** Deleting existing jobs/triggers *****");
        String[] groups = this._Scheduler.getTriggerGroupNames();
        for (i = 0; i < groups.length; ++i) {
            names = this._Scheduler.getTriggerNames(groups[i]);
            for (j = 0; j < names.length; ++j) {
                this._Scheduler.unscheduleJob(names[j], groups[i]);
            }
        }
        groups = this._Scheduler.getJobGroupNames();
        for (i = 0; i < groups.length; ++i) {
            names = this._Scheduler.getJobNames(groups[i]);
            for (j = 0; j < names.length; ++j) {
                this._Scheduler.deleteJob(names[j], groups[i]);
            }
        }
    }

    private boolean validateJobName(String jobName, String userName) throws SchedulerException {
        String[] jobNames = this._Scheduler.getJobNames(userName);
        for (int i = 0; i < jobNames.length; ++i) {
            if (!jobName.equalsIgnoreCase(jobNames[i])) continue;
            return false;
        }
        return true;
    }

    public static void validateEmailSettings() throws RemoteException {
        String smtpServer = System.getProperty(SMTP_HOST);
        String senderAddr = System.getProperty(SENDER_ADDRESS);
        if (senderAddr == null || senderAddr.length() == 0) {
            throw new RemoteException("Please set property: server.forward.email.fromAddress under admin --> Server Properties");
        }
        if (smtpServer == null || smtpServer.length() == 0) {
            throw new RemoteException("Please set property: server.forward.email.smtphost under admin --> Server Properties");
        }
    }

    @Override
    public JobDataMap jobCallback(JobExecutionContext jobCxt) throws RemoteException {
        JobDetail jobDetail = jobCxt.getJobDetail();
        String jobInstanceStr = (String)jobDetail.getJobDataMap().get((Object)"jobClassName");
        try {
            if (jobDetail.getJobDataMap().get((Object)"JobType") != null && ((String)jobDetail.getJobDataMap().get((Object)"JobType")).equalsIgnoreCase(WebConst.JOB_TYPES[9]) && jobInstanceStr.equalsIgnoreCase(CustomReportJob.class.getName())) {
                jobInstanceStr = DCNMReportJob.class.getName();
                jobDetail.getJobDataMap().put("jobClassName", jobInstanceStr);
            }
            StatefulJob jobObj = (StatefulJob)Class.forName(jobInstanceStr).newInstance();
            jobObj.execute(jobCxt);
        }
        catch (Exception ex) {
            this._log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        return jobCxt.getJobDetail().getJobDataMap();
    }

    @Override
    public void start() throws Exception {
        this._log.info((Object)"SchedulerManager - Starting");
    }

    @Override
    public void stop() {
        this._log.info((Object)"SchedulerManager - Stopping");
    }

    @Override
    public int scheduleJob(String cronExpression, int jobType, String jobName, JobDataMap jobStatesMap, Date startTime, boolean persist) throws Exception {
        return this.scheduleJob(cronExpression, jobType, jobName, jobStatesMap, startTime, null, persist);
    }
}

