/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.scheduler.jobs;

import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.IndexUtil;
import com.cisco.dcbu.sm.common.model.IndexerBase;
import com.cisco.dcbu.sm.common.model.ZoneMemUnit;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.web.util.DisplayUtil;
import com.cisco.dcbu.smis.provider.helper.MappingUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.LockObtainFailedException;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;

public class IndexJob
implements StatefulJob,
Serializable {
    private static final long serialVersionUID = 1L;
    static final String SwitchQuerySql = "select switch.id \t\t, sys_name\t, wwn, wwn,null, ip_address, ip_address, fabric.fid, serial_number, null from switch,fabric where switch.fabric_id = fabric.id";
    static final String EndPortQuerySql = "select end_port.id \t\t,alias\t, wwn, wwn,end_port.name, null,null, fabric.fid, null, null from end_port,fabric where fabric.id = end_port.fabric_id";
    static final String VsanQuerySql = "select vsan.id \t, vsan.name\t\t, principal_swwn, principal_swwn,null,ip_address,ip_address,fabric.fid, null, null \tfrom vsan,fabric,switch where vsan.fabric_id = fabric.id and principal_sw_id=switch.id and switch.fabric_id = fabric.id";
    static final String EnclQuerySql = "(select id, name, null, null, null,null, null, enc_type, null, null from enclosure where enc_type=0) union (select host.id, host.name, null, null, null, ip_address, ip_address, 47, null, mac from host left join vhost on host.vhost_id=vhost.id)  union (select host.id, host.name, null, null, null, null, null, -9, null, ph.mac from vhost, phynic ph, host where vhost.id=ph.vhost_id and vhost.id=host.vhost_id) union (select host_map.host_id, name, null, null, null, null, null, -9, null, mac from lan_host, host_map where lan_host.id=host_map.lanhost_id and (mac not in (select distinct mac from phynic)))";
    static final String VmQuerySql = "select vm.id, vm.name, null, null, null,vm.ip_address, null, vm.vhost_id, null, vnic.mac from vm, vnic where vm.id=vnic.vm_id";
    static final String LanSwitchQuerySql = "select ethswitch.id, sys_name\t, ip_address, lanswitch_map.lan_id, serial_number from ethswitch,lanswitch_map where ethswitch.id = lanswitch_map.id";
    static final String ModuleSerialNumberSql = "(select HW_COMPONENT.switch_id, HW_COMPONENT.name, SWITCH.ip_address, fabric.fid, HW_COMPONENT.serial_number, 0 from HW_COMPONENT, SWITCH, FABRIC where (HW_COMPONENT.SWITCH_ID = SWITCH.ID) AND (FABRIC.ID = SWITCH.FABRIC_ID))UNION(select HW_COMPONENT.switch_id, HW_COMPONENT.name, ETHSWITCH.ip_address, lanswitch_map.lan_id, HW_COMPONENT.serial_number, 1 from HW_COMPONENT, ETHSWITCH, LAN, LANSWITCH_MAP where (HW_COMPONENT.SWITCH_ID = ETHSWITCH.ID) AND (ETHSWITCH.ID = LANSWITCH_MAP.ID) AND (LAN.ID = LANSWITCH_MAP.LAN_ID) )";
    static final String SmisStorageSystemSql = "select id, id, system_name, null, serial_number from smis_storage_system";
    static final String SmisStoragePortSql = "select id, system_db_id, port_name, perm_address, null from smis_storage_port";
    static final String SmisPoolSql = "select id, system_db_id, pool_name, null, null from smis_pool";
    static final String SmisLunSql = "select id, system_db_id, lun_name, wwn, null from smis_storage_lun";
    static final String SmisHostPort = "select host.id, host.system_db_id, host.host_name, host_nwwn, host_pwwn from smis_host host, smis_host_port port where port.host_db_id=host.id";
    static final String SmisStorageProcessor = "select id, system_db_id, processor_name, ip_address, serial_number from smis_storage_processor";
    static final String PmEndDeviceQuerySql = "SELECT STAT.SRC_ID,STAT.DEST_ID,END_PORT.NAME,END_PORT.WWN, END_PORT.WWN, END_PORT.ALIAS,null,null,FABRIC.FID FROM STATISTICS STAT,END_PORT,ENCLOSURE,SWITCH_PORT SP,FABRIC, SWITCH WHERE ( END_PORT.SWITCH_PORT_ID = SP.ID ) AND SP.SWITCH_ID=SWITCH.ID AND ( END_PORT.ENCLOSURE_ID = ENCLOSURE.ID ) AND (STAT.SRC_ID=END_PORT.ID) AND (( STAT.TYPE=3)OR (STAT.TYPE=4)) AND (END_PORT.FABRIC_ID = FABRIC.ID) AND (FABRIC.LICENSE_ID > 1 )";
    static final String PmFlowQuerySql = " SELECT STAT.SRC_ID,STAT.DEST_ID,EP1.ALIAS ||'<->'||EP2.ALIAS, EP1.WWN,EP2.WWN, EP1.ALIAS ||'<->'||EP2.ALIAS,null,null,FABRIC.FID FROM STATISTICS STAT, END_PORT EP1, END_PORT EP2, VSAN_ENDPORT_INFO VINFO1, VSAN_ENDPORT_INFO VINFO2,VSAN,FABRIC WHERE (STAT.SRC_ID=EP1.ID AND STAT.DEST_ID=EP2.ID)  AND (TYPE=2) AND (EP1.ID = VINFO1.ENDPORT_ID) AND ( EP2.ID=VINFO2.ENDPORT_ID) AND ( VINFO1.VSAN_ID = VSAN.ID) AND ( VINFO2.VSAN_ID = VSAN.ID) AND (EP1.FABRIC_ID = FABRIC.ID) AND(EP2.FABRIC_ID = FABRIC.ID) AND (FABRIC.LICENSE_ID > 1 ) ";
    static final String EvtQuerySql = "select eventid, source,descr from events, switch, fabric where switchid = switch.id and switch.fabric_id = fabric.id ";
    static final String EvtEnclosureQuerySql = "select eventid, encl.name, events.descr from events, enclosure encl where enclosure_id > 0 and enclosure_id = encl.id";
    static final String INDEX_DIR = ClientCache.getInstallLocation() + File.separator + "db" + File.separator + "index";
    Logger _Log = Logger.getLogger((String)"fms");
    private static Lock lock = new ReentrantLock();
    Connection conn = null;
    PreparedStatement pstmt = null;
    ResultSet rs = null;

    public void execute(JobExecutionContext arg0) throws JobExecutionException {
        if (ClientCache.getDcmDir() == null) {
            return;
        }
        this._Log.info((Object)("Index will be stored in this location: " + INDEX_DIR));
        this.createIndex();
    }

    public void buildIndex() {
        ExecutorService pool = Executors.newSingleThreadExecutor();
        CreateIndexCallable call = new CreateIndexCallable();
        pool.submit(call);
        pool.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndex() {
        this._Log.info((Object)("Start to create Index at :" + INDEX_DIR));
        IndexWriter invIdxWriter = null;
        IndexWriter pmIdxWriter = null;
        Object evtIdxWriter = null;
        String[] inventorySqls = this.formInvSqls();
        String[] performanceSqls = this.formPerfSqls();
        lock.lock();
        try {
            invIdxWriter = this.buildInventoryIdx(inventorySqls);
            pmIdxWriter = this.buildPerfIdx(performanceSqls);
        }
        catch (Exception ex) {
            this._Log.warn((Object)"Error in index creation.", (Throwable)ex);
        }
        finally {
            try {
                if (pmIdxWriter != null) {
                    pmIdxWriter.close();
                }
                if (invIdxWriter != null) {
                    invIdxWriter.close();
                }
                if (evtIdxWriter != null) {
                    evtIdxWriter.close();
                }
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            DbUtil.close(this.rs);
            DbUtil.close(this.pstmt);
            DbUtil.close(this.conn);
            lock.unlock();
        }
        this._Log.info((Object)"Create Index Done.");
    }

    private IndexWriter buildPerfIdx(String[] performanceSqls) throws CorruptIndexException, LockObtainFailedException, IOException, SQLException {
        IndexWriter pmIdxWriter = new IndexWriter(INDEX_DIR + File.separator + "pm", (Analyzer)new StandardAnalyzer(), true, IndexWriter.MaxFieldLength.LIMITED);
        int idx = 1;
        for (String sql : performanceSqls) {
            this.pstmt = this.conn.prepareStatement(sql);
            this.rs = this.pstmt.executeQuery();
            IndexerBase iBase = null;
            try {
                while (this.rs.next()) {
                    String idxName;
                    long id = this.rs.getLong(1);
                    long dstId = this.rs.getLong(2);
                    String name = this.rs.getString(3);
                    byte[] wwn1 = this.rs.getBytes(4);
                    byte[] wwn2 = this.rs.getBytes(5);
                    String alias = this.rs.getString(6);
                    byte[] sw_ip1 = this.rs.getBytes(7);
                    byte[] sw_ip2 = this.rs.getBytes(8);
                    long fid = this.rs.getLong(9);
                    String wwn1Str = SnmpString.toHexString(wwn1);
                    wwn1Str = wwn1Str == null ? "" : wwn1Str;
                    String wwn2Str = SnmpString.toHexString(wwn2);
                    wwn2Str = wwn2Str == null ? "" : wwn2Str;
                    String sw_ip1Str = "";
                    String sw_ip2Str = "";
                    try {
                        sw_ip1Str = sw_ip1 == null ? "" : InetAddress.getByAddress(sw_ip1).getHostAddress();
                        sw_ip1Str = sw_ip1Str == null ? "" : sw_ip1Str;
                        sw_ip2Str = sw_ip2 == null ? "" : InetAddress.getByAddress(sw_ip2).getHostAddress();
                        sw_ip2Str = sw_ip2Str == null ? "" : sw_ip2Str;
                    }
                    catch (Exception ex) {
                        this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                    }
                    String string = idxName = name == null ? "" : name;
                    if (idx == 2) {
                        if (name.indexOf(60) == 0) {
                            idxName = DisplayUtil.getWwn(wwn1).toString() + name;
                        }
                        if (name.indexOf(62) == name.length() - 1) {
                            idxName = idxName + DisplayUtil.getWwn(wwn2).toString();
                        }
                    }
                    iBase = new IndexerBase(id, dstId, idxName, 1, idx, wwn1Str.equals(wwn2Str) ? wwn1Str : wwn1Str + "<->" + wwn2Str, alias == null ? "" : alias, sw_ip1Str.equals(sw_ip2Str) ? sw_ip1Str : sw_ip1Str + "<->" + sw_ip2Str);
                    iBase.setIdentityId(fid);
                    pmIdxWriter.addDocument(this.formatDoc(iBase));
                }
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            ++idx;
            DbUtil.close(this.rs);
            DbUtil.close(this.pstmt);
        }
        pmIdxWriter.optimize();
        return pmIdxWriter;
    }

    private IndexWriter buildEvtIdx(String[] eventSqls) throws CorruptIndexException, LockObtainFailedException, IOException, SQLException {
        IndexWriter evtIdxWriter = new IndexWriter(INDEX_DIR + File.separator + "evt", (Analyzer)new StandardAnalyzer(), true, IndexWriter.MaxFieldLength.LIMITED);
        int idx = 1;
        for (String sql : eventSqls) {
            try {
                this.pstmt = this.conn.prepareStatement(sql);
                this.rs = this.pstmt.executeQuery();
                IndexerBase iBase = null;
                while (this.rs.next()) {
                    long id = this.rs.getLong(1);
                    String name = this.rs.getString(2);
                    String dscr = this.rs.getString(3);
                    String idxName = name == null ? "" : name;
                    iBase = new IndexerBase(id, idxName, 3, dscr);
                    evtIdxWriter.addDocument(this.formatDoc(iBase));
                }
                ++idx;
            }
            catch (SQLException e) {
                throw e;
            }
            finally {
                DbUtil.close(this.rs);
                DbUtil.close(this.pstmt);
            }
        }
        evtIdxWriter.optimize();
        return evtIdxWriter;
    }

    private IndexWriter buildInventoryIdx(String[] inventorySqls) throws CorruptIndexException, LockObtainFailedException, IOException, SQLException {
        String serialNo;
        String name;
        IndexWriter invIdxWriter = new IndexWriter(INDEX_DIR + File.separator + "inv", (Analyzer)new StandardAnalyzer(), true, IndexWriter.MaxFieldLength.LIMITED);
        int idx = 1;
        this.conn = ConnectionManager.getConnection();
        for (String sql : inventorySqls) {
            this.pstmt = this.conn.prepareStatement(sql);
            this.rs = this.pstmt.executeQuery();
            IndexerBase iBase = null;
            boolean isIpStr = false;
            if (idx == 5) {
                isIpStr = true;
            }
            try {
                while (this.rs.next()) {
                    long id = this.rs.getLong(1);
                    String name2 = this.rs.getString(2);
                    byte[] wwn1 = this.rs.getBytes(3);
                    byte[] wwn2 = this.rs.getBytes(4);
                    String alias = this.rs.getString(5);
                    byte[] sw_ip1 = null;
                    byte[] sw_ip2 = null;
                    String sw_ip1Str = "";
                    String sw_ip2Str = "";
                    if (!isIpStr) {
                        sw_ip1 = this.rs.getBytes(6);
                        sw_ip2 = this.rs.getBytes(7);
                    } else {
                        sw_ip1Str = this.rs.getString(6);
                        sw_ip2Str = this.rs.getString(7);
                    }
                    long fDbid = this.rs.getLong(8);
                    String serialNo2 = this.rs.getString(9);
                    String mac = this.rs.getString(10);
                    if (serialNo2 == null) {
                        serialNo2 = "";
                    }
                    if (mac == null) {
                        mac = "";
                    }
                    String idxName = name2 == null ? "" : name2;
                    String wwn1Str = SnmpString.toHexString(wwn1);
                    wwn1Str = wwn1Str == null ? "" : wwn1Str;
                    String wwn2Str = SnmpString.toHexString(wwn2);
                    String string = wwn2Str = wwn2Str == null ? "" : wwn2Str;
                    if (!isIpStr) {
                        try {
                            sw_ip1Str = sw_ip1 == null ? "" : InetAddress.getByAddress(sw_ip1).getHostAddress();
                            sw_ip1Str = sw_ip1Str == null ? "" : sw_ip1Str;
                        }
                        catch (Exception ex) {
                            this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                        }
                        try {
                            sw_ip2Str = sw_ip2 == null ? "" : InetAddress.getByAddress(sw_ip2).getHostAddress();
                            sw_ip2Str = sw_ip2Str == null ? "" : sw_ip2Str;
                        }
                        catch (Exception ex) {
                            this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                        }
                    } else {
                        sw_ip1Str = sw_ip1Str == null ? "" : sw_ip1Str;
                        sw_ip2Str = sw_ip2Str == null ? "" : sw_ip2Str;
                    }
                    iBase = new IndexerBase(id, idxName, 2, idx, wwn1Str.equals(wwn2Str) ? wwn1Str : wwn1Str + "<->" + wwn2Str, alias == null ? "" : alias, sw_ip1Str.equals(sw_ip2Str) ? sw_ip1Str : sw_ip1Str + "<->" + sw_ip2Str, fDbid, serialNo2, mac);
                    invIdxWriter.addDocument(this.formatDoc(iBase));
                }
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            ++idx;
            DbUtil.close(this.rs);
            DbUtil.close(this.pstmt);
        }
        List<ZoneMemUnit> zoneMemList = IndexUtil.getInstance().getAllZoneMemInfo();
        for (int i = 0; i < zoneMemList.size(); ++i) {
            ZoneMemUnit zoneMem = zoneMemList.get(i);
            IndexerBase iBase = new IndexerBase(zoneMem.getZoneMemDbId(), zoneMem.getZoneMemName(), 2, zoneMem.isIvr() ? 9 : 8, zoneMem.getZoneMemWwn(), zoneMem.getZoneName(), "", zoneMem.isIvr() ? 1L : -1L, "", "");
            iBase.setDestId(zoneMem.getParentId());
            invIdxWriter.addDocument(this.formatDoc(iBase));
        }
        this.pstmt = this.conn.prepareStatement(LanSwitchQuerySql);
        this.rs = this.pstmt.executeQuery();
        IndexerBase iBase = null;
        try {
            while (this.rs.next()) {
                long id = this.rs.getLong(1);
                name = this.rs.getString(2);
                byte[] sw_ip = this.rs.getBytes(3);
                long lanDbid = this.rs.getLong(4);
                serialNo = this.rs.getString(5);
                String idxName = name == null ? "" : name;
                String sw_ipStr = "";
                try {
                    sw_ipStr = sw_ip == null ? "" : InetAddress.getByAddress(sw_ip).getHostAddress();
                    sw_ipStr = sw_ipStr == null ? "" : sw_ipStr;
                }
                catch (Exception ex) {
                    this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                }
                iBase = new IndexerBase(id, idxName, 2, 10);
                iBase.setScopeType(1);
                iBase.setIdentityId(lanDbid);
                iBase.setIpaddr(sw_ipStr);
                if (serialNo != null) {
                    iBase.setSerialNumber(serialNo);
                }
                invIdxWriter.addDocument(this.formatDoc(iBase));
            }
        }
        catch (Exception ex) {
            this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        DbUtil.close(this.rs);
        DbUtil.close(this.pstmt);
        this.pstmt = this.conn.prepareStatement(ModuleSerialNumberSql);
        this.rs = this.pstmt.executeQuery();
        try {
            while (this.rs.next()) {
                long id = this.rs.getLong(1);
                name = this.rs.getString(2);
                byte[] sw_ip = this.rs.getBytes(3);
                long lanOrFabDbid = this.rs.getLong(4);
                serialNo = this.rs.getString(5);
                int scopeType = this.rs.getInt(6);
                String idxName = name == null ? "" : name;
                String sw_ipStr = "";
                try {
                    sw_ipStr = sw_ip == null ? "" : InetAddress.getByAddress(sw_ip).getHostAddress();
                    sw_ipStr = sw_ipStr == null ? "" : sw_ipStr;
                }
                catch (Exception ex) {
                    this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                }
                iBase = new IndexerBase(id, idxName, 2, 11);
                iBase.setScopeType(scopeType);
                iBase.setIdentityId(lanOrFabDbid);
                if (serialNo != null) {
                    iBase.setSerialNumber(serialNo);
                }
                invIdxWriter.addDocument(this.formatDoc(iBase));
            }
        }
        catch (Exception ex) {
            this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        DbUtil.close(this.rs);
        DbUtil.close(this.pstmt);
        String[] inventorySmisSqls = this.formInvSmisSqls();
        idx = 12;
        for (String sql : inventorySmisSqls) {
            this.pstmt = this.conn.prepareStatement(sql);
            this.rs = this.pstmt.executeQuery();
            IndexerBase inBase = null;
            try {
                while (this.rs.next()) {
                    String idxName;
                    long id = this.rs.getLong(1);
                    long id2 = this.rs.getLong(2);
                    String name3 = this.rs.getString(3);
                    String wwn1 = this.rs.getString(4);
                    String sn = this.rs.getString(5);
                    String wwn2 = null;
                    String mac = null;
                    String wwn1Str = null;
                    String ip = null;
                    if (idx == 16) {
                        wwn2 = sn;
                        sn = null;
                        name3 = name3 + "(" + MappingUtil.fmWwnFormat(wwn2) + ")";
                    }
                    if (idx == 17) {
                        ip = wwn1;
                        wwn1 = null;
                    }
                    if (wwn1 != null && wwn1.length() > 0 && wwn1.length() < 16) {
                        mac = wwn1;
                        wwn1 = null;
                    }
                    String string = idxName = name3 == null ? "" : name3;
                    if (wwn1 != null && wwn1.length() > 0) {
                        wwn1Str = MappingUtil.fmWwnFormat(wwn1);
                    }
                    String string2 = wwn1Str = wwn1Str == null ? "" : wwn1Str;
                    if (wwn2 != null && wwn2.length() > 0) {
                        String wwn2Str = MappingUtil.fmWwnFormat(wwn2);
                        wwn1Str = wwn1Str + ":" + wwn2Str;
                    }
                    inBase = new IndexerBase(id, idxName, 2, idx, wwn1Str);
                    inBase.setIdentityId(id2);
                    if (mac != null && mac.length() > 0) {
                        String macStr = MappingUtil.fmWwnFormat(mac);
                        inBase.setMacAddr(macStr);
                    }
                    if (sn != null) {
                        inBase.setSerialNumber(sn);
                    }
                    if (ip != null && ip.length() > 0) {
                        inBase.setIpaddr(ip);
                    }
                    invIdxWriter.addDocument(this.formatDoc(inBase));
                }
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            ++idx;
            DbUtil.close(this.rs);
            DbUtil.close(this.pstmt);
        }
        invIdxWriter.optimize();
        return invIdxWriter;
    }

    private String[] formInvSqls() {
        String islInvQuerySql = PersistentHelper.getHelper().getInvISLIdxQuery();
        return new String[]{SwitchQuerySql, EndPortQuerySql, VsanQuerySql, islInvQuerySql, EnclQuerySql, VmQuerySql};
    }

    private String[] formInvSmisSqls() {
        return new String[]{SmisStorageSystemSql, SmisStoragePortSql, SmisPoolSql, SmisLunSql, SmisHostPort, SmisStorageProcessor};
    }

    private String[] formPerfSqls() {
        String islPerfQuerySql = PersistentHelper.getHelper().getPerfIslIdxQuery();
        return new String[]{PmEndDeviceQuerySql, PmFlowQuerySql, islPerfQuerySql};
    }

    private String[] formEvtSqls() {
        return new String[]{EvtQuerySql, EvtEnclosureQuerySql};
    }

    private Document formatDoc(IndexerBase base) {
        Document doc = new Document();
        doc.add((Fieldable)new Field("id", String.valueOf(base.getId()), Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("dstId", String.valueOf(base.getDstId()), Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("name", IndexUtil.getInstance().idxEscape(base.getName()), Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("category", String.valueOf(base.getCategory()), Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("type", String.valueOf(base.getType()), Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("link", base.getLink(), Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("wwn", IndexUtil.getInstance().idxEscape(base.getWwn()), Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("alias", IndexUtil.getInstance().idxEscape(base.getAlias()), Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("ipaddr", IndexUtil.getInstance().idxEscape(base.getIpaddr()), Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("dscr", IndexUtil.getInstance().idxEscape(base.getDscrpt()), Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("identityId", String.valueOf(base.getIdentityId()), Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("serialNumber", IndexUtil.getInstance().idxEscape(base.getSerialNumber()), Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("scopeType", String.valueOf(base.getScopeType()), Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("macAddr", IndexUtil.getInstance().idxEscape(base.getMacAddr()), Field.Store.YES, Field.Index.ANALYZED));
        return doc;
    }

    private void search(String queryString) throws ParseException, IOException {
        IndexSearcher searcher = new IndexSearcher(INDEX_DIR);
        QueryParser parser = new QueryParser("title", (Analyzer)new StandardAnalyzer());
        Query query = parser.parse(queryString);
        TopDocs topDocs = searcher.search(query, 10);
        int hitCount = topDocs.scoreDocs.length;
        if (hitCount == 0) {
            System.out.println("No matches were found for \"" + queryString + "\"");
        } else {
            System.out.println("Hits for \"" + queryString + "\" were found in quotes by:");
            int resultIdx = 0;
            for (int i = 0; i < hitCount; ++i) {
                ScoreDoc scoreDoc = topDocs.scoreDocs[i];
                Document doc = searcher.doc(scoreDoc.doc);
                System.out.println("Result " + ++resultIdx);
                List fList = doc.getFields();
                for (int j = 0; j < fList.size(); ++j) {
                    Field field = (Field)fList.get(j);
                    System.out.println("   " + field.name());
                    System.out.println("           " + field.stringValue());
                }
            }
        }
        System.out.println();
    }

    public static void main(String[] args) {
        IndexJob job = new IndexJob();
        job.createIndex();
    }

    public class CreateIndexCallable
    implements Callable<Integer> {
        @Override
        public Integer call() {
            IndexJob.this.createIndex();
            return new Integer(1);
        }
    }
}

