/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.security;

import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.security.DCNMUserImpl;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public final class FMUserFailedAttempts {
    private static final boolean _lockoutenabled = Boolean.valueOf(System.getProperty("login.lockout.enabled", "false"));
    private static final int _threshhold = Integer.valueOf(System.getProperty("login.lockout.threshold", "5"));
    private static final long _resetIntrvl = Long.valueOf(System.getProperty("login.lockout.ResetIntrvl", "3")) * 60000L;
    private static long _duration = Long.valueOf(System.getProperty("login.lockout.duration", "30"));
    public static Logger _Logger = Logger.getLogger((String)FMUserFailedAttempts.class.getName());
    private static FMUserFailedAttempts _instance = new FMUserFailedAttempts();
    String _user;
    static final String InsertFailedAttemptSQL = "insert into failed_attempts(user_name, failed_attempt_time) values(?,?)";
    static final String PurgeFailedAttemptsOutofRange = "delete from failed_attempts where user_name = ? and failed_attempt_time <= ?";
    static final String GetFailedAttemptsCountSQL = "select count(*) from failed_attempts where user_name=?";
    static final String GetUserFaliedAttempts = "select count(*) from failed_attempts where user_name=? and failed_attempt_time > ?";
    static final String GetAllFailedAttemptsSQL = "select failed_attempt_time from  failed_attempts where user_name =? order by failed_attempt_time desc";
    static final String LastFailedAttemptSQL = "select max(failed_attempt_time) from failed_attempts where user_name =?";
    static final String PurgeFailedAttemptsSQL = "delete from failed_attempts where user_name = ?";

    public static FMUserFailedAttempts getInstance() {
        return _instance;
    }

    public void InsertFailedAttempt(String username, long systime) throws Exception {
        Connection con = null;
        PreparedStatement stat = null;
        PreparedStatement stat2 = null;
        if (username == null) {
            return;
        }
        try {
            username = StringEncrypter.encryptString("DES", username);
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(InsertFailedAttemptSQL);
            stat.setString(1, username);
            stat.setLong(2, systime);
            stat.executeUpdate();
            stat2 = con.prepareStatement(PurgeFailedAttemptsOutofRange);
            stat2.setString(1, username);
            stat2.setLong(2, systime - _resetIntrvl);
            stat2.executeUpdate();
        }
        catch (Exception ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(stat2);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        DbUtil.close(stat2);
        DbUtil.close(con);
    }

    public void purgeFailedAttempt(String username) throws Exception {
        Connection con = null;
        PreparedStatement stat = null;
        if (username == null) {
            return;
        }
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(PurgeFailedAttemptsSQL);
            stat.setString(1, StringEncrypter.encryptString("DES", username));
            stat.executeUpdate();
        }
        catch (Exception ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        DbUtil.close(con);
    }

    public int getFailedAttemptsCount(String username) throws Exception {
        int n;
        Connection con = null;
        PreparedStatement stat = null;
        int result = 0;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(GetFailedAttemptsCountSQL);
            stat.setString(1, StringEncrypter.encryptString("DES", username));
            rs = stat.executeQuery();
            while (rs.next()) {
                result = rs.getInt(1);
            }
            n = result;
        }
        catch (Exception ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return n;
    }

    public long getLastFailedAttemptTime(String username) throws Exception {
        long l;
        Connection con = null;
        PreparedStatement stat = null;
        long result = 0L;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(LastFailedAttemptSQL);
            stat.setString(1, StringEncrypter.encryptString("DES", username));
            rs = stat.executeQuery();
            while (rs.next()) {
                result = rs.getLong(1);
            }
            l = result;
        }
        catch (Exception ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return l;
    }

    public ArrayList<Long> getFailedAttempts(String username) throws Exception {
        ArrayList<Long> arrayList;
        Connection con = null;
        PreparedStatement stat = null;
        ArrayList<Long> result = new ArrayList<Long>();
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(GetAllFailedAttemptsSQL);
            stat.setString(1, StringEncrypter.encryptString("DES", username));
            rs = stat.executeQuery();
            while (rs.next()) {
                result.add(rs.getLong(1));
            }
            arrayList = result;
        }
        catch (Exception ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return arrayList;
    }

    public int getUserFailedAttempts(String username) throws Exception {
        int n;
        if (this.isUserLockout(username)) {
            return _threshhold;
        }
        Connection con = null;
        PreparedStatement stat = null;
        int result = 0;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(GetUserFaliedAttempts);
            stat.setString(1, StringEncrypter.encryptString("DES", username));
            stat.setLong(2, this.getLastTimeInResetIntrvl());
            rs = stat.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
            n = result;
        }
        catch (Exception ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return n;
    }

    public boolean isUserLockout(String username) throws Exception {
        boolean result = false;
        ArrayList<Long> failedAttempts = this.getFailedAttempts(username);
        if (!_lockoutenabled || failedAttempts.isEmpty() || failedAttempts.size() < _threshhold) {
            return result;
        }
        if (_duration != -1L && failedAttempts.get(0) < System.currentTimeMillis() - _duration) {
            this.purgeFailedAttempt(username);
            return result;
        }
        if (failedAttempts.size() >= _threshhold && failedAttempts.get(0) - failedAttempts.get(_threshhold - 1) <= _resetIntrvl) {
            result = true;
        }
        return result;
    }

    public boolean isUserLockoutEnabled() {
        return _lockoutenabled;
    }

    public long getLastTimeInResetIntrvl() {
        return System.currentTimeMillis() - _resetIntrvl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] strArgs) {
        try {
            String configFile = ClientCache.getConfDir() + "server.properties";
            Properties properties = new Properties();
            GenUtil.loadConfiguration(configFile, properties);
            System.out.println("Server configuration file loaded: " + configFile);
            System.getProperties().putAll((Map<?, ?>)properties);
            System.setProperty("log.dir", ClientCache.getInstallLocation() + File.separator + "logs");
            String logConfFile = System.getProperty("org.apache.log4j.file");
            if (logConfFile == null || logConfFile.length() == 0) {
                logConfFile = ClientCache.getConfDir() + "log4j_fms.xml";
            }
            DOMConfigurator.configure((String)logConfFile);
            System.out.println("Log4j loaded: " + logConfFile);
            if (strArgs.length == 1) {
                String userName = strArgs[0];
                System.out.println("Processing unlocking user: [" + userName + "]");
                boolean isUserExist = DCNMUserImpl.isLocalUserExist(userName);
                if (!isUserExist) {
                    System.out.println("Unkown local User: [" + userName + "]");
                } else if (FMUserFailedAttempts.getInstance().getFailedAttemptsCount(userName) == 0) {
                    System.out.println("No failed attempts count found for user: [" + userName + "]");
                } else {
                    FMUserFailedAttempts.getInstance().purgeFailedAttempt(strArgs[0].trim());
                    System.out.println("Reset the failed attempts for the user: [" + userName + "]");
                }
            } else {
                System.out.println("Usage: \nadminUnlock(.bat|.sh) <username for locked user> \n");
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        finally {
            System.exit(0);
        }
    }

    static {
        _duration = _duration > 0L ? _duration * 60000L : -1L;
    }
}

