/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.security;

import com.cisco.dcbu.sm.server.security.DCNMUserImpl;
import com.cisco.dcbu.sm.server.security.FMUser;
import com.cisco.dcbu.sm.server.security.FMUserFailedAttempts;
import com.cisco.dcbu.sm.server.security.ServerAuthenticatorIf;

public class LocalAuthenticator
implements ServerAuthenticatorIf {
    @Override
    public String getName() {
        return "local";
    }

    @Override
    public FMUser authenticate(String userName, String authPassword) throws Exception {
        boolean isUserLockOut = false;
        FMUser fmUser = null;
        isUserLockOut = FMUserFailedAttempts.getInstance().isUserLockout(userName);
        if (isUserLockOut) {
            throw new Exception("too many failed attemtps before, user is already locked out");
        }
        fmUser = DCNMUserImpl.verifyUserInfo(userName, authPassword);
        if (FMUserFailedAttempts.getInstance().isUserLockoutEnabled()) {
            if (fmUser == null) {
                if (!isUserLockOut) {
                    FMUserFailedAttempts.getInstance().InsertFailedAttempt(userName, System.currentTimeMillis());
                }
            } else {
                FMUserFailedAttempts.getInstance().purgeFailedAttempt(userName);
            }
        }
        return fmUser;
    }
}

