/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.security;

import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.sm.common.security.RoleType;
import com.cisco.dcbu.sm.server.security.FMUser;
import com.cisco.dcbu.sm.server.security.ServerAuthenticatorIf;
import com.cisco.dcbu.sm.server.security.UMUtil;
import com.cisco.dcbu.sm.server.security.UserFabricImpl;
import com.theorem.tacacs.AVPair;
import com.theorem.tacacs.AttributeList;
import com.theorem.tacacs.AuthenticationPacket;
import com.theorem.tacacs.AuthorizationPacket;
import com.theorem.tacacs.Packet;
import com.theorem.tacacs.TACACSClient;
import com.theorem.tacacs.TACACSSession;
import com.theorem.tacacs.util.Util;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class TACACSAuthenticator
implements ServerAuthenticatorIf {
    public static Logger _Logger = LogManager.getLogger((String)"fms.security");
    private static final int DEFAULT_PORT = 49;
    private static final int AUTH_PASS = 1;
    private static final int AUTH_FAIL = 0;
    private static final int AUTH_PROTOCAL_ERROR = -1;
    private String _server = null;
    private String _secret = null;
    private String _port = null;
    private String _method = null;

    @Override
    public String getName() {
        return "tacacs";
    }

    @Override
    public FMUser authenticate(String userName, String authPassword) throws Exception {
        FMUser fmUser = null;
        ArrayList<String> roles = new ArrayList<String>();
        try {
            String[] depth = new String[]{".server.primary", ".server.secondary", ".server.tertiary"};
            for (int i = 0; i < depth.length; ++i) {
                int res = -1;
                this._server = System.getProperty("aaa" + depth[i] + ".name").trim();
                this._secret = System.getProperty("aaa" + depth[i] + ".secret").trim();
                if (this._secret.startsWith("#")) {
                    try {
                        this._secret = StringEncrypter.DESedeDecrypt(this._secret.substring(1));
                    }
                    catch (Exception ex) {
                        _Logger.error((Object)("TACACSAuthenticator can not decryt secret: " + this._secret));
                        break;
                    }
                }
                this._port = System.getProperty("tacacs" + depth[i] + ".port").trim();
                this._method = System.getProperty("aaa" + depth[i] + ".auth-method").trim();
                if (this._server == null || this._server.trim().length() == 0) continue;
                try {
                    _Logger.log((Priority)Level.INFO, (Object)("aaa" + depth[i] + " = " + this._server + ", Port = " + this._port + ", method = " + this._method));
                    res = this.go(userName, StringEncrypter.DESedeDecrypt(authPassword), roles);
                }
                catch (Exception ex) {
                    _Logger.log((Priority)Level.WARN, (Object)(userName + " authentication is failed on   " + this._server), (Throwable)ex);
                    res = -1;
                }
                if (res == 1) {
                    _Logger.log((Priority)Level.INFO, (Object)("Authenticating " + userName + " on  " + this._server + " is succeeded."));
                    if (roles.isEmpty()) {
                        roles.add(RoleType.ROLE_OPER.value());
                    }
                    fmUser = new FMUser(userName + "@TACACS", authPassword, roles);
                    fmUser.setSnmpUsers(UserFabricImpl.loadFromDB(fmUser.getUserName()));
                    return fmUser;
                }
                if (res == 0) {
                    _Logger.log((Priority)Level.INFO, (Object)("Authenticating " + userName + " on  " + this._server + " is failed."));
                    return null;
                }
                _Logger.log((Priority)Level.INFO, (Object)(userName + " can not communicate with  " + this._server));
            }
        }
        catch (Exception ex) {
            _Logger.log((Priority)Level.INFO, (Object)ex.getMessage());
        }
        throw new Exception("TACACS server is not validating user normally");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int go(String userName, String authPassword, List<String> roles) throws Exception {
        int result;
        block25: {
            TACACSClient tc;
            block26: {
                result = -1;
                String localAddress = InetAddress.getLocalHost().getHostAddress();
                TACACSSession session = null;
                tc = null;
                InetAddress tacacsServer = InetAddress.getByName(this._server);
                int port = 49;
                try {
                    port = Integer.parseInt(this._port);
                }
                catch (NumberFormatException nfe) {
                    _Logger.log((Priority)Level.TRACE, (Object)"TACACS port specification is wrong. Defaulting to port 49");
                    port = 49;
                }
                try {
                    tc = new TACACSClient(tacacsServer, port, this._secret);
                    tc.enableMultipleSessions(false);
                    session = this.createSession(tc, userName, localAddress);
                    tc.setDebug(false);
                    int type = 1;
                    int service = 1;
                    int request = 1;
                    Packet replyPacket = null;
                    byte[] arapChallenge = null;
                    byte[] password = null;
                    if (this._method.trim().equalsIgnoreCase("ascii")) {
                        type = 1;
                        session.setAuthenType(type);
                        session.setService(service);
                        password = Util.toASCII((String)authPassword);
                    }
                    if (this._method.trim().equalsIgnoreCase("pap")) {
                        type = 2;
                        session.setAuthenType(type);
                        session.setService(service);
                        password = Util.toASCII((String)authPassword);
                    }
                    if (this._method.trim().equalsIgnoreCase("chap")) {
                        type = 3;
                        session.setAuthenType(type);
                        session.setService(service);
                        password = AuthenticationPacket.createChap((String)authPassword);
                    }
                    if (this._method.trim().equalsIgnoreCase("mschap")) {
                        type = 5;
                        session.setAuthenType(type);
                        session.setService(service);
                        password = new AuthenticationPacket().createMSCHAP(Util.toASCII((String)authPassword));
                    }
                    if (this._method.trim().equalsIgnoreCase("arap")) {
                        type = 4;
                        session.setAuthenType(type);
                        session.setService(service);
                        AuthenticationPacket ap1 = new AuthenticationPacket();
                        password = ap1.createARAP(Util.toASCII((String)authPassword));
                        arapChallenge = ap1.getARAPChallenge();
                        tc.reset();
                    }
                    this.setAttr(tc, session);
                    replyPacket = tc.authentication(request, session, password);
                    if (replyPacket instanceof AuthenticationPacket) {
                        AuthenticationPacket ap = (AuthenticationPacket)replyPacket;
                        _Logger.log((Priority)Level.TRACE, (Object)("TACACSReply: Got the session " + session));
                        _Logger.log((Priority)Level.TRACE, (Object)("Server display message: " + ap.getServerMessage()));
                        _Logger.log((Priority)Level.TRACE, (Object)("Status is " + ap.getStatus()));
                        _Logger.log((Priority)Level.TRACE, (Object)("Data is " + Util.toASCII((byte[])ap.getData())));
                        int status = ap.getStatus();
                        switch (status) {
                            case 3: {
                                _Logger.log((Priority)Level.TRACE, (Object)("Server wants data: " + ap.getUserMessage()));
                                result = -1;
                                break;
                            }
                            case 1: {
                                _Logger.log((Priority)Level.TRACE, (Object)"Auth Passed");
                                result = 1;
                                break;
                            }
                            case 2: {
                                _Logger.log((Priority)Level.TRACE, (Object)"Authentication Failed.");
                                result = 0;
                                break;
                            }
                            case 4: {
                                _Logger.log((Priority)Level.TRACE, (Object)("Wants user: " + ap.getServerMessage()));
                                result = -1;
                                break;
                            }
                            case 5: {
                                _Logger.log((Priority)Level.TRACE, (Object)("Wants pass: " + ap.getServerMessage()));
                                Packet authenPacket = tc.authenticationContinue(1, session, 0, authPassword.getBytes(), null);
                                if (authenPacket instanceof AuthenticationPacket && (status = ((AuthenticationPacket)authenPacket).getStatus()) == 1) {
                                    result = 1;
                                    break;
                                }
                                result = 0;
                                break;
                            }
                            case 6: {
                                _Logger.log((Priority)Level.TRACE, (Object)"Restart requested.");
                                result = -1;
                                break;
                            }
                            default: {
                                _Logger.log((Priority)Level.TRACE, (Object)("Unknown status: " + status));
                                result = -1;
                            }
                        }
                        if (!ap.getServerMessage().equals("")) {
                            _Logger.log((Priority)Level.TRACE, (Object)("Server message: " + ap.getServerMessage()));
                        }
                    }
                    if (result == 1) {
                        session.setService(1);
                        this.setAttr(tc, session);
                        AuthorizationPacket auth = (AuthorizationPacket)tc.authorization(1, session);
                        _Logger.log((Priority)Level.TRACE, (Object)("Fetching role : " + auth.getStatus() + ":" + auth.getStatusName(auth.getStatus())));
                        if (roles != null) {
                            AttributeList list = auth.getResponseAttributes();
                            Iterator iter = list.iterator();
                            AVPair cisco = null;
                            while (iter.hasNext()) {
                                cisco = (AVPair)iter.next();
                                if (!cisco.getName().trim().startsWith("cisco-av-pair")) continue;
                                roles.addAll(UMUtil.getRoleNameFromCiscoAVPair(cisco.toString()));
                                if (roles.size() <= 0) continue;
                            }
                        }
                    }
                    if (tc == null) break block25;
                    if (session == null) break block26;
                }
                catch (Throwable throwable) {
                    if (tc != null) {
                        if (session != null) {
                            tc.removeSession(session);
                        }
                        tc.close();
                    }
                    throw throwable;
                }
                tc.removeSession(session);
            }
            tc.close();
        }
        return result;
    }

    private TACACSSession createSession(TACACSClient tc, String user, String client) throws Exception {
        TACACSSession session = tc.createSession(null);
        session.setName(user);
        session.setPort(this._port);
        session.setRemoteAddress(client);
        session.setPrivLevel(1);
        return session;
    }

    private void setAttr(TACACSClient tc, TACACSSession session) throws Exception {
        AttributeList autha = new AttributeList();
        autha.add("service=shell");
        autha.add("protocol=ip");
        autha.add(new AVPair("cmd", "=", ""));
        autha.add(new AVPair("cisco-av-pair", "*", " "));
        autha.add(new AVPair("shell:roles", "*", " "));
        session.setRequestAttributes(autha);
        tc.reset();
    }
}

