/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.security;

import com.cisco.dcbu.sm.common.model.FMUserBase;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.server.security.DCNMUserImpl;
import com.cisco.dcbu.sm.server.security.FMUser;
import com.cisco.dcbu.sm.server.security.RoleFabricImpl;
import com.cisco.dcbu.sm.server.security.RoleImpl;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class UserManager {
    public static Logger _Logger = LogManager.getLogger((String)"fms.security");
    public static final int USER_CREATED = 1;
    public static final int USER_EXIST = 0;
    public static final int USER_CREATE_ERROR = -1;
    private static volatile UserManager _Instance;
    final ConcurrentHashMap<FMUser, Integer> _users = new ConcurrentHashMap();
    private boolean _inited = false;

    private UserManager() {
    }

    public static UserManager getInstance() {
        if (_Instance == null) {
            _Instance = new UserManager();
        }
        try {
            _Instance.init();
        }
        catch (Exception ex) {
            _Logger.log((Priority)Level.WARN, (Object)"UserManager init failed", (Throwable)ex);
        }
        return _Instance;
    }

    void init() throws Exception {
        if (this._inited) {
            return;
        }
        this._inited = true;
    }

    public void reinit() throws Exception {
        if (this._inited) {
            this._users.clear();
            this._inited = false;
        }
        this.init();
    }

    public synchronized boolean deleteUser(String userName, String userInCharge) {
        boolean status = false;
        FMUser fmUser = this.findUser(userName);
        if (fmUser == null) {
            status = DCNMUserImpl.deleteUser(userName, userInCharge);
        }
        return status;
    }

    public synchronized boolean updateUser(String userName, String authPassword) {
        FMUser fmUser;
        boolean status = false;
        status = DCNMUserImpl.updateUser(userName, authPassword);
        if (status && (fmUser = this.findUser(userName)) != null) {
            fmUser.setHashedPwd(authPassword);
        }
        return status;
    }

    public void addUser(FMUser user) {
        if (user == null) {
            return;
        }
        Integer count = this._users.get(user);
        if (count == null) {
            this._users.put(user, 1);
        }
    }

    public void removeUser(FMUser user) {
        if (user == null) {
            return;
        }
        Integer count = this._users.get(user);
        if (count != null) {
            if (count == 1) {
                this._users.remove(user);
            } else {
                this._users.put(user, count - 1);
            }
        }
    }

    public void removeUser(String userName) {
        if (userName == null) {
            return;
        }
        Iterator it = this._users.keySet().iterator();
        FMUser tmpUser = null;
        while (it.hasNext() && !(tmpUser = (FMUser)it.next()).getUserName().equals(userName)) {
        }
        this.removeUser(tmpUser);
    }

    public FMUser[] getUsers() {
        return this._users.keySet().toArray(new FMUser[this._users.size()]);
    }

    public FMUser findUser(String userName, String password) {
        for (FMUser user : this._users.keySet()) {
            if (user == null || !userName.equals(user.getUserName()) || !password.equals(user.getHashedPwd())) continue;
            return user;
        }
        return null;
    }

    public FMUser findUser(String userName) {
        for (FMUser user : this._users.keySet()) {
            if (user == null || !user.getUserName().startsWith(userName) && !user.getUserName().equalsIgnoreCase(userName)) continue;
            return user;
        }
        return null;
    }

    public static int createUserInDB(String userName, String authPassword, String roleName) {
        return UserManager.createUserInDB(userName, authPassword, roleName, null);
    }

    public static int createUserInDB(String userName, String authPassword, String roleName, String userInCharge) {
        return DCNMUserImpl.insertUser(userName, authPassword, roleName, userInCharge);
    }

    public static FMUserBase findUserFromDB(String userName) throws SQLException {
        return DCNMUserImpl.getFMUserBase(userName);
    }

    public static FMUserBase findUserFromDB(String userName, String auth_password) throws SQLException {
        return DCNMUserImpl.getFMUserBase(userName, auth_password);
    }

    public static ArrayList<FabricPK> getFabricsFromRole(String roleName) {
        return RoleFabricImpl.getAllFabrics(roleName);
    }

    public static ArrayList<String> getAllRoles() throws SQLException {
        return RoleImpl.getAllRoles();
    }

    public static boolean deleteRole(String roleName) {
        return RoleImpl.deleteRole(roleName);
    }

    public static boolean addRole(String roleName) throws SQLException {
        return RoleImpl.insertRole(roleName);
    }

    public static boolean addFabricToRole(String roleName, long fid) {
        return RoleFabricImpl.addFabricToRole(roleName, fid);
    }

    public static boolean addFabricsToRole(String roleName, ArrayList<Long> fids) {
        return RoleFabricImpl.addMultiFabricsToRole(roleName, fids);
    }

    public static boolean updateRoleForUser(String role, String name) {
        return DCNMUserImpl.updateRoleForUser(role, name);
    }

    public static ArrayList getAllDBUsers() {
        return DCNMUserImpl.getAllUsers();
    }
}

