/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.smisjob;

import com.cisco.dcbu.sm.common.rif.SchedulerRif;
import com.cisco.dcbu.sm.server.smisjob.JobManagementMBean;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;

@DependsOn(value={"user:service=QuartzService,name=QuartzService"})
@Singleton
@Startup
public class JobManagement
implements Serializable,
JobManagementMBean {
    private SchedulerRif schedulerBean;
    private MBeanServer platformMBeanServer;
    private ObjectName objectName = null;
    static Logger _Logger = Logger.getLogger((String)"fmserver");
    public static final int SCHEDULE_SUCCESS = 0;
    public static final int SCHEDULE_DUPLICATE_NAME = -1;
    public static final int SCHEDULE_UNDEFINED_JOB_TYPE = -2;
    public static final int SMIS_JOB_TYPE = 10;
    public static final String SMIS_JOB_GROUP_NAME = "SMIS_GROUP";
    public static final String SMIS_JOB_NAME = "SMIS_JOB";

    @EJB
    public void setSchedulerBean(SchedulerRif schedulerBean) {
        this.schedulerBean = schedulerBean;
    }

    @Override
    public void create() throws Exception {
    }

    @Override
    @PostConstruct
    public void start() throws Exception {
        JobDetail job = null;
        this.registerInJMX();
        try {
            job = this.schedulerBean.getJobDetail(SMIS_JOB_NAME, SMIS_JOB_GROUP_NAME);
        }
        catch (SchedulerException e) {
            _Logger.warn((Object)("Failed to get information about SMIS job management job. Error: " + e.getMessage()));
        }
        catch (Exception e) {
            _Logger.warn((Object)("Failed to get information about SMIS job management job. Error: " + e.getMessage()));
            throw e;
        }
        if (job != null) {
            try {
                if (this.schedulerBean.deleteJob(SMIS_JOB_NAME, SMIS_JOB_GROUP_NAME)) {
                    _Logger.info((Object)"Sucessfully deleted existing SMIS job management job.");
                } else {
                    _Logger.warn((Object)"Failed to delete existing SMIS job management job.");
                }
            }
            catch (SchedulerException e) {
                _Logger.warn((Object)("Failed to delete existing SMIS job management job. Error: " + e.getMessage()));
            }
            catch (Exception e) {
                _Logger.warn((Object)("Failed to delete existing SMIS job management job. Error: " + e.getMessage()));
                throw e;
            }
        }
        Date startDate = new Date();
        JobDataMap jobStatesMap = new JobDataMap();
        jobStatesMap.put("UserName", SMIS_JOB_GROUP_NAME);
        String cornExpression = "0 0 12 * * ?";
        try {
            int scheduleResultCode = this.schedulerBean.scheduleJob(cornExpression, 10, SMIS_JOB_NAME, jobStatesMap, startDate, true);
            if (scheduleResultCode != 0) {
                switch (scheduleResultCode) {
                    case -1: {
                        _Logger.warn((Object)"Failed to scheduled SMIS job management job. Error: Duplicate job name");
                        break;
                    }
                    case -2: {
                        _Logger.warn((Object)"Failed to scheduled SMIS job management job. Error: Invalid job type");
                        break;
                    }
                    default: {
                        _Logger.warn((Object)"Failed to scheduled SMIS job management job. Error: Job scheduling failed");
                        break;
                    }
                }
            } else {
                _Logger.info((Object)"Sucessfully scheduled SMIS job management job.");
            }
        }
        catch (SchedulerException e) {
            _Logger.warn((Object)("Failed to scheduled SMIS job management job. Error: " + e.getMessage()));
        }
        catch (Exception e) {
            _Logger.warn((Object)("Failed to scheduled SMIS job management job. Error: " + e.getMessage()));
        }
    }

    @Override
    @PreDestroy
    public void stop() {
        this.unregisterFromJMX();
    }

    @Override
    public void destroy() {
    }

    public void registerInJMX() {
        try {
            _Logger.warn((Object)"********* Registering dcm:service=JobManagementMBean");
            this.objectName = new ObjectName("dcm:service=JobManagementMBean");
            this.platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            this.platformMBeanServer.registerMBean(this, this.objectName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem during registration of Monitoring into JMX:" + e);
        }
    }

    public void unregisterFromJMX() {
        try {
            this.platformMBeanServer.unregisterMBean(this.objectName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem during unregistration of Monitoring into JMX:" + e);
        }
    }
}

