/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.test;

import com.cisco.dcbu.lib.util.MDSProxy;
import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.sm.server.security.FMUser;
import com.cisco.dcbu.sm.server.security.LDAPAuthenticator;
import com.cisco.dcbu.sm.server.security.UMUtil;
import com.theorem.tacacs.AVPair;
import com.theorem.tacacs.AttributeList;
import com.theorem.tacacs.AuthenticationPacket;
import com.theorem.tacacs.AuthorizationPacket;
import com.theorem.tacacs.TACACSClient;
import com.theorem.tacacs.TACACSSession;
import com.theorem.tacacs.util.Util;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.List;
import net.jradius.client.RadiusClient;
import net.jradius.client.auth.CHAPAuthenticator;
import net.jradius.client.auth.MSCHAPv1Authenticator;
import net.jradius.client.auth.MSCHAPv2Authenticator;
import net.jradius.client.auth.PAPAuthenticator;
import net.jradius.client.auth.RadiusAuthenticator;
import net.jradius.dictionary.Attr_NASPort;
import net.jradius.dictionary.Attr_UserName;
import net.jradius.dictionary.Attr_UserPassword;
import net.jradius.packet.AccessAccept;
import net.jradius.packet.AccessRequest;
import net.jradius.packet.RadiusResponse;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.packet.attribute.RadiusAttribute;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class AuthTest {
    public static Logger _Logger = LogManager.getLogger((String)"fms.security");
    public static final String PAP = "PAP";
    public static final String[] methods = new String[]{"ASCII", "CHAP", "MSCHAP", "PAP"};
    static final String CHAP = "CHAP";
    static final String MSCHAP = "MSCHAP";
    static final String MSCHAPV1 = "MSCHAPV1";
    static final String MSCHAPV2 = "MSCHAPV2";
    static final String ASCII = "ASCII";
    static final String RADIUS = "Radius";
    static final String TACACS = "Tacacs";
    private static final int SOCK_TIME_OUT = 10000;
    private static final int NUM_RETRIES = 1;
    private String host;
    private String secret;
    private String method;
    private String user;
    private String password;
    private String ciscoAVPair;
    private int authPort = 1812;
    private int acctPort = 1813;
    private int tacPort = 49;
    private int port = 389;
    private boolean sslEnable = false;
    private String baseDN;
    private String filter;
    private String roleAttr;
    private String roleGrp;
    private String fmGrp;
    private List<String> roles;

    public void setRadiusInfo(String host, String secret, int authPort, int acctPort, String method) {
        this.setHost(host);
        this.setSecret(secret);
        this.setAuthPort(authPort);
        this.setAcctPort(acctPort);
        this.setMethod(method);
    }

    public void setLdapInfo(String host, int port, boolean enable, String baseDN, String filter, String roleAttr, String roleGrp, String fmGrp) {
        this.host = host;
        this.port = port;
        this.sslEnable = enable;
        this.baseDN = baseDN;
        this.filter = filter;
        this.roleAttr = roleAttr;
        this.roleGrp = roleGrp;
        this.fmGrp = fmGrp;
    }

    public void setTacacsInfo(String host, String secret, int port, String method) {
        this.setHost(host);
        this.setSecret(secret);
        this.setTacPort(port);
        this.setMethod(method);
    }

    public void setUserInfo(String user, String password) {
        this.user = user;
        this.password = password;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setAuthPort(int authPort) {
        this.authPort = authPort;
    }

    public void setAcctPort(int acctPort) {
        this.acctPort = acctPort;
    }

    public void setTacPort(int port) {
        this.tacPort = port;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void doRadiusAuthentication() throws Exception {
        this.doRadiusAuthentication(false, 10000, 1);
    }

    public void doRadiusAuthentication(boolean moreinfo) throws Exception {
        this.doRadiusAuthentication(moreinfo, 10000, 1);
    }

    public void doRadiusAuthentication(boolean moreinfo, int socktimeout, int retries) throws Exception {
        AttributeFactory.loadAttributeDictionary((String)"net.jradius.dictionary.AttributeDictionaryImpl");
        InetAddress addr = InetAddress.getByName(this.host);
        RadiusClient rc = new RadiusClient(addr, this.secret, this.authPort, this.acctPort, socktimeout);
        net.jradius.packet.attribute.AttributeList attributeList = new net.jradius.packet.attribute.AttributeList();
        _Logger.log((Priority)Level.INFO, (Object)("AuthTest: doRadiusAuthentication, host=" + this.host + ", user=" + this.user + ", sharedSecret=" + this.secret + ", authPort=" + this.authPort + ", acctPort=" + this.acctPort));
        attributeList.add((RadiusAttribute)new Attr_UserName((Serializable)((Object)this.user)));
        attributeList.add((RadiusAttribute)new Attr_NASPort((Serializable)Integer.valueOf(this.authPort)));
        AccessRequest request = new AccessRequest(rc, attributeList);
        request.addAttribute((RadiusAttribute)new Attr_UserPassword((Serializable)((Object)this.password)));
        RadiusResponse reply = null;
        int i = 0;
        try {
            if (this.method.trim().equalsIgnoreCase(CHAP)) {
                _Logger.log((Priority)Level.INFO, (Object)"Radius Autentication Method is CHAP");
                reply = rc.authenticate(request, (RadiusAuthenticator)new CHAPAuthenticator(), retries);
            } else if (this.method.equalsIgnoreCase(PAP)) {
                _Logger.log((Priority)Level.INFO, (Object)"Radius Autentication Method is PAP");
                reply = rc.authenticate(request, (RadiusAuthenticator)new PAPAuthenticator(), retries);
            } else if (this.method.equalsIgnoreCase(MSCHAPV1)) {
                _Logger.log((Priority)Level.INFO, (Object)"Radius Autentication Method is MSCHAPV1");
                reply = rc.authenticate(request, (RadiusAuthenticator)new MSCHAPv1Authenticator(), retries);
            } else if (this.method.equalsIgnoreCase(MSCHAPV2)) {
                _Logger.log((Priority)Level.INFO, (Object)"Radius Autentication Method is MSCHAPV2");
                reply = rc.authenticate(request, (RadiusAuthenticator)new MSCHAPv2Authenticator(), retries);
            }
        }
        catch (Exception ex) {
            _Logger.log((Priority)Level.WARN, (Object)("Radius authentication (method " + this.method + ") exception: " + ex.getMessage()));
        }
        if (reply == null) {
            _Logger.log((Priority)Level.INFO, (Object)"Radius Authentication Reply is null.");
            throw new Exception("Authentication failed due to time-out");
        }
        if (reply instanceof AccessAccept) {
            _Logger.log((Priority)Level.INFO, (Object)("Radius Authentication Reply is AccessAccept: " + reply.toString()));
            if (moreinfo && reply != null && reply.getAttributes() != null) {
                List attributes = reply.getAttributes().getAttributeList();
                RadiusAttribute tempRa = null;
                int j = 0;
                while (i < attributes.size()) {
                    tempRa = (RadiusAttribute)attributes.get(j);
                    if (tempRa.getType() == 26L && tempRa.getAttributeName().equalsIgnoreCase("Cisco-AVPair") && tempRa.getValue() != null) {
                        String str;
                        this.ciscoAVPair = str = new String(tempRa.getValue().toString()).trim();
                        break;
                    }
                    ++j;
                }
            }
        } else {
            _Logger.log((Priority)Level.INFO, (Object)("Radius Authentication Reply is AccessReject: " + reply.toString()));
            throw new Exception("Username/Password/Secret rejected.");
        }
    }

    public void doLdapAthentication() throws Exception {
        System.setProperty("ldap.provider.host", this.host);
        System.setProperty("ldap.provider.port", "" + this.port);
        System.setProperty("ldap.ssl.enable", "" + this.sslEnable);
        System.setProperty("ldap.baseDN", this.baseDN);
        System.setProperty("ldap.filter", this.filter);
        System.setProperty("ldap.role.attribute", this.roleAttr);
        System.setProperty("ldap.role.admingroup", this.roleGrp);
        System.setProperty("ldap.fmgrp", this.fmGrp);
        LDAPAuthenticator ldap = new LDAPAuthenticator();
        FMUser fmUser = ldap.authenticate(this.user, StringEncrypter.DESedeEncrypt(this.password));
        this.roles = fmUser.getRoles();
    }

    public void doTacacsAthentication() throws Exception {
        this.doTacacsAthentication(false);
    }

    public void doTacacsAthentication(boolean moreinfo) throws Exception {
        byte[] passwd;
        AuthenticationPacket reply;
        InetAddress address = InetAddress.getByName(this.host);
        System.err.println("host: " + address.toString());
        System.err.println("ip address: " + address);
        _Logger.log((Priority)Level.INFO, (Object)("AuthTest: doTacacsAthentication, User=" + this.user + ", host=" + address.toString()));
        TACACSClient client = new TACACSClient(address, 49, this.secret, 5000);
        TACACSSession session = client.createSession(null);
        session.setName(this.user);
        session.setRemoteAddress(address.toString());
        int status = -1;
        int service = 1;
        if (this.method.trim().equalsIgnoreCase(ASCII)) {
            session.setAuthenType(1);
            session.setService(service);
            reply = (AuthenticationPacket)client.authentication(1, session, null);
            status = reply.getStatus();
            if (status == 5) {
                AuthenticationPacket response = (AuthenticationPacket)client.authenticationContinue(1, session, 0, this.password.getBytes(), null);
                status = response.getStatus();
            }
        } else if (this.method.trim().equalsIgnoreCase(CHAP)) {
            session.setAuthenType(3);
            session.setService(service);
            passwd = AuthenticationPacket.createChap((String)this.password);
            reply = (AuthenticationPacket)client.authentication(1, session, passwd);
            status = reply.getStatus();
        } else if (this.method.trim().equalsIgnoreCase(PAP)) {
            session.setAuthenType(2);
            session.setService(service);
            reply = (AuthenticationPacket)client.authentication(1, session, Util.toASCII((String)this.password));
            status = reply.getStatus();
        } else if (this.method.trim().equalsIgnoreCase(MSCHAP)) {
            session.setAuthenType(5);
            session.setService(service);
            AuthenticationPacket ap = new AuthenticationPacket();
            passwd = ap.createMSCHAP(Util.toASCII((String)this.password));
            reply = (AuthenticationPacket)client.authentication(1, session, passwd);
            status = reply.getStatus();
        } else {
            throw new Exception("Invalid authentication method");
        }
        if (status == 1) {
            if (moreinfo) {
                session.setService(1);
                this.setAttr(client, session);
                AuthorizationPacket auth = (AuthorizationPacket)client.authorization(1, session);
                auth.getResponseAttributes();
                AttributeList list = auth.getResponseAttributes();
                Iterator it = list.iterator();
                AVPair tmp = null;
                while (it.hasNext()) {
                    tmp = (AVPair)it.next();
                    if (!tmp.getName().trim().startsWith("cisco-av-pair")) continue;
                    this.ciscoAVPair = tmp.toString();
                    this.roles = UMUtil.getRoleNameFromCiscoAVPair(this.ciscoAVPair);
                    break;
                }
            }
        } else {
            System.err.println("TACACS+ authentication (method " + this.method + ") failed-status: " + status);
        }
        if (status != 1) {
            throw new Exception("Authentication failed.");
        }
    }

    public void verifyMDS(String host, String userName, String authPassword) throws Exception {
        switch (MDSProxy.verifyMDS(host, userName, authPassword)) {
            case 1: {
                throw new Exception("Authentication failed.");
            }
            case 0: {
                throw new Exception("Unable to connect. Please make sure telnet/ssh is enabled.");
            }
            case 3: {
                throw new Exception("Host is not an MDS.");
            }
            case 2: {
                break;
            }
            default: {
                throw new Exception("Unknown status received.");
            }
        }
    }

    public String getAVPair() {
        return this.ciscoAVPair;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    private void setAttr(TACACSClient tc, TACACSSession session) throws Exception {
        AttributeList autha = new AttributeList();
        autha.add("service=shell");
        autha.add("protocol=ip");
        autha.add(new AVPair("cmd", "=", ""));
        autha.add(new AVPair("cisco-av-pair", "*", " "));
        autha.add(new AVPair("shell:roles", "*", " "));
        session.setRequestAttributes(autha);
        tc.reset();
    }

    public static void main(String[] args) {
        AuthTest aaa = new AuthTest();
        try {
            aaa.setRadiusInfo("172.28.125.180", "qwerty", 1812, 1813, PAP);
            aaa.setUserInfo("qa-admin", "nbv_12345");
            aaa.doRadiusAuthentication(true);
            System.out.println(aaa.getAVPair());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.out.println("=========================================");
        System.exit(0);
    }
}

