/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.test;

import com.cisco.dcbu.sm.server.test.DiscoverAutomationExt;
import com.cisco.dcbu.smis.jaxws.ep.Logon;
import com.cisco.dcbu.smis.jaxws.ep.LogonServiceLocator;
import com.cisco.dcbu.smis.jaxws.ep.San;
import com.cisco.dcbu.smis.jaxws.ep.SanServiceLocator;
import com.cisco.dcbu.smis.jaxws.ep.SanServiceSoapBindingStub;
import java.io.BufferedReader;
import java.io.FileReader;
import java.net.URL;
import java.util.ArrayList;
import org.apache.axis.message.SOAPHeaderElement;

public class DiscoverAutomation {
    public static String url = null;
    public static String username = null;
    public static String password = null;
    public static String token = null;
    public static Logon logon = null;
    public static San san = null;
    public static int pass = 0;
    public static int fail = 0;
    public static int countFab = 0;
    public static String[] input = null;

    public static void main(String[] args) throws Exception {
        int i;
        input = args;
        DiscoverAutomation.getServices();
        String fileName = args[3].trim();
        ArrayList<DiscoverAutomationExt> threads = new ArrayList<DiscoverAutomationExt>();
        String fabDetails = null;
        BufferedReader bfr = new BufferedReader(new FileReader(fileName));
        while ((fabDetails = bfr.readLine()) != null) {
            if (fabDetails.trim().startsWith("#", 0) || fabDetails.trim().equals("")) continue;
            threads.add(new DiscoverAutomationExt(fabDetails.trim()));
        }
        for (i = 0; i < threads.size(); ++i) {
            DiscoverAutomationExt t = (DiscoverAutomationExt)threads.get(i);
            t.start();
        }
        for (i = 0; i < threads.size(); ++i) {
            ((Thread)threads.get(i)).join();
        }
        int deadThread = 0;
        for (int count = 0; count < threads.size(); ++count) {
            if (!((Thread)threads.get(count)).isAlive()) {
                ++deadThread;
            }
            if (deadThread != threads.size()) continue;
            System.out.println("=========================================REPORT=======================================================\n");
            System.out.println("Number of Fabrics discovered successfully : " + pass + "/" + (pass + fail));
            System.out.println("Number of Fabrics not discovered : " + fail + "/" + (pass + fail));
            System.out.println("======================================END OF REPORT====================================================\n");
        }
    }

    public static void getServices() {
        Boolean loginService = false;
        Boolean login = false;
        Boolean sanService = true;
        try {
            if (input.length == 4 || input.length == 5 || input.length == 6) {
                DiscoverAutomation.getCredentials(input[0], input[1], input[2]);
            } else {
                System.out.println("Please enter FMServerIP, FMUserName, FMPassword, Path of Fabric-info file, FM Server Port(Optional, Default value is 80)");
                System.exit(0);
            }
            if (input.length == 6) {
                loginService = DiscoverAutomation.getLoginService(Integer.parseInt(input[5]));
                login = DiscoverAutomation.getLogin();
                sanService = DiscoverAutomation.getSanService(Integer.parseInt(input[5]));
            }
            if (input.length == 4 || input.length == 5) {
                loginService = DiscoverAutomation.getLoginService(0);
                login = DiscoverAutomation.getLogin();
                sanService = DiscoverAutomation.getSanService(0);
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        if (loginService.equals(false) || login.equals(false) || sanService.equals(false)) {
            System.exit(0);
        } else {
            System.out.println("Login is successful fm server :" + input[0] + "\n");
            System.out.println("Token found for configured user in fm server :" + input[0] + "\n");
        }
    }

    public static void getCredentials(String serverIP, String userName, String pwd) {
        url = serverIP;
        username = userName;
        password = pwd;
    }

    public static Boolean getLoginService(int port) throws Exception {
        String secure = input[4];
        String loginServiceAddr = null;
        loginServiceAddr = secure.equalsIgnoreCase("true") ? "https://" + url + "/LogonWSService/LogonWS" : "http://" + url + "/LogonWSService/LogonWS";
        LogonServiceLocator logonService = new LogonServiceLocator();
        logonService.setEndpointAddress("LogonPort", loginServiceAddr);
        if (secure.equalsIgnoreCase("true")) {
            if (port != 0) {
                URL endpoint = new URL("https://" + url + ":" + port + "/LogonWSService/LogonWS");
                logon = logonService.getLogonPort(endpoint);
            } else {
                URL endpoint = new URL("https://" + url + "/LogonWSService/LogonWS");
                logon = logonService.getLogonPort(endpoint);
            }
        } else if (port != 0) {
            URL endpoint = new URL("http://" + url + ":" + port + "/LogonWSService/LogonWS");
            logon = logonService.getLogonPort(endpoint);
        } else {
            URL endpoint = new URL("http://" + url + "/LogonWSService/LogonWS");
            logon = logonService.getLogonPort(endpoint);
        }
        if (logon == null) {
            return false;
        }
        return true;
    }

    public static Boolean getLogin() throws Exception {
        if (logon != null) {
            token = logon.requestToken(username, password, 1000000000L);
            if (token == null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public static Boolean getSanService(int port) throws Exception {
        String secure = input[4];
        String sanServiceAddr = null;
        sanServiceAddr = secure.equalsIgnoreCase("true") ? (port != 0 ? "https://" + url + ":" + port + "/SanWSService/SanWS" : "https://" + url + "/SanWSService/SanWS") : (port != 0 ? "http://" + url + ":" + port + "/SanWSService/SanWS" : "http://" + url + "/SanWSService/SanWS");
        SanServiceLocator sanService = new SanServiceLocator();
        sanService.setEndpointAddress("SanPort", sanServiceAddr);
        san = sanService.getSanPort();
        if (san == null) {
            System.out.println(" san service not available");
            return false;
        }
        SOAPHeaderElement hdrElement = DiscoverAutomation.setSoapHeader(token);
        SanServiceSoapBindingStub sStub = (SanServiceSoapBindingStub)san;
        sStub.setHeader(hdrElement);
        return true;
    }

    private static SOAPHeaderElement setSoapHeader(String token) {
        String secure = input[4];
        if (secure.equalsIgnoreCase("true")) {
            SOAPHeaderElement hdrElement = new SOAPHeaderElement("https://ep.cisco.dcbu.cisco.com", "token");
            hdrElement.setPrefix("m");
            hdrElement.setMustUnderstand(false);
            hdrElement.setValue(token);
            return hdrElement;
        }
        SOAPHeaderElement hdrElement = new SOAPHeaderElement("http://ep.cisco.dcbu.cisco.com", "token");
        hdrElement.setPrefix("m");
        hdrElement.setMustUnderstand(false);
        hdrElement.setValue(token);
        return hdrElement;
    }
}

