/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.admin;

import com.cisco.dcbu.sm.server.db.ClusterMapping;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.web.client.util.LogService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public final class LogViewerHandler {
    static final int DEFAULT_LOG_TYPE = 5;
    static final int DEFAULT_LOG_ID = 15;
    static Logger _Logger = Logger.getLogger((String)"fms");
    private static Properties _Logs = null;
    private static boolean _displayDB = true;
    private static Object[] _AllKeys = null;
    private static final String ZIPPATH = "/log/fmlogs.zip";
    private static LogViewerHandler _Instance;
    private Map<String, String> _Name2SqlHash = new HashMap<String, String>();

    public static LogViewerHandler getInstance() {
        if (_Instance == null) {
            _Instance = new LogViewerHandler();
        }
        return _Instance;
    }

    LogViewerHandler() {
        this._Name2SqlHash.put("sw", " ORDER BY TIMESTAMP(EVENT.HOST_TIME) DESC");
    }

    private List<String> getClusterServers() {
        try {
            List<String> servers = ClusterMapping.getInstance().qALlIPStrings();
            return servers;
        }
        catch (Exception ex) {
            _Logger.warn((Object)ex);
            return null;
        }
    }

    private static Properties getLogs(String file) throws IOException {
        Properties logs = new Properties();
        try {
            InputStream tmp = LogViewerHandler.class.getResourceAsStream(file);
            if (tmp == null) {
                throw new FileNotFoundException("Missing resource file : " + file);
            }
            logs.load(tmp);
            tmp.close();
        }
        catch (IOException ex) {
            _Logger.error((Object)ex.getMessage());
            throw ex;
        }
        return logs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer readLog(String key, String file) {
        BufferedReader in = null;
        StringBuffer buffer = new StringBuffer();
        buffer.append("&nbsp;");
        try {
            in = new BufferedReader(new FileReader(file));
            int ch = -1;
            while ((ch = in.read()) != -1) {
                buffer.append(ch != 10 ? (char)ch + "" : "<BR/>&nbsp;");
            }
        }
        catch (IOException ex) {
            _Logger.error((Object)ex.getMessage());
            buffer.append("Logs not available for " + key + "\n");
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception ex) {
                _Logger.warn((Object)("Unable to close file. " + ex.getMessage()));
            }
        }
        return buffer;
    }

    public String getTOC() throws Exception {
        List<String> servers = this.getClusterServers();
        if (servers == null) {
            throw new Exception("Unable to retrieve server names.");
        }
        String localIP = InetAddress.getLocalHost().getHostAddress();
        StringBuilder serverDoc = new StringBuilder();
        String screen = System.getProperty("logViewerScreen", "s480");
        serverDoc.append("<logs name=\"Logs\">");
        for (int j = 0; j < servers.size(); ++j) {
            int start;
            String serverName = servers.get(j);
            String displayName = serverName = serverName.contains("0.0.0.0") ? localIP : serverName;
            if (localIP.equalsIgnoreCase(serverName)) {
                displayName = displayName + " (localhost)";
                serverName = "localhost";
            }
            String serverNode = "<server name=\"" + displayName + "\" zipPath=\"" + ZIPPATH + "\">";
            serverDoc.append(serverNode);
            for (int i = start = _displayDB ? 0 : 1; i < _AllKeys.length; ++i) {
                String name = (String)_AllKeys[i];
                int id = i + (j + 1) * 10;
                String url = "/" + screen + ".do?svr=" + serverName + "&currentScreenID=" + screen + "&dtreeId=" + id + "&logfile=" + name + "&rawText=true";
                String fileNode = "<file name=\"" + name + "\" path=\"" + url + "\" server=\"" + serverName + "\"/>";
                serverDoc.append(fileNode);
            }
            serverDoc.append("</server>");
        }
        serverDoc.append("</logs>");
        return serverDoc.toString();
    }

    public String getTOC(String svrDisplayName) throws Exception {
        List<String> servers = this.getClusterServers();
        if (servers == null) {
            throw new Exception("Unable to retrieve server names.");
        }
        String localIP = InetAddress.getLocalHost().getHostAddress();
        StringBuilder serverDoc = new StringBuilder();
        String screen = System.getProperty("logViewerScreen", "s480");
        serverDoc.append("<logs name=\"Logs\">");
        for (int j = 0; j < servers.size(); ++j) {
            int start;
            String serverName = servers.get(j);
            String displayName = serverName = serverName.contains("0.0.0.0") ? localIP : serverName;
            if (localIP.equalsIgnoreCase(serverName)) {
                serverName = svrDisplayName;
                displayName = serverName + " (localhost)";
            }
            String serverNode = "<server name=\"" + displayName + "\" zipPath=\"" + ZIPPATH + "\">";
            serverDoc.append(serverNode);
            for (int i = start = _displayDB ? 0 : 1; i < _AllKeys.length; ++i) {
                String name = (String)_AllKeys[i];
                int id = i + (j + 1) * 10;
                String url = "/" + screen + ".do?";
                url = url + (localIP.equalsIgnoreCase(serverName) ? "" : "svr=" + serverName + "&");
                url = url + "currentScreenID=" + screen + "&dtreeId=" + id + "&logfile=" + name + "&rawText=true";
                String fileNode = "<file name=\"" + name + "\" path=\"" + url + "\" server=\"" + serverName + "\"/>";
                serverDoc.append(fileNode);
            }
            serverDoc.append("</server>");
        }
        serverDoc.append("</logs>");
        return serverDoc.toString();
    }

    public String getLog(String log) throws ParseException {
        String tmp;
        String tmp1;
        String tmp2;
        String fileToShow;
        StringBuffer buffer;
        if (log != null && (buffer = this.readLog(log, fileToShow = this.decodeDate(tmp2 = (tmp1 = this.decodePattern(tmp = (String)_Logs.get(log))).replace('/', File.separatorChar)))) != null) {
            return buffer.toString();
        }
        return "";
    }

    private String decodeDate(String str) {
        String result = "";
        if (str == null) {
            return str;
        }
        int dollar = str.indexOf("{");
        if (dollar == -1) {
            return str;
        }
        int spos = dollar + 1;
        int epos = str.indexOf("}");
        if (epos == -1) {
            return str;
        }
        String start = str.substring(0, dollar);
        String end = str.substring(epos + 1);
        String token = str.substring(spos, epos);
        try {
            LogService.log(LogService._FINE, "Formatting date to : " + token);
            SimpleDateFormat format = new SimpleDateFormat(token);
            Date today = new Date();
            String day = format.format(today);
            result = start + day + end;
            LogService.log(LogService._FINE, "Result is  : " + result);
            return result;
        }
        catch (Exception ex) {
            LogService.log(LogService._SEVERE, ex);
            return str;
        }
    }

    private String decodePattern(String str) throws ParseException {
        String result = str;
        if (result == null) {
            return result;
        }
        int dollar = -1;
        while ((dollar = result.indexOf("${")) != -1) {
            int spos = dollar + 2;
            int epos = str.indexOf("}");
            if (epos == -1) {
                throw new ParseException("Invalid path : " + str, epos);
            }
            String start = str.substring(0, dollar);
            String end = str.substring(epos + 1);
            String token = str.substring(spos, epos);
            String rep = System.getProperty(token);
            if (rep == null) {
                rep = "";
            }
            LogService.log(LogService._FINE, "Replaced : ${" + token + "} with (" + rep + ")");
            result = start + rep + end;
        }
        LogService.log(LogService._FINE, "Formatted path to : " + result);
        return result;
    }

    static {
        try {
            _displayDB = ConnectionManager.getDbUrl().indexOf(ConnectionManager.interDB) != -1;
            _Logs = LogViewerHandler.getLogs("/properties/LogViewer.properties");
            _AllKeys = _Logs.keySet().toArray();
            Arrays.sort(_AllKeys);
        }
        catch (IOException ex) {
            _Logger.error((Object)("Error initializing of LogViewerHandler static properties: " + ex.getMessage()));
        }
        _Instance = null;
    }
}

