/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.cfgdelivery;

import com.cisco.dcbu.dcm.connector.ConnectorException;
import com.cisco.dcbu.dcm.model.enumkind.ConfigDeliveryTaskDeviceStatus;
import com.cisco.dcbu.dcm.model.enumkind.ConfigDeliveryTaskRollbackSetting;
import com.cisco.dcbu.sm.server.web.cfgdelivery.ConfigDeliveryHelper;
import com.cisco.dcbu.sm.server.web.cfgdelivery.ConfigDeliveryJobController;
import com.cisco.dcbu.sm.server.web.cfgdelivery.ConfigDeliveryJobResult;
import com.cisco.dcbu.sm.server.web.cfgdelivery.ConfigDeliveryResponseVerifier;
import com.cisco.dcbu.sm.server.web.cfgdelivery.ConfigJob;
import com.cisco.dcbu.sm.server.web.lan.connector.CliCommand;
import com.cisco.dcbu.sm.server.web.lan.connector.CliCommandsList;
import com.cisco.dcbu.sm.server.web.lan.connector.CliMode;
import com.cisco.dcbu.sm.server.web.lan.connector.CliResponse;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigDeliveryJob
extends ConfigJob<ConfigDeliveryJobResult>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ConfigDeliveryJob.class);
    private String ipAddress;
    private String[] cmds;
    private ConfigDeliveryTaskRollbackSetting rollback;
    private Long taskId;
    private String userId;
    private int timeoutInSeconds = 0;
    private String password;
    private String enablePwd;
    private transient CountDownLatch latch;
    private Long totalJobsCount = 0L;
    private String fileName = null;
    private boolean checkPointRollbackSupport;
    private boolean doCopyRunStart = false;
    private static final String CP_RUN_START_CMD = "copy running-config";

    public ConfigDeliveryJob(String userId, String password, String enablePwd, String ipAddress, Long taskId, String[] cmds, ConfigDeliveryTaskRollbackSetting rollback, boolean doCopyRunStart, int timeoutInSeconds) {
        this.userId = userId;
        this.ipAddress = ipAddress;
        this.password = password;
        this.enablePwd = enablePwd;
        this.cmds = cmds;
        this.rollback = rollback;
        this.taskId = taskId;
        this.doCopyRunStart = doCopyRunStart;
        this.timeoutInSeconds = timeoutInSeconds;
        this.setName(ConfigDeliveryHelper.generateThreadName(taskId, ipAddress));
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String[] getCmds() {
        return this.cmds;
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public ConfigDeliveryTaskRollbackSetting getRollback() {
        return this.rollback;
    }

    @Override
    public ConfigDeliveryJobResult call() throws Exception {
        ConfigDeliveryJobResult deliverCommands = this.deliverCommands();
        return deliverCommands;
    }

    public ConfigDeliveryJobResult deliverCommands() throws Exception {
        ConfigDeliveryJobController.INSTANCE.persistPublishConfigJobChanges(this.taskId, this.ipAddress, ConfigDeliveryTaskDeviceStatus.IN_PROGRESS, null, null, -1);
        ConfigDeliveryTaskDeviceStatus status = ConfigDeliveryTaskDeviceStatus.SUCCESS;
        CliResponse[] cmdResponses = null;
        CliResponse resp = null;
        CliCommandsList commandsList = new CliCommandsList();
        boolean useCheckpointAndRollback = (ConfigDeliveryTaskRollbackSetting.ROLLBACK_ON_ALL_DEVICES == this.rollback || ConfigDeliveryTaskRollbackSetting.ROLLBACK_ON_DEVICE_CONTINUE_DELIVERY_ON_OTHER_DEVICES == this.rollback || ConfigDeliveryTaskRollbackSetting.ROLLBACK_ON_DEVICE_STOP_DELIVERY == this.rollback) && this.checkPointRollbackSupport;
        ConfigDeliveryResponseVerifier responseVerifier = new ConfigDeliveryResponseVerifier(this);
        this.setName(this.getName());
        if (useCheckpointAndRollback && !ConfigDeliveryHelper.isUCS(this.ipAddress).booleanValue()) {
            this.fileName = "dcnm-cfg-delivery" + Math.random();
            commandsList.add(new CliCommand("checkpoint file bootflash:" + this.fileName));
        }
        ConfigDeliveryJobResult configJobResult = null;
        StringBuffer errorCause = new StringBuffer();
        HashMap<String, String> failedCommands = new HashMap<String, String>();
        ArrayList<String> copyCmds = new ArrayList<String>();
        try {
            if (!this.isCancelled()) {
                CliResponse[] responses;
                log.info((Object)(this.getName() + " Started"));
                boolean isCopyStartRunPresent = false;
                for (String string : this.cmds) {
                    if (string == null) continue;
                    if (ConfigDeliveryHelper.isCopyRunCmd(string)) {
                        isCopyStartRunPresent = true;
                        copyCmds.add(string.trim());
                        continue;
                    }
                    commandsList.add(new CliCommand(string));
                }
                boolean verifyEachCommandDeliverNext = ConfigDeliveryTaskRollbackSetting.CONTINUE_ON_ERROR != this.rollback;
                for (CliResponse cliResponse : responses = ConfigDeliveryHelper.invokeCommand(this.userId, this.password, this.enablePwd, this.ipAddress, CliMode.CONFIG_MODE, commandsList, responseVerifier, verifyEachCommandDeliverNext, this.getName(), this.timeoutInSeconds)) {
                    if (!this.isCancelled()) {
                        if (cliResponse == null || responseVerifier.verifyResponse(cliResponse)) continue;
                        failedCommands.put(((CliCommand)cliResponse.getRequest()).getCliCmd(), cliResponse.getData().toString());
                        boolean shouldBreak = false;
                        if (useCheckpointAndRollback && !ConfigDeliveryHelper.isUCS(this.ipAddress).booleanValue()) {
                            log.info((Object)(this.getName() + "Rollbacking back changes beacuse of Error in Delivering commands."));
                            this.rollbackChanges();
                            status = ConfigDeliveryTaskDeviceStatus.FAILED_ROLLBACK;
                            errorCause.append("'");
                            errorCause.append(((CliCommand)cliResponse.getRequest()).getCliCmd());
                            errorCause.append("'");
                            errorCause.append(" command failed with response ");
                            errorCause.append(cliResponse.getData().toString());
                            errorCause.append("\n");
                            shouldBreak = true;
                        } else {
                            status = ConfigDeliveryTaskDeviceStatus.FAILED;
                            errorCause.append("'");
                            errorCause.append(((CliCommand)cliResponse.getRequest()).getCliCmd());
                            errorCause.append("'");
                            errorCause.append(" command failed with response ");
                            errorCause.append(cliResponse.getData().toString());
                            errorCause.append("\n");
                        }
                        if (this.shouldCancelOtherJobs()) {
                            log.info((Object)(this.getName() + " Cancelling Other Jobs becuase of Errors in Delivering Commands"));
                            ConfigDeliveryJobController.INSTANCE.cancelJob(this.taskId);
                            break;
                        }
                        if (!shouldBreak) continue;
                        break;
                    }
                    status = ConfigDeliveryTaskDeviceStatus.CANCELED;
                    log.info((Object)(this.getName() + " Cancellation Request Received"));
                    break;
                }
                if (isCopyStartRunPresent || this.doCopyRunStart) {
                    if (ConfigDeliveryTaskDeviceStatus.SUCCESS != status) {
                        log.info((Object)("Ignoring copy run request since the delivery status is " + status));
                    } else {
                        if (copyCmds.size() == 0 && this.doCopyRunStart && !ConfigDeliveryHelper.isUCS(this.ipAddress).booleanValue()) {
                            copyCmds.add("copy running-config startup-config");
                        }
                        for (String cmd : copyCmds) {
                            resp = ConfigDeliveryHelper.invokeCopyRunToStart(this.userId, this.password, this.enablePwd, this.ipAddress, cmd, this.getName());
                            if (resp.getData() == null) continue;
                            if (resp.getData().toString().contains("No space left on device")) {
                                status = ConfigDeliveryTaskDeviceStatus.FAILED;
                                errorCause.append("'");
                                errorCause.append(resp.getData().toString());
                                errorCause.append("\n");
                                continue;
                            }
                            if (resp.getData().toString().contains("file existing with this name")) {
                                status = ConfigDeliveryTaskDeviceStatus.FAILED;
                                errorCause.append("'");
                                errorCause.append("File exists with this name. Skipping the overwrite");
                                errorCause.append("\n");
                                continue;
                            }
                            if (!resp.getData().toString().startsWith("%%%%")) continue;
                            status = ConfigDeliveryTaskDeviceStatus.FAILED;
                            errorCause.append("'");
                            errorCause.append(resp.getData().toString().substring(4));
                            errorCause.append("\n");
                        }
                    }
                }
            } else {
                status = ConfigDeliveryTaskDeviceStatus.CANCELED;
                log.info((Object)(this.getName() + " Cancellation Request Received"));
            }
        }
        catch (Throwable e) {
            log.error((Object)(this.getName() + " Config Delivery Resulted in Error"), e);
            status = ConfigDeliveryTaskDeviceStatus.FAILED;
            configJobResult = new ConfigDeliveryJobResult(cmdResponses, status, this.fileName, this.ipAddress);
            if (e instanceof ConnectorException) {
                if (e.getMessage().contains("Incorrect Password")) {
                    configJobResult.setErrorMsg("Delivery failed due to invalid credentials.");
                } else {
                    configJobResult.setErrorMsg("Delivery failed due to device connectivity or invalid credential issue.");
                }
            }
            Throwable finalE = e;
            while (finalE.getCause() != null && !finalE.getClass().getName().startsWith("com.cisco")) {
                finalE = finalE.getCause();
            }
            String errorMsg = "Delivery failed with message: " + e.getMessage();
            if (finalE != null) {
                errorMsg = finalE instanceof ConnectorException ? "Delivery failed because of device connection issues: " + finalE.getMessage() : "Delivery failed with message: " + finalE.getMessage();
            }
            configJobResult.setErrorMsg(errorMsg);
        }
        if (configJobResult == null) {
            configJobResult = new ConfigDeliveryJobResult(cmdResponses, status, this.fileName, this.ipAddress);
            if (errorCause.toString().contains("command failed with ")) {
                errorCause.delete(0, errorCause.length());
                errorCause.append("One or more commands have failed in device.");
            }
            configJobResult.setErrorMsg(errorCause.toString());
        }
        this.latch.countDown();
        log.info((Object)(this.getName() + " Completed with Status:" + status.getName()));
        double jobsRemaining = this.latch.getCount();
        Double progPercent = ((double)this.totalJobsCount.longValue() - jobsRemaining) / (double)this.totalJobsCount.longValue() * 100.0;
        ConfigDeliveryJobController.INSTANCE.persistPublishConfigJobChanges(this.taskId, configJobResult.getIpAddress(), configJobResult.getDeviceDeliveryStatus(), configJobResult.getErrorMsg(), failedCommands, progPercent.intValue());
        return configJobResult;
    }

    public CountDownLatch getLatch() {
        return this.latch;
    }

    public void setLatch(CountDownLatch latch) {
        this.latch = latch;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setCmds(String[] cmds) {
        this.cmds = cmds;
    }

    public void setRollback(ConfigDeliveryTaskRollbackSetting rollback) {
        this.rollback = rollback;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public CliResponse[] rollbackChanges() {
        CliCommandsList cliCommandsList = new CliCommandsList();
        if (this.fileName != null) {
            cliCommandsList.add(new CliCommand(MessageFormat.format("rollback running-config file bootflash:{0} verbose", this.fileName)));
            try {
                log.info((Object)(this.getName() + " Started Rolling back the Changes"));
                CliResponse[] result = ConfigDeliveryHelper.invokeCommand(this.userId, this.password, this.enablePwd, this.ipAddress, CliMode.CONFIG_MODE, cliCommandsList, null, false, this.getName(), this.timeoutInSeconds);
                log.info((Object)(this.getName() + " Completed Rollback"));
                return result;
            }
            catch (Throwable e) {
                log.error((Object)(this.getName() + " Rollback Resulted in Error"), e);
            }
        }
        return null;
    }

    public Long getTotalJobsCount() {
        return this.totalJobsCount;
    }

    public void setTotalJobsCount(Long totalJobsCount) {
        this.totalJobsCount = totalJobsCount;
    }

    public boolean isCheckPointRollbackSupport() {
        return this.checkPointRollbackSupport;
    }

    public void setCheckPointRollbackSupport(boolean checkPointRollbackSupport) {
        this.checkPointRollbackSupport = checkPointRollbackSupport;
    }

    public boolean shouldCancelOtherJobs() {
        return ConfigDeliveryTaskRollbackSetting.STOP_DELIVERY_ON_ALL_DEVICES_ON_ERROR == this.rollback || ConfigDeliveryTaskRollbackSetting.ROLLBACK_ON_DEVICE_STOP_DELIVERY == this.rollback;
    }
}

