/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.cfgdelivery;

import com.cisco.dcbu.dcm.cfgtemplate.parser.TemplateFileParser;
import com.cisco.dcbu.dcm.cfgtemplate.parser.model.Template;
import com.cisco.dcbu.dcm.common.Pair;
import com.cisco.dcbu.dcm.model.cfgdelivery.ConfigDeliveryTask;
import com.cisco.dcbu.dcm.model.cfgdelivery.ConfigDeliveryTaskDeviceDetails;
import com.cisco.dcbu.dcm.model.cfgdelivery.TemplateConfigDeliveryTask;
import com.cisco.dcbu.dcm.model.enumkind.ConfigDeliveryTaskDeliveryOrderSetting;
import com.cisco.dcbu.dcm.model.enumkind.ConfigDeliveryTaskDeviceStatus;
import com.cisco.dcbu.dcm.model.enumkind.ConfigDeliveryTaskRollbackSetting;
import com.cisco.dcbu.dcm.model.enumkind.ConfigDeliveryTaskStatus;
import com.cisco.dcbu.jaxws.ep.IdentityManager;
import com.cisco.dcbu.jaxws.handler.SecurityHandler;
import com.cisco.dcbu.lib.serviceconf.ServiceConfig;
import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.sm.common.event.LogEventType;
import com.cisco.dcbu.sm.common.event.Severity;
import com.cisco.dcbu.sm.common.event.SyslogEntry;
import com.cisco.dcbu.sm.server.event.EventControllerService;
import com.cisco.dcbu.sm.server.facade.FMServerImpl;
import com.cisco.dcbu.sm.server.scheduler.jobs.JobDirector;
import com.cisco.dcbu.sm.server.web.cfgdelivery.ConfigDeliveryHandler;
import com.cisco.dcbu.sm.server.web.cfgdelivery.ConfigDeliveryHelper;
import com.cisco.dcbu.sm.server.web.cfgdelivery.ConfigDeliveryJob;
import com.cisco.dcbu.sm.server.web.cfgdelivery.ConfigDeliveryJobResult;
import com.cisco.dcbu.sm.server.web.cfgdelivery.ConfigJob;
import com.cisco.dcbu.sm.server.web.lan.persister.CommonSessionPersisterFactory;
import com.cisco.dcbu.sm.server.web.lan.persister.SessionPersister;
import com.cisco.dcbu.sm.server.web.lan.persister.Transaction;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.jboss.logging.Logger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.StatefulJob;
import org.quartz.Trigger;
import org.quartz.impl.StdScheduler;
import org.quartz.impl.StdSchedulerFactory;

public class ConfigDeliveryJobController
extends TimerTask {
    protected static final Logger log = Logger.getLogger(ConfigDeliveryJobController.class);
    Map<Long, Collection<FutureWrapper>> futureCache = new HashMap<Long, Collection<FutureWrapper>>();
    private StdScheduler scheduler;
    private Timer cleanupTimer = new Timer("ClearsCompletedConfigDeliveryJobs");
    private static int THREAD_POOL_SIZE = 10;
    public static int DEFAULT_CLI_TIMEOUT = 60;
    ExecutorService es = null;
    private final String COMMON_JOB_KEY = "jobClassName";
    public static final ConfigDeliveryJobController INSTANCE = new ConfigDeliveryJobController();

    private ConfigDeliveryJobController() {
    }

    public void initialize() {
        try {
            this.scheduler = (StdScheduler)StdSchedulerFactory.getDefaultScheduler();
            if (this.scheduler.isShutdown()) {
                this.scheduler.start();
            }
            this.cleanupTimer.schedule((TimerTask)this, 1000L, 1000L);
            if (THREAD_POOL_SIZE != -1) {
                this.es = Executors.newFixedThreadPool(THREAD_POOL_SIZE);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error in initializing config delivery job controller", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        try {
            this.scheduler.shutdown();
            this.cleanupTimer.cancel();
            Map<Long, Collection<FutureWrapper>> map = this.futureCache;
            synchronized (map) {
                this.futureCache.clear();
            }
            this.es.shutdownNow();
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<Long> toBeRemovedCfgTaskId = new ArrayList<Long>();
        Map<Long, Collection<FutureWrapper>> map = this.futureCache;
        synchronized (map) {
            Set<Map.Entry<Long, Collection<FutureWrapper>>> taskIdAndItsFuturWrapperCol = this.futureCache.entrySet();
            for (Map.Entry<Long, Collection<FutureWrapper>> futureEntry : taskIdAndItsFuturWrapperCol) {
                Collection<FutureWrapper> futureWrapperCol = futureEntry.getValue();
                ArrayList<FutureWrapper> toBeRemovedFutureWrapperCol = new ArrayList<FutureWrapper>();
                for (FutureWrapper future : futureWrapperCol) {
                    if (!future.getFuture().isDone()) continue;
                    toBeRemovedFutureWrapperCol.add(future);
                }
                futureWrapperCol.removeAll(toBeRemovedFutureWrapperCol);
                if (!futureWrapperCol.isEmpty()) continue;
                toBeRemovedCfgTaskId.add(futureEntry.getKey());
            }
            for (Long string : toBeRemovedCfgTaskId) {
                this.futureCache.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Future<T> submitJob(ConfigJob<T> callable, Long taskId, String ip) {
        Future<T> future = this.es.submit(callable);
        Map<Long, Collection<FutureWrapper>> map = this.futureCache;
        synchronized (map) {
            Collection<FutureWrapper> taskCollection = this.futureCache.get(taskId);
            if (taskCollection == null) {
                taskCollection = new ArrayList<FutureWrapper>();
                this.futureCache.put(taskId, taskCollection);
            }
            taskCollection.add(new FutureWrapper(future, callable));
        }
        return future;
    }

    public void scheduleConfigDeliveryJob(ConfigDeliveryTask task) throws SchedulerException {
        SimpleTrigger st = new SimpleTrigger();
        st.setStartTime((Date)task.getScheduledTime());
        st.setRepeatCount(0);
        st.setGroup("Config Delivery Quartz Job Group");
        st.setName(task.getInstanceName() + Math.random() * 100.0);
        ConfigDeliveryQuartzJob configDeliveryQuartzJob = new ConfigDeliveryQuartzJob(task);
        configDeliveryQuartzJob.setName(task.getInstanceName());
        configDeliveryQuartzJob.setJobClass(JobDirector.class);
        JobDataMap jDataMap = configDeliveryQuartzJob.getJobDataMap();
        jDataMap.put("jobClassName", ConfigDeliveryQuartzJob.class.getName());
        this.scheduler.scheduleJob((JobDetail)configDeliveryQuartzJob, (Trigger)st);
        log.info((Object)("Config delivery job " + task.getInstanceName() + " schedule for execution at " + task.getScheduledTime()));
    }

    public void modifyConfigDeliveryJobScehdule(ConfigDeliveryTask task) throws Exception {
        this.deleteConfigDeliveryJobSchedule(task);
        this.scheduleConfigDeliveryJob(task);
    }

    public void deleteConfigDeliveryJobSchedule(ConfigDeliveryTask task) throws SchedulerException {
        if (this.scheduler.deleteJob(task.getInstanceName(), "Config Delivery Quartz Job Group")) {
            log.info((Object)("Deleted Schedule for " + task.getInstanceName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelJob(Long taskId) throws Exception {
        Map<Long, Collection<FutureWrapper>> map = this.futureCache;
        synchronized (map) {
            Collection<FutureWrapper> entrySet = this.futureCache.get(taskId);
            if (entrySet != null) {
                for (FutureWrapper futureEntry : entrySet) {
                    if (!futureEntry.getConfigJob().isCancelled() && !futureEntry.getFuture().isDone()) {
                        futureEntry.getConfigJob().setCancel(true);
                        log.info((Object)("Cancellation Request Sent Successfully to " + futureEntry.getConfigJob().getName()));
                        continue;
                    }
                    log.error((Object)(futureEntry.getConfigJob().getName() + " Either Completed or Already Cancelled"));
                }
            }
        }
    }

    public synchronized void persistPublishTaskStatusChange(Long instanceId, ConfigDeliveryTaskStatus taskStatus) throws Exception {
        SessionPersister session = CommonSessionPersisterFactory.INSTANCE.openSession();
        Transaction transaction = session.beginTransaction();
        try {
            ConfigDeliveryTask task = (ConfigDeliveryTask)session.createCriteria(ConfigDeliveryTask.class).add((Criterion)Restrictions.eq((String)"instanceClassId", (Object)instanceId)).uniqueResult();
            task.setConfigDeliveryTaskStatus(taskStatus);
            ArrayList<String> propNames = new ArrayList<String>(1);
            if (!ConfigDeliveryTaskStatus.IN_PROGRESS.equals((Object)task.getConfigDeliveryTaskStatus())) {
                task.setEndTime(new Timestamp(System.currentTimeMillis()));
                propNames.add("endTime");
            } else {
                task.setStartTime(new Timestamp(System.currentTimeMillis()));
                propNames.add("startTime");
                if (task.getScheduledTime() == null) {
                    task.setScheduledTime(task.getStartTime());
                    propNames.add("scheduledTime");
                }
                task.setProgress(Integer.valueOf(0));
                propNames.add("progress");
            }
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction != null && transaction.isActive()) {
                transaction.rollback();
            }
            throw e;
        }
        finally {
            session.close();
        }
    }

    public synchronized void persistPublishConfigJobChanges(Long instanceId, String ipAddress, ConfigDeliveryTaskDeviceStatus deviceStatus, String errorMsg, Map<String, String> failedCommands, int progress) throws Exception {
        SessionPersister session = CommonSessionPersisterFactory.INSTANCE.openSession();
        Transaction transaction = session.beginTransaction();
        try {
            ArrayList<String> propNames = new ArrayList<String>(1);
            ConfigDeliveryTaskDeviceDetails details = (ConfigDeliveryTaskDeviceDetails)session.createCriteria(ConfigDeliveryTaskDeviceDetails.class).add((Criterion)Restrictions.like((String)"instanceName", (Object)("%id=" + instanceId + "%"))).add((Criterion)Restrictions.eq((String)"ipAddress", (Object)ipAddress)).uniqueResult();
            ConfigDeliveryTask task = details.getConfigDeliveryTaskRef();
            ConfigDeliveryHandler.getInstance().readConfigCommands(task);
            ArrayList events = new ArrayList();
            details.setConfigDeliveryTaskDeviceStatus(deviceStatus);
            propNames.add("configDeliveryTaskDeviceStatus");
            if (errorMsg != null) {
                details.setFailureCause(new StringBuilder(errorMsg));
            } else {
                details.setFailureCause(new StringBuilder());
            }
            propNames.add("failureCause");
            if (failedCommands != null && failedCommands.size() > 0) {
                Set<String> cmds = failedCommands.keySet();
                for (String cmd : cmds) {
                    details.appendFailedCommandResponse(cmd, failedCommands.get(cmd));
                }
                ConfigDeliveryHandler.getInstance().updateConfigCommands(details.getConfigDeliveryTaskRef().getInstanceClassId(), details, task);
                propNames.add("failedCommands");
            }
            if (progress >= 0) {
                task.setProgress(Integer.valueOf(progress));
                propNames = new ArrayList(1);
                propNames.add("progress");
            }
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction != null && transaction.isActive()) {
                transaction.rollback();
            }
            throw e;
        }
        finally {
            session.close();
        }
    }

    void executeDeliveryJobs(ConfigDeliveryTask task) {
        ConfigDeliveryJobOrganiser callable = new ConfigDeliveryJobOrganiser(task);
        this.submitJob(callable, task.getInstanceClassId(), null);
    }

    private class FutureWrapper {
        private ConfigJob<?> callable;
        private Future<?> future;

        private FutureWrapper(Future<?> future, ConfigJob<?> callable) {
            this.future = future;
            this.callable = callable;
        }

        public ConfigJob<?> getConfigJob() {
            return this.callable;
        }

        public Future<?> getFuture() {
            return this.future;
        }
    }

    public static class ConfigDeliveryQuartzJob
    extends JobDetail
    implements StatefulJob,
    Serializable {
        private static final String CONFIG_DELIVERY_QUARTZ_JOB_GROUP = "Config Delivery Quartz Job Group";
        private static final long serialVersionUID = 1L;
        private static final String jobIDKey = "TaskInstClsID";

        public ConfigDeliveryQuartzJob() {
        }

        public ConfigDeliveryQuartzJob(ConfigDeliveryTask task) {
            JobDataMap jobDataMap = this.getJobDataMap();
            jobDataMap.put((Object)jobIDKey, (Object)task.getInstanceClassId());
            this.setGroup(CONFIG_DELIVERY_QUARTZ_JOB_GROUP);
        }

        public void execute(JobExecutionContext arg0) throws JobExecutionException {
            log.info((Object)"Config delivery schedule job execution started");
            SessionPersister session = CommonSessionPersisterFactory.INSTANCE.openReadOnlySession();
            try {
                Long instanceClsId = (Long)arg0.getJobDetail().getJobDataMap().get((Object)jobIDKey);
                ConfigDeliveryTask task = (ConfigDeliveryTask)session.createCriteria(ConfigDeliveryTask.class).add((Criterion)Restrictions.eq((String)"instanceClassId", (Object)instanceClsId)).uniqueResult();
                INSTANCE.executeDeliveryJobs(task);
            }
            catch (Exception e) {
                log.error((Object)"Error when executing scheduled job", (Throwable)e);
            }
        }
    }

    private class ConfigDeliveryJobOrganiser
    extends ConfigJob<Object> {
        private ConfigDeliveryTask task;

        public ConfigDeliveryJobOrganiser(ConfigDeliveryTask task) {
            this.task = task;
            this.setName(ConfigDeliveryHelper.generateThreadName(task.getInstanceClassId(), null));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Object call() throws Exception {
            ConfigDeliveryTaskStatus status = ConfigDeliveryTaskStatus.FAILED;
            if (this.task.getTaskEnabled() == null || !this.task.getTaskEnabled().booleanValue()) {
                log.info((Object)(this.getName() + " is not Enabled"));
                return null;
            }
            String deviceNameStr = "";
            boolean isParallel = ConfigDeliveryTaskDeliveryOrderSetting.PARALLEL == this.task.getConfigDeliveryTaskDeliveryOrderSetting();
            ArrayList<ConfigDeliveryTaskDeviceDetails> cfgDeviceDetails = new ArrayList<ConfigDeliveryTaskDeviceDetails>();
            try {
                for (ConfigDeliveryTaskDeviceDetails configDeliveryTaskDeviceDetails : this.task.getConfigDeliveryTaskDeviceDetailsCol()) {
                    if (configDeliveryTaskDeviceDetails.getIpAddress() == null) continue;
                    cfgDeviceDetails.add(configDeliveryTaskDeviceDetails);
                }
                HashMap<ConfigDeliveryJob, ConfigDeliveryJobResult> configJobWithResultMap = new HashMap<ConfigDeliveryJob, ConfigDeliveryJobResult>();
                if (cfgDeviceDetails.size() == 0) {
                    log.info((Object)(this.getName() + " no devices added"));
                    return null;
                }
                ConfigDeliveryJobController.this.persistPublishTaskStatusChange(this.task.getInstanceClassId(), ConfigDeliveryTaskStatus.IN_PROGRESS);
                CountDownLatch latch = new CountDownLatch(cfgDeviceDetails.size());
                ArrayList<ConfigDeliveryJob> jobs = new ArrayList<ConfigDeliveryJob>();
                for (ConfigDeliveryTaskDeviceDetails configDeliveryTaskDeviceDetails : cfgDeviceDetails) {
                    void var10_14;
                    String string = "";
                    String enPwd = "";
                    if (this.task.getPassword() != null) {
                        String string2 = StringEncrypter.DESedeDecrypt(this.task.getPassword());
                    }
                    if (this.task.getEnablePwd() != null) {
                        enPwd = StringEncrypter.DESedeDecrypt(this.task.getEnablePwd());
                    }
                    ConfigDeliveryJob job = new ConfigDeliveryJob(this.task.getUserName(), (String)var10_14, enPwd, configDeliveryTaskDeviceDetails.getIpAddress().toString(), this.task.getInstanceClassId(), this.getConfigCommands(configDeliveryTaskDeviceDetails), this.task.getConfigDeliveryTaskRollbackSetting(), this.task.getIsCopyRunToStartTask(), this.task.getTimeout());
                    job.setCheckPointRollbackSupport(ConfigDeliveryHelper.isDeviceCheckpointRollbackCapable(configDeliveryTaskDeviceDetails.getIpAddress().toString()));
                    job.setLatch(latch);
                    job.setTotalJobsCount(Long.valueOf(cfgDeviceDetails.size()));
                    jobs.add(job);
                    if (configDeliveryTaskDeviceDetails.getIpAddress() == null) continue;
                    deviceNameStr = deviceNameStr + configDeliveryTaskDeviceDetails.getIpAddress() + " , ";
                }
                deviceNameStr = deviceNameStr.substring(0, deviceNameStr.lastIndexOf(","));
                if (this.isCancelled()) {
                    log.info((Object)(this.getName() + " Cancelling Requested"));
                }
                if (isParallel) {
                    ArrayList<FutureWrapper> parallelJobs = new ArrayList<FutureWrapper>();
                    log.info((Object)(this.getName() + " Starting Parallel Execution"));
                    for (ConfigDeliveryJob configDeliveryJob : jobs) {
                        parallelJobs.add(new FutureWrapper(ConfigDeliveryJobController.this.submitJob(configDeliveryJob, configDeliveryJob.getTaskId(), configDeliveryJob.getIpAddress()), configDeliveryJob));
                    }
                    latch.await();
                    log.info((Object)(this.getName() + " Completed Parallel Execution"));
                    for (FutureWrapper futureWrapper : parallelJobs) {
                        configJobWithResultMap.put((ConfigDeliveryJob)futureWrapper.getConfigJob(), (ConfigDeliveryJobResult)futureWrapper.getFuture().get());
                    }
                } else {
                    log.info((Object)(this.getName() + " Starting sequential execution"));
                    for (ConfigDeliveryJob job : jobs) {
                        job.setCancel(this.isCancelled());
                        configJobWithResultMap.put(job, ConfigDeliveryJobController.this.submitJob(job, job.getTaskId(), job.getIpAddress()).get());
                    }
                    log.info((Object)(this.getName() + " Completed Sequential Execution"));
                }
                if (ConfigDeliveryTaskRollbackSetting.ROLLBACK_ON_ALL_DEVICES.equals((Object)this.task.getConfigDeliveryTaskRollbackSetting())) {
                    boolean isAllDeviceRollbackRequired = false;
                    for (ConfigDeliveryJobResult configDeliveryJobResult : configJobWithResultMap.values()) {
                        if (ConfigDeliveryTaskDeviceStatus.FAILED_ROLLBACK != configDeliveryJobResult.getDeviceDeliveryStatus() && ConfigDeliveryTaskDeviceStatus.FAILED != configDeliveryJobResult.getDeviceDeliveryStatus()) continue;
                        log.info((Object)(this.getName() + " Config Delivery for One of the Devices Failed--" + configDeliveryJobResult.getIpAddress()));
                        isAllDeviceRollbackRequired = true;
                        break;
                    }
                    if (isAllDeviceRollbackRequired) {
                        log.info((Object)(this.getName() + " Rolling Back Changes for Other Completed Jobs"));
                        for (Map.Entry entry : configJobWithResultMap.entrySet()) {
                            if (((ConfigDeliveryJobResult)entry.getValue()).getCheckPointFileUsed() == null) continue;
                            if (ConfigDeliveryTaskDeviceStatus.SUCCESS == ((ConfigDeliveryJobResult)entry.getValue()).getDeviceDeliveryStatus()) {
                                if (!ConfigDeliveryHelper.isUCS(((ConfigDeliveryJob)entry.getKey()).getIpAddress()).booleanValue()) {
                                    ((ConfigDeliveryJob)entry.getKey()).rollbackChanges();
                                }
                                ConfigDeliveryJobController.this.persistPublishConfigJobChanges(this.task.getInstanceClassId(), ((ConfigDeliveryJob)entry.getKey()).getIpAddress(), ConfigDeliveryTaskDeviceStatus.SUCCESS_ROLLBACK, null, null, -1);
                                continue;
                            }
                            if (ConfigDeliveryTaskDeviceStatus.CANCELED == ((ConfigDeliveryJobResult)entry.getValue()).getDeviceDeliveryStatus()) {
                                log.info((Object)(this.getName() + " Job is cancelled before delivery. So ignoring rollback for " + ((ConfigDeliveryJob)entry.getKey()).getName()));
                                ConfigDeliveryJobController.this.persistPublishConfigJobChanges(this.task.getInstanceClassId(), ((ConfigDeliveryJob)entry.getKey()).getIpAddress(), ConfigDeliveryTaskDeviceStatus.CANCELED, null, null, -1);
                                continue;
                            }
                            if (ConfigDeliveryTaskDeviceStatus.FAILED_ROLLBACK != ((ConfigDeliveryJobResult)entry.getValue()).getDeviceDeliveryStatus()) continue;
                            log.info((Object)(this.getName() + " Already Changes Rolled Back for " + ((ConfigDeliveryJob)entry.getKey()).getName()));
                        }
                    }
                }
                boolean isAnyOfTheJobsCancelled = false;
                boolean isAnyOfTheJobsFailed = false;
                for (ConfigDeliveryJobResult configJobResult : configJobWithResultMap.values()) {
                    if (ConfigDeliveryTaskDeviceStatus.FAILED == configJobResult.getDeviceDeliveryStatus() || ConfigDeliveryTaskDeviceStatus.FAILED_ROLLBACK == configJobResult.getDeviceDeliveryStatus()) {
                        isAnyOfTheJobsFailed = true;
                        continue;
                    }
                    if (ConfigDeliveryTaskDeviceStatus.CANCELED != configJobResult.getDeviceDeliveryStatus()) continue;
                    isAnyOfTheJobsCancelled = true;
                }
                status = isAnyOfTheJobsFailed ? ConfigDeliveryTaskStatus.FAILED : (isAnyOfTheJobsCancelled ? ConfigDeliveryTaskStatus.CANCELED : ConfigDeliveryTaskStatus.SUCCESS);
            }
            catch (Exception e) {
                log.error((Object)(this.getName() + " Config Delivery Failed"), (Throwable)e);
                status = ConfigDeliveryTaskStatus.FAILED;
            }
            log.info((Object)(this.getName() + " Completed with Status:" + status.getName()));
            String logMsg = "";
            logMsg = "Configuration template \"" + ((TemplateConfigDeliveryTask)this.task).getSourceTemplate() + "\"" + " delivered to devices " + deviceNameStr + ": " + status.getKeyword();
            SyslogEntry se = new SyslogEntry(FMServerImpl.getInstance().getCurrentServerInetAddr(), -1L, "DCNM-SAN", LogEventType.OTHER.toString(), this.task.getUserName() != null ? this.task.getUserName() : this.getCurrentUsername(), logMsg, Severity.INFO.getValue(), 0);
            ((EventControllerService)ServiceConfig.findService("Event Controller Service")).publishAccounting(se);
            ConfigDeliveryJobController.this.persistPublishTaskStatusChange(this.task.getInstanceClassId(), status);
            return null;
        }

        private String getCurrentUsername() {
            String token = SecurityHandler.getToken();
            if (token != null) {
                return IdentityManager.getInstance().extractToken(token).getUsername();
            }
            log.error((Object)"Unable to get logged in Username, returning default username Admin!!!!");
            return "admin";
        }

        private String[] getConfigCommands(ConfigDeliveryTaskDeviceDetails details) {
            if (details.getConfigDeliveryTaskRef() instanceof TemplateConfigDeliveryTask) {
                String pContent;
                List rows = TemplateConfigDeliveryTask.getTemplateRows((ConfigDeliveryTaskDeviceDetails)details);
                String contentStr = ((TemplateConfigDeliveryTask)details.getConfigDeliveryTaskRef()).getConfigTemplateRef().getContent().toString();
                Pair result = TemplateFileParser.getInstance().parse(contentStr);
                if (((Template)result.getFirst()).getParametersCollection() == null || ((Template)result.getFirst()).getParametersCollection().size() == 0) {
                    rows = null;
                }
                if ((pContent = TemplateFileParser.getInstance().getPopulatedCommands((Template)result.getFirst(), rows, null, null)) == null) {
                    return new String[0];
                }
                return pContent.split("\n");
            }
            return details.fetchConfigCommandsAsArray();
        }
    }
}

