/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.cfgtemplates.util;

import com.cisco.dcbu.dcm.cfgtemplate.parser.model.Template;
import com.cisco.dcbu.dcm.common.Pair;
import com.cisco.dcbu.dcm.model.cfgtemplate.ConfigTemplate;
import com.cisco.dcbu.dcm.model.cfgtemplate.util.ConfigTemplateModelHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TemplateFileParser {
    private static final Log log = LogFactory.getLog(TemplateFileParser.class);
    public static final String SECTION_DELIMITERS = "##";
    public static final String PROPS_SECTION_TITLE = "##template properties";
    public static final String PARAMS_SECTION_TITLE = "##template variables";
    public static final String CONTENTS_SECTION_TITLE = "##template content";

    public static List<ConfigTemplate> parseTemplateFiles(String templatesDir) {
        if (templatesDir == null) {
            throw new IllegalArgumentException("Given templates directory, " + templatesDir + ", is not a valid directory!");
        }
        return TemplateFileParser.parseTemplateFiles(new File(templatesDir));
    }

    public static List<ConfigTemplate> parseTemplateFiles(File templatesDir) {
        ArrayList<ConfigTemplate> templates = new ArrayList<ConfigTemplate>();
        if (!templatesDir.exists() || !templatesDir.isDirectory()) {
            throw new IllegalArgumentException("Given templates directory, " + templatesDir + ", is not a valid directory!");
        }
        File[] files = templatesDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".template");
            }
        });
        if (files == null || files.length == 0) {
            return templates;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                templates.addAll(TemplateFileParser.parseTemplateFiles(file));
                continue;
            }
            try {
                ConfigTemplate configTemplate = TemplateFileParser.parseTemplateFile(file);
                if (configTemplate == null) continue;
                templates.add(configTemplate);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return templates;
    }

    public static ConfigTemplate parseFullTemplateFile(File templateFile) throws Exception {
        ConfigTemplate template = new ConfigTemplate();
        template.setFileName(templateFile.getName());
        StringBuilder fileContent = new StringBuilder();
        BufferedReader rdr = new BufferedReader(new FileReader(templateFile));
        String line = null;
        while ((line = rdr.readLine()) != null) {
            fileContent.append(line);
            fileContent.append("\n");
        }
        rdr.close();
        Pair result = com.cisco.dcbu.dcm.cfgtemplate.parser.TemplateFileParser.getInstance().parse((InputStream)new FileInputStream(templateFile));
        if (result == null || result.getFirst() == null) {
            return null;
        }
        template.setName(((Template)result.getFirst()).getName().trim());
        template.setDescription(((Template)result.getFirst()).getDescription());
        template.setUserDefined(Boolean.valueOf(((Template)result.getFirst()).isUserDefined()));
        template.setParameterList(new ArrayList(((Template)result.getFirst()).getParameters().keySet()));
        template.setTagsCol(new HashSet<String>(Arrays.asList(((Template)result.getFirst()).getTags())));
        template.setContent(fileContent);
        if (template.getName() == null || !ConfigTemplateModelHelper.isValidTemplateName((String)template.getName())) {
            return null;
        }
        if (template.getDescription() != null && !ConfigTemplateModelHelper.isValidTemplateDescription((String)template.getDescription())) {
            return null;
        }
        if (template.getTagsCol() != null && !ConfigTemplateModelHelper.areValidTemplateTags((Set)template.getTagsCol()).equals("")) {
            return null;
        }
        return template;
    }

    public static ConfigTemplate parseTemplateFile(File templateFile) throws Exception {
        String[] props;
        ConfigTemplate template = new ConfigTemplate();
        template.setFileName(templateFile.getName());
        StringBuffer fileContent = new StringBuffer();
        BufferedReader rdr = new BufferedReader(new FileReader(templateFile));
        String line = null;
        while ((line = rdr.readLine()) != null) {
            fileContent.append(line);
            fileContent.append("\n");
        }
        rdr.close();
        int idxOfSectionStart = fileContent.indexOf(PROPS_SECTION_TITLE);
        int idxOfSectionEnd = -1;
        if (idxOfSectionStart != -1) {
            idxOfSectionEnd = fileContent.indexOf(SECTION_DELIMITERS, idxOfSectionStart + 1);
            String propsContent = fileContent.substring(idxOfSectionStart + PROPS_SECTION_TITLE.length(), idxOfSectionEnd);
            props = propsContent.split(";");
            String userDefined = null;
            String tagStr = "";
            for (String prop : props) {
                if (prop.trim().startsWith("name")) {
                    template.setName(prop.substring(prop.indexOf("=") + 1).trim());
                    continue;
                }
                if (prop.trim().startsWith("description")) {
                    template.setDescription(prop.substring(prop.indexOf("=") + 1).trim());
                    continue;
                }
                if (prop.trim().startsWith("userDefined")) {
                    userDefined = prop.substring(prop.indexOf("=") + 1).trim();
                    continue;
                }
                if (!prop.trim().startsWith("tags")) continue;
                tagStr = prop.substring(prop.indexOf("=") + 1).trim();
                String[] tagArr = tagStr.split(",");
                HashSet<String> tags = new HashSet<String>();
                for (String _tag : Arrays.asList(tagArr)) {
                    tags.add(_tag.trim());
                }
                template.setTagsCol(tags);
            }
            if (userDefined != null && userDefined.equals("false")) {
                template.setUserDefined(Boolean.FALSE);
            }
        }
        if ((idxOfSectionStart = fileContent.indexOf(PARAMS_SECTION_TITLE)) != -1) {
            idxOfSectionEnd = fileContent.indexOf(SECTION_DELIMITERS, idxOfSectionStart + 1);
            String paramsContent = fileContent.substring(idxOfSectionStart + PARAMS_SECTION_TITLE.length(), idxOfSectionEnd);
            props = paramsContent.split(";");
            ArrayList<String> params = new ArrayList<String>(props.length);
            for (String prop : props) {
                if ((prop = prop.trim()).length() <= 0 || params.contains(prop)) continue;
                params.add(prop);
            }
            template.setParameterList(params);
        }
        if ((idxOfSectionStart = fileContent.indexOf(CONTENTS_SECTION_TITLE)) != -1) {
            idxOfSectionEnd = fileContent.indexOf(SECTION_DELIMITERS, idxOfSectionStart + 1);
            String content = fileContent.substring(idxOfSectionStart + CONTENTS_SECTION_TITLE.length(), idxOfSectionEnd);
            template.setContent(new StringBuilder(content.trim()));
            if (template.getParameterList() == null) {
                ArrayList<String> params = new ArrayList<String>();
                idxOfSectionStart = content.indexOf("$$");
                while (idxOfSectionStart != -1 && (idxOfSectionEnd = content.indexOf("$$", idxOfSectionStart + 1)) != -1) {
                    String paramName = content.substring(idxOfSectionStart + 2, idxOfSectionEnd);
                    if (!params.contains(paramName)) {
                        params.add(paramName);
                    }
                    idxOfSectionStart = content.indexOf("$$", idxOfSectionEnd + 1);
                }
                template.setParameterList(params);
            }
        }
        template.setContent(new StringBuilder(fileContent.toString()));
        return template;
    }

    public static Collection<? extends String> getTemplateContents(File templatesDir, List<String> fileNames) {
        ArrayList<String> templateContent = new ArrayList<String>();
        if (!templatesDir.exists() || !templatesDir.isDirectory()) {
            throw new IllegalArgumentException("Given templates directory, " + templatesDir + ", is not a valid directory!");
        }
        String templateFolder = templatesDir.getAbsolutePath() + File.separator;
        for (String fileName : fileNames) {
            if (fileName == null) {
                templateContent.add(null);
                continue;
            }
            File configTemplateFile = new File(templateFolder + fileName);
            if (configTemplateFile.exists()) {
                ConfigTemplate configTemplate = null;
                try {
                    configTemplate = TemplateFileParser.parseTemplateFile(configTemplateFile);
                    templateContent.add(configTemplate.getContent().toString());
                }
                catch (Exception e) {
                    templateContent.add(null);
                }
                continue;
            }
            templateContent.add(null);
        }
        return templateContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void modifyTemplatesContent(File templatesDir, List<ConfigTemplate> templateCol) {
        if (!templatesDir.exists() || !templatesDir.isDirectory()) {
            throw new IllegalArgumentException("Given templates directory, " + templatesDir + ", is not a valid directory!");
        }
        String templateFolder = templatesDir.getAbsolutePath() + File.separator;
        for (ConfigTemplate configTemplate : templateCol) {
            File configTemplateFile = new File(templateFolder + configTemplate.getFileName());
            if (!configTemplateFile.exists()) continue;
            StringBuffer fileContent = new StringBuffer();
            Writer output = null;
            if (configTemplate.getContent() != null) {
                fileContent.append((CharSequence)configTemplate.getContent());
            } else {
                BufferedReader rdr = null;
                try {
                    rdr = new BufferedReader(new FileReader(configTemplateFile));
                    String line = null;
                    block27: while ((line = rdr.readLine()) != null) {
                        if (line.contains(PROPS_SECTION_TITLE)) {
                            fileContent.append(line);
                            fileContent.append("\n");
                            boolean descriptionFound = false;
                            boolean tagsFound = false;
                            while ((line = rdr.readLine()) != null) {
                                if (line.contains("description ")) {
                                    descriptionFound = true;
                                    if (configTemplate.getDescription() == null) continue;
                                    fileContent.append("description = " + configTemplate.getDescription() + ";");
                                    fileContent.append("\n");
                                    continue;
                                }
                                if (line.contains("tags ")) {
                                    tagsFound = true;
                                    if (configTemplate.getTagsCol() == null || configTemplate.getTagsCol().size() <= 0) continue;
                                    fileContent.append(TemplateFileParser.getTagStrFromSet(configTemplate.getTagsCol()));
                                    fileContent.append("\n");
                                    continue;
                                }
                                if (line.contains(SECTION_DELIMITERS)) {
                                    if (!descriptionFound && configTemplate.getDescription() != null) {
                                        fileContent.append("description = " + configTemplate.getDescription() + ";");
                                        fileContent.append("\n");
                                    }
                                    if (!tagsFound && configTemplate.getTagsCol() != null && configTemplate.getTagsCol().size() > 0) {
                                        fileContent.append(TemplateFileParser.getTagStrFromSet(configTemplate.getTagsCol()));
                                        fileContent.append("\n");
                                    }
                                }
                                fileContent.append(line);
                                fileContent.append("\n");
                                if (!line.contains(SECTION_DELIMITERS)) continue;
                                continue block27;
                            }
                            continue;
                        }
                        if (line.contains(CONTENTS_SECTION_TITLE)) {
                            fileContent.append(line);
                            while ((line = rdr.readLine()) != null) {
                                fileContent.append(line);
                                fileContent.append("\n");
                                if (!line.equals(SECTION_DELIMITERS)) continue;
                                continue block27;
                            }
                            continue;
                        }
                        fileContent.append(line);
                        if (line.equals(SECTION_DELIMITERS)) continue;
                        fileContent.append("\n");
                    }
                }
                catch (FileNotFoundException e) {
                    log.error((Object)e);
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
                finally {
                    try {
                        if (rdr != null) {
                            rdr.close();
                        }
                    }
                    catch (IOException e) {
                        log.error((Object)e);
                    }
                }
            }
            try {
                output = new BufferedWriter(new FileWriter(configTemplateFile));
                output.write(fileContent.toString());
            }
            catch (IOException e) {
                log.error((Object)e);
            }
            finally {
                if (output == null) continue;
                try {
                    output.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        }
    }

    private static String getTagStrFromSet(Set<String> tagsCol) {
        String tagStr = null;
        if (tagsCol.size() > 0) {
            int tagIdx = 0;
            tagStr = "tags = ";
            for (String tag : tagsCol) {
                tagStr = tagIdx < tagsCol.size() - 1 ? tagStr.concat(tag + ",") : tagStr.concat(tag);
                ++tagIdx;
            }
            tagStr = tagStr.concat(";");
        }
        return tagStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTemplates(File templatesDir, List<ConfigTemplate> templateCol) {
        if (!templatesDir.exists() || !templatesDir.isDirectory()) {
            throw new IllegalArgumentException("Given templates directory, " + templatesDir + ", is not a valid directory!");
        }
        String templateFolder = templatesDir.getAbsolutePath() + File.separator;
        for (ConfigTemplate configTemplate : templateCol) {
            String fileName = configTemplate.getName();
            fileName = fileName.replaceAll("\\b\\s{2,}\\b", " ");
            fileName = fileName.replaceAll("[\\s-]", "_");
            configTemplate.setFileName(fileName + ".template");
            File configTemplateFile = new File(templateFolder + configTemplate.getFileName());
            if (configTemplateFile.exists()) continue;
            StringBuffer fileContent = new StringBuffer();
            fileContent.append((CharSequence)configTemplate.getContent());
            Writer output = null;
            try {
                output = new BufferedWriter(new FileWriter(configTemplateFile));
                output.write(fileContent.toString());
            }
            catch (IOException e) {
                log.error((Object)e);
            }
            finally {
                if (output == null) continue;
                try {
                    output.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        }
    }
}

